setClass(
         Class = "NG_Viztk2d_slice",
         representation = representation(
           window = "numeric"
           ),
         contains = "NG_Viztk2d"
         )



ng_2d_slice <- function(data, graph, window = 0.2, images = NULL, glyphs = NULL) {
  
  if(!is(data,"NG_data")) {
    stop("[ng_2d_slice] data argument is not an NG_data object.")
  }
  if(!is(graph,"NG_graph")) {
    stop("[ng_2d_slice] graph argument is not an NG_graph object.")
  }
  if(!is.null(images)) {
    if(!is(images,"NG_image")) {
      stop("[ng_2d_slice] image argument is not an NG_image object.")
    }
  }
  if(!(all(glyphs %in% shortnames(data)) || all(glyphs %in% names(data)))) {
    stop("[ng_2d_slice] glyph argument contains names which are not present in the data.")
  }
  
  ## check if variable- and node names of graph and data match
  varNames <-	vizVarNames(graph,data)
  
  if(is.null(images)) {
    ids <- NULL	
  }else{
    if(is(images,"NG_image")) {
      ids <- images@ids			
    }else {
      stop('[ng_2d_slice] image argument not of class NG_image')
    }
  }
  
  ## Glyph Variable order
  if(!is.null(glyphs)) {
    if(all(glyphs %in% names(data@data))) {	
      glyphVarOrder <- match(glyphs, names(data@data))
    } else if(all(glyphs %in% data@shortnames)) {
      glyphVarOrder <- match(glyphs, data@shortnames)
    } else {
      stop('[ng_2d_slice] argument glyph does not match with the data.')
    }
  }else {
    glyphVarOrder <- NULL
  }
  
  
  return( new("NG_Viztk2d_slice",
              graph = graph@name,
              data = data@name,
              from = nodes(graph@graph)[1],
              to = "",
              varList = varNames,
              mat = matrix(rep(0,length(varNames)*2),ncol = 2),
              transitionKind = 0,
              viz_name = "Slicing",
              glyphVarOrder = glyphVarOrder,
              imgIds = ids,
              scaled = TRUE,
              window = window
              ))
}



## Initialize Plots
setMethod(
          f = "initializeViz",
          signature = "NG_Viztk2d_slice",
          definition = function(viz,ngEnv){
            
            viz@toplevel <- tktoplevel()
            
            if(length(viz@geometry)>0) {
              tkwm.geometry(viz@toplevel,viz@geometry)
            }else {
              if(exists('tk2dDefaultSize',envir = ngEnv)){
                tkwm.geometry(viz@toplevel,ngEnv$tk2dDefaultSize)
              }
            }

            
            p <- ngEnv$bulletState$percentage
            state <- ngEnv$bulletState
            graph <- ngEnv$graph

            ifrom <- match(unlist(strsplit(state$from,split = graph@sep, fixed = TRUE)),viz@varList)
            
            if(state$to == "") { ## no direction of bullet
              x <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
              y <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
              
              tcl('set', paste("ng_data(\"",ngEnv$ng_LinkedInstance,".",viz@data,".deactivated\")", sep = ''), rep(0, length(x)))             
            } else {
              ito <- match(unlist(strsplit(state$to,split = graph@sep, fixed = TRUE)),viz@varList)
              if(ifrom[1] %in% ito) { ## share first variable
                z <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
                x <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
                if(ifrom[1] == ito[1]) {
                  y <- ngEnv$scaledData[[viz@data]][,ito[2]]
                } else {
                  y <- ngEnv$scaledData[[viz@data]][,ito[1]]
                }
              } else { ## assume share second variable
                if(!(ifrom[2] %in% ito)) {
                  cat("Warning, not sure what to slice on!\n")
                }
                z <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
                x <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
                if(ifrom[2] == ito[1]) {
                  y <- ngEnv$scaledData[[viz@data]][,ito[2]]
                } else {
                  y <- ngEnv$scaledData[[viz@data]][,ito[1]]
                }
              }

              zscale <- (z-min(z))/diff(range(z))
              sel <- (zscale<p-viz@window) | (zscale>p+viz@window)
              tcl('set', paste("ng_data(\"",ngEnv$ng_LinkedInstance,".",viz@data,".deactivated\")", sep = ''), as.numeric(sel))           
            }

            tcl('set', paste("ng_data(\"",ngEnv$ng_instance,".",viz@data,".xcoord\")", sep = ''), x)
            tcl('set', paste("ng_data(\"",ngEnv$ng_instance,".",viz@data,".ycoord\")", sep = ''), y)                         
            tcl('tk_2d_display', viz@toplevel, ngEnv$ng_instance, ngEnv$ng_LinkedInstance, viz@data, viz@viz_name, !is.null(viz@imgIds), !is.null(viz@glyphVarOrder), paste('Session ', ngEnv$ng_instance,', data: ',viz@data,", graph: ",viz@graph,sep=""))
            
print("Initialize DONE")            
            return(viz)
          })


setMethod(
          f = "updateViz",
          signature = "NG_Viztk2d_slice",
          definition = function(viz,ngEnv){                                  
            p <- ngEnv$bulletState$percentage
            state <- ngEnv$bulletState
            graph <- ngEnv$graph

            ifrom <- match(unlist(strsplit(state$from,split = graph@sep, fixed = TRUE)),viz@varList)
            if(state$to == "") { ## no direction of bullet
              x <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
              y <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
              
              tcl('set', paste("ng_data(\"",ngEnv$ng_LinkedInstance,".",viz@data,".deactivated\")", sep = ''), rep(0, length(x)))             
            } else {
              ito <- match(unlist(strsplit(state$to,split = graph@sep, fixed = TRUE)),viz@varList)
              if(ifrom[1] %in% ito) { ## share first variable
                z <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
                x <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
                if(ifrom[1] == ito[1]) {
                  y <- ngEnv$scaledData[[viz@data]][,ito[2]]
                } else {
                  y <- ngEnv$scaledData[[viz@data]][,ito[1]]
                }
              } else { ## assume share second variable
                if(!(ifrom[2] %in% ito)) {
                  cat("Warning, not sure what to slice on!\n")
                }
                z <- ngEnv$scaledData[[viz@data]][,ifrom[2]]
                x <- ngEnv$scaledData[[viz@data]][,ifrom[1]]
                if(ifrom[2] == ito[1]) {
                  y <- ngEnv$scaledData[[viz@data]][,ito[2]]
                } else {
                  y <- ngEnv$scaledData[[viz@data]][,ito[1]]
                }
              }
              zscale <- (z-min(z))/diff(range(z))
              sel <- (zscale<p-viz@window) | (zscale>p+viz@window)
              tcl('set', paste("ng_data(\"",ngEnv$ng_LinkedInstance,".",viz@data,".deactivated\")", sep = ''), as.numeric(sel))           
              
            }
            tcl('set', paste("ng_data(\"",ngEnv$ng_instance,".",viz@data,".xcoord\")", sep = ''), x)
            tcl('set', paste("ng_data(\"",ngEnv$ng_instance,".",viz@data,".ycoord\")", sep = ''), y)                         
            tcl('update_displays',viz@toplevel, ngEnv$ng_instance, viz@data, viz@viz_name)


            return(viz)
          })


setMethod(
          f = "closeViz",
          signature = "NG_Viztk2d_slice",
          definition = function(viz,ngEnv){
            ## first save window size
            viz@geometry <- .tcl2str(tkwm.geometry(viz@toplevel))
            ngEnv$tk2dDefaultSize <- viz@geometry 
            
            tkdestroy(viz@toplevel)
            
            t.array <- paste("ng_windowManager(\"",ngEnv$ng_LinkedInstance,".",viz@data,".ttID\")", sep = '')
            i <- .tcl2num(.Tcl(paste('lsearch -exact $',t.array, ' ', viz@toplevel, sep = '')))
            
            if(i != -1) {
              .Tcl(paste('set ', t.array, ' [lreplace $',t.array,' ',i,' ',i,']', sep=''))
            }else {
              warning("[closeViz] could not find toplevel window!")
            }
            viz@toplevel <- NULL
            
            return(viz)
          })
