(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   3136251,     162397]*)
(*NotebookOutlinePosition[   3137080,     162426]*)
(*  CellTagsIndexPosition[   3137036,     162422]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(<< cellerator.m;\)\)], "Input"],

Cell[BoxData[
    \("Cellerator\[Trademark] 1.4.10 (15-Sept-2004) loaded 13-Dec-2004 10:41 \
using Mathematica Version 4.2 for Microsoft Windows (June 5, 2002)"\)], \
"Print"]
}, Open  ]],

Cell[BoxData[{
    \(\(<< Graphics`Graphics`;\)\), "\[IndentingNewLine]", 
    \(Off[InterpolatingFunction::dmval]\)}], "Input"],

Cell[CellGroupData[{

Cell["LNA", "Section"],

Cell[TextData[{
  StyleBox["See:",
    FontVariations->{"Underline"->True}],
  " van Kampen, NG (1976) The expansion of the Master equation. ",
  StyleBox["Advances in Chemical Physics",
    FontSlant->"Italic"],
  " ",
  StyleBox["34",
    FontWeight->"Bold"],
  ", 245-308.\n"
}], "Text"],

Cell[BoxData[{\(<< 
        LinearAlgebra`MatrixManipulation`;\), "\[IndentingNewLine]", 
    RowBox[{\(<< Geometry`Rotations`;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{\(LNA[list_, \ opts___?OptionQ]\), ":=", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"Module", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
              "tMax", ",", "SizeW", ",", "n", ",", "P", ",", "Q", ",", 
                "indReactants", ",", "indLink", ",", 
                StyleBox["depReactants",
                  "MR"], 
                StyleBox[",",
                  "MR"], "depLink", ",", "Rmat", ",", "indNot", ",", "depNot",
                 ",", "depsubrhs", ",", "depsub", ",", "newNu", ",", "Mr", 
                ",", "ssoln", ",", "Amat", ",", "Bmat", ",", "AA", ",", "BB", 
                ",", "sim", ",", "funSub", ",", "lhsCorr", ",", "CorrVar", 
                ",", "lhsCorrDer", ",", "CorrDe", ",", "CorrBC", ",", 
                "CorrEqs", ",", "CorrSoln", ",", "StoVar", ",", "StoFun", ",",
                 "ReSults", ",", "Rn", ",", "Rr", ",", 
                StyleBox["myRand",
                  FontWeight->"Plain"], 
                StyleBox[",",
                  FontWeight->"Plain"], "Eitab", ",", "SState", ",", 
                "SStateVal", ",", "ASS", ",", "BSS", ",", "eX", ",", "reX", 
                ",", "var1", ",", "vareq", ",", "vsoln", ",", "CSteady"}], 
              "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            
            RowBox[{\(Off[Transpose::nmtx]\), ";", 
              "\[IndentingNewLine]", \(Off[Solve::ifun]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Dbg\  = \ \(debug /. {opts}\) /. \
{debug \[Rule] False}\), ";", 
              "\[IndentingNewLine]", \(SizeW\  = \ \(sizeW /. {opts}\) /. \
{sizeW \[Rule] 1}\), ";", 
              "\[IndentingNewLine]", \(tMax\  = \ \(timeSpan /. {opts}\) /. \
{timeSpan \[Rule] 200}\), ";", 
              "\[IndentingNewLine]", \(ics\  = \ 
                initialConditions /. {opts}\), ";", 
              "\[IndentingNewLine]", \(ReaRates\  = \ rates /. {opts}\), ";", 
              "\[IndentingNewLine]", \(SSim\  = \ \(stochasticSimulation /. \
{opts}\) /. {stochasticSimulation \[Rule] False}\), ";", 
              "\[IndentingNewLine]", \(maximumSteps\  = \ \(MaxSteps /. \
{opts}\) /. {MaxSteps \[Rule] 1000000}\), ";", 
              "\[IndentingNewLine]", \(SteadyCorr\  = \ \(SteadyStateMatrix /. \
{opts}\) /. {SteadyStateMatrix \[Rule] False}\), ";", 
              "\[IndentingNewLine]", \(LimCyc = \(LimitCycle /. {opts}\) /. \
{LimitCycle \[Rule] False}\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(If[
                And[SteadyCorr, 
                  LimCyc], \[IndentingNewLine]Print["\<SteadyStateMatrix and \
LimitCycle cannot both be True\>", "\<\n Calculation will be aborted.\>"]; \
\[IndentingNewLine]Abort[];\[IndentingNewLine]]\), ";", "\[IndentingNewLine]",
               "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ 
                  Stochastic\ simulation\ algorithm\ written\ for\ \
Mathematica\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  based\ upon\ stochCellar . 
                        nb\ available\ from\ \(\(http\)\(:\)\) // 
                    www . cellerator . info\ \ \ *) \),
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  with\ modifications\ to\ the\ original\ code\  - \ 
                    All\ errors\ are\ my\ own\ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  The\ Linear\ Noise\ Approximation\ written\ by\ Matt\ Scott\
\ in\ December\ 2004\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              StyleBox[\( (*\ Basic\ functions\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              "\[IndentingNewLine]", \(basicReactions::usage = \
"\<basicReactions[x] breaks down x into its basic mass-action reactions. x \
must be a DTGreaction (see DTGreactionQ).\>"\), ";", 
              "\[IndentingNewLine]", \(DTGreactionQ::usage = \
"\<DTGreactionQ[x] returns true if x is a valid mass-action reaction, and \
false otherwise\>"\), ";", 
              "\[IndentingNewLine]", \(getReactants::usage = \
"\<getReactants[{x\[ShortRightArrow]y,k}] returns a list of the unique \
reactants and the number of times they occur in x in the form \
{{x1,n1},{x2,n2},...}; getReactants[{a+c+a\[ShortRightArrow]b,k}] returns \
{{a,2},{c,1}}\>"\), ";", 
              "\[IndentingNewLine]", \(gTauMu::usage = "\<gTauMu[a] returns \
the values of tau and mu as per equations (21) of Gillespie(1977) given a \
list of values of {a1,a2, ..., an}\>"\), ";", 
              "\[IndentingNewLine]", \(initG::usage = "\<initG[options] \
initializes the Gillespie simulations. Options:\nseed->integer seed for \
random number generator\>"\), ";", 
              "\[IndentingNewLine]", \(k2c::usage = \
"\<k2c[{reaction,rates},Volume] calculates the stochastic rate constant c \
from the deterministic rate constant k\>"\), ";", 
              "\[IndentingNewLine]", \(seed::usage = "\<seed is an option for \
initG. If a seed is specified, the same sequence of random numbers will be \
generated using Random[].\>"\), ";", 
              "\[IndentingNewLine]", \(spreadSheet2Lists::usage = \
"\<spreadSheet2Lists[table] returns a list {set1, set2, ...} where \
seti={{t0,yi0},{t1,yi1},...,{tn,yin}} assuming table is \
{{t0,t1,...,tn},{y01,y02,...,y0n},{y11,y11,...,y1n},...}\>"\), ";", 
              "\[IndentingNewLine]", \(xlateDTG::usage = \
"\<xlateDTG[{reaction, rates}]\n\
xlateDTG[{{reaction1,rates1},{reaction2,rates2},...}]\nxlateDTG returns a \
list {{r1,k1},{r2,k2},...} where ri is a basic mass action reaction adn ki is \
the rate constant for the reaction. The reactions are any set of valid DTG \
reactions and the rates are any leading subset of rate constants for the \
reactions (same as interpret). \>"\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(StochMat::usage = \
"\<StochMat[{reaction_list}] StochMat[{reaction_list}] returns the reduced \
stoichiometry matrix, the linearly dependent stoichiometries,the link matrix \
and the unreduced stoichiometry matrix as well.\>"\), ";", 
              "\[IndentingNewLine]", \(ReacMat::usage = \
"\<ReacMat[{reaction_list}] returns the reaction and reactant names \
corresponding to the stoichiometry matrix calculated by StochMat[].\>"\), ";",
               "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(basicReactions[
                  x__ \[ShortRightArrow] y__] := \ {x \[ShortRightArrow] y}\),
               ";", "\[IndentingNewLine]", \(basicReactions[
                  x__ \[RightArrowLeftArrow] y__] := {x \[ShortRightArrow] y, 
                  y \[ShortRightArrow] x}\), ";", 
              "\[IndentingNewLine]", \(basicReactions[\(x_ \
\[RightArrowLeftArrow] y_\)\&z_] := \ 
                Module[{xz, r}, \[IndentingNewLine]xz = 
                    intermediateCompoundName[x, 
                      z]; \[IndentingNewLine]r = {x + z \[ShortRightArrow] 
                        xz, \ xz \[ShortRightArrow] x + z, \ 
                      xz + y + z}; \[IndentingNewLine]Return[
                    r];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(basicReactions[\(x_ \
\[RightArrowLeftArrow] y_\)\+zr_\%zf_] := \ 
                Module[{br1, \ br2}, \[IndentingNewLine]br1 = 
                    basicReactions[\(x \[RightArrowLeftArrow] y\)\&zf]; \
\[IndentingNewLine]br2 = 
                    basicReactions[\(y \[RightArrowLeftArrow] x\)\&zr]; \
\[IndentingNewLine]Return[Join[br1, br2]];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(DTGreactionQ[
                  x__ \[ShortRightArrow] y__] := \ True\), ";", 
              "\[IndentingNewLine]", \(DTGreactionQ[
                  x__ \[RightArrowLeftArrow] y__] := \ True\), ";", 
              "\[IndentingNewLine]", \(DTGreactionQ[\(x_ \
\[RightArrowLeftArrow] y_\)\&z_] := \ True\), ";", 
              "\[IndentingNewLine]", \(DTGreactionQ[\(x_ \
\[RightArrowLeftArrow] y_\)\+zr_\%zf_] := \ True\), ";", 
              "\[IndentingNewLine]", \(DTGreactionQ[x___] := \ False\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(xlateDTG[
                  circuit_?isAPartialRateList, \ opt___?OptionQ] := \ 
                Module[{ckt}, \[IndentingNewLine]ckt = \ 
                    Map[xlateDTG[#, \ opt] &, \ 
                      circuit]; \[IndentingNewLine]ckt\  = \ 
                    Apply[Join, ckt]; \[IndentingNewLine]Return[
                    ckt];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(xlateDTG[{x_?DTGreactionQ, k___}, 
                  opt___?OptionQ] := \ 
                Module[{r, rates, reaction, basic}, \[IndentingNewLine]r = 
                    validateRateConstants[{x, k}, 
                      opt]; \[IndentingNewLine]reaction\  = \ 
                    First[r]; \[IndentingNewLine]rates = 
                    Rest[r]; \[IndentingNewLine]basic\  = \ 
                    basicReactions[
                      reaction]; \[IndentingNewLine]r\  = \ {basic, \ 
                      rates}; \[IndentingNewLine]r\  = \ 
                    Transpose[r]; \[IndentingNewLine]Return[
                    r];\[IndentingNewLine]\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Unprotect[initG, \ seed]\), ";", 
              "\[IndentingNewLine]", 
              RowBox[{\(initG[opt___?OptionQ]\), ":=", " ", 
                RowBox[{"Module", "[", 
                  
                  RowBox[{\({randomSeed, myRand}\), ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                      RowBox[{
                        StyleBox["myRand",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["=",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], \(Random[
                          Integer, {314159, 31415927}]\)}], ";", 
                      "\[IndentingNewLine]", 
                      RowBox[{"randomSeed", " ", "=", " ", 
                        RowBox[{\(seed /. {opt}\), "/.", 
                          RowBox[{"{", 
                            RowBox[{"seed", "\[Rule]", 
                              StyleBox["myRand",
                                FontWeight->"Plain"]}], "}"}]}]}], ";", 
                      "  ", \(SeedRandom[randomSeed]\), ";"}]}], " ", 
                  "\[IndentingNewLine]", "]"}]}], ";", 
              "\[IndentingNewLine]", \(Protect[initG, seed]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Unprotect[gTauMu]\), ";", 
              "\[IndentingNewLine]", 
              RowBox[{\(gTauMu[a_?ListQ]\), ":=", " ", 
                RowBox[{"Module", "[", 
                  
                  RowBox[{\({r1 = 0, r2 = 0, \ a0, r2a0, tau, \ sum = 0, 
                      mu = 1, arest, anext, done = False, n}\), ",", 
                    "\[IndentingNewLine]", 
                    
                    StyleBox[\( (*\ 
                        Generate\ random\ numbers\ but\ make\ sure\ they\ are\
\ not\ zero\ *) \),
                      FontWeight->"Plain"], 
                    StyleBox[" ",
                      FontWeight->"Plain"], "\[IndentingNewLine]", 
                    
                    RowBox[{\(While[r1 \[Equal] 0, \ 
                        r1 = Random[Real, {0, 1}]]\), ";", 
                      "\[IndentingNewLine]", \(While[r2 \[Equal] 0, 
                        r2 = Random[Real, \ {0, 1}]]\), ";", 
                      "\[IndentingNewLine]", \(a0 = Apply[Plus, \ a]\), ";", 
                      "\[IndentingNewLine]", \(If[
                        a0 \[Equal] 
                          0, \ \[IndentingNewLine]Print["\<>>gTauMu error: \
a0=0\>"]; Abort[];]\), ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                      StyleBox[\( (*\ equation\ 21  a\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      StyleBox["\[IndentingNewLine]",
                        
                        FontWeight->"Plain"], \(tau\  = \ \((1/a0)\) 
                          Log[1/r1]\), ";", 
                      "\[IndentingNewLine]", \(r2a0 = r2*a0\), ";", 
                      "\[IndentingNewLine]", "\[IndentingNewLine]", 
                      StyleBox[\( (*\ equation\ 21  b\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], \(n = Length[a]\), ";", 
                      "\[IndentingNewLine]", \(While[\((\((\ 
                              mu\  \[LessEqual] \ 
                                n\ )\) \[And] \ \ \((\[Not] done)\))\), \
\[IndentingNewLine]anext\  = a[\([mu]\)]; \ \[IndentingNewLine]sum += \ 
                          anext; \[IndentingNewLine]If[
                          sum \[GreaterEqual] \ r2a0, \ 
                          done = \ True, \ \(mu++\)];\[IndentingNewLine]]\), 
                      ";", "\[IndentingNewLine]", \(Return[{tau, mu}]\)}]}], 
                  "\[IndentingNewLine]", "]"}]}], ";", 
              "\[IndentingNewLine]", \(Protect[gTauMu]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(getReactants[{x_ \[ShortRightArrow] 
                      y_, k_}, opt___?OptionQ] := \ 
                Module[{r, n, myTimes, u, v, \ whichSide, \ 
                    var}, \[IndentingNewLine]\[IndentingNewLine]whichSide\  = 
                    ToString[\ \(side /. {opt}\) /. {side \[Rule] \ \
"\<Left\>"}]; \[IndentingNewLine]myTimes[n_?IntegerQ, u_] := \ {u, 
                      n}; \[IndentingNewLine]myTimes[u_, 
                      n_?IntegerQ] := \ {u, 
                      n}; \[IndentingNewLine]\[IndentingNewLine]myPlus[
                      u_?AtomQ] := \ {u, 
                      1}; \[IndentingNewLine]myPlus[{}] := \ {}; \
\[IndentingNewLine]myPlus[] := \ {}; \[IndentingNewLine]myPlus[u_?ListQ, 
                      v___] := \ {u, myPlus[v]}; \[IndentingNewLine]myPlus[
                      u_?AtomQ, v___] := \ {{u, 1}, 
                      myPlus[v]}; \[IndentingNewLine]\[IndentingNewLine]If[
                    whichSide \[Equal] "\<Right\>", \ \[IndentingNewLine]\(r \
= y /. {Times \[Rule] \ myTimes, 
                            Plus \[Rule] \ 
                              myPlus};\)\[IndentingNewLine], \
\[IndentingNewLine]\(r = 
                        x /. {Times \[Rule] \ myTimes, 
                            Plus \[Rule] \ 
                              myPlus};\)\[IndentingNewLine]]; \
\[IndentingNewLine]\[IndentingNewLine]r = 
                    r /. {\[EmptySet] \[Rule] {}}; \[IndentingNewLine]If[
                    AtomQ[r], \ 
                    r = {r, 1}]; \[IndentingNewLine]\[IndentingNewLine]r = 
                    Partition[Flatten[r], 
                      2]; \[IndentingNewLine]\[IndentingNewLine]Return[
                    r];\[IndentingNewLine]]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(k2c[{n_\ x_ \[ShortRightArrow] z_, 
                    k_}, V_] := \ 
                Module[{}, \(n!\)*k2c[{x \[ShortRightArrow] z, k}, V]]\), ";",
               "\[IndentingNewLine]", \(k2c[{n_\ x_\  + \ 
                        y___ \[ShortRightArrow] z_, \ k_}, V_] := \ 
                Module[{reactants}, \[IndentingNewLine]\(n!\)*
                    k2c[{x + y \[ShortRightArrow] z, k}, 
                      V]\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(k2c[{x_ \[ShortRightArrow] z_, k_}, 
                  V_] := \ k/V\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(spreadSheet2Lists[n_] := \ 
                Module[{columns, firstColumn, \ 
                    datasets}, \[IndentingNewLine]columns\  = 
                    Drop[n, 1]; \[IndentingNewLine]columns\  = \ 
                    Transpose[columns]; \[IndentingNewLine]firstColumn = \ 
                    First[columns]; \[IndentingNewLine]columns = 
                    Rest[columns]; \[IndentingNewLine]datasets\  = \ 
                    Map[{firstColumn, #} &, \ 
                      columns]; \[IndentingNewLine]datasets\  = 
                    Map[\ Transpose, datasets]; \[IndentingNewLine]Return[
                    datasets];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ 
                  StochMat\ eliminates\ conserved\ species\ from\ the\ \
stoichiometry\ matrix\ \ \ \ *) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ returning\ the\ reduced\ matrix, \ 
                  the\ left\ over, \ 
                  and\ the\ link\ matrix\ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  See : \ 
                    Sauro\ and\ Ingalls\ \*"\"\<Conservation Analysis in \
Biochemical Networks: \>"*) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  Computational\ Issues\ for\ Software\ Writers \*"\"\< in \
Biophysical Chemistry,   \>"*) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ 
                  v  .109\ \((2004)\)\ pp  .1 - 
                    15. \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], "\[IndentingNewLine]", 
              RowBox[{\(StochMat[list1_]\), ":=", " ", 
                RowBox[{"Module", "[", 
                  
                  RowBox[{\({r, reactantNames, productNames, \ N, M, 
                      reactants, products, smat, S, Sr, Sn, eL, Gam}\), ",", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{\(r\  = \ xlateDTG[list1]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactants\  = 
                        Map[getReactants, r]\), ";", 
                      "\[IndentingNewLine]", \(products\  = \ 
                        Map[getReactants[#, side \[Rule] \ "\<Right\>"] &, \ 
                          r]\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Union[Flatten[reactants]]\), ";", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Complement[reactantNames, 
                          Select[reactantNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(productNames\  = \ 
                        Union[Flatten[products]]\), ";", 
                      "\[IndentingNewLine]", \(productNames = 
                        Complement[productNames, 
                          Select[productNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(N = Length[reactantNames]\), 
                      ";", "                    ", 
                      StyleBox[\( (*\ rows\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      "\[IndentingNewLine]", \(M = Length[reactants]\), ";", 
                      "                             ", 
                      StyleBox[\( (*\ columns\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(smat = 
                        Table[0, {i, 1, N}, {j, 1, M}]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(For[k = 1, k \[LessEqual] M, 
                        For[j = 1, j \[LessEqual] Length[reactants[\([k]\)]], 
                          rowk = \(Flatten[
                                Position[reactantNames, 
                                  reactants[\([k, j, 1]\)]]]\)[\([1]\)]; 
                          smat = 
                            ReplacePart[smat, 
                              smat[\([rowk, k]\)] - 
                                reactants[\([k, j, 2]\)], {rowk, 
                                k}]; \(j++\)]; 
                        For[j = 1, j \[LessEqual] Length[products[\([k]\)]], 
                          rowk = \(Flatten[
                                Position[reactantNames, 
                                  products[\([k, j, 1]\)]]]\)[\([1]\)]; 
                          smat = 
                            ReplacePart[smat, 
                              smat[\([rowk, k]\)] + 
                                products[\([k, j, 2]\)], {rowk, 
                                k}]; \(j++\)]; \(k++\)]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(S = Evaluate[smat]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(For[j = 2; Sr = {S[\([1]\)]}; 
                        Sn = {}; k = 2, j \[LessEqual] Length[S], 
                        If[Last[Dimensions[Append[Sr, S[\([j]\)]]]] - 
                              Length[NullSpace[Append[Sr, S[\([j]\)]]]] < k, 
                          Sn = Append[Sn, S[\([j]\)]], 
                          Sr = Append[Sr, S[\([j]\)]]; \(k++\)]; \(j++\)]\), 
                      ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(eL = 
                        smat . Transpose[Sr] . Inverse[Sr . Transpose[Sr]]\), 
                      ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(Return[{Sr, Sn, eL, S}]\)}]}], 
                  "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ 
                  ReacMat\ determines\ the\ species\ names\ and\ calculates\ \
the\ total\ rates\ of\ *) \),
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], 
              
              StyleBox[\( (*\ \(reaction\)\(.\)\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{\(ReacMat[list2_]\), ":=", " ", 
                RowBox[{"Module", "[", 
                  
                  RowBox[{\({r, reactantNames, productNames, \ N, M, 
                      reactants, products, vee}\), ",", "\[IndentingNewLine]",
                     "\[IndentingNewLine]", 
                    
                    RowBox[{\(r\  = \ xlateDTG[list2]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactants\  = 
                        Map[getReactants, r]\), ";", 
                      "\[IndentingNewLine]", \(products\  = \ 
                        Map[getReactants[#, side \[Rule] \ "\<Right\>"] &, \ 
                          r]\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Union[Flatten[reactants]]\), ";", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Complement[reactantNames, 
                          Select[reactantNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(productNames\  = \ 
                        Union[Flatten[products]]\), ";", 
                      "\[IndentingNewLine]", \(productNames = 
                        Complement[productNames, 
                          Select[productNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(N = Length[reactantNames]\), 
                      ";", "                    ", 
                      StyleBox[\( (*\ rows\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      "\[IndentingNewLine]", \(M = Length[reactants]\), ";", 
                      "                             ", 
                      StyleBox[\( (*\ columns\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(vee = Table[0, {i, 1, M}]\), 
                      ";", "\[IndentingNewLine]", \(For[k = 1, 
                        k \[LessEqual] M, \[IndentingNewLine]vee = 
                          ReplacePart[vee, 
                            Apply[Times, 
                              Append[
                                Table[
                                  Power[reactants[\([k, j, 1]\)], 
                                    reactants[\([k, j, 2]\)]], {j, 1, 
                                    Length[reactants[\([k]\)]]}], 
                                r[\([k, 2]\)]]], k]; \(k++\)]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(Return[{vee, 
                          reactantNames}]\)}]}], "\[IndentingNewLine]", 
                  "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              
              StyleBox[\( (*\ 
                  Stochastic\ simulator\ using\ Gillespie' 
                    s\ original\ method\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ *) \),
                FontWeight->"Plain"], "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{\(cellStoch[ckt_, \ opt___?OptionQ]\), ":=", " ", 
                RowBox[{"Module", "[", 
                  
                  RowBox[{\({r, \ c, \ reactantNames, productNames, \ N, M, \ 
                      ic, zeroic, V, OM, rateRulesInput, rateConstants, 
                      unknownRates, knownRates, \ defaultRates, reactants, 
                      products, \ hformula, x, y, n, h, applyh, 
                      var2indexRules, \ index2VarRules, t, tau, mu, a, i, X, 
                      a0, dbg, \ species, results, maxSteps, \ maxTime, \ 
                      timeStep, lastSaveTime, out, output}\), ",", 
                    "\[IndentingNewLine]", "\[IndentingNewLine]", 
                    
                    RowBox[{\(maxSteps\  = \ \(MaxSteps /. {opt}\) /. \
{MaxSteps \[Rule] \ 1000}\), ";", 
                      "\[IndentingNewLine]", \(maxTime\  = \ \(timeSpan /. \
{opt}\) /. {timeSpan \[Rule] \ 100}\), ";", 
                      "\[IndentingNewLine]", \(If[
                        NumberQ[
                          maxTime], \[IndentingNewLine]\(timeStep\  = \ 
                            maxTime/
                              100.0;\)\[IndentingNewLine], \
\[IndentingNewLine]{maxTime, \ timeStep} = maxTime, \[IndentingNewLine]]\), 
                      ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(Print["\<Details of the \
stochastic simulation:\>"]\), ";", 
                      "\[IndentingNewLine]", \(Print["\<maxSteps=\>", 
                        maxSteps, "\< maxTime=\>", maxTime, "\< deltaT=\>", \ 
                        timeStep]\), ";", 
                      "\[IndentingNewLine]", \(dbg = \ \(debug /. {opt}\) /. \
{debug \[Rule] \ True}\), ";", 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], 
                      
                      StyleBox[\( (*\ 
                          combinatoric\ rules\ \((equation\ 15)\)\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(OM\  = \ \(sysOmega /. {opt}\) \
/. {sysOmega \[Rule] 1}\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(hformula[{x_, 1}] := \ x/OM\), 
                      ";", "\[IndentingNewLine]", \(hformula[{x_, 
                            n_}] := \((\((x - n + 1)\)/\((n*OM)\))\)\ *\ 
                          hformula[{x, n - 1}]\), ";", 
                      "\[IndentingNewLine]", \(applyh[x_] := 
                        Apply[Times, \ Map[hformula, x]]\), ";", 
                      "\[IndentingNewLine]", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(V = \(volume /. {opt}\) /. \
{volume \[Rule] \ 1}\), ";", "\[IndentingNewLine]", \(r\  = \ xlateDTG[ckt]\),
                       ";", "\[IndentingNewLine]", \(If[dbg, \ 
                        Print["\<r=\>", r]]\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", "\[IndentingNewLine]", 
                      
                      StyleBox[\( (*\ 
                          determine\ deterministic\ rate\ constants\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], 
                      "\[IndentingNewLine]", \(rateRulesInput\  = \ \(rates /. \
{opt}\) /. {rates \[Rule] \ {}}\), ";", 
                      "\[IndentingNewLine]", \(rateConstants = Map[Last, r]\),
                       ";", "\[IndentingNewLine]", \(unknownRates = \ 
                        rateConstants /. rateRulesInput\), ";", 
                      "\[IndentingNewLine]", \(knownRates = 
                        Select[unknownRates, NumberQ]\), ";", 
                      "\[IndentingNewLine]", \(unknownRates = 
                        Complement[unknownRates, knownRates]\), ";", 
                      "\[IndentingNewLine]", \(If[
                        Length[unknownRates] > 
                          0, \[IndentingNewLine]defaultRates = 
                          Map[# \[Rule] \ 1 &, 
                            unknownRates]; \
\[IndentingNewLine]Print["\<Warning: the following rate constants were not \
specified and were set to 1:\>" <> \ 
                            Apply[commaDelimitedString, 
                              unknownRates]];\[IndentingNewLine], \
\[IndentingNewLine]\(defaultRates = {};\)\[IndentingNewLine]]\), ";", 
                      "\[IndentingNewLine]", 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], 
                      
                      StyleBox[\( (*\ 
                          
                          convert\ deterministic\ rate\ constants\ to\ \
stochastic\ rate\ constants\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(c\  = \ 
                        Map[k2c[#, \ V] &, \ r]\), ";", 
                      "\[IndentingNewLine]", \(c = \(c /. rateRulesInput\) /. 
                          defaultRates\), ";", 
                      "\[IndentingNewLine]", \(M = Length[c]\), ";", 
                      "\[IndentingNewLine]", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactants\  = 
                        Map[getReactants, r]\), ";", 
                      "\[IndentingNewLine]", \(products\  = \ 
                        Map[getReactants[#, side \[Rule] \ "\<Right\>"] &, \ 
                          r]\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Union[Flatten[reactants]]\), ";", 
                      "\[IndentingNewLine]", \(reactantNames = 
                        Complement[reactantNames, 
                          Select[reactantNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(productNames\  = \ 
                        Union[Flatten[products]]\), ";", 
                      "\[IndentingNewLine]", \(productNames = 
                        Complement[productNames, 
                          Select[productNames, NumberQ]]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(N = Length[reactantNames]\), 
                      ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(species\  = \ 
                        Union[Join[reactantNames, \ productNames]]\), ";", 
                      "\[IndentingNewLine]", \(N = Length[species]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(ic\  = \ \(initialConditions /. \
{opt}\) /. {initialConditions \[Rule] \ {}}\), ";", 
                      "\[IndentingNewLine]", \(zeroic = 
                        Map[# \[Rule] \ 0 &, species]\), ";", 
                      "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(X = \(OM*V*species /. ic\) /. 
                          zeroic\), ";", "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", 
                      StyleBox[\( (*\ apply\ equation\ 15\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], \(h = Map[applyh, reactants]\), 
                      ";", "\[IndentingNewLine]", \(var2indexRules = \ 
                        MapThread[#1 \[Rule] x[#2] &, \ {species, 
                            Range[N]}]\), ";", 
                      "\[IndentingNewLine]", \(a = \((h /. var2indexRules)\)*
                          c\), ";", 
                      "\[IndentingNewLine]", \(If[
                        dbg, \[IndentingNewLine]\(Print["\<c=\>", 
                            c, \[IndentingNewLine]"\<\nM=\>", 
                            M, \[IndentingNewLine]"\<\nreactants=\>", 
                            reactants, \[IndentingNewLine]"\<\nproducts=\>", \
\ products, \[IndentingNewLine]"\<\nreactantNames=\>", 
                            reactantNames, \[IndentingNewLine]"\<\n\
productNames=\>", productNames, \[IndentingNewLine]"\<\nspecies=\>", 
                            species, \[IndentingNewLine]"\<\nN=\>", 
                            N, \[IndentingNewLine]"\<\nX=\>", 
                            X, \[IndentingNewLine]"\<\nh=\>", 
                            h, \[IndentingNewLine]"\<\na=\>", 
                            a];\)\[IndentingNewLine]]\), ";", 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], \(\[CapitalDelta]xrule[x_] := \ 
                        Apply[Rule, x]\), " ", ";", 
                      "\[IndentingNewLine]", \(make\[CapitalDelta]xrule[
                          x_] := \ Map[\[CapitalDelta]xrule, x]\), ";", 
                      "\[IndentingNewLine]", \(\[CapitalDelta]lhsrules = 
                        Map[make\[CapitalDelta]xrule, reactants]\), ";", 
                      "\[IndentingNewLine]", \(\[CapitalDelta]rhsrules = 
                        Map[make\[CapitalDelta]xrule, products]\), ";", 
                      "\[IndentingNewLine]", \(\[CapitalDelta]lhs\  = \((\ 
                            Map[species /. # &, \ \ \[CapitalDelta]lhsrules])\
\) /. zeroic\), ";", "\[IndentingNewLine]", \(\[CapitalDelta]rhs\  = \ 
                        Map[species /. # &, \ \ \[CapitalDelta]rhsrules] /. 
                          zeroic\), ";", 
                      "\[IndentingNewLine]", \(\[CapitalDelta]X = \
\[CapitalDelta]rhs - \[CapitalDelta]lhs\), ";", 
                      "\[IndentingNewLine]", \(If[
                        dbg, \[IndentingNewLine]\(Print["\<\[CapitalDelta]\
lhsrules=\>", \[CapitalDelta]lhsrules, "\<\n\[CapitalDelta]rhsrules=\>", \
\[CapitalDelta]rhsrules, "\<\n\[CapitalDelta]lhs=\>", \[CapitalDelta]lhs, "\<\
\n\[CapitalDelta]rhs=\>", \[CapitalDelta]rhs, "\<\n\[CapitalDelta]X=\>", \
\[CapitalDelta]X];\)\[IndentingNewLine]]\), ";", " ", 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], 
                      StyleBox[\( (*\ begin\ gillespie\ algorithm\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], 
                      StyleBox["\[IndentingNewLine]",
                        FontWeight->"Plain"], 
                      StyleBox[\( (*\ step\ 0\ *) \),
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        FontWeight->"Plain"], "\[IndentingNewLine]", 
                      "\[IndentingNewLine]", \(t = 0\), ";", 
                      "\[IndentingNewLine]", \(n = 0\), ";", 
                      "\[IndentingNewLine]", \(initG[opt]\), ";", 
                      "\[IndentingNewLine]", \(results\  = \ {Prepend[
                            species, time], \ Prepend[X, t/OM]}\), ";", 
                      "\[IndentingNewLine]", \(lastSaveTime = 0\), ";", " ", 
                      "\[IndentingNewLine]", 
                      RowBox[{"While", "[", 
                        
                        RowBox[{\(\((n < maxSteps)\)\  && \ \((t < 
                                maxTime)\)\), ",", " ", "\[IndentingNewLine]",
                           
                          StyleBox[\( (*\ step\ 1\ *) \),
                            FontWeight->"Plain"], 
                          StyleBox[" ",
                            FontWeight->"Plain"], "\[IndentingNewLine]", 
                          
                          RowBox[{\(var2indexRules = \ 
                              MapThread[#1 \[Rule] X[\([#2]\)] &, \ {species, 
                                  Range[N]}]\), ";", 
                            "\[IndentingNewLine]", \(a = \((h /. 
                                    var2indexRules)\)*c\), ";", 
                            "\[IndentingNewLine]", \(a0 = Apply[Plus, a]\), 
                            ";", "\[IndentingNewLine]", 
                            "\[IndentingNewLine]", \(If[
                              dbg, \[IndentingNewLine]Print["\<a=\>", 
                                a, "\<\na0=\>", 
                                a0]; \[IndentingNewLine]Print["\<{tau,mu}=\>",\
 {tau, mu}];\[IndentingNewLine]]\), ";", "\[IndentingNewLine]", 
                            StyleBox[\( (*\ step\ 2\ *) \),
                              FontWeight->"Plain"], 
                            StyleBox["\[IndentingNewLine]",
                              FontWeight->"Plain"], \({tau, \ mu} = 
                              gTauMu[a]\), ";", "\[IndentingNewLine]", 
                            "\[IndentingNewLine]", 
                            StyleBox[\( (*\ step\ 3\ *) \),
                              FontWeight->"Plain"], 
                            "\[IndentingNewLine]", \(X\  += \ \
\[CapitalDelta]X[\([mu]\)]\), ";", 
                            StyleBox["\[IndentingNewLine]",
                              FontWeight->"Plain"], \(t += \ tau\), ";", 
                            "\[IndentingNewLine]", \(If[dbg, 
                              Print["\<t=\>", t, "\< X=\>", X]]\), ";", 
                            "\[IndentingNewLine]", \(If[
                              t - lastSaveTime > 
                                timeStep, \ \[IndentingNewLine]results = 
                                Append[results, 
                                  Prepend[X, 
                                    t/OM]]; \[IndentingNewLine]lastSaveTime = 
                                t;\[IndentingNewLine]]\), ";", 
                            "\[IndentingNewLine]", 
                            "\[IndentingNewLine]", \(n++\), ";"}]}], 
                        "\[IndentingNewLine]", \( (*\ \(If[
                              Mod[n, 1000] \[Equal] 0, 
                              Print["\<n=\>", n, "\< t=\>", t]];\)\ *) \), 
                        " ", "\[IndentingNewLine]", "]"}], ";", 
                      "\[IndentingNewLine]", \(Print["\<steps=\>", 
                        n, "\< final time=\>", t]\), ";", 
                      "\[IndentingNewLine]", \(out = \((\(output /. {opt}\) /. \
{output \[Rule] \ "\<Default\>"})\)\), ";", 
                      "\[IndentingNewLine]", \(If[
                        out \[NotEqual] \ "\<spreadsheet\>", \
\[IndentingNewLine]output\  = \ 
                          spreadSheet2Lists[
                            results]; \[IndentingNewLine]results\  = \ \
{species, output};\[IndentingNewLine]]\), ";", 
                      "\[IndentingNewLine]", \(Return[results]\)}]}], 
                  "\[IndentingNewLine]", "]"}]}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ 
                  Stochastic\ simulation\ is\ run\ if\ the\ SSim\ flag\ is\ \
True\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              "\[IndentingNewLine]", \(If[
                SSim, \[IndentingNewLine]n = 
                  cellStoch[list, 
                    timeSpan \[Rule] \ {tMax*SizeW, 0.05*SizeW}, \ 
                    initialConditions \[Rule] ics, rates \[Rule] ReaRates, 
                    debug \[Rule] \ Dbg, MaxSteps \[Rule] maximumSteps, 
                    sysOmega \[Rule] SizeW]; \[IndentingNewLine]vars\  = 
                  Flatten[\ First[n]]; \[IndentingNewLine]stochasticVars = 
                  Flatten[
                    Table[ToExpression[
                        StringJoin[
                          ToString[vars[\([i]\)]], "\<stoch\>"]], {i, 1, 
                        Length[
                          vars]}]]; \[IndentingNewLine]stochasticData\  = \ 
                  n[\([2]\)]; \[IndentingNewLine]StoFun = 
                  Table[stochasticVars[\([i]\)] \[Rule] 
                      Interpolation[stochasticData[\([i]\)], 
                        InterpolationOrder \[Rule] 1], {i, 1, 
                      Length[vars]}];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              StyleBox[\( (*\ Linear\ Noise\ Approximation\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              "\[IndentingNewLine]", \(P = StochMat[list]\), ";", 
              "\[IndentingNewLine]", \(Q = ReacMat[list]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Rmat = 
                AppendRows[P[\([3]\)], Transpose[{Q[\([2]\)]}]]\), ";", 
              "\[IndentingNewLine]", \(lenRea = Length[P[\([3, 1]\)]]\), ";", 
              "\[IndentingNewLine]", \(lenR = Length[P[\([3]\)]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(For[j = 1; 
                ztab = Table[0, {k, 1, lenRea}]; q = 1; Rr = {}; Rn = {};, 
                j \[LessEqual] lenR, 
                If[P[\([3, j]\)] \[Equal] ReplacePart[ztab, 1, q], 
                  Rr = Append[Rr, Rmat[\([j]\)]]; If[q < lenRea, \(q++\)], 
                  Rn = Append[Rn, Rmat[\([j]\)]]]; \(j++\)]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(indReactants = \(Transpose[
                    Rr]\)[\([\(-1\)]\)]\), ";", "\[IndentingNewLine]", 
              RowBox[{"indLink", "=", 
                StyleBox[\(IdentityMatrix[Length[Transpose[Rr]] - 1]\),
                  "MR"]}], 
              StyleBox[";",
                "MR"], "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["depReactants",
                  "MR"], 
                StyleBox["=",
                  "MR"], \(\(Transpose[Rn]\)[\([\(-1\)]\)]\)}], ";", 
              "\[IndentingNewLine]", \(depLink = 
                TakeColumns[Rn, Length[Transpose[Rn]] - 1]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(cutNum[a_] := If[NumberQ[a], a, 0]\), 
              ";", "\[IndentingNewLine]", \(indNot = 
                Map[cutNum, \((indReactants /. ics)\)]\), ";", 
              "\[IndentingNewLine]", \(depNot = 
                Map[cutNum, \((depReactants /. ics)\)]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(depsubrhs = 
                Flatten[
                  depLink . Transpose[{indReactants}] - 
                    depLink . Transpose[{indNot}] - depNot]\), ";", 
              "\[IndentingNewLine]", \(depsub = 
                Table[depReactants[\([i]\)] \[Rule] depsubrhs[\([i]\)], {i, 
                    1, Length[depReactants]}]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(newNu = 
                Simplify[\((P[\([1]\)] . Q[\([1]\)])\) /. depsub]\), ";", 
              "\[IndentingNewLine]", \(Mr = Length[indReactants]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(sim = 
                predictTimeCourse[
                  list, \[IndentingNewLine]initialConditions \[Rule] 
                    ics, \[IndentingNewLine]rates \[Rule] 
                    ReaRates, \[IndentingNewLine]timeSpan \[Rule] 
                    tMax, \[IndentingNewLine]plotVariables \[Rule] \ None, 
                  MaxSteps \[Rule] maximumSteps, verbose \[Rule] \ False, \ 
                  concise \[Rule] \ True]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(Amat = 
                Table[Table[
                    D[newNu[\([k]\)], indReactants[\([j]\)]], {j, 1, 
                      Mr}], {k, 1, Mr}]\), ";", 
              "\[IndentingNewLine]", \(Bmat = 
                Simplify[\((P[\([1]\)] . 
                        DiagonalMatrix[Flatten[Q[\([1]\)]]] . 
                        Transpose[P[\([1]\)]])\) /. depsub]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(funSub = 
                Flatten[
                  Table[indReactants[\([j]\)] \[Rule] \(indReactants[\([j]\)]\
\)[t], {j, 1, Mr}]]\), ";", 
              "\[IndentingNewLine]", \(ssolna\  = 
                Evaluate[\(indReactants /. funSub\) /. \ sim[\([1, 3, 1]\)]] /. 
                  t \[Rule] tMax\), ";", 
              "\[IndentingNewLine]", \(ssoln = 
                Flatten[
                  Table[
                    indReactants[\([j]\)] \[Rule] ssolna[\([j]\)], {j, 1, 
                      Mr}]]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(SState = 
                Nor[Evaluate[
                    Max[Re[Eigenvalues[\(Amat /. Flatten[ssoln]\) /. 
                              ReaRates]]] < 0]]\), ";", 
              "\[IndentingNewLine]", \(If[
                And[SState, 
                  Not[LimCyc]], \(Print["\<WARNING! The system does not \
appear to have a stable steady-state.\>", "\<\n The Linear Noise \
Approximation is not valid for long times.\>"];\)]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(If[
                And[Not[SState], SteadyCorr, 
                  Not[LimCyc]], \[IndentingNewLine]SStateVal = 
                  Solve[newNu \[Equal] Table[0, {i, 1, Mr}], 
                    indReactants]; \[IndentingNewLine]ssA = 
                  Table[\(Amat /. SStateVal[\([i]\)]\) /. ReaRates, {i, 1, 
                      Length[SStateVal]}]; \[IndentingNewLine]Eitab\  = \ 
                  Table[Max[Re[Eigenvalues[ssA[\([i]\)]]]] < 0, {i, 1, 
                      Length[SStateVal]}]; \[IndentingNewLine]ASS\  = \ 
                  Amat /. Flatten[
                      SStateVal[\([\(Position[Eitab, 
                              True]\)[\([1]\)]]\)]]; \[IndentingNewLine]BSS\  \
= \ Bmat /. Flatten[SStateVal[\([\(Position[Eitab, 
                              True]\)[\([1]\)]]\)]]; \[IndentingNewLine]eX = 
                  Table[\(X[Min[i, j], Max[i, j]]\)[t], {j, 1, Mr}, {i, 1, 
                      Mr}]; \[IndentingNewLine]reX = 
                  Flatten[
                    Table[\(X[Min[i, j], Max[i, j]]\)[t], {j, 1, Mr}, {i, j, 
                        Mr}]]; \[IndentingNewLine]var1 = 
                  Expand[\((ASS . eX)\) + \((eX . Transpose[ASS])\) + 
                      BSS]; \[IndentingNewLine]vareq = 
                  Flatten[
                    Table[0 \[Equal] Expand[var1[\([i, j]\)]], {j, 1, 
                        Mr}, {i, j, Mr}]]; \[IndentingNewLine]vsoln = 
                  Flatten[Solve[vareq, reX]]; \[IndentingNewLine]CSteady = 
                  eX /. Chop[
                      FullSimplify[
                        ExpandAll[Chop[vsoln]]]];\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(lhsCorr = 
                ToExpression[
                  Table[StringJoin[ToString[indReactants[\([Min[i, j]]\)]], 
                      ToString[
                        indReactants[\([Max[i, 
                              j]]\)]], "\<n\>", "\<[t]\>"], {i, 1, 
                      Length[indReactants]}, {j, 1, Length[indReactants]}]]\),
               ";", "\[IndentingNewLine]", \(CorrVar = 
                Flatten[
                  ToExpression[
                    Table[StringJoin[ToString[indReactants[\([Min[i, j]]\)]], 
                        ToString[
                          indReactants[\([Max[i, j]]\)]], "\<n\>"], {i, 1, 
                        Length[indReactants]}, {j, i, 
                        Length[indReactants]}]]]\), ";", 
              "\[IndentingNewLine]", \(lhsCorrDer = 
                ToExpression[
                  Table[StringJoin[ToString[indReactants[\([Min[i, j]]\)]], 
                      ToString[
                        indReactants[\([Max[i, 
                              j]]\)]], "\<n\>", "\<'\>", "\<[t]\>"], {i, 1, 
                      Length[indReactants]}, {j, 1, Length[indReactants]}]]\),
               ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(AA = \(\(Amat /. funSub\) /. 
                    ReaRates\) /. sim[\([1, 3, 1]\)]\), ";", 
              "\[IndentingNewLine]", \(BB = \(\(Bmat /. funSub\) /. 
                    ReaRates\) /. sim[\([1, 3, 1]\)]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
                RowBox[{"LimCyc", ",", "\[IndentingNewLine]", 
                  
                  StyleBox[\( (*\ 
                      Time - dependent\ cross - 
                        correlation\ of\ the\ fluctuations\ around\ the\ \
limit\ cycle*) \),
                    FontWeight->"Plain"], 
                  "\[IndentingNewLine]", \(f1 = \(\(newNu[\([1]\)] /. 
                          funSub\) /. ReaRates\) /. 
                      sim[\([1, 3, 
                          1]\)]; \[IndentingNewLine]f2 = \(\(newNu[\([2]\)] /. 
                          funSub\) /. ReaRates\) /. 
                      sim[\([1, 3, 1]\)]; \[IndentingNewLine]If[
                    Not[Mr \[Equal] 2], 
                    Print["\<Fluctuation estimation about a limit cycle is \
only implemented\>", "\<\nfor two dimensional systems. Calculation will be \
aborted.\>"]; Abort[];]; \[IndentingNewLine]Th[
                      var_] = \(Flatten[
                          Solve[{TrigToExp[Sin[T]] \[Equal] 
                                Evaluate[\(\((\(-f1\)/Sqrt[f1^2 + f2^2])\) /. 
                                      srates\) /. sim[\([1, 3, 1]\)]], 
                              TrigToExp[Cos[T]] \[Equal] 
                                Evaluate[\(\((f2/Sqrt[f1^2 + f2^2])\) /. 
                                      srates\) /. sim[\([1, 3, 1]\)]]}, 
                            T]]\)[\([1, 2]\)] /. 
                      t \[Rule] var; \[IndentingNewLine]UMat[var_] = 
                    Evaluate[RotationMatrix2D[Re[Th[t]]]] /. 
                      t \[Rule] var; \[IndentingNewLine]Rmacro = 
                    Interpolation[
                      Transpose[{Table[t, {t, 0, tMax, tMax/10000}], 
                          Table[\(Evaluate[\((UMat[t] . {{X[t]}, {Y[t]}})\) /. 
                                  sim[\([1, 3, 1]\)]]\)[\([1, 1]\)], {t, 0, 
                              tMax, tMax/10000}]}], 
                      InterpolationOrder \[Rule] 
                        1]; \[IndentingNewLine]Smacro = 
                    Interpolation[
                      Transpose[{Table[t, {t, 0, tMax, tMax/10000}], 
                          Table[\(Evaluate[\((UMat[t] . {{X[t]}, {Y[t]}})\) /. 
                                  sim[\([1, 3, 1]\)]]\)[\([2, 1]\)], {t, 0, 
                              tMax, tMax/10000}]}], 
                      InterpolationOrder \[Rule] 1]; \[IndentingNewLine]Ar1[
                      var_] = \((UMat[t] . AA . Transpose[UMat[t]])\) /. 
                      t \[Rule] var; \[IndentingNewLine]RotMat[var_] = 
                    Evaluate[{{0, \(-1\)}, {1, 0}}*\(Ar1[t]\)[\([1, 2]\)]] /. 
                      t \[Rule] var; \[IndentingNewLine]Ar[
                      var_] = \((Ar1[t] + RotMat[t])\) /. 
                      t \[Rule] var; \[IndentingNewLine]Br[
                      var_] = \((UMat[t] . BB . Transpose[UMat[t]])\) /. 
                      t \[Rule] var; \[IndentingNewLine]CorrDe = 
                    Flatten[
                      Table[lhsCorrDer[\([k, l]\)] \[Equal] 
                          Sum[\(Ar[t]\)[\([k, i]\)]*lhsCorr[\([i, l]\)], {i, 
                                1, Mr}] + 
                            Sum[\(Ar[t]\)[\([l, j]\)]*
                                lhsCorr[\([k, j]\)], {j, 1, Mr}] + \(Br[
                                t]\)[\([k, l]\)], {k, 1, Mr}, {l, k, 
                          Mr}]]; \[IndentingNewLine]CorrBC = 
                    Flatten[
                      Table[lhsCorr[\([k, l]\)] \[Equal] 0, {k, 1, Mr}, {l, 
                            k, Mr}] /. 
                        t \[Rule] 0]; \[IndentingNewLine]CorrEqs = 
                    Flatten[
                      Join[CorrDe, CorrBC]]; \[IndentingNewLine]CorrSolna = 
                    Flatten[
                      NDSolve[CorrEqs, CorrVar, {t, 0, tMax}, 
                        MaxSteps \[Rule] 
                          maximumSteps]]; \[IndentingNewLine]CorrSolnb = 
                    Transpose[
                        UMat[t]] . {{Rmacro[t] - 
                            Sqrt[Evaluate[\((lhsCorr[\([1, 1]\)]/SizeW)\) /. 
                                  CorrSolna]]}, {Smacro[
                            t]}}; \[IndentingNewLine]CorrSolnc = 
                    Transpose[
                        UMat[t]] . {{Rmacro[t] + 
                            Sqrt[Evaluate[\((lhsCorr[\([1, 1]\)]/SizeW)\) /. 
                                  CorrSolna]]}, {Smacro[
                            t]}}; \[IndentingNewLine]CorrSolnd = 
                    Table[Interpolation[
                        Transpose[{Table[t, {t, 0, tMax, tMax/50000}], 
                            Table[Re[CorrSolnb[\([j, 1]\)]], {t, 0, tMax, 
                                tMax/50000}]}], 
                        InterpolationOrder \[Rule] 1], {j, 1, 
                        Mr}]; \[IndentingNewLine]CorrSolne = 
                    Table[Interpolation[
                        Transpose[{Table[t, {t, 0, tMax, tMax/50000}], 
                            Table[Re[CorrSolnc[\([j, 1]\)]], {t, 0, tMax, 
                                tMax/50000}]}], 
                        InterpolationOrder \[Rule] 1], {j, 1, 
                        Mr}]; \[IndentingNewLine]CorrSoln = 
                    Join[Flatten[
                        Table[ToExpression[
                              StringJoin[
                                ToString[
                                  indReactants[\([j]\)]], "\<corrNeg\>"]] \
\[Rule] CorrSolnd[\([j]\)], {j, 1, Mr}]], 
                      Flatten[
                        Table[ToExpression[
                              StringJoin[
                                ToString[
                                  indReactants[\([j]\)]], "\<corrPos\>"]] \
\[Rule] CorrSolne[\([j]\)], {j, 1, Mr}]]];\), "\[IndentingNewLine]", ",", 
                  "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  
                  StyleBox[\( (*\ 
                      Time - dependent\ cross - 
                        correlation\ of\ the\ fluctuations\ *) \),
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  "\[IndentingNewLine]", \(CorrDe = 
                    Flatten[
                      Table[lhsCorrDer[\([k, l]\)] \[Equal] 
                          Sum[AA[\([k, i]\)]*lhsCorr[\([i, l]\)], {i, 1, 
                                Mr}] + 
                            Sum[AA[\([l, j]\)]*lhsCorr[\([k, j]\)], {j, 1, 
                                Mr}] + BB[\([k, l]\)], {k, 1, Mr}, {l, k, 
                          Mr}]]; \[IndentingNewLine]CorrBC = 
                    Flatten[
                      Table[lhsCorr[\([k, l]\)] \[Equal] 0, {k, 1, Mr}, {l, 
                            k, Mr}] /. 
                        t \[Rule] 0]; \[IndentingNewLine]CorrEqs = 
                    Flatten[
                      Join[CorrDe, CorrBC]]; \[IndentingNewLine]CorrSoln = 
                    Flatten[
                      NDSolve[CorrEqs, CorrVar, {t, 0, tMax}, 
                        MaxSteps \[Rule] maximumSteps]];\)}], 
                "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(ReSults = {sim[\([1, 3, 1]\)], 
                  CorrSoln}\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ If\ a\ stochastic\ simulation\ was\ run, \ 
                  the\ resulting\ functions\ are\ appended\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              "\[IndentingNewLine]", \(If[
                SSim, \[IndentingNewLine]ReSults = Append[ReSults, StoFun]]\),
               ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ \(If\ an\ analytic\ steady - 
                    state\ crosscorrelation\ matrix\ is\ asked\ for\)\(,\)\ \ \
\ \ \ *) \),
                FontWeight->"Plain"], "\[IndentingNewLine]", 
              
              StyleBox[\( (*\ 
                  the\ resulting\ matrix\ is\ appended\ along\ with\ the\ \
independent\ reactants\ *) \),
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\[IndentingNewLine]",
                FontWeight->"Plain"], \(If[And[Not[SState], SteadyCorr], 
                ReSults = Append[ReSults, {CSteady}]; 
                ReSults = Append[ReSults, {indReactants}];]\), ";", 
              "\[IndentingNewLine]", \(Return[ReSults]\), ";"}]}], 
          "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}], 
      ";"}]}], "Input"]
}, Closed]],

Cell["\<\
The Brusselator, stable but near the Hopf bifurcation
(Gillespie DT (1977) Exact stochastic simulation of coupled chemical \
reactions, Journal of Physical Chemistry 81: 2340-2361.)\
\>", "Section"],

Cell[BoxData[{
    \(\(\[CapitalOmega] = 1000;\)\), "\[IndentingNewLine]", 
    \(\(s = {{\[EmptySet] \[ShortRightArrow] X, \ 
            1}, \ \[IndentingNewLine]{2*X + Y \[ShortRightArrow] 3*X, 
            a}, \[IndentingNewLine]{X \[ShortRightArrow] Y, 
            b}, \[IndentingNewLine]{X \[ShortRightArrow] \[EmptySet], 
            1}\[IndentingNewLine]};\)\), "\[IndentingNewLine]", 
    \(\(srates = {a \[Rule] 0.95, 
          b \[Rule] 1.90};\)\), "\[IndentingNewLine]", 
    \(\(sic\  = \ {X \[Rule] \ 1, \ Y \[Rule] \ 2};\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(tfinal = 500;\)\), "\[IndentingNewLine]", 
    \(lnaResults1 = 
      LNA[s, \[IndentingNewLine]initialConditions \[Rule] 
          sic, \[IndentingNewLine]rates \[Rule] \ 
          srates, \[IndentingNewLine]timeSpan \[Rule] tfinal, 
        sizeW \[Rule] \[CapitalOmega], stochasticSimulation \[Rule] True, 
        SteadyStateMatrix \[Rule] True, MaxSteps \[Rule] 5000000]\)}], "Input"],

Cell[BoxData[
    \("Details of the stochastic simulation:"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("maxSteps="\[InvisibleSpace]5000000\[InvisibleSpace]" \
maxTime="\[InvisibleSpace]500000\[InvisibleSpace]" \
deltaT="\[InvisibleSpace]50.`\),
      SequenceForm[ 
      "maxSteps=", 5000000, " maxTime=", 500000, " deltaT=", .5*^2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("steps="\[InvisibleSpace]2900918\[InvisibleSpace]" \
final time="\[InvisibleSpace]500001.03716762527`\),
      SequenceForm[ "steps=", 2900918, " final time=", 500001.03716762527],
      Editable->False]], "Print"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"X", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.`, 500.`}}, "<>"]\),
                False,
                Editable->False]}], ",", 
            RowBox[{"Y", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.`, 500.`}}, "<>"]\),
                False,
                Editable->False]}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"XXn", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.`, 500.`}}, "<>"]\),
                False,
                Editable->False]}], ",", 
            RowBox[{"XYn", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.`, 500.`}}, "<>"]\),
                False,
                Editable->False]}], ",", 
            RowBox[{"YYn", "\[Rule]", 
              TagBox[\(InterpolatingFunction[{{0.`, 500.`}}, "<>"]\),
                False,
                Editable->False]}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"Xstoch", "\[Rule]", 
              
              TagBox[\(InterpolatingFunction[{{0.`, 499.985287322037`}}, 
                  "<>"]\),
                False,
                Editable->False]}], ",", 
            RowBox[{"Ystoch", "\[Rule]", 
              
              TagBox[\(InterpolatingFunction[{{0.`, 499.985287322037`}}, 
                  "<>"]\),
                False,
                Editable->False]}]}], "}"}], 
        ",", \({{{\(1 + a + b\)\/\(1 + a - b\), \(-\(\(2\ b\)\/\(1 + a - 
                      b\)\)\)}, {\(-\(\(2\ b\)\/\(1 + a - 
                      b\)\)\), \(b\ \((1 + a + b)\)\)\/\(a\ \((1 + a - \
b)\)\)}}}\), ",", \({{X, Y}}\)}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(\(meanFun = lnaResults1[\([1]\)];\)\), "\[IndentingNewLine]", 
    \(\(flucFun = lnaResults1[\([2]\)];\)\), "\[IndentingNewLine]", 
    \(\(stochFun = lnaResults1[\([3]\)];\)\)}], "Input"],

Cell["\<\
The steady-state fluctuations are shown with red lines representing \
the one-standard deviation envelope calculated using the Linear Noise \
Approximation. The one-dimensional projection ignores cross-correlations \
between X and Y.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayTogetherArray[
        Plot[Evaluate[\(\({Xstoch[t], \[CapitalOmega]*X[t] + 
                      Sqrt[\[CapitalOmega]*XXn[t]], \[CapitalOmega]*
                      X[t], \[CapitalOmega]*X[t] - 
                      Sqrt[\[CapitalOmega]*XXn[t]]} /. meanFun\) /. 
                flucFun\) /. stochFun], {t, 0, tfinal}, 
          PlotRange \[Rule] All, PlotPoints \[Rule] 1000, 
          PlotStyle \[Rule] {RGBColor[0, 0, 0], RGBColor[1, 0, 0], 
              RGBColor[0, 0, 0], RGBColor[1, 0, 0]}, 
          AxesLabel \[Rule] {time, X}, 
          PlotLabel \[Rule] "\<Steady-state fluctuations in X\>"], \
\[IndentingNewLine]Plot[
          Evaluate[\(\({Ystoch[t], \[CapitalOmega]*Y[t] + 
                      Sqrt[\[CapitalOmega]*YYn[t]], \[CapitalOmega]*
                      Y[t], \[CapitalOmega]*Y[t] - 
                      Sqrt[\[CapitalOmega]*YYn[t]]} /. meanFun\) /. 
                flucFun\) /. stochFun], {t, 0, tfinal}, 
          PlotRange \[Rule] All, PlotPoints \[Rule] 1000, 
          PlotStyle \[Rule] {RGBColor[0, 0, 0], RGBColor[1, 0, 0], 
              RGBColor[0, 0, 0], RGBColor[1, 0, 0]}, 
          AxesLabel \[Rule] {time, Y}, 
          PlotLabel \[Rule] "\<Steady-state fluctuations in Y\>"]];\)\)], \
"Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00190476 -0.285167 0.000517647 [
[.21429 .01292 -9 -9 ]
[.21429 .01292 9 0 ]
[.40476 .01292 -9 -9 ]
[.40476 .01292 9 0 ]
[.59524 .01292 -9 -9 ]
[.59524 .01292 9 0 ]
[.78571 .01292 -9 -9 ]
[.78571 .01292 9 0 ]
[.97619 .01292 -9 -9 ]
[.97619 .01292 9 0 ]
[1.025 .02542 0 -6.4375 ]
[1.025 .02542 28 6.4375 ]
[.01131 .12895 -18 -4.5 ]
[.01131 .12895 0 4.5 ]
[.01131 .23248 -24 -4.5 ]
[.01131 .23248 0 4.5 ]
[.01131 .33601 -24 -4.5 ]
[.01131 .33601 0 4.5 ]
[.01131 .43954 -24 -4.5 ]
[.01131 .43954 0 4.5 ]
[.01131 .54307 -24 -4.5 ]
[.01131 .54307 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[.5 .63053 -92 0 ]
[.5 .63053 92 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .02542 m
.21429 .03167 L
s
[(100)] .21429 .01292 0 1 Mshowa
.40476 .02542 m
.40476 .03167 L
s
[(200)] .40476 .01292 0 1 Mshowa
.59524 .02542 m
.59524 .03167 L
s
[(300)] .59524 .01292 0 1 Mshowa
.78571 .02542 m
.78571 .03167 L
s
[(400)] .78571 .01292 0 1 Mshowa
.97619 .02542 m
.97619 .03167 L
s
[(500)] .97619 .01292 0 1 Mshowa
.125 Mabswid
.0619 .02542 m
.0619 .02917 L
s
.1 .02542 m
.1 .02917 L
s
.1381 .02542 m
.1381 .02917 L
s
.17619 .02542 m
.17619 .02917 L
s
.25238 .02542 m
.25238 .02917 L
s
.29048 .02542 m
.29048 .02917 L
s
.32857 .02542 m
.32857 .02917 L
s
.36667 .02542 m
.36667 .02917 L
s
.44286 .02542 m
.44286 .02917 L
s
.48095 .02542 m
.48095 .02917 L
s
.51905 .02542 m
.51905 .02917 L
s
.55714 .02542 m
.55714 .02917 L
s
.63333 .02542 m
.63333 .02917 L
s
.67143 .02542 m
.67143 .02917 L
s
.70952 .02542 m
.70952 .02917 L
s
.74762 .02542 m
.74762 .02917 L
s
.82381 .02542 m
.82381 .02917 L
s
.8619 .02542 m
.8619 .02917 L
s
.9 .02542 m
.9 .02917 L
s
.9381 .02542 m
.9381 .02917 L
s
.25 Mabswid
0 .02542 m
1 .02542 L
s
gsave
1.025 .02542 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(time) show
1.000 setlinewidth
grestore
.02381 .12895 m
.03006 .12895 L
s
[(800)] .01131 .12895 1 0 Mshowa
.02381 .23248 m
.03006 .23248 L
s
[(1000)] .01131 .23248 1 0 Mshowa
.02381 .33601 m
.03006 .33601 L
s
[(1200)] .01131 .33601 1 0 Mshowa
.02381 .43954 m
.03006 .43954 L
s
[(1400)] .01131 .43954 1 0 Mshowa
.02381 .54307 m
.03006 .54307 L
s
[(1600)] .01131 .54307 1 0 Mshowa
.125 Mabswid
.02381 .0513 m
.02756 .0513 L
s
.02381 .07719 m
.02756 .07719 L
s
.02381 .10307 m
.02756 .10307 L
s
.02381 .15483 m
.02756 .15483 L
s
.02381 .18071 m
.02756 .18071 L
s
.02381 .2066 m
.02756 .2066 L
s
.02381 .25836 m
.02756 .25836 L
s
.02381 .28424 m
.02756 .28424 L
s
.02381 .31013 m
.02756 .31013 L
s
.02381 .36189 m
.02756 .36189 L
s
.02381 .38777 m
.02756 .38777 L
s
.02381 .41366 m
.02756 .41366 L
s
.02381 .46542 m
.02756 .46542 L
s
.02381 .4913 m
.02756 .4913 L
s
.02381 .51718 m
.02756 .51718 L
s
.02381 .56895 m
.02756 .56895 L
s
.02381 .59483 m
.02756 .59483 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
1.000 setlinewidth
grestore
gsave
.5 .63053 -153 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Steady) show
99.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(state) show
141.000 13.000 moveto
(fluctuations) show
219.000 13.000 moveto
(in) show
237.000 13.000 moveto
(X) show
243.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 0 r
.5 Mabswid
.02381 .23248 m
.02384 .23355 L
.02386 .23452 L
.02389 .23565 L
.02392 .23558 L
.02395 .23474 L
.02397 .23397 L
.024 .23312 L
.02403 .22945 L
.02405 .22536 L
.02408 .22096 L
.02411 .22157 L
.02414 .22593 L
.02417 .23102 L
.02418 .23371 L
.0242 .23555 L
.02423 .23725 L
.02426 .23882 L
.02428 .23967 L
.02429 .2397 L
.02432 .23698 L
.02434 .23545 L
.02436 .23381 L
.02437 .23226 L
.02439 .23205 L
.02442 .23479 L
.02445 .23738 L
.02448 .24019 L
.0245 .23961 L
.02451 .23901 L
.02454 .23798 L
.02457 .23686 L
.0246 .23616 L
.02462 .23561 L
.02465 .23504 L
.02468 .23455 L
.02471 .23455 L
.02474 .23455 L
.02475 .23455 L
.02477 .23384 L
.02479 .23132 L
.02481 .22864 L
.02482 .22629 L
.02484 .22376 L
.02487 .22062 L
.0249 .22079 L
.02493 .22094 L
.02494 .22102 L
.02496 .2212 L
.02499 .22203 L
Mistroke
.02501 .22253 L
.02503 .223 L
.02504 .22343 L
.02506 .22275 L
.02508 .22045 L
.0251 .21803 L
.02511 .21593 L
.02513 .21369 L
.02515 .21175 L
.02516 .2115 L
.02519 .21101 L
.02526 .2099 L
.02529 .20941 L
.02531 .20914 L
.02532 .20889 L
.02535 .20707 L
.02538 .20363 L
.02541 .20014 L
.02543 .19839 L
.02545 .19842 L
.02546 .19942 L
.02548 .20034 L
.02551 .20209 L
.02554 .20425 L
.02557 .20678 L
.0256 .20909 L
.02563 .21114 L
.02566 .20998 L
.02569 .2089 L
.02575 .20665 L
.02581 .20483 L
.02587 .20341 L
.02589 .2028 L
.02592 .2015 L
.02595 .19973 L
.02598 .19778 L
.02601 .19533 L
.02603 .19233 L
.02604 .18958 L
.02607 .18461 L
.02609 .18198 L
.0261 .17942 L
.02613 .17688 L
.02616 .17451 L
.02622 .16767 L
.02625 .16334 L
.02628 .15875 L
.02629 .15642 L
.02631 .15906 L
.02634 .16371 L
Mistroke
.02637 .16809 L
.0264 .17125 L
.02643 .1708 L
.02645 .17039 L
.02648 .16996 L
.0265 .16607 L
.02653 .15971 L
.02656 .15395 L
.02658 .14916 L
.02661 .14929 L
.02664 .14944 L
.02666 .14957 L
.02669 .1502 L
.02672 .15149 L
.02675 .15269 L
.02677 .15377 L
.0268 .15115 L
.02684 .1483 L
.0269 .14372 L
.02692 .14193 L
.02695 .14 L
.02697 .14012 L
.02699 .14212 L
.02702 .14606 L
.02714 .16582 L
.0272 .17772 L
.02723 .18468 L
.02726 .19012 L
.02728 .19054 L
.02731 .191 L
.02733 .19139 L
.02736 .19166 L
.02739 .19181 L
.02742 .19197 L
.02744 .19202 L
.02747 .19051 L
.0275 .18874 L
.02753 .18707 L
.02754 .18626 L
.02756 .18572 L
.02759 .18477 L
.0276 .18426 L
.02762 .18371 L
.02765 .18377 L
.02768 .18451 L
.02771 .18533 L
.02772 .1858 L
.02774 .18524 L
.02776 .18426 L
.02778 .18334 L
Mistroke
.02781 .1817 L
.02782 .18077 L
.02784 .18183 L
.02789 .18599 L
.02792 .18782 L
.02795 .18703 L
.02798 .18622 L
.02801 .18544 L
.02803 .1853 L
.02805 .18521 L
.02808 .18504 L
.02811 .18488 L
.02813 .18214 L
.02816 .1792 L
.02819 .17609 L
.02822 .17411 L
.02824 .17441 L
.02827 .17473 L
.02829 .17491 L
.02831 .17549 L
.02833 .17789 L
.02836 .18017 L
.02841 .18479 L
.02852 .19834 L
.02855 .20213 L
.02857 .20612 L
.0286 .20841 L
.02863 .20885 L
.02866 .20934 L
.02868 .20962 L
.02869 .21016 L
.02872 .21139 L
.02875 .21271 L
.02877 .21344 L
.02879 .21365 L
.02882 .21266 L
.02884 .21171 L
.02887 .21082 L
.0289 .21103 L
.02892 .2112 L
.02893 .21138 L
.02895 .21157 L
.02897 .21175 L
.029 .21351 L
.02903 .21515 L
.02905 .21668 L
.02908 .21612 L
.02911 .21392 L
.02921 .2059 L
.02924 .20364 L
Mistroke
.02927 .20071 L
.0293 .19615 L
.02933 .192 L
.02936 .18872 L
.02938 .18763 L
.02941 .18645 L
.02944 .18515 L
.02947 .1844 L
.0295 .18382 L
.02952 .18321 L
.02955 .18284 L
.02958 .18301 L
.02961 .18316 L
.02964 .18351 L
.02966 .18445 L
.02968 .18531 L
.02971 .18707 L
.02974 .18843 L
.02977 .18813 L
.0298 .18781 L
.02981 .18763 L
.02983 .18746 L
.02985 .18792 L
.02986 .18851 L
.02989 .18946 L
.02991 .18997 L
.02992 .1905 L
.02995 .18993 L
.02998 .18933 L
.03001 .18877 L
.03004 .19044 L
.03006 .19374 L
.03009 .19729 L
.03012 .20065 L
.03014 .2016 L
.03037 .21334 L
.0304 .21012 L
.03043 .21347 L
.03044 .21655 L
.03046 .21994 L
.03049 .22592 L
.03055 .23531 L
.03058 .24032 L
.03061 .24433 L
.03062 .24592 L
.03064 .24765 L
.03068 .25068 L
.03069 .25211 L
.03071 .24968 L
.03074 .2453 L
Mistroke
.03076 .24308 L
.03077 .24068 L
.0308 .24096 L
.03083 .24502 L
.03086 .24876 L
.03089 .25175 L
.03092 .25236 L
.03097 .25346 L
.03102 .25467 L
.03105 .25531 L
.03108 .25588 L
.0311 .25605 L
.03112 .25624 L
.03115 .25657 L
.03118 .25772 L
.03121 .26071 L
.03123 .26342 L
.03126 .26627 L
.03129 .26592 L
.03132 .26516 L
.03135 .26436 L
.03138 .26415 L
.0314 .26428 L
.03143 .26443 L
.03146 .26489 L
.03149 .26878 L
.03152 .27214 L
.03155 .27575 L
.03157 .28209 L
.0316 .28864 L
.03162 .2953 L
.03165 .30148 L
.03167 .30644 L
.0317 .31171 L
.03173 .31671 L
.03176 .31914 L
.03179 .31963 L
.0318 .31988 L
.03182 .32016 L
.03185 .32141 L
.03188 .32452 L
.03199 .33925 L
.03202 .34453 L
.03205 .34554 L
.03207 .34482 L
.03208 .34404 L
.03212 .34268 L
.03215 .34496 L
.03216 .3471 L
.03218 .34944 L
Mistroke
.03223 .35755 L
.03226 .36177 L
.03229 .36626 L
.03231 .36884 L
.03233 .36869 L
.03236 .36579 L
.03239 .36308 L
.03242 .36185 L
.03245 .36574 L
.03248 .36933 L
.0325 .37279 L
.03253 .37041 L
.03256 .3664 L
.03259 .36274 L
.03261 .36074 L
.03264 .36176 L
.0327 .36403 L
.03276 .36732 L
.03279 .36897 L
.03281 .36696 L
.03282 .36449 L
.03285 .36039 L
.03288 .35607 L
.03291 .35393 L
.03294 .353 L
.03297 .35198 L
.03299 .35158 L
.033 .35175 L
.03304 .35209 L
.03306 .3524 L
.03308 .35257 L
.0331 .35228 L
.03314 .35169 L
.03317 .35117 L
.03318 .35074 L
.0332 .3502 L
.03323 .34924 L
.03326 .34822 L
.03329 .34667 L
.03332 .34504 L
.03335 .3434 L
.03338 .34187 L
.03343 .33991 L
.03346 .33882 L
.03349 .33483 L
.03352 .33022 L
.03354 .32768 L
.03355 .32528 L
.03357 .32403 L
.03359 .32313 L
Mistroke
.03361 .32155 L
.03364 .31995 L
.03367 .3157 L
.03372 .30562 L
.03375 .29995 L
.03377 .30017 L
.0338 .30063 L
.03383 .30111 L
.03386 .30071 L
.03388 .29933 L
.03391 .29791 L
.03394 .29638 L
.03397 .29226 L
.034 .28851 L
.03403 .28497 L
.03405 .28697 L
.03408 .29081 L
.03411 .29488 L
.03414 .29664 L
.03417 .29285 L
.0342 .28952 L
.03423 .28624 L
.03426 .28544 L
.03429 .28472 L
.03434 .28273 L
.03437 .28082 L
.0344 .27881 L
.03441 .27776 L
.03443 .27767 L
.03446 .278 L
.03449 .27833 L
.03452 .27825 L
.03455 .27745 L
.03458 .27671 L
.03461 .27597 L
.03464 .27192 L
.03469 .26457 L
.03472 .26157 L
.03475 .25981 L
.03481 .2556 L
.03502 .24346 L
.03595 .19339 L
.03601 .1873 L
.03604 .1841 L
.03607 .18257 L
.0361 .18137 L
.03613 .18006 L
.03616 .17999 L
.03618 .1804 L
.03621 .18092 L
Mistroke
.03624 .18159 L
.03626 .18213 L
.03628 .18272 L
.03631 .18375 L
.03634 .18354 L
.03637 .18136 L
.03643 .17734 L
.03669 .16134 L
.03675 .15421 L
.03678 .1494 L
.03681 .14571 L
.03683 .14504 L
.03685 .14432 L
.03686 .14354 L
.03688 .1428 L
.0369 .14213 L
.03691 .14226 L
.03694 .14322 L
.03697 .14421 L
.037 .14521 L
.03703 .14666 L
.03707 .14826 L
.03712 .15186 L
.03715 .15448 L
.03718 .1569 L
.03721 .15794 L
.03724 .15794 L
.03726 .15794 L
.03729 .15712 L
.03732 .15405 L
.03735 .15116 L
.03737 .14857 L
.0374 .14822 L
.03743 .14939 L
.03746 .15049 L
.03747 .15112 L
.03749 .15274 L
.03752 .15684 L
.03759 .1639 L
.03762 .16664 L
.03764 .16814 L
.03766 .16955 L
.03769 .16548 L
.0377 .16162 L
.03772 .15745 L
.03775 .1507 L
.03778 .14603 L
.03781 .14346 L
.03784 .14075 L
.0379 .13718 L
Mistroke
.03793 .13557 L
.03796 .13399 L
.03797 .13355 L
.03799 .13306 L
.03802 .1322 L
.03805 .13182 L
.03807 .13264 L
.03809 .13339 L
.03814 .13621 L
.0382 .13829 L
.03823 .13947 L
.03826 .13886 L
.03829 .13764 L
.03831 .13628 L
.03837 .13408 L
.0384 .13306 L
.03842 .13249 L
.03843 .13165 L
.03846 .12717 L
.03849 .12227 L
.03851 .11952 L
.03853 .11704 L
.03856 .11687 L
.03859 .11669 L
.03861 .11659 L
.03863 .11589 L
.03866 .11276 L
.03869 .10936 L
.03872 .10618 L
.03875 .10632 L
.03878 .1065 L
.0388 .10659 L
.03881 .10668 L
.03884 .10506 L
.03887 .10351 L
.0389 .10198 L
.03893 .10105 L
.03896 .1005 L
.03898 .09989 L
.03901 .09965 L
.03903 .10002 L
.03905 .10035 L
.03911 .10161 L
.03916 .10276 L
.03919 .10337 L
.03922 .10369 L
.03924 .10383 L
.03927 .10399 L
.0393 .10347 L
.03932 .10066 L
Mistroke
.03935 .09708 L
.03938 .09375 L
.03941 .09253 L
.03943 .09209 L
.03945 .09163 L
.0395 .08984 L
.03953 .08859 L
.03956 .08727 L
.03958 .08653 L
.0396 .08828 L
.03963 .0915 L
.0397 .09831 L
.03976 .10589 L
.03982 .11188 L
.03985 .11472 L
.03988 .11538 L
.0399 .11375 L
.03991 .11222 L
.03994 .10936 L
.04001 .10221 L
.04003 .09882 L
.04006 .09631 L
.04009 .09864 L
.04012 .10081 L
.04014 .10311 L
.04017 .1019 L
.0402 .09785 L
.04023 .09401 L
.04026 .09233 L
.04029 .09451 L
.04032 .09671 L
.04035 .09884 L
.04036 .09806 L
.04038 .09735 L
.04041 .09596 L
.04043 .09523 L
.04045 .095 L
.04046 .09565 L
.04048 .09635 L
.04055 .09894 L
.04058 .10046 L
.04059 .10127 L
.04061 .10212 L
.04063 .10286 L
.04064 .10463 L
.04067 .10831 L
.0407 .11188 L
.04073 .11507 L
.04076 .11554 L
.04079 .11597 L
Mistroke
.04082 .1164 L
.04084 .1154 L
.04087 .11371 L
.0409 .11217 L
.04093 .11223 L
.04095 .11411 L
.04101 .11837 L
.04104 .12153 L
.04107 .1246 L
.04109 .12736 L
.04112 .1281 L
.04115 .12608 L
.04118 .12421 L
.04121 .12333 L
.04123 .12443 L
.04125 .12565 L
.04126 .12676 L
.04128 .12798 L
.04131 .12919 L
.04133 .12868 L
.04135 .12821 L
.04136 .12775 L
.04138 .12731 L
.0414 .1269 L
.04141 .1244 L
.04144 .11986 L
.04147 .11501 L
.04149 .11226 L
.04151 .11269 L
.04153 .11443 L
.04157 .1163 L
.04158 .11732 L
.0416 .11743 L
.04163 .1171 L
.04166 .11681 L
.04169 .11638 L
.04172 .11385 L
.04175 .11151 L
.04177 .10928 L
.0418 .11078 L
.04183 .11345 L
.04186 .11594 L
.04189 .11689 L
.04191 .11662 L
.04194 .11634 L
.04197 .11603 L
.042 .11585 L
.04203 .11569 L
.04206 .11553 L
.04208 .11719 L
Mistroke
.0421 .11965 L
.04221 .13611 L
.04242 .15848 L
.04248 .16232 L
.04251 .16398 L
.04253 .1655 L
.04256 .16938 L
.04259 .17554 L
.04261 .17883 L
.04262 .18234 L
.04265 .18479 L
.04268 .18019 L
.04272 .17516 L
.04273 .17243 L
.04275 .17412 L
.04277 .17659 L
.04278 .17928 L
.04281 .18422 L
.04283 .1867 L
.04285 .1861 L
.04288 .18286 L
.0429 .17982 L
.04293 .17742 L
.04296 .17916 L
.04299 .18074 L
.04302 .18243 L
.04305 .18305 L
.04308 .18336 L
.04309 .18355 L
.04311 .18373 L
.04314 .18595 L
.04335 .20683 L
.04359 .23463 L
.04381 .27146 L
.04406 .30469 L
.04409 .30913 L
.04413 .31595 L
.04414 .31907 L
.04416 .32239 L
.04418 .3232 L
.0442 .32245 L
.04423 .32108 L
.04424 .32036 L
.04426 .3196 L
.04428 .3197 L
.04429 .32006 L
.04432 .3207 L
.04434 .32107 L
.04436 .32141 L
.04438 .3272 L
Mistroke
.04442 .33511 L
.04443 .33858 L
.04445 .3424 L
.04448 .34589 L
.04451 .3491 L
.04457 .35554 L
.04469 .36673 L
.04481 .37734 L
.04487 .38544 L
.04494 .39606 L
.04506 .41119 L
.04509 .41475 L
.04512 .4186 L
.04515 .42031 L
.04518 .42176 L
.04521 .42346 L
.04522 .42304 L
.04524 .42014 L
.04527 .41503 L
.0453 .41037 L
.04533 .4097 L
.04535 .41304 L
.04539 .41687 L
.04541 .41991 L
.04544 .42018 L
.04546 .42047 L
.04549 .42075 L
.04552 .42082 L
.04555 .42066 L
.04558 .42051 L
.04561 .42166 L
.04562 .42484 L
.04564 .42772 L
.04567 .43356 L
.04569 .43664 L
.0457 .4385 L
.04573 .4385 L
.04576 .4385 L
.04579 .4385 L
.04582 .44011 L
.04584 .44157 L
.04587 .44317 L
.0459 .44724 L
.04593 .45369 L
.04596 .4595 L
.04599 .46442 L
.04602 .46074 L
.04605 .45728 L
.04606 .45527 L
.04608 .45345 L
Mistroke
.04611 .45276 L
.04613 .45241 L
.04615 .45204 L
.04618 .45237 L
.0462 .4577 L
.04621 .46274 L
.04623 .46723 L
.04625 .47217 L
.04628 .47725 L
.04631 .47256 L
.04636 .46413 L
.04649 .44656 L
.04675 .4255 L
.04681 .42283 L
.04687 .42052 L
.04691 .41965 L
.04694 .41877 L
.04696 .41045 L
.04699 .40145 L
.04702 .39255 L
.04705 .38897 L
.04708 .38835 L
.04711 .38768 L
.04714 .3846 L
.04716 .37572 L
.04721 .35576 L
.04727 .33647 L
.04731 .3265 L
.04732 .32178 L
.04734 .31922 L
.0474 .31029 L
.04746 .30005 L
.04769 .26511 L
.04781 .24403 L
.04784 .23725 L
.04788 .23002 L
.04789 .22651 L
.04791 .22485 L
.04794 .22198 L
.04796 .21942 L
.04799 .21699 L
.04802 .21748 L
.04805 .21794 L
.04811 .21897 L
.04814 .21947 L
.04817 .21993 L
.0482 .21675 L
.04822 .21217 L
.04825 .20727 L
.04827 .20205 L
Mistroke
.0483 .20328 L
.04833 .20455 L
.04839 .20771 L
.04842 .20983 L
.04845 .2118 L
.04848 .21001 L
.0485 .2071 L
.04852 .20399 L
.04853 .20134 L
.04855 .19845 L
.04858 .19492 L
.04861 .19269 L
.04864 .19063 L
.04877 .1778 L
.0489 .15941 L
.04901 .1479 L
.04908 .14191 L
.04911 .13896 L
.04913 .13622 L
.04915 .13679 L
.04917 .13743 L
.04919 .13813 L
.0492 .13879 L
.04922 .13939 L
.04924 .13926 L
.04927 .13635 L
.0493 .1333 L
.04931 .13164 L
.04933 .13053 L
.04936 .13068 L
.04939 .13085 L
.04942 .13101 L
.04943 .13095 L
.04945 .13086 L
.04948 .13069 L
.04951 .13054 L
.04952 .13003 L
.04954 .12904 L
.04958 .12695 L
.04961 .12515 L
.04962 .12475 L
.04964 .12466 L
.04967 .12449 L
.0497 .12433 L
.04973 .1251 L
.04975 .12633 L
.04979 .12768 L
.0498 .12836 L
.04982 .1286 L
.04985 .12893 L
Mistroke
.04988 .12924 L
.04991 .12879 L
.04994 .12585 L
.04996 .12315 L
.04999 .12071 L
.05002 .11897 L
.05005 .11742 L
.05011 .11378 L
.05016 .10868 L
.05019 .10615 L
.05022 .106 L
.05024 .10586 L
.05027 .10573 L
.0503 .1062 L
.05032 .10741 L
.05035 .10872 L
.05037 .10938 L
.05039 .10824 L
.05042 .10175 L
.05044 .09566 L
.05046 .09217 L
.05048 .08896 L
.05051 .08748 L
.05057 .08365 L
.05081 .07025 L
.05092 .06207 L
.05095 .05998 L
.05097 .05874 L
.051 .05777 L
.05103 .05675 L
.05106 .05601 L
.05108 .05616 L
.0511 .05625 L
.05112 .05634 L
.05115 .05643 L
.05117 .05613 L
.0512 .05585 L
.05123 .05553 L
.05126 .05364 L
.05131 .04911 L
.05137 .04511 L
.0514 .04316 L
.05143 .04171 L
.05146 .04607 L
.05149 .05067 L
.05152 .05514 L
.05155 .05624 L
.05158 .05656 L
.05161 .05685 L
.05164 .05589 L
Mistroke
.05166 .05482 L
.05167 .05384 L
.0517 .05203 L
.05172 .05137 L
.05174 .05173 L
.05176 .05231 L
.05179 .05295 L
.05182 .05367 L
.05185 .05466 L
.05188 .05579 L
.05189 .05642 L
.05191 .05701 L
.05194 .05877 L
.05196 .06037 L
.05199 .06191 L
.05202 .06308 L
.05204 .06372 L
.05207 .06441 L
.0521 .06516 L
.05213 .06187 L
.05215 .05816 L
.05218 .05469 L
.05221 .05355 L
.05222 .05515 L
.05224 .05688 L
.05227 .06017 L
.05229 .06183 L
.05231 .0624 L
.05234 .06292 L
.05237 .0634 L
.05239 .06337 L
.05242 .06182 L
.05246 .06 L
.05248 .05896 L
.05249 .05882 L
.05251 .05925 L
.05253 .05972 L
.05255 .06021 L
.05256 .06066 L
.05259 .06331 L
.05261 .06602 L
.05263 .0686 L
.05266 .07318 L
.05267 .07577 L
.05269 .07433 L
.05272 .07003 L
.05274 .06777 L
.05275 .06539 L
.05278 .06282 L
.05281 .06313 L
Mistroke
.05284 .06341 L
.05287 .06371 L
.0529 .06787 L
.05292 .07198 L
.05317 .10375 L
.0532 .10872 L
.05322 .11146 L
.05323 .11407 L
.05326 .11611 L
.05329 .11536 L
.05332 .11459 L
.05335 .11484 L
.05337 .11688 L
.05339 .11905 L
.05342 .12296 L
.05356 .1442 L
.05359 .15316 L
.05361 .15805 L
.05362 .16262 L
.05365 .16583 L
.05367 .16633 L
.05368 .16687 L
.0537 .16742 L
.05372 .16793 L
.05375 .17084 L
.05378 .17561 L
.0538 .17771 L
.05381 .18003 L
.05384 .18241 L
.05387 .18422 L
.05389 .18519 L
.05391 .18622 L
.05394 .18733 L
.05396 .18793 L
.05399 .18857 L
.05401 .18891 L
.05403 .18833 L
.05406 .18674 L
.05409 .18512 L
.05411 .184 L
.05414 .1851 L
.05417 .1863 L
.0542 .18758 L
.05422 .19262 L
.05425 .20005 L
.05429 .20815 L
.05431 .2137 L
.05434 .21662 L
.05439 .22241 L
.05464 .25937 L
Mistroke
.05515 .35327 L
.0556 .44179 L
.05573 .46664 L
.05584 .49043 L
.0559 .49953 L
.05591 .50216 L
.05593 .50348 L
.05596 .5022 L
.05599 .50088 L
.05601 .50022 L
.05602 .5001 L
.05604 .50418 L
.05606 .508 L
.05609 .5153 L
.05611 .51909 L
.05612 .52081 L
.05614 .52081 L
.05616 .52081 L
.05619 .52081 L
.05621 .52081 L
.05622 .52216 L
.05625 .5271 L
.05629 .53232 L
.0563 .53504 L
.05632 .5354 L
.05634 .5355 L
.05636 .53559 L
.05638 .53568 L
.05639 .53576 L
.05642 .53662 L
.05645 .53799 L
.05649 .53948 L
.05655 .54271 L
.05658 .54436 L
.05661 .54666 L
.05664 .55017 L
.05665 .55198 L
.05667 .55396 L
.0567 .55414 L
.05673 .54868 L
.05676 .54274 L
.05678 .5394 L
.0568 .53955 L
.05681 .54114 L
.05683 .54287 L
.05686 .54601 L
.05689 .54725 L
.05692 .54239 L
.05698 .53251 L
.05709 .51183 L
Mistroke
.05806 .35948 L
.0585 .30722 L
.05874 .2777 L
.05877 .27098 L
.05879 .26731 L
.0588 .26597 L
.05882 .26507 L
.05884 .26407 L
.05887 .26233 L
.05893 .25811 L
.05896 .25615 L
.05899 .25457 L
.05901 .25429 L
.05902 .25402 L
.05906 .25349 L
.05907 .25322 L
.05909 .25412 L
.05913 .25632 L
.05916 .25817 L
.05918 .25818 L
.05919 .25619 L
.05925 .24864 L
.05931 .24042 L
.05934 .23634 L
.05937 .23414 L
.0594 .23446 L
.05943 .23479 L
.05945 .23496 L
.05947 .23468 L
.05948 .23387 L
.0595 .23313 L
.05998 .20616 L
.06022 .19217 L
.06047 .17381 L
.0605 .1732 L
.06053 .17093 L
.06055 .16905 L
.06056 .16734 L
.06059 .16402 L
.06062 .16183 L
.06065 .16031 L
.06068 .15887 L
.06071 .15883 L
.06073 .16177 L
.06076 .16451 L
.06079 .16751 L
.06081 .16843 L
.06084 .16778 L
.06087 .16716 L
.0609 .16708 L
Mistroke
.06093 .16858 L
.06095 .17005 L
.06098 .17163 L
.06101 .16889 L
.06104 .16548 L
.06106 .16173 L
.06109 .15827 L
.06111 .15699 L
.06113 .15583 L
.06116 .15355 L
.06119 .15175 L
.06122 .15193 L
.06124 .15207 L
.06128 .15224 L
.06131 .14975 L
.06134 .14704 L
.0614 .14201 L
.06151 .12842 L
.06154 .12264 L
.06157 .11889 L
.0616 .1199 L
.06163 .12101 L
.06165 .12196 L
.06168 .12062 L
.06171 .11841 L
.06174 .11634 L
.06176 .11509 L
.06178 .11547 L
.06181 .11589 L
.06184 .11633 L
.06187 .11472 L
.0619 .11189 L
.06195 .10678 L
.06198 .10461 L
.06201 .10232 L
.06204 .10053 L
.06207 .10153 L
.06213 .10331 L
.06216 .10439 L
.06219 .10546 L
.06221 .10646 L
.06224 .10611 L
.06227 .10285 L
.06229 .09982 L
.06236 .09175 L
.06239 .0878 L
.06242 .08417 L
.06244 .08318 L
.06247 .08287 L
.0625 .08256 L
Mistroke
.06253 .08345 L
.06255 .08495 L
.06257 .08636 L
.0626 .08902 L
.06266 .09469 L
.06273 .09947 L
.06276 .10133 L
.06279 .10304 L
.06281 .10423 L
.06284 .10468 L
.06287 .10513 L
.0629 .10561 L
.06293 .10434 L
.06296 .10299 L
.06302 .09932 L
.06305 .09692 L
.06307 .09565 L
.06309 .09431 L
.0631 .0948 L
.06312 .09702 L
.06315 .10094 L
.06318 .10474 L
.06321 .10684 L
.06324 .1078 L
.06327 .10869 L
.06329 .10883 L
.06332 .10742 L
.06335 .10619 L
.06338 .10487 L
.06339 .10518 L
.06341 .10593 L
.06344 .1074 L
.06347 .10874 L
.06349 .1087 L
.06352 .10786 L
.06355 .10697 L
.06357 .10617 L
.0636 .10604 L
.06362 .10589 L
.06365 .10572 L
.06368 .10652 L
.06371 .10794 L
.06377 .11109 L
.06382 .11516 L
.06385 .11741 L
.06387 .11752 L
.06388 .11642 L
.06391 .11437 L
.06394 .11243 L
.06397 .11171 L
Mistroke
.064 .11264 L
.06402 .11342 L
.06405 .11428 L
.06408 .11334 L
.06411 .11189 L
.06416 .10882 L
.06419 .10603 L
.06421 .10455 L
.06422 .10298 L
.06425 .101 L
.06428 .101 L
.06432 .101 L
.06433 .101 L
.06435 .10408 L
.06438 .11181 L
.06442 .12014 L
.06444 .1264 L
.06448 .13036 L
.06451 .13422 L
.06452 .13638 L
.06454 .13622 L
.06457 .13274 L
.0646 .12947 L
.06465 .12395 L
.06478 .11015 L
.06483 .10156 L
.06489 .09454 L
.06492 .09126 L
.06494 .09216 L
.06497 .09312 L
.06501 .09414 L
.06502 .09609 L
.06504 .09824 L
.06507 .10243 L
.06508 .10478 L
.0651 .10733 L
.06512 .10695 L
.06514 .1061 L
.06524 .09587 L
.06527 .09194 L
.0653 .08796 L
.06532 .08682 L
.06535 .08555 L
.06538 .08421 L
.06541 .08326 L
.06542 .08308 L
.06544 .08291 L
.06547 .08259 L
.06549 .08243 L
.06552 .08288 L
Mistroke
.06555 .08335 L
.06558 .08378 L
.06561 .08577 L
.06564 .08805 L
.0657 .09188 L
.06573 .09219 L
.06576 .09251 L
.06578 .09361 L
.06581 .09715 L
.06592 .11074 L
.06603 .12684 L
.06609 .1363 L
.06613 .14105 L
.06615 .14544 L
.06617 .14616 L
.06619 .14635 L
.06622 .14674 L
.06625 .14704 L
.06627 .14574 L
.06629 .14451 L
.06632 .14229 L
.06635 .13995 L
.06637 .14036 L
.0664 .14098 L
.06643 .14166 L
.06645 .14288 L
.06647 .1452 L
.06653 .15396 L
.06664 .1679 L
.06677 .17955 L
.06679 .18249 L
.06682 .1853 L
.06685 .18732 L
.06687 .18859 L
.0669 .18999 L
.06693 .19097 L
.06696 .19066 L
.06699 .19036 L
.06702 .19004 L
.06704 .19033 L
.06705 .19059 L
.06708 .19107 L
.0671 .19132 L
.06711 .19156 L
.06714 .18968 L
.06717 .18793 L
.0672 .18592 L
.06723 .18591 L
.06725 .18634 L
.06726 .18681 L
Mistroke
.06729 .18763 L
.06731 .18729 L
.06733 .18506 L
.06736 .17998 L
.06743 .17127 L
.06746 .16733 L
.06749 .16374 L
.06752 .16401 L
.06754 .16599 L
.06757 .16811 L
.0676 .17095 L
.06763 .17597 L
.06766 .1806 L
.06769 .18545 L
.06771 .18649 L
.06772 .18746 L
.06779 .19158 L
.06782 .19425 L
.06785 .19673 L
.06788 .19885 L
.06791 .19917 L
.06794 .19949 L
.06796 .19966 L
.06797 .19983 L
.068 .19605 L
.06803 .19215 L
.06806 .18848 L
.06808 .18881 L
.06811 .19323 L
.06814 .19797 L
.06819 .20463 L
.06842 .24752 L
.06848 .25637 L
.06851 .26078 L
.06854 .26492 L
.06857 .26361 L
.0686 .26093 L
.06862 .25948 L
.06863 .25796 L
.06866 .25875 L
.06868 .26066 L
.06869 .26239 L
.06871 .26425 L
.06873 .26627 L
.06876 .26799 L
.06879 .26848 L
.06881 .26877 L
.06882 .26905 L
.06884 .26948 L
.06886 .27022 L
Mistroke
.06889 .27143 L
.06891 .27207 L
.06893 .27275 L
.06894 .27593 L
.06896 .28008 L
.06899 .2874 L
.06905 .30098 L
.06908 .30668 L
.06911 .31283 L
.06914 .31663 L
.06916 .31816 L
.06919 .31983 L
.06922 .32191 L
.06924 .32584 L
.06925 .32941 L
.06928 .33638 L
.06932 .34337 L
.06933 .34483 L
.06935 .34617 L
.06938 .34877 L
.06941 .35145 L
.06944 .35569 L
.06947 .36032 L
.06952 .3701 L
.06958 .38402 L
.06964 .40005 L
.06967 .40816 L
.0697 .4123 L
.06973 .40796 L
.06976 .40327 L
.06978 .3988 L
.06981 .40228 L
.06984 .4076 L
.06986 .41344 L
.06993 .42713 L
.06996 .43372 L
.06999 .43943 L
.07 .44119 L
.07002 .44305 L
.07006 .44698 L
.07009 .45081 L
.07012 .45675 L
.07015 .46193 L
.07018 .46614 L
.07019 .46519 L
.07021 .46415 L
.07024 .46233 L
.07027 .46099 L
.0703 .46351 L
.07033 .46585 L
Mistroke
.07036 .46805 L
.07039 .46478 L
.0704 .4623 L
.07042 .45964 L
.07044 .45686 L
.07045 .45421 L
.07049 .45745 L
.07054 .46579 L
.0706 .47365 L
.07062 .47589 L
.07064 .478 L
.07067 .47435 L
.0707 .46701 L
.07073 .45909 L
.0708 .44294 L
.07082 .43857 L
.07083 .43444 L
.07085 .4313 L
.07087 .42966 L
.07093 .42383 L
.07099 .41836 L
.07101 .41691 L
.07103 .41537 L
.07106 .41591 L
.07107 .41681 L
.07109 .41765 L
.07111 .41857 L
.07112 .41957 L
.07115 .41987 L
.07118 .41987 L
.07121 .41987 L
.07124 .41884 L
.07127 .4157 L
.07129 .41285 L
.07131 .41127 L
.07133 .41027 L
.07136 .41189 L
.07138 .41346 L
.07141 .41494 L
.07143 .41493 L
.07144 .41448 L
.07147 .41369 L
.0715 .41293 L
.07153 .40763 L
.07156 .40066 L
.07158 .39296 L
.07165 .37924 L
.07168 .37322 L
.0717 .36994 L
.07171 .36867 L
Mistroke
.07174 .36883 L
.07176 .36893 L
.07178 .36901 L
.0718 .36819 L
.07183 .36272 L
.0721 .32005 L
.07221 .30421 L
.07224 .29553 L
.07227 .28729 L
.07229 .28569 L
.07231 .28481 L
.07234 .28328 L
.07237 .28187 L
.0724 .28252 L
.07243 .28347 L
.07246 .28433 L
.07248 .28447 L
.07251 .28384 L
.07256 .2827 L
.07262 .28004 L
.07265 .27854 L
.07268 .27851 L
.07269 .27893 L
.07271 .2794 L
.07274 .28024 L
.07277 .27894 L
.0728 .27615 L
.07283 .27307 L
.07286 .26923 L
.07289 .2637 L
.07293 .25761 L
.07296 .25186 L
.073 .24622 L
.07303 .24141 L
.07305 .23926 L
.07306 .23952 L
.07309 .23999 L
.07312 .24043 L
.07315 .24053 L
.07318 .23992 L
.07321 .23929 L
.07324 .23837 L
.07325 .23646 L
.07327 .23436 L
.0733 .23067 L
.07336 .22418 L
.07339 .22108 L
.07341 .21938 L
.07343 .21803 L
.07346 .21866 L
Mistroke
.07349 .21936 L
.07352 .21996 L
.07355 .21584 L
.07357 .21089 L
.0736 .20629 L
.07363 .20401 L
.07366 .20401 L
.07369 .20401 L
.07371 .20416 L
.07374 .20585 L
.07377 .20745 L
.07401 .22076 L
.07404 .21835 L
.07408 .2161 L
.07409 .21497 L
.07411 .2193 L
.07415 .22946 L
.07416 .23391 L
.07418 .23876 L
.0742 .23912 L
.07421 .2347 L
.07424 .22647 L
.07427 .21744 L
.0743 .21194 L
.07432 .2102 L
.07433 .20858 L
.07436 .20567 L
.07439 .20684 L
.07441 .21024 L
.07443 .21393 L
.07444 .21719 L
.07446 .22065 L
.07448 .22313 L
.07449 .22295 L
.07452 .22262 L
.07455 .22231 L
.07458 .22129 L
.07461 .21886 L
.07464 .21619 L
.07467 .21414 L
.07469 .21537 L
.0747 .21649 L
.07474 .21867 L
.07476 .22057 L
.07479 .22057 L
.07482 .22057 L
.07485 .22057 L
.07487 .21945 L
.07488 .2175 L
.07499 .19992 L
Mistroke
.07521 .17524 L
.07524 .16813 L
.07527 .16493 L
.0753 .16124 L
.07533 .1579 L
.07535 .15659 L
.07536 .15557 L
.0754 .15328 L
.07543 .15129 L
.07544 .15144 L
.07546 .15171 L
.07549 .15221 L
.07552 .15268 L
.07554 .1523 L
.07555 .15155 L
.07558 .15025 L
.07561 .149 L
.07564 .14933 L
.07567 .15018 L
.0757 .15111 L
.07573 .15126 L
.07576 .15004 L
.07578 .14894 L
.07581 .14776 L
.07584 .14317 L
.07587 .13841 L
.0759 .13324 L
.07591 .13091 L
.07593 .13049 L
.07596 .12973 L
.07599 .12892 L
.07601 .12865 L
.07604 .12943 L
.07607 .13012 L
.07609 .13086 L
.07612 .13047 L
.07614 .12983 L
.07617 .12906 L
.0762 .12873 L
.07623 .12984 L
.07626 .13085 L
.07629 .13193 L
.07632 .12902 L
.07635 .12549 L
.07637 .12355 L
.07638 .12171 L
.07641 .12417 L
.07644 .12741 L
.07646 .13048 L
.07649 .13326 L
Mistroke
.07652 .13418 L
.07654 .13504 L
.07657 .13596 L
.0766 .13581 L
.07662 .13555 L
.07664 .13527 L
.07667 .13476 L
.0767 .13181 L
.07673 .1284 L
.07674 .12648 L
.07676 .12442 L
.07679 .12256 L
.07681 .12196 L
.07683 .1214 L
.07686 .12035 L
.07689 .11866 L
.07692 .11661 L
.07695 .11469 L
.07698 .11679 L
.07701 .12239 L
.07704 .12769 L
.0771 .13772 L
.07713 .14159 L
.07716 .14511 L
.07719 .14572 L
.07721 .14628 L
.07724 .14689 L
.07727 .14369 L
.0773 .1389 L
.07733 .13455 L
.07735 .1335 L
.07737 .13475 L
.0774 .13702 L
.07746 .14214 L
.07752 .14674 L
.07753 .148 L
.07755 .1486 L
.07758 .14958 L
.07761 .15056 L
.07764 .15043 L
.07766 .1481 L
.07769 .14557 L
.07772 .14285 L
.07775 .14459 L
.07778 .14679 L
.07781 .14922 L
.07784 .15009 L
.07786 .14995 L
.07789 .1498 L
.07792 .14982 L
Mistroke
.07795 .15216 L
.07797 .15434 L
.07802 .15943 L
.07847 .19177 L
.07871 .21479 L
.07874 .21929 L
.07877 .22356 L
.07879 .22518 L
.07881 .22617 L
.07884 .22792 L
.0789 .23134 L
.07893 .23344 L
.07896 .23541 L
.07898 .23528 L
.07899 .23275 L
.07903 .22834 L
.07905 .22424 L
.07907 .22225 L
.07909 .22108 L
.07912 .21839 L
.07914 .2169 L
.07916 .21555 L
.07918 .21595 L
.07919 .21655 L
.07923 .21786 L
.07926 .21898 L
.07929 .21753 L
.07931 .2162 L
.07934 .21476 L
.07937 .21537 L
.0794 .21665 L
.07942 .21739 L
.07944 .21817 L
.07945 .21924 L
.07947 .22088 L
.0795 .22408 L
.07953 .22709 L
.07956 .22717 L
.07959 .2262 L
.07963 .22514 L
.07964 .22471 L
.07966 .22471 L
.07969 .22471 L
.07972 .22471 L
.07975 .22702 L
.07978 .23069 L
.0798 .23272 L
.07981 .23489 L
.07984 .23741 L
.07987 .23803 L
Mistroke
.0799 .23858 L
.07993 .23907 L
.07996 .23659 L
.08001 .23188 L
.08007 .22661 L
.08008 .22504 L
.0801 .22355 L
.08013 .22301 L
.08016 .22471 L
.08019 .22655 L
.08025 .23005 L
.08029 .23191 L
.0803 .23281 L
.08032 .23326 L
.08035 .23385 L
.08038 .23448 L
.08041 .23465 L
.08042 .23283 L
.08044 .23083 L
.08047 .22755 L
.08049 .22447 L
.08052 .22478 L
.08055 .22638 L
.08058 .22799 L
.08059 .22881 L
.08061 .22798 L
.08064 .22638 L
.08067 .22489 L
.08069 .22301 L
.08072 .21738 L
.08078 .20548 L
.08083 .19651 L
.08085 .19193 L
.08088 .18801 L
.08091 .19676 L
.08094 .20479 L
.08097 .21232 L
.081 .21123 L
.08102 .20939 L
.08103 .20772 L
.08107 .20397 L
.08113 .19844 L
.08116 .1961 L
.08119 .19432 L
.08122 .19279 L
.08125 .19138 L
.08127 .19273 L
.0813 .1983 L
.08133 .20487 L
.08135 .21097 L
Mistroke
.08139 .21371 L
.08142 .2161 L
.08148 .22059 L
.08151 .22277 L
.08154 .22482 L
.08157 .22461 L
.0816 .22292 L
.08163 .22102 L
.08165 .22007 L
.08166 .22213 L
.08172 .22929 L
.08176 .23297 L
.08179 .23649 L
.08181 .23819 L
.08183 .23981 L
.08186 .2403 L
.08189 .23969 L
.08192 .23905 L
.08193 .23871 L
.08195 .24016 L
.08198 .24289 L
.08203 .24783 L
.08209 .25256 L
.08211 .2539 L
.08212 .25516 L
.08215 .25225 L
.08218 .24928 L
.08221 .24613 L
.08222 .24505 L
.08224 .24569 L
.08227 .24681 L
.08234 .24888 L
.08236 .24932 L
.08239 .2498 L
.08242 .2506 L
.08245 .25186 L
.08248 .25331 L
.08249 .25411 L
.08251 .25512 L
.08254 .25963 L
.08257 .26371 L
.08267 .27643 L
.08273 .28194 L
.08275 .284 L
.08278 .28624 L
.08281 .28726 L
.08284 .28711 L
.08285 .28703 L
.08287 .28694 L
.0829 .28586 L
Mistroke
.08293 .28306 L
.08295 .28043 L
.08298 .27755 L
.08301 .277 L
.08304 .277 L
.08307 .277 L
.08308 .27678 L
.0831 .27559 L
.08313 .27353 L
.08315 .27232 L
.08316 .27104 L
.08318 .27036 L
.0832 .27073 L
.08323 .27144 L
.08326 .27209 L
.08328 .27305 L
.08329 .27501 L
.08333 .27933 L
.0834 .28714 L
.08352 .30857 L
.08358 .31876 L
.08361 .32275 L
.08364 .3265 L
.08367 .32748 L
.08369 .32677 L
.08371 .326 L
.08374 .32463 L
.08377 .32601 L
.08422 .34167 L
.08429 .33512 L
.0843 .33313 L
.08432 .33127 L
.08434 .33033 L
.08435 .32962 L
.08442 .32713 L
.08445 .32612 L
.08448 .32517 L
.08451 .32424 L
.08454 .33076 L
.08457 .3379 L
.0846 .34436 L
.08463 .34908 L
.08464 .35027 L
.08466 .35139 L
.08472 .35527 L
.08478 .35806 L
.0848 .35928 L
.08484 .35911 L
.08486 .35896 L
.08489 .35881 L
Mistroke
.08492 .35677 L
.08494 .35461 L
.08498 .3519 L
.085 .34697 L
.08504 .33822 L
.08507 .32893 L
.08513 .31445 L
.08516 .30857 L
.08519 .30422 L
.08522 .3083 L
.08525 .31259 L
.08526 .31486 L
.08528 .31666 L
.08531 .31465 L
.08534 .31262 L
.08537 .3107 L
.0854 .31092 L
.08543 .31123 L
.08544 .3114 L
.08546 .31158 L
.08548 .30938 L
.0855 .3048 L
.08553 .29497 L
.08555 .29014 L
.08557 .28579 L
.0856 .2851 L
.08563 .28435 L
.08566 .28372 L
.08569 .28355 L
.08572 .28339 L
.08575 .28324 L
.08578 .28021 L
.08581 .27595 L
.08584 .27232 L
.08586 .27049 L
.08589 .27112 L
.08592 .27169 L
.08595 .27233 L
.08598 .27401 L
.086 .27546 L
.08603 .27703 L
.08606 .27439 L
.08609 .27029 L
.08616 .26286 L
.08627 .25628 L
.0863 .25404 L
.08633 .25167 L
.08636 .24745 L
.08639 .24288 L
.08641 .23884 L
Mistroke
.08644 .23624 L
.08647 .23484 L
.08649 .23356 L
.08652 .23212 L
.08654 .225 L
.08657 .21634 L
.0866 .20715 L
.08663 .20064 L
.08666 .19811 L
.08669 .19539 L
.08671 .19384 L
.08672 .19588 L
.08675 .20001 L
.08678 .20436 L
.08681 .20769 L
.08684 .20565 L
.08687 .20341 L
.08689 .20218 L
.08691 .20052 L
.08692 .19811 L
.08694 .19549 L
.08697 .19092 L
.08703 .18037 L
.08707 .1747 L
.08709 .17151 L
.08711 .17111 L
.08712 .17136 L
.08714 .17163 L
.08717 .17213 L
.0872 .17204 L
.08723 .17112 L
.08725 .17057 L
.08726 .17006 L
.08729 .16983 L
.08731 .17101 L
.08732 .17209 L
.08734 .17327 L
.08736 .17453 L
.08739 .17559 L
.08741 .17361 L
.08744 .17146 L
.08747 .16913 L
.08749 .16948 L
.0875 .17032 L
.08753 .17196 L
.08756 .17345 L
.08759 .17231 L
.08762 .1698 L
.08765 .16706 L
.08771 .16117 L
Mistroke
.08773 .15824 L
.08776 .1555 L
.08779 .15743 L
.08781 .15918 L
.08785 .16139 L
.08787 .16136 L
.08791 .16016 L
.08792 .15955 L
.08794 .1589 L
.08797 .15855 L
.088 .1587 L
.08801 .15879 L
.08803 .15887 L
.08806 .15984 L
.08816 .16775 L
.08819 .16953 L
.08821 .1714 L
.08824 .17297 L
.08827 .1737 L
.08833 .17537 L
.08839 .17746 L
.08841 .17851 L
.08844 .17926 L
.08847 .17959 L
.0885 .17988 L
.08853 .18019 L
.08855 .1755 L
.08858 .17133 L
.08861 .16684 L
.08864 .1652 L
.08867 .1661 L
.08868 .16665 L
.0887 .16718 L
.08873 .16532 L
.08876 .15921 L
.08879 .15271 L
.08882 .14886 L
.08885 .15161 L
.08891 .1585 L
.08894 .16182 L
.08898 .16547 L
.089 .16859 L
.08903 .16816 L
.08906 .16743 L
.08908 .16664 L
.08911 .16577 L
.08915 .16474 L
.08918 .16377 L
.0892 .16351 L
.08923 .16491 L
Mistroke
.08926 .16645 L
.08929 .16805 L
.08932 .16829 L
.08934 .16829 L
.08936 .16829 L
.08939 .16798 L
.08942 .16417 L
.08945 .16 L
.08946 .1578 L
.08948 .15548 L
.08951 .15567 L
.08954 .15658 L
.08956 .15745 L
.08959 .15733 L
.08962 .15569 L
.08965 .15392 L
.08968 .15228 L
.0897 .15247 L
.08971 .15265 L
.08973 .15284 L
.08975 .15301 L
.08978 .15356 L
.0898 .15519 L
.08983 .15695 L
.08986 .15883 L
.08989 .16243 L
.09 .18004 L
.09003 .18558 L
.09006 .19145 L
.09008 .19308 L
.09011 .19478 L
.09016 .19844 L
.09022 .20215 L
.09033 .2091 L
.09039 .21344 L
.09041 .21461 L
.09042 .21589 L
.09045 .21686 L
.09049 .21669 L
.09051 .21654 L
.09054 .2167 L
.09057 .21776 L
.0906 .21884 L
.09063 .22 L
.09066 .21976 L
.09068 .21947 L
.09071 .21921 L
.09073 .21961 L
.09076 .22141 L
.09079 .22309 L
Mistroke
.09082 .2251 L
.09084 .2254 L
.09085 .22557 L
.09088 .22589 L
.0909 .22606 L
.09091 .22624 L
.09094 .22822 L
.09097 .23025 L
.091 .23255 L
.09103 .23403 L
.09106 .23504 L
.09108 .23562 L
.09109 .23615 L
.09111 .23653 L
.09113 .23601 L
.09116 .23485 L
.09119 .23385 L
.09122 .23546 L
.09125 .23884 L
.09128 .2424 L
.09131 .24277 L
.09134 .24043 L
.09137 .23787 L
.0914 .23703 L
.09143 .24075 L
.09146 .24424 L
.09151 .2532 L
.09154 .26015 L
.09157 .26749 L
.09159 .27071 L
.09161 .27247 L
.09164 .27556 L
.0917 .28171 L
.09175 .28773 L
.09178 .28994 L
.09181 .28994 L
.09184 .28994 L
.09186 .28994 L
.09189 .28955 L
.09193 .28905 L
.09195 .28858 L
.09198 .28889 L
.09201 .28974 L
.09204 .29063 L
.09206 .29139 L
.09208 .29088 L
.09211 .29013 L
.09214 .28933 L
.09217 .29013 L
.09219 .29273 L
Mistroke
.09222 .2955 L
.09225 .29847 L
.09228 .29606 L
.09231 .29333 L
.09233 .29186 L
.09234 .29027 L
.09238 .28979 L
.09241 .28962 L
.09243 .28947 L
.09246 .28731 L
.09249 .28436 L
.09254 .27769 L
.0926 .27208 L
.09263 .26911 L
.09266 .2676 L
.09269 .26675 L
.09272 .26596 L
.09273 .26579 L
.09275 .2665 L
.09278 .26783 L
.09281 .26899 L
.09284 .26952 L
.09287 .26885 L
.0929 .26823 L
.09293 .26742 L
.09294 .26658 L
.09296 .26581 L
.09299 .26431 L
.09302 .26304 L
.09304 .26322 L
.09305 .26341 L
.09307 .26361 L
.09309 .2638 L
.09311 .26398 L
.09312 .26529 L
.09316 .2687 L
.09319 .27188 L
.09321 .27465 L
.09323 .27548 L
.09325 .27639 L
.09327 .27797 L
.09338 .2822 L
.09344 .28954 L
.09347 .29442 L
.0935 .29791 L
.09352 .29727 L
.09354 .29657 L
.09357 .29534 L
.09359 .29473 L
.0936 .29292 L
Mistroke
.09364 .28909 L
.09365 .28703 L
.09367 .2848 L
.09369 .28269 L
.0937 .2821 L
.09373 .28091 L
.09376 .27979 L
.09379 .27779 L
.09381 .27608 L
.09383 .27424 L
.09386 .27081 L
.09388 .2691 L
.0939 .26843 L
.09393 .26724 L
.09395 .26658 L
.09396 .26596 L
.09398 .26602 L
.094 .26712 L
.09403 .26903 L
.09405 .27095 L
.09409 .27383 L
.09414 .28015 L
.09417 .283 L
.09419 .28372 L
.0942 .28439 L
.09426 .28692 L
.09429 .28809 L
.09432 .28936 L
.09434 .29055 L
.09437 .2903 L
.0944 .28904 L
.09443 .28785 L
.09449 .28474 L
.09452 .28317 L
.09455 .28193 L
.09457 .28357 L
.09458 .28507 L
.09461 .28798 L
.09483 .3064 L
.09489 .31436 L
.09495 .32207 L
.09498 .32478 L
.095 .32735 L
.09503 .32944 L
.09506 .33047 L
.09508 .33156 L
.09511 .33273 L
.09514 .33255 L
.09517 .33208 L
.0952 .33157 L
Mistroke
.09522 .33118 L
.09524 .33048 L
.0953 .32784 L
.09552 .31798 L
.09555 .31713 L
.09558 .31632 L
.09559 .31588 L
.09561 .31337 L
.09564 .30854 L
.09567 .30392 L
.0957 .30161 L
.09573 .3035 L
.09576 .30558 L
.09579 .30786 L
.09581 .30999 L
.09582 .31193 L
.09586 .31575 L
.09588 .31929 L
.0959 .31785 L
.09592 .31601 L
.09595 .31212 L
.09597 .31021 L
.09599 .3094 L
.09602 .31091 L
.09605 .31228 L
.09608 .31374 L
.0961 .31206 L
.09613 .31052 L
.09616 .30872 L
.09618 .30704 L
.09619 .30438 L
.09625 .29432 L
.09631 .28387 L
.09635 .27875 L
.09637 .27676 L
.0964 .27882 L
.09643 .28103 L
.0965 .28717 L
.09653 .28985 L
.09655 .29244 L
.09658 .29102 L
.0966 .28973 L
.09666 .28662 L
.09672 .28397 L
.09674 .28275 L
.09677 .28415 L
.0968 .28569 L
.09683 .28712 L
.09686 .28657 L
.09689 .28554 L
Mistroke
.09694 .28346 L
.09794 .25834 L
.09889 .22496 L
.099 .23328 L
.09902 .23787 L
.09905 .23889 L
.09908 .23387 L
.0991 .22919 L
.09912 .22656 L
.09914 .22415 L
.09917 .22367 L
.09919 .22323 L
.09922 .22276 L
.09925 .22375 L
.09928 .22531 L
.09933 .22823 L
.09936 .23064 L
.09939 .23292 L
.09941 .23418 L
.09943 .23378 L
.09944 .23046 L
.09946 .22738 L
.09949 .22135 L
.09952 .21584 L
.09953 .21491 L
.09955 .2139 L
.09958 .21213 L
.09981 .19414 L
.10029 .14996 L
.10032 .14892 L
.10034 .14835 L
.10035 .14781 L
.10037 .14731 L
.10039 .14579 L
.10041 .1418 L
.10048 .13328 L
.10051 .12965 L
.10053 .12772 L
.10055 .12564 L
.10058 .12562 L
.10061 .12944 L
.10064 .13353 L
.10066 .13559 L
.10068 .13654 L
.10071 .13739 L
.10074 .13818 L
.10076 .13912 L
.10079 .14131 L
.10091 .1479 L
.10094 .14892 L
Mistroke
.10096 .14998 L
.10098 .1512 L
.10101 .15342 L
.10102 .15459 L
.10104 .15584 L
.10106 .15527 L
.10107 .1535 L
.1011 .15002 L
.10118 .14061 L
.10124 .13061 L
.1013 .12234 L
.10133 .11902 L
.10135 .12128 L
.10137 .12375 L
.10144 .13417 L
.10149 .14639 L
.10156 .15683 L
.10159 .161 L
.10162 .16454 L
.10165 .16293 L
.10168 .16118 L
.10171 .15952 L
.10174 .16108 L
.10176 .1637 L
.10179 .16658 L
.10185 .1707 L
.10191 .17403 L
.10194 .17521 L
.10197 .17648 L
.102 .1774 L
.10203 .17368 L
.10206 .1702 L
.10209 .16652 L
.10212 .16619 L
.10215 .16758 L
.10217 .16879 L
.1022 .16992 L
.10223 .1704 L
.10225 .17084 L
.10227 .1711 L
.10229 .17138 L
.10232 .16691 L
.10239 .15611 L
.10242 .14941 L
.10245 .14219 L
.10247 .13886 L
.10249 .13654 L
.10252 .13574 L
.10254 .13502 L
.10257 .13426 L
Mistroke
.1026 .13496 L
.10263 .13589 L
.10269 .13773 L
.10272 .13865 L
.10276 .13951 L
.10279 .14012 L
.10282 .14064 L
.10284 .14093 L
.10285 .1412 L
.10288 .14048 L
.10291 .13921 L
.10294 .13803 L
.10297 .13637 L
.103 .13396 L
.10304 .13133 L
.10306 .12998 L
.10307 .12988 L
.10311 .1297 L
.10312 .12961 L
.10314 .12951 L
.10316 .13036 L
.10317 .13192 L
.1032 .13497 L
.10322 .13661 L
.10324 .13839 L
.10327 .1366 L
.10338 .12426 L
.10341 .12131 L
.10343 .1197 L
.10344 .11877 L
.10347 .11995 L
.1035 .12124 L
.10352 .12198 L
.10353 .12267 L
.10356 .12305 L
.1036 .12343 L
.10361 .1236 L
.10363 .12371 L
.10366 .12138 L
.10369 .11892 L
.1037 .11765 L
.10372 .11626 L
.10375 .11495 L
.10378 .11373 L
.10381 .1126 L
.10384 .11262 L
.10387 .11294 L
.10389 .11312 L
.1039 .11331 L
.10392 .11398 L
Mistroke
.10394 .11524 L
.104 .12016 L
.10423 .13338 L
.10426 .13561 L
.10429 .13771 L
.10431 .13794 L
.10432 .13726 L
.10435 .13608 L
.10438 .13494 L
.10442 .13774 L
.10444 .14127 L
.10447 .14516 L
.1046 .16739 L
.10473 .18855 L
.1057 .31385 L
.10615 .36388 L
.10638 .39884 L
.10644 .40295 L
.10648 .40383 L
.10649 .40428 L
.10651 .40761 L
.10657 .4207 L
.10663 .43044 L
.10667 .43568 L
.10668 .43851 L
.1067 .4386 L
.10673 .43877 L
.10675 .43887 L
.10677 .43896 L
.10679 .43845 L
.1068 .43655 L
.10683 .43319 L
.10686 .42978 L
.10689 .43106 L
.10692 .43477 L
.10696 .43869 L
.10698 .44006 L
.10701 .43879 L
.10704 .43741 L
.10706 .43665 L
.10708 .43624 L
.10709 .436 L
.10711 .43572 L
.10714 .43525 L
.10717 .43599 L
.1072 .44041 L
.10726 .45072 L
.1073 .4586 L
.10733 .46609 L
.10736 .47216 L
Mistroke
.10737 .47388 L
.10739 .47548 L
.10742 .47834 L
.10744 .48104 L
.10747 .48133 L
.1075 .48118 L
.10753 .48101 L
.10756 .47872 L
.10759 .47444 L
.10762 .46993 L
.10765 .46727 L
.10768 .46665 L
.10771 .46596 L
.10774 .46452 L
.10777 .45876 L
.10779 .45335 L
.10782 .44735 L
.10785 .44437 L
.10786 .44371 L
.10788 .44298 L
.10791 .4417 L
.10793 .44108 L
.10795 .44098 L
.10798 .44081 L
.10801 .44064 L
.10804 .43846 L
.10807 .43528 L
.10809 .43185 L
.10812 .42921 L
.10815 .42935 L
.10818 .42952 L
.10821 .42967 L
.10823 .42958 L
.10826 .42943 L
.10829 .42927 L
.10831 .42904 L
.10832 .42655 L
.10843 .41341 L
.10853 .40296 L
.10876 .3718 L
.10883 .35906 L
.10889 .34534 L
.10895 .33605 L
.10901 .32827 L
.10911 .31718 L
.10921 .30908 L
.10944 .29182 L
.1099 .26425 L
.10994 .26289 L
.10997 .25873 L
Mistroke
.11 .25395 L
.11003 .24927 L
.11006 .24271 L
.11009 .23572 L
.11012 .22911 L
.11015 .22886 L
.11018 .22886 L
.11021 .22886 L
.11024 .23133 L
.11025 .23349 L
.11027 .23548 L
.1103 .23939 L
.11032 .24017 L
.11034 .23873 L
.11037 .23585 L
.11039 .23432 L
.11041 .23271 L
.11042 .23199 L
.11044 .23135 L
.11047 .23021 L
.1105 .22906 L
.11053 .23112 L
.11055 .23365 L
.11058 .23631 L
.11061 .23735 L
.11064 .23527 L
.11067 .23301 L
.1107 .23128 L
.11073 .23371 L
.11076 .23593 L
.11077 .23719 L
.11079 .23853 L
.11081 .23887 L
.11082 .23905 L
.11086 .2394 L
.11089 .23972 L
.11091 .23928 L
.11094 .23886 L
.11097 .23842 L
.11099 .23612 L
.11102 .23239 L
.11105 .22841 L
.1111 .22214 L
.11122 .21043 L
.11133 .20249 L
.11136 .20061 L
.11139 .20207 L
.11142 .2043 L
.11146 .20633 L
.11148 .20441 L
Mistroke
.11151 .20207 L
.11157 .19655 L
.11163 .19082 L
.11165 .18925 L
.11167 .18836 L
.1117 .18701 L
.11176 .18426 L
.1118 .18289 L
.11182 .18223 L
.11183 .18162 L
.11186 .17627 L
.11189 .168 L
.11192 .1596 L
.11194 .1553 L
.11195 .15487 L
.11198 .15407 L
.11202 .15322 L
.11204 .15078 L
.11207 .14496 L
.1121 .13945 L
.11213 .13423 L
.11216 .13413 L
.11219 .13413 L
.11221 .13413 L
.11224 .13397 L
.11226 .13368 L
.11229 .13337 L
.11232 .13318 L
.11235 .13443 L
.11238 .13551 L
.1124 .13667 L
.11243 .13567 L
.11246 .13302 L
.11252 .12817 L
.11257 .12951 L
.11259 .13019 L
.11262 .12743 L
.11265 .12177 L
.11268 .11646 L
.11271 .1128 L
.11273 .11549 L
.11277 .11891 L
.11279 .1206 L
.1128 .12129 L
.11283 .11869 L
.11286 .11586 L
.1129 .1137 L
.11292 .11618 L
.11296 .11907 L
.11299 .12167 L
Mistroke
.11302 .11895 L
.11305 .11607 L
.11308 .11319 L
.11309 .11248 L
.11311 .11265 L
.11314 .11295 L
.11316 .11324 L
.11319 .11275 L
.11322 .1114 L
.11334 .10377 L
.1134 .09981 L
.11342 .0983 L
.11345 .09664 L
.11348 .0956 L
.11351 .09514 L
.11354 .09463 L
.11357 .09423 L
.11359 .09414 L
.1136 .09406 L
.11362 .09396 L
.11364 .09387 L
.11367 .09516 L
.11368 .09806 L
.1137 .10112 L
.11373 .10609 L
.11375 .1108 L
.11378 .11365 L
.11381 .11598 L
.11383 .11819 L
.11386 .12002 L
.11389 .12151 L
.11391 .12286 L
.11394 .12435 L
.11397 .12331 L
.114 .12137 L
.11402 .11958 L
.11408 .11666 L
.11411 .11553 L
.11413 .11493 L
.11414 .11417 L
.11416 .1131 L
.11417 .11191 L
.1142 .10983 L
.11423 .10777 L
.11426 .11174 L
.11429 .11554 L
.11431 .11915 L
.11434 .12151 L
.11437 .1221 L
.1144 .12273 L
Mistroke
.11443 .12416 L
.11446 .12785 L
.11449 .13119 L
.11452 .13513 L
.11454 .13554 L
.11455 .1359 L
.11458 .13654 L
.1146 .1369 L
.11462 .13725 L
.11464 .13875 L
.11467 .14012 L
.11472 .143 L
.11477 .14737 L
.11483 .15343 L
.11486 .15743 L
.11489 .16118 L
.11492 .16288 L
.11493 .16263 L
.11495 .16236 L
.11498 .16191 L
.115 .16107 L
.11503 .15945 L
.11506 .15769 L
.11509 .15563 L
.11512 .15723 L
.11515 .1596 L
.11517 .16086 L
.11518 .16221 L
.11521 .1626 L
.11524 .1626 L
.11526 .1626 L
.11527 .1626 L
.1153 .16426 L
.11536 .16877 L
.11538 .1708 L
.11541 .17038 L
.11544 .16987 L
.11547 .16939 L
.1155 .16746 L
.11553 .16508 L
.11556 .16251 L
.11559 .16166 L
.11561 .16175 L
.11562 .16183 L
.11564 .16193 L
.11565 .16202 L
.11567 .16238 L
.11569 .1634 L
.11572 .16554 L
.11576 .1674 L
Mistroke
.11577 .16771 L
.11579 .16762 L
.11582 .16746 L
.11585 .16729 L
.11588 .16789 L
.11591 .16883 L
.11594 .16985 L
.11595 .17058 L
.11597 .17246 L
.11603 .17958 L
.11615 .19182 L
.11618 .19416 L
.11621 .19668 L
.11624 .19924 L
.11627 .20325 L
.1163 .2069 L
.11633 .21087 L
.11635 .21103 L
.11638 .20916 L
.11641 .20696 L
.11643 .20533 L
.11646 .20933 L
.11649 .21374 L
.11652 .21784 L
.11654 .21844 L
.11655 .21836 L
.11659 .21817 L
.11662 .21801 L
.11665 .21651 L
.11667 .2149 L
.1167 .2132 L
.11673 .21263 L
.11677 .21335 L
.1168 .21403 L
.11681 .21423 L
.11683 .2131 L
.11687 .21113 L
.1169 .20926 L
.11692 .20846 L
.11693 .20802 L
.11696 .20717 L
.11699 .20638 L
.11702 .2066 L
.11705 .20753 L
.11708 .20855 L
.11711 .20992 L
.11713 .21184 L
.11716 .21389 L
.11722 .21851 L
.11747 .2377 L
Mistroke
.11797 .2658 L
.11809 .27973 L
.11816 .28745 L
.11822 .29738 L
.11825 .30171 L
.11827 .30113 L
.11829 .3006 L
.11832 .29945 L
.11834 .29888 L
.11836 .29923 L
.11837 .29977 L
.11839 .30026 L
.11841 .30079 L
.11842 .30137 L
.11846 .30074 L
.11849 .29879 L
.11851 .29696 L
.11854 .29405 L
.11856 .29123 L
.11858 .28866 L
.11861 .28362 L
.11864 .28126 L
.11866 .28331 L
.11867 .28521 L
.11869 .28699 L
.11871 .28891 L
.11874 .29111 L
.11877 .29144 L
.1188 .29175 L
.11882 .29186 L
.11885 .28978 L
.11888 .2877 L
.11891 .28546 L
.11892 .28592 L
.11894 .28826 L
.11897 .29283 L
.119 .29686 L
.11902 .29953 L
.11906 .30022 L
.11908 .30086 L
.1191 .3012 L
.11912 .3031 L
.11915 .30802 L
.11918 .31287 L
.11921 .31558 L
.11924 .31187 L
.11926 .30837 L
.11929 .30468 L
.11932 .30311 L
.11935 .30223 L
Mistroke
.11938 .30131 L
.1194 .30144 L
.11943 .30332 L
.11946 .30569 L
.11949 .30766 L
.11952 .30827 L
.11955 .30894 L
.11957 .30931 L
.11959 .30973 L
.1196 .31046 L
.11962 .31128 L
.11965 .31264 L
.11967 .31338 L
.11969 .31375 L
.11972 .31375 L
.11975 .31375 L
.11977 .31375 L
.1198 .31331 L
.11984 .31276 L
.11985 .31249 L
.11987 .31224 L
.1199 .31303 L
.11993 .31403 L
.11996 .315 L
.11999 .31781 L
.12004 .32478 L
.12007 .32765 L
.1201 .32735 L
.12013 .32702 L
.12015 .32683 L
.12016 .32696 L
.12019 .33017 L
.12021 .33312 L
.12024 .33629 L
.12027 .33809 L
.1203 .33881 L
.12032 .33948 L
.12035 .34 L
.12038 .33743 L
.12041 .33457 L
.12043 .33308 L
.12044 .3315 L
.12047 .3255 L
.1205 .31985 L
.12057 .30607 L
.1206 .29766 L
.12062 .29304 L
.12064 .28886 L
.12067 .28753 L
.12069 .28632 L
Mistroke
.12072 .28519 L
.12075 .28194 L
.12078 .27716 L
.1208 .27455 L
.12081 .27211 L
.12084 .27151 L
.12087 .27388 L
.12091 .27629 L
.12094 .27653 L
.12096 .27463 L
.12099 .27256 L
.12101 .2714 L
.12102 .26979 L
.12104 .26743 L
.12106 .26482 L
.12109 .26055 L
.1211 .2583 L
.12112 .25691 L
.12114 .25719 L
.12115 .25744 L
.12117 .25773 L
.12119 .258 L
.1212 .25825 L
.12122 .2582 L
.12125 .25773 L
.12128 .25716 L
.1213 .25687 L
.12132 .25791 L
.12135 .26031 L
.12137 .26149 L
.12139 .26259 L
.12142 .26219 L
.12143 .26089 L
.12145 .25952 L
.12151 .25409 L
.12154 .2494 L
.12155 .24694 L
.12157 .24433 L
.12159 .24205 L
.1216 .24138 L
.12163 .24056 L
.12167 .23973 L
.12168 .23926 L
.1217 .24009 L
.12173 .24193 L
.12176 .24393 L
.12179 .24528 L
.12181 .24468 L
.12184 .24412 L
.12187 .24351 L
Mistroke
.1219 .24392 L
.12193 .24473 L
.12195 .24549 L
.12198 .24584 L
.12201 .24552 L
.12203 .24535 L
.12204 .24517 L
.12207 .24462 L
.1221 .24309 L
.1222 .23772 L
.12223 .23636 L
.12226 .23507 L
.12229 .2321 L
.12232 .22938 L
.12235 .22638 L
.12237 .22688 L
.12238 .22855 L
.12241 .23176 L
.12244 .23478 L
.12246 .23463 L
.12248 .23264 L
.12251 .22916 L
.12252 .22718 L
.12254 .2251 L
.12256 .22657 L
.12257 .22916 L
.12269 .24565 L
.12275 .25357 L
.12278 .25749 L
.12281 .26116 L
.12284 .26335 L
.12286 .26309 L
.12288 .2628 L
.12291 .26228 L
.12294 .2606 L
.12306 .25353 L
.12309 .25683 L
.12311 .25993 L
.12315 .25459 L
.12317 .24841 L
.1232 .24296 L
.12323 .23992 L
.12326 .24039 L
.12328 .24083 L
.12335 .24167 L
.12338 .24201 L
.12341 .24232 L
.12344 .24433 L
.12347 .24649 L
.12349 .24762 L
Mistroke
.12351 .24915 L
.12352 .25144 L
.12354 .25356 L
.12357 .25705 L
.1236 .26082 L
.12361 .26181 L
.12363 .26264 L
.12366 .26428 L
.12369 .26588 L
.1237 .26626 L
.12372 .26642 L
.12375 .26677 L
.12377 .26695 L
.12378 .26713 L
.12381 .26455 L
.12385 .26133 L
.12388 .25859 L
.12391 .25772 L
.12392 .25763 L
.12394 .25753 L
.12396 .25744 L
.12397 .25735 L
.12399 .25794 L
.12401 .2587 L
.12404 .26018 L
.1241 .26306 L
.12413 .26458 L
.12414 .26541 L
.12416 .26618 L
.12419 .26237 L
.12422 .25535 L
.12425 .24895 L
.12428 .24414 L
.1243 .24082 L
.12433 .23721 L
.12436 .23404 L
.12439 .23494 L
.12444 .23653 L
.12447 .23728 L
.12449 .23769 L
.12452 .23813 L
.12455 .2386 L
.12457 .23591 L
.1246 .23199 L
.12463 .22771 L
.12465 .22532 L
.12466 .22667 L
.12469 .2296 L
.12472 .23235 L
.12475 .23439 L
Mistroke
.12478 .2333 L
.12481 .23219 L
.12482 .2316 L
.12484 .23098 L
.12486 .2293 L
.12487 .22766 L
.1249 .22442 L
.12493 .22124 L
.12496 .22052 L
.12502 .21935 L
.12508 .21784 L
.1251 .21711 L
.12513 .21649 L
.12516 .21689 L
.12518 .21733 L
.1252 .21759 L
.12522 .21787 L
.12523 .21762 L
.12525 .21704 L
.12528 .21588 L
.12531 .21479 L
.12534 .21691 L
.12536 .21905 L
.12537 .22134 L
.12539 .22374 L
.12541 .22602 L
.12543 .22625 L
.12544 .22532 L
.12547 .22364 L
.1255 .22205 L
.12552 .22063 L
.12554 .21854 L
.12557 .21488 L
.1256 .21137 L
.12563 .21581 L
.12565 .22271 L
.12568 .23029 L
.12571 .23563 L
.12574 .23689 L
.12577 .23824 L
.12579 .23896 L
.12581 .23934 L
.12584 .23966 L
.12587 .23997 L
.12593 .24063 L
.12596 .24094 L
.12599 .24124 L
.12601 .23928 L
.12605 .23674 L
.1261 .23219 L
Mistroke
.12612 .22911 L
.12615 .22585 L
.12617 .224 L
.12619 .22312 L
.12622 .22567 L
.12625 .22808 L
.12626 .22942 L
.12628 .2301 L
.12631 .22721 L
.12634 .22458 L
.12639 .21877 L
.12643 .21504 L
.12644 .213 L
.12646 .21107 L
.12649 .21167 L
.12652 .21336 L
.12654 .21435 L
.12655 .21539 L
.12658 .21567 L
.1266 .21548 L
.12662 .21531 L
.12664 .21512 L
.12665 .21491 L
.12668 .21651 L
.12672 .21844 L
.12677 .2225 L
.12681 .22516 L
.12684 .22796 L
.12686 .229 L
.12687 .2294 L
.12691 .23011 L
.12694 .23078 L
.12695 .23064 L
.12697 .23022 L
.127 .22938 L
.12703 .22862 L
.12706 .22972 L
.12709 .23207 L
.12712 .23412 L
.12714 .23585 L
.12717 .23661 L
.1272 .2373 L
.12725 .23856 L
.12728 .23916 L
.12731 .23981 L
.12733 .23982 L
.12736 .23852 L
.12739 .23729 L
.12741 .23595 L
.12744 .23302 L
Mistroke
.12747 .22982 L
.1275 .22641 L
.12753 .22615 L
.12756 .22848 L
.12759 .23104 L
.12762 .23203 L
.12765 .22888 L
.12768 .22548 L
.1277 .22367 L
.12772 .2226 L
.12775 .22244 L
.12777 .22228 L
.12779 .22219 L
.12781 .22179 L
.12784 .21876 L
.12806 .20226 L
.12819 .19572 L
.12822 .19523 L
.12825 .19472 L
.12827 .19428 L
.1283 .19067 L
.12834 .18588 L
.12835 .18324 L
.12837 .18074 L
.12839 .17929 L
.12841 .17873 L
.12844 .17763 L
.12847 .17664 L
.1285 .1733 L
.12853 .16945 L
.12855 .16743 L
.12856 .1653 L
.12859 .16533 L
.12862 .16606 L
.12865 .16675 L
.12867 .16681 L
.1287 .16533 L
.12874 .16375 L
.12877 .16199 L
.12879 .15957 L
.12882 .15702 L
.12886 .15432 L
.12887 .15661 L
.12889 .15912 L
.12892 .16355 L
.12895 .16772 L
.12897 .16654 L
.12898 .16538 L
.12904 .161 L
.12909 .15476 L
Mistroke
.12912 .15117 L
.12915 .14933 L
.12916 .15099 L
.12918 .15279 L
.12921 .15591 L
.12927 .16142 L
.12929 .16387 L
.12932 .16614 L
.12935 .16647 L
.12938 .16484 L
.1294 .16345 L
.12943 .16214 L
.12946 .16324 L
.12948 .16435 L
.12951 .16554 L
.12954 .16637 L
.12957 .16668 L
.12959 .16695 L
.12962 .16723 L
.12964 .16705 L
.12965 .16688 L
.12971 .16624 L
.12975 .16209 L
.12978 .15739 L
.1298 .15523 L
.12981 .15351 L
.12984 .15645 L
.12987 .15909 L
.1299 .16192 L
.12993 .16314 L
.12996 .16378 L
.12999 .16438 L
.13002 .16485 L
.13005 .16515 L
.13007 .16544 L
.1301 .16569 L
.13012 .16516 L
.13015 .1646 L
.13018 .16401 L
.13021 .16272 L
.13023 .16066 L
.13026 .15825 L
.13029 .1562 L
.13032 .15523 L
.13035 .15419 L
.13038 .15303 L
.1304 .15385 L
.13043 .15539 L
.13046 .15683 L
.13049 .15812 L
Mistroke
.13052 .1588 L
.13054 .15914 L
.13055 .15951 L
.13058 .15969 L
.13062 .15853 L
.13064 .15745 L
.13067 .15638 L
.1307 .15623 L
.13072 .1561 L
.13075 .15596 L
.13078 .15561 L
.13081 .15506 L
.13084 .15441 L
.13086 .15381 L
.1309 .15446 L
.13092 .15508 L
.13095 .15574 L
.13097 .15692 L
.13099 .15838 L
.1311 .17241 L
.13113 .17776 L
.13116 .18156 L
.1312 .18373 L
.13123 .18611 L
.13125 .18737 L
.13126 .19105 L
.1313 .19971 L
.13132 .2035 L
.13133 .20761 L
.13136 .20933 L
.13139 .20812 L
.13142 .20678 L
.13144 .20611 L
.13145 .20463 L
.13148 .20188 L
.13151 .19915 L
.13154 .19783 L
.13157 .19962 L
.1316 .20157 L
.13162 .20356 L
.13165 .20455 L
.13168 .2053 L
.13171 .20613 L
.13173 .20572 L
.13176 .20337 L
.13179 .20061 L
.13181 .19809 L
.13184 .19817 L
.13187 .1995 L
.13193 .20209 L
Mistroke
.13196 .20395 L
.13198 .20492 L
.13199 .20596 L
.13201 .20686 L
.13202 .20894 L
.13205 .21323 L
.13209 .21796 L
.13212 .2214 L
.13213 .22195 L
.13215 .22255 L
.13217 .22311 L
.13219 .22361 L
.13222 .22524 L
.13223 .22662 L
.13225 .22792 L
.13231 .23323 L
.13243 .25124 L
.13254 .27183 L
.13257 .27724 L
.1326 .28073 L
.13262 .28189 L
.13263 .28316 L
.13266 .28537 L
.13269 .28771 L
.13273 .28996 L
.13276 .29189 L
.13277 .29299 L
.13279 .2899 L
.13285 .2785 L
.13287 .27286 L
.1329 .27351 L
.13293 .27407 L
.13296 .27466 L
.13298 .27618 L
.133 .27835 L
.13303 .2809 L
.13306 .2836 L
.13308 .28312 L
.13309 .2824 L
.13312 .28112 L
.13315 .27991 L
.13318 .28105 L
.13321 .28289 L
.13323 .28457 L
.13327 .2886 L
.13329 .29527 L
.13335 .30768 L
.13341 .31757 L
.13347 .32673 L
.13358 .34401 L
Mistroke
.13361 .35144 L
.13363 .35846 L
.13366 .36233 L
.13369 .36541 L
.13372 .36882 L
.13374 .36998 L
.13376 .37051 L
.13379 .37154 L
.13382 .3725 L
.13385 .37449 L
.13388 .37707 L
.13395 .38163 L
.13398 .38322 L
.13401 .38488 L
.13404 .38397 L
.13407 .38227 L
.1341 .38044 L
.13411 .37946 L
.13413 .37903 L
.13416 .37818 L
.13419 .37741 L
.13425 .37521 L
.13428 .37401 L
.1343 .37287 L
.13433 .37415 L
.13436 .37552 L
.13442 .37822 L
.13445 .37919 L
.13449 .38022 L
.13451 .37863 L
.13454 .3754 L
.13457 .37195 L
.13459 .37022 L
.13461 .37066 L
.13464 .37147 L
.13466 .37192 L
.13467 .37234 L
.1347 .37053 L
.13473 .366 L
.13475 .36169 L
.13477 .35713 L
.1348 .35622 L
.13483 .35693 L
.13486 .35769 L
.13489 .35745 L
.13492 .35487 L
.13494 .35252 L
.13501 .34603 L
.13512 .33304 L
.13515 .32968 L
Mistroke
.13518 .32791 L
.1352 .32833 L
.13523 .32879 L
.13526 .32911 L
.13528 .32684 L
.13529 .32435 L
.13532 .31989 L
.13535 .31582 L
.13538 .31731 L
.13541 .31949 L
.13544 .32178 L
.13547 .32058 L
.13549 .3161 L
.13552 .31135 L
.13554 .3073 L
.13557 .30729 L
.1356 .30763 L
.13562 .30782 L
.13564 .30799 L
.13566 .30721 L
.1357 .30603 L
.13577 .30339 L
.1358 .30224 L
.13581 .30164 L
.13583 .301 L
.13586 .30138 L
.13589 .302 L
.13592 .30258 L
.13595 .30515 L
.13598 .30953 L
.13599 .31194 L
.13601 .31423 L
.13604 .31454 L
.13607 .31142 L
.1361 .30816 L
.13612 .30632 L
.13613 .30754 L
.13616 .31111 L
.13619 .31488 L
.13622 .31763 L
.13624 .31544 L
.13627 .31305 L
.1363 .31046 L
.13632 .30849 L
.13633 .30599 L
.13636 .30107 L
.13642 .29176 L
.13645 .28644 L
.13647 .2835 L
.13649 .28071 L
Mistroke
.1365 .27812 L
.13652 .27751 L
.13655 .27656 L
.13657 .27573 L
.1366 .27506 L
.13663 .27646 L
.13665 .27772 L
.13668 .27923 L
.13671 .27806 L
.13674 .27392 L
.13676 .2701 L
.13679 .26613 L
.13681 .2664 L
.13684 .26673 L
.13687 .26703 L
.1369 .26442 L
.13693 .25997 L
.13699 .25046 L
.1371 .23626 L
.13713 .23249 L
.13715 .23051 L
.13716 .22842 L
.13719 .22801 L
.13722 .22892 L
.13725 .22988 L
.13728 .23024 L
.13731 .22992 L
.13734 .22963 L
.13737 .22919 L
.13739 .2288 L
.1374 .22845 L
.13744 .22779 L
.13745 .22745 L
.13747 .22462 L
.13749 .2173 L
.13752 .20931 L
.13755 .20177 L
.13758 .20022 L
.13764 .19721 L
.1377 .19394 L
.13775 .19076 L
.1378 .1878 L
.13783 .18616 L
.13786 .18756 L
.13788 .19112 L
.13791 .1944 L
.13797 .2004 L
.138 .20273 L
.13802 .20488 L
.13805 .20472 L
Mistroke
.13807 .20411 L
.13809 .20347 L
.13814 .20118 L
.13825 .19684 L
.13828 .19577 L
.13831 .19462 L
.13834 .1918 L
.13836 .18808 L
.13842 .18026 L
.13848 .17254 L
.1385 .17025 L
.13851 .16829 L
.13854 .16829 L
.13857 .16829 L
.13859 .16829 L
.1386 .16829 L
.13864 .17122 L
.13867 .17459 L
.1387 .17769 L
.13873 .17905 L
.13876 .18032 L
.13879 .18148 L
.13882 .18287 L
.13886 .18441 L
.13889 .1857 L
.13892 .18368 L
.13897 .1785 L
.139 .17639 L
.13903 .17572 L
.13906 .17501 L
.13909 .17416 L
.13912 .17245 L
.13915 .17083 L
.13922 .16768 L
.13925 .16649 L
.13928 .16522 L
.13929 .16324 L
.13931 .16097 L
.13934 .15696 L
.13937 .15297 L
.13939 .1569 L
.13942 .16208 L
.13945 .16773 L
.13948 .17176 L
.13951 .17125 L
.13954 .17076 L
.13957 .16985 L
.13978 .15975 L
.13984 .15123 L
.13987 .14751 L
Mistroke
.1399 .14488 L
.13992 .14242 L
.13995 .14034 L
.13998 .14034 L
.14 .14034 L
.14003 .14034 L
.14006 .14073 L
.14009 .14138 L
.14012 .14199 L
.14015 .14168 L
.14018 .13998 L
.14021 .13799 L
.14024 .13666 L
.14027 .1365 L
.1403 .13633 L
.14032 .13624 L
.14034 .13573 L
.14037 .13419 L
.1404 .13267 L
.14042 .13184 L
.14043 .13138 L
.14045 .1311 L
.14047 .13079 L
.14048 .13054 L
.1405 .13025 L
.14053 .13022 L
.14056 .1307 L
.14059 .13117 L
.14062 .13148 L
.14065 .13097 L
.14066 .13071 L
.14068 .13043 L
.14071 .1304 L
.14074 .13417 L
.14085 .1442 L
.14087 .14478 L
.14088 .1454 L
.14091 .14867 L
.14094 .1544 L
.14097 .1597 L
.141 .1644 L
.14102 .16338 L
.14103 .16243 L
.14107 .16051 L
.14108 .15944 L
.1411 .16021 L
.14113 .16438 L
.14116 .16894 L
.14119 .1725 L
.14122 .1728 L
Mistroke
.14125 .17315 L
.14127 .17334 L
.14129 .17319 L
.14132 .17155 L
.14135 .16981 L
.14138 .16828 L
.14141 .16799 L
.14144 .16767 L
.14145 .16751 L
.14147 .16733 L
.14148 .16872 L
.1415 .17092 L
.14153 .17525 L
.14159 .18467 L
.14162 .19053 L
.14164 .19362 L
.14166 .19686 L
.14168 .19831 L
.14169 .19831 L
.14173 .19831 L
.14176 .19831 L
.14177 .19971 L
.14179 .20121 L
.14182 .20391 L
.14185 .20688 L
.14188 .20678 L
.1419 .20567 L
.14196 .2033 L
.14208 .19961 L
.14211 .19869 L
.14213 .19824 L
.14214 .19782 L
.14217 .19764 L
.1422 .19747 L
.14223 .19732 L
.14226 .2001 L
.14229 .20355 L
.14231 .20719 L
.14234 .20935 L
.14237 .2077 L
.14239 .20621 L
.14242 .20479 L
.14245 .20571 L
.14247 .20849 L
.14253 .21464 L
.14259 .2195 L
.14262 .22224 L
.14264 .22001 L
.1427 .21382 L
.14273 .21126 L
Mistroke
.14275 .20965 L
.14279 .20789 L
.14282 .2067 L
.14285 .20715 L
.14288 .20764 L
.1429 .2081 L
.14293 .21051 L
.14296 .21285 L
.14299 .21532 L
.14301 .22005 L
.14304 .22798 L
.14307 .23466 L
.14309 .24193 L
.14311 .24309 L
.14313 .24274 L
.14316 .24206 L
.14319 .24145 L
.14322 .24128 L
.14323 .24128 L
.14325 .24128 L
.14327 .24128 L
.14329 .24128 L
.1433 .24268 L
.14332 .24464 L
.14335 .24807 L
.14338 .25164 L
.14341 .25228 L
.14342 .25236 L
.14344 .25246 L
.14347 .25263 L
.1435 .24943 L
.14353 .24475 L
.14356 .24039 L
.14359 .23811 L
.14362 .23795 L
.14365 .23778 L
.14368 .23779 L
.14371 .2386 L
.14373 .23939 L
.14376 .24013 L
.14379 .23935 L
.14381 .2382 L
.14384 .23692 L
.14386 .2362 L
.14388 .23387 L
.14391 .22815 L
.14394 .22293 L
.14397 .21929 L
.144 .21751 L
.14403 .21564 L
Mistroke
.14406 .21395 L
.14408 .2147 L
.14411 .21539 L
.14414 .21613 L
.14417 .21496 L
.14421 .21102 L
.14424 .20879 L
.14427 .20932 L
.1443 .21015 L
.14433 .2109 L
.14436 .21126 L
.14439 .21126 L
.14441 .21126 L
.14444 .21144 L
.14447 .21204 L
.1445 .21259 L
.14453 .21323 L
.14456 .21201 L
.14458 .2106 L
.14461 .2091 L
.14464 .20902 L
.14467 .21098 L
.14473 .21553 L
.14495 .22826 L
.14521 .24255 L
.14526 .24018 L
.14529 .23886 L
.14532 .24117 L
.14538 .24778 L
.14544 .25479 L
.1455 .26198 L
.14553 .26628 L
.14556 .27084 L
.14558 .27312 L
.1456 .27389 L
.14563 .27491 L
.14569 .27751 L
.14572 .27997 L
.14576 .28256 L
.14578 .28369 L
.14579 .28337 L
.14583 .28282 L
.14585 .28255 L
.14586 .28229 L
.14588 .28113 L
.1459 .27954 L
.14593 .27668 L
.14594 .27516 L
.14596 .27353 L
.14599 .2754 L
Mistroke
.14602 .27849 L
.14603 .28031 L
.14605 .28203 L
.14608 .28085 L
.14611 .27739 L
.14613 .27418 L
.14619 .26902 L
.14622 .26704 L
.14624 .266 L
.14625 .26482 L
.14628 .26182 L
.14631 .25907 L
.14634 .2562 L
.14636 .25664 L
.14637 .25774 L
.14641 .26008 L
.14643 .26136 L
.14644 .26248 L
.14647 .26167 L
.14651 .26078 L
.14653 .26003 L
.14656 .26048 L
.14658 .26084 L
.1466 .26124 L
.14662 .26159 L
.14663 .26196 L
.14665 .264 L
.14667 .26593 L
.1467 .2697 L
.14673 .27354 L
.14675 .27348 L
.14679 .27297 L
.1468 .27272 L
.14682 .27244 L
.14685 .27306 L
.14687 .27393 L
.14691 .27496 L
.14693 .27803 L
.14699 .28785 L
.14701 .29281 L
.14704 .29181 L
.14708 .29042 L
.14711 .28912 L
.14713 .28695 L
.14716 .28438 L
.14719 .2821 L
.14722 .28176 L
.14725 .2847 L
.14728 .28742 L
.14733 .29208 L
Mistroke
.14735 .29448 L
.14738 .29672 L
.14741 .29815 L
.14743 .29806 L
.14744 .29797 L
.14747 .29781 L
.1475 .2971 L
.14753 .29496 L
.14756 .29269 L
.14758 .29137 L
.1476 .29176 L
.14762 .29296 L
.14763 .29409 L
.14766 .29625 L
.14769 .29656 L
.14772 .2919 L
.14776 .28697 L
.14778 .28311 L
.14781 .28238 L
.14784 .28159 L
.14787 .28073 L
.1479 .2829 L
.14793 .28532 L
.14796 .28758 L
.14799 .28964 L
.14803 .29235 L
.14806 .29384 L
.14809 .2927 L
.14812 .29077 L
.14815 .28892 L
.14817 .28861 L
.1482 .29087 L
.14832 .30427 L
.14838 .31247 L
.14841 .3165 L
.14843 .3187 L
.14845 .32075 L
.14848 .31828 L
.14851 .31509 L
.14854 .31239 L
.14857 .31474 L
.1486 .31866 L
.14863 .32293 L
.14866 .32285 L
.14868 .32002 L
.14871 .31727 L
.14874 .31476 L
.14876 .3142 L
.14879 .31357 L
.14882 .31294 L
Mistroke
.14884 .3138 L
.14885 .31641 L
.14889 .32213 L
.14892 .32733 L
.14895 .32942 L
.14897 .3303 L
.149 .33122 L
.14903 .33255 L
.14907 .33445 L
.14908 .33541 L
.1491 .33645 L
.14913 .33972 L
.14916 .34477 L
.14918 .34779 L
.1492 .35109 L
.14921 .35408 L
.14923 .35264 L
.14929 .34701 L
.14935 .3481 L
.14937 .34886 L
.14939 .34968 L
.14942 .3494 L
.14943 .34801 L
.14945 .34674 L
.14947 .34534 L
.14949 .34381 L
.1495 .34219 L
.14952 .33981 L
.14955 .33514 L
.14961 .32675 L
.14967 .32096 L
.14972 .31641 L
.14975 .31459 L
.14977 .31362 L
.14979 .31231 L
.14982 .3066 L
.14984 .3013 L
.14987 .29523 L
.1499 .29563 L
.14993 .29839 L
.14995 .30138 L
.14998 .30391 L
.15 .30391 L
.15003 .30391 L
.15006 .30391 L
.15009 .30467 L
.15012 .30606 L
.15013 .30681 L
.15015 .30762 L
.15018 .30792 L
Mistroke
.15021 .30616 L
.15024 .30452 L
.15026 .30287 L
.15029 .3023 L
.15032 .30172 L
.15035 .30107 L
.15038 .29876 L
.15039 .29683 L
.15041 .29508 L
.15044 .29171 L
.15047 .29054 L
.15049 .29182 L
.15052 .29318 L
.15054 .29434 L
.15057 .2981 L
.1506 .30282 L
.15063 .3079 L
.15066 .30866 L
.15068 .30442 L
.15071 .2995 L
.15074 .295 L
.15076 .2938 L
.15077 .2925 L
.1508 .29024 L
.15087 .28604 L
.1509 .28456 L
.15092 .28377 L
.15094 .28308 L
.15097 .2824 L
.151 .28176 L
.15102 .28138 L
.15103 .28111 L
.15106 .28094 L
.15109 .2808 L
.15112 .28064 L
.15115 .27335 L
.15118 .26565 L
.15121 .25837 L
.15124 .25605 L
.15127 .2574 L
.1513 .25866 L
.15132 .25816 L
.15135 .2552 L
.1514 .24856 L
.15146 .23539 L
.15148 .23165 L
.1515 .22769 L
.15153 .22816 L
.15156 .23036 L
.15158 .23242 L
Mistroke
.15161 .23294 L
.15163 .23231 L
.15165 .23174 L
.15167 .23072 L
.1517 .23029 L
.15173 .23191 L
.15175 .23339 L
.15178 .23512 L
.15181 .23366 L
.15184 .23124 L
.15187 .22902 L
.15192 .22348 L
.15198 .2167 L
.15203 .20658 L
.15206 .20197 L
.15209 .19756 L
.15211 .19469 L
.15215 .19164 L
.15221 .18358 L
.15224 .17942 L
.15226 .17724 L
.15227 .17593 L
.1523 .1787 L
.15233 .18124 L
.15236 .18371 L
.15239 .18268 L
.15241 .18063 L
.15244 .17876 L
.15247 .17735 L
.1525 .17854 L
.15253 .17958 L
.15255 .18069 L
.15259 .17771 L
.15262 .17484 L
.15268 .168 L
.1527 .16613 L
.15272 .1641 L
.15274 .16217 L
.15275 .16163 L
.15278 .16465 L
.15282 .16786 L
.15284 .17022 L
.15288 .1686 L
.15293 .16567 L
.15306 .15965 L
.15329 .14332 L
.15331 .13777 L
.15335 .13374 L
.15338 .13006 L
.15341 .12667 L
Mistroke
.15344 .12573 L
.15347 .12558 L
.1535 .12542 L
.15351 .12533 L
.15353 .1262 L
.15356 .12824 L
.15358 .12931 L
.1536 .13046 L
.15362 .13073 L
.15364 .13018 L
.15367 .12911 L
.1537 .12808 L
.15372 .12812 L
.15373 .12838 L
.15377 .1289 L
.1538 .12939 L
.15382 .12885 L
.15385 .12804 L
.15392 .1261 L
.15395 .1248 L
.15398 .12356 L
.15401 .12201 L
.15405 .12012 L
.15407 .11844 L
.1541 .11739 L
.15413 .11708 L
.15416 .1168 L
.15419 .11653 L
.15421 .11653 L
.15422 .11653 L
.15425 .11653 L
.15427 .11653 L
.15429 .11604 L
.1543 .11415 L
.15432 .11215 L
.15435 .10858 L
.15442 .10098 L
.15444 .09796 L
.15447 .09484 L
.15449 .09636 L
.15451 .09775 L
.15454 .10046 L
.15465 .11201 L
.15468 .11505 L
.15472 .11806 L
.15475 .12089 L
.15477 .12039 L
.1548 .1165 L
.15483 .11292 L
.15486 .10922 L
Mistroke
.15489 .10839 L
.155 .10449 L
.15506 .10143 L
.15509 .0998 L
.15512 .09828 L
.15514 .09691 L
.15517 .09825 L
.15523 .10132 L
.15547 .11798 L
.15591 .14204 L
.15682 .18626 L
.15729 .21082 L
.15732 .21166 L
.15733 .21212 L
.15735 .21277 L
.15737 .2137 L
.15739 .21455 L
.15742 .2162 L
.15745 .21838 L
.15748 .22092 L
.1575 .22236 L
.15752 .22389 L
.15753 .22523 L
.15755 .22514 L
.15757 .225 L
.1576 .22484 L
.15763 .22271 L
.15766 .21529 L
.15769 .20755 L
.15771 .2033 L
.15773 .20101 L
.15776 .20146 L
.15779 .20197 L
.15782 .20242 L
.15785 .20169 L
.15787 .20098 L
.1579 .20021 L
.15792 .20071 L
.15793 .20363 L
.15796 .20939 L
.15799 .21496 L
.15802 .21915 L
.15808 .22571 L
.1581 .22765 L
.15811 .22904 L
.15814 .23116 L
.15816 .23224 L
.15818 .2334 L
.15821 .23478 L
.15824 .23323 L
Mistroke
.15825 .23241 L
.15827 .23155 L
.1583 .23107 L
.15833 .23376 L
.15839 .23979 L
.15845 .2436 L
.15848 .24576 L
.15851 .24646 L
.15853 .24646 L
.15856 .24646 L
.15858 .24646 L
.15861 .24632 L
.15863 .24617 L
.15866 .24601 L
.15869 .24644 L
.15872 .24764 L
.15875 .24891 L
.15877 .25008 L
.15879 .25008 L
.15881 .25008 L
.15883 .25008 L
.15886 .25008 L
.15889 .25267 L
.15892 .25555 L
.15894 .25864 L
.15897 .2607 L
.159 .25984 L
.15903 .25891 L
.15906 .25789 L
.15907 .25793 L
.15909 .25802 L
.15912 .25819 L
.15915 .25834 L
.15918 .26629 L
.15921 .27483 L
.15924 .28382 L
.15926 .28701 L
.15928 .28863 L
.15931 .29148 L
.15938 .29682 L
.15941 .2987 L
.15944 .3006 L
.15947 .3046 L
.1595 .30838 L
.15953 .31238 L
.15955 .31287 L
.15957 .31305 L
.1596 .31336 L
.15962 .31365 L
.15965 .3115 L
Mistroke
.15968 .30781 L
.15971 .30426 L
.15973 .30245 L
.15975 .30443 L
.15978 .30833 L
.1598 .31192 L
.15982 .31396 L
.15983 .31467 L
.15985 .31449 L
.15987 .3143 L
.15993 .31368 L
.15996 .31353 L
.15999 .31336 L
.16002 .31302 L
.16005 .31186 L
.16008 .31052 L
.1601 .30978 L
.16011 .30909 L
.16014 .30999 L
.16017 .31098 L
.1602 .31189 L
.16022 .31335 L
.16025 .31526 L
.16028 .31734 L
.16031 .31881 L
.16033 .31853 L
.16034 .31828 L
.16037 .3178 L
.1604 .31739 L
.16043 .31795 L
.16045 .31854 L
.16048 .31913 L
.16051 .3179 L
.16054 .31537 L
.16056 .31265 L
.16059 .31025 L
.16062 .31587 L
.16064 .32252 L
.16067 .3297 L
.1607 .3341 L
.16073 .33671 L
.16076 .33977 L
.16078 .34131 L
.16079 .33963 L
.16082 .3349 L
.16085 .33049 L
.16107 .29488 L
.1611 .2897 L
.16114 .28407 L
.16115 .28148 L
Mistroke
.16117 .27939 L
.1612 .27828 L
.16122 .27728 L
.16125 .27621 L
.16128 .27917 L
.16131 .28296 L
.16138 .29101 L
.16145 .29887 L
.16151 .30626 L
.16152 .3083 L
.16154 .31045 L
.16157 .30911 L
.1616 .30657 L
.16164 .30378 L
.1617 .29875 L
.16176 .29408 L
.16181 .2902 L
.16183 .28905 L
.16185 .28848 L
.16188 .28761 L
.1619 .28712 L
.16192 .28661 L
.16193 .28646 L
.16195 .28694 L
.16198 .2878 L
.162 .28825 L
.16202 .28873 L
.16203 .28788 L
.16205 .28596 L
.16208 .28259 L
.16214 .2753 L
.16217 .2715 L
.1622 .26799 L
.16221 .26611 L
.16223 .26565 L
.16227 .2647 L
.1623 .26389 L
.16231 .2635 L
.16233 .26333 L
.16236 .26301 L
.16239 .26271 L
.16241 .26309 L
.16244 .26566 L
.16247 .26848 L
.16249 .27003 L
.1625 .27176 L
.16253 .27857 L
.16256 .28474 L
.16259 .29094 L
.16262 .29166 L
Mistroke
.16265 .29058 L
.16267 .2896 L
.1627 .28941 L
.16272 .29016 L
.16274 .29084 L
.16276 .2921 L
.1628 .29236 L
.16282 .29014 L
.16286 .28774 L
.16289 .28573 L
.16291 .28529 L
.16295 .28475 L
.16298 .28426 L
.16299 .28211 L
.16301 .2797 L
.16304 .27459 L
.16327 .24845 L
.16332 .25058 L
.16335 .25177 L
.16338 .24768 L
.16341 .23958 L
.16343 .2319 L
.16346 .226 L
.16349 .22812 L
.16352 .2304 L
.16353 .23164 L
.16355 .23282 L
.16358 .23165 L
.16361 .23002 L
.16364 .22831 L
.16367 .22968 L
.16368 .23109 L
.1637 .23263 L
.16373 .23574 L
.16377 .23813 L
.1638 .24002 L
.16382 .24107 L
.16384 .24221 L
.16386 .24231 L
.16387 .24231 L
.1639 .24231 L
.16392 .24231 L
.16393 .24231 L
.16395 .2414 L
.16397 .24057 L
.164 .23871 L
.16449 .21714 L
.16471 .20182 L
.16474 .19705 L
.16477 .1919 L
Mistroke
.1648 .18825 L
.16483 .18965 L
.16486 .19103 L
.16488 .19231 L
.16491 .19593 L
.16494 .20065 L
.16496 .20316 L
.16497 .20589 L
.16501 .20662 L
.16504 .20512 L
.16507 .20372 L
.1651 .20255 L
.16513 .20163 L
.16515 .20117 L
.16517 .20067 L
.16518 .20109 L
.1652 .20274 L
.16523 .20551 L
.16526 .20848 L
.16529 .20822 L
.16532 .20423 L
.16535 .19972 L
.16538 .1967 L
.16541 .19549 L
.16544 .19417 L
.1655 .19012 L
.16553 .18768 L
.16556 .18541 L
.16557 .18537 L
.16559 .18537 L
.16561 .18537 L
.16562 .18537 L
.16564 .18537 L
.16566 .18544 L
.16569 .18654 L
.16572 .18769 L
.16574 .18876 L
.16577 .18486 L
.16581 .17913 L
.16583 .17427 L
.16586 .17178 L
.16589 .17145 L
.16592 .17116 L
.16595 .1709 L
.16598 .17106 L
.166 .17121 L
.16603 .17136 L
.16606 .17301 L
.16609 .17488 L
.16616 .17953 L
Mistroke
.16619 .18232 L
.16621 .18368 L
.16622 .18494 L
.16624 .18789 L
.16626 .19177 L
.16629 .19854 L
.16632 .20447 L
.16634 .2047 L
.16636 .20487 L
.16637 .20505 L
.16639 .20524 L
.16641 .20541 L
.16642 .20547 L
.16645 .20379 L
.16648 .202 L
.16653 .19791 L
.16659 .19137 L
.16661 .18958 L
.16662 .18862 L
.16665 .18766 L
.16668 .1867 L
.1667 .18616 L
.16671 .18664 L
.16674 .18953 L
.16677 .19261 L
.16684 .19824 L
.16687 .20018 L
.16689 .20128 L
.1669 .20191 L
.16694 .20174 L
.16695 .20164 L
.16697 .20155 L
.167 .20121 L
.16703 .19969 L
.16709 .19652 L
.16713 .19485 L
.16715 .19394 L
.16717 .19308 L
.16718 .19227 L
.1672 .19226 L
.16723 .1926 L
.16726 .19294 L
.16729 .19208 L
.16732 .18939 L
.16735 .18643 L
.16737 .18494 L
.16738 .18406 L
.16741 .18551 L
.16753 .19947 L
.16756 .20494 L
Mistroke
.16759 .20505 L
.16761 .20382 L
.16762 .20269 L
.16766 .20048 L
.16772 .19542 L
.16774 .19417 L
.16776 .19285 L
.16778 .19297 L
.16779 .19336 L
.16783 .1941 L
.16785 .19447 L
.16786 .19494 L
.16789 .19636 L
.16792 .1979 L
.16795 .19926 L
.16798 .19752 L
.16801 .19583 L
.16803 .19399 L
.16805 .19355 L
.16807 .19518 L
.1681 .19841 L
.16813 .20133 L
.16816 .20118 L
.16817 .19908 L
.16819 .19715 L
.16822 .19279 L
.16829 .18276 L
.16832 .17776 L
.16835 .1762 L
.16837 .17917 L
.16841 .18244 L
.16844 .18459 L
.16845 .18401 L
.16847 .18337 L
.1685 .18223 L
.16853 .18106 L
.16854 .1787 L
.16856 .17646 L
.16859 .17151 L
.16862 .16809 L
.16864 .16948 L
.16866 .17077 L
.16869 .17329 L
.16872 .17556 L
.16874 .17599 L
.16877 .17646 L
.1688 .17696 L
.16882 .17773 L
.16884 .17912 L
.16887 .18155 L
Mistroke
.1689 .18386 L
.16892 .18444 L
.16895 .18362 L
.16898 .18293 L
.16901 .18239 L
.16904 .18353 L
.16907 .18475 L
.1691 .18587 L
.16913 .18574 L
.16915 .1856 L
.16918 .18545 L
.1692 .18516 L
.16923 .1846 L
.16926 .18399 L
.16929 .18335 L
.16932 .18016 L
.16934 .1771 L
.16937 .17368 L
.1694 .17315 L
.16943 .17618 L
.16946 .17944 L
.16947 .18106 L
.16949 .18158 L
.16952 .18107 L
.16955 .18057 L
.16958 .18108 L
.16961 .18579 L
.16964 .19022 L
.16966 .1942 L
.16969 .19445 L
.16972 .19227 L
.16975 .18998 L
.16977 .18855 L
.1698 .18886 L
.16982 .18903 L
.16984 .18922 L
.16987 .18902 L
.1699 .18567 L
.16993 .18257 L
.16999 .17619 L
.17003 .17307 L
.17004 .17132 L
.17006 .17112 L
.17009 .17431 L
.17012 .17766 L
.17015 .18059 L
.17018 .17779 L
.17021 .17458 L
.17023 .17282 L
.17024 .17116 L
Mistroke
.17027 .17119 L
.1703 .1715 L
.17033 .1718 L
.17036 .17475 L
.17039 .17888 L
.17041 .18265 L
.17048 .18966 L
.17051 .19228 L
.17054 .19486 L
.17057 .19583 L
.1706 .19686 L
.17066 .19918 L
.17072 .20247 L
.17075 .20359 L
.17078 .20482 L
.17081 .20587 L
.17084 .20299 L
.17087 .19858 L
.17089 .19441 L
.17092 .19208 L
.17095 .19327 L
.17098 .19455 L
.17101 .1965 L
.17104 .20092 L
.17107 .20579 L
.17109 .21022 L
.17112 .20996 L
.17114 .20449 L
.17117 .19949 L
.1712 .19407 L
.17123 .19122 L
.17126 .18853 L
.17129 .186 L
.17132 .18824 L
.17134 .19177 L
.17137 .19593 L
.1714 .19868 L
.17143 .19965 L
.17145 .20016 L
.17146 .20072 L
.17149 .20123 L
.17152 .2005 L
.17154 .19985 L
.17157 .19913 L
.1716 .1968 L
.17163 .19333 L
.17166 .19035 L
.17168 .18772 L
.17172 .18669 L
.17175 .18561 L
Mistroke
.17178 .18442 L
.17181 .18272 L
.17184 .18076 L
.17187 .17935 L
.17189 .1801 L
.17191 .1809 L
.17194 .18231 L
.17197 .18383 L
.17199 .18526 L
.172 .1866 L
.17202 .1881 L
.17204 .18953 L
.17207 .19105 L
.17209 .18902 L
.17212 .18682 L
.17215 .18446 L
.17218 .18758 L
.17221 .19128 L
.17223 .1933 L
.17225 .19519 L
.17227 .19573 L
.1723 .19573 L
.17232 .19573 L
.17234 .19573 L
.17237 .1949 L
.1724 .19364 L
.17242 .19295 L
.17244 .19231 L
.17246 .19285 L
.1725 .19386 L
.17252 .19478 L
.17255 .1961 L
.17258 .19814 L
.17261 .2 L
.17264 .20053 L
.17266 .19882 L
.17268 .19723 L
.1727 .19449 L
.17273 .19184 L
.17276 .1906 L
.17279 .18945 L
.17281 .18841 L
.17284 .18856 L
.17287 .1896 L
.17289 .19057 L
.17295 .19291 L
.17298 .19414 L
.173 .19527 L
.17303 .19752 L
.17307 .20053 L
Mistroke
.17312 .20609 L
.17318 .21226 L
.17323 .21747 L
.17326 .21957 L
.17328 .22068 L
.1733 .22186 L
.17333 .21946 L
.17335 .21662 L
.17338 .21374 L
.17341 .21282 L
.17344 .21375 L
.17347 .21461 L
.17349 .21539 L
.17352 .21258 L
.17354 .20983 L
.17357 .20682 L
.17359 .20512 L
.1736 .20683 L
.17364 .21022 L
.17369 .21697 L
.17376 .22706 L
.17383 .23524 L
.17386 .23882 L
.17389 .24183 L
.17392 .24326 L
.17394 .24457 L
.17397 .2459 L
.174 .24385 L
.17404 .2417 L
.17407 .23973 L
.1741 .24068 L
.17413 .2417 L
.17416 .24272 L
.17418 .24392 L
.17419 .24518 L
.17422 .24731 L
.17425 .24955 L
.17427 .24957 L
.17428 .24856 L
.17431 .24679 L
.17454 .23547 L
.17457 .23225 L
.1746 .22823 L
.17462 .22639 L
.17463 .22444 L
.17466 .22642 L
.17468 .22848 L
.17469 .23042 L
.17471 .23272 L
.17473 .23482 L
Mistroke
.17476 .23739 L
.1748 .24007 L
.17483 .24256 L
.17486 .2401 L
.17489 .23643 L
.17492 .23311 L
.17495 .23554 L
.17498 .23914 L
.17501 .24295 L
.17504 .2457 L
.17507 .24719 L
.1751 .24854 L
.17515 .25083 L
.17518 .25198 L
.1752 .25259 L
.17521 .25334 L
.17524 .25706 L
.17527 .26048 L
.1753 .26399 L
.17533 .2653 L
.17536 .26611 L
.17539 .26685 L
.17541 .26694 L
.17542 .26627 L
.17546 .26477 L
.17549 .26344 L
.17551 .26355 L
.17552 .26465 L
.17555 .26661 L
.17558 .26869 L
.1756 .26964 L
.17563 .26934 L
.17566 .26902 L
.17568 .26884 L
.17569 .26873 L
.17572 .2689 L
.17575 .26905 L
.17578 .26919 L
.1758 .26757 L
.17583 .26552 L
.17585 .26326 L
.17588 .26094 L
.17591 .26061 L
.17594 .26031 L
.17597 .26002 L
.176 .26124 L
.17602 .26301 L
.17609 .26741 L
.17614 .27258 L
.17617 .27555 L
Mistroke
.1762 .28185 L
.17622 .28824 L
.17625 .29511 L
.17627 .29758 L
.17629 .29834 L
.17632 .29983 L
.17645 .30798 L
.17648 .30736 L
.17651 .30578 L
.17652 .3049 L
.17654 .30396 L
.17657 .30799 L
.17659 .31206 L
.17661 .31636 L
.17663 .32034 L
.17664 .32404 L
.17667 .32628 L
.17669 .32699 L
.17671 .32775 L
.17672 .32842 L
.17674 .32913 L
.17676 .32605 L
.17677 .32235 L
.17681 .31513 L
.17684 .30836 L
.17686 .30695 L
.17689 .3057 L
.17695 .30203 L
.17743 .25903 L
.17749 .24856 L
.17756 .23659 L
.17757 .23321 L
.17759 .22965 L
.17761 .2276 L
.17763 .22828 L
.17769 .23077 L
.17772 .23052 L
.17774 .23025 L
.17776 .23 L
.17778 .22954 L
.17781 .2298 L
.17783 .23016 L
.17785 .23049 L
.17787 .23089 L
.17788 .23125 L
.17791 .23622 L
.17794 .24364 L
.17797 .24977 L
.178 .25474 L
.17803 .25759 L
Mistroke
.17806 .26024 L
.17807 .26168 L
.17809 .26259 L
.17812 .26292 L
.17815 .26321 L
.17818 .26353 L
.17821 .26369 L
.17823 .26383 L
.17826 .26399 L
.17829 .26282 L
.17832 .26095 L
.17835 .25896 L
.17837 .25749 L
.1784 .25867 L
.17843 .26017 L
.17844 .26095 L
.17846 .26179 L
.17848 .26183 L
.1785 .26164 L
.17851 .26146 L
.17853 .26127 L
.17856 .26107 L
.17859 .2633 L
.17862 .26572 L
.17864 .26699 L
.17866 .2679 L
.17867 .2656 L
.17869 .26306 L
.17872 .25857 L
.17875 .25438 L
.17878 .25773 L
.17881 .26097 L
.17884 .26444 L
.17887 .26608 L
.1789 .26721 L
.17892 .26842 L
.17895 .26776 L
.17898 .26404 L
.17901 .26061 L
.17904 .25689 L
.17907 .25797 L
.17913 .26038 L
.1792 .26568 L
.17921 .26723 L
.17923 .2687 L
.17926 .26717 L
.17929 .26581 L
.17932 .26436 L
.17934 .26246 L
.17935 .26019 L
Mistroke
.17938 .25578 L
.17941 .25168 L
.17944 .25108 L
.17946 .25245 L
.17949 .25394 L
.17955 .25724 L
.17958 .25913 L
.17961 .26091 L
.17964 .25858 L
.17967 .25595 L
.1797 .25357 L
.17972 .25316 L
.17975 .25394 L
.17977 .2548 L
.1798 .2557 L
.17983 .25539 L
.17986 .2549 L
.17987 .25463 L
.17989 .25438 L
.17992 .25158 L
.17995 .24802 L
.18008 .22929 L
.1802 .21563 L
.18025 .20629 L
.18028 .20128 L
.18031 .19973 L
.18034 .19833 L
.18036 .197 L
.18039 .19747 L
.18042 .1997 L
.18044 .20191 L
.18047 .20426 L
.1805 .20265 L
.18053 .20071 L
.18076 .18745 L
.18079 .18687 L
.18081 .18623 L
.18084 .18563 L
.18087 .18544 L
.1809 .1856 L
.18092 .18574 L
.18095 .18567 L
.18098 .18158 L
.18101 .17742 L
.18103 .17515 L
.18105 .17334 L
.18108 .17224 L
.18111 .17104 L
.18123 .16573 L
.18166 .15138 L
Mistroke
.18178 .14683 L
.1818 .14665 L
.18182 .14628 L
.18183 .14559 L
.18185 .14496 L
.18188 .14382 L
.1819 .14317 L
.18191 .14406 L
.18194 .14761 L
.18197 .15092 L
.18203 .15735 L
.18206 .15997 L
.18209 .16246 L
.1821 .16338 L
.18212 .16394 L
.18215 .16492 L
.18218 .16583 L
.18221 .16632 L
.18224 .16647 L
.18226 .16661 L
.18229 .16699 L
.18232 .16888 L
.18235 .17085 L
.18237 .17194 L
.18238 .17296 L
.18241 .17567 L
.18244 .17813 L
.18248 .18313 L
.1826 .1964 L
.18271 .20743 L
.18274 .21054 L
.18276 .21228 L
.18277 .21224 L
.1828 .20614 L
.18283 .20034 L
.18286 .19435 L
.18289 .19301 L
.18292 .19197 L
.18295 .19086 L
.18298 .1903 L
.18301 .18997 L
.18303 .18979 L
.18305 .18959 L
.18306 .18974 L
.18308 .1902 L
.18352 .19986 L
.18355 .20014 L
.18358 .20132 L
.1836 .20194 L
.18362 .20262 L
Mistroke
.18365 .20478 L
.18368 .20719 L
.18369 .20852 L
.18371 .20978 L
.18374 .20934 L
.18377 .20724 L
.18379 .2052 L
.18382 .20359 L
.18385 .20403 L
.18387 .20443 L
.1839 .2049 L
.18394 .20492 L
.18396 .20476 L
.18399 .20461 L
.18402 .20515 L
.18405 .20667 L
.18408 .20799 L
.18411 .20957 L
.18413 .21102 L
.18414 .21236 L
.18418 .21501 L
.1842 .21778 L
.18424 .22239 L
.18449 .25299 L
.1846 .27091 L
.18463 .27795 L
.18466 .28546 L
.18469 .29015 L
.18472 .29287 L
.18475 .29586 L
.18478 .29743 L
.1848 .2958 L
.18481 .2943 L
.18483 .29277 L
.18485 .29133 L
.18487 .29015 L
.1849 .29368 L
.18496 .30082 L
.18507 .31485 L
.1851 .32006 L
.18512 .32561 L
.18515 .33084 L
.18517 .3301 L
.1852 .32837 L
.18523 .32674 L
.18529 .3228 L
.18532 .32115 L
.18535 .31954 L
.18537 .32368 L
.1854 .32749 L
Mistroke
.18543 .33163 L
.18545 .33237 L
.18546 .33129 L
.18549 .32936 L
.18552 .32722 L
.18555 .32571 L
.18557 .32474 L
.18563 .3226 L
.18566 .32178 L
.18569 .32093 L
.18572 .3202 L
.18575 .32063 L
.18576 .32117 L
.18578 .32166 L
.1858 .32219 L
.18581 .32277 L
.18584 .32705 L
.18587 .33235 L
.1859 .33728 L
.18593 .33807 L
.18596 .33199 L
.18599 .32547 L
.18602 .31916 L
.18605 .31688 L
.18608 .31481 L
.1861 .31261 L
.18613 .31251 L
.18616 .31296 L
.18618 .31337 L
.18621 .31376 L
.18623 .31773 L
.18626 .32201 L
.18629 .32573 L
.18632 .32765 L
.18635 .32748 L
.18637 .32733 L
.1864 .32645 L
.18643 .32335 L
.18649 .31646 L
.18652 .31377 L
.18655 .31109 L
.18658 .30877 L
.18661 .30796 L
.18663 .30782 L
.18666 .30768 L
.18668 .30755 L
.18671 .30784 L
.18674 .30817 L
.18677 .30847 L
.1868 .30616 L
Mistroke
.18682 .30438 L
.18683 .30249 L
.1869 .29608 L
.18692 .2935 L
.18695 .29074 L
.18698 .29069 L
.18701 .29493 L
.18704 .29977 L
.18706 .30251 L
.18708 .30112 L
.18711 .29735 L
.18713 .29542 L
.18714 .29334 L
.18717 .29307 L
.1872 .29611 L
.18724 .29975 L
.18727 .30209 L
.1873 .30273 L
.18732 .30333 L
.18735 .30339 L
.18737 .29988 L
.18739 .29665 L
.18741 .29078 L
.18744 .2853 L
.18747 .28522 L
.1875 .28749 L
.18751 .28867 L
.18753 .28996 L
.18756 .29384 L
.18762 .30328 L
.18764 .30604 L
.18765 .3077 L
.18767 .30937 L
.18769 .31089 L
.18775 .31632 L
.18778 .31858 L
.18781 .32069 L
.18784 .32144 L
.18786 .32063 L
.18788 .31977 L
.18799 .31371 L
.18826 .29969 L
.18831 .2936 L
.18834 .29102 L
.18838 .28856 L
.1884 .28631 L
.18843 .28598 L
.18846 .28567 L
.18849 .2854 L
.18852 .28437 L
Mistroke
.18855 .28285 L
.18858 .28143 L
.1886 .28091 L
.18862 .28134 L
.18864 .28179 L
.18867 .28259 L
.18868 .28304 L
.1887 .28196 L
.18871 .27966 L
.18873 .2772 L
.18881 .2675 L
.18884 .26286 L
.18886 .26083 L
.18887 .25858 L
.1889 .25601 L
.18894 .2536 L
.189 .24899 L
.18903 .24706 L
.18907 .24526 L
.18908 .2451 L
.1891 .24546 L
.18913 .24621 L
.18915 .24654 L
.18916 .2469 L
.18919 .24198 L
.18922 .23657 L
.18925 .23151 L
.18928 .23039 L
.18931 .23227 L
.18934 .2341 L
.18936 .235 L
.18937 .23389 L
.18949 .22525 L
.18952 .2226 L
.18954 .22114 L
.18955 .22011 L
.18957 .22041 L
.18959 .22069 L
.1896 .22095 L
.18962 .22123 L
.18965 .22237 L
.18968 .22518 L
.1897 .22689 L
.18971 .2285 L
.18975 .22966 L
.18977 .22419 L
.1898 .21825 L
.18983 .2119 L
.18986 .2118 L
.18988 .21233 L
Mistroke
.18991 .21292 L
.18994 .21307 L
.18997 .21234 L
.19 .21154 L
.19003 .21044 L
.19005 .20638 L
.19008 .20195 L
.19012 .19715 L
.19013 .19643 L
.19015 .19669 L
.19018 .1972 L
.19021 .19767 L
.19024 .19544 L
.19027 .19186 L
.19029 .18822 L
.19031 .18629 L
.19033 .18532 L
.19034 .18457 L
.19036 .18388 L
.19039 .18251 L
.19042 .18237 L
.19045 .18422 L
.19048 .18581 L
.19051 .18735 L
.19054 .18383 L
.19056 .1806 L
.19059 .17779 L
.19062 .17589 L
.19064 .17463 L
.19067 .17346 L
.19093 .16106 L
.19096 .16366 L
.19099 .16513 L
.19102 .16127 L
.19105 .15774 L
.19108 .15386 L
.19109 .15343 L
.19111 .15307 L
.19114 .15238 L
.19117 .15175 L
.1912 .15265 L
.19123 .15357 L
.19129 .15545 L
.19142 .16004 L
.19143 .1608 L
.19145 .16162 L
.19148 .16263 L
.19151 .16348 L
.19153 .16392 L
.19155 .1644 L
Mistroke
.19156 .16462 L
.19158 .16452 L
.19162 .16433 L
.19163 .16424 L
.19165 .16413 L
.19167 .1638 L
.19168 .16344 L
.19171 .16278 L
.19173 .16242 L
.19175 .16209 L
.19177 .16208 L
.1918 .16208 L
.19182 .16208 L
.19184 .16208 L
.19187 .15962 L
.1919 .15628 L
.19192 .15446 L
.19193 .15275 L
.19196 .15249 L
.19199 .15283 L
.19202 .15311 L
.19205 .15242 L
.19206 .15132 L
.19208 .15012 L
.19211 .14794 L
.19214 .14632 L
.19217 .14572 L
.1922 .1451 L
.19222 .14452 L
.19225 .14308 L
.19228 .14171 L
.19234 .13885 L
.19239 .13582 L
.19241 .13429 L
.19244 .13638 L
.19247 .13893 L
.1925 .14167 L
.19253 .14319 L
.19256 .14364 L
.19257 .14392 L
.19259 .14419 L
.19262 .142 L
.19265 .13588 L
.19267 .13252 L
.19268 .12935 L
.19271 .12585 L
.19274 .12721 L
.19277 .12873 L
.19279 .12956 L
.19281 .12995 L
Mistroke
.19282 .12985 L
.19284 .12975 L
.19286 .12967 L
.19288 .12957 L
.19291 .12923 L
.19293 .1286 L
.19296 .12805 L
.19299 .12744 L
.19302 .12786 L
.19305 .12839 L
.19311 .12934 L
.19314 .12986 L
.19316 .13015 L
.19318 .13042 L
.19321 .12998 L
.19322 .12964 L
.19324 .12928 L
.19325 .1289 L
.19327 .12848 L
.19329 .13073 L
.19331 .1331 L
.19334 .13789 L
.19337 .14219 L
.1934 .14459 L
.19343 .14718 L
.19345 .14866 L
.19347 .15005 L
.1935 .14845 L
.19353 .14668 L
.19356 .14479 L
.19358 .14695 L
.19359 .1501 L
.19362 .15623 L
.19366 .16202 L
.19367 .16293 L
.19369 .16338 L
.19372 .1642 L
.19374 .16494 L
.19376 .16655 L
.19378 .16937 L
.19381 .17558 L
.19384 .18101 L
.19386 .18285 L
.19387 .18404 L
.1939 .18616 L
.19393 .18814 L
.19396 .19066 L
.19399 .194 L
.19402 .19772 L
.19404 .19975 L
Mistroke
.19405 .20095 L
.19408 .20247 L
.19411 .20413 L
.19505 .27676 L
.19553 .31323 L
.19566 .32398 L
.19573 .32886 L
.1958 .33361 L
.19583 .33582 L
.19585 .33792 L
.19587 .33722 L
.19589 .33613 L
.19592 .33422 L
.19593 .33312 L
.19595 .33208 L
.19597 .33309 L
.19598 .33443 L
.19605 .33953 L
.1961 .34801 L
.19613 .3528 L
.19616 .35434 L
.19619 .35463 L
.19622 .35494 L
.19625 .35555 L
.19627 .35693 L
.19638 .36251 L
.19645 .36508 L
.19648 .3661 L
.19651 .36703 L
.19654 .36611 L
.19657 .36223 L
.19658 .36021 L
.1966 .358 L
.19662 .35591 L
.19663 .35649 L
.19677 .36251 L
.1968 .36313 L
.19683 .36424 L
.19686 .36557 L
.19688 .36698 L
.1969 .36776 L
.19692 .36799 L
.19695 .36765 L
.19698 .36732 L
.19701 .3676 L
.19704 .37089 L
.19707 .37438 L
.1971 .37736 L
.19713 .37581 L
.19716 .37406 L
Mistroke
.19718 .37314 L
.1972 .37226 L
.19721 .37243 L
.19723 .37262 L
.19726 .37294 L
.19729 .37329 L
.19732 .3739 L
.19735 .37457 L
.19736 .37491 L
.19738 .37528 L
.19741 .36874 L
.19744 .36198 L
.19747 .35565 L
.1975 .35416 L
.19794 .3268 L
.19841 .28756 L
.19854 .26947 L
.19867 .25488 L
.19873 .2478 L
.19877 .24438 L
.1988 .24122 L
.19882 .23876 L
.19885 .23937 L
.19888 .24005 L
.19891 .24067 L
.19894 .23835 L
.19897 .23531 L
.199 .2325 L
.19903 .23215 L
.19906 .23352 L
.19909 .23479 L
.19915 .23714 L
.19922 .23939 L
.19925 .24062 L
.19928 .24175 L
.19931 .23984 L
.19933 .23734 L
.19935 .23472 L
.19936 .2322 L
.19938 .22952 L
.1994 .22786 L
.19942 .22796 L
.19945 .22813 L
.19947 .22822 L
.19948 .2283 L
.1995 .22737 L
.19952 .22558 L
.19955 .22243 L
.19958 .21947 L
.19961 .21798 L
Mistroke
.19964 .21654 L
.19967 .21523 L
.1999 .20669 L
.19993 .20867 L
.19996 .21075 L
.19998 .21076 L
.19999 .20976 L
.20002 .20799 L
.20008 .20461 L
.20011 .20251 L
.20013 .20052 L
.20017 .19717 L
.20019 .19108 L
.20022 .18529 L
.20025 .17916 L
.20027 .17934 L
.20028 .18026 L
.20031 .18188 L
.20033 .18279 L
.20035 .18376 L
.20036 .18347 L
.20038 .18314 L
.20041 .18254 L
.20044 .18191 L
.20046 .18024 L
.20049 .17835 L
.20061 .17194 L
.20066 .16927 L
.20069 .16748 L
.20072 .1656 L
.20074 .16269 L
.20077 .15774 L
.2008 .15351 L
.20082 .14903 L
.20085 .15063 L
.20088 .15345 L
.20091 .15648 L
.20093 .15707 L
.20095 .15635 L
.20098 .15513 L
.20101 .15385 L
.20102 .15333 L
.20104 .15369 L
.20107 .15433 L
.2011 .15497 L
.20112 .15461 L
.20115 .1521 L
.20118 .14974 L
.20129 .14146 L
.20135 .1371 L
Mistroke
.20137 .13597 L
.20139 .13476 L
.20142 .13385 L
.20145 .13432 L
.20147 .13475 L
.2015 .13492 L
.20153 .13364 L
.20179 .12261 L
.20185 .11223 L
.20191 .10399 L
.20198 .09744 L
.20204 .09107 L
.20207 .0882 L
.2021 .08666 L
.20213 .0854 L
.20215 .08404 L
.20217 .08342 L
.20219 .0835 L
.20222 .08367 L
.20225 .08383 L
.20228 .08479 L
.2023 .08653 L
.20233 .08813 L
.20238 .09214 L
.20241 .09419 L
.20244 .09637 L
.20246 .09811 L
.20248 .09886 L
.20251 .09974 L
.20254 .10069 L
.20257 .09921 L
.2026 .09679 L
.20266 .09219 L
.20271 .08813 L
.20274 .08605 L
.20277 .08708 L
.2028 .08822 L
.20282 .08882 L
.20283 .08946 L
.20285 .09096 L
.20287 .09256 L
.2029 .09572 L
.20293 .09853 L
.20296 .09788 L
.20299 .09677 L
.20302 .09575 L
.20305 .09637 L
.20308 .09823 L
.2031 .09975 L
.20313 .10073 L
Mistroke
.20316 .09943 L
.20319 .09823 L
.2032 .09751 L
.20322 .09726 L
.20325 .10266 L
.20329 .10897 L
.20331 .11205 L
.20332 .1136 L
.20335 .11424 L
.20338 .11493 L
.20342 .11573 L
.20345 .11661 L
.20348 .11744 L
.20351 .11878 L
.20354 .12367 L
.20357 .12889 L
.20364 .13786 L
.20366 .1417 L
.20369 .14581 L
.20372 .14746 L
.20375 .14848 L
.20378 .14968 L
.20381 .15236 L
.20384 .15637 L
.20387 .16008 L
.2039 .16085 L
.20392 .15853 L
.20393 .15598 L
.20396 .15204 L
.20399 .14918 L
.20402 .15272 L
.20405 .15595 L
.20407 .15899 L
.2041 .15938 L
.20413 .15923 L
.20415 .15908 L
.20422 .15499 L
.20424 .15345 L
.20426 .15182 L
.20427 .15091 L
.20429 .15215 L
.20432 .15439 L
.20434 .15562 L
.20436 .15679 L
.20437 .15742 L
.20439 .15742 L
.20442 .15742 L
.20445 .15742 L
.20448 .15992 L
.20449 .16222 L
Mistroke
.20451 .16471 L
.20454 .16922 L
.20457 .17033 L
.2046 .16802 L
.20463 .16588 L
.20466 .16449 L
.20468 .16752 L
.20472 .17082 L
.20475 .17372 L
.20478 .17309 L
.2048 .17222 L
.20483 .17141 L
.20485 .17161 L
.20488 .17353 L
.20492 .17556 L
.20493 .1767 L
.20495 .17681 L
.20498 .17599 L
.20501 .17512 L
.20507 .17347 L
.2051 .17275 L
.20513 .17196 L
.20516 .17501 L
.20519 .17851 L
.20525 .18542 L
.2053 .19071 L
.20536 .19702 L
.20539 .20034 L
.20542 .20349 L
.20544 .20255 L
.20547 .20153 L
.20549 .20056 L
.20552 .20093 L
.20554 .20368 L
.20557 .20672 L
.20607 .26016 L
.20613 .27148 L
.20616 .27778 L
.20618 .28358 L
.20621 .28615 L
.20624 .28883 L
.20629 .29305 L
.20633 .29493 L
.20636 .29668 L
.20639 .29712 L
.2064 .29641 L
.20642 .29566 L
.20645 .2943 L
.20648 .29377 L
.20651 .2942 L
Mistroke
.20654 .29467 L
.20657 .29581 L
.2066 .30147 L
.20662 .30662 L
.20665 .31205 L
.20668 .31493 L
.20671 .31644 L
.20674 .31807 L
.20675 .31891 L
.20677 .31865 L
.2068 .31819 L
.20683 .31775 L
.20685 .31732 L
.20688 .31562 L
.2069 .31381 L
.20693 .31185 L
.20696 .31087 L
.20699 .31045 L
.20702 .31 L
.20705 .30976 L
.20706 .31022 L
.20708 .31064 L
.20711 .31147 L
.20713 .31193 L
.20714 .31289 L
.20717 .31639 L
.2072 .32021 L
.20722 .32229 L
.20724 .32308 L
.20726 .32056 L
.20729 .3178 L
.20732 .31545 L
.20735 .31598 L
.20736 .3169 L
.20738 .31789 L
.20741 .3197 L
.20744 .32324 L
.20747 .32783 L
.20758 .34265 L
.20764 .34866 L
.20767 .35123 L
.2077 .35362 L
.20772 .35423 L
.20775 .35339 L
.20777 .35253 L
.2078 .35159 L
.20783 .34693 L
.20786 .34232 L
.20791 .33407 L
.20794 .33019 L
Mistroke
.20797 .32601 L
.20799 .32362 L
.20801 .323 L
.20804 .32283 L
.20807 .32265 L
.20809 .32255 L
.20811 .32028 L
.20814 .3156 L
.20817 .31119 L
.2082 .30894 L
.20823 .3086 L
.20826 .30829 L
.20829 .30841 L
.20831 .31057 L
.20835 .31294 L
.20836 .31414 L
.20838 .31523 L
.20841 .31375 L
.20847 .31073 L
.2085 .30943 L
.20854 .30823 L
.20856 .30721 L
.20859 .3078 L
.20861 .30831 L
.20862 .30884 L
.20865 .3098 L
.20867 .31005 L
.20868 .30989 L
.20872 .30952 L
.20875 .30918 L
.20878 .30909 L
.2088 .30909 L
.20881 .30909 L
.20883 .30909 L
.20885 .30909 L
.20886 .30898 L
.20888 .3088 L
.20892 .30839 L
.20893 .30822 L
.20895 .30809 L
.20898 .30874 L
.20902 .3095 L
.20903 .30987 L
.20905 .31037 L
.20908 .31239 L
.20911 .31457 L
.20917 .31821 L
.2092 .31975 L
.20923 .3214 L
.20926 .32225 L
Mistroke
.20928 .32255 L
.2093 .32272 L
.20932 .3229 L
.20935 .32291 L
.20938 .32259 L
.2094 .3223 L
.20943 .32151 L
.20946 .31889 L
.20951 .31396 L
.20954 .31193 L
.20957 .31027 L
.2096 .30846 L
.20962 .30764 L
.20963 .30872 L
.20969 .31248 L
.20975 .31551 L
.20977 .31653 L
.2098 .3176 L
.20983 .31548 L
.20985 .3116 L
.20987 .30927 L
.20989 .30674 L
.20992 .30551 L
.20995 .3095 L
.20998 .31319 L
.21001 .31589 L
.21002 .31467 L
.21004 .31353 L
.21007 .3112 L
.21009 .31003 L
.21011 .30954 L
.21014 .30938 L
.21017 .30922 L
.21019 .30925 L
.21022 .31095 L
.21026 .31294 L
.21029 .3147 L
.21032 .31102 L
.21035 .30704 L
.21046 .29479 L
.21052 .28756 L
.21055 .28371 L
.21057 .28015 L
.21059 .27952 L
.21061 .27889 L
.21064 .27755 L
.21066 .27692 L
.21067 .27616 L
.2107 .27394 L
.21073 .27179 L
Mistroke
.21076 .26952 L
.21078 .26949 L
.21079 .26986 L
.21082 .27051 L
.21084 .27087 L
.21086 .27125 L
.21088 .26974 L
.21089 .26807 L
.21092 .26469 L
.21095 .26152 L
.21098 .26222 L
.211 .26302 L
.21102 .26389 L
.21103 .26476 L
.21105 .26534 L
.21107 .26189 L
.21109 .25812 L
.21112 .25129 L
.21115 .24489 L
.21116 .24391 L
.21118 .24284 L
.21121 .24099 L
.21124 .23921 L
.21127 .24341 L
.2113 .24733 L
.21133 .25097 L
.21136 .25005 L
.21137 .24846 L
.21139 .24677 L
.21145 .23994 L
.21156 .2229 L
.21159 .21885 L
.21162 .21448 L
.21165 .21264 L
.21167 .21177 L
.2118 .20806 L
.21185 .2069 L
.21188 .20631 L
.2119 .20575 L
.21193 .20777 L
.21196 .2106 L
.21199 .21326 L
.21202 .21406 L
.21204 .20909 L
.21207 .20362 L
.2121 .19791 L
.21213 .19594 L
.21216 .19419 L
.21219 .19254 L
.21221 .18881 L
Mistroke
.21224 .18372 L
.21227 .17806 L
.21229 .17508 L
.2123 .1732 L
.21233 .17221 L
.21236 .1713 L
.21239 .17042 L
.21241 .16682 L
.21247 .15811 L
.21254 .14421 L
.21255 .14063 L
.21257 .13682 L
.2126 .13334 L
.21263 .13218 L
.21266 .1309 L
.21269 .13026 L
.21272 .13106 L
.21274 .13176 L
.21277 .1325 L
.21279 .13413 L
.21282 .13606 L
.21285 .13814 L
.21288 .13885 L
.21291 .13507 L
.21293 .13164 L
.21296 .12767 L
.21299 .12745 L
.21302 .12826 L
.21305 .12911 L
.21308 .13032 L
.2131 .13183 L
.21313 .13365 L
.21316 .1352 L
.21319 .13568 L
.21322 .1362 L
.21325 .13668 L
.21328 .13629 L
.21331 .1358 L
.21333 .13553 L
.21334 .13527 L
.21336 .13419 L
.21338 .13239 L
.21341 .12923 L
.21344 .12622 L
.21347 .11995 L
.2135 .11378 L
.21352 .10724 L
.21355 .10246 L
.21358 .10033 L
.21365 .09593 L
Mistroke
.21367 .09499 L
.2137 .09397 L
.21373 .093 L
.21375 .09113 L
.21378 .08842 L
.21381 .08552 L
.21383 .08333 L
.21386 .08307 L
.21389 .08274 L
.2139 .08257 L
.21392 .0824 L
.21395 .08104 L
.21398 .07968 L
.21401 .07833 L
.21403 .07911 L
.21406 .08217 L
.21409 .08545 L
.21412 .08814 L
.21414 .08841 L
.21415 .08866 L
.21422 .08972 L
.21428 .09064 L
.21431 .09116 L
.21434 .08915 L
.21437 .08705 L
.21438 .0859 L
.2144 .08482 L
.21442 .08513 L
.21443 .08604 L
.21447 .08781 L
.21448 .08871 L
.2145 .08954 L
.21453 .08717 L
.21457 .08437 L
.21458 .08314 L
.2146 .08244 L
.21463 .08276 L
.21466 .08306 L
.21472 .08389 L
.21475 .08435 L
.21478 .08483 L
.21481 .08247 L
.21483 .07943 L
.21486 .07579 L
.21488 .0738 L
.2149 .0729 L
.21491 .07208 L
.21493 .07118 L
.21495 .07036 L
.21496 .06959 L
Mistroke
.21499 .07018 L
.21502 .07233 L
.21505 .07465 L
.21507 .07595 L
.21509 .07587 L
.21511 .07526 L
.21514 .07463 L
.2152 .07316 L
.21523 .07217 L
.21524 .07162 L
.21526 .0711 L
.21529 .07069 L
.21532 .07039 L
.21535 .07007 L
.21537 .07026 L
.2154 .07091 L
.21544 .07159 L
.21547 .07281 L
.2155 .07471 L
.21556 .0785 L
.21562 .07964 L
.21565 .08028 L
.21567 .08292 L
.21572 .08774 L
.21575 .08985 L
.21578 .09055 L
.21581 .09136 L
.21584 .0921 L
.21587 .09121 L
.2159 .09 L
.21595 .08765 L
.21598 .0863 L
.21601 .08506 L
.21604 .0842 L
.21607 .08587 L
.21612 .0888 L
.21624 .09736 L
.2163 .10593 L
.21633 .10963 L
.21636 .11069 L
.21638 .11167 L
.21641 .11274 L
.21644 .11571 L
.21646 .1188 L
.21649 .12236 L
.21652 .12473 L
.21655 .1244 L
.21658 .1241 L
.21661 .12388 L
.21664 .12577 L
Mistroke
.21667 .12799 L
.2167 .13 L
.21673 .13031 L
.21676 .13064 L
.21678 .13083 L
.2168 .13101 L
.21683 .12695 L
.21686 .12282 L
.21687 .12056 L
.21689 .11844 L
.21691 .11908 L
.21693 .12039 L
.21696 .12271 L
.2174 .15879 L
.21743 .16009 L
.21745 .16078 L
.21746 .1615 L
.2175 .16077 L
.21752 .16 L
.21754 .15957 L
.21756 .15912 L
.21757 .16096 L
.21759 .16358 L
.21765 .17296 L
.21789 .2047 L
.21792 .20795 L
.21793 .20973 L
.21795 .21184 L
.21797 .21511 L
.21798 .21808 L
.21802 .22387 L
.21814 .25364 L
.21837 .30495 L
.2184 .31396 L
.21843 .32045 L
.21846 .32349 L
.2185 .32683 L
.21861 .3372 L
.21888 .36719 L
.21981 .51516 L
.22006 .5636 L
.22012 .5771 L
.22016 .58214 L
.2202 .58639 L
.22023 .59 L
.22025 .58934 L
.22026 .58748 L
.22029 .58407 L
.22031 .5822 L
.22032 .58044 L
Mistroke
.22035 .58214 L
.22038 .58471 L
.22041 .58714 L
.22044 .59055 L
.22047 .59556 L
.2205 .60018 L
.22053 .60332 L
.22054 .60097 L
.22056 .59877 L
.22081 .57087 L
.22174 .45776 L
.22273 .2888 L
.22297 .24195 L
.22301 .2401 L
.22302 .23715 L
.22304 .23391 L
.22307 .22712 L
.22311 .22006 L
.22317 .20326 L
.22323 .18746 L
.22326 .18069 L
.22329 .17451 L
.22332 .17479 L
.22334 .1751 L
.22337 .17539 L
.2234 .17262 L
.22342 .16772 L
.22345 .16232 L
.22348 .15592 L
.22351 .15648 L
.22354 .15716 L
.22356 .15751 L
.22357 .15789 L
.2236 .15545 L
.22363 .15295 L
.22366 .15036 L
.22369 .14556 L
.22372 .13907 L
.22375 .13302 L
.22378 .12895 L
.22379 .12895 L
.22381 .12895 L
.22384 .12895 L
.22387 .12837 L
.22389 .12432 L
.22392 .11993 L
.22393 .11743 L
.22395 .11473 L
.22398 .11187 L
.22401 .10966 L
Mistroke
.22405 .10722 L
.22416 .10032 L
.22428 .09308 L
.2244 .08484 L
.22461 .06433 L
.22467 .05982 L
.2247 .05684 L
.22473 .05483 L
.22476 .05456 L
.22478 .05426 L
.22481 .05397 L
.22484 .05303 L
.2249 .05065 L
.22494 .04947 L
.22497 .0484 L
.225 .04741 L
.22502 .04763 L
.22503 .04841 L
.22506 .04989 L
.22509 .05125 L
.22511 .05136 L
.22512 .0494 L
.22516 .04528 L
.22519 .04172 L
.22521 .04047 L
.22522 .04055 L
.22525 .0407 L
.22528 .04085 L
.22531 .04095 L
.22534 .04095 L
.22537 .04095 L
.22539 .04095 L
.2254 .0416 L
.22543 .04345 L
.22546 .04519 L
.22548 .04623 L
.2255 .04612 L
.22553 .04442 L
.22556 .04259 L
.2256 .04002 L
.22563 .03707 L
.22566 .03435 L
.22569 .03114 L
.22572 .02657 L
.22575 .02275 L
.22577 .01865 L
.2258 .01717 L
.22583 .01613 L
.22586 .01494 L
.22588 .01472 L
Mistroke
.2259 .01507 L
.22593 .01572 L
.22594 .01606 L
.22596 .01642 L
.22599 .01892 L
.22601 .02206 L
.22605 .02562 L
.22607 .02742 L
.2261 .02728 L
.22613 .02713 L
.22616 .02706 L
.22619 .02871 L
.22622 .03043 L
.22625 .03229 L
.22628 .03114 L
.22631 .02934 L
.22633 .02781 L
.22635 .0265 L
.22638 .02681 L
.22641 .02709 L
.22644 .0274 L
.22646 .02844 L
.22652 .03095 L
.22658 .03358 L
.22661 .03474 L
.22664 .03574 L
.22666 .03491 L
.22669 .03404 L
.22675 .03197 L
.2268 .0292 L
.22686 .02664 L
.22688 .02596 L
.2269 .02532 L
.22693 .02563 L
.22696 .03093 L
.22699 .03669 L
.22702 .04143 L
.22705 .03976 L
.22708 .03778 L
.2271 .03596 L
.22713 .03535 L
.22716 .03551 L
.22719 .03566 L
.22721 .03575 L
.22722 .03533 L
.22725 .03437 L
.22728 .03334 L
.2273 .03236 L
.22733 .03304 L
.22735 .03439 L
Mistroke
.22738 .03582 L
.22741 .03659 L
.22744 .03527 L
.22746 .03386 L
.2275 .03236 L
.22751 .03273 L
.22753 .0336 L
.22756 .03513 L
.22759 .03656 L
.22761 .03712 L
.22762 .03753 L
.22765 .03833 L
.22768 .03907 L
.2277 .03947 L
.22773 .03961 L
.22776 .03976 L
.22779 .03995 L
.22782 .04295 L
.22785 .04578 L
.2279 .05203 L
.22814 .07696 L
.22821 .08596 L
.22824 .09048 L
.22827 .09449 L
.22829 .09574 L
.2283 .09707 L
.22832 .09852 L
.22834 .09989 L
.22836 .10113 L
.22837 .10145 L
.22841 .10128 L
.22844 .10112 L
.22845 .10103 L
.22847 .10111 L
.22848 .10129 L
.2285 .10145 L
.22852 .10165 L
.22853 .10182 L
.22856 .10262 L
.22859 .10451 L
.22865 .10778 L
.22871 .10872 L
.22872 .10897 L
.22874 .10924 L
.22877 .11164 L
.2288 .11407 L
.22883 .11667 L
.22886 .11785 L
.22888 .11827 L
.22891 .11874 L
Mistroke
.22894 .11842 L
.22897 .11305 L
.229 .10722 L
.22902 .10413 L
.22903 .10152 L
.22905 .10161 L
.22907 .10171 L
.22909 .10187 L
.22911 .10196 L
.22913 .10195 L
.22914 .10125 L
.22916 .1005 L
.22919 .09913 L
.22922 .09797 L
.22925 .09874 L
.22939 .10354 L
.22942 .10401 L
.22944 .09999 L
.22948 .09535 L
.2295 .09113 L
.22953 .09282 L
.22956 .09512 L
.22961 .10084 L
.22967 .10874 L
.2297 .11324 L
.22973 .11417 L
.22976 .11502 L
.22979 .11581 L
.22982 .11804 L
.22985 .12093 L
.22991 .12826 L
.22998 .13925 L
.23005 .14695 L
.23011 .15753 L
.23024 .18345 L
.23035 .20793 L
.23135 .38459 L
.23159 .43042 L
.23185 .48638 L
.23196 .51552 L
.23199 .52461 L
.23202 .52848 L
.23207 .53404 L
.2321 .53649 L
.23213 .53789 L
.2322 .54139 L
.23231 .54633 L
.23252 .5535 L
.23255 .55812 L
.23258 .55996 L
Mistroke
.2326 .55979 L
.23262 .5596 L
.23265 .55927 L
.23267 .55688 L
.23271 .55193 L
.23273 .5476 L
.23276 .54357 L
.23278 .54348 L
.23279 .54339 L
.23282 .54323 L
.23284 .54314 L
.23286 .54382 L
.23287 .54666 L
.23289 .54925 L
.23292 .55426 L
.23293 .5569 L
.23295 .55835 L
.23298 .55189 L
.23301 .5459 L
.23304 .53968 L
.23306 .53786 L
.23307 .53662 L
.2331 .53438 L
.23313 .53191 L
.23316 .53165 L
.23318 .53234 L
.23324 .53382 L
.2333 .53509 L
.23333 .53574 L
.23334 .53652 L
.23336 .53736 L
.23339 .53913 L
.23341 .54006 L
.23343 .54099 L
.23344 .54073 L
.23346 .54045 L
.23349 .53996 L
.23352 .53945 L
.23355 .53672 L
.23358 .53373 L
.2336 .53216 L
.23361 .5305 L
.23364 .52107 L
.23367 .51153 L
.23373 .4971 L
.23396 .44504 L
.23406 .42313 L
.23412 .41099 L
.23415 .40396 L
.23417 .39735 L
Mistroke
.2342 .39397 L
.23423 .39489 L
.23426 .39576 L
.23429 .39588 L
.23432 .39101 L
.23435 .38588 L
.2344 .37772 L
.23464 .33999 L
.23508 .29062 L
.236 .17253 L
.23624 .13997 L
.23636 .12295 L
.23638 .11604 L
.23641 .11222 L
.23644 .10869 L
.23647 .10538 L
.23648 .10365 L
.2365 .10441 L
.23653 .10584 L
.23656 .10738 L
.23658 .10824 L
.23659 .10824 L
.23661 .10824 L
.23663 .10824 L
.23666 .10824 L
.23668 .10798 L
.23669 .10664 L
.23673 .10362 L
.23676 .10128 L
.23679 .10066 L
.23682 .10097 L
.23685 .10131 L
.23686 .10148 L
.23688 .10042 L
.23691 .09788 L
.23697 .0931 L
.23703 .0883 L
.23706 .08578 L
.23709 .08428 L
.23711 .0831 L
.23714 .0818 L
.23717 .08184 L
.2372 .08266 L
.23723 .08369 L
.23725 .08428 L
.23726 .0854 L
.23729 .08785 L
.23731 .08914 L
.23733 .09054 L
.23736 .09195 L
Mistroke
.23738 .0912 L
.23745 .08954 L
.23748 .08853 L
.23749 .08799 L
.23751 .08742 L
.23753 .08688 L
.23754 .08708 L
.23757 .09162 L
.2376 .09601 L
.23763 .10075 L
.23766 .10115 L
.23769 .10129 L
.23772 .10146 L
.23775 .10244 L
.23777 .10325 L
.23778 .104 L
.2378 .10487 L
.23782 .10567 L
.23783 .10665 L
.23785 .1081 L
.23789 .11116 L
.23792 .11381 L
.23793 .11484 L
.23795 .11546 L
.23798 .1166 L
.23801 .11764 L
.23804 .1177 L
.23807 .11702 L
.2381 .11644 L
.23812 .11506 L
.23815 .11217 L
.23818 .1095 L
.23821 .10641 L
.23823 .10566 L
.23826 .10566 L
.23828 .10566 L
.23829 .10566 L
.23831 .1059 L
.23833 .10761 L
.23836 .11071 L
.23839 .11353 L
.23842 .11343 L
.23845 .11083 L
.23847 .10843 L
.23853 .10345 L
.23863 .0936 L
.23866 .08994 L
.23869 .08602 L
.23871 .08507 L
.23874 .08465 L
Mistroke
.23877 .08418 L
.2388 .08451 L
.23883 .08611 L
.23886 .08784 L
.23892 .09108 L
.23895 .09293 L
.23898 .09469 L
.239 .09226 L
.23903 .08934 L
.23906 .0867 L
.23909 .08512 L
.2391 .08469 L
.23912 .08423 L
.23915 .08342 L
.23918 .08261 L
.23922 .08187 L
.23925 .08123 L
.23926 .08086 L
.23928 .08225 L
.23934 .08846 L
.23937 .09092 L
.23938 .09025 L
.2394 .08963 L
.23943 .08849 L
.23945 .08791 L
.23946 .08802 L
.23949 .09005 L
.23952 .09225 L
.23955 .0942 L
.23958 .09174 L
.23961 .08905 L
.23964 .08618 L
.23966 .0858 L
.23967 .08633 L
.23971 .08737 L
.23972 .08789 L
.23974 .08844 L
.23976 .08787 L
.23978 .08704 L
.23981 .08553 L
.23982 .08474 L
.23984 .08391 L
.23987 .08374 L
.2399 .08358 L
.23993 .08342 L
.23996 .0843 L
.23999 .08532 L
.24002 .08642 L
.24004 .08639 L
.24007 .08503 L
Mistroke
.24013 .08172 L
.24019 .07863 L
.24022 .07707 L
.24025 .07894 L
.24026 .08066 L
.24028 .08228 L
.24031 .08533 L
.24034 .08246 L
.24036 .07715 L
.24039 .07199 L
.24042 .06696 L
.24045 .06473 L
.24047 .0627 L
.2405 .06065 L
.24052 .06005 L
.24055 .06123 L
.24058 .0625 L
.24061 .06369 L
.24063 .0632 L
.24066 .06256 L
.24068 .06222 L
.24069 .06186 L
.24072 .06436 L
.24075 .06799 L
.24078 .0718 L
.2408 .07381 L
.24081 .07485 L
.24084 .07646 L
.24087 .07796 L
.2409 .07929 L
.24092 .0797 L
.24095 .08014 L
.24098 .08062 L
.24101 .0822 L
.24104 .08459 L
.2411 .08873 L
.24113 .09077 L
.24115 .0919 L
.24116 .09296 L
.24118 .09395 L
.24119 .09338 L
.24122 .09117 L
.24125 .08923 L
.24128 .08715 L
.24131 .08656 L
.24133 .0861 L
.24137 .08559 L
.2414 .08631 L
.24142 .08733 L
.24145 .08845 L
Mistroke
.24148 .0898 L
.24151 .09144 L
.24153 .09321 L
.24156 .09512 L
.24159 .09805 L
.24161 .10086 L
.24166 .10655 L
.24169 .11169 L
.24172 .11728 L
.24175 .12255 L
.24178 .12334 L
.24181 .12268 L
.24182 .12231 L
.24184 .12197 L
.24187 .12097 L
.2419 .1195 L
.24192 .11821 L
.24195 .11718 L
.24198 .11796 L
.242 .11882 L
.24203 .11974 L
.24206 .1217 L
.24212 .12644 L
.24261 .16133 L
.24285 .17337 L
.24287 .17416 L
.2429 .17491 L
.24293 .17667 L
.24296 .17839 L
.24298 .17932 L
.24299 .1803 L
.24301 .18275 L
.24303 .18583 L
.24309 .19731 L
.24322 .21544 L
.24326 .22078 L
.24327 .22358 L
.24329 .22592 L
.24331 .22648 L
.24333 .22709 L
.24335 .22764 L
.24336 .22816 L
.24338 .22867 L
.24339 .23086 L
.24342 .23616 L
.24346 .24194 L
.24347 .2451 L
.24349 .24678 L
.24352 .24887 L
.24355 .25118 L
Mistroke
.24358 .25345 L
.24361 .257 L
.24367 .2641 L
.24373 .2727 L
.24375 .27524 L
.24377 .27885 L
.24379 .28505 L
.2438 .29176 L
.24383 .30378 L
.24385 .31014 L
.24387 .31524 L
.24388 .31761 L
.2439 .31977 L
.24393 .324 L
.24395 .32627 L
.24396 .328 L
.24398 .32863 L
.244 .3292 L
.24402 .33031 L
.24405 .33138 L
.24408 .33684 L
.24411 .34286 L
.24433 .38787 L
.24439 .4046 L
.24441 .40938 L
.24443 .41456 L
.24446 .41969 L
.24449 .42311 L
.24452 .42627 L
.24457 .43133 L
.24481 .45201 L
.24493 .46555 L
.24506 .4845 L
.24529 .51166 L
.24539 .5205 L
.24544 .52747 L
.24547 .53129 L
.2455 .53335 L
.24553 .53455 L
.24556 .53564 L
.24559 .53504 L
.24562 .53063 L
.24565 .52637 L
.24568 .52189 L
.2457 .5236 L
.24573 .52555 L
.24574 .52671 L
.24576 .5278 L
.24579 .52749 L
.24582 .52563 L
Mistroke
.24585 .5236 L
.24597 .51414 L
.24641 .48107 L
.24739 .4014 L
.24834 .29288 L
.24925 .21119 L
.24928 .20832 L
.2493 .20562 L
.24932 .20247 L
.24933 .19897 L
.24936 .19288 L
.24939 .18704 L
.24942 .18514 L
.24945 .18487 L
.24947 .18458 L
.2495 .18448 L
.24953 .18514 L
.24956 .18571 L
.24959 .18633 L
.2496 .18447 L
.24962 .18222 L
.24965 .17779 L
.24971 .16917 L
.24974 .16476 L
.24977 .16 L
.24979 .15896 L
.24981 .16003 L
.24984 .16213 L
.24987 .16417 L
.24989 .16483 L
.2499 .1651 L
.24994 .16568 L
.24996 .16597 L
.24997 .16618 L
.25 .16366 L
.25003 .16092 L
.25006 .1586 L
.25009 .15918 L
.25012 .161 L
.25015 .1627 L
.25018 .16169 L
.2502 .15952 L
.25021 .15754 L
.25027 .15069 L
.25033 .14586 L
.25039 .14167 L
.25045 .13884 L
.2505 .13497 L
.25053 .13301 L
.25056 .13232 L
Mistroke
.25059 .13497 L
.25062 .13745 L
.25064 .13972 L
.25067 .13646 L
.2508 .11736 L
.25087 .10819 L
.25093 .10097 L
.25099 .09619 L
.25101 .09375 L
.25104 .09241 L
.25107 .09192 L
.2511 .09146 L
.25112 .09119 L
.25114 .09344 L
.25117 .09796 L
.2512 .10229 L
.25121 .10457 L
.25123 .10575 L
.25126 .10724 L
.25129 .10861 L
.25132 .10978 L
.25134 .10965 L
.25137 .1095 L
.2514 .10934 L
.25143 .11032 L
.25146 .11179 L
.25152 .11467 L
.25155 .11655 L
.25157 .11757 L
.25158 .11854 L
.2516 .11945 L
.25161 .11788 L
.25164 .11413 L
.25167 .11079 L
.2517 .10721 L
.25173 .10655 L
.25175 .10594 L
.25182 .10438 L
.25185 .10342 L
.25187 .10252 L
.2519 .1013 L
.25193 .09941 L
.25198 .09543 L
.25203 .0928 L
.25206 .09143 L
.25208 .09024 L
.25212 .09142 L
.25214 .09252 L
.25217 .09367 L
.2522 .09619 L
Mistroke
.25223 .09884 L
.25226 .10164 L
.25228 .10355 L
.25231 .10487 L
.25234 .10628 L
.25237 .10766 L
.25239 .1069 L
.2524 .10621 L
.25244 .10485 L
.25246 .1036 L
.2525 .10815 L
.25253 .11247 L
.25255 .11653 L
.25258 .11571 L
.25261 .11293 L
.25263 .1101 L
.25266 .10758 L
.25269 .10693 L
.25273 .10625 L
.25278 .10488 L
.25281 .10414 L
.25283 .10344 L
.25286 .1045 L
.25289 .10696 L
.25299 .1163 L
.25302 .11885 L
.25305 .12099 L
.25308 .1219 L
.2531 .12273 L
.25313 .12371 L
.25315 .12216 L
.25317 .12047 L
.2532 .11738 L
.25323 .11405 L
.25324 .11336 L
.25326 .11328 L
.25329 .11311 L
.25335 .11281 L
.25338 .11263 L
.25341 .11247 L
.25344 .11289 L
.25346 .11343 L
.25347 .114 L
.2535 .1149 L
.25353 .11537 L
.25355 .1152 L
.25356 .11502 L
.25359 .1147 L
.25362 .11413 L
.25365 .11249 L
Mistroke
.25368 .11108 L
.25371 .10953 L
.25373 .10915 L
.25376 .10901 L
.25382 .10871 L
.25386 .10844 L
.25389 .10829 L
.25392 .10833 L
.25395 .10848 L
.25397 .10863 L
.254 .10897 L
.25403 .11033 L
.25406 .11164 L
.2541 .11314 L
.25416 .11701 L
.25419 .11889 L
.25422 .11986 L
.25425 .12064 L
.25427 .12137 L
.2543 .12001 L
.25432 .11634 L
.25435 .11255 L
.25438 .10851 L
.25441 .10872 L
.25444 .1092 L
.25451 .11028 L
.25454 .11086 L
.25456 .11115 L
.25458 .11133 L
.25461 .11116 L
.25462 .11108 L
.25464 .11098 L
.25467 .11097 L
.25469 .11533 L
.25476 .12524 L
.25479 .13038 L
.25482 .13514 L
.25485 .13942 L
.25488 .14008 L
.25491 .1389 L
.25494 .13782 L
.25497 .13826 L
.25499 .13929 L
.255 .14043 L
.25512 .14918 L
.25539 .16342 L
.25587 .19627 L
.25634 .23876 L
.25684 .29161 L
.25783 .38731 L
Mistroke
.25808 .41237 L
.25821 .42616 L
.25824 .42821 L
.25827 .43036 L
.2583 .4322 L
.25833 .44002 L
.25836 .44685 L
.25838 .4533 L
.25841 .45781 L
.25844 .45908 L
.25847 .46045 L
.2585 .46151 L
.25852 .45889 L
.25855 .45647 L
.25858 .45382 L
.25861 .45349 L
.25864 .45429 L
.25867 .45515 L
.25868 .45558 L
.2587 .45473 L
.25873 .45319 L
.25876 .45168 L
.25879 .45375 L
.25882 .46029 L
.25885 .46631 L
.25888 .47163 L
.2589 .47163 L
.25891 .47163 L
.25894 .47163 L
.25897 .47171 L
.259 .477 L
.25903 .48181 L
.25905 .48682 L
.25908 .48806 L
.25911 .48537 L
.25913 .48252 L
.25924 .4737 L
.25927 .47197 L
.25929 .47135 L
.25933 .47066 L
.25936 .46991 L
.25939 .46795 L
.25941 .46611 L
.25944 .46446 L
.25947 .45885 L
.2596 .4366 L
.25962 .43581 L
.25966 .43161 L
.25969 .42454 L
.25971 .4181 L
Mistroke
.25977 .4048 L
.2598 .39727 L
.25983 .39036 L
.25986 .39036 L
.2599 .39036 L
.25993 .39036 L
.25996 .39349 L
.25998 .3962 L
.26001 .39914 L
.26004 .39866 L
.26006 .39638 L
.26009 .39364 L
.26012 .39132 L
.26015 .3907 L
.26018 .39001 L
.26021 .38941 L
.26024 .38807 L
.26029 .38543 L
.26039 .38146 L
.26045 .37904 L
.26048 .37768 L
.26051 .37539 L
.26054 .37213 L
.26056 .36863 L
.26062 .36311 L
.26085 .3344 L
.26091 .32249 L
.26098 .31183 L
.26101 .30744 L
.26104 .30281 L
.26107 .29886 L
.2611 .29829 L
.26113 .29924 L
.26115 .29976 L
.26117 .30026 L
.26119 .29891 L
.2612 .2973 L
.26124 .29449 L
.2613 .29018 L
.26133 .28865 L
.26136 .28697 L
.26139 .28323 L
.26142 .2792 L
.26148 .27107 L
.26161 .25708 L
.26164 .25401 L
.26167 .25513 L
.26169 .25602 L
.26171 .25698 L
.26174 .25865 L
Mistroke
.26177 .25778 L
.2618 .25641 L
.26183 .25525 L
.26186 .25236 L
.26198 .237 L
.26201 .2334 L
.26203 .23132 L
.26205 .22736 L
.26208 .22011 L
.26209 .21613 L
.26211 .2124 L
.26214 .20891 L
.26217 .20846 L
.2622 .20804 L
.26222 .20749 L
.26225 .20584 L
.26228 .20433 L
.26235 .20028 L
.2624 .19613 L
.26246 .1911 L
.26249 .18874 L
.26252 .18719 L
.26254 .18799 L
.26257 .18887 L
.2626 .18983 L
.26261 .18969 L
.26263 .18919 L
.26269 .18732 L
.26274 .18598 L
.26277 .18537 L
.2628 .18485 L
.26283 .18469 L
.26286 .18452 L
.26289 .18436 L
.26291 .18434 L
.26293 .18434 L
.26294 .18434 L
.26297 .18434 L
.26301 .1813 L
.26302 .17857 L
.26304 .17602 L
.2631 .16813 L
.26313 .16523 L
.26315 .16255 L
.26318 .16012 L
.2632 .15962 L
.26323 .15917 L
.26325 .15876 L
.26328 .15775 L
.26331 .15525 L
Mistroke
.26334 .15291 L
.26336 .15072 L
.26339 .15424 L
.26342 .16001 L
.26345 .16555 L
.26347 .16842 L
.26348 .16933 L
.26351 .17115 L
.26353 .17215 L
.26354 .17306 L
.26357 .17047 L
.2636 .16197 L
.26364 .15287 L
.26365 .14771 L
.26367 .14809 L
.2637 .15027 L
.26372 .15148 L
.26373 .15259 L
.26377 .15312 L
.26378 .15232 L
.2638 .15148 L
.26383 .14995 L
.26386 .14768 L
.26389 .1447 L
.26391 .14151 L
.26394 .13814 L
.26397 .13676 L
.26408 .12919 L
.26411 .12624 L
.26413 .12476 L
.26415 .12468 L
.26417 .12563 L
.2642 .12653 L
.26423 .12738 L
.26426 .1271 L
.26431 .12657 L
.26433 .12632 L
.26436 .12618 L
.26439 .12602 L
.26442 .12586 L
.26445 .12957 L
.26448 .13381 L
.26451 .13774 L
.26454 .13657 L
.26456 .13537 L
.26457 .13423 L
.2646 .1321 L
.26464 .12909 L
.26467 .12567 L
.2647 .12292 L
Mistroke
.26473 .12443 L
.26476 .12704 L
.26479 .12949 L
.26482 .13079 L
.26485 .13032 L
.26491 .12909 L
.26513 .12605 L
.26516 .12325 L
.26518 .12061 L
.26521 .12233 L
.26524 .12466 L
.26527 .12724 L
.26529 .12848 L
.2653 .12873 L
.26536 .12967 L
.26538 .13002 L
.26541 .13017 L
.26544 .13033 L
.26547 .13048 L
.2655 .1297 L
.26553 .12883 L
.26555 .12803 L
.26558 .1274 L
.26561 .1274 L
.26563 .1274 L
.26566 .1274 L
.26568 .12969 L
.2657 .13187 L
.26573 .13562 L
.26575 .13917 L
.26578 .13812 L
.26581 .1353 L
.26584 .13215 L
.26587 .12981 L
.2659 .12818 L
.26593 .12638 L
.26595 .12544 L
.26597 .12315 L
.266 .1175 L
.26603 .1126 L
.26605 .11034 L
.26606 .11071 L
.26618 .11259 L
.26621 .11276 L
.26624 .11297 L
.26627 .11363 L
.2663 .11436 L
.26632 .11472 L
.26634 .11516 L
.26635 .11603 L
Mistroke
.26637 .11683 L
.2664 .11837 L
.26643 .11908 L
.26646 .11455 L
.26649 .10973 L
.26651 .10698 L
.26652 .10438 L
.26655 .10608 L
.26658 .10801 L
.26661 .11004 L
.26663 .11263 L
.26666 .11626 L
.26669 .12011 L
.26672 .12407 L
.26675 .1263 L
.26678 .12836 L
.26679 .12961 L
.26681 .13079 L
.26682 .13138 L
.26684 .13186 L
.2669 .13349 L
.26697 .13492 L
.26699 .13533 L
.267 .1356 L
.26702 .13482 L
.26704 .13397 L
.26707 .13245 L
.2671 .13104 L
.26711 .13246 L
.26713 .13399 L
.26716 .13666 L
.26719 .13923 L
.26722 .13963 L
.26728 .14024 L
.26731 .14056 L
.26734 .1409 L
.26737 .14122 L
.2674 .14036 L
.26743 .13833 L
.26745 .13615 L
.26748 .13419 L
.26751 .13747 L
.26753 .14096 L
.26756 .14479 L
.26759 .14682 L
.26761 .14709 L
.26763 .14734 L
.26764 .14761 L
.26766 .14786 L
.26769 .14878 L
Mistroke
.26772 .1503 L
.26775 .15194 L
.26781 .15696 L
.26784 .15986 L
.26786 .16251 L
.26789 .16245 L
.26792 .1623 L
.26795 .16213 L
.26798 .16461 L
.26819 .18279 L
.26867 .21367 L
.26878 .22196 L
.2688 .22385 L
.26883 .22704 L
.26886 .23336 L
.26888 .23925 L
.26892 .24592 L
.26895 .24527 L
.26897 .24463 L
.269 .24404 L
.26903 .24424 L
.26905 .24482 L
.26908 .24541 L
.26911 .24677 L
.26914 .25174 L
.26917 .25629 L
.26919 .25887 L
.2692 .26159 L
.26922 .26645 L
.26924 .27177 L
.26927 .28145 L
.2693 .29036 L
.26932 .29572 L
.26935 .30153 L
.26938 .30711 L
.26941 .3108 L
.26944 .313 L
.26946 .31542 L
.26958 .32773 L
.26971 .34172 L
.26978 .34779 L
.26981 .35131 L
.26984 .35457 L
.26987 .35715 L
.2699 .35647 L
.26994 .35573 L
.26996 .35537 L
.26997 .35485 L
.27 .3534 L
.27003 .35185 L
Mistroke
.27006 .35023 L
.27009 .3542 L
.27012 .35886 L
.27013 .36131 L
.27015 .36391 L
.27018 .36576 L
.27021 .36666 L
.27023 .36753 L
.27026 .36753 L
.27029 .36544 L
.27032 .3632 L
.27035 .36085 L
.27037 .36056 L
.27038 .36029 L
.27041 .35976 L
.27044 .35932 L
.27047 .3598 L
.2705 .36024 L
.27056 .36098 L
.27059 .36111 L
.27061 .36126 L
.27064 .36165 L
.27066 .36294 L
.27069 .36444 L
.27072 .36603 L
.27074 .36688 L
.27077 .36747 L
.2708 .36811 L
.27082 .36848 L
.27083 .36843 L
.27086 .36782 L
.27089 .36718 L
.27092 .36658 L
.27094 .36707 L
.27097 .36768 L
.271 .36833 L
.27103 .36646 L
.27106 .36286 L
.27112 .35627 L
.27118 .35046 L
.27121 .3478 L
.27124 .34642 L
.27127 .34496 L
.27129 .34362 L
.27132 .34537 L
.27134 .34692 L
.27136 .34839 L
.27139 .35131 L
.27142 .35206 L
.27143 .35206 L
Mistroke
.27145 .35206 L
.27147 .35206 L
.27148 .35206 L
.27151 .3515 L
.27154 .3507 L
.27157 .34996 L
.27159 .35013 L
.27162 .3529 L
.27165 .35541 L
.27168 .35826 L
.27171 .3581 L
.27174 .35796 L
.27177 .35781 L
.27179 .35702 L
.27182 .35548 L
.27184 .35383 L
.27187 .35206 L
.2719 .3519 L
.27193 .35176 L
.27196 .35159 L
.27199 .34886 L
.27201 .34518 L
.27204 .34119 L
.27207 .33808 L
.27209 .33808 L
.27211 .33808 L
.27214 .33808 L
.27216 .33793 L
.27219 .337 L
.27222 .33613 L
.27224 .33534 L
.27227 .33269 L
.27238 .32209 L
.27251 .31081 L
.27253 .30714 L
.27254 .30337 L
.27256 .30236 L
.27258 .30143 L
.27259 .30055 L
.27261 .29962 L
.27264 .29887 L
.27267 .30227 L
.2727 .30536 L
.27273 .30905 L
.27276 .3109 L
.27279 .31258 L
.2728 .31345 L
.27282 .3144 L
.27285 .31152 L
.27288 .30698 L
Mistroke
.27291 .3025 L
.27294 .30229 L
.27297 .30502 L
.27299 .30642 L
.27301 .30793 L
.27302 .30883 L
.27304 .30757 L
.27307 .30512 L
.27313 .30037 L
.27315 .29773 L
.27318 .29491 L
.27321 .29224 L
.27323 .2925 L
.27326 .29311 L
.27329 .29369 L
.27332 .29294 L
.27335 .28957 L
.27359 .24758 L
.27385 .21427 L
.27391 .20307 L
.27394 .19736 L
.27397 .19205 L
.274 .18877 L
.27403 .18615 L
.27407 .18378 L
.2741 .18229 L
.27412 .18108 L
.27415 .17976 L
.27418 .17916 L
.27421 .17916 L
.27423 .17916 L
.27426 .17918 L
.2743 .17987 L
.27433 .18051 L
.27436 .18118 L
.27437 .17796 L
.27439 .17451 L
.27442 .16765 L
.27445 .16144 L
.27448 .16046 L
.27451 .15986 L
.27457 .15836 L
.2746 .15732 L
.27462 .15675 L
.27463 .15622 L
.27466 .15722 L
.27469 .1596 L
.27471 .16094 L
.27473 .1622 L
.27476 .1628 L
Mistroke
.27478 .16252 L
.27479 .16225 L
.27483 .16166 L
.27486 .16117 L
.27489 .16071 L
.27491 .16029 L
.27494 .16045 L
.27497 .16175 L
.27499 .16247 L
.275 .16314 L
.27504 .16374 L
.27506 .16209 L
.27509 .16052 L
.27512 .15885 L
.27514 .16022 L
.27517 .16291 L
.27523 .16886 L
.27528 .17453 L
.27531 .17772 L
.27533 .17717 L
.27534 .17604 L
.27538 .17391 L
.2754 .17192 L
.27543 .16733 L
.27547 .16139 L
.27554 .14931 L
.27557 .1441 L
.2756 .13862 L
.27562 .13743 L
.27565 .13774 L
.27568 .13808 L
.2757 .13826 L
.27572 .13663 L
.27575 .13346 L
.27578 .13048 L
.2758 .12888 L
.27583 .13075 L
.27586 .13265 L
.27588 .13365 L
.27589 .13455 L
.27591 .13326 L
.27593 .13206 L
.27596 .12969 L
.27602 .12571 L
.27604 .124 L
.27608 .12216 L
.2761 .11877 L
.27613 .11512 L
.27624 .0993 L
.27627 .09461 L
Mistroke
.27629 .0916 L
.27632 .08888 L
.27635 .0864 L
.27638 .08463 L
.2764 .08424 L
.27642 .08388 L
.27645 .0832 L
.27648 .08288 L
.27651 .08288 L
.27654 .08288 L
.27656 .08288 L
.27657 .08322 L
.2766 .08404 L
.27663 .08486 L
.27665 .0853 L
.27667 .08593 L
.27669 .08684 L
.2767 .08767 L
.27674 .08928 L
.27766 .12796 L
.27789 .14365 L
.27813 .15742 L
.2784 .16901 L
.27853 .17399 L
.27855 .17399 L
.27858 .17468 L
.2786 .1755 L
.27862 .17625 L
.27865 .17772 L
.27867 .1796 L
.2787 .18255 L
.27873 .18551 L
.27875 .18713 L
.27877 .18965 L
.27878 .19366 L
.2788 .1973 L
.27883 .20443 L
.27885 .20819 L
.27886 .21068 L
.27888 .2117 L
.2789 .21264 L
.27896 .21562 L
.27901 .21851 L
.27903 .21936 L
.27905 .21981 L
.27908 .21647 L
.27911 .21303 L
.27914 .20992 L
.27917 .21365 L
.2792 .21766 L
Mistroke
.27923 .22224 L
.27925 .22517 L
.27928 .22675 L
.2793 .22843 L
.27933 .23011 L
.27936 .23028 L
.27939 .23011 L
.27942 .22996 L
.27943 .2301 L
.27945 .23174 L
.27948 .23473 L
.27951 .23753 L
.27954 .24179 L
.27959 .2525 L
.27962 .25785 L
.27965 .25963 L
.27968 .26137 L
.27971 .26322 L
.27974 .2638 L
.27977 .26409 L
.27979 .26438 L
.27982 .2655 L
.27985 .26933 L
.27988 .2734 L
.27991 .27687 L
.27994 .27424 L
.27997 .27117 L
.27998 .26948 L
.28 .26788 L
.28002 .26746 L
.28003 .26719 L
.28006 .26672 L
.28009 .26623 L
.28012 .26354 L
.28017 .25728 L
.2802 .25474 L
.28023 .25474 L
.28026 .25474 L
.28029 .25488 L
.28031 .2594 L
.28034 .26424 L
.28036 .26842 L
.28039 .27196 L
.28042 .2726 L
.28045 .2732 L
.28047 .27379 L
.2805 .274 L
.28053 .27416 L
.28056 .27431 L
.28059 .27575 L
Mistroke
.28062 .2797 L
.28068 .28685 L
.28073 .29307 L
.28074 .29492 L
.28076 .29692 L
.28079 .29796 L
.28081 .29814 L
.28082 .29834 L
.28084 .29851 L
.28086 .29868 L
.28089 .29632 L
.28091 .29361 L
.28093 .29196 L
.28095 .2904 L
.28098 .29267 L
.28101 .29737 L
.28104 .30256 L
.28105 .3047 L
.28107 .30151 L
.2811 .29574 L
.28113 .29029 L
.28116 .29053 L
.28119 .29612 L
.28122 .30223 L
.28124 .30597 L
.28125 .30754 L
.28128 .30754 L
.28132 .30754 L
.28134 .30754 L
.28136 .30762 L
.28139 .3078 L
.28142 .30796 L
.28145 .31045 L
.28146 .31357 L
.28148 .31693 L
.28154 .32803 L
.28158 .33312 L
.28161 .33791 L
.28164 .34005 L
.28165 .33915 L
.28167 .33832 L
.2817 .33687 L
.28173 .33602 L
.28174 .33863 L
.28176 .34101 L
.28179 .34567 L
.2818 .34827 L
.28182 .35044 L
.28184 .35016 L
.28185 .34991 L
Mistroke
.28189 .3494 L
.2819 .34911 L
.28192 .34918 L
.28194 .34975 L
.28195 .35028 L
.28197 .3509 L
.28199 .35146 L
.28202 .35091 L
.28205 .34749 L
.28208 .34428 L
.2821 .34132 L
.28213 .33914 L
.28217 .33684 L
.28219 .33482 L
.28223 .33432 L
.28226 .33416 L
.28229 .33399 L
.28232 .33587 L
.28234 .33838 L
.28241 .34444 L
.28244 .34832 L
.28246 .35036 L
.28247 .35251 L
.2825 .35338 L
.28253 .35215 L
.28259 .34984 L
.28271 .34303 L
.28274 .33949 L
.28276 .33614 L
.28279 .33549 L
.28282 .33717 L
.28284 .33902 L
.28288 .33907 L
.2829 .33076 L
.28293 .32309 L
.28296 .31484 L
.28299 .31187 L
.28302 .3103 L
.28305 .30887 L
.28317 .30316 L
.2832 .29987 L
.28324 .29636 L
.28325 .29473 L
.28327 .29565 L
.2833 .29744 L
.28334 .29911 L
.28335 .29966 L
.28337 .29932 L
.2834 .29864 L
.28343 .29801 L
Mistroke
.28346 .30022 L
.28349 .30573 L
.28351 .31031 L
.28354 .31423 L
.28357 .3091 L
.2836 .30365 L
.28363 .29883 L
.28366 .30203 L
.28371 .30783 L
.28374 .31005 L
.28377 .31127 L
.2838 .3126 L
.28383 .31373 L
.28385 .31344 L
.28388 .31314 L
.2839 .31296 L
.28391 .31278 L
.28395 .31285 L
.28396 .31294 L
.28398 .31303 L
.284 .31313 L
.28402 .31323 L
.28403 .31456 L
.28405 .31609 L
.28408 .31878 L
.28409 .32029 L
.28411 .32191 L
.28414 .32056 L
.28417 .31906 L
.28419 .31827 L
.28421 .31743 L
.28424 .31313 L
.28427 .30908 L
.28432 .30121 L
.28435 .29675 L
.28438 .29202 L
.28439 .28963 L
.28441 .28917 L
.28444 .28981 L
.28447 .29046 L
.2845 .2905 L
.28452 .28754 L
.28455 .28483 L
.28458 .28185 L
.28461 .28119 L
.28464 .28213 L
.28466 .28302 L
.28469 .28211 L
.28472 .27746 L
.28475 .27231 L
Mistroke
.28477 .2696 L
.28479 .26834 L
.2848 .26859 L
.28482 .26887 L
.28485 .26935 L
.28488 .26967 L
.28491 .26922 L
.28493 .26881 L
.28496 .26837 L
.28499 .26436 L
.28502 .25876 L
.28508 .2466 L
.28513 .23868 L
.28515 .23452 L
.28518 .23157 L
.28521 .22914 L
.28524 .22691 L
.28526 .22578 L
.28529 .22882 L
.28532 .23199 L
.28535 .23536 L
.28537 .23497 L
.28539 .23419 L
.28542 .23281 L
.28545 .23152 L
.28546 .22925 L
.28548 .227 L
.28551 .2226 L
.28554 .21851 L
.28556 .21694 L
.28559 .21617 L
.28562 .21531 L
.28565 .21304 L
.28571 .20525 L
.28573 .20133 L
.28576 .20176 L
.28578 .20229 L
.2858 .20286 L
.28583 .20387 L
.28586 .20386 L
.28589 .20371 L
.2859 .20362 L
.28592 .20353 L
.28594 .20284 L
.28596 .20191 L
.28602 .19836 L
.28627 .18209 L
.28629 .1809 L
.28632 .17775 L
.28635 .17263 L
Mistroke
.28638 .16798 L
.2864 .16274 L
.28643 .16486 L
.28646 .1674 L
.28649 .1701 L
.28652 .17174 L
.28655 .17284 L
.28658 .17404 L
.2866 .17408 L
.28662 .17282 L
.28665 .17065 L
.28668 .16829 L
.28671 .167 L
.28673 .16656 L
.28676 .16611 L
.28679 .16547 L
.28682 .15981 L
.28684 .15468 L
.28687 .1502 L
.28689 .1465 L
.28692 .14383 L
.28695 .14137 L
.28697 .13872 L
.287 .1429 L
.28705 .15286 L
.28707 .15578 L
.28709 .15761 L
.28712 .16038 L
.28717 .16558 L
.28723 .17109 L
.28726 .17413 L
.28729 .17576 L
.28732 .1771 L
.28735 .17855 L
.28737 .1778 L
.2874 .17547 L
.28743 .17246 L
.28746 .17036 L
.28749 .17036 L
.28752 .17036 L
.28754 .17036 L
.28755 .17018 L
.28757 .16892 L
.28759 .16775 L
.28762 .16548 L
.28765 .1639 L
.28768 .16627 L
.28771 .16885 L
.28774 .17096 L
.28776 .17138 L
Mistroke
.28778 .17183 L
.28789 .17498 L
.28796 .17647 L
.28799 .17702 L
.28801 .17732 L
.28803 .1776 L
.28806 .1771 L
.28809 .17654 L
.28812 .17606 L
.28815 .17855 L
.28819 .18113 L
.28822 .18355 L
.28825 .18185 L
.28828 .17942 L
.28831 .17733 L
.28834 .17825 L
.28837 .17977 L
.2884 .18122 L
.28842 .18223 L
.28843 .18347 L
.28847 .18623 L
.28853 .19244 L
.28856 .1974 L
.28858 .20012 L
.2886 .20264 L
.28863 .20361 L
.28867 .20437 L
.2887 .20502 L
.28872 .20678 L
.28876 .20888 L
.28879 .21082 L
.2888 .21049 L
.28882 .20906 L
.28885 .20605 L
.28888 .20345 L
.2889 .20266 L
.28892 .20223 L
.28894 .20146 L
.28898 .20065 L
.289 .19925 L
.28903 .19726 L
.28906 .19511 L
.28908 .19391 L
.28909 .19158 L
.28912 .18633 L
.28915 .18141 L
.28918 .17724 L
.28921 .17943 L
.28927 .18408 L
.28939 .1953 L
Mistroke
.2895 .2066 L
.28953 .20957 L
.28956 .21274 L
.28958 .21197 L
.28961 .21102 L
.28963 .21049 L
.28965 .20994 L
.28966 .21008 L
.28968 .21063 L
.28972 .21173 L
.28975 .21275 L
.28978 .21515 L
.28981 .21782 L
.28983 .21934 L
.28984 .22078 L
.28987 .21883 L
.2899 .21651 L
.28993 .21435 L
.28996 .21349 L
.28999 .21383 L
.29002 .21416 L
.29004 .21435 L
.29005 .21436 L
.29008 .21436 L
.29011 .21436 L
.29014 .21401 L
.29016 .21337 L
.29017 .21278 L
.2902 .21171 L
.29023 .21017 L
.29026 .20704 L
.29029 .20413 L
.29031 .20105 L
.29034 .20128 L
.29037 .20367 L
.29039 .20493 L
.29041 .20627 L
.29042 .20725 L
.29044 .20781 L
.29047 .20879 L
.2905 .20973 L
.29053 .21233 L
.29056 .21614 L
.29059 .21963 L
.29061 .22249 L
.29064 .2207 L
.29067 .21915 L
.29069 .21747 L
.29072 .21705 L
.29075 .21828 L
Mistroke
.29078 .21947 L
.2908 .22056 L
.29083 .21894 L
.29086 .21715 L
.29089 .21541 L
.29092 .21561 L
.29095 .21656 L
.29098 .21745 L
.291 .21665 L
.29103 .2124 L
.29106 .20768 L
.29109 .20279 L
.29111 .201 L
.29113 .19903 L
.29116 .19558 L
.29119 .19289 L
.29121 .19444 L
.29122 .19586 L
.29125 .19864 L
.29128 .20121 L
.29131 .19876 L
.29133 .19567 L
.29136 .19257 L
.29139 .19404 L
.29142 .19862 L
.29145 .20354 L
.29148 .2068 L
.2915 .20557 L
.29153 .20405 L
.29155 .20322 L
.29157 .20246 L
.2916 .20314 L
.29163 .20375 L
.29164 .2041 L
.29166 .20448 L
.29169 .20343 L
.29173 .20214 L
.29174 .20143 L
.29176 .20107 L
.29179 .20244 L
.29182 .20369 L
.29185 .20486 L
.29188 .20873 L
.29191 .21315 L
.29194 .2178 L
.29196 .2197 L
.29198 .22118 L
.29201 .22377 L
.29207 .22804 L
.2921 .22963 L
Mistroke
.29212 .23108 L
.29215 .23208 L
.29218 .23236 L
.29223 .23297 L
.29226 .2333 L
.2923 .23365 L
.29232 .23394 L
.29235 .23616 L
.29242 .24271 L
.29248 .25092 L
.29251 .25512 L
.29253 .25595 L
.29255 .25533 L
.29258 .25409 L
.29261 .25298 L
.29264 .25098 L
.29267 .24877 L
.29269 .24644 L
.29273 .24576 L
.29276 .24799 L
.29279 .25044 L
.29281 .25161 L
.29283 .25069 L
.29286 .24905 L
.29288 .24826 L
.2929 .2474 L
.29291 .24726 L
.29293 .24784 L
.29296 .24894 L
.29299 .2501 L
.29302 .24934 L
.29305 .24673 L
.29307 .24432 L
.2931 .24177 L
.29313 .23396 L
.29316 .22561 L
.29319 .21788 L
.29322 .22205 L
.29327 .23083 L
.2933 .23396 L
.29332 .23365 L
.29335 .23332 L
.29338 .23302 L
.29341 .23247 L
.29344 .23186 L
.29345 .23151 L
.29347 .23114 L
.2935 .23238 L
.29352 .2337 L
.29354 .23494 L
Mistroke
.29357 .23725 L
.29363 .24182 L
.29365 .24308 L
.29366 .24441 L
.2937 .24302 L
.29372 .24089 L
.29375 .2386 L
.29378 .23904 L
.29381 .24129 L
.29393 .24895 L
.29399 .25337 L
.29402 .25624 L
.29405 .25886 L
.29408 .25706 L
.29411 .25393 L
.29412 .25231 L
.29414 .25053 L
.29417 .25172 L
.29439 .26171 L
.29442 .26677 L
.29444 .26862 L
.29446 .26836 L
.29448 .26789 L
.2945 .26764 L
.29452 .26737 L
.29453 .26679 L
.29455 .26547 L
.29459 .26259 L
.2946 .26122 L
.29462 .25993 L
.29465 .25978 L
.29468 .26026 L
.29471 .26076 L
.29474 .26181 L
.29477 .26354 L
.2948 .2654 L
.29481 .26637 L
.29483 .26692 L
.29486 .2676 L
.29489 .26823 L
.29492 .26864 L
.29494 .26846 L
.29495 .26829 L
.29498 .26799 L
.29501 .26759 L
.29504 .2661 L
.29506 .26471 L
.29509 .26324 L
.29512 .26259 L
.29515 .26276 L
Mistroke
.29517 .26285 L
.29519 .26294 L
.2952 .26297 L
.29522 .26272 L
.29525 .26224 L
.29528 .26176 L
.29531 .26189 L
.29534 .26285 L
.29536 .26373 L
.29539 .26456 L
.29542 .2631 L
.29544 .26182 L
.29547 .26042 L
.2955 .25971 L
.29553 .26048 L
.29555 .26123 L
.29558 .26193 L
.29561 .26198 L
.29564 .26198 L
.29567 .26198 L
.2957 .26232 L
.29573 .26277 L
.29575 .26325 L
.29578 .26178 L
.29581 .25486 L
.29584 .24729 L
.29587 .23929 L
.29588 .23651 L
.2959 .23349 L
.29593 .22818 L
.29596 .22317 L
.29598 .22216 L
.296 .22125 L
.29605 .2178 L
.29611 .21913 L
.29614 .22006 L
.29617 .21809 L
.2962 .2139 L
.29623 .20937 L
.29625 .20553 L
.29628 .20526 L
.29631 .20492 L
.29634 .20461 L
.29637 .2034 L
.2964 .20178 L
.29642 .20092 L
.29644 .20011 L
.29647 .20213 L
.29654 .20817 L
.29665 .21986 L
Mistroke
.29669 .22266 L
.2967 .22419 L
.29672 .22562 L
.29675 .23155 L
.29678 .23937 L
.29684 .2525 L
.2969 .26387 L
.29692 .2672 L
.29694 .26869 L
.29697 .27148 L
.297 .27413 L
.29701 .27544 L
.29703 .27535 L
.29706 .27518 L
.29709 .27503 L
.29712 .27509 L
.29715 .2757 L
.29717 .27632 L
.2972 .27698 L
.29722 .27716 L
.29724 .27735 L
.29727 .27768 L
.2973 .27801 L
.29732 .2785 L
.29733 .27899 L
.29736 .27989 L
.29739 .28087 L
.29742 .28357 L
.29744 .28675 L
.2975 .2942 L
.29753 .2986 L
.29755 .30337 L
.29758 .30787 L
.2976 .30946 L
.29763 .31006 L
.29766 .31071 L
.29769 .31137 L
.29771 .31285 L
.29783 .3276 L
.29786 .33454 L
.29789 .33953 L
.29792 .34374 L
.29795 .34756 L
.29798 .35024 L
.29801 .35172 L
.29804 .35334 L
.29807 .35315 L
.2981 .34773 L
.29812 .34268 L
.29815 .33718 L
Mistroke
.29818 .33456 L
.2982 .33379 L
.29822 .33308 L
.29823 .33241 L
.29825 .33168 L
.29828 .33371 L
.29831 .33709 L
.29833 .33897 L
.29834 .34076 L
.29836 .34012 L
.29838 .33743 L
.29841 .33251 L
.29843 .32982 L
.29844 .32727 L
.29847 .32773 L
.2985 .32881 L
.29853 .32983 L
.29856 .33057 L
.29859 .33108 L
.29862 .33154 L
.29865 .32988 L
.29867 .32673 L
.29868 .3238 L
.29874 .31364 L
.2988 .30457 L
.29882 .3023 L
.29884 .30038 L
.29885 .29919 L
.29887 .29806 L
.29889 .29702 L
.2989 .29593 L
.29893 .29527 L
.29896 .29727 L
.29899 .29941 L
.29902 .30113 L
.29905 .29775 L
.29908 .29376 L
.29909 .29166 L
.29911 .28944 L
.29914 .28788 L
.29917 .2868 L
.2992 .28578 L
.29922 .28415 L
.29925 .28141 L
.29928 .27891 L
.29931 .27672 L
.29933 .27562 L
.29936 .27457 L
.29938 .2736 L
.29941 .27159 L
Mistroke
.29943 .26955 L
.29945 .26769 L
.29951 .26065 L
.29962 .24629 L
.29985 .20898 L
.29992 .20476 L
.29995 .20261 L
.29997 .20153 L
.29999 .1993 L
.3 .19637 L
.30002 .19322 L
.30005 .18752 L
.30008 .1827 L
.30011 .18055 L
.30014 .17833 L
.30017 .17601 L
.3002 .17506 L
.30023 .17419 L
.30028 .17239 L
.30032 .17149 L
.30035 .17066 L
.30038 .1693 L
.3004 .16734 L
.30046 .16291 L
.30049 .15966 L
.30052 .15613 L
.30054 .15279 L
.30057 .15181 L
.30059 .15196 L
.30062 .15212 L
.30065 .15209 L
.30068 .15017 L
.30079 .13868 L
.30082 .13524 L
.30084 .13219 L
.30087 .13059 L
.3009 .12913 L
.30093 .12776 L
.30095 .12919 L
.30097 .13196 L
.301 .13492 L
.30102 .1366 L
.30103 .13772 L
.30106 .13756 L
.3011 .13737 L
.30112 .13728 L
.30113 .13723 L
.30116 .13723 L
.30119 .13723 L
.3012 .13723 L
Mistroke
.30122 .13705 L
.30125 .13453 L
.30128 .13214 L
.30131 .12989 L
.30133 .12991 L
.30134 .13063 L
.30137 .13189 L
.3014 .1331 L
.30143 .13122 L
.30145 .12782 L
.30148 .12408 L
.30151 .12174 L
.30154 .12676 L
.30157 .13217 L
.30159 .13524 L
.30161 .13617 L
.30163 .13046 L
.30166 .12431 L
.30168 .1211 L
.3017 .11773 L
.30173 .11586 L
.30195 .10458 L
.30201 .10197 L
.30204 .1006 L
.30206 .09985 L
.30207 .09915 L
.3021 .09448 L
.30214 .08855 L
.30216 .0832 L
.30219 .08048 L
.30221 .07969 L
.30223 .07882 L
.30226 .0773 L
.30228 .07682 L
.30229 .07744 L
.30233 .07854 L
.30234 .07906 L
.30236 .07963 L
.30239 .08007 L
.30242 .0804 L
.30245 .0807 L
.30248 .08013 L
.30251 .079 L
.30253 .07836 L
.30254 .07775 L
.30257 .07883 L
.3026 .08226 L
.30263 .08543 L
.30265 .08722 L
.30266 .08795 L
Mistroke
.30268 .08848 L
.3027 .08906 L
.30293 .09678 L
.30298 .10049 L
.30301 .10219 L
.30303 .10374 L
.30305 .10389 L
.30308 .1036 L
.30311 .10328 L
.30314 .10307 L
.30317 .10307 L
.30318 .10307 L
.3032 .10307 L
.30323 .10296 L
.30326 .10104 L
.30329 .09927 L
.30331 .09739 L
.30334 .09631 L
.30337 .09542 L
.3034 .09449 L
.30343 .09357 L
.30346 .09283 L
.30349 .09215 L
.30355 .09069 L
.30358 .08984 L
.30361 .08942 L
.30364 .09468 L
.30367 .1003 L
.30368 .10351 L
.3037 .10654 L
.30373 .10674 L
.30376 .10559 L
.30378 .10452 L
.30381 .10381 L
.30384 .10505 L
.30387 .10638 L
.3039 .10763 L
.30391 .10609 L
.30393 .10401 L
.30396 .10038 L
.30399 .09693 L
.30402 .09916 L
.30405 .10232 L
.30407 .10519 L
.30409 .10668 L
.30411 .10658 L
.30414 .10641 L
.30416 .10633 L
.30417 .10623 L
.30419 .10552 L
Mistroke
.30421 .10408 L
.30424 .10129 L
.30426 .09992 L
.30428 .09865 L
.30431 .10209 L
.30434 .10654 L
.30437 .11052 L
.3044 .11319 L
.30442 .11487 L
.30445 .11666 L
.30448 .11729 L
.30451 .1146 L
.30454 .11166 L
.30455 .11011 L
.30457 .10918 L
.3046 .11347 L
.30463 .11743 L
.30465 .12114 L
.30468 .12233 L
.30471 .12247 L
.30474 .12262 L
.30476 .12293 L
.30479 .12397 L
.30482 .12529 L
.30485 .12652 L
.30486 .12804 L
.30488 .13063 L
.30491 .13515 L
.30493 .1378 L
.30494 .1406 L
.30496 .1404 L
.30498 .13882 L
.30501 .13575 L
.30504 .13296 L
.30507 .13374 L
.3051 .13501 L
.30513 .13635 L
.30515 .13851 L
.30517 .14173 L
.30523 .15384 L
.30528 .16375 L
.30531 .16851 L
.30534 .17192 L
.30537 .16993 L
.30539 .16809 L
.30542 .16595 L
.30545 .17355 L
.30548 .18403 L
.30551 .19367 L
.30554 .19712 L
Mistroke
.30557 .19772 L
.3056 .19838 L
.30563 .19945 L
.30565 .20156 L
.30568 .20382 L
.30571 .20633 L
.30573 .20693 L
.30576 .20659 L
.30578 .20641 L
.30579 .20624 L
.30582 .20608 L
.30585 .20608 L
.30587 .20608 L
.30589 .20608 L
.30592 .2079 L
.30593 .21045 L
.30595 .21282 L
.30599 .21821 L
.30602 .22159 L
.30605 .22351 L
.3061 .22712 L
.30616 .23101 L
.30618 .23208 L
.3062 .23293 L
.30623 .23225 L
.30626 .23162 L
.30629 .23094 L
.30632 .2354 L
.30635 .23962 L
.30637 .24373 L
.3064 .24558 L
.30643 .24589 L
.30645 .24618 L
.30648 .24646 L
.30651 .24646 L
.30654 .24646 L
.30657 .24646 L
.3066 .24631 L
.30663 .24615 L
.30665 .24605 L
.30667 .24596 L
.3067 .24206 L
.30672 .23819 L
.30675 .23457 L
.30678 .23267 L
.30681 .23315 L
.30683 .23354 L
.30686 .23394 L
.30688 .23675 L
.30691 .23987 L
Mistroke
.30703 .25532 L
.30714 .27222 L
.30719 .2785 L
.30721 .28004 L
.30723 .28168 L
.30726 .2829 L
.30728 .28231 L
.30731 .28176 L
.30734 .28117 L
.30737 .28452 L
.30761 .30657 L
.30767 .31891 L
.3077 .32635 L
.30772 .33042 L
.30773 .33218 L
.30776 .33308 L
.30779 .33408 L
.30781 .33493 L
.30784 .33468 L
.30787 .33438 L
.3079 .3341 L
.30792 .33304 L
.30795 .3308 L
.30798 .32889 L
.308 .32709 L
.30803 .328 L
.30805 .32949 L
.30827 .3459 L
.30832 .35306 L
.30835 .35787 L
.30838 .36299 L
.30841 .36514 L
.30844 .36648 L
.30847 .36782 L
.30849 .3677 L
.30851 .36615 L
.30853 .36451 L
.30856 .36158 L
.30862 .35424 L
.30865 .35111 L
.30868 .34946 L
.3087 .35239 L
.30871 .35507 L
.30874 .36031 L
.3088 .37002 L
.30883 .3751 L
.30886 .37986 L
.30889 .38257 L
.30892 .38542 L
.30895 .3886 L
Mistroke
.30898 .38949 L
.309 .3889 L
.30903 .38825 L
.30907 .38787 L
.30909 .38819 L
.30913 .38853 L
.30916 .38876 L
.30917 .38858 L
.30919 .38839 L
.30922 .38805 L
.30925 .38726 L
.30928 .38043 L
.30931 .37376 L
.30933 .37009 L
.30934 .36661 L
.30937 .36445 L
.3094 .36251 L
.30943 .3607 L
.30945 .36109 L
.30947 .36244 L
.30949 .36389 L
.3095 .36517 L
.30952 .36653 L
.30955 .36618 L
.30958 .36399 L
.30965 .35844 L
.30968 .35548 L
.30972 .35279 L
.30974 .35393 L
.30977 .35644 L
.3098 .35913 L
.30983 .36086 L
.30986 .36086 L
.30989 .36086 L
.30992 .35782 L
.30994 .352 L
.30996 .34653 L
.30999 .33681 L
.31001 .33147 L
.31002 .32918 L
.31005 .3274 L
.31008 .32578 L
.31009 .32484 L
.31011 .32347 L
.31014 .31908 L
.31017 .31429 L
.31019 .31161 L
.31021 .3107 L
.31024 .3133 L
.31027 .31577 L
Mistroke
.31029 .31804 L
.31032 .31906 L
.31035 .31991 L
.31037 .32038 L
.31039 .32081 L
.31041 .31502 L
.31044 .30637 L
.31047 .29858 L
.3105 .29536 L
.31053 .29714 L
.31056 .29909 L
.31058 .30077 L
.31061 .29797 L
.31063 .2948 L
.31066 .29145 L
.31069 .29017 L
.31072 .29403 L
.31075 .29854 L
.31078 .30222 L
.3108 .30096 L
.31083 .29961 L
.31089 .29622 L
.31113 .28228 L
.31115 .28326 L
.31117 .28286 L
.31118 .2814 L
.3112 .28006 L
.31122 .2785 L
.31124 .27684 L
.31125 .27545 L
.31127 .27525 L
.3113 .27491 L
.31132 .27472 L
.31134 .27454 L
.31135 .27443 L
.31137 .27452 L
.3114 .27468 L
.31143 .27484 L
.31146 .27316 L
.31149 .26882 L
.31152 .26415 L
.31165 .23878 L
.31177 .21472 L
.3118 .20704 L
.31183 .20025 L
.31185 .19873 L
.31188 .19709 L
.31191 .19541 L
.31194 .19546 L
.31196 .19656 L
Mistroke
.31199 .19778 L
.31202 .19796 L
.31204 .19526 L
.31205 .19279 L
.31208 .18826 L
.31211 .18345 L
.31213 .18268 L
.31214 .18195 L
.31217 .18066 L
.31219 .17993 L
.31221 .17918 L
.31222 .18029 L
.31224 .1813 L
.31227 .18329 L
.31229 .18439 L
.3123 .18546 L
.31233 .18879 L
.31236 .19183 L
.31242 .19896 L
.31245 .20243 L
.31248 .20625 L
.31251 .20715 L
.31253 .20608 L
.31254 .20508 L
.31261 .2002 L
.31264 .19737 L
.31266 .19587 L
.31267 .19428 L
.31271 .19324 L
.31274 .1934 L
.31275 .1935 L
.31277 .1936 L
.31279 .19347 L
.31281 .1929 L
.31284 .19181 L
.31287 .19081 L
.3129 .18709 L
.31293 .1826 L
.31296 .17786 L
.31297 .17518 L
.31299 .17686 L
.31302 .18038 L
.31305 .18418 L
.31307 .18751 L
.3131 .1882 L
.31313 .18895 L
.31316 .18977 L
.31319 .18969 L
.3132 .18941 L
.31322 .18915 L
Mistroke
.31324 .18888 L
.31325 .18862 L
.31328 .187 L
.31331 .18476 L
.31333 .18358 L
.31335 .1823 L
.31338 .18084 L
.31341 .17971 L
.31343 .17905 L
.31344 .17842 L
.31348 .17838 L
.3135 .17869 L
.31353 .17898 L
.31356 .17945 L
.31359 .18013 L
.31366 .18189 L
.3137 .18303 L
.31371 .18353 L
.31373 .18407 L
.31376 .18239 L
.31379 .17954 L
.31381 .17804 L
.31382 .17644 L
.31386 .17635 L
.31388 .17746 L
.3139 .1781 L
.31392 .17869 L
.31393 .1785 L
.31395 .17535 L
.31398 .16966 L
.31404 .1598 L
.3141 .1529 L
.31413 .14968 L
.31415 .14859 L
.31416 .14759 L
.31423 .14344 L
.31426 .14199 L
.31428 .14122 L
.3143 .14041 L
.31432 .13927 L
.31433 .13576 L
.31437 .12958 L
.31438 .12657 L
.3144 .12328 L
.31443 .12324 L
.31446 .12632 L
.31449 .12917 L
.31452 .1316 L
.31453 .13243 L
.31455 .13321 L
Mistroke
.31458 .1348 L
.31462 .137 L
.31468 .14177 L
.31473 .14633 L
.31476 .14876 L
.31479 .15137 L
.3148 .14954 L
.31482 .14692 L
.31485 .1418 L
.31488 .137 L
.31491 .13772 L
.31493 .14089 L
.31497 .1443 L
.31498 .146 L
.315 .14649 L
.31503 .14734 L
.31509 .149 L
.31515 .15081 L
.31518 .15223 L
.3152 .15725 L
.31531 .17174 L
.31534 .17392 L
.31537 .17699 L
.3154 .1842 L
.31543 .19211 L
.31545 .19622 L
.31547 .19807 L
.31549 .19746 L
.3155 .19691 L
.31557 .19497 L
.3156 .19433 L
.31563 .19366 L
.31565 .19349 L
.31568 .1976 L
.31572 .20201 L
.31573 .20432 L
.31575 .20655 L
.31576 .20589 L
.31578 .20517 L
.31581 .2039 L
.31587 .20107 L
.3159 .19923 L
.31593 .1975 L
.31596 .19779 L
.31597 .19869 L
.31599 .19966 L
.31602 .20138 L
.31605 .20003 L
.31611 .19457 L
.31614 .19189 L
Mistroke
.31616 .19087 L
.31622 .18852 L
.31628 .18573 L
.3163 .18493 L
.31632 .18409 L
.31633 .18382 L
.31635 .18382 L
.31638 .18382 L
.3164 .18382 L
.31642 .18391 L
.31643 .1859 L
.31645 .18778 L
.31648 .1913 L
.3165 .19328 L
.31651 .19513 L
.31653 .19614 L
.31655 .19721 L
.31657 .19892 L
.31661 .20077 L
.31663 .19874 L
.31666 .19659 L
.31669 .1941 L
.31671 .19299 L
.31672 .19255 L
.31678 .19091 L
.31684 .1873 L
.31686 .18621 L
.31688 .18503 L
.31691 .18382 L
.31692 .18382 L
.31694 .18382 L
.31696 .18382 L
.31698 .18382 L
.31699 .18394 L
.31701 .18454 L
.31704 .1857 L
.31707 .18671 L
.31709 .18754 L
.31713 .18788 L
.31715 .1882 L
.31719 .1882 L
.3172 .18744 L
.31722 .1866 L
.31725 .18512 L
.31728 .18383 L
.31731 .18398 L
.31734 .18415 L
.31736 .1843 L
.31739 .18603 L
.31745 .19137 L
Mistroke
.31748 .19489 L
.31749 .19779 L
.31751 .20049 L
.31754 .20533 L
.31756 .20972 L
.31759 .21011 L
.31761 .21053 L
.31764 .21099 L
.31767 .21111 L
.3177 .2108 L
.31772 .21053 L
.31775 .21016 L
.31778 .20768 L
.31781 .20473 L
.31784 .20205 L
.31787 .20168 L
.3179 .202 L
.31793 .20233 L
.31795 .2027 L
.31797 .2034 L
.31799 .20446 L
.31802 .2056 L
.31805 .20643 L
.31807 .20569 L
.31813 .20408 L
.31819 .20259 L
.31822 .2018 L
.31825 .20265 L
.31827 .2039 L
.31828 .20509 L
.31832 .20731 L
.31833 .20778 L
.31835 .2063 L
.31838 .20363 L
.3184 .20225 L
.31841 .20077 L
.31843 .20037 L
.31845 .20141 L
.31851 .20522 L
.31857 .20825 L
.3186 .20954 L
.31863 .2103 L
.31866 .21046 L
.31869 .21062 L
.31872 .21065 L
.31875 .21016 L
.31877 .20969 L
.31881 .20919 L
.31883 .21122 L
.31886 .21308 L
Mistroke
.31891 .2169 L
.31894 .21942 L
.31897 .22209 L
.31899 .22348 L
.31901 .22328 L
.31904 .22023 L
.31907 .21737 L
.3191 .21511 L
.31913 .21623 L
.31916 .21726 L
.31918 .21829 L
.31921 .21713 L
.31924 .21552 L
.31926 .21405 L
.31932 .21108 L
.31938 .20811 L
.31941 .20705 L
.31944 .20593 L
.31946 .20497 L
.31949 .20598 L
.31952 .20837 L
.31954 .21094 L
.31957 .21333 L
.31959 .21346 L
.31962 .2136 L
.31965 .21376 L
.31968 .21465 L
.31971 .21625 L
.31974 .21794 L
.31976 .21879 L
.31977 .21861 L
.3198 .21763 L
.31983 .21672 L
.31986 .21627 L
.31989 .21892 L
.31994 .22388 L
.31999 .22872 L
.32002 .23121 L
.32005 .23317 L
.32008 .23062 L
.32011 .22824 L
.32013 .22684 L
.32015 .22578 L
.32018 .22611 L
.3202 .2264 L
.32023 .22671 L
.32026 .22835 L
.32029 .23023 L
.32055 .25099 L
.32103 .29397 L
Mistroke
.32155 .34604 L
.32168 .3639 L
.32171 .367 L
.32174 .36994 L
.32177 .37257 L
.3218 .37825 L
.32183 .38405 L
.32186 .39019 L
.32187 .39149 L
.32189 .39046 L
.32192 .38864 L
.32194 .38761 L
.32195 .38664 L
.32197 .3866 L
.32199 .38716 L
.32202 .38827 L
.32205 .38928 L
.32208 .38534 L
.32211 .3814 L
.32214 .37725 L
.32217 .37717 L
.3222 .37994 L
.32222 .38286 L
.32225 .38516 L
.32228 .38473 L
.32231 .38423 L
.32234 .38375 L
.32235 .382 L
.32237 .37866 L
.3224 .37282 L
.32246 .36314 L
.32248 .35922 L
.32252 .35494 L
.32255 .35238 L
.32258 .35187 L
.32261 .3514 L
.32263 .3507 L
.32266 .34803 L
.32269 .34517 L
.32274 .34012 L
.32277 .33713 L
.3228 .33433 L
.32284 .33246 L
.32285 .33201 L
.32287 .33152 L
.32289 .3311 L
.3229 .33065 L
.32293 .32695 L
.32296 .32148 L
.32299 .3164 L
Mistroke
.32302 .3129 L
.32305 .31337 L
.32307 .31363 L
.32308 .31391 L
.32312 .31389 L
.32315 .31241 L
.32318 .31104 L
.3232 .31035 L
.32321 .31103 L
.32323 .31248 L
.32325 .31379 L
.32328 .31618 L
.3233 .3174 L
.32332 .31757 L
.32335 .31789 L
.32336 .31806 L
.32338 .31825 L
.32341 .31802 L
.32343 .31727 L
.32347 .31641 L
.3235 .31532 L
.32352 .31322 L
.32355 .31125 L
.32358 .30916 L
.3236 .31104 L
.32361 .31296 L
.32364 .31643 L
.32367 .31967 L
.3237 .32109 L
.32373 .32125 L
.32374 .32133 L
.32376 .32143 L
.32379 .32096 L
.32382 .31982 L
.32385 .31876 L
.32386 .31811 L
.32388 .31823 L
.32391 .3192 L
.32394 .32025 L
.32396 .32085 L
.32398 .32014 L
.32401 .31808 L
.32403 .31612 L
.32405 .31504 L
.32407 .31454 L
.32409 .31596 L
.32413 .31765 L
.32414 .3184 L
.32416 .31896 L
.32419 .31912 L
Mistroke
.32422 .3193 L
.32424 .31939 L
.32426 .32007 L
.32429 .32306 L
.32432 .32627 L
.32434 .32809 L
.32436 .32773 L
.32437 .32613 L
.32439 .32461 L
.32442 .32178 L
.32448 .31722 L
.3247 .29573 L
.32476 .28984 L
.32479 .28755 L
.32482 .28543 L
.32484 .2861 L
.32487 .2883 L
.3249 .29071 L
.32493 .29237 L
.32496 .2914 L
.32499 .29037 L
.32502 .28945 L
.32504 .28467 L
.32518 .25992 L
.32523 .24622 L
.32527 .23785 L
.3253 .22995 L
.32533 .22822 L
.32536 .22805 L
.32538 .2279 L
.32541 .22831 L
.32544 .2295 L
.32546 .23061 L
.32549 .23183 L
.32552 .22741 L
.32555 .22211 L
.32558 .21708 L
.32561 .21807 L
.32564 .22123 L
.32565 .22291 L
.32567 .22473 L
.3257 .22618 L
.32572 .22608 L
.32574 .22599 L
.32575 .2259 L
.32577 .22582 L
.3258 .22716 L
.32583 .22998 L
.32586 .23274 L
.32587 .23428 L
Mistroke
.32589 .23381 L
.32592 .23195 L
.32595 .23021 L
.32598 .22907 L
.326 .22951 L
.32601 .22998 L
.32603 .23047 L
.32605 .23098 L
.32607 .23141 L
.32608 .23082 L
.32612 .22953 L
.32615 .22835 L
.32618 .22561 L
.32621 .22188 L
.32628 .21299 L
.32631 .20818 L
.32634 .20301 L
.32637 .19919 L
.3264 .19682 L
.32642 .19444 L
.32645 .19232 L
.32648 .19445 L
.32651 .19642 L
.32654 .19854 L
.32657 .19846 L
.32658 .19779 L
.3266 .19705 L
.32663 .19573 L
.32666 .19316 L
.32669 .18942 L
.32671 .18753 L
.32673 .18551 L
.32674 .18427 L
.32676 .1841 L
.32679 .18379 L
.32682 .18345 L
.32685 .18216 L
.32688 .18022 L
.32698 .17218 L
.32701 .16975 L
.32704 .1688 L
.32707 .16988 L
.32709 .17088 L
.32712 .17189 L
.32715 .17145 L
.32718 .17093 L
.32721 .17045 L
.32724 .17181 L
.32726 .17351 L
.32729 .1753 L
Mistroke
.32732 .17579 L
.32735 .17352 L
.32738 .17145 L
.32744 .16662 L
.32747 .16441 L
.3275 .16201 L
.32752 .16132 L
.32755 .16104 L
.32758 .16074 L
.32761 .16058 L
.32762 .16067 L
.32764 .16076 L
.32767 .16092 L
.32773 .16126 L
.32777 .16143 L
.32778 .16153 L
.3278 .16043 L
.32783 .15718 L
.32785 .15547 L
.32787 .15365 L
.32788 .15207 L
.3279 .15239 L
.32793 .15385 L
.32796 .15526 L
.32799 .15652 L
.32802 .15699 L
.32804 .15743 L
.32806 .15769 L
.32808 .15808 L
.32811 .16025 L
.32813 .16147 L
.32814 .16279 L
.32816 .16403 L
.32818 .16424 L
.32819 .16332 L
.32821 .16231 L
.32823 .16133 L
.32825 .16028 L
.32828 .16057 L
.32831 .1656 L
.32834 .1711 L
.32837 .17536 L
.3284 .17401 L
.32843 .17253 L
.32846 .17105 L
.32849 .16813 L
.32852 .16494 L
.32855 .16155 L
.32857 .1636 L
.32859 .16674 L
Mistroke
.32862 .17288 L
.32863 .17632 L
.32865 .17952 L
.32867 .17795 L
.32869 .17651 L
.32872 .17367 L
.32875 .17137 L
.32877 .17129 L
.32878 .1712 L
.32882 .17101 L
.32885 .17055 L
.32886 .16965 L
.32888 .16865 L
.32891 .16655 L
.32893 .16555 L
.32895 .16493 L
.32898 .1641 L
.32899 .16367 L
.32901 .16321 L
.32904 .16387 L
.32907 .16981 L
.32918 .18942 L
.32924 .19828 L
.32927 .20262 L
.3293 .20667 L
.32933 .20793 L
.32935 .2063 L
.32937 .20455 L
.32943 .19938 L
.32946 .19827 L
.32947 .19768 L
.32949 .19706 L
.32952 .19521 L
.32955 .19186 L
.32958 .18808 L
.32961 .18429 L
.32964 .1788 L
.32967 .17287 L
.32969 .16731 L
.32972 .16469 L
.32975 .16403 L
.32977 .16331 L
.3298 .16262 L
.32982 .16272 L
.32984 .1628 L
.32987 .16296 L
.3299 .16294 L
.32992 .16211 L
.32993 .16132 L
.32997 .15953 L
Mistroke
.33 .15827 L
.33002 .15789 L
.33003 .15755 L
.33006 .15697 L
.33009 .15622 L
.33011 .15476 L
.33012 .15344 L
.33015 .15085 L
.33021 .14602 L
.33024 .14366 L
.33026 .14235 L
.33028 .14112 L
.33031 .14494 L
.33034 .14912 L
.33036 .15305 L
.33039 .15362 L
.33042 .15143 L
.33044 .15022 L
.33046 .14909 L
.33048 .14864 L
.33052 .14982 L
.33054 .15084 L
.33057 .15275 L
.3306 .15776 L
.33062 .16326 L
.33065 .16919 L
.33068 .16999 L
.33071 .16796 L
.33074 .16611 L
.3308 .15976 L
.33083 .15567 L
.33086 .1526 L
.33088 .15225 L
.33089 .15188 L
.33093 .15109 L
.33099 .14945 L
.33102 .14861 L
.33104 .14814 L
.33106 .14655 L
.33109 .14321 L
.33112 .14017 L
.33115 .13985 L
.33118 .144 L
.33121 .14839 L
.33124 .15291 L
.33127 .15488 L
.33129 .15668 L
.33132 .1585 L
.33135 .15958 L
.33138 .16056 L
Mistroke
.33141 .16163 L
.33144 .16282 L
.33147 .16407 L
.3315 .16526 L
.33153 .16545 L
.33154 .16379 L
.33156 .16205 L
.33159 .15894 L
.33162 .15701 L
.33165 .15972 L
.33168 .16268 L
.3317 .16423 L
.33172 .16547 L
.33175 .16661 L
.33178 .16766 L
.3318 .16865 L
.33183 .16537 L
.33186 .16151 L
.33188 .15785 L
.33191 .15529 L
.33193 .15502 L
.33196 .15472 L
.33199 .1544 L
.33201 .15408 L
.33202 .15367 L
.33205 .15288 L
.33208 .15214 L
.33211 .15211 L
.33214 .15287 L
.33216 .15357 L
.33219 .15392 L
.33222 .14986 L
.33228 .14226 L
.33231 .1391 L
.33233 .13668 L
.33237 .13402 L
.33238 .13268 L
.3324 .13386 L
.33251 .14465 L
.33262 .15177 L
.33264 .15146 L
.33268 .1519 L
.33269 .15361 L
.33271 .15516 L
.33274 .1582 L
.33276 .15977 L
.33277 .15933 L
.3328 .1554 L
.33284 .15134 L
.33285 .14919 L
Mistroke
.33287 .14765 L
.3329 .14543 L
.33293 .14337 L
.33295 .14216 L
.33297 .1421 L
.333 .1426 L
.33302 .14303 L
.33305 .14372 L
.33308 .1466 L
.33311 .14927 L
.33314 .15178 L
.33317 .14983 L
.3332 .1468 L
.33323 .14398 L
.33326 .1396 L
.33328 .13458 L
.33331 .12911 L
.33334 .12331 L
.33337 .12442 L
.3334 .12551 L
.33343 .12668 L
.33345 .12655 L
.33346 .1261 L
.33349 .12531 L
.33352 .12456 L
.33353 .12429 L
.33355 .12429 L
.33358 .12429 L
.33361 .12429 L
.33364 .12489 L
.33366 .12612 L
.33369 .12744 L
.33372 .12889 L
.33375 .13299 L
.33381 .14053 L
.33386 .14687 L
.33388 .15034 L
.33391 .15363 L
.33394 .15431 L
.33397 .15431 L
.33399 .15431 L
.33402 .15621 L
.33405 .1619 L
.33408 .16711 L
.3341 .17283 L
.33414 .17014 L
.33416 .16781 L
.33419 .16531 L
.33422 .16433 L
.33425 .16463 L
Mistroke
.33428 .16497 L
.3343 .16517 L
.33431 .16369 L
.33434 .16075 L
.33436 .15919 L
.33438 .15751 L
.33441 .15615 L
.33443 .15675 L
.33446 .15738 L
.33449 .15822 L
.33451 .15908 L
.33453 .15986 L
.33456 .16138 L
.33458 .16224 L
.3346 .16204 L
.33461 .16117 L
.33463 .16037 L
.33466 .15892 L
.33468 .15809 L
.33469 .16046 L
.33473 .16725 L
.33474 .17058 L
.33476 .17366 L
.33479 .17637 L
.33482 .17447 L
.33485 .17286 L
.33487 .17232 L
.33491 .1793 L
.33493 .18584 L
.33497 .19301 L
.33498 .19137 L
.335 .1897 L
.33503 .18651 L
.33506 .18351 L
.33509 .18498 L
.33511 .18694 L
.33517 .19164 L
.33521 .19514 L
.33524 .19842 L
.33526 .20069 L
.33529 .20176 L
.33532 .20293 L
.33535 .204 L
.33538 .20372 L
.33541 .20341 L
.33543 .20315 L
.33546 .20271 L
.33549 .20188 L
.33552 .2011 L
.33553 .20065 L
Mistroke
.33555 .20171 L
.33558 .207 L
.33565 .21819 L
.33568 .22275 L
.33571 .22689 L
.33574 .22954 L
.33577 .22997 L
.33583 .23096 L
.33595 .23332 L
.33598 .23056 L
.33601 .22795 L
.33603 .22744 L
.33604 .22772 L
.33607 .2282 L
.3361 .22867 L
.33613 .23106 L
.33616 .23445 L
.33619 .23751 L
.33622 .24034 L
.33625 .24086 L
.33627 .2413 L
.3363 .24179 L
.33632 .24047 L
.33634 .23919 L
.33637 .23638 L
.33643 .23152 L
.33646 .22943 L
.33649 .22716 L
.33652 .23059 L
.33655 .23485 L
.33657 .239 L
.3366 .2423 L
.33662 .24216 L
.33665 .24201 L
.33668 .24186 L
.33671 .24467 L
.33673 .24878 L
.33676 .25327 L
.33682 .26175 L
.33685 .26499 L
.33688 .26856 L
.33691 .26825 L
.33694 .26774 L
.33695 .26747 L
.33697 .26718 L
.33699 .26716 L
.337 .26716 L
.33703 .26716 L
.33705 .26716 L
.33707 .26716 L
Mistroke
.3371 .26687 L
.33712 .26656 L
.33715 .26627 L
.33718 .26759 L
.33721 .27021 L
.33723 .27262 L
.33726 .27529 L
.33729 .27529 L
.33732 .27512 L
.33735 .27496 L
.33738 .27291 L
.33741 .27014 L
.33743 .26887 L
.33745 .26753 L
.33748 .27209 L
.33751 .27769 L
.33753 .28301 L
.33756 .28552 L
.33759 .28505 L
.33766 .28402 L
.33769 .28354 L
.33772 .28304 L
.33773 .28275 L
.33775 .28356 L
.33778 .28575 L
.33785 .29114 L
.33798 .29875 L
.33801 .29909 L
.33804 .30072 L
.33807 .30335 L
.3381 .30621 L
.33813 .3072 L
.33816 .30132 L
.33819 .29455 L
.33822 .28914 L
.33825 .29134 L
.33828 .29376 L
.33835 .29773 L
.33838 .29916 L
.33841 .30072 L
.33844 .30381 L
.33847 .30718 L
.33858 .32072 L
.3387 .33274 L
.33873 .33689 L
.33876 .34128 L
.33879 .34502 L
.33882 .34591 L
.33884 .34652 L
.33887 .34717 L
Mistroke
.3389 .3472 L
.33893 .34692 L
.33896 .34662 L
.33899 .34633 L
.339 .34623 L
.33902 .34615 L
.33905 .34598 L
.33908 .34582 L
.33911 .34534 L
.33913 .34493 L
.33916 .34448 L
.33919 .34535 L
.33921 .34731 L
.33924 .34899 L
.33926 .35081 L
.33928 .34929 L
.3393 .34736 L
.33933 .34356 L
.33935 .3401 L
.33938 .33923 L
.33941 .3394 L
.33944 .33956 L
.33946 .33972 L
.33948 .34005 L
.33951 .34081 L
.33954 .34144 L
.33957 .34046 L
.3396 .33802 L
.33961 .33678 L
.33963 .33543 L
.33966 .33525 L
.33969 .33835 L
.33972 .34134 L
.33974 .34416 L
.33977 .34398 L
.3398 .34369 L
.33986 .34291 L
.33989 .34249 L
.33991 .34205 L
.33994 .34275 L
.33997 .3462 L
.34 .34989 L
.34002 .35183 L
.34003 .35347 L
.34006 .35151 L
.34009 .34971 L
.3401 .34869 L
.34012 .34759 L
.34015 .34932 L
.34022 .35414 L
Mistroke
.34025 .35604 L
.34029 .35805 L
.3403 .3591 L
.34032 .35878 L
.34034 .35622 L
.34036 .35383 L
.34042 .34364 L
.34045 .33836 L
.34047 .33558 L
.34049 .33261 L
.34052 .33039 L
.34055 .33536 L
.3406 .34517 L
.34066 .35676 L
.34068 .35993 L
.34069 .36334 L
.34073 .36488 L
.34074 .36543 L
.34076 .36595 L
.34079 .36693 L
.34082 .36288 L
.34086 .35764 L
.34089 .35309 L
.34092 .35074 L
.34095 .34881 L
.34097 .34705 L
.34101 .35002 L
.34102 .3529 L
.34104 .35593 L
.34107 .36104 L
.34109 .36249 L
.3411 .36131 L
.34124 .34814 L
.34173 .31561 L
.34195 .28373 L
.342 .27274 L
.34203 .26657 L
.34206 .26563 L
.34207 .26605 L
.34209 .2665 L
.34212 .26732 L
.34215 .26553 L
.34218 .26202 L
.34219 .26002 L
.34221 .25787 L
.34224 .25632 L
.34227 .25747 L
.3423 .25853 L
.34233 .25907 L
.34235 .25832 L
Mistroke
.34236 .25762 L
.3424 .25621 L
.34241 .25542 L
.34243 .25574 L
.34246 .25688 L
.34249 .25793 L
.34252 .25856 L
.34253 .25764 L
.34255 .25663 L
.34258 .25495 L
.34261 .25316 L
.34264 .25254 L
.34266 .25197 L
.3427 .25128 L
.34271 .25148 L
.34273 .25208 L
.34279 .25435 L
.34281 .25474 L
.34282 .25474 L
.34284 .25474 L
.34286 .25474 L
.34287 .25474 L
.34289 .25474 L
.34291 .25639 L
.34293 .25816 L
.34296 .2616 L
.34298 .26342 L
.34299 .26524 L
.34301 .26625 L
.34303 .26736 L
.34306 .26932 L
.34309 .27128 L
.3431 .27423 L
.34312 .27697 L
.34318 .28733 L
.34329 .30216 L
.34332 .30585 L
.34334 .30787 L
.34335 .30979 L
.34339 .31166 L
.34341 .31028 L
.34344 .30885 L
.34347 .30743 L
.34349 .30569 L
.3435 .30379 L
.34353 .30045 L
.34355 .29853 L
.34357 .29673 L
.34358 .29737 L
.3436 .29796 L
Mistroke
.34363 .2992 L
.34366 .30042 L
.34369 .30287 L
.34372 .30545 L
.34378 .30987 L
.34384 .31255 L
.3439 .31565 L
.34391 .31654 L
.34393 .31738 L
.34396 .31666 L
.34398 .31194 L
.34401 .3068 L
.34408 .29809 L
.34414 .29156 L
.34436 .25982 L
.34447 .24787 L
.3445 .24258 L
.34453 .238 L
.34456 .2359 L
.34459 .234 L
.34462 .23199 L
.34464 .23321 L
.34468 .23464 L
.34471 .23596 L
.34473 .23269 L
.34476 .22854 L
.34482 .21962 L
.34487 .21125 L
.3449 .20655 L
.34492 .20791 L
.34495 .21151 L
.34498 .21492 L
.34501 .21629 L
.34504 .21427 L
.34516 .2073 L
.34522 .20249 L
.34524 .20067 L
.34526 .19875 L
.34528 .19712 L
.34529 .19648 L
.34532 .1973 L
.34535 .19807 L
.34538 .19874 L
.3454 .19808 L
.34542 .19749 L
.34553 .19159 L
.34556 .18957 L
.34559 .18944 L
.34561 .18979 L
.34563 .19017 L
Mistroke
.34566 .19084 L
.34569 .19137 L
.34572 .19189 L
.34575 .19237 L
.34577 .19195 L
.3458 .19014 L
.34582 .18919 L
.34584 .18818 L
.34587 .18804 L
.3459 .19125 L
.34593 .19475 L
.34594 .19671 L
.34596 .19645 L
.34598 .19242 L
.346 .1886 L
.34603 .18126 L
.34609 .16943 L
.34612 .163 L
.34615 .15696 L
.34617 .15833 L
.3462 .15989 L
.34622 .1616 L
.34625 .16238 L
.34628 .16175 L
.3463 .16139 L
.34631 .16106 L
.34634 .15953 L
.34636 .15687 L
.34638 .15435 L
.3464 .15018 L
.34643 .14576 L
.34646 .14631 L
.34649 .14708 L
.34652 .14788 L
.34655 .14936 L
.3466 .15273 L
.34663 .1544 L
.34666 .15535 L
.34669 .15639 L
.34672 .15735 L
.34675 .16143 L
.34678 .16613 L
.3468 .17027 L
.34683 .17304 L
.34685 .17413 L
.34688 .17533 L
.34691 .17641 L
.34693 .17657 L
.34696 .17657 L
.34698 .17657 L
Mistroke
.34699 .17657 L
.34702 .1755 L
.34705 .17379 L
.34716 .16512 L
.34722 .16076 L
.34725 .15905 L
.34728 .15743 L
.3473 .15679 L
.34732 .15649 L
.34735 .15597 L
.34741 .15467 L
.34744 .15387 L
.34748 .15302 L
.34749 .1528 L
.34751 .1529 L
.34754 .15307 L
.34757 .15323 L
.34759 .15311 L
.3476 .15278 L
.34763 .15212 L
.34766 .15152 L
.34769 .1491 L
.34772 .14436 L
.34775 .1392 L
.34778 .13506 L
.3478 .13452 L
.34783 .13394 L
.34786 .13329 L
.34789 .1313 L
.34813 .1142 L
.34816 .11331 L
.34819 .11019 L
.34823 .1066 L
.34826 .10352 L
.34827 .10305 L
.34829 .10261 L
.34831 .10214 L
.34833 .10162 L
.34836 .10201 L
.34837 .10407 L
.34839 .106 L
.34842 .10958 L
.34844 .11159 L
.34845 .11192 L
.34848 .11032 L
.34851 .10881 L
.34853 .10795 L
.34854 .1074 L
.34857 .10936 L
.34861 .11149 L
Mistroke
.34862 .11266 L
.34864 .11316 L
.34867 .11167 L
.3487 .11031 L
.34875 .1079 L
.34878 .10681 L
.34881 .10565 L
.34883 .10528 L
.34885 .10622 L
.34888 .10789 L
.34891 .1094 L
.34894 .11025 L
.34896 .11011 L
.34899 .10996 L
.34902 .1098 L
.34903 .1098 L
.34905 .1098 L
.34908 .1098 L
.34911 .1098 L
.34913 .1099 L
.34916 .11005 L
.34919 .1102 L
.34922 .11175 L
.34924 .1157 L
.34927 .11994 L
.3493 .12393 L
.34932 .12391 L
.34935 .12254 L
.34938 .12124 L
.34941 .12055 L
.34944 .12241 L
.34947 .12426 L
.34948 .12519 L
.3495 .12485 L
.34953 .1199 L
.34956 .1153 L
.34959 .11064 L
.34962 .10991 L
.34964 .10951 L
.34967 .10908 L
.3497 .10823 L
.34973 .10644 L
.34975 .10479 L
.34978 .10323 L
.34981 .10231 L
.34984 .10155 L
.34987 .10072 L
.34989 .10078 L
.3499 .10138 L
.34993 .10244 L
Mistroke
.34996 .10345 L
.34999 .10703 L
.35002 .11311 L
.35005 .11997 L
.35007 .12372 L
.35008 .12578 L
.35011 .12826 L
.35014 .13099 L
.35016 .13252 L
.35018 .13342 L
.35021 .13444 L
.35024 .13553 L
.35026 .13615 L
.35028 .13559 L
.35033 .13355 L
.35036 .13245 L
.35039 .12973 L
.35042 .12677 L
.35045 .12402 L
.35048 .12458 L
.35051 .12554 L
.35061 .12789 L
.35067 .12901 L
.3507 .12982 L
.35073 .13059 L
.35074 .13102 L
.35076 .13074 L
.3508 .13016 L
.35081 .12988 L
.35083 .12962 L
.35086 .13156 L
.35089 .13465 L
.35091 .13635 L
.35093 .13795 L
.35094 .13904 L
.35096 .13966 L
.35099 .14075 L
.35102 .14183 L
.35105 .14063 L
.35107 .13757 L
.3511 .13421 L
.35113 .13119 L
.35115 .13194 L
.35116 .13261 L
.35122 .13513 L
.35172 .16113 L
.35175 .16646 L
.35177 .17229 L
.3518 .17648 L
.35183 .17608 L
Mistroke
.35186 .17561 L
.35189 .17511 L
.35191 .177 L
.35194 .17924 L
.35197 .18192 L
.35199 .18329 L
.352 .18311 L
.35203 .1828 L
.35206 .18246 L
.35209 .18303 L
.35212 .18482 L
.35215 .18669 L
.35218 .18818 L
.35221 .18589 L
.35224 .18377 L
.35227 .18175 L
.35229 .18135 L
.35232 .18149 L
.35234 .18161 L
.35237 .18173 L
.3524 .18112 L
.35243 .18046 L
.35246 .17985 L
.35249 .17578 L
.35252 .16999 L
.35255 .16508 L
.35257 .16253 L
.3526 .16237 L
.35263 .16222 L
.35266 .16204 L
.35269 .16123 L
.35272 .16043 L
.35275 .15957 L
.35278 .16006 L
.3528 .16064 L
.35283 .16119 L
.35286 .16218 L
.35289 .16405 L
.35292 .16579 L
.35293 .16686 L
.35295 .16946 L
.35298 .17622 L
.35301 .18227 L
.35304 .18826 L
.35306 .1897 L
.35307 .19127 L
.3531 .19403 L
.35408 .26719 L
.35501 .35026 L
.356 .4233 L
Mistroke
.35613 .41621 L
.35616 .41267 L
.35619 .40902 L
.35622 .41018 L
.35625 .41144 L
.35631 .4141 L
.35634 .41572 L
.35637 .41719 L
.35639 .41832 L
.3564 .4201 L
.35644 .424 L
.35647 .42738 L
.35649 .43183 L
.3565 .43753 L
.35655 .45566 L
.35658 .46353 L
.35661 .46753 L
.35664 .47224 L
.35667 .47632 L
.3567 .47661 L
.35673 .47694 L
.35676 .47727 L
.35679 .4795 L
.35682 .48231 L
.35683 .48379 L
.35685 .48535 L
.35688 .48528 L
.35691 .48422 L
.35693 .48322 L
.35696 .48391 L
.35699 .48811 L
.35701 .49032 L
.35702 .49266 L
.35706 .49476 L
.35708 .49002 L
.35719 .47558 L
.35744 .4475 L
.35788 .38315 L
.35879 .28443 L
.35905 .24468 L
.35911 .22895 L
.35918 .21521 L
.35921 .21 L
.35924 .20509 L
.35927 .20461 L
.3593 .20414 L
.35933 .20371 L
.35935 .20366 L
.35938 .20399 L
.35941 .2043 L
Mistroke
.35944 .20272 L
.35946 .19557 L
.35952 .1795 L
.35955 .17298 L
.35958 .16806 L
.35961 .16276 L
.35963 .16002 L
.35964 .1602 L
.35967 .16052 L
.3597 .16082 L
.35973 .16229 L
.35976 .16689 L
.35979 .17099 L
.35982 .17485 L
.35985 .1725 L
.35987 .17011 L
.35998 .16355 L
.36021 .15067 L
.36024 .1451 L
.36027 .13911 L
.3603 .13464 L
.36033 .13464 L
.36035 .13464 L
.36038 .13464 L
.36041 .1349 L
.36044 .13523 L
.36046 .13541 L
.36048 .13558 L
.36049 .13513 L
.36051 .13416 L
.36054 .13226 L
.36057 .1305 L
.3606 .13204 L
.36063 .1352 L
.36066 .13839 L
.36068 .14019 L
.36069 .14003 L
.36072 .13939 L
.36075 .13871 L
.36078 .13776 L
.36081 .13561 L
.36087 .1316 L
.36092 .12738 L
.36095 .12498 L
.36098 .12439 L
.36101 .12558 L
.36103 .12626 L
.36105 .12687 L
.36108 .1268 L
.36111 .12561 L
Mistroke
.36116 .12307 L
.36138 .10985 L
.36144 .10619 L
.36147 .10337 L
.3615 .10054 L
.36152 .09791 L
.36155 .09684 L
.36158 .09789 L
.36161 .09886 L
.36163 .09986 L
.36166 .10334 L
.36169 .10727 L
.36172 .11088 L
.36175 .11323 L
.36177 .11394 L
.36178 .11469 L
.36185 .11713 L
.36195 .12118 L
.36198 .12275 L
.36201 .12443 L
.36204 .12337 L
.36207 .12164 L
.3621 .11961 L
.36211 .11861 L
.36213 .12039 L
.36219 .12649 L
.36221 .12825 L
.36222 .12914 L
.36224 .13005 L
.36226 .13088 L
.36229 .13239 L
.36231 .13292 L
.36232 .13204 L
.36235 .13046 L
.36238 .12875 L
.36241 .12768 L
.36244 .12724 L
.36247 .12671 L
.36249 .12643 L
.36251 .1263 L
.36254 .12614 L
.36257 .12597 L
.3626 .12595 L
.36261 .1262 L
.36263 .12648 L
.36266 .12697 L
.36269 .12744 L
.3627 .12804 L
.36272 .12867 L
.36276 .12999 L
Mistroke
.36282 .13316 L
.36285 .13486 L
.36288 .13667 L
.36291 .1355 L
.36293 .13437 L
.36296 .13304 L
.36298 .13247 L
.363 .13221 L
.36303 .13174 L
.36306 .13124 L
.36308 .13196 L
.36311 .13362 L
.36314 .1353 L
.36316 .13687 L
.36319 .13627 L
.36322 .13495 L
.36324 .13379 L
.36327 .13342 L
.3633 .13423 L
.36333 .1351 L
.36339 .13627 L
.36342 .13672 L
.36345 .13719 L
.36347 .13675 L
.3635 .13615 L
.36353 .13547 L
.36356 .1354 L
.36358 .13565 L
.36359 .13593 L
.36361 .13621 L
.36363 .13648 L
.36366 .13589 L
.36367 .13501 L
.36369 .13417 L
.36372 .13268 L
.36375 .13265 L
.36378 .13627 L
.3638 .13955 L
.36384 .14334 L
.36386 .14329 L
.36389 .14314 L
.36392 .14301 L
.36394 .14306 L
.36397 .14337 L
.364 .1437 L
.36403 .14416 L
.36405 .14485 L
.36407 .14561 L
.3641 .14694 L
.36413 .14796 L
Mistroke
.36416 .14612 L
.36421 .1428 L
.36428 .13323 L
.36435 .12466 L
.36438 .12198 L
.36441 .11913 L
.36443 .12161 L
.36444 .12389 L
.36447 .12834 L
.3645 .13213 L
.36453 .13395 L
.36456 .13564 L
.36459 .13721 L
.3647 .14484 L
.36476 .15074 L
.36478 .15244 L
.36479 .15384 L
.36483 .15434 L
.36485 .15477 L
.36488 .15524 L
.36491 .1567 L
.36494 .15828 L
.36497 .15975 L
.365 .15996 L
.36503 .15892 L
.36505 .15796 L
.36508 .15709 L
.3651 .15878 L
.36515 .16348 L
.36518 .16564 L
.36521 .16534 L
.36524 .16502 L
.36525 .16485 L
.36527 .16467 L
.3653 .16705 L
.36533 .16928 L
.36538 .17284 L
.36629 .22901 L
.36632 .22935 L
.36635 .2226 L
.36639 .21417 L
.36642 .20651 L
.36645 .20955 L
.36647 .21296 L
.3665 .21669 L
.36654 .21729 L
.36657 .2163 L
.36659 .21538 L
.36663 .21815 L
.36664 .22177 L
Mistroke
.36666 .22507 L
.36673 .23822 L
.36676 .2429 L
.36678 .24538 L
.36679 .24807 L
.36682 .24869 L
.36685 .24825 L
.36688 .24776 L
.36691 .24655 L
.36694 .24421 L
.36697 .24165 L
.36698 .24036 L
.367 .24147 L
.36703 .24728 L
.36706 .25279 L
.36709 .25798 L
.36712 .25879 L
.36715 .25953 L
.36717 .26021 L
.3672 .26371 L
.36726 .27326 L
.36729 .27721 L
.3673 .27767 L
.36732 .27808 L
.36735 .27892 L
.36738 .28009 L
.3674 .28443 L
.36743 .28852 L
.36746 .29281 L
.36749 .2952 L
.36752 .29619 L
.36753 .29669 L
.36755 .29723 L
.36758 .29778 L
.36761 .29793 L
.36762 .29803 L
.36764 .29812 L
.36766 .29822 L
.36767 .29863 L
.36774 .30029 L
.36779 .30147 L
.36781 .30204 L
.36784 .30264 L
.36787 .30515 L
.3679 .30837 L
.36795 .31549 L
.36819 .3466 L
.36824 .35659 L
.36827 .3608 L
.3683 .36526 L
Mistroke
.36833 .36879 L
.36836 .3701 L
.36839 .37132 L
.36842 .37243 L
.36843 .37201 L
.36845 .37066 L
.36848 .36768 L
.3685 .36633 L
.36851 .36489 L
.36854 .36366 L
.3686 .36185 L
.36866 .35961 L
.36869 .35855 L
.36872 .35681 L
.36873 .35506 L
.36875 .35314 L
.36878 .34977 L
.36881 .34691 L
.36884 .34723 L
.36887 .34753 L
.36889 .34781 L
.36892 .34791 L
.36895 .34791 L
.36897 .34791 L
.369 .34809 L
.36903 .34902 L
.36905 .34989 L
.36908 .35094 L
.3691 .35239 L
.36913 .35501 L
.36916 .35781 L
.36919 .36037 L
.36921 .36137 L
.36925 .36253 L
.36926 .36312 L
.36928 .36378 L
.36931 .36171 L
.36934 .35886 L
.36959 .33918 L
.36964 .3268 L
.36967 .32099 L
.3697 .32083 L
.36973 .32065 L
.36976 .32049 L
.36979 .31506 L
.36982 .30878 L
.36984 .30275 L
.36987 .30045 L
.3699 .30075 L
.36993 .30108 L
Mistroke
.36996 .30092 L
.36998 .29822 L
.37 .29527 L
.37003 .29215 L
.37006 .29054 L
.37009 .2907 L
.37012 .29087 L
.37014 .29097 L
.37016 .29064 L
.37019 .29 L
.37022 .2894 L
.37023 .28907 L
.37025 .28786 L
.37028 .2845 L
.37031 .28121 L
.37033 .2781 L
.37036 .27803 L
.37039 .27803 L
.37042 .27803 L
.37044 .2777 L
.37047 .27711 L
.3705 .27649 L
.37053 .27592 L
.37056 .27577 L
.37059 .2756 L
.37061 .27552 L
.37062 .27536 L
.37066 .27469 L
.37068 .27407 L
.37071 .27349 L
.37074 .26741 L
.37077 .25957 L
.37079 .25529 L
.37081 .25131 L
.37082 .24979 L
.37084 .2502 L
.37088 .25094 L
.37094 .25274 L
.37097 .25369 L
.37099 .25419 L
.371 .25473 L
.37103 .25654 L
.37106 .25825 L
.37108 .25925 L
.37109 .2602 L
.37112 .25635 L
.37115 .25155 L
.37117 .24892 L
.37119 .24644 L
.37121 .24595 L
Mistroke
.37122 .24669 L
.37126 .24812 L
.37129 .24939 L
.37132 .24346 L
.37134 .2374 L
.37137 .23091 L
.3714 .22819 L
.37143 .2288 L
.37149 .23064 L
.37152 .23216 L
.37155 .23377 L
.37157 .23461 L
.37158 .2347 L
.37161 .2334 L
.37164 .23219 L
.37167 .2308 L
.3717 .22753 L
.37173 .22454 L
.37194 .20427 L
.37216 .18682 L
.37222 .18118 L
.37228 .17585 L
.37231 .17366 L
.37234 .17142 L
.37237 .17212 L
.3724 .1729 L
.37241 .17337 L
.37243 .17382 L
.37245 .17343 L
.37247 .17268 L
.3725 .17121 L
.37253 .16985 L
.37256 .17477 L
.37259 .18003 L
.37262 .1853 L
.37264 .18529 L
.37266 .18361 L
.3729 .16436 L
.37302 .15317 L
.37308 .14735 L
.3731 .14481 L
.37313 .14354 L
.37316 .14242 L
.37319 .14136 L
.3732 .14086 L
.37322 .14086 L
.37325 .14086 L
.37327 .14086 L
.37328 .14086 L
.37331 .14039 L
Mistroke
.37333 .1398 L
.37335 .13923 L
.37336 .13869 L
.37338 .13818 L
.37341 .1367 L
.37343 .13492 L
.37346 .13285 L
.37349 .13105 L
.37351 .1317 L
.37354 .13238 L
.37357 .13313 L
.37359 .1334 L
.37362 .13266 L
.37365 .13185 L
.37368 .13111 L
.3737 .13114 L
.37373 .13131 L
.37376 .13146 L
.37379 .13188 L
.37381 .13222 L
.37382 .13259 L
.37385 .13322 L
.37388 .13469 L
.37391 .1381 L
.37394 .14173 L
.37396 .14356 L
.37398 .14489 L
.37401 .14627 L
.37404 .14749 L
.37407 .14845 L
.3741 .14751 L
.37412 .14662 L
.37415 .14568 L
.37418 .14358 L
.37421 .14141 L
.37424 .13935 L
.37426 .13663 L
.37429 .13231 L
.37432 .12761 L
.37435 .12287 L
.37437 .1249 L
.37438 .12677 L
.37442 .13043 L
.37445 .13373 L
.37446 .13439 L
.37448 .13501 L
.37452 .13633 L
.37453 .13698 L
.37455 .13739 L
.37458 .13786 L
Mistroke
.37461 .13838 L
.37464 .13867 L
.37467 .13696 L
.3747 .13526 L
.37473 .13342 L
.37474 .13453 L
.37476 .13644 L
.37479 .14019 L
.37482 .14356 L
.37485 .14572 L
.37488 .14719 L
.37491 .14874 L
.37492 .1496 L
.37494 .15268 L
.37497 .15833 L
.375 .16391 L
.37503 .16767 L
.37506 .16888 L
.37508 .17003 L
.37511 .17124 L
.37514 .16776 L
.37517 .16422 L
.3752 .16041 L
.37522 .15865 L
.37525 .15905 L
.37528 .15951 L
.37531 .15998 L
.37532 .15917 L
.37534 .15841 L
.37537 .15677 L
.37544 .1538 L
.37547 .15265 L
.37549 .152 L
.37551 .15065 L
.37553 .14704 L
.37557 .14323 L
.37559 .13989 L
.37562 .13872 L
.37565 .13755 L
.37567 .13691 L
.37569 .13629 L
.37572 .14206 L
.37575 .14789 L
.37578 .15404 L
.37579 .15608 L
.37581 .15651 L
.37584 .15727 L
.37587 .1581 L
.37589 .15956 L
.37592 .16152 L
Mistroke
.37595 .16358 L
.37598 .16566 L
.37599 .16512 L
.37601 .16463 L
.37604 .16366 L
.37607 .16277 L
.3761 .16491 L
.37622 .17191 L
.37634 .18679 L
.3764 .19586 L
.37643 .19987 L
.37645 .20348 L
.37648 .20171 L
.3765 .20005 L
.37653 .19827 L
.37655 .1973 L
.37658 .20015 L
.37661 .20277 L
.37663 .20559 L
.37666 .20638 L
.37669 .20607 L
.37672 .20577 L
.37675 .20671 L
.37678 .20936 L
.37681 .21188 L
.37683 .21424 L
.37686 .2156 L
.37689 .21703 L
.37692 .21845 L
.37695 .21881 L
.37698 .2185 L
.37701 .21822 L
.37704 .21798 L
.37705 .21798 L
.37707 .21798 L
.3771 .21798 L
.37712 .21798 L
.37713 .21784 L
.37716 .2174 L
.37719 .21692 L
.37721 .21652 L
.37724 .21442 L
.37727 .21174 L
.3773 .20919 L
.37731 .20778 L
.37733 .20747 L
.37736 .20715 L
.37739 .20686 L
.37742 .2073 L
.37744 .21078 L
Mistroke
.37747 .21392 L
.37752 .22157 L
.37757 .23073 L
.3776 .2357 L
.37763 .23422 L
.37766 .23216 L
.37767 .23107 L
.37769 .22991 L
.37771 .23094 L
.37772 .23354 L
.37775 .23867 L
.37781 .24929 L
.37786 .26004 L
.37789 .26484 L
.37792 .26342 L
.37795 .26183 L
.37798 .26016 L
.37801 .26064 L
.37804 .2616 L
.37805 .26213 L
.37807 .2627 L
.37809 .26445 L
.3781 .26769 L
.37813 .27421 L
.37816 .28031 L
.37819 .28489 L
.37821 .28649 L
.37823 .28821 L
.37824 .28976 L
.37826 .29142 L
.37828 .29268 L
.37829 .29306 L
.37833 .29379 L
.37836 .29446 L
.37839 .2931 L
.37842 .29134 L
.37845 .28962 L
.37848 .29046 L
.37851 .29361 L
.37854 .29694 L
.37876 .32842 L
.37879 .33509 L
.37882 .34216 L
.37884 .34585 L
.37886 .34755 L
.37889 .34993 L
.37892 .35218 L
.37894 .35344 L
.37895 .35368 L
.37898 .35384 L
Mistroke
.37901 .35399 L
.37904 .35416 L
.37907 .35464 L
.37909 .35506 L
.37912 .35551 L
.37914 .35536 L
.37915 .3546 L
.37918 .3531 L
.37924 .35015 L
.37927 .34862 L
.37929 .34699 L
.37932 .34545 L
.37934 .34602 L
.37937 .34682 L
.37939 .34769 L
.37942 .34777 L
.37945 .34478 L
.37956 .33476 L
.37959 .33266 L
.37962 .32901 L
.37965 .3241 L
.37968 .31873 L
.37969 .3157 L
.37971 .31405 L
.37973 .31513 L
.37974 .3161 L
.37976 .31704 L
.37977 .31803 L
.3798 .31895 L
.37983 .31672 L
.37986 .31425 L
.37988 .31298 L
.37989 .31172 L
.37993 .31353 L
.37996 .3154 L
.37997 .31643 L
.37999 .31738 L
.38001 .31769 L
.38003 .31797 L
.38006 .31853 L
.38008 .31878 L
.38009 .31897 L
.38012 .31913 L
.38015 .3193 L
.38017 .3194 L
.38019 .31862 L
.38022 .31557 L
.38025 .31268 L
.38028 .31024 L
.38031 .31758 L
Mistroke
.38034 .32557 L
.38035 .32994 L
.38037 .33405 L
.3804 .33373 L
.38043 .33288 L
.38046 .33212 L
.38049 .3272 L
.38054 .31512 L
.38061 .3039 L
.38064 .29958 L
.38067 .29594 L
.38068 .29553 L
.3807 .29508 L
.38073 .29428 L
.38074 .29382 L
.38076 .29317 L
.38079 .2916 L
.38083 .29003 L
.38086 .28825 L
.38089 .28585 L
.38092 .28324 L
.38136 .23462 L
.38139 .22856 L
.38141 .22292 L
.38144 .21953 L
.38147 .21764 L
.38153 .21378 L
.38159 .21075 L
.3816 .20985 L
.38162 .20915 L
.38165 .20883 L
.38168 .20845 L
.3817 .20829 L
.38171 .20817 L
.38174 .20832 L
.38177 .20849 L
.38179 .20857 L
.3818 .20866 L
.38183 .2063 L
.38187 .20377 L
.38188 .20238 L
.3819 .20107 L
.38192 .20127 L
.38194 .20164 L
.38195 .202 L
.38197 .20237 L
.38199 .2027 L
.382 .20342 L
.38203 .20663 L
.38207 .21042 L
Mistroke
.38208 .21207 L
.3821 .21346 L
.38213 .21429 L
.38216 .21507 L
.38217 .21551 L
.38219 .2161 L
.38222 .21896 L
.38225 .22141 L
.38228 .22406 L
.38231 .223 L
.38234 .22091 L
.38237 .21881 L
.3824 .21772 L
.38241 .21747 L
.38243 .21719 L
.38246 .21672 L
.38249 .2166 L
.38252 .21708 L
.38254 .21753 L
.38257 .21795 L
.3826 .21828 L
.38263 .21863 L
.38266 .21895 L
.38269 .22092 L
.38272 .22357 L
.38274 .22503 L
.38275 .2264 L
.38277 .2269 L
.38279 .22607 L
.38282 .22446 L
.38285 .22302 L
.38287 .22167 L
.38288 .21998 L
.38295 .2129 L
.383 .20816 L
.38304 .2056 L
.38306 .20444 L
.38308 .20435 L
.3831 .20426 L
.38312 .20415 L
.38314 .20406 L
.38315 .2048 L
.38317 .20695 L
.3832 .21151 L
.38327 .21901 L
.3833 .22165 L
.38333 .22452 L
.38336 .226 L
.38339 .22696 L
.38341 .2275 L
Mistroke
.38342 .22806 L
.38345 .22723 L
.38348 .22583 L
.38351 .22452 L
.38354 .22254 L
.38357 .21962 L
.3836 .21648 L
.38362 .21485 L
.38364 .21456 L
.38367 .21404 L
.38369 .21376 L
.38371 .21346 L
.38374 .21446 L
.38377 .21589 L
.38379 .21669 L
.3838 .21753 L
.38384 .21621 L
.38387 .2138 L
.38389 .21151 L
.38391 .21025 L
.38393 .20986 L
.38395 .20923 L
.38398 .20862 L
.38401 .20904 L
.38404 .21194 L
.38407 .21512 L
.38408 .21704 L
.3841 .21886 L
.38413 .21763 L
.38416 .21592 L
.38418 .21509 L
.3842 .21438 L
.38422 .21514 L
.38425 .21596 L
.38427 .21639 L
.38429 .21685 L
.38432 .21724 L
.38435 .21754 L
.38437 .21783 L
.38439 .21809 L
.38441 .21963 L
.38444 .22232 L
.38447 .22519 L
.38448 .22663 L
.3845 .22704 L
.38453 .22754 L
.38456 .22801 L
.38459 .22822 L
.38462 .22776 L
.38464 .22735 L
Mistroke
.38467 .22692 L
.38469 .22906 L
.38472 .23208 L
.38475 .23541 L
.38478 .23766 L
.3848 .23766 L
.38481 .23766 L
.38485 .23766 L
.38486 .23766 L
.38488 .23679 L
.38492 .23478 L
.38493 .2338 L
.38495 .23275 L
.38497 .23241 L
.38498 .23433 L
.38501 .2382 L
.38504 .24183 L
.38507 .24408 L
.3851 .2447 L
.38513 .24539 L
.38516 .24532 L
.38519 .24039 L
.38522 .235 L
.38523 .23228 L
.38525 .22937 L
.38528 .22772 L
.38531 .22598 L
.38534 .22435 L
.38537 .22527 L
.38541 .22657 L
.38544 .22767 L
.38547 .22821 L
.3855 .22873 L
.38553 .2292 L
.38554 .22934 L
.38556 .22924 L
.38559 .22907 L
.38561 .22896 L
.38563 .22886 L
.38565 .22967 L
.38567 .23061 L
.38569 .23222 L
.38573 .23394 L
.38574 .23403 L
.38576 .23403 L
.38579 .23403 L
.38582 .23403 L
.38585 .23898 L
.38591 .25035 L
.38597 .26161 L
Mistroke
.386 .26717 L
.38602 .26971 L
.38605 .2682 L
.38608 .26656 L
.38611 .26529 L
.38613 .26606 L
.38615 .2669 L
.38618 .26849 L
.3862 .26937 L
.38621 .27095 L
.38625 .27533 L
.38628 .27942 L
.3863 .28275 L
.38633 .28337 L
.38639 .2847 L
.38642 .28402 L
.38646 .28313 L
.38649 .28228 L
.38652 .28703 L
.38655 .29267 L
.38657 .29798 L
.3866 .30218 L
.38663 .30449 L
.38668 .30859 L
.38674 .31307 L
.38677 .31563 L
.3868 .31355 L
.38683 .30934 L
.38685 .30719 L
.38686 .30485 L
.38689 .30691 L
.38692 .31199 L
.38698 .32103 L
.38701 .32507 L
.38704 .32886 L
.38706 .33076 L
.38708 .32877 L
.3871 .32475 L
.38711 .32107 L
.38718 .30705 L
.38721 .30073 L
.38724 .29388 L
.38727 .29015 L
.3873 .29061 L
.38733 .29107 L
.38735 .29154 L
.38738 .29276 L
.38741 .29411 L
.38747 .29787 L
.3875 .29998 L
Mistroke
.38753 .30228 L
.38756 .30304 L
.38758 .30237 L
.38761 .30159 L
.38764 .30084 L
.38767 .30125 L
.38769 .30171 L
.38773 .30221 L
.38774 .3016 L
.38776 .29954 L
.38782 .29249 L
.38795 .27373 L
.38798 .26699 L
.38801 .26062 L
.38803 .25824 L
.38804 .25785 L
.38808 .25719 L
.3881 .25655 L
.38814 .25786 L
.38816 .26002 L
.38819 .2624 L
.38822 .26446 L
.38825 .26555 L
.38828 .26675 L
.3883 .26742 L
.38832 .26627 L
.38835 .2618 L
.38838 .25696 L
.38844 .245 L
.38846 .23769 L
.38849 .23088 L
.38852 .23047 L
.38855 .232 L
.38858 .23329 L
.3886 .23425 L
.38863 .23487 L
.38866 .23544 L
.38869 .23606 L
.38872 .23352 L
.38875 .23083 L
.38877 .22942 L
.38878 .22794 L
.38881 .23057 L
.38884 .23319 L
.38887 .2359 L
.3889 .23723 L
.38893 .23824 L
.38895 .23876 L
.38896 .23933 L
.38899 .238 L
Mistroke
.38902 .23531 L
.38909 .22934 L
.38913 .2262 L
.38914 .22466 L
.38916 .22323 L
.38919 .22178 L
.38922 .22057 L
.38925 .21945 L
.38928 .21869 L
.3893 .21813 L
.38933 .21753 L
.38936 .21741 L
.38939 .22233 L
.38942 .22821 L
.38945 .23369 L
.38947 .23411 L
.38948 .2342 L
.3895 .23429 L
.38952 .23439 L
.38953 .23448 L
.38955 .23428 L
.38958 .23015 L
.38961 .22612 L
.38964 .22242 L
.38967 .22248 L
.3897 .22367 L
.38973 .22478 L
.38975 .227 L
.38979 .23067 L
.3898 .23269 L
.38982 .23459 L
.38984 .23616 L
.38985 .23662 L
.38988 .23742 L
.38991 .23827 L
.38993 .23869 L
.38995 .23822 L
.38998 .23738 L
.39001 .23661 L
.39003 .23614 L
.39004 .23479 L
.39008 .23163 L
.39014 .22608 L
.39025 .21507 L
.39032 .20616 L
.39038 .19662 L
.39041 .19174 L
.39044 .19509 L
.39046 .19908 L
.39049 .20335 L
Mistroke
.39053 .2045 L
.39055 .2037 L
.39057 .20322 L
.39059 .20276 L
.39061 .20201 L
.39062 .20021 L
.39073 .18928 L
.39076 .18722 L
.39079 .185 L
.39081 .18526 L
.39082 .18567 L
.39085 .18649 L
.39088 .18722 L
.3909 .18506 L
.39093 .18119 L
.39096 .17706 L
.39099 .17432 L
.39102 .17574 L
.39104 .17713 L
.39106 .17839 L
.39109 .17849 L
.39112 .17702 L
.39118 .17439 L
.3913 .17016 L
.39136 .17079 L
.39139 .17121 L
.39142 .17173 L
.39143 .172 L
.39145 .17229 L
.39147 .17152 L
.39149 .16983 L
.39152 .16634 L
.39155 .1631 L
.39157 .16323 L
.3916 .16515 L
.39163 .16711 L
.39166 .16868 L
.39169 .16799 L
.39172 .16735 L
.39175 .16682 L
.39178 .16942 L
.3918 .17177 L
.39183 .17429 L
.39185 .17567 L
.39188 .17466 L
.39191 .17353 L
.39194 .17246 L
.39196 .1775 L
.39199 .1832 L
.39202 .18921 L
Mistroke
.39205 .1908 L
.39208 .18558 L
.39211 .18007 L
.39213 .17559 L
.39216 .17641 L
.39219 .1773 L
.39222 .17827 L
.39223 .17859 L
.39225 .17842 L
.39228 .17808 L
.39231 .17778 L
.39234 .18038 L
.39237 .18691 L
.3924 .19301 L
.39243 .19985 L
.39247 .20768 L
.39248 .21131 L
.3925 .21518 L
.39253 .21672 L
.39255 .21491 L
.39256 .2132 L
.39259 .21001 L
.39262 .20911 L
.39265 .21127 L
.39268 .21363 L
.39271 .21563 L
.39274 .21257 L
.39277 .20971 L
.39279 .20796 L
.3928 .20597 L
.39284 .1991 L
.39287 .19234 L
.39288 .18864 L
.3929 .18605 L
.39292 .1869 L
.39294 .18782 L
.39295 .18868 L
.39297 .18946 L
.393 .1901 L
.39303 .1878 L
.39308 .18368 L
.39311 .17989 L
.39315 .17561 L
.39318 .17196 L
.39321 .17137 L
.39324 .17205 L
.39327 .17269 L
.39328 .17362 L
.3933 .17569 L
.39333 .18035 L
Mistroke
.39336 .18435 L
.39338 .18545 L
.3934 .18419 L
.39346 .1794 L
.39351 .1749 L
.39354 .17275 L
.39357 .17109 L
.39359 .17446 L
.39362 .17802 L
.39364 .18159 L
.39367 .18321 L
.3937 .17915 L
.39373 .17544 L
.39376 .17131 L
.39379 .16986 L
.39382 .1686 L
.39384 .16727 L
.39387 .16757 L
.3939 .16877 L
.39396 .17121 L
.39402 .17379 L
.39403 .17456 L
.39405 .17499 L
.39408 .17482 L
.39411 .17466 L
.39414 .17475 L
.39417 .17763 L
.3942 .18079 L
.39422 .18238 L
.39423 .18409 L
.39426 .17943 L
.39429 .17445 L
.39432 .16916 L
.39435 .1667 L
.39437 .16564 L
.3944 .16454 L
.39443 .16434 L
.39446 .17101 L
.39449 .1782 L
.39452 .1846 L
.39455 .18835 L
.39457 .19125 L
.3946 .19435 L
.39463 .19624 L
.39465 .19624 L
.39468 .19624 L
.3947 .19624 L
.39473 .19705 L
.39476 .19878 L
.39481 .20192 L
Mistroke
.39527 .23481 L
.39553 .25302 L
.39556 .25151 L
.39558 .25168 L
.3956 .25265 L
.39563 .25458 L
.39566 .25632 L
.39569 .26119 L
.39572 .26695 L
.39574 .27303 L
.39578 .27548 L
.3958 .27224 L
.39583 .26869 L
.39589 .2618 L
.39592 .25861 L
.39594 .25559 L
.39597 .25377 L
.39599 .25279 L
.39602 .25172 L
.39605 .25063 L
.39607 .25155 L
.39608 .25257 L
.39611 .25436 L
.39623 .26238 L
.39672 .30332 L
.39719 .34261 L
.3972 .34246 L
.39722 .34296 L
.39724 .34355 L
.39725 .34408 L
.39728 .34504 L
.3973 .34595 L
.39731 .34719 L
.39738 .35237 L
.39741 .35623 L
.39745 .36073 L
.39748 .36428 L
.39751 .36581 L
.39754 .36675 L
.39756 .36761 L
.39759 .36556 L
.39761 .36272 L
.39763 .36009 L
.39769 .35055 L
.3978 .33485 L
.39783 .33007 L
.39785 .32747 L
.39786 .32504 L
.39789 .32475 L
.39792 .32492 L
Mistroke
.39797 .32521 L
.39802 .32548 L
.39805 .32564 L
.39808 .32875 L
.39811 .33168 L
.39814 .33483 L
.39817 .33618 L
.3982 .33556 L
.39821 .33518 L
.39823 .33482 L
.39826 .33612 L
.39828 .33793 L
.39829 .33986 L
.39832 .34332 L
.39834 .34533 L
.39836 .34533 L
.39839 .34533 L
.39842 .34533 L
.39845 .34574 L
.39848 .34644 L
.39851 .34722 L
.39854 .34894 L
.39856 .35232 L
.39857 .35539 L
.3986 .3614 L
.39863 .36617 L
.39866 .36215 L
.39869 .35782 L
.39875 .34972 L
.39878 .34651 L
.39879 .34476 L
.39881 .34313 L
.39884 .34431 L
.39887 .34763 L
.3989 .35075 L
.39892 .35213 L
.39895 .35108 L
.39898 .34994 L
.399 .3487 L
.39903 .3504 L
.39906 .3525 L
.39909 .35482 L
.39911 .35611 L
.39912 .35593 L
.39915 .35542 L
.39918 .35491 L
.39921 .35265 L
.39923 .34973 L
.39925 .34699 L
.39928 .34186 L
Mistroke
.3993 .33898 L
.39931 .3383 L
.39933 .33792 L
.39935 .33753 L
.39938 .3369 L
.39941 .33784 L
.39944 .34068 L
.39946 .34326 L
.39949 .34547 L
.39951 .34404 L
.39953 .34272 L
.39959 .33791 L
.3997 .33345 L
.39973 .33196 L
.39975 .33115 L
.39976 .3304 L
.39979 .32816 L
.39982 .32491 L
.39985 .32184 L
.39987 .31985 L
.3999 .32193 L
.39992 .32418 L
.39995 .32664 L
.39998 .32735 L
.40001 .32679 L
.40004 .32618 L
.4001 .32098 L
.40013 .31698 L
.40015 .31496 L
.40017 .31441 L
.40019 .31458 L
.4002 .31477 L
.40024 .31512 L
.40027 .31499 L
.4003 .31436 L
.40032 .31378 L
.40035 .31332 L
.40038 .31416 L
.40041 .31495 L
.40043 .31537 L
.40044 .31582 L
.40047 .31565 L
.4005 .31549 L
.40053 .31534 L
.40056 .31289 L
.40059 .30942 L
.40062 .30589 L
.40064 .30391 L
.40065 .30332 L
.40068 .30204 L
Mistroke
.4007 .30141 L
.40072 .30083 L
.40075 .29861 L
.40078 .2951 L
.4008 .29203 L
.40083 .28936 L
.40086 .28902 L
.40089 .28871 L
.40092 .28841 L
.40094 .28717 L
.401 .28408 L
.4015 .25125 L
.40172 .22389 L
.40178 .21241 L
.40184 .20289 L
.40189 .19557 L
.40195 .18998 L
.40198 .18766 L
.402 .1871 L
.40201 .18659 L
.40204 .18562 L
.40207 .18486 L
.40209 .18486 L
.4021 .18486 L
.40214 .18486 L
.40215 .18486 L
.40217 .18452 L
.40219 .18384 L
.4022 .18309 L
.40244 .16973 L
.40247 .16819 L
.40249 .16762 L
.4025 .16709 L
.40253 .16611 L
.40255 .16511 L
.40257 .1629 L
.4026 .15753 L
.40262 .1549 L
.40264 .15248 L
.40267 .15088 L
.40268 .15034 L
.4027 .14978 L
.40295 .1438 L
.40298 .14501 L
.40301 .14629 L
.40302 .14696 L
.40304 .1492 L
.40307 .1536 L
.4031 .15774 L
.40313 .1602 L
Mistroke
.40316 .15711 L
.40318 .15428 L
.4032 .15261 L
.40321 .15082 L
.40323 .1506 L
.40325 .15051 L
.40327 .15042 L
.40328 .15033 L
.40331 .14982 L
.40334 .1427 L
.40337 .13615 L
.4034 .12896 L
.40342 .12791 L
.40343 .1289 L
.40346 .13078 L
.40349 .13257 L
.40352 .1327 L
.40355 .13206 L
.40358 .13137 L
.40362 .13034 L
.40368 .12803 L
.4037 .12752 L
.40373 .12783 L
.40375 .12799 L
.40377 .12817 L
.40379 .12782 L
.40382 .12471 L
.40385 .12138 L
.40388 .11825 L
.40391 .11923 L
.40395 .12345 L
.40401 .12714 L
.40403 .1286 L
.40406 .13021 L
.40409 .1307 L
.40411 .13002 L
.40414 .12924 L
.40417 .12849 L
.40419 .12936 L
.4042 .13055 L
.40423 .13262 L
.40426 .1346 L
.40429 .13179 L
.40432 .12748 L
.40435 .12358 L
.40438 .12152 L
.4044 .12386 L
.40446 .12912 L
.40452 .13301 L
.40454 .13413 L
Mistroke
.40456 .13514 L
.40459 .13398 L
.40464 .13202 L
.40467 .13132 L
.40469 .13086 L
.40472 .13036 L
.40475 .13025 L
.40478 .13141 L
.40481 .13266 L
.40484 .13403 L
.40487 .13236 L
.40494 .12803 L
.405 .1245 L
.40502 .12349 L
.40504 .12306 L
.40505 .12443 L
.40507 .12591 L
.4051 .12861 L
.40513 .13101 L
.40516 .13085 L
.40519 .13067 L
.40522 .13051 L
.40525 .12804 L
.40528 .12506 L
.40531 .12226 L
.40534 .12193 L
.40536 .12331 L
.4054 .12484 L
.40542 .12517 L
.40545 .12285 L
.40548 .12031 L
.4055 .11903 L
.40552 .11819 L
.40555 .11885 L
.40558 .11946 L
.40561 .12013 L
.40564 .12167 L
.40566 .12313 L
.40577 .1309 L
.4058 .13338 L
.40583 .13437 L
.40585 .13509 L
.40588 .13588 L
.4059 .13597 L
.40592 .13535 L
.40595 .13413 L
.40598 .13302 L
.40601 .13436 L
.40603 .13596 L
.40604 .13743 L
Mistroke
.40606 .13901 L
.40608 .14075 L
.40611 .13975 L
.40613 .13862 L
.40614 .13756 L
.40617 .13556 L
.4062 .1354 L
.40622 .13557 L
.40624 .13575 L
.40627 .13608 L
.4063 .1361 L
.40632 .13595 L
.40635 .13579 L
.40638 .13482 L
.40641 .13262 L
.40643 .13057 L
.40646 .12832 L
.40649 .12977 L
.40651 .13104 L
.40652 .13222 L
.40654 .13348 L
.40656 .13487 L
.40659 .13895 L
.40662 .14354 L
.40665 .1477 L
.40668 .14835 L
.40671 .14803 L
.40674 .14773 L
.40677 .14816 L
.40679 .14873 L
.40681 .14924 L
.40684 .15025 L
.40686 .15094 L
.40688 .1512 L
.4069 .15148 L
.40692 .15178 L
.40693 .15207 L
.40697 .15469 L
.40698 .15666 L
.407 .15877 L
.40725 .18721 L
.40736 .20023 L
.40743 .20906 L
.40749 .21733 L
.40752 .22088 L
.40754 .21992 L
.40756 .21904 L
.40763 .21599 L
.40766 .21617 L
.40768 .21626 L
Mistroke
.4077 .21635 L
.40771 .21631 L
.40773 .21421 L
.40776 .21055 L
.40779 .20681 L
.40782 .20547 L
.40785 .20738 L
.40788 .20948 L
.40801 .21801 L
.40824 .23732 L
.40871 .26954 L
.40874 .27852 L
.40876 .28306 L
.40877 .28374 L
.40879 .28303 L
.40881 .28236 L
.40883 .28174 L
.40884 .28108 L
.40886 .28082 L
.40888 .28191 L
.40891 .28382 L
.40892 .28489 L
.40894 .28605 L
.40896 .28643 L
.40897 .28511 L
.409 .28263 L
.40903 .28 L
.40905 .27862 L
.40906 .27999 L
.4091 .28266 L
.40916 .28783 L
.40921 .2924 L
.40924 .29449 L
.40927 .29281 L
.4093 .29099 L
.40934 .28941 L
.40937 .28924 L
.4094 .28907 L
.40943 .28891 L
.40946 .28918 L
.40948 .28945 L
.40951 .28974 L
.40954 .28981 L
.40956 .28952 L
.40959 .28918 L
.40962 .28873 L
.40965 .28731 L
.40968 .28577 L
.40971 .28409 L
.40974 .28554 L
Mistroke
.40976 .28689 L
.40977 .28814 L
.40979 .28959 L
.4098 .29093 L
.40984 .28991 L
.40985 .28884 L
.40987 .2877 L
.40989 .2865 L
.40991 .28537 L
.40992 .28755 L
.40994 .29023 L
.41006 .3128 L
.41018 .33807 L
.41024 .349 L
.41026 .35412 L
.41029 .35879 L
.41032 .35911 L
.41035 .35946 L
.41038 .35975 L
.41041 .35458 L
.41044 .34717 L
.41046 .34327 L
.41048 .33916 L
.41049 .33802 L
.41051 .33792 L
.41054 .33776 L
.41057 .3376 L
.41059 .33643 L
.4106 .3347 L
.41063 .3316 L
.41066 .32817 L
.41069 .32569 L
.41071 .32475 L
.41072 .32388 L
.41078 .32045 L
.41082 .31828 L
.41085 .31622 L
.41087 .31547 L
.41088 .3164 L
.41092 .31803 L
.41095 .31947 L
.41098 .32179 L
.411 .32477 L
.41104 .32805 L
.41105 .32978 L
.41107 .33013 L
.4111 .33087 L
.41113 .33156 L
.41116 .32984 L
.4112 .32571 L
Mistroke
.41122 .32188 L
.41124 .31988 L
.41126 .31915 L
.41127 .31877 L
.41129 .31841 L
.41132 .31776 L
.41135 .31591 L
.41138 .31131 L
.41141 .30648 L
.41144 .30295 L
.41147 .30357 L
.41149 .30411 L
.41152 .30469 L
.41155 .30495 L
.41158 .30495 L
.41161 .30495 L
.41164 .30452 L
.41167 .30326 L
.4117 .3019 L
.41175 .29912 L
.41179 .29726 L
.4118 .29634 L
.41182 .29534 L
.41185 .29216 L
.41188 .28869 L
.41195 .28221 L
.41198 .27928 L
.41201 .27659 L
.41202 .27598 L
.41204 .27542 L
.41208 .27424 L
.41211 .27308 L
.41212 .27178 L
.41214 .27056 L
.41259 .24241 L
.41265 .23955 L
.41271 .23531 L
.41274 .23294 L
.41277 .23045 L
.4128 .23138 L
.41283 .23247 L
.41285 .2336 L
.41287 .23293 L
.41289 .22987 L
.41292 .22386 L
.41294 .21832 L
.41296 .21514 L
.41298 .21404 L
.41301 .21213 L
.41308 .2096 L
Mistroke
.4132 .20407 L
.41322 .20223 L
.41324 .20049 L
.41326 .20003 L
.41327 .20148 L
.41331 .20413 L
.41332 .20559 L
.41334 .20696 L
.41337 .20785 L
.4134 .20871 L
.41343 .20945 L
.41346 .20755 L
.41349 .20436 L
.41352 .20095 L
.41354 .19935 L
.41355 .19935 L
.41359 .19935 L
.41365 .19935 L
.41368 .19935 L
.41369 .19935 L
.41371 .19935 L
.41373 .19935 L
.41374 .19945 L
.41378 .19963 L
.41381 .19979 L
.41382 .20014 L
.41384 .20166 L
.41387 .20434 L
.4139 .2072 L
.41391 .20885 L
.41393 .20835 L
.41396 .20625 L
.41407 .19702 L
.41419 .17977 L
.41424 .17196 L
.41427 .16888 L
.4143 .16553 L
.41432 .16697 L
.41435 .16885 L
.41438 .171 L
.41441 .17151 L
.41444 .17073 L
.41447 .16988 L
.41449 .16946 L
.4145 .16673 L
.41453 .1602 L
.41457 .15353 L
.41458 .14975 L
.4146 .15086 L
.41462 .15307 L
Mistroke
.41463 .15507 L
.41465 .15741 L
.41467 .15956 L
.4147 .16115 L
.41472 .16123 L
.41473 .16133 L
.41476 .16149 L
.41479 .16175 L
.41482 .16208 L
.41485 .16239 L
.41488 .16235 L
.41491 .16162 L
.41494 .16083 L
.41497 .16008 L
.41499 .16182 L
.415 .16339 L
.41503 .16647 L
.41506 .1693 L
.41509 .16526 L
.41512 .16037 L
.41515 .15593 L
.41518 .15279 L
.41521 .15026 L
.41524 .1476 L
.41526 .14666 L
.41528 .14701 L
.4153 .14759 L
.41533 .14822 L
.41536 .14899 L
.41538 .15007 L
.41541 .15119 L
.41544 .15241 L
.41547 .15167 L
.4155 .15026 L
.41551 .14947 L
.41553 .14862 L
.41555 .14817 L
.41556 .14833 L
.41559 .14867 L
.41562 .14898 L
.41565 .14959 L
.41569 .15051 L
.41571 .15097 L
.41572 .15141 L
.41574 .15236 L
.41576 .15393 L
.41579 .1566 L
.41582 .15944 L
.41584 .15974 L
.41587 .15816 L
Mistroke
.4159 .15647 L
.41592 .15552 L
.41594 .15521 L
.41597 .15489 L
.416 .15455 L
.41603 .15391 L
.41606 .1524 L
.41608 .15083 L
.4161 .14994 L
.41612 .14914 L
.41613 .14914 L
.41615 .14914 L
.41617 .14914 L
.41618 .14914 L
.41621 .14925 L
.41623 .15077 L
.41624 .15238 L
.41627 .15534 L
.41629 .15689 L
.41631 .15849 L
.41634 .15966 L
.41637 .16074 L
.41639 .16178 L
.41642 .16122 L
.41645 .15985 L
.41648 .15839 L
.41658 .1541 L
.4167 .14836 L
.41675 .14519 L
.41678 .14359 L
.41681 .14315 L
.41684 .14288 L
.41686 .14258 L
.41689 .14256 L
.41691 .14294 L
.41694 .14339 L
.41697 .14387 L
.41699 .14564 L
.417 .14791 L
.41703 .15234 L
.41709 .16159 L
.41713 .16679 L
.41714 .16963 L
.41716 .17229 L
.41719 .17335 L
.41722 .17318 L
.41725 .17303 L
.41727 .17154 L
.4173 .16836 L
.41733 .16535 L
Mistroke
.41738 .16014 L
.41742 .15726 L
.41744 .15456 L
.41748 .15488 L
.41749 .15568 L
.41751 .15653 L
.41756 .15931 L
.41759 .1609 L
.41762 .1626 L
.41764 .16358 L
.41766 .16271 L
.41769 .16079 L
.41771 .15976 L
.41773 .15864 L
.41775 .15797 L
.41776 .15806 L
.41779 .15823 L
.41782 .15839 L
.41785 .1609 L
.41787 .16303 L
.41789 .16531 L
.41792 .1694 L
.41795 .17197 L
.41796 .17294 L
.41798 .174 L
.41801 .17585 L
.41813 .18401 L
.41839 .20633 L
.41845 .21373 L
.41848 .21753 L
.41851 .22086 L
.41854 .22329 L
.41857 .22593 L
.4186 .22818 L
.41862 .22893 L
.41876 .23313 L
.41888 .2384 L
.41893 .24086 L
.41895 .24153 L
.41897 .24224 L
.41899 .24484 L
.41905 .25176 L
.41908 .25538 L
.41911 .25656 L
.41914 .25795 L
.41917 .25926 L
.4192 .25619 L
.41923 .25228 L
.41924 .25005 L
.41926 .24796 L
Mistroke
.41928 .24673 L
.41929 .24623 L
.41933 .24534 L
.41936 .24451 L
.41939 .24942 L
.41942 .25589 L
.41945 .26159 L
.41947 .26198 L
.41948 .26132 L
.41951 .26007 L
.41954 .25871 L
.41957 .25825 L
.4196 .2581 L
.41963 .25794 L
.41966 .25769 L
.4197 .25732 L
.41971 .25714 L
.41973 .25697 L
.41975 .25668 L
.41976 .25565 L
.4198 .25379 L
.41986 .25019 L
.41989 .24851 L
.41992 .24674 L
.41995 .24698 L
.41997 .2494 L
.42 .25203 L
.42002 .25349 L
.42004 .25396 L
.42007 .25283 L
.42009 .25176 L
.42015 .24984 L
.42017 .24878 L
.4202 .2478 L
.42023 .24774 L
.42026 .25142 L
.42031 .25789 L
.42055 .28343 L
.42062 .29349 L
.42065 .29846 L
.42068 .30306 L
.42071 .30419 L
.42074 .30272 L
.42077 .30124 L
.42081 .29916 L
.42083 .29692 L
.42086 .29452 L
.4209 .29292 L
.42092 .29465 L
.42098 .29772 L
Mistroke
.42103 .30131 L
.42105 .30239 L
.42107 .30353 L
.4211 .30857 L
.42113 .31556 L
.42114 .31958 L
.42116 .32325 L
.42119 .32714 L
.42122 .32698 L
.42125 .32682 L
.42127 .32671 L
.4213 .32686 L
.42133 .32701 L
.42136 .32716 L
.42138 .32984 L
.42141 .33478 L
.42144 .33932 L
.4215 .34794 L
.42171 .37585 L
.42177 .38277 L
.4218 .38618 L
.42183 .38933 L
.42186 .39182 L
.42187 .39234 L
.42189 .39289 L
.42192 .39379 L
.42195 .39455 L
.42198 .3947 L
.422 .39484 L
.42203 .39497 L
.42205 .39362 L
.42208 .39115 L
.42211 .38886 L
.42217 .38174 L
.4222 .37735 L
.42221 .37505 L
.42223 .37356 L
.42225 .37446 L
.42226 .37546 L
.42229 .3772 L
.42232 .37889 L
.42235 .37707 L
.42241 .37347 L
.42248 .3687 L
.42254 .36411 L
.42257 .3621 L
.4226 .35997 L
.42262 .35969 L
.42263 .36046 L
.42266 .36196 L
Mistroke
.42269 .36328 L
.42272 .36528 L
.42275 .36805 L
.42278 .37063 L
.4228 .37202 L
.42281 .36921 L
.42285 .36273 L
.42287 .35696 L
.4229 .35174 L
.42293 .34923 L
.42296 .34687 L
.42299 .34439 L
.42302 .34413 L
.42305 .34398 L
.42308 .34383 L
.4231 .34331 L
.42313 .34245 L
.42314 .34192 L
.42316 .34134 L
.42318 .3408 L
.42319 .33928 L
.42325 .33185 L
.42339 .31035 L
.42342 .30733 L
.42345 .3041 L
.42348 .30038 L
.4235 .29525 L
.42353 .28988 L
.42356 .28404 L
.42358 .28449 L
.4236 .28527 L
.42363 .2868 L
.42366 .28817 L
.42369 .28054 L
.42374 .26411 L
.42377 .25765 L
.4238 .25497 L
.42386 .24842 L
.42408 .22026 L
.42433 .18935 L
.42445 .16918 L
.42448 .16201 L
.42451 .15431 L
.42454 .15173 L
.42457 .15173 L
.4246 .15173 L
.42463 .15074 L
.42466 .14905 L
.42468 .1472 L
.42475 .14411 L
Mistroke
.42481 .14189 L
.42506 .1336 L
.42512 .13285 L
.42514 .13254 L
.42517 .13222 L
.4252 .13127 L
.42523 .12926 L
.42528 .12572 L
.42531 .12387 L
.42534 .12196 L
.42537 .12015 L
.4254 .11695 L
.42543 .11311 L
.42546 .10898 L
.42548 .10567 L
.42551 .10402 L
.42553 .1023 L
.42556 .10043 L
.42559 .1013 L
.42562 .10315 L
.42565 .10499 L
.42567 .10559 L
.42569 .10542 L
.42572 .10509 L
.42575 .10478 L
.42577 .10378 L
.4258 .10181 L
.42583 .09966 L
.42586 .09791 L
.42588 .09804 L
.42591 .09819 L
.42594 .09834 L
.42597 .09936 L
.426 .10135 L
.42603 .10322 L
.42606 .10431 L
.42607 .1037 L
.42609 .10305 L
.42616 .10051 L
.42619 .09953 L
.42621 .099 L
.42622 .09844 L
.42624 .09791 L
.42626 .09845 L
.42629 .09958 L
.42635 .10234 L
.42641 .10564 L
.42644 .10704 L
.42647 .10608 L
.4265 .10507 L
Mistroke
.42653 .10411 L
.42655 .10253 L
.42658 .1008 L
.42661 .09896 L
.42664 .09945 L
.42667 .10112 L
.42671 .10291 L
.42681 .10866 L
.42693 .11529 L
.42696 .11696 L
.42698 .11787 L
.427 .11872 L
.42703 .11899 L
.42704 .1189 L
.42706 .11881 L
.42708 .11872 L
.4271 .11862 L
.42711 .11739 L
.42713 .11579 L
.42716 .11256 L
.42719 .10954 L
.42721 .10856 L
.42724 .10825 L
.42727 .10791 L
.4273 .10866 L
.42733 .11082 L
.42736 .11318 L
.42738 .11437 L
.4274 .11676 L
.42743 .12282 L
.42744 .12593 L
.42746 .12927 L
.42749 .1334 L
.42752 .12948 L
.42755 .12516 L
.42759 .12178 L
.42762 .12015 L
.42765 .11854 L
.42767 .11709 L
.42769 .11858 L
.4277 .1201 L
.42774 .12344 L
.42777 .12633 L
.42778 .12654 L
.4278 .1267 L
.42782 .12688 L
.42783 .12708 L
.42785 .12726 L
.42787 .1276 L
.42788 .12873 L
Mistroke
.4279 .1298 L
.42794 .13222 L
.42842 .17032 L
.42866 .20103 L
.42868 .2056 L
.42871 .20994 L
.42874 .21265 L
.42877 .21391 L
.4288 .2153 L
.42882 .21594 L
.42884 .21603 L
.42887 .21619 L
.42889 .21628 L
.4289 .21637 L
.42893 .21958 L
.42896 .22437 L
.42899 .22925 L
.42901 .23282 L
.42904 .23193 L
.42906 .23098 L
.42912 .22824 L
.42914 .22543 L
.42917 .2224 L
.4292 .21954 L
.42923 .21884 L
.42925 .21812 L
.42928 .21732 L
.42931 .21562 L
.42935 .21303 L
.42938 .21045 L
.42939 .20951 L
.42941 .21179 L
.42944 .21594 L
.42946 .21812 L
.42947 .22043 L
.4295 .22324 L
.42953 .22434 L
.42956 .22546 L
.42959 .22601 L
.42962 .22464 L
.42965 .22317 L
.42972 .21997 L
.42975 .21799 L
.42977 .21687 L
.42979 .21789 L
.4298 .22032 L
.42982 .22252 L
.42986 .22745 L
.42991 .23588 L
.42995 .24053 L
Mistroke
.42997 .2442 L
.42999 .24496 L
.43001 .24577 L
.43003 .24666 L
.43004 .24749 L
.43006 .24825 L
.43007 .24786 L
.4301 .2461 L
.43013 .24428 L
.43016 .24322 L
.43019 .24597 L
.43023 .24901 L
.43025 .25162 L
.43028 .25709 L
.43031 .26303 L
.43034 .26947 L
.43037 .27161 L
.4304 .27129 L
.43043 .27099 L
.43045 .2704 L
.43048 .26887 L
.43051 .26719 L
.43053 .26634 L
.43054 .2661 L
.43057 .27069 L
.43079 .29566 L
.43129 .33972 L
.43153 .36128 L
.43155 .36407 L
.43157 .36708 L
.43159 .36992 L
.4316 .37087 L
.43162 .37116 L
.43164 .37147 L
.43166 .37174 L
.43167 .37202 L
.4317 .3703 L
.43173 .36712 L
.43175 .36529 L
.43177 .36336 L
.43178 .36183 L
.4318 .36119 L
.43183 .36006 L
.43185 .35943 L
.43186 .35884 L
.43188 .35845 L
.4319 .35945 L
.43193 .36141 L
.43196 .36323 L
.43199 .36223 L
Mistroke
.43202 .35886 L
.43204 .35699 L
.43205 .35526 L
.43208 .35321 L
.4321 .35279 L
.43212 .35234 L
.43215 .35151 L
.43217 .35037 L
.4322 .34873 L
.43223 .34698 L
.43228 .34169 L
.43232 .33755 L
.43235 .33367 L
.43238 .33135 L
.43239 .33054 L
.43241 .32967 L
.43244 .32821 L
.43247 .32831 L
.4325 .32904 L
.43253 .32984 L
.43255 .33031 L
.43256 .33003 L
.43259 .32952 L
.43261 .32925 L
.43263 .32896 L
.43265 .32884 L
.43267 .32903 L
.4327 .32935 L
.43273 .32969 L
.43274 .32852 L
.43276 .32583 L
.43279 .32056 L
.43282 .31572 L
.43286 .31414 L
.43289 .31398 L
.43291 .31384 L
.43293 .31376 L
.43294 .3141 L
.43298 .31485 L
.43301 .31551 L
.43302 .31571 L
.43304 .31418 L
.43328 .2963 L
.43354 .276 L
.43379 .257 L
.43389 .24658 L
.43395 .24185 L
.43398 .23923 L
.43401 .24033 L
.43404 .24145 L
Mistroke
.43407 .24263 L
.43408 .24254 L
.4341 .24206 L
.43413 .24122 L
.43416 .24043 L
.43419 .23842 L
.43425 .23421 L
.4347 .17558 L
.43476 .16569 L
.43479 .15979 L
.43482 .15441 L
.43485 .15043 L
.43487 .14945 L
.43488 .14851 L
.43492 .14657 L
.43494 .14562 L
.43495 .14784 L
.43498 .1512 L
.43501 .15483 L
.43504 .15692 L
.43507 .15256 L
.4351 .14793 L
.43511 .14541 L
.43513 .14329 L
.43516 .14165 L
.43519 .13986 L
.4352 .13893 L
.43522 .13795 L
.43524 .13736 L
.43525 .13691 L
.43528 .13605 L
.43532 .13524 L
.43534 .13699 L
.43537 .1392 L
.43543 .1439 L
.43547 .14649 L
.43549 .14785 L
.4355 .14931 L
.43552 .15018 L
.43554 .15081 L
.43557 .15205 L
.4356 .15324 L
.43562 .15319 L
.43564 .1531 L
.43567 .15294 L
.43568 .15285 L
.4357 .15277 L
.43573 .15149 L
.43576 .15028 L
.43578 .14916 L
Mistroke
.43581 .15095 L
.43584 .15508 L
.43587 .15954 L
.43589 .16209 L
.4359 .16239 L
.43593 .16188 L
.43597 .16139 L
.43598 .16114 L
.436 .16129 L
.43601 .16165 L
.43603 .16204 L
.43606 .16273 L
.43608 .16307 L
.4361 .16303 L
.43613 .16287 L
.43616 .16271 L
.43618 .16162 L
.43621 .15757 L
.43624 .15316 L
.43627 .14899 L
.4363 .14862 L
.43633 .14862 L
.43634 .14862 L
.43636 .14862 L
.43639 .1505 L
.43642 .15287 L
.43644 .15519 L
.43647 .15645 L
.4365 .15515 L
.43652 .15373 L
.43655 .15219 L
.43658 .1529 L
.43661 .15445 L
.43663 .15586 L
.43667 .15709 L
.43668 .15734 L
.4367 .15762 L
.43673 .15811 L
.43676 .15741 L
.43677 .15499 L
.43679 .1527 L
.43682 .14839 L
.43684 .14615 L
.43685 .14466 L
.43687 .14396 L
.43689 .1433 L
.43695 .14091 L
.43699 .13987 L
.43702 .13891 L
.43704 .13857 L
Mistroke
.43707 .1398 L
.43713 .14238 L
.43736 .15604 L
.43748 .16276 L
.43751 .16263 L
.43755 .16504 L
.43757 .16728 L
.4376 .16938 L
.43763 .16819 L
.43765 .16583 L
.43768 .16321 L
.43771 .1632 L
.43774 .16851 L
.43777 .17432 L
.43779 .17725 L
.4378 .1787 L
.43783 .17086 L
.43786 .16368 L
.43789 .1559 L
.43792 .15857 L
.43794 .16358 L
.43797 .16849 L
.43799 .1729 L
.43802 .17092 L
.43804 .16873 L
.43807 .1663 L
.43809 .1657 L
.4381 .16832 L
.43816 .17824 L
.43818 .18094 L
.43819 .18239 L
.43821 .18338 L
.43823 .18428 L
.43829 .18809 L
.43853 .20353 L
.43897 .22458 L
.439 .22339 L
.43903 .22214 L
.43906 .22182 L
.43909 .22214 L
.43912 .22244 L
.43914 .22395 L
.43917 .22973 L
.4392 .23595 L
.43922 .23943 L
.43924 .24242 L
.43925 .24349 L
.43927 .24464 L
.43933 .24857 L
.43936 .2495 L
Mistroke
.43939 .25052 L
.43942 .25147 L
.43945 .25536 L
.43956 .27289 L
.43966 .28689 L
.43972 .29499 L
.43977 .30282 L
.4398 .30677 L
.43983 .30806 L
.43984 .30806 L
.43986 .30806 L
.43989 .30806 L
.43992 .3103 L
.43994 .31555 L
.43997 .32008 L
.44 .32505 L
.44003 .32448 L
.44006 .32378 L
.44012 .32224 L
.44015 .32121 L
.44018 .32023 L
.4402 .32054 L
.44022 .3218 L
.44025 .32401 L
.44028 .32612 L
.44031 .33143 L
.44037 .34288 L
.44042 .35278 L
.44045 .3581 L
.44047 .36316 L
.4405 .36526 L
.44053 .36737 L
.44058 .37131 L
.44063 .37858 L
.44065 .38068 L
.44067 .38259 L
.4407 .38179 L
.44072 .38108 L
.44075 .38033 L
.44078 .37793 L
.44081 .37477 L
.44087 .36741 L
.4409 .363 L
.44093 .35892 L
.44095 .35522 L
.44098 .35631 L
.44104 .35877 L
.44115 .36487 L
.44118 .36642 L
.4412 .36723 L
Mistroke
.44122 .36809 L
.44123 .36884 L
.44125 .36685 L
.44128 .36058 L
.44131 .3543 L
.44134 .34917 L
.44136 .35123 L
.44139 .35345 L
.44151 .36473 L
.44156 .3689 L
.44159 .37081 L
.44162 .3726 L
.44164 .3714 L
.44167 .36977 L
.44172 .36644 L
.44178 .36489 L
.44179 .36447 L
.44181 .36402 L
.44184 .36803 L
.44186 .37187 L
.44189 .37599 L
.44192 .37838 L
.44195 .37823 L
.44197 .37814 L
.44198 .37804 L
.442 .37795 L
.44202 .37674 L
.44208 .37111 L
.44219 .36038 L
.44246 .33477 L
.44271 .30107 L
.44317 .24863 L
.44341 .20901 L
.44367 .1757 L
.44373 .16443 L
.44379 .15503 L
.44382 .15061 L
.44384 .15006 L
.44385 .14956 L
.44392 .14647 L
.44398 .13718 L
.44401 .13261 L
.44403 .13408 L
.44404 .13545 L
.44407 .13785 L
.4441 .14012 L
.44413 .13742 L
.44415 .13308 L
.44421 .12453 L
.44427 .11894 L
Mistroke
.44433 .11405 L
.44439 .10991 L
.44461 .09379 L
.44472 .08404 L
.44475 .08059 L
.44477 .07886 L
.44479 .07906 L
.44482 .0813 L
.44484 .08338 L
.44487 .08547 L
.4449 .08576 L
.44492 .08603 L
.44495 .0863 L
.44498 .08608 L
.445 .08496 L
.44506 .08243 L
.44517 .07895 L
.4452 .07652 L
.44522 .07523 L
.44524 .07386 L
.44527 .07292 L
.4453 .07369 L
.44531 .0742 L
.44533 .07468 L
.44535 .07512 L
.44537 .0753 L
.4454 .07563 L
.44541 .07582 L
.44543 .07599 L
.44546 .07587 L
.44548 .07561 L
.44549 .07533 L
.44553 .07482 L
.44555 .07532 L
.44651 .09344 L
.44654 .09553 L
.44657 .09776 L
.44659 .09986 L
.44662 .09984 L
.44664 .0997 L
.44667 .09956 L
.44669 .10014 L
.44672 .1038 L
.44675 .10754 L
.44679 .11124 L
.44681 .10875 L
.44684 .10601 L
.44687 .10352 L
.4469 .10406 L
.44693 .10629 L
Mistroke
.44695 .10833 L
.44697 .10958 L
.44698 .11007 L
.44701 .10912 L
.44703 .10853 L
.44705 .10798 L
.44708 .108 L
.44711 .11098 L
.44714 .11371 L
.44717 .11625 L
.44718 .11391 L
.4472 .11136 L
.44723 .10681 L
.44726 .10251 L
.44727 .10169 L
.44729 .10123 L
.44732 .10042 L
.44735 .09965 L
.44738 .10228 L
.44741 .1055 L
.44743 .10905 L
.44749 .11911 L
.44752 .12461 L
.44755 .12875 L
.44758 .1272 L
.44762 .12551 L
.44765 .12432 L
.44768 .12449 L
.44771 .12465 L
.44773 .12474 L
.44774 .12504 L
.44777 .12766 L
.4478 .13042 L
.44783 .1329 L
.44785 .132 L
.44788 .12945 L
.44791 .12671 L
.44793 .1252 L
.44794 .12552 L
.44797 .12721 L
.44801 .12903 L
.44803 .12996 L
.44805 .12967 L
.44808 .12918 L
.44811 .12866 L
.44812 .12868 L
.44814 .13065 L
.44817 .1341 L
.44829 .1482 L
.44835 .15777 L
Mistroke
.44837 .16056 L
.44838 .16356 L
.44841 .16725 L
.44845 .16486 L
.44848 .16223 L
.44854 .15781 L
.44856 .15672 L
.44857 .15554 L
.4486 .15484 L
.44863 .16016 L
.44866 .16509 L
.44869 .17035 L
.44872 .17235 L
.44877 .17543 L
.44889 .18485 L
.44939 .21535 L
.45032 .28177 L
.4513 .3764 L
.45179 .41499 L
.45182 .41964 L
.45185 .4232 L
.45187 .42251 L
.45189 .42175 L
.45192 .42042 L
.45195 .41942 L
.45198 .41993 L
.452 .42036 L
.45203 .42084 L
.45206 .42265 L
.45209 .42452 L
.45212 .42667 L
.45215 .42961 L
.4522 .43675 L
.45225 .44637 L
.4523 .45845 L
.45233 .46332 L
.45236 .46523 L
.45239 .4673 L
.45242 .46887 L
.45245 .46725 L
.45248 .46552 L
.45269 .45231 L
.45317 .4255 L
.45341 .40797 L
.45344 .39918 L
.45346 .39488 L
.45348 .39272 L
.45349 .39352 L
.45351 .39437 L
.45353 .39532 L
Mistroke
.45355 .3962 L
.45358 .39431 L
.45359 .39048 L
.45361 .38639 L
.45367 .37275 L
.45416 .29577 L
.45428 .2733 L
.45431 .26715 L
.45434 .26151 L
.4544 .25423 L
.45447 .24828 L
.45449 .24681 L
.45451 .24541 L
.45452 .24454 L
.45454 .24542 L
.45457 .24699 L
.45459 .24785 L
.45461 .24866 L
.45462 .24863 L
.45464 .24772 L
.45467 .24614 L
.4547 .24451 L
.45473 .24131 L
.45479 .23121 L
.45492 .21644 L
.45515 .19419 L
.45564 .16033 L
.4557 .15189 L
.45573 .14775 L
.45575 .1434 L
.45578 .14189 L
.45581 .14189 L
.45584 .14189 L
.45586 .14189 L
.45589 .1402 L
.45592 .13829 L
.45594 .13653 L
.45597 .13609 L
.456 .13706 L
.45603 .13797 L
.45606 .13836 L
.45607 .13712 L
.45609 .13576 L
.45612 .13329 L
.45615 .13101 L
.45616 .13084 L
.45618 .13065 L
.45621 .13032 L
.45624 .13001 L
.45627 .13108 L
Mistroke
.4563 .13217 L
.45633 .13317 L
.45636 .13296 L
.45639 .13178 L
.45641 .13074 L
.45644 .13037 L
.45647 .13149 L
.45649 .13253 L
.45652 .13367 L
.45655 .13335 L
.45656 .13265 L
.45658 .1319 L
.45661 .13056 L
.45663 .12937 L
.45665 .12684 L
.45668 .12107 L
.4567 .11849 L
.45671 .11604 L
.45674 .11619 L
.45677 .11789 L
.45679 .11885 L
.45681 .11976 L
.45684 .11989 L
.45687 .11959 L
.4569 .11926 L
.45692 .11931 L
.45693 .12008 L
.45696 .12148 L
.45699 .12279 L
.45702 .12318 L
.45705 .12086 L
.45708 .1186 L
.4571 .11652 L
.45713 .11636 L
.45717 .11619 L
.45718 .1161 L
.4572 .11601 L
.45722 .11357 L
.45723 .11129 L
.45726 .10719 L
.45728 .10493 L
.4573 .10315 L
.45733 .10446 L
.45736 .10566 L
.45741 .10831 L
.45744 .11003 L
.45747 .11186 L
.45749 .11282 L
.4575 .115 L
.45754 .11901 L
Mistroke
.45756 .12285 L
.45759 .12381 L
.45762 .11958 L
.45765 .11496 L
.45768 .10996 L
.45769 .10935 L
.45771 .10943 L
.45774 .10959 L
.45777 .10974 L
.45779 .11013 L
.45782 .11072 L
.45785 .11132 L
.45788 .11113 L
.4579 .10731 L
.45793 .10321 L
.45796 .09934 L
.45798 .09889 L
.45801 .1009 L
.45804 .10278 L
.45807 .10513 L
.4581 .11025 L
.45813 .11533 L
.45814 .1181 L
.45816 .12008 L
.45819 .11947 L
.45822 .11881 L
.45825 .11824 L
.45827 .11606 L
.4583 .11306 L
.45833 .11029 L
.45836 .10917 L
.45838 .1101 L
.45844 .11223 L
.45857 .11614 L
.45859 .11843 L
.45863 .12092 L
.45865 .12129 L
.45868 .12071 L
.45871 .12004 L
.45873 .1197 L
.45875 .119 L
.45878 .11766 L
.45881 .11643 L
.45882 .11573 L
.45884 .11654 L
.45886 .11811 L
.45887 .11983 L
.45894 .12429 L
.45897 .12429 L
.459 .12429 L
Mistroke
.45902 .12429 L
.45903 .12601 L
.45907 .12961 L
.4591 .13298 L
.45912 .13569 L
.45914 .13661 L
.45916 .13762 L
.45919 .13938 L
.45921 .14051 L
.45925 .13801 L
.45927 .13585 L
.4593 .13352 L
.45933 .13504 L
.45936 .13729 L
.45941 .14194 L
.45944 .14643 L
.45946 .1489 L
.45948 .15124 L
.45949 .15342 L
.45951 .15381 L
.45954 .15237 L
.45957 .15085 L
.45958 .15009 L
.4596 .14989 L
.45962 .1504 L
.45964 .15088 L
.45965 .15132 L
.45967 .1518 L
.4597 .15132 L
.45973 .14913 L
.45976 .14711 L
.45979 .14643 L
.45982 .15347 L
.45985 .15987 L
.45986 .16341 L
.45988 .1668 L
.45991 .16765 L
.45994 .16844 L
.45997 .16919 L
.45998 .17049 L
.46 .17237 L
.46003 .17568 L
.46006 .17882 L
.46009 .18076 L
.46011 .18166 L
.46014 .18248 L
.46016 .18299 L
.46017 .1844 L
.4602 .18906 L
.46024 .1945 L
Mistroke
.46027 .19914 L
.46033 .2051 L
.46039 .21126 L
.4609 .24807 L
.46134 .29156 L
.46147 .30678 L
.46148 .30945 L
.4615 .31224 L
.46152 .31372 L
.46153 .31481 L
.46157 .31694 L
.4616 .31892 L
.46162 .31629 L
.46165 .31345 L
.46168 .31031 L
.46171 .30995 L
.46174 .3116 L
.46175 .31246 L
.46177 .31338 L
.4618 .31435 L
.46183 .3145 L
.46186 .31467 L
.46189 .31505 L
.46191 .31557 L
.46193 .31614 L
.46196 .31716 L
.46199 .31797 L
.46202 .31831 L
.46205 .31863 L
.46207 .31892 L
.46211 .32419 L
.46214 .32992 L
.46217 .33497 L
.4622 .33224 L
.46223 .32944 L
.46225 .32789 L
.46227 .32696 L
.46229 .32879 L
.46231 .33045 L
.46234 .33371 L
.4624 .33822 L
.46243 .34022 L
.46246 .34205 L
.46248 .34574 L
.46251 .3499 L
.46253 .35206 L
.46254 .35443 L
.46257 .35603 L
.46261 .35657 L
.46263 .35686 L
Mistroke
.46264 .35714 L
.46266 .35844 L
.46268 .36049 L
.46271 .36407 L
.46274 .36772 L
.46275 .36798 L
.46277 .3666 L
.46283 .3619 L
.46289 .35829 L
.4629 .3574 L
.46292 .35645 L
.46295 .35568 L
.46298 .35568 L
.46301 .35568 L
.46304 .35678 L
.46306 .35889 L
.46307 .36083 L
.4631 .36398 L
.46312 .36734 L
.46315 .3655 L
.46318 .36342 L
.46321 .36107 L
.46324 .36118 L
.46327 .36232 L
.4633 .36356 L
.46333 .3651 L
.46336 .36713 L
.46338 .36811 L
.46339 .36904 L
.46342 .369 L
.46345 .36552 L
.46349 .36173 L
.4635 .35972 L
.46352 .3611 L
.46354 .36322 L
.46356 .36513 L
.46359 .36884 L
.46362 .36768 L
.46365 .36042 L
.46366 .35672 L
.46368 .35276 L
.46371 .35051 L
.46374 .35603 L
.46377 .3625 L
.4638 .36803 L
.46383 .36707 L
.46386 .36601 L
.46389 .36496 L
.46391 .36322 L
.46393 .36164 L
Mistroke
.46395 .35881 L
.46399 .35573 L
.46402 .3574 L
.46404 .35903 L
.46406 .36003 L
.46408 .36107 L
.4641 .36153 L
.46412 .36172 L
.46415 .36207 L
.46417 .36227 L
.46418 .36336 L
.4642 .36711 L
.46421 .37066 L
.46424 .37731 L
.46428 .38403 L
.46429 .38249 L
.46431 .38106 L
.46434 .37862 L
.46437 .37599 L
.4644 .37438 L
.46442 .37296 L
.46445 .37144 L
.46448 .36653 L
.46451 .35848 L
.46453 .35395 L
.46454 .34968 L
.46456 .34549 L
.46458 .34577 L
.46461 .34658 L
.46462 .34704 L
.46464 .34752 L
.46466 .34788 L
.46467 .34725 L
.4647 .34611 L
.46472 .34549 L
.46474 .34489 L
.46477 .34523 L
.46479 .34704 L
.46482 .349 L
.46484 .3501 L
.46486 .34954 L
.46488 .3466 L
.46491 .34349 L
.46494 .3407 L
.46497 .33443 L
.46502 .32009 L
.46509 .30171 L
.46512 .29226 L
.46514 .28774 L
.46516 .28909 L
Mistroke
.46517 .29052 L
.46519 .29207 L
.46521 .29353 L
.46524 .29253 L
.46527 .28477 L
.4653 .27792 L
.46532 .2717 L
.46535 .26875 L
.46538 .26552 L
.46541 .26277 L
.46543 .2614 L
.46546 .26125 L
.46548 .26112 L
.46551 .26097 L
.46554 .25599 L
.46557 .25105 L
.46559 .24575 L
.46562 .24332 L
.46565 .2457 L
.46568 .24826 L
.46569 .24963 L
.46571 .25063 L
.46574 .2508 L
.46577 .25096 L
.46579 .25105 L
.46581 .25121 L
.46584 .25172 L
.46587 .25216 L
.46589 .25263 L
.46593 .24961 L
.46596 .24656 L
.46597 .24485 L
.46599 .24302 L
.46601 .24426 L
.46603 .24571 L
.46609 .25109 L
.46616 .25505 L
.46622 .25953 L
.46625 .26177 L
.46628 .26365 L
.46631 .26424 L
.46634 .26488 L
.46637 .26549 L
.4664 .26508 L
.46643 .26447 L
.46645 .26392 L
.46651 .26232 L
.46653 .26185 L
.46655 .26136 L
.46656 .26088 L
Mistroke
.46658 .25767 L
.46661 .25182 L
.46663 .24861 L
.46665 .2456 L
.46667 .24225 L
.4667 .24091 L
.46676 .23814 L
.4668 .23609 L
.46683 .23422 L
.46686 .23211 L
.46689 .2286 L
.46692 .22504 L
.46693 .22308 L
.46695 .22139 L
.46698 .21934 L
.46701 .21748 L
.46706 .21424 L
.46717 .20899 L
.4672 .20747 L
.46723 .20612 L
.46726 .20829 L
.4673 .21067 L
.46733 .21269 L
.46735 .21364 L
.46739 .21465 L
.46741 .21558 L
.46745 .21603 L
.46746 .21612 L
.46748 .21621 L
.46751 .21638 L
.46754 .21706 L
.46757 .21809 L
.46759 .21866 L
.46761 .21919 L
.46762 .2185 L
.46764 .21557 L
.46768 .21042 L
.46771 .20579 L
.46772 .20436 L
.46774 .20326 L
.46777 .20128 L
.4678 .19948 L
.46781 .19784 L
.46783 .19553 L
.46786 .19042 L
.46789 .18601 L
.46791 .18536 L
.46793 .18622 L
.46796 .1879 L
.46799 .18949 L
Mistroke
.46801 .18916 L
.46804 .18762 L
.46807 .18594 L
.46809 .1851 L
.46811 .18555 L
.46814 .1872 L
.46817 .18874 L
.46819 .18984 L
.46822 .18838 L
.46825 .18709 L
.46828 .18572 L
.4683 .18567 L
.46833 .18612 L
.46836 .18651 L
.46838 .18692 L
.46841 .18517 L
.46844 .18354 L
.46847 .18178 L
.46848 .18164 L
.4685 .18249 L
.46853 .184 L
.46855 .18543 L
.46858 .18555 L
.46861 .18362 L
.46872 .17375 L
.46877 .1677 L
.46882 .16203 L
.46885 .15888 L
.46888 .15954 L
.4689 .16081 L
.46891 .16201 L
.46894 .16424 L
.46897 .16327 L
.469 .16002 L
.46905 .15268 L
.46911 .14513 L
.46913 .14306 L
.46914 .14085 L
.46917 .14295 L
.4692 .14603 L
.46922 .14766 L
.46924 .14939 L
.46925 .15021 L
.46927 .15095 L
.4693 .15225 L
.46933 .15357 L
.46935 .15213 L
.46936 .14992 L
.46939 .14594 L
.46942 .14159 L
Mistroke
.46945 .13971 L
.46948 .13886 L
.46951 .13796 L
.46954 .13774 L
.46955 .13884 L
.46957 .13999 L
.4696 .14206 L
.46966 .14675 L
.46969 .1487 L
.46972 .1506 L
.46974 .14957 L
.46975 .14863 L
.46979 .1468 L
.46981 .14507 L
.46984 .14625 L
.46987 .1478 L
.4699 .1492 L
.46993 .14856 L
.46996 .14701 L
.46999 .14525 L
.47001 .14412 L
.47004 .14492 L
.47007 .1458 L
.47011 .14692 L
.47012 .14864 L
.47014 .1502 L
.4702 .15611 L
.47026 .16156 L
.47029 .16463 L
.4703 .16414 L
.47032 .16235 L
.47035 .15887 L
.47037 .15695 L
.47039 .15528 L
.47041 .15474 L
.47042 .15416 L
.47046 .15313 L
.47047 .15263 L
.47049 .15252 L
.47052 .15429 L
.47055 .15622 L
.47058 .15766 L
.47061 .15116 L
.47065 .14403 L
.47068 .13829 L
.4707 .13858 L
.47073 .13891 L
.47077 .13925 L
.47078 .13747 L
.4708 .13455 L
Mistroke
.47083 .12941 L
.47085 .12652 L
.47087 .1238 L
.47089 .12399 L
.4709 .12417 L
.47093 .1245 L
.47095 .12469 L
.47097 .12396 L
.47098 .12104 L
.471 .11838 L
.47103 .11241 L
.47109 .10382 L
.47112 .09969 L
.47115 .09582 L
.47117 .09574 L
.47118 .09565 L
.4712 .09555 L
.47122 .09545 L
.47123 .09537 L
.47125 .0959 L
.47128 .09978 L
.47134 .10749 L
.47137 .1107 L
.4714 .11366 L
.47143 .11643 L
.47146 .11559 L
.47149 .11391 L
.47152 .11238 L
.47155 .10963 L
.47158 .10588 L
.47163 .09885 L
.47169 .09159 L
.4717 .0896 L
.47172 .08749 L
.47175 .0889 L
.47178 .09072 L
.47181 .09269 L
.47186 .09719 L
.47191 .10297 L
.47197 .10808 L
.472 .11078 L
.47203 .11061 L
.47205 .10945 L
.47207 .10835 L
.4721 .10631 L
.47213 .10335 L
.47217 .09987 L
.4722 .0969 L
.47221 .09683 L
.47223 .09753 L
Mistroke
.47226 .09876 L
.47228 .09992 L
.47232 .10038 L
.47234 .10023 L
.47237 .10006 L
.4724 .10018 L
.47243 .10086 L
.47247 .10158 L
.4725 .10161 L
.47252 .10025 L
.47256 .09868 L
.47259 .09755 L
.47261 .09949 L
.47264 .10129 L
.47267 .10325 L
.4727 .10382 L
.47273 .10335 L
.47275 .10292 L
.47278 .10283 L
.47281 .10418 L
.47284 .10545 L
.47287 .10686 L
.47289 .10812 L
.47291 .10927 L
.47294 .1115 L
.47297 .1134 L
.473 .11289 L
.47303 .11246 L
.47306 .11198 L
.47308 .11198 L
.47311 .11214 L
.47317 .11242 L
.47322 .11271 L
.47325 .11286 L
.47327 .11519 L
.47337 .12481 L
.47384 .1593 L
.47434 .19963 L
.4753 .26165 L
.47622 .32468 L
.47646 .34238 L
.47649 .33959 L
.47652 .34134 L
.47655 .34597 L
.47657 .34857 L
.47658 .35103 L
.47661 .35392 L
.47664 .35461 L
.47666 .35541 L
.47669 .35615 L
Mistroke
.47672 .3636 L
.47675 .37195 L
.47678 .38104 L
.47681 .38695 L
.47684 .39166 L
.47687 .39597 L
.4769 .39894 L
.47692 .39932 L
.47693 .39968 L
.47695 .40003 L
.47696 .40037 L
.47698 .401 L
.477 .40345 L
.47706 .41271 L
.4772 .43918 L
.47722 .44811 L
.47725 .45656 L
.47728 .46068 L
.47731 .45963 L
.47737 .45695 L
.4774 .45527 L
.47743 .45341 L
.47746 .45286 L
.47748 .45544 L
.47749 .45786 L
.47752 .46247 L
.47755 .46685 L
.47757 .46713 L
.47758 .46732 L
.47761 .46764 L
.47763 .46782 L
.47765 .46805 L
.47767 .46888 L
.47768 .46963 L
.47779 .46649 L
.47782 .46299 L
.47785 .46123 L
.47787 .46253 L
.4779 .46394 L
.47792 .46532 L
.47795 .46789 L
.47798 .47154 L
.47801 .47492 L
.47803 .4792 L
.47806 .48558 L
.47809 .49266 L
.47811 .49653 L
.47812 .5001 L
.47815 .50057 L
.47818 .50109 L
Mistroke
.47821 .50152 L
.47824 .49796 L
.47837 .47613 L
.47859 .44293 L
.47909 .38108 L
.47956 .33743 L
.48008 .28215 L
.48033 .2597 L
.48039 .25033 L
.48041 .24786 L
.48043 .24574 L
.48046 .24301 L
.48047 .24168 L
.48049 .24026 L
.48052 .23863 L
.48055 .23846 L
.48058 .2383 L
.48061 .23787 L
.48064 .23592 L
.48067 .23383 L
.4807 .23153 L
.48072 .23043 L
.48075 .22976 L
.48077 .22906 L
.4808 .22821 L
.48083 .22566 L
.48086 .22324 L
.48089 .22089 L
.48092 .22144 L
.48095 .22253 L
.48098 .22374 L
.481 .22365 L
.48101 .22132 L
.48104 .21709 L
.48107 .21306 L
.4811 .21006 L
.48113 .20743 L
.48116 .20505 L
.48119 .20522 L
.48122 .21036 L
.48124 .21595 L
.48127 .22196 L
.4813 .22032 L
.48133 .21788 L
.4814 .21258 L
.48143 .20997 L
.48145 .20868 L
.48146 .20749 L
.48149 .20792 L
.48151 .20842 L
Mistroke
.48153 .20896 L
.48156 .20997 L
.48159 .21353 L
.48162 .21838 L
.48163 .22094 L
.48165 .22368 L
.48168 .22247 L
.48171 .21861 L
.48174 .21421 L
.48177 .21153 L
.48178 .21116 L
.4818 .21078 L
.48182 .21036 L
.48184 .20997 L
.48185 .20951 L
.48187 .20853 L
.48191 .20643 L
.48197 .2014 L
.482 .19818 L
.48203 .19515 L
.48206 .19449 L
.48209 .195 L
.48212 .19542 L
.48215 .19562 L
.48218 .19529 L
.48219 .19512 L
.48221 .19493 L
.48224 .19413 L
.48227 .19214 L
.4823 .19015 L
.48233 .18799 L
.48236 .18967 L
.48238 .19128 L
.48241 .19272 L
.48243 .19253 L
.48246 .18967 L
.48249 .18698 L
.48299 .14469 L
.48322 .12822 L
.48335 .11676 L
.48337 .11634 L
.48338 .1156 L
.48341 .11296 L
.48344 .11056 L
.48347 .10802 L
.4835 .11 L
.48353 .11289 L
.48355 .11555 L
.48357 .1176 L
.4836 .1179 L
Mistroke
.48363 .11822 L
.48366 .11851 L
.48368 .12048 L
.48374 .12623 L
.48377 .1289 L
.4838 .12861 L
.48383 .12826 L
.48386 .12793 L
.48389 .12548 L
.48392 .12272 L
.48394 .12023 L
.48397 .11874 L
.484 .11813 L
.48403 .11757 L
.48406 .11606 L
.48407 .1135 L
.48409 .11068 L
.48412 .10572 L
.48415 .10118 L
.48416 .10108 L
.48418 .10117 L
.48421 .10135 L
.48424 .10149 L
.48426 .10095 L
.48428 .10045 L
.48431 .09949 L
.48433 .09859 L
.48435 .09846 L
.48437 .09856 L
.4844 .09872 L
.48443 .09889 L
.48446 .09732 L
.48449 .09484 L
.48451 .09367 L
.48452 .09258 L
.48454 .0926 L
.48456 .09327 L
.48459 .09447 L
.48466 .09732 L
.4849 .10593 L
.48514 .11793 L
.48517 .11826 L
.48518 .11844 L
.4852 .11868 L
.48523 .12003 L
.48526 .12125 L
.48532 .1245 L
.48535 .1266 L
.48537 .12775 L
.48539 .12882 L
Mistroke
.48542 .12966 L
.48545 .13051 L
.4855 .13236 L
.48554 .13398 L
.48557 .13552 L
.4856 .13596 L
.48563 .13546 L
.48565 .13503 L
.48568 .13477 L
.48571 .13549 L
.48573 .13614 L
.48576 .1369 L
.48579 .1357 L
.48582 .13323 L
.48585 .13097 L
.48595 .1239 L
.486 .12007 L
.48603 .11813 L
.48606 .11634 L
.48609 .11969 L
.48612 .12445 L
.48615 .12841 L
.48617 .1307 L
.4862 .13176 L
.48623 .13274 L
.48629 .1351 L
.48632 .13638 L
.48634 .13757 L
.48637 .14053 L
.4864 .14407 L
.48646 .15127 L
.48651 .16053 L
.48654 .16569 L
.48656 .16479 L
.48657 .16396 L
.4866 .1624 L
.48663 .16094 L
.48666 .16156 L
.48669 .16311 L
.48675 .16636 L
.48678 .16798 L
.48681 .1695 L
.48683 .17034 L
.48684 .17054 L
.48687 .17086 L
.48689 .17104 L
.48691 .17124 L
.48692 .17139 L
.48694 .1712 L
.48697 .17085 L
Mistroke
.487 .17052 L
.48703 .1729 L
.48706 .17757 L
.48709 .18292 L
.48712 .18675 L
.48715 .18863 L
.48718 .19062 L
.48724 .19381 L
.48727 .19484 L
.48729 .19581 L
.48732 .19847 L
.48735 .20176 L
.48745 .21412 L
.48748 .21773 L
.4875 .21963 L
.48751 .2204 L
.48754 .22178 L
.48757 .2233 L
.4876 .2255 L
.48763 .22903 L
.48766 .23273 L
.48768 .23675 L
.48771 .23875 L
.48774 .24044 L
.4878 .24318 L
.48782 .24392 L
.48785 .24472 L
.48787 .24517 L
.48788 .2462 L
.48792 .24997 L
.48794 .25364 L
.48796 .25571 L
.48798 .25717 L
.48799 .25625 L
.48801 .25527 L
.48804 .25326 L
.4881 .25051 L
.48816 .24868 L
.48821 .25062 L
.48824 .25177 L
.48827 .25149 L
.4883 .2472 L
.48833 .24319 L
.48836 .23978 L
.48839 .24073 L
.48842 .24162 L
.48845 .2426 L
.48847 .24385 L
.4885 .24513 L
.48853 .24637 L
Mistroke
.48855 .24763 L
.48858 .25215 L
.4886 .25624 L
.48863 .26081 L
.48866 .26275 L
.48869 .26229 L
.48871 .26187 L
.48874 .2612 L
.48876 .26036 L
.48878 .25959 L
.48881 .25808 L
.48884 .25659 L
.48886 .2545 L
.48889 .25226 L
.48891 .25104 L
.48893 .24976 L
.48896 .25299 L
.48899 .25667 L
.48902 .26059 L
.48904 .25978 L
.48905 .2573 L
.48909 .25243 L
.48911 .24823 L
.48914 .24652 L
.48917 .24598 L
.4892 .24538 L
.48922 .24594 L
.48924 .24829 L
.48926 .25043 L
.48931 .25833 L
.48953 .28386 L
.48956 .28402 L
.48959 .28418 L
.48962 .28815 L
.48964 .29394 L
.48967 .29997 L
.4897 .30446 L
.48973 .30242 L
.48975 .30132 L
.48977 .30027 L
.4898 .29897 L
.48982 .30011 L
.48985 .30144 L
.48988 .30266 L
.48991 .3047 L
.48993 .30711 L
.48999 .31232 L
.49005 .31903 L
.49006 .32096 L
.49008 .32256 L
Mistroke
.49011 .32273 L
.49014 .32287 L
.49016 .32302 L
.4902 .32307 L
.49022 .32307 L
.49024 .32307 L
.49026 .32307 L
.49028 .32249 L
.4903 .32135 L
.49033 .31911 L
.49035 .31802 L
.49036 .31703 L
.49039 .317 L
.49042 .31716 L
.49044 .31725 L
.49045 .31734 L
.49049 .3178 L
.49051 .31824 L
.49054 .31871 L
.49057 .31813 L
.4906 .31687 L
.49063 .3157 L
.49065 .31586 L
.49068 .32306 L
.49071 .33076 L
.49073 .33485 L
.49074 .33917 L
.49076 .33928 L
.49078 .33891 L
.49081 .3382 L
.49084 .33761 L
.49087 .33879 L
.4909 .34006 L
.49092 .34078 L
.49093 .34146 L
.49096 .34013 L
.49099 .33809 L
.49102 .33618 L
.49104 .33555 L
.49106 .33574 L
.49109 .33608 L
.49112 .3364 L
.49115 .33757 L
.49117 .33902 L
.4912 .3406 L
.49127 .34291 L
.4913 .34384 L
.49132 .34434 L
.49134 .34588 L
.4914 .35128 L
Mistroke
.49144 .35365 L
.49147 .35572 L
.4915 .35792 L
.49153 .35745 L
.49156 .35506 L
.49159 .35245 L
.49165 .34834 L
.49168 .34611 L
.49171 .34517 L
.49174 .34612 L
.49177 .34715 L
.4918 .34732 L
.49183 .34432 L
.49185 .34124 L
.49188 .33837 L
.49191 .33856 L
.49194 .34156 L
.49197 .34478 L
.49198 .3466 L
.492 .34555 L
.49203 .34264 L
.49206 .33953 L
.49218 .33084 L
.49224 .326 L
.49225 .32468 L
.49227 .32328 L
.4923 .32352 L
.49232 .32381 L
.49234 .32407 L
.49235 .32438 L
.49237 .32457 L
.49239 .32431 L
.4924 .32405 L
.49244 .3235 L
.49336 .30715 L
.49348 .29884 L
.4935 .29529 L
.49352 .29142 L
.49353 .29314 L
.49355 .29543 L
.49358 .30004 L
.49361 .30437 L
.49364 .30416 L
.49367 .30317 L
.49372 .30144 L
.49375 .30046 L
.49377 .29992 L
.49378 .29942 L
.49381 .29887 L
.49384 .29952 L
Mistroke
.49387 .30019 L
.4939 .30088 L
.49393 .3029 L
.49396 .30509 L
.49399 .30747 L
.494 .30656 L
.49402 .30334 L
.49405 .29796 L
.49408 .2923 L
.4941 .29039 L
.49411 .29019 L
.49415 .28985 L
.49416 .28966 L
.49418 .28945 L
.4942 .28901 L
.49422 .28857 L
.49425 .28771 L
.49426 .28726 L
.49428 .28656 L
.4943 .28421 L
.49431 .28164 L
.49434 .27711 L
.49437 .27269 L
.4944 .27047 L
.49444 .26826 L
.49447 .26621 L
.49449 .26651 L
.4945 .26696 L
.49453 .26778 L
.49456 .26858 L
.49459 .27113 L
.49462 .27408 L
.49465 .27724 L
.49467 .27907 L
.4947 .27907 L
.49472 .27907 L
.49475 .27907 L
.49478 .28018 L
.49481 .28144 L
.49484 .2828 L
.49487 .28225 L
.49489 .28144 L
.4949 .2807 L
.49492 .27983 L
.49494 .27903 L
.49496 .27865 L
.49497 .27892 L
.49501 .27951 L
.49503 .27979 L
.49504 .28006 L
Mistroke
.49507 .27637 L
.4951 .27254 L
.49513 .26851 L
.49516 .26877 L
.49519 .27034 L
.49522 .27203 L
.49524 .27255 L
.49525 .27029 L
.49529 .26588 L
.49531 .26174 L
.49534 .25882 L
.49537 .25712 L
.4954 .2554 L
.49543 .25372 L
.49546 .25389 L
.49548 .25397 L
.49549 .25407 L
.49552 .25397 L
.49555 .2506 L
.49577 .23183 L
.4958 .23149 L
.49582 .23029 L
.49584 .22853 L
.49587 .22483 L
.49589 .22304 L
.49591 .22166 L
.49594 .2225 L
.49597 .22341 L
.496 .22404 L
.49603 .22177 L
.49606 .21962 L
.49609 .21759 L
.49612 .21634 L
.49615 .21559 L
.49618 .21475 L
.4962 .21438 L
.49621 .21446 L
.49627 .21479 L
.49633 .21706 L
.49635 .21874 L
.49638 .22054 L
.49641 .21849 L
.49644 .21614 L
.49647 .21398 L
.49649 .21319 L
.49652 .21435 L
.49655 .2156 L
.49658 .21647 L
.49661 .21663 L
.49664 .21677 L
Mistroke
.49667 .21692 L
.4967 .21681 L
.49672 .21666 L
.49674 .21657 L
.49676 .21648 L
.49678 .21704 L
.49679 .21817 L
.49683 .22037 L
.49686 .22243 L
.49689 .22305 L
.49692 .22353 L
.49693 .2238 L
.49695 .22407 L
.49698 .22432 L
.49701 .22449 L
.49703 .22458 L
.49705 .22467 L
.49708 .22586 L
.49711 .2276 L
.49714 .22916 L
.49716 .22968 L
.49719 .22921 L
.49722 .22871 L
.49728 .22771 L
.49731 .22722 L
.49734 .22681 L
.49737 .22736 L
.49739 .22794 L
.49742 .22853 L
.49745 .231 L
.49748 .23557 L
.49751 .23991 L
.49753 .2423 L
.49755 .24252 L
.49758 .24185 L
.49761 .24121 L
.49764 .2385 L
.49767 .23233 L
.4977 .22674 L
.49772 .22108 L
.49775 .2195 L
.49778 .21814 L
.4978 .21669 L
.49783 .21559 L
.49786 .215 L
.49789 .21436 L
.49791 .21402 L
.49792 .21353 L
.49795 .21239 L
.49798 .21134 L
Mistroke
.49803 .20927 L
.49814 .20557 L
.49825 .19977 L
.49827 .1976 L
.4983 .19599 L
.49833 .19752 L
.49836 .19894 L
.49838 .19974 L
.4984 .19999 L
.49841 .19853 L
.49843 .19719 L
.49846 .19469 L
.49849 .19218 L
.49852 .19345 L
.49854 .19463 L
.49857 .19588 L
.4986 .19415 L
.49863 .19145 L
.49866 .18895 L
.49869 .18854 L
.49872 .19112 L
.49875 .19358 L
.49878 .1943 L
.49881 .19153 L
.49883 .18855 L
.49886 .1858 L
.49889 .18506 L
.49892 .18538 L
.49894 .18567 L
.49897 .1857 L
.49899 .18483 L
.49902 .18389 L
.49904 .18288 L
.49907 .18386 L
.4991 .18731 L
.49916 .19519 L
.49919 .19965 L
.49922 .2039 L
.49925 .20757 L
.49928 .20442 L
.49931 .20149 L
.49934 .19874 L
.49937 .1978 L
.4994 .1978 L
.49942 .1978 L
.49945 .198 L
.49948 .19902 L
.4995 .2001 L
.49953 .20127 L
.49956 .20115 L
Mistroke
.49958 .20098 L
.4996 .2008 L
.49963 .20046 L
.49966 .19838 L
.49969 .19554 L
.49972 .19288 L
.49974 .19165 L
.49977 .19182 L
.49979 .19191 L
.49981 .192 L
.49983 .19176 L
.49987 .19077 L
.4999 .18966 L
.49992 .18905 L
.49994 .18873 L
.49997 .18817 L
.5 .18765 L
.50006 .19087 L
.50008 .19214 L
.50009 .19335 L
.50012 .19312 L
.50015 .1895 L
.50018 .18614 L
.50021 .18245 L
.50024 .18366 L
.50027 .1852 L
.5003 .18664 L
.50032 .18647 L
.50035 .18584 L
.50037 .18547 L
.50039 .18513 L
.5004 .18507 L
.50042 .18605 L
.50048 .18942 L
.50051 .18941 L
.50054 .18822 L
.50056 .18716 L
.50059 .18605 L
.50061 .18717 L
.50064 .18851 L
.50067 .19 L
.5007 .19028 L
.50073 .188 L
.50074 .18674 L
.50076 .18555 L
.50079 .185 L
.50082 .18933 L
.50093 .20679 L
.50096 .21161 L
.50097 .21391 L
Mistroke
.50099 .21482 L
.50102 .21644 L
.50105 .21793 L
.50106 .21882 L
.50108 .21717 L
.5011 .21464 L
.50111 .21189 L
.50114 .20735 L
.50116 .20476 L
.50118 .20492 L
.50121 .2057 L
.50124 .20654 L
.50125 .20698 L
.50127 .2083 L
.5013 .21127 L
.50133 .21384 L
.50136 .21646 L
.50139 .21696 L
.50142 .21743 L
.50186 .22294 L
.50189 .22326 L
.50191 .22343 L
.50192 .2236 L
.50195 .22442 L
.50198 .22532 L
.50201 .22625 L
.50204 .22814 L
.50206 .22967 L
.50208 .23129 L
.50211 .23423 L
.50213 .23543 L
.50215 .23448 L
.50218 .23277 L
.50225 .22987 L
.50228 .22865 L
.5023 .22798 L
.50231 .22735 L
.50234 .22806 L
.50237 .22893 L
.5024 .22974 L
.50242 .23076 L
.50244 .23195 L
.50247 .23409 L
.5025 .23645 L
.50252 .23785 L
.50255 .23885 L
.50261 .24168 L
.50286 .25192 L
.50288 .25123 L
.50291 .25299 L
Mistroke
.50294 .25542 L
.50297 .25766 L
.50299 .25882 L
.50302 .25869 L
.50305 .25854 L
.50307 .2584 L
.5031 .25486 L
.50313 .25081 L
.50316 .24645 L
.50318 .24488 L
.50319 .24767 L
.50322 .25256 L
.50325 .25715 L
.50328 .26082 L
.5033 .25763 L
.50333 .25397 L
.50335 .25197 L
.50337 .2501 L
.50339 .25157 L
.50342 .25322 L
.50344 .25414 L
.50346 .25501 L
.50349 .25844 L
.50352 .26251 L
.50354 .26475 L
.50355 .26684 L
.50358 .26703 L
.50361 .26686 L
.50364 .26672 L
.50367 .26853 L
.50368 .27065 L
.5037 .27296 L
.50373 .27717 L
.50376 .27972 L
.50379 .28002 L
.50382 .28035 L
.50383 .28053 L
.50385 .28087 L
.50388 .28181 L
.50391 .2828 L
.50394 .28369 L
.50396 .28691 L
.50402 .29447 L
.50427 .32095 L
.5043 .32568 L
.50433 .32976 L
.50435 .33063 L
.50436 .33159 L
.50439 .3333 L
.50442 .33607 L
Mistroke
.50444 .3394 L
.50446 .34245 L
.50449 .34843 L
.50451 .35333 L
.50453 .35116 L
.50455 .34883 L
.50458 .3439 L
.50465 .33372 L
.50467 .33135 L
.50468 .32878 L
.5047 .32635 L
.50472 .32617 L
.50475 .32617 L
.50478 .32617 L
.50481 .32702 L
.50484 .33097 L
.50486 .33446 L
.50489 .33808 L
.50492 .33792 L
.50495 .33777 L
.50498 .33763 L
.505 .33828 L
.50503 .33987 L
.50506 .34156 L
.50509 .34343 L
.50512 .34773 L
.50515 .35236 L
.50517 .3549 L
.50518 .35649 L
.5052 .35566 L
.50522 .35476 L
.50525 .35318 L
.5053 .34968 L
.50533 .34732 L
.50536 .34513 L
.50538 .34603 L
.5054 .34881 L
.50542 .35177 L
.50545 .35702 L
.50547 .36022 L
.5055 .35707 L
.50553 .35366 L
.50556 .35066 L
.50558 .34423 L
.50563 .33141 L
.50566 .32468 L
.50569 .32563 L
.50571 .32672 L
.50574 .32775 L
.50577 .3285 L
Mistroke
.50579 .32909 L
.50582 .32973 L
.50585 .32984 L
.50588 .32692 L
.50591 .32427 L
.50593 .32274 L
.50594 .32112 L
.50597 .32038 L
.50601 .31963 L
.50603 .31927 L
.50604 .31894 L
.50607 .32204 L
.5061 .32543 L
.50611 .3272 L
.50613 .32912 L
.50616 .32966 L
.50619 .32949 L
.50622 .32933 L
.50624 .32932 L
.50625 .3294 L
.50629 .32959 L
.5063 .32967 L
.50632 .32977 L
.50634 .32851 L
.50636 .32682 L
.50639 .32375 L
.50641 .32214 L
.50642 .32048 L
.50644 .32039 L
.50646 .32029 L
.50649 .32012 L
.5065 .32004 L
.50652 .31949 L
.50655 .31402 L
.50658 .30833 L
.50661 .30295 L
.50664 .30462 L
.50667 .30742 L
.5067 .31028 L
.50672 .30863 L
.50675 .30144 L
.50678 .29388 L
.50684 .28361 L
.50686 .27905 L
.50689 .27474 L
.50691 .27308 L
.50692 .27235 L
.50695 .27107 L
.50698 .26988 L
.50701 .26899 L
Mistroke
.50703 .26871 L
.50704 .26845 L
.50706 .26815 L
.50708 .26788 L
.50711 .26435 L
.50713 .2612 L
.50714 .25822 L
.50717 .25229 L
.5072 .24826 L
.50722 .24684 L
.50724 .24532 L
.50727 .24265 L
.50732 .2366 L
.50735 .23313 L
.50738 .23028 L
.5074 .23204 L
.50742 .23365 L
.50745 .23679 L
.50747 .23848 L
.50749 .23946 L
.5075 .23984 L
.50752 .2402 L
.50755 .24083 L
.50757 .24119 L
.50758 .24003 L
.50761 .23663 L
.50765 .23298 L
.5077 .22489 L
.50773 .22048 L
.50776 .21641 L
.50779 .2165 L
.5078 .21684 L
.50782 .2172 L
.50785 .21778 L
.50788 .21533 L
.50789 .21312 L
.50791 .2111 L
.50793 .20892 L
.50794 .20655 L
.50796 .20691 L
.50798 .20919 L
.50801 .21369 L
.50803 .21779 L
.50807 .21666 L
.50808 .2143 L
.5081 .21176 L
.50813 .20715 L
.50814 .20503 L
.50816 .20485 L
.50819 .20453 L
Mistroke
.50826 .20369 L
.50829 .2031 L
.50831 .2028 L
.50833 .20253 L
.50836 .20459 L
.50839 .20733 L
.50851 .21682 L
.50854 .21978 L
.50857 .22344 L
.50859 .22511 L
.50861 .22689 L
.50864 .22693 L
.50865 .22556 L
.50867 .22408 L
.5087 .2214 L
.50873 .2199 L
.50876 .2196 L
.50878 .2193 L
.50881 .21888 L
.50884 .21296 L
.50887 .20648 L
.50889 .20086 L
.50892 .19626 L
.50897 .18988 L
.50903 .18337 L
.50906 .18085 L
.50909 .17814 L
.50912 .17623 L
.50914 .17498 L
.50916 .17426 L
.50918 .17349 L
.50921 .17508 L
.50923 .17688 L
.50924 .17881 L
.50927 .18227 L
.50929 .18311 L
.50931 .18062 L
.50934 .17597 L
.5094 .16833 L
.50946 .16035 L
.50947 .158 L
.50949 .1567 L
.50952 .15486 L
.50955 .15312 L
.50958 .15185 L
.50961 .15235 L
.50964 .1528 L
.50967 .15325 L
.50969 .15604 L
.50972 .1593 L
Mistroke
.50975 .16273 L
.50977 .1642 L
.50978 .16448 L
.50981 .16498 L
.50983 .16523 L
.50985 .1655 L
.50988 .16636 L
.50991 .16768 L
.50994 .16888 L
.50997 .16853 L
.50999 .16787 L
.51 .16714 L
.51006 .16373 L
.51011 .15749 L
.51014 .154 L
.51017 .15758 L
.5102 .16237 L
.51023 .16688 L
.51026 .16445 L
.51029 .15816 L
.51034 .14704 L
.51037 .14266 L
.5104 .13856 L
.51043 .13507 L
.51045 .13506 L
.51048 .13645 L
.51051 .13771 L
.51054 .13898 L
.51057 .1396 L
.5106 .14029 L
.51061 .14063 L
.51063 .14058 L
.51066 .13947 L
.51069 .13827 L
.51075 .13609 L
.51078 .13498 L
.51081 .13394 L
.51083 .13574 L
.51086 .1391 L
.51089 .14195 L
.51092 .14369 L
.51095 .14244 L
.51097 .1413 L
.511 .14004 L
.51102 .14007 L
.51103 .1404 L
.51107 .14113 L
.5111 .1418 L
.51113 .14018 L
.51115 .13828 L
Mistroke
.51118 .13627 L
.51121 .13707 L
.51123 .13928 L
.51125 .14136 L
.51128 .14524 L
.51131 .14828 L
.51135 .15061 L
.51136 .15167 L
.51138 .15266 L
.5114 .15284 L
.51141 .1516 L
.51144 .1496 L
.51147 .14739 L
.5115 .15004 L
.51152 .15319 L
.51154 .15615 L
.51156 .16149 L
.51159 .16467 L
.51161 .16467 L
.51163 .16467 L
.51166 .16467 L
.51167 .16467 L
.51169 .16571 L
.51172 .16802 L
.51176 .17019 L
.51177 .1714 L
.51179 .17149 L
.51182 .17164 L
.51185 .17181 L
.51188 .17165 L
.5119 .17093 L
.51196 .16936 L
.51202 .16488 L
.51204 .16247 L
.51207 .1614 L
.5121 .1621 L
.51213 .16287 L
.51215 .16357 L
.51218 .16482 L
.51221 .16635 L
.51224 .16797 L
.51225 .16881 L
.51227 .1689 L
.5123 .16906 L
.51233 .16921 L
.51236 .1696 L
.51238 .1705 L
.51241 .17133 L
.51244 .17226 L
.51246 .1715 L
Mistroke
.51249 .17023 L
.51252 .16887 L
.51254 .16873 L
.51256 .1718 L
.51259 .1774 L
.51265 .18731 L
.5127 .19484 L
.51273 .19852 L
.51276 .19958 L
.51279 .20057 L
.51282 .20164 L
.51284 .20379 L
.51287 .2062 L
.5129 .20902 L
.51293 .21143 L
.51296 .21207 L
.51298 .21264 L
.51302 .21332 L
.51303 .21285 L
.51305 .21241 L
.51308 .21155 L
.51311 .21074 L
.51314 .21089 L
.51317 .21106 L
.51319 .21114 L
.5132 .21124 L
.51324 .21187 L
.51327 .21253 L
.51328 .21289 L
.5133 .21324 L
.51332 .21404 L
.51333 .21487 L
.51337 .21649 L
.5134 .21794 L
.51343 .21784 L
.51344 .21775 L
.51346 .21766 L
.51349 .2175 L
.51352 .22017 L
.51355 .22378 L
.51357 .2269 L
.5136 .23117 L
.51363 .2374 L
.51366 .24326 L
.51372 .25438 L
.51375 .26098 L
.51377 .26458 L
.51379 .26626 L
.51382 .26449 L
.51385 .26255 L
Mistroke
.51391 .25845 L
.51393 .25615 L
.51396 .25402 L
.51398 .25348 L
.51401 .25402 L
.51404 .25462 L
.51406 .25517 L
.51409 .2598 L
.51412 .26549 L
.51415 .27083 L
.51417 .27373 L
.5142 .27328 L
.51423 .27278 L
.51426 .27325 L
.51428 .27904 L
.51429 .28429 L
.51441 .31639 L
.51447 .32927 L
.5145 .33587 L
.51453 .3419 L
.51456 .34397 L
.51458 .34343 L
.51461 .34286 L
.51464 .34225 L
.51467 .34326 L
.51469 .34428 L
.51475 .34699 L
.51478 .3487 L
.51481 .35051 L
.51483 .35145 L
.51485 .34973 L
.51488 .34627 L
.51491 .343 L
.51494 .34078 L
.51496 .34109 L
.51499 .34138 L
.51525 .34452 L
.51537 .3472 L
.5154 .34827 L
.51543 .34829 L
.51545 .3482 L
.51546 .34811 L
.51549 .34794 L
.51552 .34945 L
.51555 .35114 L
.51561 .35513 L
.51566 .35905 L
.51569 .36126 L
.51571 .36082 L
.51575 .36013 L
Mistroke
.51576 .35976 L
.51578 .3594 L
.51581 .3549 L
.51584 .34916 L
.51587 .34407 L
.5159 .34114 L
.51593 .33911 L
.51596 .33726 L
.51599 .33782 L
.516 .34021 L
.51602 .34285 L
.51605 .34756 L
.51608 .34938 L
.5161 .34735 L
.51611 .34522 L
.51613 .3429 L
.51615 .34074 L
.51618 .34048 L
.5162 .3427 L
.51621 .34508 L
.51623 .34719 L
.51625 .34945 L
.51628 .35106 L
.51631 .35004 L
.51634 .34891 L
.51637 .34829 L
.5164 .34798 L
.51642 .3478 L
.51643 .34763 L
.51646 .34603 L
.51648 .34305 L
.5165 .33983 L
.51653 .33401 L
.51655 .33153 L
.51657 .3338 L
.5166 .33786 L
.51663 .34179 L
.51666 .3403 L
.51668 .33746 L
.51669 .33488 L
.51673 .32908 L
.51678 .31629 L
.51682 .3089 L
.51685 .30481 L
.51686 .30464 L
.51688 .30446 L
.5169 .30427 L
.51691 .30408 L
.51693 .30391 L
.51695 .30345 L
Mistroke
.51698 .30265 L
.51701 .30181 L
.51703 .2996 L
.51705 .29699 L
.51707 .29416 L
.5171 .28904 L
.51713 .28545 L
.51716 .28627 L
.51719 .28704 L
.51721 .28775 L
.51724 .28625 L
.51727 .28418 L
.5173 .28236 L
.51733 .28258 L
.51736 .28388 L
.51738 .28511 L
.51741 .28661 L
.51744 .28982 L
.51747 .29331 L
.5175 .29655 L
.51753 .29634 L
.51755 .29616 L
.51757 .29597 L
.5176 .29563 L
.51763 .29482 L
.51768 .29331 L
.51773 .29191 L
.51776 .29121 L
.51778 .29057 L
.51781 .28835 L
.51784 .28563 L
.51787 .28317 L
.51789 .28213 L
.51792 .28377 L
.51795 .28526 L
.51798 .28678 L
.518 .28554 L
.51801 .28439 L
.51804 .28229 L
.51807 .28032 L
.51809 .2793 L
.51812 .27881 L
.51815 .27832 L
.51818 .27646 L
.51821 .27283 L
.51824 .26889 L
.51836 .24811 L
.51842 .23907 L
.51845 .23464 L
.51847 .23421 L
Mistroke
.51849 .2354 L
.51851 .23737 L
.51854 .23943 L
.51856 .23995 L
.51857 .23867 L
.5186 .23643 L
.51883 .2209 L
.51886 .22118 L
.51889 .2206 L
.51891 .22001 L
.51894 .21872 L
.51897 .21621 L
.51899 .21392 L
.51905 .20867 L
.51908 .20565 L
.51911 .20237 L
.51914 .2016 L
.51917 .20476 L
.5192 .20809 L
.51923 .21146 L
.51924 .21244 L
.51926 .21335 L
.51929 .21513 L
.51932 .21637 L
.51935 .21502 L
.51938 .21359 L
.5194 .21229 L
.51943 .21276 L
.51946 .21444 L
.51949 .216 L
.51952 .21617 L
.51955 .21361 L
.51958 .21121 L
.51961 .21036 L
.51963 .21362 L
.51964 .21712 L
.51968 .22332 L
.51971 .22865 L
.51973 .23052 L
.51976 .23256 L
.51978 .23381 L
.51979 .235 L
.51983 .23392 L
.5199 .23084 L
.51993 .2271 L
.51995 .22504 L
.51996 .22309 L
.51998 .22128 L
.51999 .22067 L
.52002 .22351 L
Mistroke
.52005 .22624 L
.52008 .22881 L
.5201 .23031 L
.52013 .23163 L
.52017 .23296 L
.52018 .23315 L
.5202 .23186 L
.52023 .22937 L
.52026 .22705 L
.52029 .22369 L
.52031 .21854 L
.52035 .2133 L
.52036 .21035 L
.52038 .20977 L
.52039 .21086 L
.52041 .212 L
.52044 .21411 L
.5205 .21916 L
.52056 .22403 L
.52059 .22669 L
.52061 .22921 L
.52064 .23155 L
.52067 .23163 L
.52069 .22874 L
.52072 .22606 L
.52075 .22259 L
.52078 .22292 L
.5208 .22375 L
.52083 .22465 L
.52086 .22312 L
.52087 .22048 L
.52089 .21759 L
.52095 .20794 L
.52101 .20009 L
.52103 .19794 L
.52104 .19637 L
.52108 .19722 L
.52114 .19893 L
.52117 .20007 L
.52119 .20111 L
.52122 .2021 L
.52125 .20194 L
.52127 .20108 L
.5213 .20014 L
.52133 .19891 L
.52136 .19619 L
.52139 .19381 L
.52142 .1913 L
.52143 .19151 L
.52145 .19208 L
Mistroke
.52148 .19309 L
.5215 .19366 L
.52152 .19401 L
.52154 .19305 L
.52155 .19217 L
.52159 .19046 L
.5216 .18957 L
.52162 .18892 L
.52164 .18875 L
.52165 .18857 L
.52168 .18825 L
.52171 .18842 L
.52174 .1912 L
.52181 .19745 L
.52184 .20046 L
.52187 .2033 L
.52189 .20584 L
.52192 .20603 L
.52195 .20525 L
.52198 .20442 L
.52201 .20587 L
.52204 .21083 L
.52207 .21608 L
.52208 .21897 L
.5221 .22007 L
.52213 .21774 L
.52216 .21562 L
.52238 .20171 L
.52244 .20267 L
.52245 .20302 L
.52247 .20339 L
.5225 .19978 L
.52262 .18389 L
.52265 .17988 L
.52266 .17764 L
.52268 .17752 L
.52272 .17733 L
.52273 .17723 L
.52275 .17714 L
.52278 .1772 L
.5228 .17728 L
.52281 .17737 L
.52284 .17753 L
.52287 .17861 L
.52293 .18232 L
.52296 .18379 L
.52299 .18362 L
.52301 .18353 L
.52303 .18343 L
.52304 .18334 L
Mistroke
.52306 .18432 L
.52309 .18805 L
.52312 .19158 L
.52315 .19448 L
.52318 .1911 L
.52323 .18504 L
.52329 .17718 L
.5233 .17503 L
.52332 .17268 L
.52335 .17029 L
.52338 .17013 L
.52341 .16998 L
.52343 .16985 L
.52346 .17156 L
.52349 .17336 L
.52351 .17504 L
.52353 .17585 L
.52356 .17518 L
.52359 .17436 L
.52362 .1736 L
.52365 .17681 L
.52368 .1812 L
.52371 .185 L
.52373 .18396 L
.52376 .17918 L
.52379 .17467 L
.52382 .17081 L
.52385 .17033 L
.5239 .16946 L
.52393 .1688 L
.52397 .16813 L
.52399 .16752 L
.52402 .16824 L
.52404 .16915 L
.52406 .17 L
.52409 .17161 L
.52412 .17279 L
.52414 .17318 L
.52415 .17354 L
.52418 .17413 L
.52421 .17278 L
.52424 .16866 L
.52427 .16482 L
.5243 .16208 L
.52433 .16208 L
.52435 .16208 L
.52438 .16208 L
.52441 .16022 L
.52444 .15767 L
.52448 .1532 L
Mistroke
.52459 .14505 L
.52462 .14196 L
.52464 .14026 L
.52466 .13866 L
.52469 .13678 L
.52471 .13693 L
.52474 .13708 L
.52477 .13723 L
.52479 .13715 L
.5248 .13706 L
.52483 .1369 L
.52486 .13673 L
.52488 .13766 L
.5249 .13868 L
.52493 .14069 L
.52496 .14256 L
.52498 .14563 L
.52501 .1493 L
.52504 .15337 L
.52507 .15429 L
.5251 .1521 L
.52513 .14975 L
.52518 .14619 L
.52521 .14461 L
.52524 .14292 L
.52526 .14287 L
.52527 .14376 L
.52531 .1455 L
.52544 .15175 L
.52547 .15392 L
.5255 .15625 L
.52553 .15846 L
.52556 .15789 L
.52558 .15634 L
.52561 .15471 L
.52565 .1563 L
.52566 .15942 L
.52568 .16232 L
.52571 .16787 L
.52574 .16959 L
.52577 .16687 L
.5258 .16392 L
.52583 .16123 L
.52584 .16208 L
.52586 .16302 L
.52589 .1647 L
.52592 .16625 L
.52595 .17069 L
.52597 .17489 L
.526 .17933 L
Mistroke
.52603 .17804 L
.52606 .17344 L
.52609 .16856 L
.52611 .16459 L
.52614 .16327 L
.5262 .16032 L
.52626 .15629 L
.52628 .15524 L
.5263 .15412 L
.52631 .15583 L
.52633 .15841 L
.52637 .16328 L
.5264 .16778 L
.52643 .16946 L
.52646 .17128 L
.52649 .17286 L
.52651 .17336 L
.52652 .17378 L
.52655 .17457 L
.52658 .17529 L
.52661 .17564 L
.52664 .17581 L
.52667 .17598 L
.5267 .17646 L
.52672 .17717 L
.52675 .17794 L
.52678 .17922 L
.5268 .18099 L
.52682 .18294 L
.52685 .18642 L
.52687 .18948 L
.5269 .1881 L
.52693 .1868 L
.52696 .18543 L
.52699 .18833 L
.52701 .19317 L
.52704 .19839 L
.52707 .20225 L
.52709 .20119 L
.52715 .1986 L
.52719 .19751 L
.52722 .19639 L
.52724 .19586 L
.52725 .1953 L
.52728 .19999 L
.52732 .20547 L
.52734 .20835 L
.52735 .21129 L
.52737 .21181 L
.52739 .21238 L
Mistroke
.52742 .21338 L
.52748 .2162 L
.52751 .21789 L
.52754 .2197 L
.52757 .22215 L
.52759 .22457 L
.52762 .22719 L
.52765 .22824 L
.52768 .22683 L
.52771 .22553 L
.52774 .22508 L
.52775 .22865 L
.52777 .23257 L
.5278 .23949 L
.52783 .24578 L
.52786 .24399 L
.52788 .24211 L
.52792 .23995 L
.52794 .23892 L
.52797 .23852 L
.52799 .23809 L
.52802 .23766 L
.52805 .2406 L
.52808 .24377 L
.5281 .24552 L
.52811 .24716 L
.52813 .24834 L
.52815 .24927 L
.52818 .25109 L
.52825 .25407 L
.52828 .25517 L
.52829 .25575 L
.52831 .25676 L
.52834 .26254 L
.52837 .26794 L
.52839 .2736 L
.52842 .27638 L
.52844 .27712 L
.52846 .27782 L
.52849 .27919 L
.52852 .27979 L
.52855 .28012 L
.52866 .2893 L
.5287 .29259 L
.52871 .29276 L
.52873 .29295 L
.52876 .29328 L
.52879 .29353 L
.52882 .29322 L
.52885 .29292 L
Mistroke
.52887 .2926 L
.52891 .28885 L
.52893 .28468 L
.52896 .28025 L
.52899 .27981 L
.52901 .28455 L
.52904 .28984 L
.52907 .29466 L
.52909 .29535 L
.52911 .2961 L
.52914 .29742 L
.52925 .30288 L
.52952 .31577 L
.52978 .333 L
.5298 .33633 L
.52981 .3399 L
.52984 .34442 L
.52987 .34269 L
.52989 .34179 L
.52991 .3408 L
.52993 .3399 L
.52994 .34122 L
.52997 .34582 L
.53 .35026 L
.53003 .35403 L
.53005 .35282 L
.53008 .35151 L
.53011 .35006 L
.53014 .34979 L
.53016 .35037 L
.53019 .35101 L
.53022 .3515 L
.53025 .35135 L
.53028 .35118 L
.53031 .35104 L
.53034 .35768 L
.53037 .36487 L
.5304 .37271 L
.53042 .37435 L
.53043 .37321 L
.53049 .36932 L
.53052 .36746 L
.53056 .36551 L
.53059 .36366 L
.53062 .36444 L
.53064 .36682 L
.53067 .36945 L
.5307 .37287 L
.53073 .37909 L
.53076 .38593 L
Mistroke
.53078 .38966 L
.53079 .39279 L
.53082 .38753 L
.53085 .38177 L
.53087 .37854 L
.53088 .37548 L
.53091 .378 L
.53094 .38182 L
.53096 .38384 L
.53098 .38602 L
.53101 .3826 L
.53103 .37899 L
.53106 .37495 L
.53109 .3731 L
.53112 .37282 L
.53115 .37251 L
.53117 .37237 L
.5312 .37445 L
.53123 .37714 L
.53126 .37967 L
.53128 .37663 L
.53131 .36987 L
.53134 .36247 L
.53136 .35875 L
.53138 .35789 L
.53141 .35822 L
.53143 .35853 L
.53146 .35836 L
.53148 .35737 L
.5315 .35627 L
.53153 .35431 L
.53155 .35261 L
.53157 .35321 L
.53159 .35385 L
.53162 .35518 L
.53165 .35649 L
.53167 .35798 L
.53169 .35937 L
.53181 .36946 L
.53192 .38119 L
.53198 .38679 L
.532 .38967 L
.53203 .39236 L
.53206 .39165 L
.53209 .39088 L
.53211 .39017 L
.53214 .39123 L
.53217 .39434 L
.5322 .39773 L
.53222 .40041 L
Mistroke
.53225 .3962 L
.53231 .3861 L
.53237 .37355 L
.5324 .36655 L
.53243 .36132 L
.53246 .35709 L
.53249 .35245 L
.53251 .34999 L
.53252 .35186 L
.53256 .35608 L
.53258 .35797 L
.53259 .35997 L
.53262 .36198 L
.53265 .36289 L
.53268 .3639 L
.5327 .36442 L
.53272 .36282 L
.53275 .35945 L
.53278 .35623 L
.53281 .35016 L
.53283 .3412 L
.53286 .33141 L
.53289 .32175 L
.53292 .3185 L
.53295 .31555 L
.53298 .31243 L
.53301 .31014 L
.53303 .30865 L
.53306 .30703 L
.53308 .30611 L
.53309 .30444 L
.53315 .29812 L
.5332 .29253 L
.53331 .28272 L
.53334 .28114 L
.53337 .27956 L
.53339 .27939 L
.5334 .2792 L
.53343 .27887 L
.53346 .27855 L
.53349 .27889 L
.53352 .27918 L
.53355 .2795 L
.53357 .27894 L
.53358 .27784 L
.53361 .27565 L
.53367 .27077 L
.53381 .25919 L
.53391 .24269 L
.53394 .23665 L
Mistroke
.53397 .23351 L
.534 .23077 L
.53403 .22784 L
.53404 .22695 L
.53406 .2273 L
.53409 .22797 L
.53412 .22864 L
.53415 .22711 L
.53418 .22443 L
.53421 .22196 L
.53427 .21422 L
.53429 .21043 L
.53432 .20637 L
.53435 .20712 L
.53437 .20814 L
.5344 .20934 L
.53443 .2092 L
.53446 .20626 L
.53448 .20354 L
.5346 .19479 L
.53465 .19149 L
.53467 .19066 L
.53468 .18976 L
.53471 .18923 L
.53474 .19279 L
.53477 .1961 L
.5348 .19972 L
.53482 .1985 L
.53483 .19716 L
.53487 .19446 L
.53488 .19303 L
.5349 .1916 L
.53491 .19193 L
.53493 .19229 L
.53496 .19293 L
.53499 .19356 L
.53502 .19341 L
.53505 .19308 L
.53508 .19276 L
.5351 .19309 L
.53513 .19391 L
.53516 .1948 L
.53519 .19571 L
.53522 .1952 L
.53525 .19467 L
.53531 .19357 L
.53534 .19285 L
.53536 .19246 L
.53538 .19207 L
.53539 .19146 L
Mistroke
.53541 .1908 L
.53544 .18965 L
.53547 .18855 L
.5355 .18565 L
.53553 .18286 L
.53556 .1802 L
.53559 .17905 L
.53562 .1789 L
.53565 .17873 L
.53567 .1788 L
.53568 .18198 L
.53571 .18793 L
.53574 .19353 L
.53577 .19721 L
.53579 .19691 L
.53582 .19658 L
.53584 .19641 L
.53586 .19605 L
.53589 .1917 L
.53591 .18763 L
.53594 .18355 L
.53597 .18481 L
.53599 .18824 L
.53602 .19197 L
.53605 .19602 L
.53608 .19594 L
.5361 .19566 L
.53613 .19536 L
.53616 .19333 L
.53619 .18994 L
.53625 .18181 L
.53637 .16142 L
.53649 .13635 L
.53651 .1282 L
.53654 .12319 L
.53657 .12091 L
.53659 .11841 L
.53663 .1161 L
.53665 .11658 L
.53669 .11714 L
.53672 .1178 L
.53675 .11904 L
.53678 .12022 L
.53684 .12225 L
.53687 .12298 L
.53689 .12336 L
.53691 .12377 L
.53692 .12499 L
.53694 .12635 L
.53697 .12874 L
Mistroke
.537 .13102 L
.53702 .13102 L
.53704 .13102 L
.53707 .13102 L
.53709 .13102 L
.53712 .13314 L
.53715 .13567 L
.53721 .14134 L
.53733 .15444 L
.53735 .15866 L
.53739 .16304 L
.53742 .15984 L
.53744 .15692 L
.53751 .14813 L
.53754 .14282 L
.53757 .13801 L
.5376 .136 L
.53762 .13456 L
.53765 .13303 L
.53767 .13157 L
.5377 .13203 L
.53773 .13245 L
.53776 .13291 L
.53779 .13392 L
.53784 .13637 L
.53787 .13736 L
.5379 .13767 L
.53793 .13796 L
.53796 .13825 L
.53799 .1378 L
.53801 .13739 L
.53804 .13693 L
.53807 .13522 L
.5381 .1329 L
.53812 .13037 L
.53815 .12825 L
.53817 .13006 L
.53819 .13171 L
.53824 .13796 L
.5383 .14403 L
.53833 .14723 L
.53836 .14985 L
.53838 .15126 L
.53841 .15281 L
.53844 .15422 L
.53846 .15444 L
.53849 .1546 L
.53851 .15469 L
.53852 .15478 L
.53856 .15519 L
Mistroke
.53859 .15566 L
.53862 .15616 L
.53865 .15841 L
.53867 .16193 L
.5387 .16574 L
.53876 .17308 L
.5388 .17654 L
.53882 .17823 L
.53883 .17927 L
.53886 .18081 L
.53889 .18245 L
.53891 .18331 L
.53892 .1834 L
.53896 .1817 L
.53898 .18022 L
.53901 .17867 L
.53904 .18203 L
.53907 .18517 L
.5391 .18811 L
.53912 .18844 L
.53915 .18754 L
.53918 .18658 L
.5392 .18604 L
.53921 .18648 L
.53923 .1874 L
.53925 .18837 L
.53926 .18923 L
.53928 .19015 L
.53931 .19299 L
.53934 .19715 L
.53937 .20096 L
.53938 .20311 L
.5394 .20478 L
.53943 .20592 L
.53994 .23142 L
.54006 .25172 L
.5401 .25585 L
.54013 .26019 L
.54017 .26318 L
.54018 .26357 L
.5402 .26392 L
.54023 .26462 L
.54025 .26501 L
.54027 .26474 L
.5403 .26391 L
.54031 .26348 L
.54033 .26302 L
.54036 .26305 L
.54039 .26453 L
.54045 .26781 L
Mistroke
.5405 .2696 L
.54054 .27062 L
.54056 .27361 L
.54059 .27713 L
.54062 .28044 L
.54065 .28263 L
.54067 .2838 L
.5407 .28508 L
.54073 .28628 L
.54075 .28611 L
.54077 .28592 L
.5408 .28558 L
.54083 .28526 L
.54086 .28443 L
.54088 .28371 L
.54091 .28292 L
.54094 .28627 L
.54096 .28899 L
.54098 .29155 L
.541 .29611 L
.54103 .29813 L
.54105 .29804 L
.54107 .29795 L
.54109 .29785 L
.5411 .29775 L
.54112 .29783 L
.54114 .29808 L
.54117 .29857 L
.5412 .29907 L
.54123 .30189 L
.54126 .30678 L
.54127 .30928 L
.54129 .31196 L
.54132 .31457 L
.54135 .31515 L
.54138 .31583 L
.54141 .31631 L
.54143 .31615 L
.54146 .31599 L
.54148 .3159 L
.5415 .31589 L
.54153 .3175 L
.54155 .31895 L
.54158 .32047 L
.54161 .32539 L
.54164 .33126 L
.54169 .34125 L
.54174 .34929 L
.54177 .35391 L
.5418 .35632 L
Mistroke
.54183 .35798 L
.54186 .35955 L
.54188 .36053 L
.54191 .35876 L
.54197 .35557 L
.54202 .34986 L
.54204 .34821 L
.54206 .34646 L
.54209 .35036 L
.5421 .35468 L
.54212 .35876 L
.54215 .36638 L
.54218 .36802 L
.5422 .36647 L
.54222 .36504 L
.54233 .3536 L
.54236 .3515 L
.54239 .35136 L
.54242 .35119 L
.54245 .35104 L
.54247 .34822 L
.5425 .3451 L
.54252 .34175 L
.54255 .33853 L
.54258 .33809 L
.5426 .33768 L
.54263 .33724 L
.54266 .33614 L
.54269 .3345 L
.54272 .33277 L
.54275 .33089 L
.54278 .32815 L
.54281 .32545 L
.54284 .32304 L
.54285 .32295 L
.54287 .32285 L
.5429 .32268 L
.54293 .32233 L
.54295 .3217 L
.54297 .32112 L
.543 .31998 L
.54302 .31891 L
.54305 .31719 L
.54308 .31534 L
.54314 .31082 L
.54317 .30814 L
.54319 .3053 L
.54322 .30313 L
.54325 .3018 L
.54328 .30026 L
Mistroke
.5433 .29941 L
.54331 .29865 L
.54333 .29803 L
.54335 .29746 L
.54337 .29692 L
.54338 .29635 L
.5434 .29586 L
.54341 .29746 L
.54344 .30304 L
.54348 .30963 L
.54349 .31252 L
.54351 .31441 L
.54354 .3163 L
.54357 .31828 L
.54359 .31933 L
.5436 .3188 L
.54363 .31398 L
.54367 .30909 L
.5437 .30485 L
.54372 .30399 L
.54375 .30306 L
.54387 .29788 L
.54393 .29496 L
.544 .29177 L
.54402 .2898 L
.54405 .2877 L
.54407 .28649 L
.54409 .28723 L
.54412 .28937 L
.54414 .2913 L
.54417 .29281 L
.5442 .29145 L
.54423 .29021 L
.54426 .28881 L
.54428 .28671 L
.54431 .28384 L
.54434 .28122 L
.54437 .27951 L
.54439 .27942 L
.54441 .27933 L
.54444 .27917 L
.54447 .27635 L
.5445 .26957 L
.54452 .26601 L
.54454 .26228 L
.54455 .25899 L
.54457 .25932 L
.5446 .26013 L
.54461 .26057 L
.54463 .26103 L
Mistroke
.54466 .25958 L
.54468 .25718 L
.5447 .25492 L
.54473 .25068 L
.54479 .24274 L
.54482 .23823 L
.54484 .23531 L
.54486 .23582 L
.54488 .23638 L
.54491 .23736 L
.54494 .23792 L
.54497 .23668 L
.54499 .23549 L
.54502 .23421 L
.54504 .23627 L
.54506 .23897 L
.54509 .24426 L
.54512 .24941 L
.54513 .24931 L
.54515 .24728 L
.54522 .23879 L
.54524 .23595 L
.54527 .23303 L
.5453 .23028 L
.54533 .22935 L
.54535 .23038 L
.54538 .23151 L
.5454 .23269 L
.54543 .22788 L
.54546 .22029 L
.54549 .212 L
.54551 .20655 L
.54554 .20837 L
.54557 .21048 L
.54559 .21163 L
.5456 .21272 L
.54563 .20817 L
.54566 .20379 L
.54569 .19924 L
.54572 .19679 L
.54574 .19603 L
.54577 .19533 L
.54583 .19361 L
.54586 .19285 L
.54589 .1919 L
.54592 .18999 L
.54595 .18796 L
.54597 .1869 L
.54599 .18625 L
.54601 .18897 L
Mistroke
.54602 .19146 L
.54605 .1964 L
.54608 .20099 L
.54611 .20084 L
.54612 .2005 L
.54614 .20014 L
.54659 .1888 L
.54662 .18541 L
.54664 .18219 L
.54666 .1807 L
.54668 .18061 L
.54671 .18045 L
.54673 .1803 L
.54676 .1795 L
.54679 .17781 L
.54682 .17628 L
.54685 .17456 L
.54688 .17368 L
.54691 .17294 L
.54694 .17213 L
.54695 .17215 L
.54697 .17258 L
.547 .17351 L
.54706 .17491 L
.5471 .17548 L
.54712 .17576 L
.54713 .17601 L
.54716 .17782 L
.54719 .17992 L
.54721 .18092 L
.54723 .18201 L
.54725 .18258 L
.54726 .18295 L
.54733 .18447 L
.54737 .18498 L
.54738 .18525 L
.5474 .18554 L
.54742 .18582 L
.54743 .18393 L
.54746 .17849 L
.54749 .17325 L
.54751 .17049 L
.54753 .16896 L
.54756 .16961 L
.54758 .17021 L
.54761 .17087 L
.54764 .17057 L
.54767 .17028 L
.5477 .16998 L
.54773 .16994 L
Mistroke
.54776 .17009 L
.54779 .17025 L
.5478 .17035 L
.54782 .17117 L
.54785 .17278 L
.54788 .17448 L
.5479 .17593 L
.54793 .18 L
.54799 .18954 L
.54804 .19695 L
.54807 .20089 L
.54809 .20311 L
.54811 .2019 L
.54814 .19845 L
.54817 .1948 L
.54823 .18875 L
.54825 .18732 L
.54827 .18579 L
.54829 .18434 L
.5483 .18434 L
.54833 .18434 L
.54836 .18434 L
.54839 .18402 L
.54841 .18354 L
.54843 .18311 L
.54845 .18231 L
.54849 .18122 L
.54852 .17976 L
.54854 .17842 L
.54857 .1771 L
.5486 .17725 L
.54863 .17743 L
.54866 .17758 L
.54869 .17784 L
.54872 .17813 L
.54874 .17843 L
.54877 .18037 L
.5488 .18532 L
.54883 .19053 L
.54885 .19326 L
.54887 .19301 L
.54889 .19147 L
.5489 .19005 L
.54893 .18721 L
.54896 .18749 L
.54898 .1916 L
.54899 .19605 L
.54902 .20412 L
.54906 .21113 L
.54908 .21289 L
Mistroke
.5491 .21396 L
.54912 .21498 L
.54913 .21589 L
.54915 .2161 L
.54917 .21539 L
.54919 .21463 L
.54922 .21326 L
.54923 .21252 L
.54925 .21288 L
.54927 .21384 L
.54929 .21488 L
.54932 .21647 L
.54933 .21737 L
.54935 .21665 L
.54938 .21462 L
.54941 .21277 L
.54944 .21013 L
.54947 .20642 L
.5495 .2025 L
.54953 .19874 L
.54956 .19809 L
.54959 .1975 L
.54961 .19689 L
.54964 .1959 L
.54967 .1946 L
.5497 .19318 L
.54973 .19141 L
.54976 .18908 L
.54979 .18665 L
.54981 .18542 L
.54983 .18605 L
.54986 .18718 L
.54988 .18778 L
.54989 .18843 L
.54992 .18797 L
.54995 .18603 L
.54998 .1838 L
.55001 .1831 L
.55004 .18637 L
.55007 .18985 L
.55009 .19285 L
.55012 .19443 L
.55015 .19553 L
.55018 .19657 L
.55019 .19717 L
.55021 .19728 L
.55024 .19728 L
.55026 .19728 L
.55029 .19725 L
.55032 .19669 L
Mistroke
.55034 .19618 L
.55037 .19558 L
.5504 .19542 L
.55043 .19588 L
.55045 .19631 L
.55048 .19684 L
.55051 .19777 L
.55054 .19861 L
.55057 .19952 L
.5506 .19831 L
.55062 .19604 L
.55069 .18925 L
.55071 .18371 L
.55074 .17772 L
.55077 .17324 L
.5508 .17237 L
.55083 .17153 L
.55085 .17074 L
.55088 .17125 L
.5509 .17305 L
.55093 .17505 L
.55095 .17611 L
.55097 .17668 L
.551 .17703 L
.55103 .17734 L
.55106 .17749 L
.55108 .17663 L
.55114 .17468 L
.55121 .17265 L
.55124 .17164 L
.55127 .17105 L
.5513 .17051 L
.55132 .1702 L
.55134 .16992 L
.55137 .16998 L
.55138 .17008 L
.5514 .17016 L
.55143 .17031 L
.55146 .1716 L
.55148 .17314 L
.55151 .17481 L
.55153 .17583 L
.55154 .17788 L
.55158 .18262 L
.55161 .1872 L
.55163 .19096 L
.55166 .19274 L
.55169 .19466 L
.55175 .20009 L
.55181 .20671 L
Mistroke
.55185 .21067 L
.55188 .21496 L
.55191 .21877 L
.55194 .21874 L
.55197 .21844 L
.55199 .21816 L
.55202 .21725 L
.55205 .21577 L
.55208 .21414 L
.55211 .21378 L
.55214 .2172 L
.55217 .22087 L
.55219 .22434 L
.55221 .22477 L
.55224 .22271 L
.55227 .22046 L
.5523 .21861 L
.55233 .21988 L
.55236 .22138 L
.55238 .22278 L
.55241 .22328 L
.55243 .22337 L
.55245 .22346 L
.55247 .22356 L
.55248 .22365 L
.5525 .22513 L
.55252 .22736 L
.55255 .23128 L
.55256 .23337 L
.55258 .23561 L
.55261 .23595 L
.55264 .2358 L
.55266 .23571 L
.55267 .23561 L
.5527 .23789 L
.55273 .24032 L
.55276 .24291 L
.55279 .24333 L
.55282 .24129 L
.55285 .2393 L
.55288 .23793 L
.55289 .23861 L
.55291 .23935 L
.55294 .24066 L
.55297 .24202 L
.553 .24533 L
.55303 .24843 L
.55305 .2513 L
.55308 .25299 L
.55311 .25428 L
Mistroke
.55314 .25542 L
.55316 .25554 L
.55319 .25286 L
.55322 .25034 L
.55327 .24541 L
.55339 .23021 L
.5535 .21423 L
.55353 .21025 L
.55356 .20789 L
.55359 .2058 L
.55362 .2039 L
.55364 .20309 L
.55365 .20444 L
.55368 .20687 L
.5537 .20833 L
.55372 .20973 L
.55373 .21084 L
.55375 .21138 L
.5538 .21309 L
.55383 .21384 L
.55386 .21384 L
.55388 .21384 L
.55391 .21384 L
.55394 .21475 L
.55396 .21625 L
.55399 .21803 L
.55402 .21944 L
.55403 .21893 L
.55405 .21838 L
.55408 .21742 L
.55411 .2165 L
.55414 .22172 L
.55417 .22701 L
.55419 .23198 L
.55422 .23331 L
.55425 .23047 L
.55431 .22437 L
.55443 .21411 L
.55468 .19627 L
.55479 .18677 L
.55485 .18076 L
.55488 .17798 L
.55491 .17665 L
.55493 .1755 L
.55496 .17426 L
.55498 .17503 L
.55501 .17873 L
.55504 .18281 L
.55507 .18713 L
.55509 .18568 L
Mistroke
.55512 .18357 L
.55518 .17927 L
.55521 .17738 L
.55523 .17635 L
.55525 .17537 L
.55526 .17461 L
.55528 .17652 L
.55531 .17986 L
.55533 .18296 L
.55536 .18495 L
.55539 .18352 L
.55542 .18218 L
.55545 .18077 L
.55548 .17575 L
.55551 .17095 L
.55554 .1664 L
.55556 .168 L
.55559 .1743 L
.55562 .1812 L
.55565 .18696 L
.55567 .18522 L
.55568 .18362 L
.5557 .182 L
.55571 .18049 L
.55575 .17859 L
.55576 .17966 L
.55578 .18081 L
.55585 .18497 L
.55609 .20276 L
.55612 .20629 L
.55614 .2069 L
.55615 .20724 L
.55618 .20784 L
.55621 .2085 L
.55624 .21067 L
.55627 .21322 L
.55629 .21467 L
.5563 .2162 L
.55632 .21702 L
.55634 .2172 L
.55637 .21758 L
.55639 .21777 L
.55641 .21798 L
.55642 .21745 L
.55644 .21686 L
.55647 .21581 L
.55649 .21527 L
.55651 .21501 L
.55652 .21569 L
.55654 .21631 L
Mistroke
.5566 .21846 L
.55684 .22885 L
.55685 .2306 L
.55687 .23251 L
.5569 .23407 L
.55692 .23339 L
.55693 .23275 L
.55695 .23212 L
.55697 .23153 L
.557 .23294 L
.55702 .23674 L
.55705 .24084 L
.55707 .24315 L
.55709 .24264 L
.55711 .2394 L
.55714 .23639 L
.55717 .23308 L
.5572 .23181 L
.55723 .23096 L
.55726 .23015 L
.55729 .23044 L
.55731 .23139 L
.55733 .23189 L
.55735 .23244 L
.55738 .233 L
.55739 .233 L
.55741 .233 L
.55743 .233 L
.55744 .233 L
.55747 .23126 L
.5575 .22711 L
.55752 .225 L
.55753 .22276 L
.55756 .22016 L
.5576 .2205 L
.55761 .22069 L
.55763 .22087 L
.55766 .22155 L
.55768 .22231 L
.55769 .22313 L
.55772 .22464 L
.55775 .22564 L
.55778 .22521 L
.55781 .22474 L
.55783 .22445 L
.55784 .22405 L
.55787 .22019 L
.55789 .21799 L
.55791 .21567 L
.55793 .2137 L
Mistroke
.55794 .21286 L
.55798 .21574 L
.558 .21843 L
.55804 .22156 L
.55805 .22459 L
.55807 .22735 L
.5581 .23191 L
.55812 .23683 L
.55816 .23924 L
.55819 .24099 L
.5582 .24193 L
.55822 .24295 L
.55825 .24255 L
.55828 .24156 L
.55831 .24064 L
.55834 .23728 L
.55836 .2324 L
.55839 .22797 L
.55842 .22329 L
.55844 .22271 L
.55847 .22228 L
.5585 .22183 L
.55853 .2174 L
.55856 .21009 L
.55858 .20624 L
.55859 .20215 L
.55862 .20065 L
.55865 .20365 L
.55872 .21109 L
.55879 .21835 L
.55885 .23003 L
.55886 .23336 L
.55888 .23693 L
.55891 .23888 L
.55894 .23841 L
.55897 .23798 L
.559 .23801 L
.55903 .23895 L
.55906 .23983 L
.55908 .24075 L
.55911 .23852 L
.55914 .23604 L
.55925 .22685 L
.55931 .22199 L
.55933 .2206 L
.55935 .21909 L
.55938 .21744 L
.55939 .21853 L
.55941 .21969 L
.55944 .22177 L
Mistroke
.5595 .2254 L
.55955 .22878 L
.55958 .23099 L
.55961 .23356 L
.55964 .23581 L
.55967 .24018 L
.5597 .24618 L
.55973 .25178 L
.55975 .25766 L
.55978 .26012 L
.55983 .26454 L
.55988 .26805 L
.55991 .26948 L
.55993 .2708 L
.55996 .26789 L
.55999 .26211 L
.56005 .25067 L
.5601 .24358 L
.56013 .23956 L
.56016 .24151 L
.56019 .24452 L
.56022 .24735 L
.56025 .2459 L
.56028 .24283 L
.56034 .23677 L
.56041 .23092 L
.56047 .22559 L
.56049 .22405 L
.56051 .2226 L
.56054 .2227 L
.56056 .22364 L
.56057 .22451 L
.56059 .22545 L
.56061 .22648 L
.56064 .22452 L
.56067 .2216 L
.5607 .21888 L
.56073 .21968 L
.56076 .22119 L
.5608 .22278 L
.56085 .22551 L
.56089 .22706 L
.56092 .2266 L
.56095 .22396 L
.56098 .22116 L
.56101 .2192 L
.56104 .21805 L
.56107 .2168 L
.56109 .21611 L
.5611 .21731 L
Mistroke
.56112 .21916 L
.56114 .22118 L
.56117 .22487 L
.5612 .22629 L
.56123 .22367 L
.56129 .21796 L
.56132 .21596 L
.56135 .2138 L
.56138 .21179 L
.56141 .21512 L
.56143 .21834 L
.56146 .2218 L
.56149 .22356 L
.56151 .2233 L
.56154 .22299 L
.56157 .22266 L
.56159 .22251 L
.56162 .22236 L
.56168 .22205 L
.56171 .22189 L
.56172 .22181 L
.56174 .22172 L
.56177 .22292 L
.5618 .2265 L
.56183 .23015 L
.56185 .23352 L
.56188 .23264 L
.5619 .23179 L
.56191 .23089 L
.56197 .22773 L
.562 .22637 L
.56202 .22492 L
.56205 .22253 L
.56208 .21775 L
.56211 .21231 L
.56213 .20943 L
.56215 .20709 L
.56216 .207 L
.56218 .20692 L
.56221 .20675 L
.56224 .2066 L
.56227 .20829 L
.5623 .20989 L
.56233 .21137 L
.56235 .21227 L
.56238 .21302 L
.56241 .21385 L
.56244 .2136 L
.56247 .21107 L
.5625 .20833 L
Mistroke
.56256 .20167 L
.56258 .1978 L
.56261 .19417 L
.56264 .19578 L
.56267 .2017 L
.56269 .20646 L
.56272 .21146 L
.56274 .20883 L
.56277 .20596 L
.5628 .20257 L
.56281 .20128 L
.56283 .20404 L
.56286 .20902 L
.56289 .21449 L
.56292 .21643 L
.56294 .21141 L
.56297 .20614 L
.563 .20041 L
.56303 .19693 L
.56306 .19416 L
.56312 .18924 L
.56318 .18465 L
.56321 .18185 L
.56324 .17832 L
.56327 .17527 L
.5633 .17458 L
.56333 .17757 L
.56335 .18072 L
.56342 .18834 L
.56345 .19239 L
.56347 .19607 L
.5635 .19693 L
.56352 .19641 L
.56355 .19586 L
.56357 .19528 L
.5636 .19429 L
.56363 .19332 L
.56366 .19219 L
.56368 .19075 L
.56371 .18871 L
.56375 .18649 L
.5638 .18167 L
.56383 .17918 L
.56386 .17684 L
.56388 .18023 L
.56391 .18556 L
.56394 .19151 L
.56397 .19458 L
.564 .19327 L
.56403 .19184 L
Mistroke
.56409 .18818 L
.56412 .18646 L
.56415 .18478 L
.56418 .18431 L
.56421 .18386 L
.56426 .18279 L
.56429 .18206 L
.56432 .18127 L
.56434 .18082 L
.56435 .18078 L
.56438 .18094 L
.56441 .18108 L
.56443 .18121 L
.56446 .18701 L
.56448 .19447 L
.56451 .20184 L
.56454 .20698 L
.56457 .20635 L
.56459 .20577 L
.56465 .2044 L
.56468 .20344 L
.56471 .20252 L
.56472 .20201 L
.56474 .20317 L
.56477 .20562 L
.5648 .20812 L
.56483 .20784 L
.56484 .20462 L
.56486 .20115 L
.56489 .19485 L
.56495 .18473 L
.56498 .17964 L
.565 .17685 L
.56501 .17507 L
.56504 .17539 L
.56508 .17574 L
.5651 .17604 L
.56513 .18127 L
.56516 .18615 L
.56519 .19133 L
.56521 .19421 L
.56524 .19542 L
.56527 .19651 L
.56529 .19755 L
.56532 .20014 L
.56535 .20281 L
.56541 .20796 L
.56552 .2173 L
.56555 .22233 L
.56558 .22703 L
Mistroke
.56561 .22875 L
.56562 .22933 L
.56564 .22996 L
.56566 .23064 L
.56567 .23128 L
.56569 .23156 L
.5657 .23174 L
.56573 .23206 L
.56575 .23223 L
.56577 .23241 L
.5658 .23417 L
.56583 .23618 L
.56584 .2373 L
.56586 .23848 L
.56589 .24347 L
.56594 .25525 L
.56597 .26016 L
.566 .2609 L
.56603 .26162 L
.56606 .26241 L
.56608 .26289 L
.56611 .2633 L
.56613 .26371 L
.56616 .26406 L
.56618 .26406 L
.56621 .26406 L
.56624 .26406 L
.56627 .26755 L
.56629 .27314 L
.56632 .27923 L
.56635 .28495 L
.56638 .28067 L
.56641 .27693 L
.56644 .27298 L
.56645 .27274 L
.56647 .27337 L
.5665 .27449 L
.56651 .27512 L
.56653 .27579 L
.56655 .2741 L
.56656 .27179 L
.56659 .26757 L
.56662 .26308 L
.56664 .26123 L
.56665 .2604 L
.56668 .25893 L
.56671 .25753 L
.56674 .25811 L
.56677 .26047 L
.5668 .26264 L
Mistroke
.56682 .26459 L
.56685 .26489 L
.56688 .26518 L
.56691 .2655 L
.56693 .26626 L
.56694 .26766 L
.56697 .27044 L
.56704 .27639 L
.56717 .28805 L
.5672 .28917 L
.56723 .29227 L
.56726 .2956 L
.56729 .29876 L
.56732 .29789 L
.56735 .29404 L
.56741 .28718 L
.56747 .28656 L
.5675 .28619 L
.56753 .28567 L
.56756 .28522 L
.56759 .28441 L
.56762 .28056 L
.56764 .27698 L
.56767 .27288 L
.5677 .27172 L
.56773 .27257 L
.56776 .27336 L
.56778 .27379 L
.56779 .27104 L
.56782 .26441 L
.56786 .25659 L
.56787 .25317 L
.56789 .25117 L
.56792 .24841 L
.56794 .24578 L
.56797 .24284 L
.568 .24328 L
.56802 .24369 L
.56805 .24408 L
.56808 .24476 L
.5681 .24585 L
.56821 .25259 L
.56833 .26117 L
.56856 .27663 L
.56859 .27593 L
.56862 .27527 L
.56864 .2751 L
.56866 .27798 L
.56869 .28301 L
.56872 .28782 L
Mistroke
.56874 .28967 L
.56875 .28737 L
.56878 .28359 L
.56881 .27947 L
.56883 .27722 L
.56884 .27685 L
.56886 .27667 L
.56888 .27648 L
.56891 .27614 L
.56894 .27635 L
.56895 .27692 L
.56897 .27744 L
.56899 .278 L
.56901 .27862 L
.56902 .27885 L
.56904 .27759 L
.56907 .27484 L
.5692 .26585 L
.56926 .2621 L
.56932 .25841 L
.56935 .25584 L
.56938 .25306 L
.56939 .25154 L
.56941 .25103 L
.56944 .25363 L
.5695 .25906 L
.56953 .26228 L
.56957 .26573 L
.5696 .2681 L
.56963 .26763 L
.56966 .26716 L
.56968 .26673 L
.56971 .26893 L
.56975 .27194 L
.56981 .27705 L
.56983 .27898 L
.56986 .28107 L
.56988 .2824 L
.56991 .28085 L
.56994 .27899 L
.56997 .27702 L
.57 .27385 L
.57002 .27049 L
.57008 .26286 L
.57014 .25154 L
.5702 .23777 L
.57022 .22966 L
.57025 .22226 L
.57028 .21817 L
.57031 .21661 L
Mistroke
.57037 .21247 L
.5704 .20858 L
.57043 .20444 L
.57044 .20229 L
.57046 .20142 L
.57049 .2036 L
.57052 .20559 L
.57055 .20763 L
.57058 .20763 L
.5706 .20763 L
.57063 .20763 L
.57066 .20881 L
.57069 .2113 L
.57071 .21361 L
.57078 .22007 L
.57081 .22352 L
.57084 .22622 L
.57087 .22593 L
.57089 .22562 L
.57092 .22531 L
.57095 .22549 L
.57097 .22568 L
.57099 .22586 L
.57102 .22619 L
.57104 .22654 L
.57105 .22697 L
.57109 .22795 L
.57112 .22881 L
.57115 .22798 L
.57121 .22588 L
.57127 .21321 L
.57129 .20966 L
.57131 .20581 L
.57134 .20214 L
.5714 .19645 L
.57146 .19153 L
.57149 .18883 L
.5715 .18748 L
.57152 .18735 L
.57155 .18719 L
.57158 .18703 L
.5716 .18694 L
.57161 .18715 L
.57165 .18774 L
.57168 .18825 L
.5717 .18838 L
.57171 .18794 L
.57174 .18716 L
.57177 .18631 L
.5718 .18796 L
Mistroke
.57183 .19194 L
.57186 .19585 L
.57188 .1995 L
.57191 .19835 L
.57194 .1965 L
.57206 .18857 L
.57212 .1849 L
.57215 .18317 L
.57218 .18171 L
.5722 .18125 L
.57223 .18083 L
.57226 .18038 L
.57229 .18357 L
.57232 .18905 L
.57235 .19417 L
.57238 .19647 L
.57239 .19544 L
.57241 .19434 L
.57244 .19239 L
.57247 .18959 L
.57249 .18492 L
.57252 .17985 L
.57257 .17093 L
.57262 .16397 L
.57265 .16005 L
.57268 .16194 L
.57271 .16391 L
.57273 .16496 L
.57274 .16607 L
.57276 .16874 L
.57278 .17143 L
.57281 .17674 L
.57287 .18739 L
.5729 .1929 L
.57292 .1958 L
.57293 .19887 L
.57297 .20041 L
.57299 .20148 L
.5731 .2064 L
.57316 .21116 L
.57319 .21453 L
.57322 .21811 L
.57325 .2185 L
.57328 .2185 L
.5733 .2185 L
.57333 .21825 L
.57335 .21791 L
.57336 .21755 L
.57339 .21691 L
.57342 .21664 L
Mistroke
.57344 .21702 L
.57346 .21738 L
.57349 .21801 L
.57351 .21802 L
.57355 .21432 L
.57357 .21084 L
.57363 .20518 L
.57366 .20265 L
.57368 .20028 L
.57371 .19883 L
.57373 .19883 L
.57376 .19883 L
.57379 .19883 L
.57382 .20064 L
.57383 .20215 L
.57385 .20377 L
.57388 .20675 L
.57391 .20713 L
.57393 .20507 L
.57396 .20285 L
.57399 .20089 L
.57402 .20075 L
.57405 .20059 L
.57407 .20043 L
.5741 .20233 L
.57413 .20554 L
.57416 .20902 L
.57417 .21078 L
.57419 .21133 L
.57422 .21149 L
.57425 .21164 L
.57428 .21163 L
.5743 .21011 L
.57433 .20879 L
.57435 .20739 L
.57438 .20521 L
.57441 .20251 L
.57444 .19955 L
.57447 .19708 L
.57448 .19855 L
.5745 .20017 L
.57453 .20302 L
.57455 .20463 L
.57457 .20542 L
.57459 .20514 L
.5746 .20488 L
.57463 .20437 L
.57465 .20409 L
.57467 .20597 L
.5747 .21114 L
Mistroke
.57473 .21664 L
.57478 .22534 L
.57481 .22965 L
.57484 .2342 L
.57486 .23523 L
.57487 .23552 L
.5749 .23601 L
.57494 .23652 L
.57496 .2365 L
.575 .23633 L
.57501 .23624 L
.57503 .23616 L
.57506 .23947 L
.57509 .24526 L
.57522 .26473 L
.57534 .28599 L
.5754 .29484 L
.57546 .30181 L
.57548 .30421 L
.57551 .30677 L
.57554 .30716 L
.57557 .30729 L
.57559 .30743 L
.57562 .30768 L
.57565 .30811 L
.57567 .3085 L
.5757 .30895 L
.57572 .31062 L
.57576 .31329 L
.57578 .31573 L
.57581 .31743 L
.57584 .31758 L
.57587 .31774 L
.57589 .31783 L
.5759 .31865 L
.57593 .3234 L
.57596 .32839 L
.57599 .33271 L
.57601 .33579 L
.57604 .33852 L
.57607 .34106 L
.57613 .3466 L
.57624 .35653 L
.57627 .35947 L
.5763 .36131 L
.57632 .36201 L
.57635 .36278 L
.57637 .36325 L
.57638 .36167 L
.5764 .35789 L
Mistroke
.57642 .3543 L
.57644 .35096 L
.57645 .3474 L
.57648 .34348 L
.57652 .3428 L
.57654 .34218 L
.57656 .34182 L
.57658 .34118 L
.57661 .3398 L
.57664 .33856 L
.57667 .33814 L
.57669 .33926 L
.5767 .34044 L
.57673 .34258 L
.57679 .34561 L
.57685 .34766 L
.57687 .34947 L
.57691 .35165 L
.57694 .35371 L
.57696 .3534 L
.57699 .35066 L
.57702 .34805 L
.57705 .34653 L
.57707 .34832 L
.57708 .34999 L
.57711 .35295 L
.57714 .35555 L
.57717 .34972 L
.57719 .34342 L
.57722 .33654 L
.57725 .33224 L
.57728 .33111 L
.57731 .32987 L
.57732 .32917 L
.57734 .32789 L
.57737 .32447 L
.5774 .32142 L
.57743 .31843 L
.57745 .31852 L
.57746 .31861 L
.57748 .31871 L
.5775 .3188 L
.57753 .32014 L
.57755 .32252 L
.57756 .32503 L
.57759 .32926 L
.57762 .33239 L
.57765 .32988 L
.57768 .3276 L
.5778 .31817 L
Mistroke
.57793 .31301 L
.57805 .30678 L
.57808 .30497 L
.57811 .30285 L
.57814 .29965 L
.57817 .29673 L
.57824 .28951 L
.57825 .28748 L
.57827 .28529 L
.57829 .28321 L
.5783 .28338 L
.57833 .2837 L
.57836 .28404 L
.57839 .28348 L
.57842 .28025 L
.57845 .27701 L
.57847 .27395 L
.5785 .27254 L
.57852 .2714 L
.57858 .26885 L
.57862 .26767 L
.57865 .26642 L
.57868 .26565 L
.57871 .26582 L
.57874 .26597 L
.57877 .26612 L
.57879 .26741 L
.57882 .2689 L
.57885 .27035 L
.57888 .2698 L
.57891 .26852 L
.57894 .26732 L
.57899 .26467 L
.57902 .26305 L
.57906 .2609 L
.57908 .25457 L
.57911 .24761 L
.57918 .23142 L
.57921 .22409 L
.57923 .22022 L
.57924 .2161 L
.57927 .21365 L
.5793 .21185 L
.57933 .21016 L
.57935 .2071 L
.57938 .2025 L
.57941 .19817 L
.57947 .18811 L
.57958 .1744 L
.57969 .15973 L
Mistroke
.5797 .15724 L
.57972 .15454 L
.57975 .15338 L
.57978 .15251 L
.57981 .15155 L
.57984 .14951 L
.57987 .14662 L
.57992 .14176 L
.57995 .14089 L
.57997 .14043 L
.57999 .13993 L
.58 .13946 L
.58002 .13753 L
.58005 .13204 L
.58008 .12675 L
.58009 .12396 L
.58011 .12175 L
.58014 .1196 L
.58017 .11763 L
.5802 .11557 L
.58023 .11873 L
.58026 .12248 L
.5803 .1258 L
.58031 .12423 L
.58033 .12252 L
.58036 .11942 L
.58038 .1177 L
.5804 .11686 L
.58041 .11764 L
.58043 .1185 L
.58068 .12738 L
.58079 .12402 L
.58082 .12146 L
.58085 .11905 L
.58088 .11823 L
.5809 .12056 L
.58096 .1253 L
.58102 .13237 L
.58105 .13629 L
.58106 .13795 L
.58108 .1388 L
.58111 .14029 L
.58114 .14171 L
.58116 .14226 L
.58118 .14091 L
.58121 .13854 L
.58122 .1372 L
.58124 .13578 L
.58126 .13537 L
.58128 .13571 L
Mistroke
.58131 .13639 L
.58132 .13675 L
.58134 .13713 L
.58136 .13773 L
.58137 .13855 L
.5814 .13998 L
.58152 .14476 L
.58158 .14639 L
.58159 .14674 L
.58161 .14711 L
.58164 .14843 L
.58167 .15131 L
.58169 .15293 L
.58171 .15447 L
.58174 .15615 L
.58177 .15552 L
.5818 .15493 L
.58183 .15409 L
.58184 .15106 L
.58186 .14831 L
.58189 .14293 L
.58192 .13778 L
.58194 .13723 L
.58197 .13723 L
.582 .13723 L
.58203 .13618 L
.58206 .13415 L
.58208 .13174 L
.58211 .12952 L
.58214 .13079 L
.58218 .13225 L
.58221 .13355 L
.58222 .13264 L
.58224 .13146 L
.58227 .12943 L
.5823 .12724 L
.58233 .1274 L
.58235 .12798 L
.58239 .12866 L
.58241 .13072 L
.58243 .13262 L
.58245 .13436 L
.58248 .13825 L
.58251 .14148 L
.58255 .14459 L
.58257 .14601 L
.58258 .14752 L
.58261 .14532 L
.58264 .14202 L
.58268 .13841 L
Mistroke
.58271 .13787 L
.58273 .13877 L
.58276 .13965 L
.58279 .14036 L
.58281 .14052 L
.58284 .14066 L
.58287 .14082 L
.5829 .14256 L
.58293 .14447 L
.58296 .14651 L
.58299 .14983 L
.58302 .15394 L
.58304 .15645 L
.58305 .15883 L
.58308 .16019 L
.58313 .15754 L
.58316 .1562 L
.58319 .16048 L
.58321 .167 L
.58324 .17306 L
.58327 .17709 L
.58329 .17709 L
.58331 .17709 L
.58333 .17709 L
.58336 .17715 L
.58339 .17939 L
.58341 .18146 L
.58344 .18359 L
.58347 .1846 L
.58349 .18505 L
.58352 .18554 L
.58355 .18548 L
.58358 .18409 L
.58361 .18282 L
.58364 .18148 L
.58367 .18231 L
.58369 .18351 L
.58371 .1842 L
.58373 .18493 L
.58376 .18548 L
.58377 .18556 L
.58379 .18566 L
.58381 .18575 L
.58382 .18584 L
.58384 .18467 L
.58386 .18241 L
.58389 .17797 L
.58391 .17373 L
.58395 .17233 L
.58398 .17297 L
Mistroke
.584 .17356 L
.58403 .17486 L
.58406 .17887 L
.58408 .18234 L
.58411 .18612 L
.58414 .1873 L
.58416 .18621 L
.58419 .18517 L
.58422 .18384 L
.58425 .18026 L
.58428 .17702 L
.58431 .17322 L
.58434 .17164 L
.58439 .16907 L
.58445 .16585 L
.58448 .16405 L
.5845 .16285 L
.58453 .16438 L
.58456 .16606 L
.58459 .16787 L
.5846 .16843 L
.58462 .1687 L
.58468 .16965 L
.58473 .17099 L
.58476 .17176 L
.58479 .17218 L
.58482 .17089 L
.58485 .16949 L
.5849 .16602 L
.58493 .16253 L
.58494 .1607 L
.58496 .15875 L
.58499 .15748 L
.58502 .15858 L
.58506 .15983 L
.58507 .16049 L
.58509 .15915 L
.58512 .15668 L
.58516 .15433 L
.58518 .15498 L
.58522 .15856 L
.58524 .16184 L
.58527 .16393 L
.5853 .16274 L
.58532 .16214 L
.58533 .16148 L
.58537 .16121 L
.58539 .16482 L
.58551 .17584 L
.58557 .17961 L
Mistroke
.5856 .18188 L
.58562 .18397 L
.58565 .18534 L
.58567 .18403 L
.58569 .18265 L
.58574 .17786 L
.58581 .17005 L
.58582 .16791 L
.58584 .16605 L
.58586 .16547 L
.58587 .16484 L
.58591 .16367 L
.58592 .16302 L
.58594 .16265 L
.58597 .16299 L
.586 .1633 L
.58603 .16361 L
.58605 .16541 L
.58611 .16969 L
.58624 .17777 L
.58628 .18326 L
.58629 .18616 L
.58631 .18924 L
.58633 .18959 L
.58635 .18969 L
.58638 .18987 L
.58641 .19003 L
.58643 .19031 L
.58644 .19057 L
.58647 .19102 L
.5865 .19153 L
.58653 .19358 L
.58656 .19571 L
.58661 .20044 L
.58664 .2029 L
.58667 .20523 L
.58669 .20732 L
.58672 .20604 L
.58675 .20403 L
.58678 .2019 L
.5868 .20242 L
.58683 .20611 L
.58685 .20817 L
.58687 .21042 L
.5869 .21298 L
.58693 .21183 L
.58696 .21076 L
.58709 .20551 L
.58712 .20534 L
.58715 .20518 L
Mistroke
.58718 .20467 L
.5872 .20336 L
.58721 .20196 L
.58724 .19967 L
.58727 .19723 L
.5873 .19598 L
.58733 .19483 L
.58736 .1935 L
.58737 .19314 L
.58739 .19314 L
.58742 .19314 L
.58745 .19314 L
.58747 .19333 L
.58748 .1946 L
.58752 .19727 L
.58755 .19958 L
.58757 .20028 L
.58758 .20001 L
.58761 .19951 L
.58764 .19903 L
.58767 .19782 L
.5877 .19582 L
.58773 .19364 L
.58774 .19254 L
.58776 .1939 L
.58779 .19888 L
.58782 .20355 L
.58785 .20779 L
.58788 .20959 L
.58793 .21286 L
.58804 .21952 L
.58827 .23037 L
.5883 .23541 L
.58833 .2402 L
.58835 .24155 L
.58836 .24303 L
.58838 .24438 L
.5884 .24562 L
.58843 .24691 L
.58844 .24557 L
.58846 .24429 L
.58849 .242 L
.58852 .23998 L
.58854 .2436 L
.58857 .2476 L
.58863 .25314 L
.58874 .26507 L
.58901 .28489 L
.58903 .28521 L
.58906 .2855 L
Mistroke
.58909 .28644 L
.58912 .29136 L
.58915 .2968 L
.58917 .29966 L
.58919 .30248 L
.58922 .30454 L
.58925 .30643 L
.58949 .31743 L
.58971 .32768 L
.58977 .3321 L
.58983 .33515 L
.58989 .33781 L
.58995 .33976 L
.58998 .34113 L
.59002 .34259 L
.59003 .34335 L
.59005 .3431 L
.59007 .34187 L
.59009 .34071 L
.59012 .33861 L
.59015 .33685 L
.59016 .33649 L
.59018 .3361 L
.59021 .33542 L
.59025 .33522 L
.59027 .33585 L
.59031 .33653 L
.59032 .33692 L
.59034 .33788 L
.59037 .34019 L
.5904 .3423 L
.59043 .34381 L
.59045 .34159 L
.59046 .33948 L
.59049 .33582 L
.59052 .33192 L
.59054 .33629 L
.59057 .34159 L
.5906 .34785 L
.59063 .35289 L
.59066 .35498 L
.59068 .3569 L
.59081 .36422 L
.59084 .36612 L
.59087 .36791 L
.5909 .36953 L
.59093 .36936 L
.59096 .36903 L
.59099 .36872 L
.59102 .36441 L
Mistroke
.59105 .35817 L
.59107 .35514 L
.59109 .35187 L
.59112 .35206 L
.59114 .35323 L
.59115 .35446 L
.59117 .3556 L
.59119 .35666 L
.59122 .35327 L
.59125 .34942 L
.59131 .33981 L
.59142 .31511 L
.59145 .30902 L
.59147 .30249 L
.59149 .30492 L
.59151 .30733 L
.59154 .31207 L
.59157 .31693 L
.59159 .31737 L
.5916 .31737 L
.59166 .31737 L
.59169 .31737 L
.59172 .31737 L
.59174 .31737 L
.59176 .317 L
.59179 .3136 L
.59182 .30989 L
.59185 .30601 L
.59188 .3057 L
.59191 .30682 L
.59193 .30788 L
.59196 .30842 L
.59199 .30783 L
.59202 .3072 L
.59204 .3066 L
.59206 .30639 L
.59208 .30621 L
.5921 .30589 L
.59213 .30558 L
.59217 .30132 L
.59219 .29555 L
.59222 .29032 L
.59225 .28628 L
.59228 .28453 L
.59231 .28289 L
.59233 .28136 L
.59236 .28214 L
.59238 .28275 L
.59239 .2834 L
.59241 .28408 L
Mistroke
.59243 .28472 L
.59244 .28414 L
.59246 .28342 L
.59249 .28211 L
.59251 .28139 L
.59252 .28072 L
.59255 .28089 L
.59258 .28122 L
.59261 .28154 L
.59263 .28095 L
.59264 .27918 L
.59268 .27529 L
.59271 .27176 L
.59274 .27002 L
.59276 .269 L
.59279 .26793 L
.59282 .26693 L
.59284 .26657 L
.59286 .26623 L
.59289 .2655 L
.59292 .26498 L
.59295 .26464 L
.59297 .26446 L
.59299 .26425 L
.593 .26406 L
.59302 .26676 L
.59305 .27192 L
.59307 .27473 L
.59309 .27735 L
.59312 .27805 L
.59313 .27657 L
.59315 .27499 L
.59318 .27241 L
.59321 .27002 L
.59324 .26791 L
.59328 .26592 L
.59334 .26216 L
.59337 .26043 L
.5934 .25708 L
.59343 .25214 L
.59346 .24762 L
.59349 .24332 L
.59352 .24299 L
.59355 .24265 L
.59356 .24246 L
.59358 .24193 L
.59361 .23716 L
.59364 .23266 L
.59366 .22862 L
.59369 .22941 L
Mistroke
.59372 .2327 L
.59374 .2345 L
.59376 .23618 L
.59378 .23796 L
.59381 .23861 L
.59384 .23921 L
.59387 .23962 L
.59389 .23873 L
.59392 .23775 L
.59394 .2367 L
.59397 .23443 L
.594 .23139 L
.59403 .22804 L
.59406 .22472 L
.59408 .22487 L
.59412 .22504 L
.59415 .2252 L
.59418 .22329 L
.59421 .22109 L
.59427 .21586 L
.59432 .21112 L
.59435 .20921 L
.59438 .20937 L
.59441 .20954 L
.59444 .20969 L
.59446 .20943 L
.59449 .20912 L
.59451 .20894 L
.59453 .20876 L
.59456 .20682 L
.59463 .20112 L
.59466 .19849 L
.59469 .19603 L
.59472 .19381 L
.59475 .19429 L
.59478 .19492 L
.59481 .1956 L
.59483 .19516 L
.59485 .19423 L
.59488 .19256 L
.59491 .19088 L
.59494 .1918 L
.59496 .19322 L
.59499 .19476 L
.59502 .19369 L
.59505 .18893 L
.59508 .1838 L
.59511 .17851 L
.59514 .17701 L
.59516 .17562 L
Mistroke
.59519 .17415 L
.59522 .17462 L
.59525 .1769 L
.59527 .1781 L
.59529 .17937 L
.5953 .17998 L
.59532 .17905 L
.59535 .17741 L
.59547 .17099 L
.5956 .15903 L
.59564 .15468 L
.59567 .15005 L
.5957 .14696 L
.59573 .14473 L
.59576 .14256 L
.59579 .14178 L
.59582 .14257 L
.59585 .14329 L
.59588 .14367 L
.59589 .14251 L
.59591 .14142 L
.59594 .13924 L
.59596 .13801 L
.59597 .13781 L
.596 .14117 L
.59603 .14474 L
.59606 .14786 L
.59609 .14795 L
.59612 .14781 L
.59615 .14765 L
.59617 .14894 L
.5962 .15123 L
.59623 .15386 L
.59626 .15603 L
.59628 .15403 L
.59629 .15222 L
.59632 .14867 L
.59635 .1455 L
.59638 .14516 L
.59641 .14486 L
.59644 .14454 L
.59647 .14236 L
.5965 .13998 L
.59652 .13852 L
.59654 .13714 L
.59657 .13843 L
.59658 .13948 L
.5966 .1406 L
.59663 .1426 L
.5967 .14679 L
Mistroke
.59676 .14967 L
.59679 .15092 L
.59682 .15223 L
.59683 .15263 L
.59685 .15206 L
.59688 .15104 L
.59694 .14886 L
.59706 .14362 L
.59709 .14207 L
.59711 .14122 L
.59712 .13994 L
.59715 .13697 L
.59718 .1337 L
.59721 .13096 L
.59724 .13051 L
.59727 .13009 L
.5973 .12965 L
.59732 .13037 L
.59735 .1317 L
.59737 .13246 L
.59738 .13327 L
.59741 .13393 L
.59743 .13367 L
.59745 .13337 L
.59747 .13308 L
.59748 .13277 L
.5975 .13242 L
.59752 .13197 L
.59755 .13109 L
.59758 .13031 L
.59761 .12968 L
.59765 .12912 L
.59768 .12861 L
.59771 .12905 L
.59774 .12997 L
.59777 .13098 L
.59778 .13158 L
.5978 .13323 L
.59783 .13646 L
.59786 .13952 L
.59789 .14184 L
.59792 .14339 L
.59795 .14495 L
.59798 .14649 L
.598 .14495 L
.59803 .14324 L
.59806 .14144 L
.59808 .1407 L
.59809 .14037 L
.59812 .13971 L
Mistroke
.59815 .1391 L
.59818 .13927 L
.59821 .14048 L
.59827 .14303 L
.59832 .14524 L
.59834 .14649 L
.59837 .14979 L
.5984 .15548 L
.59843 .16157 L
.59846 .16633 L
.59849 .16834 L
.59855 .17275 L
.59861 .17695 L
.59863 .178 L
.59864 .17911 L
.59866 .17722 L
.59868 .17534 L
.59871 .17167 L
.59875 .16869 L
.59877 .16808 L
.5988 .16742 L
.59887 .16583 L
.5989 .16498 L
.59893 .16418 L
.59895 .16473 L
.59896 .1654 L
.599 .16658 L
.59903 .1677 L
.59906 .1722 L
.59909 .17663 L
.59911 .18067 L
.59914 .18113 L
.59916 .18019 L
.59918 .1793 L
.59921 .17772 L
.59922 .17745 L
.59924 .17862 L
.59927 .18123 L
.59929 .18261 L
.59931 .18405 L
.59933 .18595 L
.59935 .18823 L
.59938 .19223 L
.59941 .1957 L
.59944 .1939 L
.59946 .1913 L
.59949 .18895 L
.59955 .18158 L
.59958 .17812 L
.59961 .17559 L
Mistroke
.59964 .17575 L
.59967 .17592 L
.59969 .17601 L
.59971 .17643 L
.59972 .17706 L
.59974 .17765 L
.59977 .17877 L
.59979 .17941 L
.5998 .17867 L
.59983 .17528 L
.59986 .17166 L
.59989 .16864 L
.59991 .17215 L
.59992 .17542 L
.59996 .18258 L
.59999 .18787 L
.60002 .18739 L
.60005 .18694 L
.60008 .18646 L
.60009 .18742 L
.60011 .18857 L
.60024 .20204 L
.60025 .20456 L
.60027 .20696 L
.60029 .20812 L
.60031 .20909 L
.60034 .21087 L
.60036 .21187 L
.60038 .21219 L
.60041 .21187 L
.60043 .21156 L
.60046 .21128 L
.60049 .20731 L
.60052 .20262 L
.60054 .20005 L
.60055 .19766 L
.60058 .19736 L
.60061 .19819 L
.60063 .19861 L
.60064 .19907 L
.60067 .19717 L
.6007 .19394 L
.60073 .19094 L
.60076 .18976 L
.60078 .19086 L
.60079 .19189 L
.60086 .19785 L
.6013 .25723 L
.60143 .27078 L
.60149 .27947 L
Mistroke
.60156 .28861 L
.60158 .29295 L
.60161 .29682 L
.60163 .29725 L
.60165 .29772 L
.60168 .29855 L
.60171 .2991 L
.60174 .29652 L
.60176 .29425 L
.60179 .29184 L
.60181 .29123 L
.60182 .29181 L
.60185 .29294 L
.60187 .29357 L
.60189 .29425 L
.6019 .29442 L
.60192 .29409 L
.60195 .29342 L
.60198 .2928 L
.60201 .29167 L
.60204 .29007 L
.60207 .28861 L
.6021 .28561 L
.60212 .28121 L
.60215 .27643 L
.60218 .2713 L
.6022 .27105 L
.60221 .27078 L
.60224 .27033 L
.60227 .26985 L
.60229 .26975 L
.6023 .26975 L
.60234 .26975 L
.60237 .26975 L
.6024 .26922 L
.60243 .26843 L
.60245 .26805 L
.60247 .26769 L
.6025 .26403 L
.60253 .26003 L
.60265 .24213 L
.60268 .23705 L
.60272 .23151 L
.60273 .22898 L
.60275 .22628 L
.60278 .22574 L
.60279 .22608 L
.60281 .22645 L
.60284 .22712 L
.60287 .22506 L
Mistroke
.6029 .22224 L
.60293 .21938 L
.60295 .21735 L
.60298 .2169 L
.60301 .21642 L
.60304 .21595 L
.60307 .21684 L
.60309 .21776 L
.60312 .21874 L
.60314 .21915 L
.60317 .21775 L
.6032 .21612 L
.60323 .21456 L
.60326 .21538 L
.60329 .21645 L
.60332 .21759 L
.60333 .21798 L
.60335 .21798 L
.60338 .21798 L
.60341 .21798 L
.60344 .21583 L
.60346 .21129 L
.60353 .20168 L
.60356 .19755 L
.60359 .19369 L
.60361 .19167 L
.60362 .19186 L
.60364 .19488 L
.60366 .19764 L
.60369 .20289 L
.60372 .20649 L
.60375 .20821 L
.60378 .21007 L
.60381 .21186 L
.60384 .21233 L
.6039 .21328 L
.60396 .21466 L
.60402 .21623 L
.60407 .2182 L
.60418 .22299 L
.60431 .24734 L
.60434 .25666 L
.60436 .26176 L
.60438 .26653 L
.60441 .26364 L
.60444 .25945 L
.6045 .25283 L
.60453 .25012 L
.60456 .24759 L
.60459 .24676 L
Mistroke
.6046 .24703 L
.60462 .24732 L
.60468 .24848 L
.60471 .24932 L
.60473 .24978 L
.60475 .25021 L
.60476 .2503 L
.60478 .24826 L
.60481 .24467 L
.60485 .24124 L
.60488 .24056 L
.60489 .24082 L
.60491 .2411 L
.60494 .24161 L
.60497 .24025 L
.605 .2374 L
.60501 .23596 L
.60503 .23442 L
.60506 .23348 L
.60509 .23441 L
.60512 .23539 L
.60515 .23612 L
.60517 .23627 L
.6052 .23643 L
.60523 .23658 L
.60526 .23804 L
.60529 .24014 L
.60534 .2445 L
.60538 .24674 L
.6054 .24883 L
.60543 .25051 L
.60546 .24721 L
.60549 .24361 L
.60552 .2402 L
.60554 .24016 L
.60557 .24168 L
.60562 .24435 L
.60568 .25068 L
.60571 .25426 L
.60574 .25253 L
.60576 .24909 L
.60579 .24532 L
.60585 .23957 L
.60588 .23697 L
.60591 .23453 L
.60592 .23381 L
.60594 .23302 L
.60597 .23165 L
.60604 .22825 L
.60607 .22627 L
Mistroke
.60609 .22447 L
.60612 .22352 L
.60615 .22267 L
.60617 .22223 L
.60619 .22174 L
.60621 .22193 L
.60622 .22235 L
.60626 .22327 L
.60629 .22413 L
.6063 .22403 L
.60632 .22383 L
.60636 .22347 L
.60639 .22322 L
.6064 .22438 L
.60642 .22547 L
.60645 .22786 L
.60648 .2299 L
.60651 .23006 L
.60654 .23021 L
.60657 .23036 L
.6066 .23016 L
.60663 .22985 L
.60665 .22955 L
.60668 .2327 L
.60672 .24078 L
.60674 .24738 L
.60677 .25422 L
.6068 .25422 L
.60682 .25422 L
.60684 .25422 L
.60686 .25422 L
.60688 .25472 L
.60689 .25535 L
.60692 .25659 L
.60696 .25775 L
.60698 .25609 L
.60701 .25403 L
.60703 .25286 L
.60704 .25174 L
.60707 .25314 L
.60711 .2562 L
.60713 .25908 L
.60715 .26046 L
.60717 .26065 L
.6072 .26098 L
.60723 .2613 L
.60726 .2613 L
.60729 .26101 L
.60732 .26069 L
.60735 .26072 L
Mistroke
.60736 .26132 L
.60738 .26199 L
.6074 .26271 L
.60742 .26338 L
.60743 .264 L
.60745 .26276 L
.60749 .26 L
.6075 .25863 L
.60752 .25737 L
.60755 .25681 L
.60756 .25731 L
.60758 .25785 L
.60759 .25835 L
.60761 .25888 L
.60763 .25929 L
.60765 .25849 L
.60768 .25691 L
.60771 .25544 L
.60773 .25501 L
.60776 .25564 L
.60779 .25627 L
.60781 .25663 L
.60782 .25673 L
.60785 .25641 L
.60789 .25608 L
.60791 .25578 L
.60794 .25703 L
.60797 .25818 L
.608 .25942 L
.60802 .26162 L
.60805 .2643 L
.60811 .2712 L
.60814 .27612 L
.60818 .28077 L
.60821 .2844 L
.60822 .28486 L
.60824 .28528 L
.60829 .2868 L
.60835 .28961 L
.60837 .29038 L
.60839 .29122 L
.60842 .28997 L
.60843 .28892 L
.60845 .28793 L
.60848 .28606 L
.6085 .28552 L
.60852 .28518 L
.60855 .2844 L
.60858 .28373 L
.6086 .28272 L
Mistroke
.60862 .2816 L
.60865 .27961 L
.60867 .27779 L
.60869 .27946 L
.60871 .2819 L
.60874 .28727 L
.60881 .29536 L
.60886 .30109 L
.60892 .30688 L
.60895 .30988 L
.60897 .31052 L
.60899 .30812 L
.60901 .30393 L
.60905 .29935 L
.60907 .29741 L
.6091 .29784 L
.60913 .29829 L
.60916 .29848 L
.60919 .29531 L
.60921 .29232 L
.60924 .28966 L
.60926 .2876 L
.60929 .28683 L
.60932 .28602 L
.60935 .28529 L
.60937 .28725 L
.6094 .28956 L
.60943 .29201 L
.60946 .29353 L
.60949 .295 L
.60952 .29644 L
.60954 .29714 L
.60955 .29664 L
.60958 .29566 L
.60961 .29475 L
.60964 .29434 L
.60966 .29477 L
.60968 .29523 L
.60971 .29609 L
.60974 .29725 L
.60978 .29869 L
.60981 .30002 L
.60984 .30027 L
.60987 .29875 L
.60989 .29748 L
.60992 .2962 L
.60995 .29853 L
.60998 .3007 L
.61001 .30295 L
.61004 .30212 L
Mistroke
.61007 .30032 L
.61008 .29941 L
.6101 .29841 L
.61013 .29862 L
.61016 .30003 L
.61019 .30128 L
.61021 .30199 L
.61024 .30033 L
.61027 .29878 L
.61029 .29714 L
.61032 .29771 L
.61035 .29905 L
.61038 .30032 L
.6104 .30163 L
.61043 .30466 L
.61045 .30792 L
.61048 .31135 L
.61051 .31347 L
.61054 .31456 L
.61057 .31551 L
.61059 .31625 L
.61062 .31577 L
.61065 .31532 L
.61072 .31386 L
.61075 .31296 L
.61078 .31197 L
.61081 .30898 L
.61084 .30582 L
.6109 .29686 L
.61093 .29071 L
.61096 .28487 L
.61098 .28218 L
.61099 .28047 L
.61103 .27747 L
.61105 .27462 L
.61109 .27477 L
.61112 .277 L
.61114 .27901 L
.61116 .28028 L
.61118 .28041 L
.61121 .2799 L
.61122 .27963 L
.61124 .27935 L
.61126 .27885 L
.61128 .27672 L
.61134 .26931 L
.61141 .26314 L
.61144 .26061 L
.61147 .25911 L
.61148 .25882 L
Mistroke
.6115 .25855 L
.61153 .25803 L
.61159 .25735 L
.61162 .25703 L
.61165 .25809 L
.61167 .26024 L
.61169 .26227 L
.61172 .26606 L
.61174 .26818 L
.61175 .26793 L
.61179 .26733 L
.6118 .26708 L
.61182 .26681 L
.61185 .26599 L
.61188 .26498 L
.61192 .26386 L
.61198 .26184 L
.612 .26129 L
.61201 .2607 L
.61203 .26097 L
.61205 .26226 L
.61208 .26457 L
.61209 .26578 L
.61211 .26706 L
.61214 .26743 L
.61217 .26712 L
.6122 .26682 L
.61223 .26692 L
.61226 .26752 L
.61228 .26807 L
.61231 .26871 L
.61233 .26699 L
.61234 .2654 L
.61237 .26232 L
.6124 .25939 L
.61243 .2625 L
.61246 .2673 L
.61249 .27172 L
.61251 .27326 L
.61254 .27163 L
.61256 .2708 L
.61258 .2699 L
.61261 .26627 L
.61263 .2576 L
.61266 .24879 L
.61269 .24057 L
.61272 .23997 L
.61275 .24096 L
.61277 .24182 L
.6128 .24137 L
Mistroke
.61283 .23836 L
.61285 .23551 L
.61288 .23242 L
.61291 .23094 L
.61294 .22979 L
.61296 .22919 L
.61297 .22855 L
.61301 .23038 L
.61303 .23267 L
.61306 .23482 L
.61309 .23547 L
.61311 .23461 L
.61312 .23381 L
.61315 .2323 L
.61317 .23146 L
.61319 .23221 L
.61322 .23396 L
.61325 .23537 L
.61328 .23358 L
.6133 .23115 L
.61332 .22855 L
.61335 .22386 L
.61347 .21053 L
.6135 .20162 L
.61351 .19694 L
.61353 .192 L
.61356 .18658 L
.61359 .19069 L
.61363 .19555 L
.61364 .1983 L
.61366 .19812 L
.61369 .19658 L
.61373 .19493 L
.61375 .19431 L
.61376 .19684 L
.6138 .20143 L
.61383 .2059 L
.61386 .20432 L
.61389 .19847 L
.61391 .19291 L
.61393 .18985 L
.61395 .18948 L
.61398 .19062 L
.61401 .1917 L
.61404 .19236 L
.61406 .19112 L
.61409 .18999 L
.61412 .18872 L
.61415 .19173 L
.61418 .19514 L
Mistroke
.61421 .19888 L
.61423 .20052 L
.61424 .20095 L
.61428 .20189 L
.61431 .2027 L
.61432 .20234 L
.61434 .20091 L
.61437 .19843 L
.61439 .19582 L
.61443 .19432 L
.61445 .19463 L
.61448 .1949 L
.61451 .19518 L
.61453 .19334 L
.61456 .19145 L
.61459 .18934 L
.61462 .18619 L
.61467 .17866 L
.61473 .17037 L
.61477 .16591 L
.6148 .16216 L
.61483 .16317 L
.61486 .16427 L
.61489 .16512 L
.61492 .1621 L
.61494 .16041 L
.61496 .15857 L
.61498 .15684 L
.61499 .15637 L
.61502 .15874 L
.61504 .16005 L
.61506 .16126 L
.61509 .16278 L
.6151 .16198 L
.61512 .16114 L
.61515 .15972 L
.61517 .15891 L
.61518 .15911 L
.61521 .16224 L
.61524 .16508 L
.61527 .16837 L
.6153 .16629 L
.61532 .16347 L
.61535 .16043 L
.61538 .16032 L
.61541 .16282 L
.61544 .16583 L
.61547 .16797 L
.6155 .16523 L
.61553 .16224 L
Mistroke
.61559 .15625 L
.61562 .15315 L
.61565 .15029 L
.61566 .15012 L
.61568 .15092 L
.61571 .15261 L
.61578 .15557 L
.6158 .15689 L
.61583 .15814 L
.61586 .15802 L
.61588 .15598 L
.61591 .15418 L
.61593 .15228 L
.61596 .15261 L
.61599 .15371 L
.61601 .15489 L
.61604 .15693 L
.61607 .16116 L
.6161 .16505 L
.61612 .16935 L
.61616 .16565 L
.61617 .16262 L
.61619 .15938 L
.61622 .15354 L
.61625 .155 L
.61626 .15773 L
.61628 .16028 L
.61631 .16543 L
.61633 .16704 L
.61635 .16651 L
.61638 .16555 L
.61641 .16452 L
.61644 .16395 L
.61646 .16366 L
.6165 .16332 L
.61651 .16314 L
.61653 .16303 L
.61655 .16293 L
.61657 .16283 L
.61658 .16274 L
.6166 .16265 L
.61662 .16371 L
.61663 .16594 L
.61666 .17029 L
.61668 .17272 L
.6167 .17536 L
.61671 .1759 L
.61673 .1747 L
.61676 .17259 L
.61679 .17033 L
Mistroke
.61682 .16933 L
.61684 .16933 L
.61687 .16933 L
.6169 .16969 L
.61692 .17072 L
.61693 .17182 L
.61697 .1738 L
.61698 .1749 L
.617 .17505 L
.61701 .17358 L
.61703 .17202 L
.61706 .16918 L
.6171 .16721 L
.61712 .16706 L
.61715 .1669 L
.61717 .16681 L
.61718 .16693 L
.61721 .17014 L
.61724 .17339 L
.61726 .1751 L
.61728 .1769 L
.61731 .17191 L
.61734 .16687 L
.61736 .16201 L
.61739 .16154 L
.61742 .16455 L
.61745 .16777 L
.61748 .1696 L
.61749 .16785 L
.61751 .16623 L
.61754 .16333 L
.61756 .16167 L
.61757 .1612 L
.6176 .16164 L
.61763 .16212 L
.61766 .1625 L
.61769 .1611 L
.6178 .15301 L
.61783 .14963 L
.61786 .14751 L
.61789 .14897 L
.61792 .15028 L
.61813 .15937 L
.61816 .16029 L
.61819 .16062 L
.61821 .16079 L
.61823 .16099 L
.61826 .15895 L
.61829 .15654 L
.61832 .15398 L
Mistroke
.61835 .15466 L
.61838 .15691 L
.61841 .15921 L
.61842 .1605 L
.61844 .16094 L
.6185 .16255 L
.61853 .16368 L
.61855 .16464 L
.61857 .16554 L
.61863 .16929 L
.61875 .17592 L
.61886 .18242 L
.61889 .18399 L
.61892 .18646 L
.61895 .19013 L
.61898 .19352 L
.61901 .19756 L
.61904 .20254 L
.61907 .20843 L
.6191 .21383 L
.61912 .21233 L
.61915 .21073 L
.61921 .20707 L
.61933 .19829 L
.61936 .19559 L
.61939 .1929 L
.61941 .19153 L
.61944 .19026 L
.61947 .18901 L
.61949 .18827 L
.61951 .18787 L
.61954 .18742 L
.61957 .18694 L
.61959 .19179 L
.6196 .19653 L
.61963 .20505 L
.61966 .21445 L
.61969 .21394 L
.61972 .2117 L
.61974 .20933 L
.61977 .20971 L
.6198 .21609 L
.61984 .22308 L
.61985 .2266 L
.61987 .22828 L
.61989 .22891 L
.6199 .22949 L
.61993 .2306 L
.61996 .23211 L
.61999 .23422 L
Mistroke
.62002 .23617 L
.62097 .28398 L
.621 .28538 L
.62103 .2861 L
.62106 .28662 L
.62109 .28708 L
.6211 .28735 L
.62112 .28727 L
.62115 .28708 L
.62118 .28692 L
.62121 .28717 L
.62124 .28777 L
.62127 .28841 L
.6213 .28967 L
.62132 .29326 L
.62135 .29748 L
.62137 .2997 L
.62139 .30206 L
.62142 .29788 L
.62144 .29343 L
.62147 .28919 L
.6215 .28915 L
.62152 .29311 L
.62155 .29688 L
.62165 .31164 L
.62171 .3208 L
.62174 .32606 L
.62177 .33102 L
.6218 .33288 L
.62183 .33467 L
.62188 .33878 L
.62194 .3467 L
.62196 .35035 L
.622 .3466 L
.62202 .34341 L
.62205 .33998 L
.62208 .3389 L
.6221 .33863 L
.62213 .33829 L
.62216 .33823 L
.62219 .33874 L
.62223 .33928 L
.62226 .33988 L
.62228 .34077 L
.62235 .34282 L
.62246 .34753 L
.6225 .34769 L
.62251 .34779 L
.62253 .34787 L
.62256 .34935 L
Mistroke
.62259 .35104 L
.62262 .3529 L
.62264 .35314 L
.62265 .35182 L
.62269 .34907 L
.62271 .34761 L
.62272 .34604 L
.62276 .34443 L
.62279 .343 L
.6228 .34216 L
.62282 .34137 L
.62285 .34381 L
.62288 .34673 L
.6229 .34827 L
.62291 .3499 L
.62294 .35116 L
.62297 .35193 L
.623 .35266 L
.62302 .35208 L
.62305 .34909 L
.62308 .34588 L
.62315 .33831 L
.62318 .33442 L
.62321 .33013 L
.62324 .32246 L
.62327 .31432 L
.62329 .30615 L
.62331 .30449 L
.62333 .30457 L
.62335 .30472 L
.62338 .30486 L
.62341 .30399 L
.62344 .30141 L
.62346 .29922 L
.62349 .29686 L
.62352 .29552 L
.62354 .29436 L
.62357 .29298 L
.6236 .29261 L
.62362 .29411 L
.62365 .29575 L
.62368 .29751 L
.62371 .29709 L
.62374 .29645 L
.62377 .29586 L
.62383 .30226 L
.62386 .3065 L
.62387 .30859 L
.62389 .30924 L
.62392 .31043 L
Mistroke
.62395 .31154 L
.62398 .30967 L
.62401 .30201 L
.62404 .2933 L
.62407 .28622 L
.6241 .28366 L
.62413 .28088 L
.62419 .27354 L
.62423 .26894 L
.62425 .26635 L
.62426 .26549 L
.6243 .26699 L
.62432 .26842 L
.62438 .27085 L
.62441 .27193 L
.62444 .27309 L
.62446 .27327 L
.62447 .27309 L
.6245 .27276 L
.62456 .27216 L
.62459 .27185 L
.62462 .27152 L
.62464 .2713 L
.62467 .2713 L
.6247 .2713 L
.62472 .2713 L
.62475 .26916 L
.62477 .26755 L
.62479 .26584 L
.62484 .26068 L
.62495 .25207 L
.6252 .23006 L
.62564 .19798 L
.62575 .18168 L
.62581 .17309 L
.62584 .16929 L
.62587 .16583 L
.6259 .16357 L
.62593 .16188 L
.62595 .16099 L
.62596 .16003 L
.62598 .15852 L
.626 .15627 L
.62603 .15203 L
.62605 .14806 L
.62608 .14682 L
.62611 .15053 L
.62614 .15375 L
.62617 .15699 L
.6262 .15774 L
Mistroke
.62622 .15845 L
.62632 .16153 L
.62635 .1625 L
.62638 .16192 L
.62641 .16113 L
.62643 .16069 L
.62644 .16027 L
.62647 .16138 L
.6265 .16329 L
.62652 .16536 L
.62655 .16739 L
.62658 .16838 L
.62661 .1693 L
.62664 .17029 L
.62666 .16938 L
.62667 .16833 L
.62674 .16391 L
.62677 .16244 L
.62681 .16084 L
.62684 .15915 L
.62687 .15575 L
.62692 .14905 L
.62698 .14386 L
.627 .14245 L
.62702 .14113 L
.62705 .14023 L
.62749 .12955 L
.62755 .12082 L
.62757 .11755 L
.62758 .114 L
.62762 .1101 L
.62765 .1096 L
.62767 .10914 L
.6277 .10921 L
.62773 .11372 L
.62776 .1181 L
.62778 .12281 L
.6278 .12405 L
.62782 .12355 L
.62785 .12258 L
.62791 .12008 L
.62794 .11819 L
.62798 .11647 L
.628 .11733 L
.62803 .11915 L
.62806 .12123 L
.62809 .12258 L
.62811 .12193 L
.62813 .12125 L
.62816 .12056 L
Mistroke
.62819 .12152 L
.62842 .13247 L
.62939 .16616 L
.62941 .16912 L
.62944 .16514 L
.62947 .16023 L
.6295 .15571 L
.62953 .15471 L
.62955 .15628 L
.6296 .15985 L
.62966 .16423 L
.62973 .16991 L
.62975 .17339 L
.62978 .17668 L
.62981 .17764 L
.62983 .1744 L
.62987 .17048 L
.6299 .16719 L
.62991 .16694 L
.62993 .16667 L
.62995 .1664 L
.62997 .1661 L
.63 .16703 L
.63001 .1704 L
.63003 .17353 L
.63006 .1791 L
.63009 .18504 L
.63012 .18919 L
.63015 .19309 L
.63017 .1969 L
.6302 .19697 L
.63023 .19577 L
.63026 .19445 L
.63027 .19379 L
.63029 .19344 L
.63032 .19295 L
.63034 .19269 L
.63035 .19241 L
.63039 .19483 L
.6304 .19861 L
.63042 .20215 L
.63046 .21025 L
.63052 .21993 L
.63054 .22233 L
.63055 .22487 L
.63057 .22644 L
.63059 .22699 L
.63062 .22801 L
.63065 .22897 L
.63066 .23001 L
Mistroke
.63068 .23298 L
.63071 .23818 L
.63074 .24315 L
.63077 .24474 L
.6308 .24373 L
.63083 .24261 L
.63084 .24203 L
.63086 .24284 L
.63089 .24583 L
.63092 .24877 L
.63095 .2511 L
.63097 .25101 L
.63098 .25092 L
.631 .25082 L
.63102 .25073 L
.63105 .25147 L
.63106 .25446 L
.63108 .25761 L
.63111 .26289 L
.63114 .26856 L
.63116 .26857 L
.63119 .26843 L
.63122 .26826 L
.63124 .26845 L
.63125 .2693 L
.63131 .27252 L
.6318 .30671 L
.63192 .31164 L
.63195 .31048 L
.63196 .30984 L
.63198 .30924 L
.63201 .31126 L
.63204 .3169 L
.63206 .32179 L
.63209 .32697 L
.63212 .32786 L
.63214 .328 L
.63217 .32815 L
.6322 .32913 L
.63222 .33179 L
.63226 .33465 L
.63228 .33701 L
.63231 .33672 L
.63237 .33605 L
.6324 .33587 L
.63243 .33571 L
.63246 .33558 L
.63248 .33517 L
.63251 .33448 L
.63254 .33374 L
Mistroke
.63256 .33312 L
.63258 .333 L
.63261 .33314 L
.63264 .3333 L
.63267 .33352 L
.63269 .33406 L
.63294 .33912 L
.63296 .33996 L
.63299 .34324 L
.63302 .34702 L
.63304 .35048 L
.63307 .34972 L
.63311 .34886 L
.63314 .34805 L
.63316 .34547 L
.63319 .34231 L
.63322 .33933 L
.63324 .33833 L
.63327 .3408 L
.6333 .34349 L
.63333 .34633 L
.63336 .34468 L
.63339 .34281 L
.63342 .34081 L
.63344 .34083 L
.63346 .34142 L
.63348 .34206 L
.63351 .34323 L
.63362 .3492 L
.63375 .35427 L
.63378 .35391 L
.6338 .35371 L
.63382 .35441 L
.63385 .35763 L
.63388 .36102 L
.63391 .36318 L
.63394 .36161 L
.63397 .35979 L
.634 .35806 L
.63401 .35563 L
.63403 .35212 L
.63406 .34598 L
.63407 .34251 L
.63409 .33882 L
.63412 .33866 L
.63415 .33992 L
.63418 .34129 L
.63421 .34503 L
.63424 .34954 L
.63427 .35393 L
Mistroke
.63429 .3569 L
.63432 .35501 L
.63435 .3533 L
.63441 .34794 L
.63444 .34448 L
.63446 .34125 L
.63449 .34057 L
.63451 .3415 L
.63453 .34249 L
.63454 .34353 L
.63456 .34451 L
.63459 .34393 L
.63462 .34187 L
.63464 .33961 L
.63467 .33754 L
.6347 .33739 L
.63472 .33726 L
.63475 .33713 L
.63478 .33724 L
.6348 .33765 L
.63483 .33809 L
.63486 .33857 L
.63489 .33606 L
.63491 .3336 L
.63497 .32818 L
.635 .32557 L
.63502 .32414 L
.63503 .32278 L
.63506 .32117 L
.63509 .32164 L
.63515 .32258 L
.63518 .3241 L
.63521 .32571 L
.63524 .32717 L
.63527 .32442 L
.63538 .31048 L
.63541 .30504 L
.63544 .29979 L
.63547 .29994 L
.63549 .30009 L
.63552 .30024 L
.63555 .29936 L
.63558 .29809 L
.63561 .29694 L
.63564 .29507 L
.63567 .29231 L
.63574 .2875 L
.63577 .28534 L
.6358 .28331 L
.63582 .28229 L
Mistroke
.63583 .28185 L
.63587 .28107 L
.63593 .27957 L
.63596 .27881 L
.63599 .27799 L
.63602 .2745 L
.63605 .26816 L
.63612 .25474 L
.63624 .23692 L
.63636 .2183 L
.63638 .21508 L
.6364 .21242 L
.63642 .21066 L
.63643 .20906 L
.63647 .20591 L
.6365 .20365 L
.63653 .20275 L
.63656 .20179 L
.63659 .2009 L
.6366 .2009 L
.63662 .2009 L
.63664 .2009 L
.63665 .2009 L
.63668 .20084 L
.6367 .20047 L
.63672 .20013 L
.63675 .19936 L
.63698 .19285 L
.6372 .19811 L
.63723 .19908 L
.63726 .20007 L
.63727 .20091 L
.63729 .20182 L
.63732 .20343 L
.63735 .20496 L
.63738 .20489 L
.63741 .20474 L
.63743 .2046 L
.63746 .202 L
.63748 .19944 L
.63749 .19709 L
.63755 .18878 L
.63759 .18534 L
.63762 .18213 L
.63763 .18051 L
.63765 .18027 L
.63767 .18037 L
.63769 .18047 L
.63772 .18063 L
.63774 .18059 L
Mistroke
.63777 .18026 L
.63779 .18009 L
.63781 .17991 L
.63783 .17915 L
.63786 .17704 L
.63789 .17471 L
.63792 .17223 L
.63794 .17156 L
.63795 .17115 L
.63798 .17033 L
.63805 .16899 L
.63808 .16862 L
.6381 .16842 L
.63812 .16786 L
.63814 .16678 L
.63815 .16558 L
.63817 .16435 L
.63819 .16317 L
.6382 .1621 L
.63822 .1621 L
.63825 .16384 L
.63828 .16574 L
.6383 .16678 L
.63831 .16757 L
.63834 .16868 L
.63838 .1699 L
.6384 .17088 L
.63843 .17088 L
.63846 .17088 L
.63849 .17088 L
.63851 .17081 L
.63853 .17073 L
.63856 .17056 L
.63857 .17048 L
.63859 .17039 L
.63861 .17218 L
.63862 .17443 L
.63865 .17855 L
.63867 .18082 L
.63869 .18297 L
.63872 .18108 L
.63874 .17887 L
.63877 .17679 L
.6388 .17621 L
.63883 .17786 L
.63884 .17877 L
.63886 .17962 L
.63889 .1806 L
.63892 .1803 L
.63895 .18 L
Mistroke
.63898 .17965 L
.639 .1772 L
.63903 .17496 L
.63909 .16941 L
.63912 .16698 L
.63915 .1643 L
.63918 .16337 L
.63921 .16389 L
.63928 .16507 L
.63931 .16572 L
.63933 .16606 L
.63934 .16642 L
.63937 .16631 L
.6394 .16556 L
.63943 .16481 L
.63945 .16436 L
.63948 .16919 L
.63951 .17359 L
.63953 .17746 L
.63956 .18036 L
.63959 .18198 L
.63961 .18348 L
.63964 .1851 L
.63967 .18483 L
.6397 .18423 L
.63972 .18367 L
.63975 .18317 L
.63977 .18298 L
.63978 .18281 L
.63981 .1825 L
.63984 .18369 L
.64009 .19575 L
.64016 .1983 L
.64018 .19927 L
.6402 .20031 L
.64021 .20129 L
.64023 .20097 L
.64026 .19995 L
.64029 .19899 L
.64031 .19845 L
.64032 .1988 L
.64034 .19954 L
.64036 .20032 L
.64039 .20162 L
.64042 .20134 L
.64045 .19705 L
.64048 .19297 L
.64051 .18979 L
.64053 .193 L
.64056 .1965 L
Mistroke
.64059 .20029 L
.64061 .2012 L
.64062 .20076 L
.64065 .19991 L
.64068 .19914 L
.64071 .19499 L
.64075 .18837 L
.64076 .18488 L
.64078 .18117 L
.6408 .17854 L
.64081 .17675 L
.64084 .17359 L
.64087 .17054 L
.64089 .16935 L
.64091 .16944 L
.64093 .16958 L
.64096 .16975 L
.64099 .16947 L
.64102 .1685 L
.64107 .16639 L
.6411 .16548 L
.64113 .16466 L
.64116 .16393 L
.64119 .16638 L
.64125 .17549 L
.64127 .17799 L
.64128 .17922 L
.64132 .1813 L
.64135 .18324 L
.64137 .18452 L
.6414 .18493 L
.64143 .18538 L
.64146 .18586 L
.64149 .18764 L
.64155 .191 L
.64157 .19235 L
.6416 .19364 L
.64163 .19477 L
.64166 .19533 L
.64168 .19357 L
.64171 .19163 L
.64176 .1876 L
.64182 .17975 L
.64183 .1776 L
.64185 .17636 L
.64188 .17568 L
.64191 .17509 L
.64194 .17436 L
.64196 .17335 L
.64197 .17243 L
Mistroke
.642 .17063 L
.64203 .16902 L
.64205 .16986 L
.64208 .17121 L
.64211 .17264 L
.64217 .17601 L
.6422 .17758 L
.64223 .17906 L
.64226 .17752 L
.64229 .17589 L
.64231 .17504 L
.64233 .1748 L
.64234 .17548 L
.64236 .1761 L
.64239 .17729 L
.64241 .17797 L
.64243 .17666 L
.64246 .17307 L
.64247 .17108 L
.64249 .16925 L
.64252 .1672 L
.64255 .16918 L
.64258 .17104 L
.6426 .17277 L
.64263 .17608 L
.64266 .17989 L
.64273 .18756 L
.64276 .19121 L
.64278 .1932 L
.64279 .19507 L
.64282 .19501 L
.64285 .19402 L
.64287 .19346 L
.64288 .19294 L
.64291 .19328 L
.64293 .19383 L
.64294 .19434 L
.64298 .1955 L
.64301 .19677 L
.64304 .19805 L
.64307 .19919 L
.6431 .2023 L
.64312 .20765 L
.64315 .21338 L
.64317 .21667 L
.64319 .2177 L
.64322 .21669 L
.64325 .21578 L
.64328 .21514 L
.64331 .21823 L
Mistroke
.64333 .2211 L
.64345 .23185 L
.64367 .25103 L
.64369 .25242 L
.64372 .2539 L
.64375 .25523 L
.64378 .25424 L
.64384 .25208 L
.6439 .24891 L
.64397 .24527 L
.644 .24348 L
.64403 .24182 L
.64406 .24355 L
.64409 .24727 L
.64412 .251 L
.64414 .25312 L
.64415 .25236 L
.64418 .25085 L
.64421 .2492 L
.64424 .24928 L
.64427 .2544 L
.64437 .2732 L
.64449 .29568 L
.64455 .3047 L
.64458 .30768 L
.64461 .31094 L
.64464 .31226 L
.64466 .31297 L
.64469 .31371 L
.64472 .31392 L
.64473 .31334 L
.64475 .3127 L
.64478 .31155 L
.64481 .31015 L
.64484 .30781 L
.64486 .30582 L
.64489 .30368 L
.64491 .30275 L
.64494 .30358 L
.64497 .30447 L
.645 .3054 L
.64502 .30095 L
.64505 .29558 L
.64508 .28924 L
.64511 .28558 L
.64514 .28429 L
.64517 .28289 L
.6452 .28199 L
.64521 .28286 L
.64523 .28381 L
Mistroke
.64529 .28716 L
.64534 .29113 L
.64537 .29331 L
.6454 .29417 L
.64543 .29433 L
.64544 .29442 L
.64546 .2945 L
.64549 .29496 L
.64552 .29607 L
.64555 .29727 L
.64558 .29776 L
.64561 .29459 L
.64564 .29112 L
.64567 .2884 L
.6457 .28855 L
.64573 .28873 L
.64576 .28889 L
.64579 .28877 L
.64582 .28862 L
.64584 .28846 L
.64588 .2892 L
.6459 .29049 L
.64593 .2919 L
.64596 .29291 L
.64598 .29209 L
.64602 .29106 L
.64603 .2905 L
.64605 .28997 L
.64608 .28928 L
.64611 .28866 L
.64613 .28831 L
.64614 .28793 L
.64617 .28606 L
.64621 .28387 L
.64623 .28267 L
.64624 .2818 L
.64627 .28401 L
.6463 .28602 L
.64633 .28791 L
.64636 .28608 L
.64639 .283 L
.64642 .27977 L
.64644 .27845 L
.64645 .27806 L
.64649 .27737 L
.64652 .27674 L
.64655 .27711 L
.64658 .27806 L
.6466 .27893 L
.64663 .28021 L
Mistroke
.64666 .28288 L
.64671 .28772 L
.64678 .29438 L
.64679 .29603 L
.64681 .2978 L
.64682 .29753 L
.64684 .29534 L
.64696 .28281 L
.64703 .27739 L
.64706 .27335 L
.64708 .27113 L
.6471 .26905 L
.64711 .26877 L
.64713 .26986 L
.64716 .27175 L
.64718 .27268 L
.6472 .27367 L
.64723 .27319 L
.64725 .27241 L
.64728 .27157 L
.64731 .27172 L
.64734 .27229 L
.64737 .27296 L
.64739 .27334 L
.64741 .27281 L
.64744 .27162 L
.64747 .27049 L
.64749 .27038 L
.64752 .27269 L
.64755 .27482 L
.64758 .27675 L
.64761 .28213 L
.64764 .28825 L
.6477 .2982 L
.64775 .30578 L
.64781 .31254 L
.64784 .31529 L
.64787 .3182 L
.64789 .31733 L
.64792 .31605 L
.64798 .31304 L
.64801 .31158 L
.64803 .31078 L
.64805 .31003 L
.64808 .31203 L
.6481 .31391 L
.64811 .31594 L
.64815 .31954 L
.64818 .31869 L
.6482 .31622 L
Mistroke
.64823 .31393 L
.64829 .30764 L
.64835 .30024 L
.64838 .29542 L
.64841 .29097 L
.64844 .28662 L
.64847 .28929 L
.6485 .29275 L
.64853 .29599 L
.64855 .29425 L
.64858 .29078 L
.64861 .28696 L
.64864 .28407 L
.64867 .28324 L
.6487 .28232 L
.64876 .28047 L
.64879 .27953 L
.64882 .27866 L
.64885 .27644 L
.64888 .27431 L
.64891 .27212 L
.64893 .27192 L
.64894 .2736 L
.64897 .27728 L
.64901 .28063 L
.64903 .28009 L
.64906 .27789 L
.64909 .27556 L
.64912 .27504 L
.64915 .27843 L
.64919 .28217 L
.6492 .28406 L
.64922 .28781 L
.64926 .29493 L
.64927 .29841 L
.64929 .30164 L
.6493 .30397 L
.64932 .30104 L
.64935 .29626 L
.64938 .29102 L
.64941 .28863 L
.64943 .2889 L
.64945 .28915 L
.64947 .2896 L
.6495 .2883 L
.64952 .28527 L
.64954 .28197 L
.64956 .27906 L
.64957 .27596 L
.64959 .27319 L
Mistroke
.64961 .27277 L
.64964 .27261 L
.64967 .27244 L
.64969 .27195 L
.64973 .27059 L
.64976 .26917 L
.64979 .26813 L
.64981 .26784 L
.64984 .26752 L
.64987 .26718 L
.6499 .26349 L
.64993 .25987 L
.64996 .25647 L
.64999 .25407 L
.65001 .25294 L
.65004 .2519 L
.65009 .25022 L
.65012 .24978 L
.65015 .24929 L
.65018 .24786 L
.6502 .24545 L
.65026 .23969 L
.65032 .23444 L
.65035 .23159 L
.65037 .23182 L
.65038 .23229 L
.65042 .23311 L
.65044 .23387 L
.65046 .23451 L
.65048 .2352 L
.65051 .23673 L
.65054 .23805 L
.65056 .23717 L
.65058 .23604 L
.6506 .23417 L
.65063 .23215 L
.65066 .23202 L
.65069 .23282 L
.65072 .23367 L
.65074 .2339 L
.65076 .23296 L
.65079 .23132 L
.65081 .22976 L
.65084 .22687 L
.65087 .22157 L
.6509 .21716 L
.65093 .21231 L
.65096 .21752 L
.65099 .22308 L
.65102 .22823 L
Mistroke
.65105 .22964 L
.65115 .23369 L
.65118 .23529 L
.65121 .23682 L
.65123 .23671 L
.65126 .23611 L
.65128 .23577 L
.65129 .23541 L
.65132 .23373 L
.65136 .23063 L
.65139 .22723 L
.65151 .21745 L
.65154 .21257 L
.65157 .20726 L
.6516 .20274 L
.65163 .20124 L
.65166 .19978 L
.65168 .19842 L
.65171 .19828 L
.65174 .19922 L
.65177 .20025 L
.6518 .20056 L
.65181 .19995 L
.65183 .19929 L
.65186 .19808 L
.6519 .19652 L
.65193 .19438 L
.652 .18927 L
.65203 .18516 L
.65204 .183 L
.65206 .18071 L
.65208 .17937 L
.65209 .18036 L
.65212 .18212 L
.65215 .18383 L
.65218 .18633 L
.65224 .19239 L
.6523 .19752 L
.65233 .19954 L
.65235 .2007 L
.65237 .20119 L
.6524 .19992 L
.65243 .19856 L
.65248 .19594 L
.65252 .19441 L
.65255 .19296 L
.65256 .19298 L
.65258 .19366 L
.65261 .19485 L
.65263 .19554 L
Mistroke
.65265 .19613 L
.65266 .19345 L
.65268 .19051 L
.65272 .18481 L
.65273 .18232 L
.65275 .18031 L
.65278 .17852 L
.65281 .17681 L
.65287 .17307 L
.6529 .17137 L
.65293 .16956 L
.65296 .17054 L
.65298 .17181 L
.65311 .17812 L
.65317 .18119 L
.65318 .18201 L
.6532 .18288 L
.65322 .1837 L
.65323 .1825 L
.65326 .17954 L
.65329 .17639 L
.65331 .17475 L
.65333 .17497 L
.65336 .17797 L
.65339 .18079 L
.65342 .18327 L
.65345 .18311 L
.65347 .18297 L
.6535 .18282 L
.65353 .18101 L
.65356 .17812 L
.65358 .1755 L
.65361 .17371 L
.65364 .17458 L
.6537 .17649 L
.65394 .18156 L
.65406 .18506 L
.65408 .18534 L
.65409 .18599 L
.65411 .18681 L
.65413 .18756 L
.6542 .19091 L
.65423 .193 L
.65425 .19496 L
.65427 .19605 L
.65429 .19487 L
.65432 .19202 L
.65443 .17709 L
.65444 .17441 L
.65446 .17155 L
Mistroke
.65449 .17016 L
.65451 .1697 L
.65452 .16929 L
.65454 .1688 L
.65456 .16834 L
.65459 .17114 L
.65462 .17444 L
.65465 .17735 L
.65468 .1758 L
.65478 .1686 L
.65481 .1689 L
.65484 .16921 L
.65486 .16635 L
.65489 .16191 L
.65492 .15666 L
.65494 .15377 L
.65495 .15217 L
.65498 .15038 L
.65501 .14875 L
.65504 .14707 L
.65506 .14415 L
.65509 .14099 L
.65512 .13755 L
.65515 .13738 L
.65518 .13924 L
.65521 .14089 L
.65523 .14337 L
.65526 .14948 L
.6553 .15598 L
.65533 .16161 L
.65535 .16222 L
.65538 .1628 L
.65541 .16341 L
.65543 .16623 L
.65546 .17115 L
.65549 .17646 L
.65552 .18168 L
.65555 .18075 L
.65557 .17991 L
.6556 .1789 L
.65562 .17877 L
.65564 .17905 L
.6557 .18 L
.65571 .18018 L
.65573 .18008 L
.65576 .17991 L
.65578 .17981 L
.6558 .17972 L
.65581 .18037 L
.65583 .18175 L
Mistroke
.65589 .18707 L
.65595 .1916 L
.65598 .19379 L
.65601 .19459 L
.65604 .19443 L
.65607 .19428 L
.65631 .17672 L
.65634 .17688 L
.65635 .17697 L
.65637 .17706 L
.65639 .17638 L
.6564 .17518 L
.65644 .17305 L
.6565 .16801 L
.65653 .16542 L
.65656 .16259 L
.65659 .16438 L
.65662 .16702 L
.65665 .16999 L
.65668 .17147 L
.65671 .17165 L
.65674 .1718 L
.65677 .17262 L
.65678 .17383 L
.6568 .17496 L
.65691 .18126 L
.65694 .18248 L
.65697 .1845 L
.657 .18676 L
.65702 .18886 L
.65704 .1909 L
.65707 .18906 L
.6571 .18669 L
.65712 .18446 L
.65715 .18306 L
.65717 .18438 L
.6572 .18583 L
.65723 .18718 L
.65726 .18499 L
.65729 .18166 L
.65731 .17985 L
.65732 .17814 L
.65735 .17591 L
.65738 .17424 L
.65741 .17271 L
.65743 .17157 L
.65746 .17254 L
.65749 .17342 L
.65752 .17436 L
.65755 .17724 L
Mistroke
.65757 .18023 L
.6576 .18373 L
.65762 .18571 L
.65763 .18566 L
.65766 .18521 L
.65769 .18472 L
.65772 .18513 L
.65774 .18686 L
.65776 .18844 L
.65779 .19131 L
.65782 .19419 L
.65787 .19782 L
.6579 .1998 L
.65793 .19838 L
.65796 .19673 L
.65798 .19583 L
.658 .19499 L
.65802 .1923 L
.65805 .189 L
.65807 .18726 L
.65809 .18543 L
.65812 .18888 L
.65813 .19268 L
.65815 .19621 L
.65817 .20006 L
.65818 .20424 L
.65822 .20397 L
.65824 .20126 L
.65827 .19863 L
.6583 .19924 L
.65833 .20402 L
.65836 .20928 L
.65837 .21193 L
.65839 .21333 L
.65842 .21333 L
.65845 .21333 L
.65848 .21323 L
.65851 .20997 L
.65854 .2065 L
.65857 .20319 L
.6586 .20603 L
.65866 .21216 L
.6587 .21801 L
.65873 .22125 L
.65876 .22427 L
.65878 .22282 L
.65882 .21907 L
.65884 .21595 L
.65887 .21376 L
.6589 .21575 L
Mistroke
.65893 .21785 L
.65896 .22028 L
.65899 .22545 L
.65902 .23142 L
.65905 .23709 L
.65907 .23587 L
.65909 .23447 L
.65912 .23201 L
.65918 .22701 L
.65921 .22404 L
.65924 .22124 L
.65927 .2208 L
.6593 .22046 L
.65933 .22015 L
.65936 .22263 L
.65941 .22991 L
.65944 .234 L
.65946 .23486 L
.65949 .23584 L
.65952 .23677 L
.65955 .23665 L
.65958 .23573 L
.6596 .23476 L
.65963 .23406 L
.65966 .23422 L
.65969 .23439 L
.65972 .23454 L
.65975 .236 L
.65977 .23764 L
.6598 .23942 L
.65984 .2407 L
.65986 .24148 L
.65989 .24218 L
.65992 .24307 L
.65995 .24471 L
.65998 .24645 L
.66001 .24787 L
.66004 .24436 L
.66015 .23272 L
.66018 .2301 L
.6602 .22812 L
.66023 .23136 L
.66026 .23489 L
.66028 .23692 L
.66029 .23911 L
.66031 .2401 L
.66032 .2406 L
.66036 .24159 L
.66038 .24252 L
.66041 .24445 L
Mistroke
.66045 .24702 L
.66047 .24831 L
.66048 .24953 L
.6605 .25026 L
.66052 .25054 L
.66055 .251 L
.66058 .2515 L
.6606 .25361 L
.66063 .25675 L
.66066 .25988 L
.66069 .26395 L
.66072 .26979 L
.66076 .27522 L
.66077 .27787 L
.66079 .27835 L
.66082 .27786 L
.66084 .27743 L
.66087 .27712 L
.66091 .27848 L
.66094 .27993 L
.66097 .28119 L
.661 .28166 L
.66111 .28412 L
.66122 .28683 L
.66148 .29469 L
.66151 .29361 L
.66154 .29265 L
.66157 .29439 L
.6616 .29599 L
.66166 .29983 L
.66169 .30238 L
.66172 .30475 L
.66175 .30481 L
.66178 .30373 L
.66181 .30263 L
.66184 .30108 L
.66186 .29988 L
.66187 .29877 L
.6619 .29658 L
.66193 .29408 L
.66196 .28987 L
.66199 .28619 L
.66201 .28225 L
.66204 .28286 L
.66207 .28418 L
.66209 .28571 L
.66212 .28784 L
.66218 .29333 L
.66225 .29834 L
.66228 .30019 L
Mistroke
.66231 .30187 L
.66232 .30239 L
.66234 .30294 L
.66236 .30354 L
.66237 .30411 L
.66241 .30455 L
.66242 .30322 L
.66244 .3018 L
.66247 .29929 L
.66249 .29797 L
.6625 .29727 L
.66254 .29761 L
.66256 .29793 L
.66259 .29831 L
.66262 .30017 L
.66268 .30441 L
.66292 .33485 L
.66297 .34327 L
.66303 .35084 L
.66305 .35308 L
.66307 .35515 L
.66308 .35432 L
.6631 .35341 L
.66316 .35002 L
.66322 .35457 L
.66325 .35685 L
.66327 .35831 L
.6633 .35943 L
.66332 .36007 L
.66334 .36065 L
.66336 .36018 L
.66339 .35604 L
.6635 .3385 L
.66353 .33267 L
.66356 .32838 L
.66358 .32879 L
.66361 .32925 L
.66364 .32972 L
.66367 .33139 L
.6637 .33301 L
.66373 .33477 L
.66376 .33339 L
.66378 .33005 L
.66384 .32377 L
.6639 .31588 L
.66391 .31396 L
.66393 .31234 L
.66395 .31342 L
.66397 .31443 L
.66403 .31813 L
Mistroke
.66409 .32127 L
.66412 .32288 L
.66415 .32047 L
.66421 .31431 L
.66425 .31016 L
.66427 .30812 L
.66429 .30625 L
.66432 .30464 L
.66433 .30808 L
.66435 .31171 L
.66438 .31778 L
.66441 .32347 L
.66444 .32253 L
.66447 .32166 L
.66459 .31756 L
.66465 .30654 L
.66467 .30325 L
.66468 .29979 L
.66472 .29859 L
.66474 .29906 L
.66477 .29949 L
.6648 .30106 L
.66483 .30447 L
.66489 .31147 L
.66495 .31915 L
.66497 .32128 L
.66499 .32271 L
.66501 .32313 L
.66502 .32351 L
.66505 .32417 L
.66507 .32455 L
.66509 .32399 L
.66512 .3226 L
.66515 .32109 L
.66518 .31918 L
.6652 .31579 L
.66531 .30212 L
.66555 .27434 L
.66599 .22503 L
.66602 .22519 L
.66606 .22242 L
.66609 .21847 L
.66612 .21483 L
.66618 .20644 L
.66624 .19889 L
.66627 .19573 L
.66629 .19274 L
.66632 .19051 L
.66635 .19251 L
.66641 .19711 L
Mistroke
.66647 .20056 L
.66649 .2021 L
.66652 .20311 L
.66655 .20344 L
.66658 .20373 L
.66661 .20346 L
.66664 .20026 L
.66667 .19653 L
.6667 .1931 L
.66673 .19212 L
.66676 .19106 L
.66679 .1901 L
.66682 .1868 L
.66685 .18267 L
.66688 .17881 L
.66691 .17832 L
.66693 .17886 L
.66695 .17944 L
.66698 .1804 L
.667 .17937 L
.66703 .17709 L
.66705 .17592 L
.66707 .17466 L
.6671 .17123 L
.66713 .16688 L
.66715 .16268 L
.66718 .15903 L
.6672 .16014 L
.66723 .16136 L
.66726 .16255 L
.66729 .16294 L
.66732 .16265 L
.66734 .16237 L
.66736 .16212 L
.66739 .16278 L
.66742 .16372 L
.66745 .16461 L
.66748 .16672 L
.66751 .16986 L
.66753 .17262 L
.66756 .17554 L
.66759 .1757 L
.66762 .17585 L
.66763 .17593 L
.66765 .17602 L
.66767 .17748 L
.66768 .17957 L
.66772 .18366 L
.66775 .18748 L
.66777 .18949 L
Mistroke
.6678 .1914 L
.66782 .19249 L
.66784 .19352 L
.66787 .19396 L
.6679 .19364 L
.66791 .19346 L
.66793 .1933 L
.66794 .19324 L
.66796 .19456 L
.66799 .19693 L
.66802 .19916 L
.66805 .20044 L
.66808 .2006 L
.66811 .20076 L
.66812 .20085 L
.66814 .20211 L
.66816 .20449 L
.66817 .20668 L
.66821 .2111 L
.66824 .21426 L
.66827 .21375 L
.66829 .21346 L
.6683 .21319 L
.66832 .21291 L
.66834 .21225 L
.66837 .21028 L
.6684 .20865 L
.66842 .20773 L
.66843 .20897 L
.66846 .2117 L
.66849 .2147 L
.66852 .21697 L
.66855 .21711 L
.66857 .21726 L
.6686 .21742 L
.66862 .21874 L
.66863 .22124 L
.66866 .22615 L
.66869 .23062 L
.66872 .23206 L
.66875 .23005 L
.66878 .22817 L
.6688 .22709 L
.66881 .2277 L
.66883 .22916 L
.66885 .2307 L
.66888 .23306 L
.6689 .23497 L
.66893 .23384 L
.66896 .23282 L
Mistroke
.66898 .23185 L
.66901 .23165 L
.66903 .23206 L
.66906 .2325 L
.66909 .23295 L
.66912 .23486 L
.66917 .23861 L
.6692 .24054 L
.66923 .24204 L
.66926 .24339 L
.66929 .24334 L
.66932 .24019 L
.66935 .2373 L
.66938 .23412 L
.66941 .2394 L
.66943 .24423 L
.66946 .2488 L
.66949 .25228 L
.66952 .25416 L
.66958 .25844 L
.66963 .26218 L
.66976 .26934 L
.66983 .27617 L
.66984 .27814 L
.66986 .28043 L
.66989 .28737 L
.66992 .29344 L
.66995 .29992 L
.66996 .30046 L
.66998 .30005 L
.67001 .29924 L
.67007 .29786 L
.6701 .29732 L
.67013 .29682 L
.67015 .29663 L
.67017 .29653 L
.6702 .29634 L
.67027 .29598 L
.6703 .29581 L
.67033 .29564 L
.67036 .29811 L
.67039 .30102 L
.67045 .30627 L
.67049 .3083 L
.6705 .3093 L
.67052 .31021 L
.67054 .30889 L
.67057 .30631 L
.6706 .30369 L
.67062 .30232 L
Mistroke
.67064 .30198 L
.67069 .30081 L
.67072 .30033 L
.67075 .30065 L
.67078 .30095 L
.67081 .30127 L
.67082 .30099 L
.67084 .30045 L
.67087 .29948 L
.6709 .29857 L
.67093 .29822 L
.67096 .29822 L
.67098 .29822 L
.67101 .2979 L
.67103 .29641 L
.67106 .29464 L
.67109 .29304 L
.67112 .29391 L
.67114 .29588 L
.67117 .29813 L
.67119 .30019 L
.67122 .30058 L
.67125 .30091 L
.67128 .30121 L
.6713 .30048 L
.67134 .29883 L
.67136 .2973 L
.67139 .29678 L
.67141 .2978 L
.67143 .29892 L
.67146 .30098 L
.67149 .3026 L
.67151 .30305 L
.67152 .30354 L
.67156 .3044 L
.67159 .30379 L
.6716 .30178 L
.67162 .29996 L
.67168 .29343 L
.67189 .26986 L
.67194 .26335 L
.67197 .26047 L
.672 .25858 L
.67203 .25634 L
.67206 .25462 L
.67209 .25417 L
.67212 .25368 L
.67218 .25253 L
.67221 .25181 L
.67224 .25114 L
Mistroke
.67227 .25235 L
.6723 .25374 L
.67236 .25681 L
.67247 .26303 L
.67249 .26505 L
.67252 .26697 L
.67255 .26826 L
.67258 .26903 L
.67261 .26988 L
.67263 .26968 L
.67265 .2671 L
.67271 .25745 L
.67277 .24945 L
.67281 .24568 L
.67283 .24399 L
.67284 .24306 L
.67287 .24143 L
.6729 .23987 L
.67293 .24159 L
.67296 .2464 L
.67299 .25168 L
.67301 .25463 L
.67302 .25472 L
.67305 .25337 L
.67308 .2521 L
.67332 .24059 L
.67345 .23411 L
.67346 .23193 L
.67348 .22957 L
.67351 .22869 L
.67354 .22918 L
.67356 .22962 L
.67359 .22981 L
.67361 .22953 L
.67364 .22923 L
.67367 .22896 L
.67369 .23124 L
.67372 .23521 L
.67375 .23868 L
.67378 .24165 L
.6738 .24074 L
.67383 .2399 L
.67386 .23889 L
.67389 .24083 L
.67395 .24634 L
.67396 .24785 L
.67398 .24874 L
.67401 .2502 L
.67404 .25172 L
.67407 .25228 L
Mistroke
.6741 .25126 L
.67413 .25016 L
.67416 .24907 L
.67417 .24933 L
.67419 .24961 L
.67422 .25011 L
.67425 .25058 L
.67428 .2506 L
.6743 .2506 L
.67433 .2506 L
.67436 .24929 L
.67439 .24725 L
.67442 .24506 L
.67447 .24162 L
.6745 .23975 L
.67452 .23872 L
.67454 .23774 L
.67455 .23893 L
.67457 .24046 L
.6746 .24316 L
.67466 .24842 L
.6747 .25101 L
.67471 .25214 L
.67473 .25288 L
.67476 .24901 L
.67479 .24537 L
.67481 .24334 L
.67482 .24112 L
.67485 .2336 L
.67488 .22711 L
.67491 .22014 L
.67494 .21641 L
.67497 .21435 L
.675 .21213 L
.67502 .21155 L
.67504 .21245 L
.67507 .21406 L
.67508 .21492 L
.6751 .21584 L
.67513 .21603 L
.67516 .21543 L
.67519 .21475 L
.67522 .21483 L
.67523 .21549 L
.67525 .2162 L
.67528 .21748 L
.6753 .21827 L
.67531 .21774 L
.67533 .21673 L
.67535 .21564 L
Mistroke
.67538 .2134 L
.6754 .21224 L
.67542 .20944 L
.67548 .19985 L
.6756 .18642 L
.67564 .18267 L
.67565 .18083 L
.67567 .17912 L
.6757 .17998 L
.67572 .18235 L
.67573 .18488 L
.67576 .1895 L
.67578 .1921 L
.6758 .19227 L
.67582 .19258 L
.67585 .19292 L
.67588 .19205 L
.67591 .18839 L
.67594 .18459 L
.67597 .18039 L
.676 .18009 L
.67601 .18036 L
.67603 .18062 L
.67606 .18107 L
.67609 .17991 L
.6761 .17887 L
.67612 .17774 L
.67616 .17546 L
.67619 .17264 L
.67622 .16992 L
.67625 .16712 L
.67628 .16664 L
.67631 .1673 L
.67632 .16764 L
.67634 .16802 L
.67637 .17026 L
.6764 .17391 L
.67643 .17705 L
.67646 .1791 L
.67649 .17651 L
.67651 .17406 L
.67657 .16983 L
.6766 .16772 L
.67661 .16656 L
.67663 .16547 L
.67666 .16415 L
.67669 .16317 L
.67674 .16153 L
.67679 .1598 L
.67682 .1589 L
Mistroke
.67685 .16001 L
.67688 .16257 L
.6769 .16495 L
.67693 .1674 L
.67695 .16782 L
.67696 .16828 L
.677 .1691 L
.67702 .16983 L
.67704 .1681 L
.67706 .16646 L
.67709 .16285 L
.67715 .15612 L
.67718 .15302 L
.67721 .14971 L
.67724 .15012 L
.67727 .15054 L
.6773 .15104 L
.67732 .15117 L
.67733 .15108 L
.67736 .15093 L
.67739 .15076 L
.67742 .15325 L
.67745 .15755 L
.67747 .16192 L
.6775 .16596 L
.67752 .16826 L
.67755 .17023 L
.67758 .17198 L
.67761 .17266 L
.67764 .17207 L
.67767 .17143 L
.67769 .17093 L
.67772 .17162 L
.67784 .17487 L
.67879 .2078 L
.67971 .23648 L
.67977 .24248 L
.6798 .24467 L
.67982 .24401 L
.67983 .24339 L
.6799 .24079 L
.67994 .2397 L
.67996 .23916 L
.67997 .23867 L
.68 .23657 L
.68002 .23486 L
.68003 .23303 L
.68006 .23005 L
.68009 .22827 L
.68011 .22915 L
Mistroke
.68012 .22996 L
.68016 .23155 L
.68019 .23345 L
.68022 .23634 L
.68033 .25007 L
.6804 .2589 L
.68046 .26706 L
.68051 .27272 L
.68055 .27582 L
.68058 .27681 L
.6806 .27654 L
.68063 .27625 L
.68066 .27612 L
.68068 .27915 L
.68071 .2823 L
.68074 .28573 L
.68077 .28775 L
.6808 .28904 L
.68082 .2903 L
.68085 .29148 L
.68087 .28669 L
.6809 .28232 L
.68093 .27744 L
.68096 .27567 L
.68098 .27692 L
.68101 .27829 L
.68104 .27997 L
.68106 .28179 L
.68107 .28345 L
.6811 .28644 L
.68113 .28974 L
.68116 .29118 L
.68119 .29258 L
.68122 .29387 L
.68125 .29636 L
.68132 .30303 L
.68135 .30539 L
.68138 .30788 L
.68141 .31008 L
.68144 .31011 L
.68147 .30934 L
.6815 .30852 L
.68153 .3077 L
.68156 .30702 L
.68159 .3064 L
.68162 .30703 L
.68165 .30975 L
.68168 .31223 L
.68171 .31464 L
.68174 .31335 L
Mistroke
.68177 .31216 L
.68179 .31104 L
.68182 .31031 L
.68185 .30987 L
.68188 .30938 L
.6819 .30911 L
.68191 .31072 L
.68197 .31728 L
.682 .32033 L
.68202 .32125 L
.68203 .32212 L
.6821 .32585 L
.68213 .32791 L
.68215 .32899 L
.68216 .33014 L
.68218 .33114 L
.6822 .3295 L
.68223 .32545 L
.68226 .32153 L
.68229 .31836 L
.68232 .3182 L
.68234 .31806 L
.68237 .31794 L
.68239 .32023 L
.68241 .32234 L
.68244 .32615 L
.68245 .32817 L
.68247 .3303 L
.68249 .32828 L
.6825 .3264 L
.68254 .32228 L
.68257 .31898 L
.6826 .31628 L
.68262 .31499 L
.68264 .31362 L
.68267 .31299 L
.6827 .31879 L
.68273 .3252 L
.68276 .33088 L
.68279 .3321 L
.68281 .33287 L
.68284 .33358 L
.6829 .33508 L
.68292 .33581 L
.68295 .33648 L
.68297 .33391 L
.683 .3309 L
.68306 .3246 L
.68318 .31474 L
.6832 .31412 L
Mistroke
.68322 .31347 L
.68325 .31172 L
.68326 .31024 L
.68328 .30889 L
.6833 .30727 L
.68332 .30577 L
.68335 .3041 L
.68336 .30375 L
.68338 .30337 L
.6834 .30302 L
.68341 .30268 L
.68344 .30275 L
.68347 .30353 L
.6835 .30426 L
.68353 .30483 L
.68356 .30382 L
.68447 .26993 L
.68453 .27377 L
.68455 .2755 L
.68456 .27737 L
.68459 .27733 L
.68461 .27629 L
.68463 .27533 L
.68466 .27311 L
.6847 .27046 L
.68473 .26755 L
.68479 .26009 L
.68483 .25459 L
.68484 .25189 L
.68486 .2494 L
.68489 .248 L
.68492 .24677 L
.68495 .24573 L
.68498 .24644 L
.685 .24773 L
.68503 .2491 L
.68506 .24939 L
.68508 .24688 L
.68514 .24068 L
.6852 .23577 L
.68523 .23327 L
.68526 .23357 L
.68528 .23537 L
.68529 .23706 L
.68532 .24023 L
.68535 .24141 L
.68538 .24068 L
.68541 .23987 L
.68544 .24003 L
.68547 .2436 L
Mistroke
.6855 .24699 L
.68552 .25002 L
.68555 .24838 L
.68558 .24546 L
.68561 .24236 L
.68567 .23827 L
.6857 .23661 L
.68572 .2353 L
.68575 .23699 L
.68577 .23853 L
.6858 .24033 L
.68583 .24027 L
.68586 .23841 L
.68589 .23669 L
.68595 .23018 L
.68598 .22567 L
.68599 .22321 L
.68601 .22112 L
.68604 .22173 L
.68607 .22241 L
.68609 .22298 L
.68612 .21853 L
.68616 .2103 L
.68619 .2025 L
.68622 .19736 L
.68626 .19237 L
.68631 .1845 L
.68634 .18137 L
.68636 .17966 L
.68638 .17808 L
.6864 .17665 L
.68644 .17682 L
.68646 .17697 L
.68649 .17733 L
.68652 .17844 L
.68655 .17949 L
.6866 .1822 L
.68666 .18697 L
.6867 .19038 L
.68673 .19492 L
.68676 .19879 L
.68678 .20022 L
.68679 .19964 L
.68685 .19747 L
.68697 .19048 L
.687 .18877 L
.68703 .18694 L
.68705 .18605 L
.68706 .18556 L
.68709 .18744 L
Mistroke
.68712 .18948 L
.68714 .1906 L
.68716 .19162 L
.68717 .19238 L
.68719 .1932 L
.68721 .19395 L
.68723 .19466 L
.68724 .19533 L
.68726 .1956 L
.68729 .19512 L
.68735 .19434 L
.68741 .19556 L
.68744 .19624 L
.68747 .19281 L
.6875 .18953 L
.68752 .18648 L
.68755 .1845 L
.68758 .1837 L
.6876 .18328 L
.68761 .18282 L
.68764 .18271 L
.68767 .18401 L
.6877 .18521 L
.68783 .19133 L
.68786 .19269 L
.68789 .19398 L
.68791 .19469 L
.68793 .19622 L
.68796 .20146 L
.68799 .20645 L
.68802 .21101 L
.68805 .20858 L
.68808 .20637 L
.6882 .19872 L
.68826 .19091 L
.68828 .18861 L
.6883 .18616 L
.68832 .18813 L
.68834 .19044 L
.68836 .19454 L
.6884 .19898 L
.68843 .19759 L
.68845 .1958 L
.68851 .19157 L
.68854 .18885 L
.68856 .18735 L
.68858 .18593 L
.68861 .18468 L
.68863 .18439 L
.68866 .18412 L
Mistroke
.68868 .18383 L
.68871 .18175 L
.68874 .17976 L
.68877 .17756 L
.6888 .17629 L
.68882 .17602 L
.68883 .17574 L
.68886 .17523 L
.68888 .17515 L
.6889 .17565 L
.68893 .17657 L
.68895 .17701 L
.68897 .1775 L
.68899 .17905 L
.689 .18082 L
.68906 .18774 L
.68912 .19918 L
.68915 .20579 L
.68918 .20912 L
.68921 .20895 L
.68922 .20885 L
.68924 .20877 L
.68927 .20945 L
.6893 .21175 L
.68933 .21385 L
.68936 .216 L
.68937 .21667 L
.68939 .2174 L
.68942 .21868 L
.68945 .2199 L
.68948 .21948 L
.6895 .21887 L
.68953 .21831 L
.68956 .2186 L
.68958 .21986 L
.68964 .22269 L
.68969 .22518 L
.68972 .22648 L
.68975 .22823 L
.68978 .23097 L
.68981 .23349 L
.68984 .23454 L
.68986 .23365 L
.68987 .23281 L
.6899 .23128 L
.68993 .22992 L
.68996 .23076 L
.68999 .23152 L
.69002 .23236 L
.69003 .23164 L
Mistroke
.69005 .23034 L
.69008 .22801 L
.69011 .22587 L
.69013 .22589 L
.69014 .22736 L
.69018 .23043 L
.69021 .23309 L
.69023 .23195 L
.69024 .22993 L
.69027 .22609 L
.69029 .22399 L
.69031 .22202 L
.69033 .22387 L
.69036 .22668 L
.69038 .22825 L
.6904 .22974 L
.69043 .22878 L
.69045 .22758 L
.69046 .22647 L
.6905 .22396 L
.69074 .20884 L
.69079 .2022 L
.69082 .19914 L
.69085 .19591 L
.69087 .19307 L
.6909 .19327 L
.69093 .19482 L
.69095 .19626 L
.69098 .19801 L
.691 .20086 L
.69103 .20418 L
.69106 .20725 L
.69109 .20792 L
.69111 .20725 L
.69112 .20653 L
.69115 .20521 L
.69118 .20419 L
.69121 .20341 L
.69124 .20255 L
.69127 .20248 L
.6913 .20551 L
.69133 .2085 L
.69136 .21131 L
.69138 .21123 L
.69141 .21051 L
.69144 .20971 L
.69145 .20926 L
.69147 .20995 L
.6915 .21198 L
.69154 .21383 L
Mistroke
.69156 .2163 L
.69159 .21971 L
.69162 .22329 L
.69165 .22696 L
.69168 .22828 L
.6917 .22953 L
.69173 .23084 L
.69176 .23117 L
.69181 .23038 L
.69184 .22994 L
.69186 .23209 L
.69189 .23507 L
.69192 .23777 L
.69195 .23865 L
.69198 .23745 L
.69201 .23643 L
.69204 .23607 L
.69207 .23802 L
.69209 .23982 L
.69212 .2418 L
.69215 .24293 L
.69218 .24382 L
.69221 .24464 L
.69224 .24933 L
.69227 .25536 L
.6923 .26084 L
.69233 .26527 L
.69234 .26638 L
.69236 .2676 L
.69239 .26975 L
.69241 .27096 L
.69243 .27079 L
.69244 .27013 L
.69246 .26953 L
.69249 .2684 L
.69251 .26776 L
.69252 .26877 L
.69258 .27355 L
.69263 .27739 L
.69266 .27937 L
.69269 .28125 L
.69272 .2801 L
.69275 .27682 L
.69277 .27376 L
.6928 .27262 L
.69283 .2778 L
.69286 .28251 L
.69288 .28511 L
.69289 .28743 L
.69293 .28809 L
Mistroke
.69295 .2887 L
.69298 .28936 L
.69301 .2897 L
.69304 .28999 L
.69307 .29028 L
.69309 .28873 L
.69312 .28512 L
.69315 .28177 L
.69318 .27815 L
.69321 .27803 L
.69322 .27803 L
.69324 .27803 L
.69327 .27803 L
.6933 .27901 L
.69333 .28024 L
.69335 .28086 L
.69336 .28152 L
.6934 .28075 L
.69351 .27775 L
.69354 .2773 L
.69357 .27722 L
.69358 .27754 L
.6936 .27791 L
.69363 .27854 L
.69366 .2788 L
.69369 .27654 L
.69374 .27246 L
.6938 .26799 L
.69382 .26577 L
.69385 .26442 L
.69387 .26641 L
.6939 .26853 L
.69392 .27088 L
.69395 .27129 L
.69398 .26736 L
.69401 .26369 L
.69403 .25966 L
.69407 .26069 L
.6941 .26214 L
.69413 .26351 L
.69416 .25753 L
.69419 .25085 L
.69422 .24459 L
.69425 .24078 L
.69427 .23771 L
.69431 .23433 L
.69433 .23332 L
.69436 .23545 L
.69439 .23797 L
.69441 .24026 L
Mistroke
.69444 .23899 L
.69447 .23662 L
.69453 .23262 L
.69456 .23077 L
.69458 .22979 L
.69459 .22876 L
.69461 .22786 L
.69463 .22764 L
.69466 .22732 L
.69467 .22714 L
.69469 .22696 L
.69472 .22457 L
.69474 .22198 L
.69475 .21957 L
.69477 .21677 L
.69479 .21413 L
.69482 .21309 L
.69485 .21464 L
.69491 .21722 L
.69502 .2205 L
.69506 .22248 L
.69509 .22417 L
.69512 .22386 L
.69515 .22353 L
.69516 .22336 L
.69518 .22318 L
.69521 .22031 L
.69528 .21351 L
.6954 .20456 L
.69563 .19041 L
.69565 .18478 L
.69568 .18228 L
.69571 .18065 L
.69573 .17917 L
.69579 .17576 L
.69581 .17422 L
.69584 .17259 L
.69587 .17144 L
.6959 .17071 L
.69596 .1687 L
.69601 .16496 L
.69604 .16287 L
.69607 .16488 L
.6961 .16789 L
.69613 .17074 L
.69615 .17272 L
.69618 .17431 L
.69621 .17605 L
.69623 .17693 L
.69625 .17589 L
Mistroke
.69631 .17093 L
.69642 .15965 L
.69645 .15679 L
.69648 .15389 L
.69651 .15141 L
.69654 .15121 L
.69656 .15303 L
.69659 .15468 L
.69665 .15771 L
.69667 .15879 L
.6967 .15997 L
.69673 .15835 L
.69675 .15436 L
.69678 .14933 L
.69681 .14456 L
.69683 .14488 L
.69686 .14533 L
.69689 .14581 L
.69691 .14598 L
.69692 .14573 L
.69695 .14523 L
.69698 .14478 L
.69701 .14373 L
.69704 .14102 L
.6971 .13532 L
.69715 .1302 L
.69717 .12797 L
.6972 .12665 L
.69723 .12764 L
.69726 .12857 L
.69728 .12909 L
.69729 .12921 L
.69732 .12773 L
.69735 .12647 L
.69738 .1251 L
.69741 .12818 L
.69744 .13212 L
.69747 .1364 L
.69749 .13784 L
.6975 .13802 L
.69754 .13841 L
.69756 .13858 L
.69757 .13877 L
.6976 .13721 L
.69763 .13564 L
.69765 .13477 L
.69767 .13384 L
.6977 .13432 L
.69772 .13505 L
.69775 .13583 L
Mistroke
.69778 .13629 L
.69781 .13645 L
.69784 .13659 L
.69787 .13679 L
.6979 .13727 L
.69792 .13773 L
.69794 .138 L
.69796 .13826 L
.69797 .13592 L
.69799 .13325 L
.69802 .12845 L
.69805 .12409 L
.69808 .12233 L
.69811 .12085 L
.69814 .11929 L
.69817 .11572 L
.6982 .1114 L
.69823 .10675 L
.69825 .10337 L
.69828 .10268 L
.69834 .10115 L
.69837 .10043 L
.6984 .09978 L
.69842 .09923 L
.69845 .09785 L
.69848 .0953 L
.69851 .09298 L
.69853 .09079 L
.69856 .09106 L
.69858 .09148 L
.69861 .09187 L
.69864 .09332 L
.69867 .09644 L
.69869 .09928 L
.69872 .10229 L
.69875 .10391 L
.69878 .10527 L
.69881 .10675 L
.69883 .10742 L
.69884 .10784 L
.69887 .10855 L
.6989 .10929 L
.69892 .10942 L
.69895 .10756 L
.69897 .10554 L
.69901 .10338 L
.69903 .1056 L
.69906 .10831 L
.69909 .11151 L
.69911 .11287 L
Mistroke
.69912 .11259 L
.69916 .11209 L
.69918 .11163 L
.6992 .11136 L
.69922 .1105 L
.69925 .10857 L
.69928 .10691 L
.6993 .10648 L
.69932 .10779 L
.69935 .11014 L
.69938 .11268 L
.69941 .11455 L
.69943 .11572 L
.69946 .1171 L
.69948 .1178 L
.6995 .11778 L
.69953 .11695 L
.69956 .11618 L
.69959 .11582 L
.6996 .11682 L
.69962 .11792 L
.69965 .1199 L
.69968 .1217 L
.69969 .12025 L
.69971 .11888 L
.69975 .11584 L
.69978 .1137 L
.69979 .11575 L
.69981 .11765 L
.69984 .12136 L
.69987 .12482 L
.6999 .12539 L
.69992 .12601 L
.69998 .12727 L
.70001 .12795 L
.70003 .12831 L
.70005 .12866 L
.70008 .13008 L
.70011 .1319 L
.70016 .13546 L
.70019 .13741 L
.70022 .13948 L
.70025 .14125 L
.70028 .14183 L
.70031 .14225 L
.70033 .14269 L
.70036 .1428 L
.70038 .14254 L
.70041 .14224 L
.70044 .14196 L
Mistroke
.70046 .14212 L
.70049 .14244 L
.70052 .14277 L
.70054 .14306 L
.70056 .1449 L
.70062 .15121 L
.70063 .15303 L
.70065 .15409 L
.70067 .15518 L
.70068 .15618 L
.70075 .16111 L
.70081 .16892 L
.70087 .17822 L
.7009 .18294 L
.70093 .18504 L
.70096 .18276 L
.70099 .18031 L
.7012 .16526 L
.70126 .16027 L
.70129 .15768 L
.7013 .1565 L
.70132 .15744 L
.70135 .15908 L
.70137 .16064 L
.7014 .1635 L
.70143 .17004 L
.70155 .18892 L
.70158 .19094 L
.70161 .19756 L
.70166 .21291 L
.70169 .2192 L
.70172 .22016 L
.70178 .22209 L
.70182 .21944 L
.70183 .21814 L
.70185 .21693 L
.70188 .21564 L
.70189 .22034 L
.70191 .22531 L
.70194 .23367 L
.70197 .24265 L
.702 .2483 L
.70202 .25303 L
.70205 .25802 L
.70208 .26229 L
.70209 .26354 L
.70211 .2647 L
.70214 .267 L
.70235 .2811 L
.70246 .2817 L
Mistroke
.70251 .28199 L
.70254 .28215 L
.70257 .2842 L
.7026 .28682 L
.70263 .28929 L
.70264 .29093 L
.70266 .29436 L
.70269 .30035 L
.70272 .30599 L
.70275 .31069 L
.70277 .31304 L
.7028 .31562 L
.70306 .34615 L
.7033 .37996 L
.70336 .3902 L
.70339 .39601 L
.7034 .39913 L
.70342 .39818 L
.70345 .39629 L
.70348 .39451 L
.70351 .3933 L
.70354 .39282 L
.70357 .39234 L
.7036 .39192 L
.70362 .39223 L
.70366 .39257 L
.70368 .39286 L
.70371 .39356 L
.70376 .39565 L
.70379 .39672 L
.70381 .39706 L
.70383 .39744 L
.70386 .3981 L
.70389 .39816 L
.7039 .39593 L
.70392 .39358 L
.70395 .38939 L
.70398 .38507 L
.70402 .38158 L
.70405 .3785 L
.70408 .37774 L
.70411 .38338 L
.70414 .3887 L
.7042 .39937 L
.70423 .40356 L
.70426 .40739 L
.70429 .4095 L
.70432 .41149 L
.70435 .41359 L
.70438 .41215 L
Mistroke
.70441 .40713 L
.70444 .40179 L
.7045 .39038 L
.70453 .38377 L
.70455 .38005 L
.70456 .37964 L
.7046 .37997 L
.70461 .38014 L
.70463 .38032 L
.70466 .37981 L
.70468 .37791 L
.70475 .3735 L
.70519 .35046 L
.70525 .3583 L
.70528 .36381 L
.70531 .36905 L
.70534 .36598 L
.70537 .36002 L
.70539 .35454 L
.70542 .3505 L
.70545 .34747 L
.70548 .34424 L
.70551 .34184 L
.70554 .34273 L
.70557 .34371 L
.7056 .34475 L
.70562 .34225 L
.70563 .3391 L
.70567 .33356 L
.70573 .32195 L
.7058 .3101 L
.70584 .30574 L
.70586 .3036 L
.70587 .30161 L
.7059 .29928 L
.70592 .29877 L
.70593 .29823 L
.70618 .29207 L
.7063 .30494 L
.70633 .30784 L
.70636 .31094 L
.70638 .31184 L
.70639 .3121 L
.70642 .3126 L
.70644 .31286 L
.70645 .31314 L
.70647 .31204 L
.70649 .31046 L
.70656 .30448 L
.70661 .29678 L
Mistroke
.70663 .29475 L
.70665 .29253 L
.70668 .2904 L
.70671 .28855 L
.70674 .28684 L
.70676 .28565 L
.70679 .28458 L
.70682 .28348 L
.70685 .28259 L
.70687 .28219 L
.7069 .28176 L
.70693 .28128 L
.70695 .27999 L
.70696 .27773 L
.70699 .27278 L
.70703 .26828 L
.70705 .2667 L
.70708 .26611 L
.70711 .26548 L
.70714 .26424 L
.70805 .21747 L
.70903 .16256 L
.70926 .14447 L
.7093 .14049 L
.70933 .1368 L
.70934 .13608 L
.70936 .13536 L
.7094 .13385 L
.70941 .13318 L
.70943 .13262 L
.70946 .13312 L
.70952 .13405 L
.70957 .13495 L
.7096 .13546 L
.70963 .13686 L
.70966 .13918 L
.70969 .1413 L
.70971 .14247 L
.70972 .14098 L
.70975 .13546 L
.70978 .13038 L
.70981 .12584 L
.70984 .12584 L
.70987 .12584 L
.70989 .12584 L
.70992 .12517 L
.70995 .12402 L
.70997 .1228 L
.71 .12193 L
.71003 .12357 L
Mistroke
.71008 .12662 L
.71014 .13021 L
.71017 .1318 L
.7102 .13297 L
.71022 .13256 L
.71025 .13218 L
.71027 .13177 L
.7103 .13387 L
.71033 .13934 L
.71035 .14454 L
.71038 .1492 L
.71041 .15126 L
.71044 .15335 L
.71047 .15532 L
.7105 .15373 L
.71053 .15038 L
.71056 .14672 L
.71057 .14506 L
.71059 .14621 L
.71065 .15015 L
.71088 .16738 L
.71091 .17199 L
.71094 .17688 L
.71096 .17925 L
.71098 .18012 L
.71101 .18166 L
.71103 .18303 L
.71106 .1849 L
.7111 .18752 L
.71113 .18993 L
.71115 .19128 L
.71118 .19027 L
.71121 .18908 L
.71124 .18799 L
.71127 .18528 L
.71129 .18267 L
.71132 .17991 L
.71135 .17927 L
.71138 .18203 L
.71141 .18504 L
.71144 .18762 L
.71147 .18864 L
.7115 .18983 L
.71151 .19049 L
.71153 .19093 L
.71156 .18638 L
.71159 .18226 L
.71161 .17983 L
.71162 .17727 L
.71165 .17676 L
Mistroke
.71167 .17657 L
.71169 .17637 L
.71171 .17618 L
.71173 .17559 L
.71176 .17274 L
.71179 .17004 L
.7118 .16862 L
.71182 .16726 L
.71184 .16726 L
.71185 .16726 L
.71188 .16726 L
.71191 .16726 L
.71194 .16929 L
.71197 .17133 L
.712 .17324 L
.71202 .17319 L
.71205 .17169 L
.71208 .17009 L
.7121 .16924 L
.71211 .16862 L
.71213 .16822 L
.71215 .16786 L
.71221 .16641 L
.71227 .16487 L
.71228 .16445 L
.7123 .16424 L
.71233 .16473 L
.71236 .16524 L
.71238 .16552 L
.71239 .16568 L
.71241 .16558 L
.71243 .16548 L
.71245 .16539 L
.71247 .16529 L
.71248 .16521 L
.7125 .16498 L
.71253 .1645 L
.71254 .16423 L
.71256 .16394 L
.71258 .16367 L
.71259 .167 L
.71265 .18213 L
.71267 .18627 L
.71269 .18813 L
.71272 .18864 L
.71274 .18908 L
.71277 .18933 L
.71281 .1864 L
.71284 .18366 L
.71285 .18214 L
Mistroke
.71287 .18072 L
.7129 .18356 L
.71293 .18687 L
.71296 .18991 L
.71299 .18932 L
.71302 .18854 L
.71303 .1881 L
.71305 .18768 L
.71308 .18722 L
.71311 .18688 L
.71313 .18669 L
.71314 .18651 L
.71317 .18928 L
.71319 .19153 L
.7132 .19393 L
.71324 .19858 L
.71325 .20059 L
.71327 .20121 L
.71331 .20264 L
.71334 .20397 L
.71346 .20974 L
.7135 .21125 L
.71352 .21199 L
.71353 .21267 L
.71356 .21781 L
.71359 .22387 L
.71362 .22915 L
.71365 .23093 L
.71368 .23093 L
.71371 .23093 L
.71372 .23093 L
.71374 .22969 L
.71377 .22672 L
.71383 .22137 L
.71394 .21417 L
.71397 .21058 L
.71399 .20868 L
.714 .20669 L
.71403 .20475 L
.71406 .20368 L
.71409 .2026 L
.71412 .20257 L
.71415 .2046 L
.71418 .20678 L
.71423 .21087 L
.71425 .2128 L
.71428 .21493 L
.71431 .21657 L
.71433 .21676 L
.71435 .21693 L
Mistroke
.71436 .21712 L
.71438 .21729 L
.7144 .21721 L
.71441 .21562 L
.71444 .21291 L
.71448 .21003 L
.71449 .20907 L
.71451 .21111 L
.71454 .21508 L
.71457 .21864 L
.7146 .22065 L
.71462 .22074 L
.71463 .22083 L
.71466 .22099 L
.71469 .22168 L
.71472 .22335 L
.71478 .22614 L
.71481 .22391 L
.71484 .2215 L
.71487 .21922 L
.7149 .21929 L
.71493 .2196 L
.71496 .21994 L
.71499 .22139 L
.71502 .22363 L
.71509 .22727 L
.71513 .2284 L
.71516 .22975 L
.71519 .23645 L
.71522 .24277 L
.71529 .25396 L
.71577 .31158 L
.7158 .31626 L
.71583 .32059 L
.71585 .32177 L
.71586 .32306 L
.71589 .32533 L
.71592 .32748 L
.71595 .33489 L
.71598 .34183 L
.71601 .34933 L
.71602 .35299 L
.71604 .35232 L
.71607 .35103 L
.7161 .34977 L
.71612 .34908 L
.71615 .34957 L
.71617 .34985 L
.71619 .35011 L
.7162 .35038 L
Mistroke
.71622 .35114 L
.71623 .35248 L
.71625 .35394 L
.71628 .35602 L
.71631 .35826 L
.71634 .36301 L
.71636 .36747 L
.71639 .37222 L
.71643 .37097 L
.71645 .36847 L
.71648 .36575 L
.71651 .3644 L
.71654 .36426 L
.71657 .36411 L
.71659 .36382 L
.71662 .36062 L
.71664 .35768 L
.71667 .3545 L
.7167 .35267 L
.71673 .35495 L
.71675 .35711 L
.71678 .35921 L
.71681 .35731 L
.71684 .35487 L
.71687 .35258 L
.7169 .35181 L
.71691 .35206 L
.71693 .35234 L
.71696 .3528 L
.71698 .35359 L
.71701 .3551 L
.71704 .35675 L
.71707 .35819 L
.71709 .35655 L
.71715 .35245 L
.71718 .35043 L
.71721 .34883 L
.71724 .34745 L
.71727 .3468 L
.71729 .34772 L
.7173 .34857 L
.71733 .35022 L
.71737 .35211 L
.7174 .35374 L
.71743 .35513 L
.71746 .35522 L
.71748 .35324 L
.7175 .35137 L
.71753 .34788 L
.71756 .34555 L
Mistroke
.71758 .34643 L
.71761 .34745 L
.71764 .34841 L
.71767 .34663 L
.7177 .34462 L
.71776 .34195 L
.71779 .34145 L
.71781 .34099 L
.71784 .33926 L
.71786 .33697 L
.71788 .3345 L
.71791 .3303 L
.71794 .32711 L
.71796 .32908 L
.71799 .33123 L
.71802 .33322 L
.71804 .33283 L
.71807 .33126 L
.7181 .32984 L
.71813 .32709 L
.71814 .32269 L
.71816 .31785 L
.71822 .30129 L
.71835 .27435 L
.71838 .26701 L
.71841 .26025 L
.71843 .25851 L
.71844 .2566 L
.71848 .25326 L
.7185 .25009 L
.71854 .24974 L
.71859 .24913 L
.71871 .24417 L
.71874 .24289 L
.71877 .24153 L
.71879 .24081 L
.71881 .24277 L
.71884 .2466 L
.71886 .24859 L
.71887 .25071 L
.71889 .25139 L
.71891 .24955 L
.71895 .24594 L
.71896 .24417 L
.71898 .24255 L
.71901 .24188 L
.71904 .24136 L
.71906 .2411 L
.71907 .24081 L
.71909 .23999 L
Mistroke
.71911 .23913 L
.71959 .21998 L
.71971 .21092 L
.71981 .20152 L
.71984 .1996 L
.71987 .1951 L
.71989 .18942 L
.71992 .18424 L
.71995 .18022 L
.71998 .17826 L
.72004 .17327 L
.72007 .16945 L
.72009 .16745 L
.72011 .16533 L
.72014 .16304 L
.72017 .16442 L
.7202 .16597 L
.72023 .16709 L
.72024 .16632 L
.72026 .16549 L
.7203 .16375 L
.72033 .16263 L
.72035 .16272 L
.72036 .16281 L
.72039 .16297 L
.72042 .16347 L
.72045 .16629 L
.72047 .16893 L
.7205 .17183 L
.72053 .17263 L
.72056 .17211 L
.72058 .17183 L
.7206 .17156 L
.72062 .1716 L
.72063 .17198 L
.72067 .17273 L
.72069 .17308 L
.7207 .17344 L
.72073 .17597 L
.7208 .18186 L
.72086 .18645 L
.72089 .18902 L
.72092 .18902 L
.72093 .18866 L
.72095 .18828 L
.72097 .18794 L
.72098 .18758 L
.721 .1867 L
.72102 .18533 L
.72105 .18291 L
Mistroke
.72108 .18045 L
.7211 .17897 L
.72113 .17785 L
.72117 .17663 L
.72118 .17588 L
.7212 .17444 L
.72123 .17121 L
.7213 .16519 L
.72132 .16215 L
.72135 .15894 L
.72137 .15726 L
.72139 .15788 L
.72142 .16 L
.72144 .16201 L
.72148 .16351 L
.7215 .16304 L
.72153 .16261 L
.72156 .16211 L
.72159 .1597 L
.72162 .1574 L
.72165 .15498 L
.72168 .15693 L
.7217 .16211 L
.72173 .16775 L
.72175 .17092 L
.72177 .17083 L
.7218 .16962 L
.72182 .16847 L
.72185 .16741 L
.72187 .16997 L
.7219 .17338 L
.72193 .17705 L
.72196 .1795 L
.72199 .18094 L
.72202 .18261 L
.72205 .18319 L
.72208 .18029 L
.7221 .17863 L
.72211 .17713 L
.72213 .17554 L
.72215 .17582 L
.72216 .17712 L
.72218 .17853 L
.72225 .18371 L
.72228 .18674 L
.72231 .18956 L
.72234 .19112 L
.72235 .19033 L
.72237 .18948 L
.7224 .18798 L
Mistroke
.72243 .18606 L
.72246 .1831 L
.72249 .17988 L
.72254 .17267 L
.72257 .1682 L
.7226 .16349 L
.72263 .16235 L
.72266 .16397 L
.72271 .16683 L
.72277 .17086 L
.72284 .17518 L
.72287 .17728 L
.7229 .17937 L
.72293 .18294 L
.72296 .18681 L
.72299 .19088 L
.72302 .1921 L
.72304 .19247 L
.72305 .1928 L
.72309 .19355 L
.72315 .19527 L
.72317 .19575 L
.72319 .19624 L
.72321 .19614 L
.72322 .19606 L
.72325 .19589 L
.72327 .1958 L
.72329 .19538 L
.72332 .1922 L
.72335 .18884 L
.72337 .18589 L
.7234 .18405 L
.72344 .18232 L
.72347 .1807 L
.7235 .18161 L
.72351 .18279 L
.72353 .1839 L
.72356 .18613 L
.72358 .18675 L
.72359 .18631 L
.72371 .18287 L
.72374 .1819 L
.72376 .18136 L
.72377 .18111 L
.72379 .18091 L
.72381 .18072 L
.72382 .18056 L
.72384 .18037 L
.72386 .18025 L
.72387 .18148 L
Mistroke
.72391 .18369 L
.72392 .18492 L
.72394 .18626 L
.72396 .18817 L
.72398 .1906 L
.72401 .19508 L
.72402 .19754 L
.72404 .19985 L
.72407 .19916 L
.7241 .19654 L
.72411 .19517 L
.72413 .19373 L
.72416 .19409 L
.72418 .19553 L
.72419 .19687 L
.72421 .19833 L
.72423 .19992 L
.72426 .20008 L
.72429 .19883 L
.72431 .19762 L
.72434 .19756 L
.72437 .20134 L
.7244 .20551 L
.72446 .21274 L
.7247 .24153 L
.72476 .24907 L
.72479 .25383 L
.72482 .25761 L
.72485 .2588 L
.72487 .26009 L
.7249 .26116 L
.72493 .26191 L
.72496 .26259 L
.72497 .26294 L
.72499 .26332 L
.72502 .26263 L
.72505 .26137 L
.72512 .25779 L
.72516 .25557 L
.72517 .25459 L
.72519 .25351 L
.72522 .25712 L
.72525 .26217 L
.72531 .27294 L
.72534 .27771 L
.72537 .28285 L
.7254 .28382 L
.72543 .28239 L
.72546 .28074 L
.72549 .27876 L
Mistroke
.72551 .27594 L
.72554 .27287 L
.72557 .26953 L
.72559 .27054 L
.72561 .2723 L
.72566 .27831 L
.72572 .28291 L
.72575 .28536 L
.72578 .28706 L
.7258 .28763 L
.72583 .28826 L
.72586 .28882 L
.72588 .29025 L
.72601 .30045 L
.72612 .313 L
.72625 .32696 L
.72628 .32893 L
.7263 .33 L
.72632 .33103 L
.72633 .33198 L
.72635 .3346 L
.72638 .34101 L
.72641 .34718 L
.72644 .35137 L
.72647 .34552 L
.7265 .33907 L
.72653 .33209 L
.72655 .33251 L
.72656 .33382 L
.72659 .33639 L
.72662 .33878 L
.72665 .33467 L
.72668 .32903 L
.72671 .32289 L
.72674 .32027 L
.72676 .32086 L
.72679 .3215 L
.72682 .32198 L
.72684 .32145 L
.72687 .32083 L
.7269 .32016 L
.72693 .32345 L
.72696 .32807 L
.72699 .33349 L
.72701 .33653 L
.72703 .33688 L
.72706 .33757 L
.72709 .33822 L
.72712 .34006 L
.72715 .34406 L
Mistroke
.72716 .34623 L
.72718 .3485 L
.72721 .34934 L
.72723 .34711 L
.72725 .34472 L
.72728 .34043 L
.72729 .33781 L
.72731 .3325 L
.72735 .32197 L
.72737 .31314 L
.7274 .30845 L
.72743 .31226 L
.72746 .31575 L
.72749 .31982 L
.7275 .32108 L
.72752 .32219 L
.72755 .32421 L
.72758 .32639 L
.7276 .32628 L
.72761 .32578 L
.72764 .32479 L
.72767 .32389 L
.7277 .32369 L
.72773 .32386 L
.72776 .32402 L
.72778 .32368 L
.72779 .32069 L
.72783 .31396 L
.72785 .30859 L
.72788 .30632 L
.72791 .30795 L
.72793 .30973 L
.72796 .31165 L
.728 .31168 L
.72803 .31168 L
.72805 .31168 L
.72808 .31178 L
.7281 .31191 L
.72813 .31206 L
.72816 .31253 L
.72819 .31592 L
.72822 .31912 L
.72824 .32225 L
.72827 .32375 L
.7283 .32481 L
.72833 .32594 L
.72835 .32536 L
.72838 .32099 L
.72841 .31624 L
.72844 .31119 L
Mistroke
.72845 .31105 L
.72847 .31161 L
.7285 .31261 L
.72852 .31311 L
.72853 .31364 L
.72856 .30702 L
.7286 .2982 L
.72863 .28998 L
.72866 .28484 L
.72869 .27972 L
.7287 .27699 L
.72872 .27409 L
.72875 .27093 L
.72878 .26902 L
.72881 .26691 L
.72887 .26277 L
.72898 .25575 L
.72919 .2411 L
.72925 .23992 L
.72928 .24077 L
.7293 .24125 L
.72932 .2382 L
.72935 .23166 L
.72938 .2255 L
.72941 .22101 L
.72944 .21892 L
.72947 .21687 L
.72949 .21495 L
.72952 .21547 L
.72955 .21614 L
.72958 .21672 L
.7296 .22 L
.72963 .22629 L
.72966 .23225 L
.72969 .23824 L
.72972 .23927 L
.72975 .24028 L
.72977 .24085 L
.72978 .24095 L
.72981 .23748 L
.72984 .23384 L
.72987 .23065 L
.7299 .22939 L
.72992 .22901 L
.72993 .22865 L
.72997 .22797 L
.72998 .22742 L
.73 .22681 L
.73004 .22543 L
.73006 .22433 L
Mistroke
.73008 .22413 L
.7301 .22404 L
.73016 .22369 L
.73022 .22934 L
.73024 .23104 L
.73025 .23264 L
.73028 .23295 L
.7303 .23249 L
.73031 .23207 L
.73033 .23161 L
.73035 .23112 L
.73038 .23245 L
.7304 .23354 L
.73041 .23454 L
.73044 .23655 L
.73047 .23422 L
.7305 .23041 L
.73053 .22628 L
.73056 .2229 L
.73057 .22248 L
.73059 .22201 L
.73062 .22124 L
.73065 .22048 L
.73068 .22003 L
.73071 .21954 L
.73073 .21909 L
.73076 .21593 L
.73088 .20116 L
.73098 .19095 L
.73101 .18769 L
.73104 .18614 L
.73107 .18573 L
.73109 .18528 L
.73112 .18481 L
.73115 .18341 L
.73118 .18187 L
.73121 .18045 L
.73124 .18186 L
.73126 .18378 L
.73129 .18593 L
.73132 .18697 L
.73134 .18623 L
.73135 .18542 L
.73138 .18399 L
.7314 .18318 L
.73142 .1835 L
.73145 .18592 L
.73148 .18829 L
.73151 .19025 L
.73153 .19111 L
Mistroke
.73156 .19204 L
.73158 .19255 L
.7316 .19309 L
.73161 .19468 L
.73163 .19626 L
.73165 .19787 L
.73167 .19963 L
.73169 .2013 L
.7317 .2013 L
.73172 .2002 L
.73173 .19919 L
.73175 .19811 L
.73177 .19695 L
.7318 .19403 L
.73183 .19006 L
.73189 .18137 L
.73193 .17577 L
.73194 .17304 L
.73196 .17054 L
.73199 .16749 L
.73202 .16845 L
.73205 .16941 L
.73206 .16993 L
.73208 .17057 L
.73211 .17238 L
.73214 .17408 L
.7322 .17795 L
.73231 .18471 L
.73234 .18638 L
.73236 .18732 L
.73238 .18971 L
.7324 .19452 L
.73244 .19974 L
.73245 .20254 L
.73247 .20333 L
.7325 .20284 L
.73251 .20257 L
.73253 .20227 L
.73255 .20199 L
.73257 .20194 L
.73259 .20194 L
.73262 .20194 L
.73265 .20192 L
.73267 .20174 L
.73268 .20157 L
.73275 .20087 L
.73278 .20056 L
.73281 .20023 L
.73283 .19992 L
.73286 .20081 L
Mistroke
.73289 .20198 L
.73291 .20306 L
.73294 .20482 L
.73297 .21001 L
.733 .21498 L
.73303 .22046 L
.73306 .21963 L
.73307 .21873 L
.73309 .21788 L
.73312 .21637 L
.73315 .21909 L
.73318 .22379 L
.7332 .22628 L
.73321 .22893 L
.73323 .22954 L
.73325 .22903 L
.73328 .22803 L
.73331 .22703 L
.73333 .22705 L
.73334 .22748 L
.73337 .22826 L
.7334 .22912 L
.73343 .23136 L
.73346 .23412 L
.73349 .23701 L
.73352 .23866 L
.73355 .23687 L
.73357 .23521 L
.73363 .23251 L
.73366 .23154 L
.73368 .23062 L
.7337 .23051 L
.73373 .23336 L
.73376 .23625 L
.73379 .23893 L
.73381 .24047 L
.73384 .2416 L
.73391 .24406 L
.73396 .24655 L
.73422 .25806 L
.73425 .25823 L
.73428 .25892 L
.73431 .26286 L
.73434 .2672 L
.73437 .27079 L
.7344 .27093 L
.73443 .2711 L
.73445 .27125 L
.73448 .27166 L
.73451 .27225 L
Mistroke
.73454 .27289 L
.73456 .27316 L
.73459 .27216 L
.73462 .27108 L
.73464 .2701 L
.73467 .2677 L
.7347 .26374 L
.73473 .2595 L
.73476 .2562 L
.73478 .25578 L
.73481 .25533 L
.73484 .25485 L
.73486 .25547 L
.73487 .25664 L
.7349 .25895 L
.73493 .26111 L
.73496 .26029 L
.73498 .25794 L
.73501 .25537 L
.73504 .25322 L
.73506 .25331 L
.73507 .25339 L
.73511 .25356 L
.73513 .25374 L
.73516 .25458 L
.73519 .25548 L
.73521 .25638 L
.73524 .25905 L
.73527 .26242 L
.7353 .2661 L
.73533 .26927 L
.73535 .26968 L
.73538 .27018 L
.7354 .27046 L
.73541 .27073 L
.73544 .27078 L
.73547 .27078 L
.73549 .27078 L
.73551 .27078 L
.73554 .27003 L
.73557 .26895 L
.73559 .26836 L
.73561 .26781 L
.73564 .2715 L
.73567 .27548 L
.73572 .28375 L
.73575 .28881 L
.73578 .29417 L
.7358 .29697 L
.73581 .2969 L
Mistroke
.73585 .29503 L
.73588 .29318 L
.73591 .29314 L
.73594 .29708 L
.73597 .30128 L
.73603 .31001 L
.73606 .31457 L
.73609 .31852 L
.73612 .31985 L
.73615 .32125 L
.73617 .32266 L
.73621 .32206 L
.73623 .32092 L
.73626 .3197 L
.73631 .31766 L
.73634 .31648 L
.73636 .31582 L
.73638 .31547 L
.73639 .31669 L
.73641 .31804 L
.73643 .3192 L
.73645 .32042 L
.73646 .32151 L
.73648 .32158 L
.73651 .32014 L
.73654 .31845 L
.73657 .31727 L
.73661 .31693 L
.73663 .31662 L
.73666 .3166 L
.73668 .31754 L
.7367 .31841 L
.73673 .31998 L
.73675 .32145 L
.73678 .32652 L
.73681 .33224 L
.73684 .33779 L
.73686 .33906 L
.73688 .33898 L
.73691 .33882 L
.73693 .33867 L
.73695 .33877 L
.73697 .33985 L
.737 .34213 L
.73703 .34409 L
.73705 .34444 L
.73706 .34349 L
.73709 .34165 L
.73712 .33991 L
.73715 .33946 L
Mistroke
.73718 .34023 L
.73721 .34107 L
.73722 .3415 L
.73724 .34238 L
.73727 .34451 L
.7373 .34654 L
.73733 .34839 L
.73736 .34691 L
.73741 .34433 L
.73747 .34075 L
.73749 .33967 L
.7375 .33865 L
.73753 .33817 L
.73756 .33954 L
.73758 .34079 L
.73761 .34217 L
.73764 .34004 L
.73767 .33823 L
.73769 .33629 L
.73772 .33497 L
.73775 .33497 L
.73778 .33497 L
.73779 .33497 L
.73781 .33484 L
.73784 .33347 L
.73786 .33277 L
.73787 .332 L
.7379 .33111 L
.73793 .33401 L
.73796 .33668 L
.73799 .3392 L
.73801 .33833 L
.73803 .33637 L
.73806 .33294 L
.73813 .32728 L
.73826 .3144 L
.73838 .3008 L
.73841 .29573 L
.73845 .29028 L
.73846 .28764 L
.73848 .28559 L
.73851 .28413 L
.73854 .28277 L
.73856 .28133 L
.73859 .28062 L
.73862 .28008 L
.73865 .27943 L
.73868 .27944 L
.73871 .28043 L
.73872 .28098 L
Mistroke
.73874 .28151 L
.73877 .28105 L
.7388 .27779 L
.73883 .27399 L
.73886 .27125 L
.73888 .27598 L
.73891 .281 L
.73894 .28604 L
.73897 .28621 L
.73898 .28424 L
.739 .28216 L
.73903 .27844 L
.73905 .27644 L
.73906 .27577 L
.7391 .27425 L
.73913 .27291 L
.73916 .27025 L
.73917 .26807 L
.73919 .26571 L
.73922 .26142 L
.73935 .2439 L
.73942 .23175 L
.73945 .22632 L
.73948 .22157 L
.73951 .21722 L
.73954 .21597 L
.73957 .21706 L
.7396 .21824 L
.73963 .21952 L
.73966 .221 L
.73969 .22226 L
.73971 .22297 L
.73973 .22269 L
.73976 .22139 L
.73979 .22001 L
.73982 .21865 L
.73985 .21759 L
.73988 .21661 L
.7399 .21605 L
.73992 .21403 L
.73995 .20921 L
.73997 .20469 L
.74 .20061 L
.74003 .20135 L
.74005 .20239 L
.74008 .20353 L
.74011 .20361 L
.74014 .20297 L
.7402 .20172 L
.74033 .1983 L
Mistroke
.7404 .19649 L
.74043 .19575 L
.74046 .19507 L
.74049 .19489 L
.74052 .1954 L
.74055 .19591 L
.74057 .1962 L
.74059 .19425 L
.74064 .18618 L
.74067 .18221 L
.7407 .18069 L
.74074 .17912 L
.74077 .17764 L
.74079 .17495 L
.74082 .17202 L
.74084 .17034 L
.74086 .16877 L
.74087 .16791 L
.74089 .16731 L
.74092 .16626 L
.74095 .16527 L
.74098 .16191 L
.74102 .158 L
.74104 .15476 L
.74107 .15319 L
.7411 .15302 L
.74112 .15293 L
.74113 .15284 L
.74116 .15191 L
.74119 .15036 L
.74122 .14886 L
.74125 .14817 L
.74127 .14983 L
.74128 .15134 L
.74131 .15427 L
.74134 .15689 L
.74137 .15656 L
.7414 .15628 L
.74143 .15596 L
.74145 .15433 L
.74148 .15224 L
.74151 .14984 L
.74154 .14837 L
.74156 .14961 L
.74159 .15078 L
.74161 .15201 L
.74164 .1525 L
.74167 .15186 L
.74169 .15128 L
.74172 .15041 L
Mistroke
.74176 .14703 L
.74186 .13358 L
.74189 .12937 L
.74191 .12701 L
.74193 .12757 L
.74198 .13037 L
.74202 .13192 L
.74205 .13343 L
.74208 .13472 L
.7421 .13546 L
.74211 .13528 L
.74215 .13409 L
.74217 .133 L
.74219 .1324 L
.74221 .13214 L
.74224 .13248 L
.7423 .13324 L
.74234 .13383 L
.74236 .13411 L
.74237 .13438 L
.7424 .13403 L
.74243 .1325 L
.74247 .13091 L
.74248 .13011 L
.7425 .13032 L
.74253 .13096 L
.74256 .13164 L
.74259 .13245 L
.74262 .13348 L
.74268 .13577 L
.74274 .13845 L
.74276 .1398 L
.74279 .13962 L
.74281 .13896 L
.74283 .13834 L
.74286 .13718 L
.74289 .13679 L
.74291 .13695 L
.74294 .13708 L
.74296 .13722 L
.743 .13286 L
.74302 .12846 L
.74305 .12418 L
.74308 .12274 L
.74311 .12274 L
.74314 .12274 L
.74317 .12285 L
.7432 .12314 L
.74323 .12347 L
.74324 .12367 L
Mistroke
.74326 .12409 L
.74329 .12555 L
.74332 .1271 L
.74335 .12847 L
.74337 .12865 L
.74339 .12882 L
.74342 .12915 L
.74344 .12946 L
.74348 .12796 L
.74349 .12709 L
.74351 .12629 L
.74353 .12545 L
.74354 .12519 L
.74356 .12731 L
.74358 .12961 L
.74361 .13322 L
.74364 .13665 L
.74365 .13759 L
.74367 .13858 L
.7437 .14032 L
.74372 .14197 L
.74375 .14289 L
.74378 .14349 L
.74381 .14404 L
.74382 .14438 L
.74384 .14599 L
.74387 .1497 L
.74389 .15179 L
.7439 .15403 L
.74392 .15614 L
.74394 .15595 L
.74397 .15498 L
.74399 .15407 L
.74402 .15351 L
.74404 .15416 L
.74406 .15477 L
.74409 .15595 L
.74412 .15693 L
.74413 .15702 L
.74415 .15711 L
.74418 .15728 L
.74421 .15761 L
.74425 .15898 L
.74427 .16018 L
.7443 .16147 L
.74432 .16074 L
.74434 .15987 L
.74437 .15817 L
.7444 .15662 L
.74443 .15331 L
Mistroke
.74446 .14959 L
.74447 .14754 L
.74449 .1456 L
.74451 .14724 L
.74453 .15001 L
.74456 .15543 L
.74468 .16001 L
.74471 .1609 L
.74474 .16204 L
.74477 .16301 L
.74479 .16493 L
.74482 .16822 L
.74485 .17129 L
.74488 .17473 L
.74491 .18307 L
.74497 .19954 L
.74504 .21385 L
.7451 .22502 L
.74513 .22915 L
.74516 .23369 L
.74519 .23099 L
.74521 .22683 L
.74524 .22215 L
.74527 .21966 L
.7453 .21994 L
.74533 .22024 L
.74535 .22051 L
.74537 .22319 L
.74548 .23387 L
.74642 .32587 L
.74667 .34683 L
.7468 .36198 L
.74683 .36695 L
.74685 .36968 L
.74687 .37227 L
.74689 .37433 L
.7469 .37145 L
.74694 .36584 L
.74697 .3609 L
.74698 .35997 L
.747 .36199 L
.74703 .36561 L
.74706 .36892 L
.74708 .37074 L
.74709 .37156 L
.74713 .37328 L
.74716 .37477 L
.74718 .37512 L
.74719 .37442 L
.74722 .37322 L
Mistroke
.74725 .37192 L
.74728 .37108 L
.7473 .37079 L
.74733 .37046 L
.74735 .37029 L
.74737 .37036 L
.7474 .37132 L
.74742 .37222 L
.74767 .38371 L
.74771 .38321 L
.74773 .38274 L
.74776 .38675 L
.74778 .38987 L
.7478 .39324 L
.74783 .39888 L
.74786 .39885 L
.74788 .39547 L
.74791 .39178 L
.74797 .38519 L
.74799 .38169 L
.74802 .37839 L
.74805 .37713 L
.74808 .37668 L
.7481 .37627 L
.74813 .37588 L
.74815 .37587 L
.74818 .37587 L
.74821 .37587 L
.74823 .37543 L
.74825 .37468 L
.74827 .37334 L
.7483 .37189 L
.74833 .3747 L
.74836 .38109 L
.74839 .38865 L
.74841 .39278 L
.74842 .39483 L
.74845 .39589 L
.74848 .39706 L
.7485 .39771 L
.74851 .39623 L
.74854 .38518 L
.74858 .37314 L
.74859 .36707 L
.74861 .3645 L
.74864 .36833 L
.74867 .37193 L
.7487 .37524 L
.74873 .36949 L
.74876 .36278 L
Mistroke
.74877 .35913 L
.74879 .35572 L
.74882 .35404 L
.74885 .35269 L
.74888 .35147 L
.74891 .35512 L
.74894 .36099 L
.74896 .36641 L
.74902 .37645 L
.74904 .38109 L
.74907 .38532 L
.74909 .38849 L
.74912 .39014 L
.74915 .39195 L
.74918 .3933 L
.74921 .39156 L
.74924 .38966 L
.74927 .38798 L
.7493 .38806 L
.74933 .38838 L
.74934 .38857 L
.74936 .38874 L
.74938 .38881 L
.74939 .38881 L
.74943 .38881 L
.74946 .38881 L
.74949 .38785 L
.74955 .38565 L
.74956 .38521 L
.74958 .38531 L
.74961 .38548 L
.74963 .38557 L
.74965 .38567 L
.74967 .38302 L
.74968 .37942 L
.74975 .36697 L
.74978 .35993 L
.74981 .35328 L
.74984 .34704 L
.74986 .34812 L
.74988 .34931 L
.7499 .35138 L
.74993 .35365 L
.74996 .34979 L
.74999 .34459 L
.75004 .33335 L
.75008 .32739 L
.75011 .32174 L
.75014 .31759 L
.75017 .31924 L
Mistroke
.7502 .32103 L
.75022 .32193 L
.75023 .32148 L
.75025 .31911 L
.75027 .31656 L
.7503 .31193 L
.75033 .30833 L
.75036 .30996 L
.75038 .31171 L
.7504 .31264 L
.75042 .31362 L
.75045 .31197 L
.75047 .3102 L
.75053 .30664 L
.75078 .28297 L
.75129 .23286 L
.75151 .21087 L
.75164 .19821 L
.7517 .19198 L
.75173 .1894 L
.75176 .18705 L
.75178 .18832 L
.75181 .18971 L
.75184 .19117 L
.75187 .19158 L
.7519 .19028 L
.75193 .18891 L
.75199 .18643 L
.75201 .18534 L
.75204 .18418 L
.75206 .18565 L
.75209 .18813 L
.7522 .19651 L
.75225 .19939 L
.75228 .20114 L
.75231 .20274 L
.75234 .20294 L
.75237 .19819 L
.7524 .19294 L
.75243 .18848 L
.75246 .18633 L
.75248 .18402 L
.75251 .18147 L
.75254 .18346 L
.75257 .1877 L
.7526 .1923 L
.75263 .19362 L
.75265 .1892 L
.75268 .18437 L
.75271 .17918 L
Mistroke
.75274 .17837 L
.75277 .17765 L
.7528 .1768 L
.75282 .17598 L
.75283 .17492 L
.75286 .17301 L
.75288 .172 L
.7529 .17094 L
.75291 .17106 L
.75293 .17237 L
.75296 .17494 L
.75299 .17723 L
.75302 .17695 L
.75304 .17592 L
.75305 .17498 L
.75309 .17288 L
.75315 .17 L
.75321 .16684 L
.75325 .16453 L
.75328 .16233 L
.75331 .16265 L
.75332 .16364 L
.75334 .16455 L
.75337 .16617 L
.7534 .16546 L
.75341 .16279 L
.75343 .15991 L
.75346 .15468 L
.75349 .15079 L
.75352 .14958 L
.75353 .14888 L
.75355 .14812 L
.75358 .1459 L
.7536 .14318 L
.75362 .14071 L
.75363 .138 L
.75365 .13501 L
.75368 .13216 L
.75371 .13249 L
.75374 .1328 L
.75376 .13308 L
.7538 .13212 L
.75383 .13105 L
.75386 .13011 L
.75389 .12999 L
.75391 .12999 L
.75394 .12999 L
.75397 .1287 L
.754 .12645 L
.75402 .1238 L
Mistroke
.75406 .12116 L
.75408 .12084 L
.75411 .12054 L
.75414 .12024 L
.75417 .12097 L
.75419 .12239 L
.75422 .12373 L
.75425 .12486 L
.75427 .12525 L
.7543 .12567 L
.75433 .12613 L
.75436 .12716 L
.75439 .12857 L
.75441 .12982 L
.75444 .13054 L
.75447 .12657 L
.7545 .12239 L
.75453 .11861 L
.75456 .11922 L
.75459 .11986 L
.75461 .1202 L
.75462 .12056 L
.75465 .11618 L
.75468 .1112 L
.75471 .10674 L
.75473 .10344 L
.75476 .10296 L
.75479 .10251 L
.75482 .10194 L
.75484 .09937 L
.75485 .09699 L
.75489 .09175 L
.75492 .08781 L
.75495 .09003 L
.75497 .09212 L
.755 .09433 L
.75503 .0934 L
.75515 .09148 L
.75517 .09211 L
.75519 .09279 L
.75521 .09242 L
.75522 .08996 L
.75525 .08502 L
.75528 .08038 L
.75531 .07764 L
.75534 .07629 L
.75536 .07492 L
.75539 .07377 L
.75542 .0759 L
.75546 .07814 L
Mistroke
.75549 .08022 L
.75551 .08086 L
.75554 .08154 L
.75557 .08218 L
.7556 .08406 L
.75563 .08672 L
.75566 .08936 L
.75569 .09183 L
.75572 .09384 L
.75575 .09573 L
.75577 .0968 L
.75579 .09634 L
.75582 .0953 L
.75584 .09477 L
.75585 .09421 L
.75587 .09383 L
.75589 .09412 L
.75593 .09468 L
.75594 .09495 L
.75596 .09521 L
.75599 .0953 L
.75602 .0953 L
.75605 .0953 L
.75608 .0958 L
.7561 .0965 L
.75613 .09726 L
.75616 .09749 L
.75618 .09665 L
.75619 .09573 L
.75623 .09408 L
.75625 .0924 L
.75628 .08939 L
.75631 .08622 L
.75634 .08303 L
.75637 .08261 L
.75639 .08361 L
.75642 .08468 L
.75645 .08592 L
.75647 .08773 L
.75697 .11913 L
.75709 .12744 L
.75715 .1315 L
.75718 .13368 L
.75721 .1357 L
.75724 .13587 L
.75727 .13602 L
.75729 .13611 L
.7573 .1364 L
.75733 .14153 L
.7574 .15242 L
Mistroke
.75743 .15829 L
.75747 .16448 L
.7575 .16894 L
.75752 .16932 L
.75753 .16967 L
.75756 .1703 L
.75759 .17156 L
.75762 .17669 L
.75765 .18154 L
.75768 .18589 L
.75771 .1843 L
.75774 .18217 L
.75776 .17981 L
.7578 .18063 L
.75782 .18417 L
.75785 .18741 L
.75787 .1905 L
.7579 .19055 L
.75793 .19055 L
.75796 .19055 L
.75799 .18936 L
.75801 .18757 L
.75804 .18564 L
.75807 .18416 L
.7581 .18674 L
.75816 .19136 L
.75821 .19484 L
.75823 .19674 L
.75826 .19821 L
.75829 .19723 L
.75832 .19634 L
.75834 .1955 L
.75837 .19925 L
.7584 .20564 L
.75842 .20899 L
.75843 .21252 L
.75846 .21632 L
.75849 .21785 L
.75852 .21956 L
.75855 .22069 L
.75857 .22086 L
.75859 .22104 L
.7586 .22124 L
.75862 .22143 L
.75865 .22289 L
.75867 .22443 L
.75868 .22606 L
.75871 .22881 L
.75874 .23008 L
.75877 .22754 L
Mistroke
.7588 .22482 L
.75883 .22225 L
.75885 .22606 L
.75888 .23111 L
.75891 .23585 L
.75894 .23749 L
.75897 .23718 L
.759 .23685 L
.75901 .23668 L
.75903 .23849 L
.75906 .24326 L
.75909 .24771 L
.75912 .25189 L
.75915 .25377 L
.7592 .25731 L
.75925 .26111 L
.75928 .26313 L
.75931 .2647 L
.75934 .26082 L
.75937 .25719 L
.75939 .25516 L
.7594 .25327 L
.75943 .25542 L
.75946 .25728 L
.75949 .25927 L
.75952 .2592 L
.75955 .25826 L
.75956 .25773 L
.75958 .25717 L
.7596 .2579 L
.75962 .26033 L
.75968 .26954 L
.75981 .28642 L
.76028 .36019 L
.76049 .38136 L
.76072 .40922 L
.76078 .41463 L
.7608 .41688 L
.76081 .41931 L
.76084 .42092 L
.76087 .41595 L
.7609 .41139 L
.76093 .40626 L
.76096 .40401 L
.76099 .40224 L
.76102 .40032 L
.76104 .40007 L
.76107 .40063 L
.7611 .40128 L
.76113 .40013 L
Mistroke
.76116 .39578 L
.76119 .39099 L
.76122 .38635 L
.76123 .38775 L
.76125 .38903 L
.76128 .39135 L
.76131 .39388 L
.76134 .39223 L
.76137 .39052 L
.7614 .38889 L
.76143 .38963 L
.76144 .39088 L
.76146 .39203 L
.7615 .39462 L
.76153 .39715 L
.76156 .4 L
.7616 .40255 L
.76162 .40235 L
.76166 .40185 L
.76167 .40157 L
.76169 .40131 L
.76172 .40243 L
.76175 .40401 L
.76178 .40555 L
.7618 .40444 L
.76182 .40224 L
.76185 .39821 L
.76187 .39446 L
.7619 .39314 L
.76193 .39348 L
.7622 .39678 L
.76232 .39794 L
.76235 .39701 L
.76238 .39722 L
.7624 .3982 L
.76243 .39929 L
.7625 .40146 L
.76253 .40252 L
.76255 .40312 L
.76256 .40422 L
.76262 .40919 L
.76268 .41256 L
.76271 .4139 L
.76274 .41517 L
.76277 .41328 L
.7628 .41114 L
.76283 .40878 L
.76284 .40727 L
.76286 .40477 L
.76292 .39623 L
Mistroke
.76303 .37543 L
.76314 .35267 L
.76317 .34584 L
.76319 .34224 L
.7632 .33842 L
.76323 .3363 L
.76326 .34023 L
.7634 .35653 L
.76345 .3628 L
.76348 .3661 L
.76351 .36867 L
.76353 .36665 L
.76355 .36443 L
.76358 .36054 L
.76364 .35386 L
.76415 .30176 L
.76461 .24912 L
.76473 .23321 L
.76475 .22914 L
.76478 .22691 L
.76482 .22446 L
.76485 .22217 L
.76488 .2201 L
.76491 .21814 L
.76494 .21643 L
.76496 .21643 L
.76498 .21643 L
.76501 .21643 L
.76503 .21643 L
.76506 .21438 L
.7651 .21172 L
.76555 .17852 L
.76579 .16584 L
.7658 .16535 L
.76582 .1667 L
.76585 .16915 L
.76587 .17062 L
.76589 .17197 L
.76592 .16882 L
.76594 .16303 L
.76597 .15681 L
.76599 .15324 L
.76601 .15326 L
.76604 .15442 L
.76606 .15538 L
.76609 .15632 L
.76612 .15477 L
.76614 .15333 L
.76617 .15167 L
.76619 .15111 L
Mistroke
.76622 .15253 L
.76625 .15386 L
.76628 .15525 L
.76631 .15444 L
.76636 .1527 L
.76642 .1513 L
.76643 .15096 L
.76645 .15059 L
.76648 .15078 L
.76651 .15237 L
.76654 .15413 L
.76656 .15501 L
.76658 .1556 L
.76661 .15628 L
.76664 .15693 L
.76667 .15747 L
.7667 .15761 L
.76673 .15777 L
.76674 .15787 L
.76676 .15768 L
.76679 .15596 L
.76686 .1527 L
.7669 .15253 L
.76693 .15237 L
.76696 .15112 L
.76697 .14895 L
.76699 .14662 L
.76701 .14461 L
.76702 .1424 L
.76706 .14059 L
.76708 .14269 L
.76711 .14464 L
.76714 .14654 L
.76717 .14626 L
.76722 .14564 L
.76725 .1451 L
.76729 .14439 L
.76732 .14372 L
.76735 .14236 L
.76738 .14014 L
.76741 .13804 L
.76742 .13686 L
.76744 .13818 L
.76748 .14198 L
.7675 .14514 L
.76754 .14973 L
.76759 .1608 L
.76762 .16552 L
.76765 .1646 L
.76772 .16265 L
Mistroke
.76777 .16356 L
.7678 .16407 L
.76783 .16214 L
.76788 .15768 L
.76791 .15578 L
.76794 .15549 L
.76797 .15516 L
.76799 .15498 L
.768 .15478 L
.76803 .15416 L
.76806 .15349 L
.76808 .15311 L
.7681 .1528 L
.76813 .15731 L
.76816 .16223 L
.76818 .16493 L
.7682 .16653 L
.76822 .16529 L
.76826 .16393 L
.76828 .16277 L
.76831 .16748 L
.76834 .17364 L
.76837 .17947 L
.76839 .18208 L
.76841 .18412 L
.76844 .18768 L
.76847 .19111 L
.76848 .19081 L
.7685 .18746 L
.76853 .18147 L
.76856 .176 L
.76859 .17355 L
.76862 .17499 L
.76864 .17626 L
.76867 .1776 L
.76869 .1777 L
.7687 .17778 L
.76873 .17794 L
.76875 .17803 L
.76877 .17812 L
.76878 .17793 L
.7688 .17776 L
.76883 .17743 L
.76886 .17712 L
.76889 .17814 L
.76892 .17939 L
.76895 .18059 L
.76897 .17977 L
.76899 .1787 L
.76902 .17677 L
Mistroke
.76903 .17574 L
.76905 .17464 L
.76908 .1698 L
.76911 .16504 L
.76914 .15963 L
.76917 .15731 L
.76918 .15681 L
.7692 .15628 L
.76921 .15573 L
.76923 .15514 L
.76925 .15709 L
.76927 .16138 L
.7693 .16942 L
.76933 .17705 L
.76935 .17894 L
.76937 .18017 L
.76943 .1844 L
.76949 .18923 L
.76952 .19182 L
.76954 .19279 L
.76955 .19327 L
.76959 .19413 L
.76962 .19495 L
.76964 .19337 L
.76967 .1903 L
.7697 .18728 L
.76973 .18556 L
.76976 .18618 L
.76979 .18686 L
.76982 .18744 L
.76984 .18758 L
.76987 .18772 L
.7699 .18788 L
.76993 .18882 L
.76994 .18975 L
.76996 .19062 L
.77002 .19328 L
.77006 .19367 L
.77007 .19386 L
.77009 .19404 L
.77012 .19615 L
.77014 .19791 L
.77015 .19979 L
.77019 .20324 L
.77022 .20374 L
.77024 .20258 L
.77027 .20132 L
.77029 .20066 L
.7703 .20128 L
.77032 .2028 L
Mistroke
.77034 .20422 L
.77037 .20671 L
.77038 .20814 L
.7704 .20807 L
.77043 .20611 L
.77046 .20402 L
.77049 .20248 L
.77052 .20264 L
.77055 .20282 L
.77057 .20291 L
.77059 .20326 L
.7706 .20394 L
.77062 .20466 L
.77065 .20597 L
.77068 .20669 L
.7707 .205 L
.77071 .20345 L
.77077 .19753 L
.7708 .19447 L
.77083 .19117 L
.77086 .18807 L
.77089 .1881 L
.77091 .18892 L
.77094 .18982 L
.77097 .19061 L
.77099 .191 L
.77102 .19146 L
.77105 .19196 L
.77108 .19148 L
.7711 .19063 L
.77113 .18972 L
.77116 .18927 L
.77119 .19023 L
.77121 .19128 L
.77124 .19241 L
.77126 .19359 L
.77128 .1949 L
.7713 .19746 L
.77133 .19986 L
.77136 .20043 L
.77139 .1995 L
.77145 .19711 L
.77148 .19467 L
.77149 .19338 L
.77151 .19201 L
.77154 .19036 L
.77157 .19177 L
.77163 .19472 L
.77169 .19768 L
.77171 .19908 L
Mistroke
.77174 .20135 L
.77179 .20691 L
.77182 .21015 L
.77185 .20701 L
.77189 .20327 L
.77192 .19987 L
.77193 .20116 L
.77195 .20256 L
.77198 .20512 L
.772 .20653 L
.77202 .20752 L
.77203 .20718 L
.77205 .2068 L
.77208 .20617 L
.77211 .20559 L
.77213 .20576 L
.77214 .20595 L
.77218 .20628 L
.7722 .20659 L
.77224 .20909 L
.77226 .21143 L
.77229 .21363 L
.77232 .21469 L
.77234 .21495 L
.77235 .21522 L
.77237 .21551 L
.77239 .21578 L
.77242 .21529 L
.77245 .21449 L
.77248 .21376 L
.77251 .21454 L
.77254 .2173 L
.77255 .21876 L
.77257 .22031 L
.77259 .22105 L
.77261 .21884 L
.77264 .21452 L
.77266 .21241 L
.77268 .21048 L
.77271 .21193 L
.77274 .21498 L
.7728 .22051 L
.77292 .23104 L
.77296 .23528 L
.77297 .23702 L
.77299 .23604 L
.77302 .23428 L
.77305 .23267 L
.77308 .23213 L
.77311 .23245 L
Mistroke
.77317 .2332 L
.7732 .23363 L
.77323 .23409 L
.77326 .23481 L
.77329 .23776 L
.77377 .28673 L
.7739 .30149 L
.77404 .31353 L
.77409 .31818 L
.77416 .32189 L
.77417 .32277 L
.77419 .32361 L
.77421 .32436 L
.77422 .32338 L
.77424 .32167 L
.77426 .31985 L
.77429 .31658 L
.77432 .31438 L
.77433 .31455 L
.77435 .31474 L
.77438 .31508 L
.77441 .3153 L
.77443 .3153 L
.77444 .3153 L
.77446 .3153 L
.77448 .3153 L
.77451 .31465 L
.77453 .31385 L
.77455 .313 L
.77458 .31148 L
.77461 .30849 L
.77462 .30566 L
.77464 .30256 L
.77467 .29714 L
.7747 .29493 L
.77473 .29716 L
.77479 .30145 L
.77482 .30497 L
.77485 .30878 L
.77488 .31238 L
.7749 .31207 L
.77501 .31099 L
.77504 .31177 L
.77507 .31262 L
.7751 .31117 L
.77512 .30957 L
.77518 .30564 L
.77522 .30277 L
.77525 .30007 L
.77527 .30011 L
Mistroke
.7753 .30367 L
.77533 .30728 L
.77536 .31041 L
.77539 .30889 L
.77543 .30729 L
.77548 .30408 L
.77551 .30238 L
.77554 .30078 L
.77557 .30226 L
.7756 .30469 L
.77565 .30905 L
.77571 .31358 L
.77574 .31612 L
.77577 .31677 L
.7758 .31731 L
.77583 .3178 L
.77586 .31616 L
.77588 .31411 L
.77594 .30913 L
.77598 .30577 L
.776 .3026 L
.77602 .30085 L
.77604 .30063 L
.77607 .30145 L
.77609 .30193 L
.77611 .30244 L
.77612 .30288 L
.77614 .30401 L
.77617 .3062 L
.7762 .30822 L
.77623 .30909 L
.77626 .30909 L
.7763 .30909 L
.77631 .30913 L
.77633 .31003 L
.77636 .31154 L
.77639 .31313 L
.7764 .31397 L
.77642 .31317 L
.77645 .31028 L
.77648 .30746 L
.77651 .30493 L
.77654 .30459 L
.77657 .30429 L
.77659 .30399 L
.77662 .30714 L
.77664 .31216 L
.77667 .31747 L
.7767 .32177 L
.77673 .32254 L
Mistroke
.77675 .32296 L
.77677 .32343 L
.7768 .32501 L
.77683 .32926 L
.77686 .33379 L
.77688 .33765 L
.77691 .33651 L
.77693 .33552 L
.77695 .33447 L
.77698 .33261 L
.777 .33105 L
.77701 .32946 L
.77705 .32586 L
.77707 .32424 L
.77708 .32297 L
.77711 .32217 L
.77718 .32034 L
.77723 .31831 L
.77726 .31717 L
.77729 .31738 L
.7773 .3178 L
.77732 .31825 L
.77735 .31909 L
.77738 .31342 L
.77741 .30362 L
.77742 .29827 L
.77744 .29248 L
.77747 .28775 L
.7775 .29112 L
.77753 .29423 L
.77756 .29701 L
.77758 .29619 L
.77759 .29542 L
.77762 .29388 L
.77764 .29301 L
.77766 .29373 L
.77768 .2991 L
.77771 .30479 L
.77774 .30966 L
.77777 .30859 L
.77779 .30477 L
.77783 .30066 L
.77786 .29759 L
.77788 .29552 L
.77791 .29369 L
.77793 .29174 L
.77796 .28753 L
.77799 .28338 L
.7781 .26277 L
.77816 .25213 L
Mistroke
.7782 .24734 L
.77821 .245 L
.77823 .24303 L
.77825 .24053 L
.77828 .23784 L
.77832 .23491 L
.77835 .23597 L
.77836 .23688 L
.77838 .23771 L
.77839 .2386 L
.77841 .23956 L
.77844 .23616 L
.77847 .23244 L
.77861 .21957 L
.77864 .21457 L
.77868 .20921 L
.77871 .2049 L
.77874 .20413 L
.77876 .20332 L
.77878 .2029 L
.7788 .20243 L
.77882 .20057 L
.77883 .19884 L
.77886 .19544 L
.77889 .19262 L
.77892 .19214 L
.77895 .19173 L
.77898 .19128 L
.77899 .19115 L
.77901 .19149 L
.77904 .19217 L
.77907 .19278 L
.7791 .19465 L
.77913 .19801 L
.77916 .20171 L
.77918 .20357 L
.77919 .20229 L
.77921 .2002 L
.77923 .1983 L
.77925 .19467 L
.77929 .19228 L
.77932 .19277 L
.77934 .19322 L
.77937 .19407 L
.7794 .19866 L
.77944 .20368 L
.77947 .20729 L
.77949 .20593 L
.77951 .20467 L
.77954 .20181 L
Mistroke
.77956 .20053 L
.77958 .20001 L
.77959 .19951 L
.77961 .19906 L
.77964 .19823 L
.77967 .19793 L
.7797 .19826 L
.77972 .19844 L
.77973 .19862 L
.77976 .19838 L
.77979 .19697 L
.77982 .19532 L
.77985 .19379 L
.77987 .19283 L
.7799 .19187 L
.77992 .19132 L
.77994 .1908 L
.77997 .19281 L
.78 .19616 L
.78002 .198 L
.78003 .19975 L
.78005 .20028 L
.78007 .2001 L
.7801 .19977 L
.78012 .19947 L
.78015 .19778 L
.78018 .1957 L
.78021 .1934 L
.78024 .1915 L
.78025 .19131 L
.78027 .19114 L
.7803 .19083 L
.78033 .19077 L
.78036 .19206 L
.78039 .19343 L
.78042 .19458 L
.78045 .19148 L
.78052 .1838 L
.78055 .18108 L
.78058 .17808 L
.78061 .17554 L
.78063 .17524 L
.78066 .17553 L
.78069 .17585 L
.7807 .17602 L
.78072 .17806 L
.78075 .18266 L
.78078 .18675 L
.78081 .19016 L
.78083 .18789 L
Mistroke
.78086 .18576 L
.78089 .18331 L
.78092 .18211 L
.78097 .1805 L
.78102 .17831 L
.78113 .17185 L
.78119 .16804 L
.78124 .16527 L
.78127 .16373 L
.7813 .16322 L
.78133 .16338 L
.78135 .16348 L
.78136 .16356 L
.78139 .16314 L
.78142 .16216 L
.78145 .16131 L
.78148 .16049 L
.78149 .1603 L
.78151 .16013 L
.78154 .1598 L
.78156 .15962 L
.78157 .16071 L
.78159 .16391 L
.78161 .16686 L
.78164 .17267 L
.78167 .17626 L
.7817 .1716 L
.78173 .16648 L
.78176 .16274 L
.78179 .16354 L
.78182 .16426 L
.78185 .16503 L
.78188 .16341 L
.78191 .1614 L
.78194 .15923 L
.78196 .15994 L
.78197 .16368 L
.782 .17013 L
.78203 .17702 L
.78206 .17917 L
.78209 .17734 L
.78212 .17519 L
.78213 .17398 L
.78215 .1737 L
.78218 .17449 L
.78221 .17532 L
.78224 .17619 L
.78227 .17808 L
.7823 .17971 L
.78233 .18149 L
Mistroke
.78235 .18034 L
.78236 .17861 L
.7824 .17521 L
.78243 .17212 L
.78244 .17489 L
.78246 .17796 L
.78249 .18357 L
.78252 .1895 L
.78254 .19144 L
.78257 .19204 L
.7826 .19269 L
.78261 .19305 L
.78263 .19283 L
.78266 .19204 L
.78269 .19128 L
.78271 .19058 L
.78274 .1947 L
.78279 .20247 L
.78282 .20565 L
.78284 .20593 L
.78287 .20624 L
.7829 .20657 L
.78293 .203 L
.78296 .1994 L
.78299 .19574 L
.78302 .19319 L
.78305 .19103 L
.78308 .18869 L
.78311 .18679 L
.78314 .18538 L
.78317 .1839 L
.7832 .18316 L
.78323 .18565 L
.78326 .18832 L
.78329 .19048 L
.78331 .1902 L
.78333 .18993 L
.78336 .18944 L
.78337 .18918 L
.78339 .1887 L
.78342 .18706 L
.78344 .18555 L
.78349 .18337 L
.78352 .18352 L
.78355 .18369 L
.78358 .18324 L
.7836 .17918 L
.78363 .17496 L
.78366 .17038 L
.78369 .16986 L
Mistroke
.78371 .17138 L
.78374 .17302 L
.78377 .17377 L
.78379 .17177 L
.7838 .16962 L
.78383 .16574 L
.78385 .16359 L
.78387 .16206 L
.78389 .1619 L
.78393 .16173 L
.78394 .16164 L
.78396 .16173 L
.78399 .16364 L
.78402 .16573 L
.78408 .16971 L
.78411 .17173 L
.78413 .17273 L
.78414 .17366 L
.78416 .17172 L
.78418 .16815 L
.78421 .1619 L
.78424 .15645 L
.78426 .15719 L
.78428 .15795 L
.78431 .15949 L
.78432 .1603 L
.78434 .16074 L
.78437 .15708 L
.7844 .15368 L
.78442 .15185 L
.78443 .14986 L
.78446 .14842 L
.78452 .1459 L
.78457 .14385 L
.7846 .1427 L
.78462 .14205 L
.78464 .14234 L
.78465 .14299 L
.78467 .14357 L
.78469 .14426 L
.7847 .14489 L
.78473 .14488 L
.78475 .14412 L
.78477 .14331 L
.78482 .14054 L
.78489 .13814 L
.78492 .13695 L
.78495 .1361 L
.78498 .1353 L
.78501 .13489 L
Mistroke
.78504 .13815 L
.78507 .14163 L
.78509 .14344 L
.78511 .14512 L
.78514 .14632 L
.78521 .14892 L
.78524 .14973 L
.78527 .1506 L
.78529 .15109 L
.78531 .15244 L
.78534 .15566 L
.78582 .19406 L
.78678 .24899 L
.7877 .31878 L
.78821 .35304 L
.78867 .37549 L
.7887 .37516 L
.78873 .37485 L
.78875 .37577 L
.78876 .3769 L
.7888 .37888 L
.78882 .38076 L
.78885 .38076 L
.78888 .38047 L
.78891 .38016 L
.78894 .38246 L
.78896 .385 L
.78897 .38733 L
.78903 .39649 L
.78906 .40255 L
.78908 .40589 L
.7891 .40903 L
.78911 .41197 L
.78913 .41282 L
.78916 .41413 L
.78921 .41637 L
.78927 .41929 L
.78929 .42082 L
.78933 .41988 L
.78935 .41772 L
.78938 .4157 L
.78941 .41476 L
.78944 .41645 L
.78947 .41799 L
.78949 .41963 L
.78952 .41819 L
.78955 .4164 L
.78957 .4153 L
.78958 .41426 L
.78961 .41388 L
Mistroke
.78964 .41417 L
.78967 .41449 L
.7897 .41299 L
.78973 .40894 L
.78975 .40521 L
.78978 .40168 L
.78981 .40234 L
.78983 .40348 L
.78986 .40474 L
.78989 .40378 L
.78992 .40121 L
.78995 .39838 L
.79001 .39247 L
.79005 .38979 L
.79007 .38774 L
.7901 .38759 L
.79013 .38741 L
.79017 .38709 L
.79018 .38541 L
.7902 .38389 L
.79023 .38066 L
.79025 .37896 L
.79027 .37794 L
.79028 .37794 L
.7903 .37794 L
.79033 .37794 L
.79036 .37742 L
.79039 .3757 L
.79046 .37186 L
.79057 .36629 L
.7908 .35302 L
.79082 .35349 L
.79085 .35337 L
.79087 .3532 L
.79089 .35302 L
.79092 .35269 L
.79095 .3506 L
.79098 .34711 L
.79103 .34141 L
.79106 .34026 L
.79108 .33965 L
.7911 .339 L
.79113 .33629 L
.79116 .32867 L
.79119 .31966 L
.79121 .31488 L
.79123 .3112 L
.79126 .30666 L
.79129 .30241 L
.79136 .29248 L
Mistroke
.79139 .28732 L
.79142 .2843 L
.79144 .28444 L
.79147 .2846 L
.7915 .28466 L
.79153 .28188 L
.79156 .27902 L
.79159 .27595 L
.79162 .27452 L
.79165 .27349 L
.79171 .27133 L
.79174 .27024 L
.79177 .26922 L
.7918 .26907 L
.79183 .26998 L
.79186 .27098 L
.79189 .27177 L
.79191 .27137 L
.79194 .27094 L
.79197 .27046 L
.79199 .26786 L
.79202 .2633 L
.79205 .259 L
.79208 .25563 L
.79211 .25701 L
.79214 .25854 L
.79216 .25934 L
.79218 .26004 L
.79219 .26037 L
.79221 .26073 L
.79224 .26137 L
.79225 .26174 L
.79227 .26182 L
.7923 .26083 L
.79232 .26026 L
.79234 .25966 L
.79235 .2591 L
.79237 .25811 L
.79243 .25296 L
.79249 .24839 L
.79252 .24654 L
.79255 .24471 L
.79257 .24312 L
.79259 .2414 L
.79262 .23838 L
.79268 .23221 L
.79271 .22846 L
.79274 .22495 L
.79277 .22303 L
.7928 .2214 L
Mistroke
.79283 .22002 L
.79286 .21717 L
.79289 .21362 L
.79291 .21167 L
.79293 .20983 L
.79294 .20852 L
.79296 .20824 L
.793 .20769 L
.79303 .20718 L
.79306 .20203 L
.79312 .18856 L
.79318 .17778 L
.79321 .17215 L
.79322 .16899 L
.79324 .16842 L
.79327 .16766 L
.79329 .16693 L
.79332 .16626 L
.79334 .16346 L
.79346 .15237 L
.79357 .14371 L
.7936 .14141 L
.79362 .14049 L
.79363 .13989 L
.79366 .13873 L
.79369 .13764 L
.79372 .13603 L
.79375 .13394 L
.79381 .12918 L
.79394 .1217 L
.79397 .1217 L
.794 .1207 L
.79401 .11885 L
.79403 .11681 L
.79406 .11323 L
.79409 .11023 L
.79412 .10958 L
.79417 .10839 L
.79423 .10743 L
.79426 .10698 L
.79428 .10678 L
.79431 .10703 L
.79433 .10731 L
.79436 .10761 L
.79439 .10841 L
.79444 .11116 L
.79447 .11306 L
.7945 .11602 L
.79461 .12644 L
.79464 .12887 L
Mistroke
.79467 .13057 L
.7947 .13072 L
.79472 .13086 L
.79475 .13102 L
.79478 .12985 L
.79482 .12869 L
.79483 .12805 L
.79485 .12746 L
.79486 .12747 L
.79488 .12757 L
.79491 .12774 L
.79493 .12783 L
.79495 .12789 L
.79497 .12759 L
.79498 .12731 L
.79505 .12621 L
.79508 .12558 L
.79511 .1249 L
.79514 .12437 L
.79516 .12671 L
.7952 .12935 L
.79522 .13186 L
.79526 .13131 L
.79528 .12976 L
.79535 .1258 L
.79541 .12146 L
.79542 .12027 L
.79544 .11966 L
.79547 .1187 L
.79549 .11786 L
.79552 .1167 L
.79555 .11276 L
.79558 .10908 L
.7956 .10691 L
.79561 .10466 L
.79563 .10615 L
.79565 .10752 L
.79568 .11006 L
.79569 .11141 L
.79571 .11287 L
.79574 .10977 L
.79577 .10679 L
.7958 .1034 L
.79583 .10164 L
.79586 .10035 L
.79588 .09918 L
.79591 .09828 L
.79593 .0981 L
.79594 .09793 L
.79597 .09763 L
Mistroke
.796 .09756 L
.79603 .10019 L
.79606 .10296 L
.79608 .10528 L
.79611 .10505 L
.79613 .10339 L
.79616 .10188 L
.79618 .1001 L
.79621 .10145 L
.79627 .10437 L
.79725 .15316 L
.79773 .18487 L
.79785 .19845 L
.79788 .2056 L
.7979 .20953 L
.79791 .21164 L
.79794 .21097 L
.79797 .21037 L
.798 .20981 L
.79802 .21093 L
.79808 .21446 L
.7981 .21602 L
.79813 .21681 L
.79816 .21763 L
.79819 .21841 L
.79822 .21608 L
.79825 .21303 L
.79827 .21026 L
.7983 .21078 L
.79833 .21737 L
.79836 .22334 L
.79839 .22997 L
.79842 .23155 L
.79863 .24069 L
.79885 .24905 L
.79891 .2512 L
.79893 .25207 L
.79895 .25303 L
.79896 .25375 L
.79898 .25391 L
.79901 .25424 L
.79903 .25442 L
.79904 .25458 L
.79907 .25657 L
.7991 .2609 L
.79913 .2651 L
.79916 .26787 L
.79918 .26385 L
.79921 .25946 L
.79924 .25472 L
Mistroke
.79926 .25324 L
.79927 .25257 L
.7993 .25134 L
.79933 .25003 L
.79935 .2502 L
.79937 .25264 L
.79939 .25694 L
.79941 .25936 L
.79943 .26196 L
.79945 .26354 L
.79946 .26354 L
.79949 .26354 L
.79951 .26354 L
.79952 .26354 L
.79955 .26364 L
.79958 .26379 L
.79961 .26394 L
.79963 .26447 L
.79966 .26791 L
.79969 .27153 L
.79972 .27469 L
.79974 .274 L
.79976 .27022 L
.79979 .26618 L
.79982 .26208 L
.79984 .26319 L
.79986 .2642 L
.79988 .26604 L
.79991 .26806 L
.79994 .26722 L
.79997 .26623 L
.8 .26518 L
.80003 .26169 L
.80009 .24877 L
.8001 .24506 L
.80012 .24344 L
.80015 .24126 L
.80018 .23934 L
.80021 .2382 L
.80024 .24164 L
.80027 .2448 L
.8003 .24812 L
.80032 .24908 L
.80033 .24996 L
.80039 .25328 L
.80043 .25531 L
.80045 .25639 L
.80047 .25753 L
.80048 .25852 L
.8005 .25748 L
Mistroke
.80052 .25559 L
.80053 .25382 L
.80056 .25063 L
.80059 .24983 L
.80061 .25354 L
.80062 .25751 L
.80065 .26466 L
.80068 .27088 L
.80071 .27149 L
.80074 .27204 L
.80077 .27264 L
.8008 .27641 L
.80083 .282 L
.80086 .28723 L
.80089 .29039 L
.8009 .29147 L
.80092 .29249 L
.80094 .29366 L
.80095 .29475 L
.80098 .29563 L
.801 .29563 L
.80102 .29563 L
.80105 .29563 L
.80106 .29552 L
.80108 .29389 L
.80111 .29033 L
.80115 .28709 L
.80117 .28507 L
.8012 .28386 L
.80123 .2826 L
.80125 .28188 L
.80126 .28194 L
.80128 .28236 L
.8013 .28282 L
.80131 .28329 L
.80133 .28375 L
.80135 .28417 L
.80136 .28591 L
.80139 .28943 L
.80143 .29393 L
.80147 .29713 L
.8015 .29956 L
.80153 .3018 L
.80156 .30169 L
.80159 .30072 L
.80162 .29974 L
.80164 .29882 L
.80165 .29578 L
.80169 .28968 L
.80172 .2839 L
Mistroke
.80173 .28113 L
.80175 .28103 L
.80178 .28085 L
.80181 .2807 L
.80184 .27896 L
.80186 .27737 L
.80187 .27565 L
.8019 .27253 L
.80193 .2719 L
.80196 .27482 L
.80199 .27752 L
.80202 .28002 L
.80205 .28042 L
.80208 .28076 L
.80211 .28107 L
.80214 .28075 L
.80216 .28031 L
.80219 .2799 L
.80222 .2798 L
.80225 .2806 L
.80228 .28146 L
.80229 .2819 L
.80231 .2823 L
.80234 .28282 L
.80237 .28331 L
.80241 .2835 L
.80244 .28237 L
.80246 .28137 L
.80249 .28027 L
.80252 .28264 L
.80254 .28546 L
.80257 .28843 L
.8026 .28935 L
.80263 .28654 L
.80265 .28387 L
.80268 .28148 L
.8027 .28218 L
.80273 .28471 L
.80276 .28749 L
.80279 .28756 L
.80282 .2824 L
.80285 .27791 L
.80287 .27319 L
.8029 .2727 L
.80293 .27256 L
.80296 .2724 L
.80298 .27203 L
.80299 .27128 L
.80302 .26993 L
.80305 .26845 L
Mistroke
.80308 .26768 L
.80311 .26768 L
.80313 .26768 L
.80316 .26768 L
.80319 .26338 L
.80322 .25898 L
.80325 .25469 L
.80328 .25625 L
.80331 .26017 L
.80333 .26223 L
.80335 .26441 L
.80336 .26521 L
.80338 .26403 L
.80341 .26195 L
.80343 .26015 L
.80346 .2574 L
.80349 .25323 L
.80351 .24944 L
.80357 .24097 L
.80362 .23483 L
.80365 .23234 L
.80368 .23171 L
.80371 .23103 L
.80374 .23043 L
.80376 .23098 L
.80379 .23157 L
.80382 .23223 L
.80385 .2296 L
.80388 .22455 L
.80391 .21908 L
.80394 .21593 L
.80396 .21767 L
.80399 .21969 L
.80401 .2208 L
.80403 .22152 L
.80405 .22076 L
.80409 .21994 L
.80411 .21923 L
.80414 .21913 L
.80417 .21929 L
.8042 .21944 L
.80422 .21894 L
.80425 .21694 L
.80428 .21471 L
.8043 .21237 L
.80434 .21085 L
.80437 .20975 L
.8044 .20857 L
.80441 .20876 L
.80443 .21027 L
Mistroke
.80446 .21289 L
.80449 .21537 L
.80452 .21575 L
.80454 .2133 L
.80458 .21059 L
.80459 .20922 L
.80461 .20902 L
.80464 .21002 L
.80467 .21095 L
.80469 .21152 L
.8047 .21071 L
.80473 .20689 L
.80477 .20275 L
.80479 .20042 L
.8048 .2007 L
.80483 .20267 L
.80485 .20375 L
.80487 .20475 L
.80489 .20575 L
.80492 .20442 L
.80495 .20324 L
.80498 .20212 L
.80501 .19656 L
.80503 .19085 L
.80506 .18459 L
.80509 .18155 L
.80512 .18126 L
.80515 .18094 L
.80517 .18076 L
.80518 .18017 L
.80522 .1785 L
.80525 .17703 L
.80528 .1772 L
.80531 .17988 L
.80533 .18232 L
.80536 .18513 L
.80539 .18389 L
.80541 .18248 L
.80544 .181 L
.80547 .18003 L
.80549 .18167 L
.80552 .18346 L
.80555 .18537 L
.80558 .18441 L
.8056 .18251 L
.80563 .18029 L
.80565 .17912 L
.80566 .17848 L
.80569 .17798 L
.80572 .17752 L
Mistroke
.80575 .17706 L
.80578 .17608 L
.80581 .17514 L
.80584 .17412 L
.80587 .17534 L
.80589 .17677 L
.80592 .17822 L
.80595 .17861 L
.80598 .17655 L
.80601 .17437 L
.80603 .17251 L
.80606 .16795 L
.80609 .16294 L
.80611 .16019 L
.80613 .15756 L
.80614 .15636 L
.80616 .15556 L
.80619 .15414 L
.80622 .15282 L
.80625 .15063 L
.8063 .14573 L
.80631 .1443 L
.80633 .14352 L
.80636 .14384 L
.80639 .14413 L
.80642 .14445 L
.80644 .14108 L
.80647 .13758 L
.80649 .13402 L
.80652 .13122 L
.80654 .13387 L
.80657 .13675 L
.8066 .13929 L
.80663 .14015 L
.80666 .13986 L
.80669 .13953 L
.80672 .13775 L
.80675 .13334 L
.80677 .12926 L
.8068 .12542 L
.80683 .12699 L
.80685 .1293 L
.80688 .13186 L
.80691 .13145 L
.80694 .12888 L
.80697 .12605 L
.807 .1242 L
.80702 .12516 L
.80704 .12603 L
.80706 .12763 L
Mistroke
.8071 .12872 L
.80713 .12776 L
.80715 .12689 L
.8072 .12542 L
.80723 .12479 L
.80726 .12411 L
.80729 .12424 L
.80732 .12513 L
.80735 .12591 L
.80737 .12675 L
.8074 .12622 L
.80743 .12551 L
.80746 .12471 L
.80748 .12429 L
.80751 .12429 L
.80754 .12429 L
.80756 .12429 L
.80759 .12443 L
.80762 .12459 L
.80765 .12476 L
.80768 .12382 L
.80771 .12251 L
.80776 .12034 L
.80801 .10876 L
.80804 .10876 L
.80807 .10907 L
.80811 .10943 L
.80814 .10977 L
.80817 .10632 L
.80819 .10277 L
.80822 .09889 L
.80824 .09793 L
.80826 .09958 L
.80829 .10322 L
.80831 .10513 L
.80833 .10717 L
.80834 .10718 L
.80836 .10629 L
.80839 .10473 L
.80842 .10323 L
.80844 .10307 L
.80846 .10307 L
.80849 .10307 L
.80852 .10307 L
.80855 .10444 L
.80858 .10628 L
.8086 .1078 L
.80863 .11029 L
.80866 .11413 L
.80869 .11819 L
Mistroke
.80875 .1263 L
.80881 .13486 L
.80887 .14273 L
.80889 .14615 L
.80892 .14875 L
.80895 .15029 L
.80897 .15172 L
.80899 .15259 L
.809 .1531 L
.80904 .1519 L
.80906 .15084 L
.8091 .14967 L
.80911 .14938 L
.80913 .14911 L
.80915 .14881 L
.80916 .14854 L
.8092 .14819 L
.80921 .14856 L
.80923 .1489 L
.80926 .14948 L
.80928 .15009 L
.80931 .15239 L
.80934 .15469 L
.80937 .15723 L
.80939 .15755 L
.80941 .15684 L
.80944 .15548 L
.80947 .1542 L
.8095 .15359 L
.80953 .15326 L
.80956 .15296 L
.80958 .15213 L
.80964 .14753 L
.80965 .14627 L
.80967 .14511 L
.8097 .1484 L
.80973 .15188 L
.80976 .15519 L
.80979 .15339 L
.80982 .15112 L
.80984 .14988 L
.80985 .1487 L
.80987 .14806 L
.80989 .14796 L
.80992 .1478 L
.80993 .14772 L
.80995 .14763 L
.80998 .14716 L
.81 .1466 L
.81003 .14595 L
Mistroke
.81006 .14463 L
.81008 .14149 L
.81011 .13808 L
.81014 .13486 L
.81016 .13443 L
.81019 .13607 L
.81021 .1376 L
.81027 .14044 L
.81039 .14751 L
.81132 .20892 L
.8118 .24357 L
.81183 .24914 L
.81185 .25207 L
.81186 .25516 L
.81188 .25564 L
.8119 .25546 L
.81193 .25513 L
.81194 .25493 L
.81196 .25488 L
.81198 .25647 L
.812 .25791 L
.81206 .26353 L
.81209 .26579 L
.81213 .26818 L
.81214 .26943 L
.81216 .26992 L
.81218 .26911 L
.81219 .26836 L
.81222 .26697 L
.81225 .26563 L
.81227 .2658 L
.81228 .26598 L
.81231 .26631 L
.81234 .26664 L
.81236 .2674 L
.81238 .2681 L
.81241 .26936 L
.81242 .27002 L
.81244 .27074 L
.81247 .27407 L
.81249 .27727 L
.81255 .28379 L
.81259 .28681 L
.81262 .29011 L
.81265 .2944 L
.81269 .2988 L
.81272 .30309 L
.81274 .30981 L
.81278 .31909 L
.81281 .3275 L
Mistroke
.81283 .33121 L
.81286 .33089 L
.81289 .33056 L
.81292 .32997 L
.81295 .32852 L
.81297 .3272 L
.813 .32568 L
.81303 .33011 L
.81327 .38278 L
.81375 .45725 L
.81396 .48287 L
.81419 .51353 L
.81422 .52107 L
.81424 .52506 L
.81425 .52931 L
.81428 .52909 L
.81431 .52801 L
.81434 .52688 L
.81437 .5277 L
.81439 .52935 L
.81442 .53114 L
.81448 .53472 L
.81451 .53668 L
.81454 .53852 L
.81456 .53537 L
.81458 .5302 L
.81464 .51989 L
.81513 .45327 L
.81561 .36652 L
.81564 .36471 L
.81567 .36281 L
.81569 .36188 L
.81571 .36178 L
.81574 .36161 L
.81577 .36144 L
.81579 .3604 L
.8158 .35654 L
.81586 .34193 L
.81592 .32815 L
.81595 .3212 L
.81597 .31739 L
.81599 .3158 L
.81601 .31444 L
.81603 .31295 L
.81604 .31158 L
.81606 .31032 L
.81608 .30791 L
.81609 .30428 L
.81613 .29625 L
.81616 .28912 L
Mistroke
.81619 .2875 L
.8162 .28724 L
.81622 .28696 L
.81625 .28646 L
.81628 .2835 L
.81631 .27919 L
.81634 .27515 L
.81637 .27339 L
.8164 .27506 L
.81641 .27592 L
.81643 .27685 L
.81646 .27671 L
.81649 .27232 L
.81662 .25596 L
.81668 .25172 L
.81671 .24997 L
.81674 .24796 L
.81677 .24169 L
.8168 .23494 L
.81683 .22794 L
.81685 .22723 L
.81686 .22714 L
.81689 .22699 L
.81692 .22684 L
.81695 .22487 L
.81698 .22228 L
.817 .22 L
.81703 .21815 L
.81706 .21924 L
.81708 .22025 L
.81711 .22136 L
.81715 .21888 L
.81717 .21584 L
.8172 .21261 L
.81723 .21126 L
.81726 .21126 L
.81729 .21126 L
.81731 .2113 L
.81734 .2134 L
.81737 .2156 L
.8174 .21749 L
.81743 .2169 L
.81746 .21535 L
.81748 .2145 L
.81749 .2137 L
.81751 .21164 L
.81753 .20796 L
.81756 .20153 L
.81758 .19542 L
.81761 .19019 L
Mistroke
.81767 .18324 L
.8177 .17976 L
.81772 .18091 L
.81775 .18229 L
.81778 .18357 L
.81781 .18361 L
.81784 .18332 L
.81787 .18301 L
.81789 .18296 L
.81792 .18365 L
.81795 .1844 L
.81797 .18511 L
.818 .18354 L
.81823 .17287 L
.81825 .17449 L
.81827 .17621 L
.81828 .1749 L
.8183 .17297 L
.81833 .16921 L
.81837 .16572 L
.81839 .1687 L
.81842 .17191 L
.81844 .17365 L
.81846 .17548 L
.81849 .17063 L
.81851 .16452 L
.81854 .15874 L
.81857 .15535 L
.8186 .15535 L
.81862 .15535 L
.81865 .15535 L
.81868 .15333 L
.81871 .15134 L
.81873 .1492 L
.81876 .14748 L
.81879 .14638 L
.81882 .14535 L
.81885 .14299 L
.81887 .13989 L
.81889 .13709 L
.81892 .13164 L
.81894 .1274 L
.81897 .1274 L
.819 .1274 L
.81903 .1274 L
.81906 .12806 L
.81911 .12948 L
.81917 .13119 L
.8192 .13213 L
.81923 .13302 L
Mistroke
.81925 .13617 L
.81928 .13983 L
.8193 .14325 L
.81933 .14653 L
.81936 .14847 L
.81938 .15024 L
.81941 .15236 L
.81944 .15179 L
.81947 .14919 L
.81948 .1477 L
.8195 .14634 L
.81952 .14506 L
.81953 .14625 L
.81957 .14884 L
.8196 .15109 L
.81961 .15219 L
.81963 .15161 L
.81968 .1496 L
.81971 .14867 L
.81974 .14897 L
.8198 .14959 L
.81986 .15025 L
.81989 .15058 L
.8199 .15052 L
.81992 .15009 L
.81995 .14933 L
.81998 .14852 L
.81999 .14811 L
.82001 .14904 L
.82004 .15067 L
.82011 .15424 L
.82014 .15573 L
.82017 .15714 L
.82018 .15792 L
.8202 .15692 L
.82023 .15512 L
.82026 .15339 L
.82029 .15343 L
.82032 .15613 L
.82035 .15909 L
.82037 .16205 L
.8204 .16099 L
.82043 .16002 L
.82046 .15899 L
.82049 .15854 L
.82051 .15869 L
.82053 .15878 L
.82055 .15887 L
.82058 .16071 L
.8206 .16536 L
Mistroke
.82063 .17027 L
.82065 .17452 L
.82068 .17753 L
.82071 .17992 L
.82073 .18215 L
.82079 .18578 L
.82082 .18706 L
.82085 .18843 L
.82088 .18895 L
.82091 .18939 L
.82094 .18987 L
.82097 .19247 L
.821 .19654 L
.82102 .19849 L
.82104 .20033 L
.82105 .20077 L
.82107 .19947 L
.8211 .19653 L
.82112 .19508 L
.82114 .19355 L
.82116 .19449 L
.82117 .19614 L
.8212 .19883 L
.82123 .20172 L
.82125 .20118 L
.82127 .20038 L
.8213 .19882 L
.82133 .19738 L
.82136 .19776 L
.82139 .19821 L
.82142 .19869 L
.82144 .19978 L
.82146 .20141 L
.82149 .20462 L
.82152 .20753 L
.82155 .20692 L
.82158 .20555 L
.8216 .20426 L
.82163 .20413 L
.82166 .20533 L
.82169 .20665 L
.82171 .20735 L
.82173 .20856 L
.82176 .21124 L
.82178 .21372 L
.82181 .21562 L
.82185 .21305 L
.82187 .21078 L
.8219 .20836 L
.82193 .21004 L
Mistroke
.82196 .21192 L
.82199 .21381 L
.82201 .21422 L
.82204 .21231 L
.82207 .21028 L
.82213 .20547 L
.82216 .20247 L
.82219 .19926 L
.82221 .19891 L
.82222 .19899 L
.82225 .19917 L
.82228 .19932 L
.82231 .19898 L
.82234 .19858 L
.82236 .19814 L
.82239 .19788 L
.82242 .19817 L
.82245 .19849 L
.82246 .19866 L
.82248 .19878 L
.82251 .19757 L
.82253 .19643 L
.82256 .19513 L
.82259 .19478 L
.82269 .19381 L
.82272 .19209 L
.82275 .19023 L
.82278 .19073 L
.82281 .19262 L
.82287 .19695 L
.8229 .20022 L
.82293 .20326 L
.82296 .20517 L
.82299 .20108 L
.82302 .19662 L
.82305 .19242 L
.82307 .19345 L
.8231 .19599 L
.82313 .19814 L
.82315 .19976 L
.82319 .19925 L
.82321 .19878 L
.82323 .19849 L
.82325 .19758 L
.82328 .19381 L
.82331 .18978 L
.82333 .18757 L
.82335 .18616 L
.82338 .18419 L
.8234 .18313 L
Mistroke
.82341 .18202 L
.82344 .18184 L
.82347 .18528 L
.8235 .18903 L
.82353 .19303 L
.82356 .19443 L
.82359 .19567 L
.82361 .19643 L
.82362 .19714 L
.82365 .19743 L
.82368 .19758 L
.82371 .19774 L
.82374 .19614 L
.82377 .19378 L
.8238 .19095 L
.82383 .18832 L
.82389 .18484 L
.82392 .18346 L
.82393 .18435 L
.82395 .18518 L
.82402 .1887 L
.82407 .19118 L
.82409 .19186 L
.82411 .19258 L
.82414 .1912 L
.82416 .18987 L
.82419 .18861 L
.82422 .18999 L
.82425 .19335 L
.82435 .20662 L
.82438 .21044 L
.82441 .21288 L
.82443 .21301 L
.82446 .21316 L
.82449 .21333 L
.82451 .21379 L
.82452 .21421 L
.82458 .21579 L
.82464 .21473 L
.82465 .21438 L
.82467 .21401 L
.8247 .21548 L
.82473 .21751 L
.82476 .21939 L
.82479 .21996 L
.82482 .21842 L
.82484 .21758 L
.82485 .21666 L
.82487 .216 L
.82489 .21663 L
Mistroke
.82495 .21905 L
.82507 .2234 L
.82529 .23588 L
.82532 .23874 L
.82535 .24114 L
.82538 .2379 L
.82541 .23435 L
.82544 .23075 L
.82546 .23303 L
.82547 .2359 L
.8255 .24147 L
.82553 .24661 L
.82556 .24725 L
.82559 .24693 L
.82562 .24662 L
.82564 .2464 L
.82565 .24589 L
.82568 .24492 L
.82571 .244 L
.82574 .24329 L
.82576 .24299 L
.82579 .2427 L
.82582 .2424 L
.82584 .23965 L
.82587 .23617 L
.82589 .23212 L
.82592 .22823 L
.82595 .22746 L
.82598 .22676 L
.82601 .22601 L
.82604 .22618 L
.82606 .22678 L
.82609 .22733 L
.82612 .22819 L
.82613 .2291 L
.82615 .22994 L
.82618 .23157 L
.82621 .23319 L
.82624 .23583 L
.82626 .23867 L
.82633 .24654 L
.82645 .26034 L
.82744 .35488 L
.8275 .36119 L
.82752 .36277 L
.82753 .36445 L
.82756 .36262 L
.82759 .35843 L
.82762 .35451 L
.82765 .35325 L
Mistroke
.82768 .35923 L
.82772 .36606 L
.82775 .3713 L
.82778 .3749 L
.82781 .37823 L
.82784 .37899 L
.82787 .37639 L
.8279 .37378 L
.82792 .3723 L
.82794 .37363 L
.82796 .37901 L
.82799 .3849 L
.82805 .39391 L
.82816 .40999 L
.82819 .41716 L
.8282 .42094 L
.82822 .42339 L
.82825 .42493 L
.82828 .42635 L
.82831 .42778 L
.82833 .43034 L
.82837 .43332 L
.82839 .43615 L
.82842 .43727 L
.82845 .43776 L
.82848 .4382 L
.8285 .43902 L
.82854 .44131 L
.82856 .44338 L
.82859 .44574 L
.82862 .4451 L
.82865 .44445 L
.82869 .44377 L
.82871 .43612 L
.82874 .42633 L
.82877 .41578 L
.82879 .41115 L
.82881 .40885 L
.82887 .40017 L
.82931 .34296 L
.82981 .28836 L
.83003 .26018 L
.83014 .24531 L
.83018 .23949 L
.8302 .23408 L
.83024 .23196 L
.83025 .23196 L
.83027 .23196 L
.83028 .23196 L
.8303 .23196 L
Mistroke
.83033 .23087 L
.83036 .22926 L
.83039 .22777 L
.83042 .22726 L
.83044 .22908 L
.83047 .23102 L
.8305 .23278 L
.83053 .23131 L
.83055 .22949 L
.83061 .22627 L
.83064 .22627 L
.83067 .22627 L
.83069 .22627 L
.83072 .22193 L
.83077 .20961 L
.8308 .20466 L
.83083 .20264 L
.83086 .20072 L
.83089 .19894 L
.83091 .19911 L
.83094 .19942 L
.83096 .19959 L
.83098 .19977 L
.83101 .20034 L
.83103 .20092 L
.83106 .20157 L
.83108 .20193 L
.8311 .2002 L
.83113 .1963 L
.83119 .19115 L
.83144 .17249 L
.8315 .16324 L
.83153 .15883 L
.83156 .15535 L
.83159 .15535 L
.83162 .15535 L
.83165 .15535 L
.83168 .15793 L
.8317 .16052 L
.83173 .1633 L
.83175 .16463 L
.83178 .15982 L
.83181 .15442 L
.83184 .1493 L
.83186 .1485 L
.83189 .14909 L
.83192 .14969 L
.83195 .14952 L
.83196 .14836 L
.83198 .1471 L
Mistroke
.83201 .14483 L
.83204 .14282 L
.83207 .14185 L
.83212 .14012 L
.83304 .11308 L
.83307 .11171 L
.8331 .10981 L
.83313 .10647 L
.83316 .1028 L
.83318 .10087 L
.8332 .1013 L
.83322 .1025 L
.83323 .10365 L
.83327 .10566 L
.83328 .10668 L
.8333 .10659 L
.83333 .10642 L
.83336 .10625 L
.83339 .10527 L
.83342 .10319 L
.83345 .10112 L
.83348 .09911 L
.8335 .09833 L
.83352 .09761 L
.83355 .09621 L
.83358 .09522 L
.83361 .09487 L
.83364 .09458 L
.83367 .09441 L
.8337 .09798 L
.83373 .10176 L
.83376 .10511 L
.83379 .10449 L
.83382 .10391 L
.83385 .10329 L
.83387 .1024 L
.8339 .1011 L
.83393 .0997 L
.83396 .09799 L
.83399 .09516 L
.83401 .09258 L
.83407 .08761 L
.8341 .08552 L
.83413 .08358 L
.83416 .08505 L
.83419 .08907 L
.83422 .0935 L
.83424 .0971 L
.83426 .09787 L
.83428 .09868 L
Mistroke
.83429 .09956 L
.83431 .10039 L
.83434 .10115 L
.83436 .10037 L
.83437 .09952 L
.83441 .09804 L
.83442 .0973 L
.83444 .09759 L
.83447 .10045 L
.83449 .10311 L
.83495 .14305 L
.83498 .14561 L
.835 .14804 L
.83503 .14599 L
.83506 .14402 L
.83509 .14217 L
.83511 .1418 L
.83514 .14266 L
.83517 .14359 L
.8352 .14452 L
.83523 .14497 L
.83525 .14539 L
.83528 .14583 L
.83531 .14851 L
.83534 .15245 L
.8354 .16147 L
.83565 .1945 L
.83571 .20353 L
.83574 .20741 L
.83577 .21099 L
.8358 .21263 L
.83583 .21424 L
.83589 .21679 L
.83592 .21798 L
.83595 .21911 L
.83598 .21869 L
.836 .21798 L
.83601 .21721 L
.83604 .21591 L
.83607 .21379 L
.8361 .21139 L
.83613 .20922 L
.83615 .20787 L
.83616 .20954 L
.8362 .21475 L
.83623 .2193 L
.83626 .22326 L
.83628 .2247 L
.83629 .22629 L
.83633 .22908 L
Mistroke
.83634 .2305 L
.83636 .23114 L
.8364 .23228 L
.83646 .23433 L
.83649 .23533 L
.83652 .23625 L
.83654 .23749 L
.83655 .24074 L
.83659 .24758 L
.83662 .25326 L
.83663 .25501 L
.83665 .25443 L
.83668 .25328 L
.83671 .25219 L
.83673 .25175 L
.83676 .25205 L
.83679 .25238 L
.83681 .25256 L
.83683 .2528 L
.83685 .25339 L
.83688 .25405 L
.83691 .25473 L
.83694 .25973 L
.83697 .2643 L
.837 .26917 L
.83703 .27184 L
.83706 .27324 L
.83713 .27655 L
.8372 .28044 L
.83723 .28235 L
.83727 .2841 L
.8373 .2857 L
.83733 .2909 L
.83739 .3023 L
.83745 .31163 L
.83747 .31432 L
.83748 .31686 L
.83751 .31827 L
.83754 .31872 L
.83756 .31913 L
.83759 .31973 L
.83762 .3207 L
.83764 .32122 L
.83766 .32178 L
.83769 .32217 L
.8377 .32125 L
.83772 .32042 L
.83774 .31942 L
.83775 .31851 L
.83778 .31829 L
Mistroke
.8378 .31991 L
.83782 .32163 L
.83788 .32743 L
.83793 .33016 L
.83796 .33169 L
.83799 .33515 L
.8381 .34807 L
.83813 .35084 L
.83816 .35342 L
.83819 .35121 L
.83822 .34916 L
.83823 .3479 L
.83825 .34671 L
.83828 .3461 L
.83831 .34576 L
.83832 .34558 L
.83834 .34539 L
.83837 .34264 L
.8384 .33944 L
.83842 .33597 L
.83845 .33262 L
.83849 .33005 L
.83852 .32762 L
.83857 .32342 L
.8386 .32149 L
.83862 .31968 L
.83865 .3184 L
.83868 .31744 L
.8387 .31667 L
.83873 .31587 L
.83876 .31638 L
.83878 .31692 L
.83881 .31757 L
.83883 .31804 L
.83884 .31921 L
.8389 .32364 L
.83896 .32913 L
.83899 .33213 L
.83901 .33487 L
.83904 .33138 L
.83907 .3258 L
.83908 .32289 L
.8391 .31972 L
.83913 .31874 L
.83916 .32115 L
.83918 .32247 L
.8392 .32371 L
.83922 .32307 L
.83924 .32166 L
.83926 .32014 L
Mistroke
.83928 .31775 L
.83931 .31564 L
.83934 .31481 L
.83937 .31405 L
.83938 .31363 L
.8394 .31339 L
.83943 .31599 L
.83946 .31831 L
.83949 .32086 L
.83951 .31924 L
.83954 .31631 L
.83957 .31295 L
.8396 .31031 L
.83962 .30909 L
.83965 .30793 L
.8397 .30456 L
.83982 .29607 L
.83983 .2965 L
.83985 .29695 L
.83988 .29738 L
.83991 .29327 L
.83995 .28875 L
.84001 .27946 L
.84004 .27508 L
.84007 .27033 L
.8401 .26707 L
.84012 .26408 L
.84015 .26122 L
.84018 .2613 L
.84021 .26362 L
.84023 .26575 L
.84026 .2681 L
.84029 .26378 L
.84033 .25592 L
.84039 .24956 L
.84042 .24666 L
.84044 .24402 L
.84047 .24412 L
.8405 .24508 L
.84052 .24614 L
.84055 .24762 L
.84057 .24896 L
.84059 .25043 L
.84062 .25301 L
.84068 .25768 L
.84071 .25977 L
.84073 .2617 L
.84077 .26243 L
.84078 .26271 L
.8408 .263 L
Mistroke
.84083 .26351 L
.84086 .26118 L
.84089 .25879 L
.84092 .25627 L
.84093 .25527 L
.84095 .25536 L
.84098 .25552 L
.84101 .25567 L
.84103 .2562 L
.84106 .25727 L
.84109 .25823 L
.84115 .26069 L
.84118 .26212 L
.84121 .26346 L
.84123 .26323 L
.84125 .26286 L
.84126 .26247 L
.84128 .26207 L
.8413 .26172 L
.84132 .26046 L
.84135 .25524 L
.84138 .24991 L
.84141 .24573 L
.84143 .24734 L
.84144 .24909 L
.84147 .25214 L
.8415 .25431 L
.84154 .25019 L
.84157 .24637 L
.84159 .24282 L
.84162 .2441 L
.84164 .24519 L
.84165 .24635 L
.84168 .24829 L
.84171 .24915 L
.84174 .2493 L
.84177 .24946 L
.84179 .24986 L
.84182 .25133 L
.84188 .25461 L
.84191 .25616 L
.84195 .25781 L
.84196 .25861 L
.84198 .25937 L
.84201 .26233 L
.84203 .26512 L
.84206 .26819 L
.84209 .26848 L
.84212 .26736 L
.84215 .26608 L
Mistroke
.84217 .26471 L
.8422 .2624 L
.84222 .26021 L
.84225 .25789 L
.84227 .2577 L
.8423 .26196 L
.84233 .26582 L
.84236 .26947 L
.84239 .26722 L
.8425 .2589 L
.84253 .2568 L
.84256 .25556 L
.84259 .25648 L
.84262 .25732 L
.84265 .25831 L
.84266 .26047 L
.84268 .26261 L
.84274 .27073 L
.8428 .28007 L
.84283 .28468 L
.84286 .28735 L
.84289 .28956 L
.84292 .29194 L
.84294 .29283 L
.84295 .28913 L
.84299 .28167 L
.84302 .27516 L
.84304 .27242 L
.84307 .27256 L
.8431 .27271 L
.84313 .27304 L
.84314 .27427 L
.84316 .27562 L
.84319 .27804 L
.84322 .28025 L
.84324 .2774 L
.84327 .27374 L
.84333 .26538 L
.84338 .25703 L
.8434 .25233 L
.84343 .25212 L
.84346 .25377 L
.84348 .25467 L
.84349 .25551 L
.84352 .25416 L
.84355 .24937 L
.84358 .24512 L
.8436 .24125 L
.84363 .24061 L
.84366 .24003 L
Mistroke
.84369 .23939 L
.84372 .24122 L
.84375 .24355 L
.84378 .24613 L
.8438 .24742 L
.84381 .2461 L
.84385 .24314 L
.84388 .24039 L
.84391 .23984 L
.84394 .24089 L
.84396 .24185 L
.84399 .24253 L
.84402 .23986 L
.84412 .23153 L
.84417 .22861 L
.84423 .22467 L
.84426 .22257 L
.84428 .22183 L
.84429 .22295 L
.84435 .227 L
.84441 .23218 L
.84442 .23368 L
.84444 .2353 L
.84447 .23733 L
.84449 .23642 L
.8445 .23558 L
.84454 .23365 L
.8446 .23069 L
.84463 .22953 L
.84466 .22832 L
.84469 .22782 L
.84472 .22735 L
.84473 .22709 L
.84475 .22682 L
.84478 .22978 L
.84481 .23287 L
.84484 .23576 L
.84486 .23444 L
.84489 .23098 L
.84492 .22747 L
.84495 .22514 L
.84497 .22594 L
.84498 .22668 L
.84501 .22816 L
.84504 .22943 L
.84507 .23006 L
.8451 .23067 L
.84513 .23132 L
.84516 .22887 L
.84518 .22591 L
Mistroke
.84521 .223 L
.84523 .22075 L
.84526 .2225 L
.84528 .22442 L
.84531 .22657 L
.84533 .22709 L
.84535 .22636 L
.84538 .22504 L
.84541 .22384 L
.84542 .22316 L
.84544 .22325 L
.84547 .22344 L
.8455 .22361 L
.84552 .22341 L
.84554 .22237 L
.84557 .22035 L
.8456 .21843 L
.84562 .21909 L
.84565 .22311 L
.84568 .2275 L
.8457 .22971 L
.84572 .22986 L
.84575 .22607 L
.84577 .22253 L
.84599 .20436 L
.84605 .19514 L
.84607 .19034 L
.8461 .18783 L
.84613 .18753 L
.84616 .18721 L
.84619 .18626 L
.8462 .18383 L
.84622 .18118 L
.84625 .17607 L
.84627 .17321 L
.84629 .17309 L
.8463 .17527 L
.84632 .17763 L
.84635 .18192 L
.84638 .1854 L
.8464 .18549 L
.84641 .18558 L
.84644 .18574 L
.84647 .18586 L
.8465 .18335 L
.84653 .18106 L
.84656 .1786 L
.84658 .17905 L
.84659 .18035 L
.84662 .18268 L
Mistroke
.84665 .18488 L
.84668 .18427 L
.84671 .18183 L
.84674 .17939 L
.84676 .17758 L
.84679 .17743 L
.84682 .17727 L
.84685 .17713 L
.84687 .17617 L
.84692 .17329 L
.84695 .1721 L
.84698 .17329 L
.84701 .17457 L
.84702 .17525 L
.84704 .17598 L
.84707 .17434 L
.8471 .17262 L
.84715 .16943 L
.84721 .16791 L
.84723 .16749 L
.84724 .16721 L
.84727 .16706 L
.8473 .16692 L
.84732 .16677 L
.84735 .16421 L
.84738 .16121 L
.8474 .15945 L
.84742 .15753 L
.84743 .15514 L
.84745 .15201 L
.84751 .13976 L
.84757 .12979 L
.8476 .12517 L
.84763 .12218 L
.84764 .12209 L
.84766 .122 L
.84768 .1219 L
.84769 .12181 L
.84772 .12067 L
.84774 .11908 L
.84776 .11737 L
.84777 .11555 L
.84779 .11357 L
.84781 .11186 L
.84783 .11177 L
.84786 .11158 L
.84788 .11149 L
.84789 .11141 L
.84792 .11249 L
.84795 .11458 L
Mistroke
.84797 .11567 L
.84798 .11686 L
.84801 .11727 L
.84803 .11626 L
.84805 .11535 L
.84806 .11437 L
.84808 .1133 L
.84811 .11256 L
.84814 .11288 L
.84817 .11319 L
.8482 .11395 L
.84823 .11552 L
.84826 .11696 L
.84829 .1186 L
.84831 .1186 L
.84832 .1186 L
.84835 .1186 L
.84838 .11849 L
.84841 .11378 L
.84845 .1087 L
.84847 .1043 L
.8485 .10188 L
.84854 .09967 L
.84856 .09854 L
.84857 .09739 L
.84859 .09795 L
.84861 .09846 L
.84864 .09945 L
.84867 .10036 L
.8487 .09847 L
.84872 .0965 L
.84875 .09439 L
.84878 .09371 L
.84881 .09462 L
.84887 .09714 L
.84909 .10352 L
.84934 .11703 L
.8494 .12195 L
.84942 .12341 L
.84944 .12412 L
.84946 .12368 L
.84948 .1232 L
.84951 .12232 L
.84952 .12188 L
.84954 .12195 L
.84957 .12263 L
.8496 .12327 L
.84963 .12381 L
.84965 .1239 L
.84967 .12399 L
Mistroke
.84969 .12414 L
.84973 .12497 L
.84975 .1306 L
.84978 .13588 L
.84981 .14162 L
.84984 .14518 L
.84987 .14713 L
.84988 .14812 L
.8499 .14918 L
.84993 .15219 L
.84996 .1561 L
.84997 .15846 L
.84999 .16103 L
.85001 .16345 L
.85002 .16371 L
.85005 .16387 L
.85009 .16404 L
.85011 .16451 L
.85014 .16591 L
.85017 .16746 L
.8502 .16886 L
.85023 .16983 L
.85026 .17075 L
.85029 .17157 L
.85031 .16937 L
.85035 .16447 L
.85036 .1618 L
.85038 .15931 L
.85041 .15814 L
.85042 .15881 L
.85044 .15953 L
.85047 .16089 L
.8505 .1627 L
.85056 .16721 L
.851 .21707 L
.85192 .34397 L
.85239 .43087 L
.85252 .45556 L
.85255 .46534 L
.85257 .47017 L
.85259 .47465 L
.85262 .47383 L
.85264 .47302 L
.85265 .47215 L
.85267 .47139 L
.85269 .4706 L
.8527 .4708 L
.85272 .47098 L
.85275 .47131 L
.85277 .47149 L
Mistroke
.85278 .47227 L
.85281 .47793 L
.85284 .48309 L
.8529 .49244 L
.85301 .50596 L
.85308 .51475 L
.85313 .52166 L
.85316 .52492 L
.85318 .52474 L
.8532 .52457 L
.85323 .52421 L
.85325 .52402 L
.85327 .52296 L
.8533 .51949 L
.85333 .51579 L
.85336 .5129 L
.85339 .5123 L
.85342 .51168 L
.85345 .51102 L
.85347 .51341 L
.8535 .51635 L
.85362 .52688 L
.85368 .5322 L
.85371 .53536 L
.85374 .53806 L
.85377 .53909 L
.8538 .5402 L
.85382 .54122 L
.85385 .53939 L
.85479 .47269 L
.85491 .45642 L
.85502 .44296 L
.85505 .43852 L
.85508 .43559 L
.85509 .436 L
.85511 .43645 L
.85514 .43724 L
.85516 .4377 L
.85517 .43793 L
.85519 .43775 L
.85521 .43756 L
.85524 .43723 L
.85525 .43705 L
.85527 .43669 L
.85529 .43599 L
.8553 .43526 L
.85532 .43448 L
.85534 .43375 L
.85535 .43307 L
.85537 .43157 L
Mistroke
.8554 .42819 L
.85543 .42414 L
.85547 .41808 L
.85554 .40386 L
.8556 .3938 L
.85563 .3885 L
.85566 .38462 L
.85568 .38325 L
.85569 .38176 L
.85573 .37915 L
.85579 .37353 L
.85582 .3709 L
.85585 .36639 L
.85588 .35951 L
.8559 .3532 L
.85596 .33963 L
.856 .33282 L
.85601 .32908 L
.85603 .3263 L
.85605 .32701 L
.85607 .32778 L
.8561 .32912 L
.85613 .32959 L
.85616 .32411 L
.85629 .2987 L
.85653 .26437 L
.85656 .26344 L
.85659 .26242 L
.85662 .25819 L
.85665 .25168 L
.85667 .24535 L
.8567 .23939 L
.85673 .23645 L
.85675 .23389 L
.85697 .21637 L
.85703 .21222 L
.85706 .21083 L
.85708 .20921 L
.85711 .20473 L
.85714 .19992 L
.85716 .19736 L
.85717 .19463 L
.8572 .19225 L
.85723 .1901 L
.85725 .18889 L
.85727 .18776 L
.85729 .18718 L
.85733 .18684 L
.85736 .18653 L
.85738 .18418 L
Mistroke
.85741 .17997 L
.85744 .17553 L
.85747 .17301 L
.85749 .17404 L
.8575 .17497 L
.85754 .17681 L
.85756 .17767 L
.85758 .17653 L
.8576 .17533 L
.85762 .17402 L
.85763 .17279 L
.85766 .16921 L
.85768 .16601 L
.8577 .16257 L
.85776 .1506 L
.85779 .14383 L
.85782 .13747 L
.85785 .13356 L
.85787 .13455 L
.85789 .13547 L
.85791 .13707 L
.85794 .13878 L
.85796 .13715 L
.85797 .13567 L
.858 .13277 L
.85802 .13115 L
.85804 .12949 L
.85806 .12995 L
.85807 .13037 L
.85809 .13081 L
.85811 .13128 L
.85812 .13173 L
.85814 .1317 L
.85815 .12976 L
.85817 .12792 L
.85821 .12374 L
.85824 .12127 L
.85827 .12157 L
.85829 .12189 L
.85831 .12206 L
.85833 .12219 L
.85836 .12138 L
.85838 .12063 L
.85841 .11994 L
.85844 .11732 L
.8585 .10891 L
.85857 .09842 L
.8586 .09343 L
.85861 .09108 L
.85863 .09015 L
Mistroke
.85866 .0886 L
.85869 .08698 L
.85872 .08656 L
.85875 .08783 L
.85882 .09156 L
.85885 .09493 L
.85888 .09854 L
.85891 .10001 L
.85894 .09676 L
.85904 .08277 L
.85907 .07856 L
.8591 .07575 L
.85913 .07607 L
.85916 .07637 L
.85919 .07653 L
.85922 .07264 L
.85925 .06928 L
.85927 .06562 L
.85929 .06435 L
.85931 .06373 L
.85934 .0625 L
.85937 .06138 L
.8594 .061 L
.85942 .06091 L
.85944 .06082 L
.85945 .06073 L
.85947 .06062 L
.85949 .06209 L
.8595 .06351 L
.85954 .06661 L
.8596 .07098 L
.85966 .07442 L
.85991 .09164 L
.85992 .09333 L
.85994 .09516 L
.85996 .09651 L
.85997 .09702 L
.86001 .09812 L
.86003 .09875 L
.86004 .09934 L
.86007 .0983 L
.86011 .09689 L
.86017 .09468 L
.8604 .08146 L
.86047 .0761 L
.86048 .07446 L
.8605 .07271 L
.86052 .07105 L
.86054 .07106 L
.86056 .07297 L
Mistroke
.86059 .07477 L
.86062 .07659 L
.86064 .07511 L
.86066 .07374 L
.86068 .0713 L
.86071 .06867 L
.86073 .06801 L
.86075 .06757 L
.86078 .06673 L
.86081 .06591 L
.86083 .06587 L
.86084 .06596 L
.86091 .06635 L
.86094 .06727 L
.86097 .06828 L
.861 .06923 L
.86102 .06714 L
.86106 .06373 L
.86107 .06186 L
.86109 .06011 L
.86112 .06026 L
.86115 .06227 L
.86118 .06406 L
.86121 .06423 L
.86123 .06161 L
.86126 .05918 L
.86129 .05677 L
.86131 .05736 L
.86134 .05854 L
.86136 .05964 L
.86139 .06144 L
.86142 .06596 L
.86145 .06987 L
.86147 .07406 L
.8615 .07659 L
.86153 .0784 L
.86155 .0795 L
.86156 .08054 L
.86159 .08007 L
.86162 .07815 L
.86165 .07608 L
.86168 .07442 L
.8617 .07372 L
.86174 .07289 L
.86176 .07212 L
.86179 .07215 L
.86181 .07223 L
.86183 .07233 L
.86184 .07241 L
.86186 .0725 L
Mistroke
.86188 .07414 L
.86189 .07621 L
.86193 .08025 L
.86196 .08403 L
.86198 .08238 L
.86201 .07988 L
.86207 .07516 L
.8621 .07367 L
.86213 .07208 L
.86215 .07116 L
.86216 .07168 L
.86219 .07345 L
.8623 .08241 L
.86252 .10436 L
.86302 .14971 L
.86348 .18335 L
.86396 .20603 L
.86441 .23093 L
.86486 .26603 L
.86489 .26686 L
.86492 .26764 L
.86495 .26644 L
.86498 .26501 L
.865 .26427 L
.86502 .26357 L
.86503 .2648 L
.86505 .26601 L
.86508 .26819 L
.8651 .26939 L
.86512 .27066 L
.86515 .27406 L
.86518 .27715 L
.86523 .28549 L
.86526 .29201 L
.86529 .29811 L
.86532 .30106 L
.86534 .30168 L
.86536 .30234 L
.86537 .30293 L
.86539 .30358 L
.86542 .30549 L
.86548 .3096 L
.86553 .31316 L
.86556 .315 L
.86559 .31659 L
.86561 .31436 L
.86563 .3123 L
.86566 .30828 L
.86567 .30605 L
.86569 .30451 L
Mistroke
.86571 .30487 L
.86572 .30527 L
.86576 .30593 L
.86578 .30639 L
.8658 .30561 L
.86582 .30477 L
.86585 .3033 L
.86588 .30195 L
.8659 .30585 L
.86593 .31104 L
.86596 .31578 L
.86599 .31862 L
.86602 .31984 L
.86605 .32113 L
.86608 .32288 L
.86613 .3269 L
.86618 .33199 L
.86624 .34005 L
.86627 .34368 L
.86629 .34322 L
.86633 .34269 L
.86636 .34217 L
.86637 .34146 L
.86639 .34079 L
.86642 .3393 L
.86645 .33823 L
.86648 .34133 L
.86654 .34834 L
.86657 .35316 L
.86661 .3586 L
.86662 .36111 L
.86664 .36374 L
.86667 .3652 L
.8667 .36667 L
.86674 .36804 L
.86675 .36702 L
.86677 .36576 L
.86679 .36447 L
.86681 .3631 L
.86682 .362 L
.86684 .36182 L
.86687 .36345 L
.8669 .36523 L
.86692 .36623 L
.86694 .36649 L
.86695 .36641 L
.86697 .36631 L
.867 .36615 L
.86703 .3646 L
.86706 .3604 L
Mistroke
.86709 .35596 L
.86712 .35197 L
.86715 .35072 L
.86717 .34938 L
.8672 .3479 L
.86722 .34755 L
.86724 .34809 L
.86726 .34899 L
.86729 .34995 L
.86732 .35207 L
.86735 .35523 L
.86742 .36222 L
.86748 .36822 L
.86754 .37427 L
.86757 .37712 L
.86759 .37984 L
.86762 .37943 L
.86765 .37814 L
.86771 .3753 L
.86773 .37428 L
.86776 .37318 L
.86779 .3712 L
.86782 .36643 L
.86785 .36134 L
.86787 .35856 L
.86789 .35722 L
.86792 .36034 L
.86795 .36377 L
.868 .37061 L
.86804 .3754 L
.86805 .37776 L
.86807 .37995 L
.8681 .37702 L
.86813 .37259 L
.86816 .36817 L
.86818 .3675 L
.8682 .36823 L
.86827 .37127 L
.86829 .37249 L
.86832 .3738 L
.86835 .37503 L
.86838 .37313 L
.86841 .36941 L
.86843 .36737 L
.86844 .36546 L
.86847 .36413 L
.8685 .36446 L
.86853 .36481 L
.86856 .36506 L
.86858 .36515 L
Mistroke
.8686 .36523 L
.86861 .36532 L
.86863 .36542 L
.86866 .36504 L
.86869 .36399 L
.8687 .36334 L
.86872 .36273 L
.86875 .36262 L
.86878 .365 L
.86881 .36761 L
.86883 .37034 L
.86886 .36694 L
.86889 .36297 L
.86891 .35866 L
.86894 .3559 L
.86896 .35668 L
.86899 .3576 L
.86902 .35857 L
.86905 .36019 L
.86908 .36228 L
.86911 .3645 L
.86912 .36575 L
.86914 .36603 L
.86917 .36603 L
.8692 .36603 L
.86923 .36637 L
.86924 .36792 L
.86926 .36934 L
.86929 .37191 L
.86932 .37474 L
.86934 .37253 L
.86937 .3703 L
.8694 .36794 L
.86943 .36726 L
.86946 .36897 L
.86949 .37083 L
.86955 .3747 L
.86958 .37661 L
.86961 .37776 L
.86964 .37733 L
.86967 .37684 L
.8697 .37639 L
.86972 .37887 L
.86975 .38181 L
.86978 .38447 L
.86981 .38498 L
.86983 .38369 L
.86986 .3823 L
.86989 .38076 L
.86991 .3772 L
Mistroke
.86994 .37348 L
.86997 .36931 L
.86999 .36664 L
.87002 .36696 L
.87005 .36725 L
.87008 .36757 L
.8701 .36792 L
.87011 .36825 L
.87014 .36893 L
.87017 .36958 L
.8702 .36827 L
.87023 .36654 L
.87026 .36465 L
.87028 .36331 L
.87029 .36075 L
.87033 .35617 L
.87035 .352 L
.87038 .34982 L
.87041 .34953 L
.87044 .34922 L
.87047 .34933 L
.8705 .35109 L
.87052 .35296 L
.87055 .35456 L
.87058 .35334 L
.8707 .34855 L
.87072 .34967 L
.87074 .35074 L
.87076 .35091 L
.87077 .34924 L
.87081 .34595 L
.87084 .34293 L
.87086 .34222 L
.87089 .34222 L
.87092 .34222 L
.87095 .3405 L
.87098 .33594 L
.87102 .33105 L
.87108 .32378 L
.87119 .30853 L
.87125 .29906 L
.87128 .29387 L
.87132 .28898 L
.87135 .29056 L
.87136 .29255 L
.87138 .29438 L
.8714 .29763 L
.87143 .29746 L
.87146 .29425 L
.87149 .29126 L
Mistroke
.87154 .28325 L
.8718 .24821 L
.87193 .23148 L
.87198 .22084 L
.87204 .2124 L
.87207 .20873 L
.8721 .20629 L
.87212 .20593 L
.87213 .2056 L
.87216 .20495 L
.87218 .20459 L
.8722 .2035 L
.87223 .20064 L
.87225 .19936 L
.87226 .19797 L
.8723 .19641 L
.87233 .19573 L
.87236 .1951 L
.87238 .19465 L
.87241 .1945 L
.87244 .19435 L
.87247 .19419 L
.87249 .19369 L
.8725 .19318 L
.87253 .19218 L
.87256 .19129 L
.87259 .18731 L
.87264 .17844 L
.8727 .16874 L
.87273 .16415 L
.87276 .16026 L
.87279 .15855 L
.87281 .15676 L
.87284 .15494 L
.87287 .15336 L
.87289 .15229 L
.87292 .1513 L
.87298 .14855 L
.87346 .12665 L
.87349 .13189 L
.87352 .13687 L
.87354 .13588 L
.87356 .13419 L
.87359 .13122 L
.87371 .12251 L
.87384 .11284 L
.87387 .11074 L
.87389 .10959 L
.87391 .10878 L
.87393 .10888 L
Mistroke
.87394 .10898 L
.87396 .10906 L
.87398 .10915 L
.87401 .10959 L
.87404 .11085 L
.87407 .11223 L
.87408 .11295 L
.8741 .11335 L
.87412 .11314 L
.87414 .11296 L
.87416 .11277 L
.87417 .11259 L
.8742 .11294 L
.87422 .11372 L
.87424 .11457 L
.8743 .11754 L
.87433 .11916 L
.87436 .12067 L
.87439 .12162 L
.87442 .12116 L
.87445 .12065 L
.87448 .12019 L
.8745 .11409 L
.87454 .10713 L
.87457 .10014 L
.87458 .099 L
.8746 .09997 L
.87463 .10185 L
.87466 .10364 L
.87469 .10626 L
.87472 .10959 L
.87474 .11262 L
.87477 .11394 L
.8748 .11066 L
.87482 .10704 L
.87485 .10322 L
.87488 .10296 L
.87491 .10419 L
.87494 .10531 L
.87505 .11073 L
.87508 .1131 L
.87511 .11574 L
.87514 .11823 L
.87517 .11756 L
.8752 .11641 L
.87523 .11514 L
.87529 .11188 L
.87539 .10395 L
.87542 .10115 L
.87544 .09977 L
Mistroke
.87545 .09908 L
.87548 .09771 L
.87551 .09647 L
.87553 .09605 L
.87555 .09764 L
.87558 .10113 L
.87565 .10781 L
.87568 .11128 L
.8757 .11452 L
.87573 .11665 L
.87576 .11699 L
.87579 .11733 L
.87581 .11752 L
.87583 .11803 L
.87586 .1192 L
.87589 .12029 L
.87591 .12088 L
.87594 .11795 L
.87597 .11496 L
.876 .1117 L
.87603 .1109 L
.87605 .11062 L
.87607 .11036 L
.87609 .1099 L
.87613 .11304 L
.87615 .11689 L
.87618 .12107 L
.87621 .12201 L
.87624 .12085 L
.87627 .11972 L
.87629 .11865 L
.87632 .11991 L
.87635 .12143 L
.87647 .13023 L
.87653 .13517 L
.87656 .13757 L
.87659 .13933 L
.87662 .1395 L
.87665 .13968 L
.87667 .13978 L
.87669 .1384 L
.8767 .13608 L
.87672 .13395 L
.87675 .1299 L
.87678 .12803 L
.87681 .12999 L
.87684 .13214 L
.87778 .19088 L
.87803 .20841 L
.87829 .22641 L
Mistroke
.87835 .23273 L
.87839 .23642 L
.87841 .23795 L
.87844 .23843 L
.87848 .23895 L
.87849 .2392 L
.87851 .23902 L
.87854 .23865 L
.87857 .23831 L
.8786 .23738 L
.87862 .23655 L
.87863 .23565 L
.87866 .23402 L
.87869 .23285 L
.87872 .23236 L
.87875 .23191 L
.87878 .23149 L
.8788 .22943 L
.87884 .22701 L
.87886 .22488 L
.87889 .22578 L
.87892 .2278 L
.87895 .2297 L
.87897 .23156 L
.879 .23236 L
.87903 .23323 L
.87906 .23403 L
.8791 .23353 L
.87913 .23297 L
.87919 .23199 L
.87922 .23151 L
.87925 .23107 L
.87927 .23278 L
.8793 .23577 L
.87936 .24211 L
.87946 .2544 L
.87969 .28114 L
.87971 .28114 L
.87974 .28244 L
.87977 .28687 L
.8798 .29099 L
.87983 .29564 L
.87986 .30263 L
.87989 .30898 L
.87991 .31568 L
.87993 .31859 L
.87995 .31932 L
.87997 .32059 L
.87999 .3213 L
.88001 .32207 L
Mistroke
.88003 .3214 L
.88004 .31835 L
.88007 .31261 L
.8801 .30637 L
.88013 .30387 L
.88016 .30475 L
.8806 .32257 L
.88062 .32273 L
.88066 .32289 L
.88068 .32305 L
.88071 .32559 L
.88077 .33183 L
.88083 .34096 L
.88086 .34606 L
.88088 .34834 L
.8809 .34789 L
.88093 .34706 L
.88095 .34662 L
.88096 .34615 L
.88099 .34719 L
.88102 .34919 L
.88108 .35349 L
.88114 .35731 L
.88117 .35915 L
.88121 .36058 L
.88124 .36195 L
.88127 .36248 L
.8813 .36046 L
.88132 .35855 L
.88137 .35524 L
.88143 .35231 L
.88146 .35123 L
.88149 .35274 L
.88151 .35412 L
.88154 .35539 L
.88157 .35517 L
.88158 .35483 L
.8816 .35448 L
.88163 .35383 L
.88166 .35284 L
.88171 .3506 L
.88174 .34934 L
.88177 .34616 L
.8818 .3428 L
.88181 .34102 L
.88183 .33912 L
.88185 .33884 L
.88186 .33859 L
.88189 .33811 L
.88192 .33764 L
Mistroke
.88195 .3363 L
.88198 .33488 L
.88201 .33356 L
.88204 .33179 L
.88206 .32927 L
.88209 .3267 L
.88212 .32406 L
.88215 .32338 L
.88218 .32273 L
.88221 .3221 L
.88224 .32599 L
.88229 .33494 L
.88235 .34497 L
.88237 .34923 L
.8824 .35379 L
.88242 .35504 L
.88245 .35408 L
.88248 .35294 L
.88251 .35221 L
.88253 .35304 L
.88256 .35394 L
.88259 .35493 L
.8826 .35428 L
.88262 .35245 L
.88265 .34918 L
.88268 .3462 L
.88271 .34457 L
.88273 .34414 L
.88276 .34365 L
.88279 .34322 L
.88282 .34296 L
.88284 .34267 L
.88287 .34236 L
.8829 .34348 L
.88293 .34652 L
.88294 .34817 L
.88296 .34972 L
.88299 .34863 L
.88302 .33912 L
.88303 .33425 L
.88305 .32895 L
.88308 .32222 L
.8831 .32263 L
.88312 .323 L
.88315 .32371 L
.88321 .32547 L
.88324 .32642 L
.88327 .32721 L
.8833 .32721 L
.88333 .32721 L
Mistroke
.88336 .32721 L
.88337 .32592 L
.88339 .32424 L
.88352 .31587 L
.88364 .3049 L
.88369 .29845 L
.88372 .29487 L
.88375 .29224 L
.88377 .29396 L
.88381 .29586 L
.88383 .29747 L
.88386 .29552 L
.88389 .29279 L
.88391 .2913 L
.88393 .28989 L
.88394 .28747 L
.88396 .28434 L
.884 .27882 L
.88401 .27627 L
.88403 .27417 L
.88406 .27849 L
.88409 .2832 L
.88411 .28579 L
.88413 .28745 L
.88416 .28238 L
.88419 .27777 L
.88421 .27345 L
.88424 .27401 L
.88427 .27641 L
.88429 .27773 L
.88431 .27897 L
.88433 .27802 L
.88437 .27562 L
.8853 .21379 L
.88629 .16224 L
.88724 .127 L
.88816 .10263 L
.88819 .10136 L
.88822 .10016 L
.88825 .0999 L
.88828 .1011 L
.88831 .10231 L
.88833 .10298 L
.88834 .10261 L
.88837 .1016 L
.8884 .10064 L
.88846 .09477 L
.88849 .09033 L
.88852 .0866 L
.88855 .08755 L
Mistroke
.88858 .08859 L
.88863 .09078 L
.88867 .09199 L
.88868 .09266 L
.8887 .09327 L
.88873 .09366 L
.88876 .09349 L
.88878 .09339 L
.88879 .0933 L
.88883 .09363 L
.88884 .09402 L
.88886 .09437 L
.88888 .09475 L
.8889 .09517 L
.88893 .09627 L
.88895 .09743 L
.88897 .09814 L
.88898 .09881 L
.88901 .1021 L
.88904 .10769 L
.88908 .11373 L
.88911 .11831 L
.88914 .12108 L
.88917 .12404 L
.8892 .12631 L
.88923 .12599 L
.88926 .12564 L
.88929 .12534 L
.88931 .12624 L
.88934 .12729 L
.88937 .1284 L
.8894 .1284 L
.88943 .12747 L
.88946 .12646 L
.88948 .12588 L
.88949 .12692 L
.88961 .13257 L
.88972 .13501 L
.88983 .13712 L
.88984 .13695 L
.88986 .13677 L
.88989 .1381 L
.88992 .13957 L
.88995 .14119 L
.88997 .14362 L
.89 .14701 L
.89006 .15317 L
.89012 .16191 L
.89014 .16443 L
.89015 .16645 L
Mistroke
.89017 .16728 L
.89019 .16818 L
.89022 .16982 L
.89023 .17072 L
.89025 .17133 L
.89028 .17073 L
.89031 .17007 L
.89033 .16944 L
.89036 .17 L
.89039 .17071 L
.89042 .17148 L
.89045 .17416 L
.89047 .17677 L
.89048 .17914 L
.89051 .1835 L
.89054 .18647 L
.89057 .18662 L
.8906 .18678 L
.89063 .18692 L
.89065 .18905 L
.89077 .19958 L
.89099 .2151 L
.89102 .21494 L
.89105 .21722 L
.89108 .21984 L
.89111 .22224 L
.89114 .22593 L
.89117 .22993 L
.89119 .23173 L
.89121 .23438 L
.89124 .24172 L
.89127 .24862 L
.8913 .25601 L
.89132 .25599 L
.89135 .25571 L
.89141 .25489 L
.89144 .25443 L
.89147 .25392 L
.8915 .25271 L
.89153 .2509 L
.89155 .24897 L
.89158 .24705 L
.89161 .25063 L
.89164 .2539 L
.89167 .25743 L
.89169 .25826 L
.8917 .2581 L
.89173 .25779 L
.89176 .2575 L
.89179 .25672 L
Mistroke
.89182 .2551 L
.89184 .25372 L
.89187 .25242 L
.89189 .25365 L
.89192 .25532 L
.89195 .25716 L
.89198 .25836 L
.89199 .25836 L
.89201 .25836 L
.89204 .25836 L
.89206 .25836 L
.89207 .25994 L
.89211 .26452 L
.89212 .26659 L
.89214 .26881 L
.89217 .27155 L
.8922 .27297 L
.89223 .27426 L
.89226 .27522 L
.89229 .27426 L
.89232 .27333 L
.89235 .27235 L
.89236 .27351 L
.89238 .27483 L
.89241 .27715 L
.89244 .27922 L
.89246 .28354 L
.89249 .28917 L
.89252 .29428 L
.89255 .29656 L
.89257 .29494 L
.89258 .29344 L
.89261 .29055 L
.89264 .28916 L
.89266 .2926 L
.89269 .29628 L
.89275 .30539 L
.8928 .3173 L
.89283 .32309 L
.89286 .32324 L
.89289 .32341 L
.89291 .3235 L
.89292 .32371 L
.89294 .32455 L
.89296 .32544 L
.89299 .32707 L
.89305 .33131 L
.89307 .3338 L
.8931 .33612 L
.89313 .33775 L
Mistroke
.89315 .33905 L
.89318 .34038 L
.89321 .34134 L
.89324 .33632 L
.89327 .33158 L
.8933 .32697 L
.89332 .33078 L
.89335 .33706 L
.89338 .3438 L
.89341 .34466 L
.89344 .34074 L
.89347 .33616 L
.89349 .33356 L
.89351 .33491 L
.89354 .33997 L
.89357 .34535 L
.89359 .34829 L
.8936 .34784 L
.89362 .34623 L
.89364 .34453 L
.89367 .34166 L
.89369 .34042 L
.8937 .3441 L
.89373 .35085 L
.89376 .35723 L
.89378 .36076 L
.8938 .36074 L
.89383 .35943 L
.89385 .35824 L
.89388 .35735 L
.89391 .35804 L
.89394 .35866 L
.89397 .35925 L
.894 .36327 L
.89402 .36804 L
.89405 .37319 L
.89407 .37587 L
.89408 .37587 L
.89412 .37587 L
.89414 .37587 L
.89417 .3762 L
.8942 .37723 L
.89423 .3782 L
.89425 .37874 L
.89427 .37954 L
.89429 .38073 L
.8943 .38182 L
.89436 .38573 L
.8944 .38772 L
.89443 .38959 L
Mistroke
.89445 .39088 L
.89448 .39088 L
.89451 .39088 L
.89454 .39088 L
.89456 .39103 L
.89458 .39121 L
.89461 .39159 L
.89463 .39177 L
.89465 .39195 L
.89466 .39204 L
.89468 .39213 L
.89471 .39231 L
.89473 .39239 L
.89475 .39162 L
.89478 .38927 L
.89481 .38707 L
.89484 .38436 L
.89485 .38163 L
.89487 .37917 L
.89493 .36983 L
.89506 .34521 L
.89509 .34599 L
.89511 .34671 L
.89514 .343 L
.89517 .33754 L
.89523 .32506 L
.89526 .31815 L
.89529 .3116 L
.89532 .30759 L
.89535 .30645 L
.89538 .3055 L
.8954 .30445 L
.89543 .30475 L
.89547 .30509 L
.8955 .30541 L
.89552 .30339 L
.89574 .2812 L
.89618 .21937 L
.89621 .21126 L
.89625 .20247 L
.89628 .19616 L
.8963 .1934 L
.89637 .18656 L
.8964 .18292 L
.89643 .1795 L
.89646 .17696 L
.89649 .1762 L
.89655 .17459 L
.89667 .17018 L
.8967 .17066 L
Mistroke
.89672 .17093 L
.89673 .17118 L
.89675 .1708 L
.89677 .16881 L
.8968 .16494 L
.89683 .16127 L
.89686 .1635 L
.89689 .16962 L
.8969 .173 L
.89692 .17608 L
.89695 .17987 L
.89698 .18161 L
.897 .18325 L
.89703 .18476 L
.89706 .18136 L
.89709 .17735 L
.89712 .17382 L
.89715 .17308 L
.89718 .17325 L
.89721 .1734 L
.89723 .17351 L
.89724 .17369 L
.89727 .17404 L
.8973 .17435 L
.89734 .1746 L
.89736 .17476 L
.89739 .1749 L
.89741 .17499 L
.89743 .17306 L
.89746 .16812 L
.89753 .1578 L
.89756 .15443 L
.89759 .15081 L
.89761 .14931 L
.89762 .15012 L
.89766 .15171 L
.89769 .15311 L
.89772 .15407 L
.89775 .15454 L
.89777 .15498 L
.8978 .156 L
.89783 .15955 L
.89786 .16324 L
.89788 .16527 L
.8979 .16674 L
.89792 .16674 L
.89795 .16674 L
.89797 .16674 L
.898 .16444 L
.89803 .15922 L
Mistroke
.89806 .1537 L
.89812 .14667 L
.89817 .14127 L
.89824 .13605 L
.89829 .13148 L
.89832 .12896 L
.89835 .12628 L
.89837 .12491 L
.89839 .12575 L
.89842 .1274 L
.89844 .12821 L
.89846 .12908 L
.89847 .12875 L
.89849 .1275 L
.89852 .12495 L
.89855 .12258 L
.89858 .12342 L
.8986 .12483 L
.89861 .12633 L
.89864 .12888 L
.89866 .12988 L
.89868 .12946 L
.89871 .12854 L
.89874 .1277 L
.89877 .12554 L
.8988 .12223 L
.89883 .11891 L
.89884 .11703 L
.89886 .11861 L
.89889 .12515 L
.89891 .1286 L
.89893 .13224 L
.89895 .13491 L
.89897 .13611 L
.899 .13822 L
.89906 .14207 L
.89909 .14406 L
.89911 .14505 L
.89913 .14596 L
.89916 .14567 L
.89917 .14498 L
.89919 .14424 L
.89922 .14306 L
.89925 .14381 L
.89927 .14638 L
.8993 .14916 L
.89936 .15279 L
.89939 .15439 L
.89942 .15585 L
.89944 .15518 L
Mistroke
.89945 .15447 L
.89947 .15374 L
.89949 .15295 L
.89951 .15223 L
.89952 .15214 L
.89955 .15543 L
.89958 .15837 L
.89961 .16159 L
.89964 .16167 L
.89967 .1612 L
.8997 .16075 L
.89972 .15995 L
.89975 .15845 L
.89978 .1571 L
.89979 .15634 L
.89981 .1568 L
.89984 .16088 L
.89994 .17837 L
.89997 .18439 L
.9 .18824 L
.90003 .18575 L
.90006 .18348 L
.90009 .1808 L
.90011 .18018 L
.90012 .17966 L
.90015 .17863 L
.90018 .17767 L
.90021 .17823 L
.90025 .17896 L
.90026 .1793 L
.90028 .17967 L
.9003 .18065 L
.90032 .18157 L
.90037 .18454 L
.90043 .18829 L
.90045 .18942 L
.90046 .19048 L
.90049 .18907 L
.90052 .18642 L
.90055 .18355 L
.90058 .18329 L
.90061 .18505 L
.90067 .18933 L
.9007 .19218 L
.90073 .19522 L
.90076 .19808 L
.90078 .19807 L
.90081 .19772 L
.90084 .1974 L
.90086 .19708 L
Mistroke
.90088 .19649 L
.90091 .19517 L
.90094 .19401 L
.90097 .19345 L
.901 .19313 L
.90102 .19295 L
.90103 .19278 L
.90106 .19218 L
.9011 .19125 L
.90113 .19044 L
.90114 .19009 L
.90116 .19317 L
.90119 .19848 L
.90122 .2042 L
.90125 .20723 L
.90128 .20621 L
.90131 .20509 L
.90134 .20406 L
.90136 .20435 L
.90137 .20462 L
.9014 .20514 L
.90142 .20541 L
.90144 .20664 L
.90145 .20938 L
.90147 .21229 L
.90154 .22199 L
.90176 .25197 L
.9018 .26011 L
.90181 .26407 L
.90183 .26416 L
.90189 .2645 L
.90192 .26457 L
.90195 .26457 L
.90198 .26457 L
.90201 .26531 L
.90203 .26825 L
.90206 .27148 L
.90211 .27797 L
.90214 .28174 L
.90217 .2853 L
.90219 .28838 L
.90222 .28838 L
.90225 .28838 L
.90228 .28838 L
.90231 .2871 L
.90234 .28537 L
.90237 .28377 L
.90239 .28411 L
.90242 .28967 L
.90245 .29564 L
Mistroke
.90247 .29895 L
.90248 .30188 L
.90251 .30266 L
.90254 .30358 L
.90258 .30442 L
.9026 .30851 L
.90263 .3129 L
.90266 .31731 L
.90268 .31852 L
.90269 .31744 L
.90276 .31281 L
.90282 .30932 L
.90284 .30842 L
.90285 .30746 L
.90287 .30757 L
.90289 .30844 L
.90296 .31164 L
.90301 .31225 L
.90304 .31255 L
.90307 .31415 L
.90308 .31576 L
.9031 .31747 L
.90313 .32056 L
.90316 .32221 L
.90319 .32132 L
.90322 .32027 L
.90324 .31968 L
.90325 .3184 L
.90328 .31505 L
.90332 .31151 L
.90335 .30879 L
.90338 .30772 L
.90341 .30655 L
.90342 .30589 L
.90344 .30416 L
.90366 .2798 L
.90369 .28335 L
.90372 .2871 L
.90374 .28564 L
.90375 .28349 L
.90378 .27971 L
.90384 .27179 L
.90387 .26652 L
.9039 .26154 L
.90392 .25889 L
.90393 .25899 L
.90397 .25918 L
.90398 .25926 L
.904 .25936 L
.90403 .2594 L
Mistroke
.90406 .2594 L
.90409 .2594 L
.90412 .2606 L
.90414 .26174 L
.90416 .26277 L
.90419 .26476 L
.90422 .26512 L
.90425 .26411 L
.90426 .26359 L
.90428 .26304 L
.90431 .26373 L
.90434 .26616 L
.90437 .26848 L
.9044 .27016 L
.90443 .26951 L
.90445 .26892 L
.90448 .26828 L
.9045 .26731 L
.90451 .26623 L
.90454 .26428 L
.90457 .26245 L
.90459 .2626 L
.90462 .26519 L
.90464 .26658 L
.90466 .26806 L
.90469 .2692 L
.9047 .26838 L
.90472 .26763 L
.90474 .26674 L
.90475 .26592 L
.90478 .26762 L
.9048 .27075 L
.90482 .27406 L
.90485 .28017 L
.90487 .284 L
.9049 .28306 L
.90493 .28206 L
.90496 .28114 L
.90499 .28129 L
.90502 .28145 L
.90505 .28162 L
.90507 .28084 L
.90509 .27969 L
.90512 .27743 L
.90538 .26206 L
.9055 .25801 L
.90555 .25555 L
.90561 .25331 L
.90563 .25197 L
.90566 .24879 L
Mistroke
.90569 .24539 L
.90572 .24178 L
.90575 .23954 L
.90578 .23799 L
.90584 .23414 L
.90587 .23196 L
.90589 .23082 L
.90591 .22962 L
.90594 .23008 L
.90597 .23179 L
.906 .23368 L
.90602 .23491 L
.90603 .23674 L
.90607 .24095 L
.90609 .24286 L
.9061 .24487 L
.90614 .24373 L
.90616 .24188 L
.90623 .23682 L
.90628 .23107 L
.90632 .22864 L
.90634 .22721 L
.90637 .22577 L
.90641 .22471 L
.90643 .22471 L
.90646 .22471 L
.90649 .22471 L
.90652 .22318 L
.90655 .22171 L
.90657 .22033 L
.9066 .21954 L
.90662 .21954 L
.90663 .21954 L
.90665 .21954 L
.90667 .21954 L
.9067 .21981 L
.90673 .22028 L
.90675 .22072 L
.90678 .22219 L
.90682 .22762 L
.90684 .23227 L
.90687 .23668 L
.9069 .23508 L
.90692 .23218 L
.90697 .22692 L
.90703 .22212 L
.90706 .21936 L
.90708 .22083 L
.90711 .22439 L
.90714 .22774 L
Mistroke
.90717 .23022 L
.90719 .22676 L
.90723 .22276 L
.90726 .21906 L
.90728 .22136 L
.90731 .22386 L
.90734 .22613 L
.90737 .22602 L
.9074 .22481 L
.90743 .22348 L
.90744 .22282 L
.90746 .22244 L
.90749 .22195 L
.90752 .22151 L
.90755 .22064 L
.90758 .2162 L
.9076 .21207 L
.90763 .20819 L
.90765 .20766 L
.90768 .20856 L
.90771 .20941 L
.90774 .21018 L
.90777 .20984 L
.90778 .20967 L
.9078 .20948 L
.90783 .20999 L
.90786 .21748 L
.90789 .22459 L
.90795 .2361 L
.90798 .24115 L
.90799 .24392 L
.90801 .24653 L
.90804 .24286 L
.90807 .23628 L
.9081 .22893 L
.90812 .22557 L
.90813 .22416 L
.90817 .22119 L
.90819 .21986 L
.9082 .21846 L
.90824 .21895 L
.90827 .22004 L
.90833 .22226 L
.90836 .223 L
.90839 .2238 L
.9084 .22408 L
.90842 .22325 L
.90845 .22161 L
.90848 .22018 L
.90851 .21895 L
Mistroke
.90854 .21861 L
.90857 .21829 L
.90859 .21793 L
.90862 .21643 L
.90867 .21363 L
.90879 .20487 L
.90882 .20119 L
.90884 .19917 L
.90886 .19725 L
.90889 .19467 L
.90892 .19731 L
.90895 .20042 L
.90898 .2029 L
.909 .20254 L
.90902 .20216 L
.90905 .20135 L
.90918 .19847 L
.91008 .17813 L
.91015 .17326 L
.91018 .1707 L
.9102 .16944 L
.91021 .16828 L
.91024 .1674 L
.91026 .16715 L
.91027 .16688 L
.9103 .16644 L
.91033 .16639 L
.91036 .16673 L
.91038 .16691 L
.91039 .16708 L
.91042 .1656 L
.91045 .16252 L
.91048 .15914 L
.9105 .15725 L
.91052 .15745 L
.91054 .15827 L
.91055 .15903 L
.91057 .15979 L
.91059 .1605 L
.91061 .16003 L
.91064 .15795 L
.91067 .15576 L
.9107 .15321 L
.91073 .14953 L
.91075 .14605 L
.91078 .14237 L
.91081 .14076 L
.91084 .1406 L
.91087 .14043 L
.91089 .14034 L
Mistroke
.9109 .14296 L
.91093 .148 L
.91096 .1527 L
.91099 .15703 L
.91105 .16276 L
.91108 .16576 L
.91111 .16669 L
.91116 .16843 L
.91119 .16966 L
.91123 .17109 L
.91125 .17232 L
.91129 .17135 L
.91132 .16845 L
.91135 .16533 L
.9114 .16013 L
.91142 .15869 L
.91144 .15712 L
.91146 .15563 L
.91147 .15521 L
.9115 .15489 L
.91152 .15472 L
.91153 .15455 L
.91156 .15409 L
.91159 .15314 L
.91162 .15203 L
.91164 .151 L
.91167 .15178 L
.91169 .15356 L
.91175 .15734 L
.91198 .17259 L
.91297 .23198 L
.91393 .27302 L
.91396 .27282 L
.91399 .27396 L
.91401 .27522 L
.91404 .27639 L
.91407 .27829 L
.9141 .28014 L
.91412 .28182 L
.91414 .28315 L
.91417 .28283 L
.9142 .28253 L
.91423 .28221 L
.91425 .28013 L
.91426 .27776 L
.91429 .27366 L
.91432 .26978 L
.91435 .26802 L
.91437 .2686 L
.9144 .26925 L
Mistroke
.91442 .26958 L
.91443 .272 L
.91446 .27925 L
.91449 .28606 L
.91451 .28995 L
.91452 .29337 L
.91455 .29578 L
.91459 .2984 L
.91461 .29986 L
.91462 .30011 L
.91465 .29575 L
.91468 .29164 L
.91471 .28787 L
.91473 .29115 L
.91476 .29694 L
.91479 .30316 L
.91481 .30651 L
.91483 .30669 L
.91486 .30702 L
.91489 .30734 L
.9149 .30753 L
.91492 .308 L
.91495 .30899 L
.91498 .30991 L
.91499 .31042 L
.91501 .30979 L
.91504 .30725 L
.9151 .30151 L
.91516 .29616 L
.91519 .29353 L
.91521 .29308 L
.91522 .29266 L
.91525 .29193 L
.91528 .29123 L
.91531 .29097 L
.91533 .29097 L
.91536 .29097 L
.91538 .29097 L
.91539 .29304 L
.91543 .29854 L
.91546 .30357 L
.91549 .30509 L
.91551 .30074 L
.91557 .29201 L
.91584 .26416 L
.91632 .22837 L
.91653 .20465 L
.91659 .19837 L
.91661 .19525 L
.91665 .19441 L
Mistroke
.91667 .1947 L
.9167 .19502 L
.91673 .19455 L
.91675 .19292 L
.91678 .19104 L
.91681 .18903 L
.91683 .1885 L
.91685 .18792 L
.91688 .18691 L
.91691 .18596 L
.91694 .18732 L
.91697 .18875 L
.917 .19008 L
.91703 .18927 L
.91706 .18713 L
.91709 .18505 L
.91712 .1859 L
.91715 .19022 L
.91717 .1943 L
.9172 .19775 L
.91723 .19657 L
.91726 .19531 L
.91729 .19395 L
.91731 .19432 L
.91732 .1953 L
.91735 .19722 L
.91737 .19818 L
.91739 .1992 L
.91741 .19952 L
.91742 .19971 L
.91745 .20005 L
.91747 .20023 L
.91749 .20035 L
.9175 .20017 L
.91752 .19998 L
.91755 .19964 L
.91757 .19947 L
.91759 .19943 L
.91762 .19992 L
.91765 .20042 L
.91768 .20089 L
.9177 .2002 L
.91773 .19943 L
.91779 .19791 L
.91782 .19711 L
.91785 .19627 L
.91787 .19765 L
.9179 .2054 L
.91793 .21239 L
.91796 .21899 L
Mistroke
.91797 .22141 L
.91799 .22288 L
.91802 .22545 L
.91804 .22691 L
.91805 .22845 L
.91807 .22874 L
.91809 .22856 L
.91812 .22824 L
.91813 .22806 L
.91815 .22789 L
.91818 .22693 L
.91821 .22588 L
.91827 .22376 L
.9183 .22286 L
.91833 .22202 L
.91836 .22176 L
.91839 .22211 L
.91842 .22242 L
.91845 .22255 L
.91846 .2223 L
.91848 .22203 L
.91851 .22146 L
.91853 .22116 L
.91855 .22223 L
.91858 .22496 L
.91861 .22735 L
.91865 .22886 L
.91866 .22886 L
.91868 .22886 L
.91871 .22886 L
.91874 .22913 L
.91877 .22976 L
.9188 .23044 L
.91882 .23082 L
.91884 .23074 L
.91886 .23027 L
.9189 .22976 L
.91895 .22882 L
.91898 .22835 L
.91901 .2279 L
.91904 .22998 L
.91907 .23285 L
.9191 .2353 L
.91912 .23656 L
.91915 .23641 L
.91918 .23626 L
.91921 .23611 L
.91924 .23444 L
.91927 .23277 L
.91928 .23189 L
Mistroke
.9193 .23097 L
.91933 .23224 L
.91936 .23347 L
.91939 .23463 L
.91942 .23809 L
.91945 .24338 L
.91947 .24599 L
.91948 .24839 L
.9195 .24934 L
.91952 .24727 L
.91955 .24365 L
.91962 .23618 L
.91965 .23275 L
.91968 .22901 L
.91971 .22742 L
.91974 .22637 L
.91976 .22536 L
.91979 .22592 L
.91981 .22761 L
.91982 .22944 L
.91985 .23276 L
.91988 .23461 L
.91991 .23312 L
.91994 .23181 L
.91996 .23039 L
.91999 .23 L
.92002 .23014 L
.92005 .2303 L
.92008 .23031 L
.9201 .23004 L
.92013 .22974 L
.92016 .22941 L
.92019 .23255 L
.92022 .23682 L
.92025 .24073 L
.92028 .24287 L
.92032 .24482 L
.92033 .24577 L
.92035 .24678 L
.92037 .24647 L
.92039 .24591 L
.92042 .24491 L
.92043 .24438 L
.92045 .24372 L
.92048 .24082 L
.92051 .23814 L
.92054 .23574 L
.92057 .23462 L
.9206 .23396 L
.92062 .23334 L
Mistroke
.92162 .20887 L
.92211 .19454 L
.92214 .19411 L
.92216 .19372 L
.92219 .19294 L
.92222 .19202 L
.92225 .19109 L
.92228 .19116 L
.92231 .19239 L
.92233 .19352 L
.92236 .19427 L
.92238 .1923 L
.9224 .19048 L
.92242 .1872 L
.92246 .1838 L
.92249 .18348 L
.92251 .18318 L
.92254 .18287 L
.92257 .18266 L
.9226 .1825 L
.92263 .18235 L
.92266 .18189 L
.92269 .18098 L
.92271 .18008 L
.92274 .17923 L
.92276 .18112 L
.92279 .18346 L
.92285 .18891 L
.92288 .19203 L
.92291 .19494 L
.92293 .19713 L
.92296 .19446 L
.92299 .19171 L
.92302 .1888 L
.92305 .18809 L
.92308 .18825 L
.92311 .18842 L
.92313 .18841 L
.92315 .18822 L
.92317 .18792 L
.9232 .18759 L
.92322 .1873 L
.92324 .18601 L
.92327 .18373 L
.9233 .18151 L
.92332 .18053 L
.92336 .18156 L
.92338 .18249 L
.92349 .18741 L
.92355 .19455 L
Mistroke
.92357 .19671 L
.92358 .19906 L
.92361 .20127 L
.92364 .20094 L
.92367 .20063 L
.9237 .20005 L
.92373 .19736 L
.92376 .19427 L
.92379 .19136 L
.92382 .19365 L
.92384 .1968 L
.92386 .19864 L
.92388 .20035 L
.92389 .2016 L
.92391 .20209 L
.92394 .2029 L
.92396 .20332 L
.92397 .20377 L
.924 .20401 L
.92403 .20401 L
.92406 .20401 L
.92409 .20318 L
.92411 .20057 L
.92414 .19775 L
.92419 .19306 L
.92425 .18839 L
.92431 .18418 L
.92433 .1824 L
.92436 .1805 L
.92439 .18006 L
.92442 .17991 L
.92448 .17957 L
.92451 .17938 L
.92453 .17929 L
.92455 .17921 L
.92457 .18002 L
.9246 .18142 L
.92463 .18287 L
.92465 .18359 L
.92466 .18519 L
.9247 .18908 L
.92473 .19268 L
.92475 .19468 L
.92477 .19221 L
.9248 .18773 L
.92483 .18345 L
.92485 .18191 L
.92487 .18102 L
.9249 .17957 L
.92491 .1788 L
Mistroke
.92493 .17799 L
.92495 .17785 L
.92496 .17828 L
.92499 .17911 L
.92502 .17986 L
.92505 .17886 L
.92507 .17758 L
.92508 .1764 L
.9251 .17514 L
.92512 .17377 L
.92514 .17355 L
.92515 .17513 L
.92518 .17824 L
.92521 .18136 L
.92524 .18247 L
.92527 .18191 L
.9253 .18131 L
.92533 .18071 L
.92534 .18071 L
.92536 .18071 L
.92539 .18071 L
.92542 .18071 L
.92545 .18321 L
.92548 .18574 L
.92554 .19083 L
.92557 .19261 L
.9256 .19453 L
.92562 .19531 L
.92563 .19557 L
.92566 .19606 L
.92569 .1965 L
.92571 .19767 L
.92574 .2005 L
.92577 .20353 L
.92589 .21255 L
.92615 .23406 L
.92618 .24146 L
.9262 .24452 L
.92623 .24637 L
.92626 .24806 L
.92629 .2496 L
.92633 .25089 L
.92636 .2521 L
.92639 .25158 L
.92642 .24929 L
.92645 .24721 L
.92651 .24192 L
.92663 .23061 L
.9267 .22376 L
.92674 .2198 L
Mistroke
.92675 .2178 L
.92677 .21844 L
.92679 .21944 L
.92681 .22052 L
.92682 .22152 L
.92684 .22246 L
.92685 .22285 L
.92687 .22147 L
.9269 .21907 L
.92693 .2166 L
.92696 .21462 L
.92699 .2133 L
.92702 .21205 L
.92704 .21138 L
.92706 .21395 L
.92708 .21968 L
.9271 .22324 L
.92712 .22661 L
.92714 .22962 L
.92715 .23056 L
.92721 .23309 L
.92723 .23377 L
.92724 .23496 L
.92727 .23755 L
.9273 .23978 L
.92733 .24218 L
.92736 .24794 L
.92739 .25347 L
.92741 .2592 L
.92743 .26087 L
.92745 .2607 L
.92748 .26033 L
.92751 .25999 L
.92754 .26181 L
.92757 .26445 L
.9276 .2671 L
.92761 .2686 L
.92763 .26803 L
.9279 .25618 L
.92795 .2525 L
.92802 .24844 L
.92804 .2458 L
.92807 .24299 L
.9281 .24192 L
.92813 .24439 L
.92816 .24721 L
.92818 .24877 L
.9282 .24943 L
.92821 .24918 L
.92823 .24889 L
Mistroke
.92826 .2484 L
.92829 .2489 L
.92831 .25152 L
.92832 .25389 L
.92835 .25853 L
.92838 .26287 L
.92841 .26149 L
.92843 .25978 L
.92845 .25881 L
.92847 .25789 L
.9285 .26073 L
.92853 .26609 L
.92856 .27105 L
.92859 .27235 L
.9286 .27072 L
.92862 .26892 L
.92865 .26615 L
.92868 .2644 L
.92871 .26575 L
.92873 .26698 L
.92884 .27251 L
.92934 .30669 L
.9294 .30823 L
.92942 .30865 L
.92943 .30909 L
.92946 .30893 L
.92949 .30879 L
.92951 .30864 L
.92954 .31184 L
.92957 .31704 L
.92964 .32883 L
.92967 .33326 L
.92968 .33559 L
.9297 .33807 L
.92973 .34082 L
.92976 .34113 L
.92979 .34142 L
.92982 .34205 L
.92987 .34642 L
.9299 .34887 L
.92993 .34827 L
.92998 .34529 L
.93001 .34403 L
.93003 .34655 L
.93006 .34918 L
.93009 .35196 L
.93011 .35324 L
.93014 .35354 L
.93017 .35386 L
.9302 .35357 L
Mistroke
.93023 .35114 L
.93026 .34891 L
.93029 .34641 L
.93032 .35076 L
.93035 .3561 L
.93038 .36095 L
.93041 .36268 L
.93044 .36403 L
.93047 .36546 L
.9305 .3656 L
.93053 .36502 L
.93056 .36438 L
.93059 .36208 L
.93062 .35741 L
.93072 .34147 L
.93075 .33724 L
.93079 .3339 L
.93085 .32922 L
.93097 .3173 L
.93103 .31093 L
.93105 .30938 L
.93106 .30824 L
.93108 .30753 L
.9311 .30686 L
.93113 .30566 L
.93115 .30505 L
.93116 .30479 L
.93119 .30448 L
.93122 .30415 L
.93126 .30232 L
.93129 .29755 L
.93132 .29243 L
.93133 .28951 L
.93135 .29099 L
.93138 .29904 L
.93141 .30639 L
.93142 .31045 L
.93144 .31354 L
.93147 .31206 L
.9315 .31064 L
.93153 .30931 L
.93156 .30629 L
.93159 .30335 L
.93161 .30074 L
.93164 .29872 L
.93167 .29745 L
.9317 .29629 L
.9322 .27128 L
.93232 .26161 L
.93235 .25935 L
Mistroke
.93237 .25811 L
.93238 .25695 L
.93241 .25672 L
.93243 .25706 L
.93245 .25742 L
.93247 .25807 L
.93249 .25793 L
.93251 .2559 L
.93257 .24822 L
.93262 .24228 L
.93265 .2397 L
.93268 .23731 L
.9327 .23584 L
.93273 .23436 L
.93276 .23275 L
.93279 .23175 L
.93281 .23138 L
.93284 .23098 L
.93289 .23022 L
.93292 .22991 L
.93295 .22957 L
.93298 .229 L
.93301 .2281 L
.93303 .22723 L
.93306 .22641 L
.93308 .22756 L
.93311 .22928 L
.93322 .24219 L
.93325 .2464 L
.93328 .24697 L
.93331 .24697 L
.93334 .24697 L
.93336 .24598 L
.93337 .24331 L
.93341 .23848 L
.93343 .23417 L
.93347 .23126 L
.9335 .22951 L
.93353 .22764 L
.93356 .22852 L
.93358 .23175 L
.93361 .23546 L
.93363 .23756 L
.93365 .23624 L
.93368 .23107 L
.93371 .22556 L
.93377 .2177 L
.9338 .21494 L
.93383 .21203 L
.93384 .21301 L
Mistroke
.93386 .21463 L
.93389 .21747 L
.93391 .21907 L
.93393 .22052 L
.93394 .22014 L
.93396 .2198 L
.93399 .21912 L
.93401 .21877 L
.93402 .21828 L
.93404 .21762 L
.93406 .21689 L
.93409 .21561 L
.93412 .21462 L
.93415 .21719 L
.93418 .22015 L
.93421 .22277 L
.93424 .22437 L
.93427 .22585 L
.9343 .22747 L
.93433 .22673 L
.93436 .22541 L
.93439 .22417 L
.93442 .22228 L
.93446 .21992 L
.93447 .21869 L
.93449 .21736 L
.93451 .21494 L
.93453 .21217 L
.93459 .20138 L
.93465 .19033 L
.93468 .18448 L
.93471 .18035 L
.93473 .17816 L
.93476 .17575 L
.93479 .17401 L
.93481 .17415 L
.93484 .1743 L
.93487 .17445 L
.9349 .17341 L
.93493 .1719 L
.93496 .17032 L
.93499 .16768 L
.935 .16559 L
.93502 .16328 L
.93505 .15921 L
.93508 .15627 L
.9351 .15537 L
.93511 .15454 L
.93515 .15289 L
.93517 .15223 L
Mistroke
.9352 .15446 L
.93523 .15656 L
.93525 .15878 L
.93528 .15904 L
.93531 .15838 L
.93535 .15767 L
.93536 .15719 L
.93538 .15642 L
.93541 .15503 L
.93548 .15161 L
.9355 .14956 L
.93553 .14729 L
.93556 .14634 L
.93559 .14714 L
.93562 .14789 L
.93564 .14858 L
.93567 .14709 L
.93571 .14536 L
.93574 .14374 L
.93576 .14283 L
.93579 .14211 L
.93581 .14145 L
.93584 .14125 L
.93587 .14343 L
.93598 .15361 L
.93601 .15675 L
.93604 .15795 L
.93607 .157 L
.9361 .15612 L
.93613 .15643 L
.93616 .16123 L
.93619 .16647 L
.93621 .16935 L
.93622 .17129 L
.93625 .17051 L
.93628 .1698 L
.9363 .16914 L
.93633 .16904 L
.93636 .16951 L
.93639 .17001 L
.93641 .17023 L
.93644 .16945 L
.93648 .16854 L
.93649 .16809 L
.93651 .16788 L
.93654 .16881 L
.93657 .16982 L
.9366 .17082 L
.93662 .16801 L
.93663 .16499 L
Mistroke
.93667 .15884 L
.93669 .15548 L
.9367 .15358 L
.93673 .15531 L
.93676 .1572 L
.93679 .1588 L
.93682 .16218 L
.93685 .16639 L
.93687 .16845 L
.93688 .17035 L
.93691 .17127 L
.93694 .17177 L
.93697 .17226 L
.937 .17431 L
.93703 .17696 L
.93706 .17985 L
.93709 .18257 L
.9371 .18323 L
.93712 .18397 L
.93718 .18649 L
.93723 .18853 L
.93729 .19125 L
.93732 .193 L
.93734 .19484 L
.93737 .19677 L
.9374 .20218 L
.93752 .22084 L
.93759 .22755 L
.93762 .23138 L
.93765 .23491 L
.93768 .23612 L
.93771 .2373 L
.93774 .23848 L
.93776 .23863 L
.93778 .23854 L
.93781 .23838 L
.93783 .23824 L
.93786 .23959 L
.93789 .24173 L
.93792 .24401 L
.93794 .24529 L
.93795 .24475 L
.93798 .24338 L
.93801 .24188 L
.93804 .24141 L
.93807 .24502 L
.93809 .24882 L
.93812 .25294 L
.93814 .25466 L
.93815 .25558 L
Mistroke
.93818 .25738 L
.93821 .25902 L
.93824 .25953 L
.93827 .25868 L
.9383 .25789 L
.93832 .25743 L
.93833 .25943 L
.93837 .2658 L
.93839 .27054 L
.93842 .27507 L
.93845 .27606 L
.93847 .27695 L
.9385 .27801 L
.93853 .28053 L
.93856 .28408 L
.93858 .28735 L
.93861 .29019 L
.93864 .28717 L
.93867 .28358 L
.93869 .2803 L
.93872 .28067 L
.93875 .28304 L
.93878 .28576 L
.93881 .28689 L
.93884 .28559 L
.93887 .28419 L
.9389 .28272 L
.93893 .28027 L
.93896 .27805 L
.93898 .27595 L
.93901 .27443 L
.93904 .27326 L
.93907 .272 L
.9391 .27147 L
.93913 .27179 L
.93916 .27209 L
.93919 .27297 L
.9392 .27461 L
.93922 .27615 L
.93929 .28291 L
.93931 .28646 L
.93934 .29034 L
.93937 .294 L
.9394 .29228 L
.9395 .28495 L
.93953 .28268 L
.93956 .28055 L
.93958 .28273 L
.93961 .28644 L
.93964 .29048 L
Mistroke
.93967 .29346 L
.9397 .29434 L
.93973 .2953 L
.93976 .29658 L
.93979 .29891 L
.93982 .30143 L
.93984 .30276 L
.93985 .30407 L
.93988 .30536 L
.93991 .30657 L
.93997 .30923 L
.94 .31038 L
.94003 .31147 L
.94005 .3122 L
.94008 .3122 L
.94011 .3122 L
.94014 .31274 L
.94017 .31734 L
.9402 .32158 L
.94023 .32622 L
.94024 .32681 L
.94026 .32621 L
.94029 .32491 L
.94033 .32372 L
.94034 .32237 L
.94036 .32069 L
.94039 .31761 L
.94046 .31101 L
.94052 .30545 L
.94055 .30329 L
.94058 .30126 L
.94061 .29936 L
.94064 .302 L
.94067 .3046 L
.9407 .30705 L
.94073 .30528 L
.94076 .3013 L
.94079 .29664 L
.94082 .29324 L
.94084 .29143 L
.94087 .28951 L
.94093 .28633 L
.94106 .27781 L
.94112 .2724 L
.94115 .27044 L
.94118 .2683 L
.94121 .26768 L
.94124 .26768 L
.94126 .26768 L
.9413 .26813 L
Mistroke
.94131 .26874 L
.94133 .26941 L
.94136 .27061 L
.94139 .26992 L
.94142 .26682 L
.94145 .26341 L
.94147 .2616 L
.94149 .26076 L
.9415 .26051 L
.94152 .26023 L
.94155 .25974 L
.94157 .25945 L
.94159 .25675 L
.94162 .25089 L
.94164 .24809 L
.94165 .24513 L
.94169 .24346 L
.94171 .24361 L
.94174 .24378 L
.94177 .24514 L
.9418 .24806 L
.94183 .25149 L
.94184 .2533 L
.94186 .25487 L
.94189 .25588 L
.94192 .25681 L
.94195 .25765 L
.94197 .25219 L
.94202 .23914 L
.94205 .23326 L
.94208 .23436 L
.94211 .23541 L
.94214 .23641 L
.94217 .24162 L
.9422 .24712 L
.94221 .25024 L
.94223 .25354 L
.94226 .25596 L
.94229 .2568 L
.94232 .25773 L
.94237 .25923 L
.94239 .2596 L
.94241 .25996 L
.94244 .25877 L
.94246 .25561 L
.94247 .25269 L
.94249 .24928 L
.94251 .24608 L
.94254 .24349 L
.94255 .2444 L
Mistroke
.94257 .24539 L
.94263 .24948 L
.94269 .25417 L
.94271 .25552 L
.94272 .25602 L
.94275 .25475 L
.94281 .25241 L
.94286 .25049 L
.94289 .24951 L
.94291 .24923 L
.94293 .25035 L
.94298 .25443 L
.94305 .25838 L
.94312 .26166 L
.94314 .26294 L
.94318 .26431 L
.94319 .26506 L
.94321 .26267 L
.94324 .25799 L
.94327 .25376 L
.9433 .25076 L
.94333 .24996 L
.94336 .24923 L
.94339 .24895 L
.94342 .25118 L
.94346 .25384 L
.94347 .2551 L
.94349 .25591 L
.9435 .25626 L
.94352 .25664 L
.94355 .25732 L
.94357 .2577 L
.94359 .2579 L
.9436 .25799 L
.94362 .25809 L
.94365 .25825 L
.94367 .25834 L
.94368 .25914 L
.94374 .26288 L
.94387 .26972 L
.94393 .27319 L
.94395 .27415 L
.94396 .27497 L
.94399 .2753 L
.94402 .27558 L
.94405 .27589 L
.94408 .27409 L
.94411 .27189 L
.94417 .2678 L
.9442 .26601 L
Mistroke
.94421 .26503 L
.94423 .26411 L
.94426 .26412 L
.94429 .26763 L
.94431 .27065 L
.94434 .27382 L
.94437 .27079 L
.94439 .26732 L
.94442 .26412 L
.94444 .26172 L
.94447 .26053 L
.9445 .25926 L
.94453 .25808 L
.94455 .25884 L
.94458 .26007 L
.94461 .26138 L
.94463 .26216 L
.94466 .26069 L
.94469 .25919 L
.94472 .25777 L
.94474 .25883 L
.94477 .26132 L
.94483 .26771 L
.94485 .27154 L
.94488 .27574 L
.94491 .2796 L
.94494 .27963 L
.94496 .27904 L
.94499 .27841 L
.94501 .27805 L
.94503 .27819 L
.94506 .27856 L
.94509 .2789 L
.94511 .27906 L
.94512 .27752 L
.94515 .27473 L
.94517 .27321 L
.94519 .2718 L
.94521 .27009 L
.94524 .26961 L
.94527 .26915 L
.9453 .26921 L
.94532 .27205 L
.94533 .27473 L
.94536 .27974 L
.94539 .28418 L
.94542 .28622 L
.94545 .28805 L
.94548 .28973 L
.94553 .29214 L
Mistroke
.94555 .29275 L
.94557 .29334 L
.94559 .2924 L
.94562 .28751 L
.94565 .28299 L
.9457 .27234 L
.94574 .26594 L
.94577 .25992 L
.9458 .25879 L
.94583 .25943 L
.94584 .2598 L
.94586 .26014 L
.94587 .26031 L
.94589 .25963 L
.94595 .25729 L
.94599 .25751 L
.94601 .25861 L
.94604 .25976 L
.94606 .26037 L
.94608 .25932 L
.94612 .25673 L
.94613 .2556 L
.94615 .25437 L
.94617 .25345 L
.94618 .25293 L
.94621 .2519 L
.94623 .25139 L
.94625 .25085 L
.94628 .24792 L
.94633 .2412 L
.94635 .23922 L
.94636 .23838 L
.94638 .2375 L
.9464 .23654 L
.94643 .23496 L
.94646 .23643 L
.94649 .24158 L
.94652 .24705 L
.94654 .2499 L
.94656 .25027 L
.94658 .25046 L
.94659 .25063 L
.94662 .25095 L
.94665 .2512 L
.94667 .25129 L
.94668 .25138 L
.94672 .25155 L
.94675 .2498 L
.94677 .24646 L
.9468 .24287 L
Mistroke
.94682 .24085 L
.94684 .24019 L
.94687 .24003 L
.9469 .23987 L
.94692 .23973 L
.94695 .24198 L
.94698 .2442 L
.94701 .24663 L
.94703 .24835 L
.94706 .24962 L
.94712 .25249 L
.94718 .25435 L
.94721 .25526 L
.94724 .2557 L
.94726 .25609 L
.94728 .25651 L
.94731 .25561 L
.94734 .25231 L
.94737 .24843 L
.9474 .24484 L
.94743 .2441 L
.94744 .24394 L
.94746 .24376 L
.94749 .24346 L
.94752 .24213 L
.94754 .24048 L
.94757 .23874 L
.9476 .23743 L
.94762 .23655 L
.94769 .23457 L
.94772 .23337 L
.94775 .23208 L
.94777 .23146 L
.94778 .23093 L
.94781 .23093 L
.94784 .23093 L
.94787 .23093 L
.9479 .23423 L
.94792 .23858 L
.94795 .24356 L
.94798 .24734 L
.948 .2487 L
.94803 .25 L
.94805 .25136 L
.94808 .25194 L
.94811 .25149 L
.94814 .25101 L
.94815 .25076 L
.94817 .25094 L
.9482 .25252 L
Mistroke
.94823 .25402 L
.94826 .25561 L
.94828 .25604 L
.94831 .25632 L
.94834 .25663 L
.94837 .25586 L
.94839 .25315 L
.94843 .25029 L
.94845 .24812 L
.94848 .24935 L
.94853 .25216 L
.9486 .25544 L
.94863 .25708 L
.94865 .258 L
.94867 .25817 L
.94869 .25835 L
.94871 .25854 L
.94872 .25873 L
.94874 .25892 L
.94875 .25928 L
.94878 .25991 L
.94882 .2606 L
.94884 .26081 L
.94886 .26062 L
.94888 .26046 L
.9489 .26026 L
.94891 .26008 L
.94893 .25984 L
.94894 .25817 L
.94898 .25464 L
.94901 .25156 L
.94903 .25017 L
.94905 .24928 L
.94908 .24772 L
.94911 .24607 L
.94913 .24494 L
.94916 .244 L
.94919 .24297 L
.94921 .2424 L
.94923 .24217 L
.94926 .24182 L
.94929 .24151 L
.94932 .24114 L
.94935 .2405 L
.94937 .23994 L
.9494 .23934 L
.94942 .23792 L
.94943 .23605 L
.94946 .23236 L
.94952 .22454 L
Mistroke
.94955 .2197 L
.94957 .21716 L
.94958 .21447 L
.94961 .2122 L
.94964 .21205 L
.94967 .21188 L
.94969 .21178 L
.94971 .21186 L
.94974 .21202 L
.94977 .21219 L
.9498 .2106 L
.94983 .20625 L
.94985 .20218 L
.94988 .19769 L
.94991 .19728 L
.94993 .19728 L
.94996 .19728 L
.94998 .19687 L
.95001 .19401 L
.95005 .19089 L
.95008 .18796 L
.9501 .18719 L
.95013 .18645 L
.95016 .18576 L
.95019 .18571 L
.95021 .18629 L
.95024 .1869 L
.95027 .18764 L
.9503 .18887 L
.95032 .18999 L
.95035 .1913 L
.95037 .19311 L
.95039 .19542 L
.95042 .19992 L
.95045 .20415 L
.95047 .20402 L
.9505 .20147 L
.95057 .19579 L
.95063 .18954 L
.9507 .18018 L
.95072 .17575 L
.95075 .17297 L
.95078 .17467 L
.95081 .17622 L
.95084 .17797 L
.95087 .1756 L
.95093 .17059 L
.95098 .16715 L
.95101 .16553 L
.95104 .16508 L
Mistroke
.95106 .16866 L
.95109 .1725 L
.95114 .17952 L
.95117 .18413 L
.9512 .18847 L
.95122 .19088 L
.95123 .19032 L
.95127 .1873 L
.95129 .1844 L
.95133 .18247 L
.95135 .18305 L
.95138 .18369 L
.9514 .18408 L
.95142 .18471 L
.95145 .18711 L
.95149 .18991 L
.95152 .19315 L
.95155 .19693 L
.95158 .20111 L
.9516 .20327 L
.95161 .20217 L
.95163 .19914 L
.95165 .19587 L
.95168 .19065 L
.95171 .18613 L
.95172 .18547 L
.95174 .18487 L
.95177 .1837 L
.95179 .18307 L
.9518 .18351 L
.95182 .18506 L
.95184 .1867 L
.95187 .18949 L
.95188 .19105 L
.9519 .19148 L
.95193 .19117 L
.95196 .19087 L
.95198 .1906 L
.95201 .1889 L
.95213 .1833 L
.95225 .17179 L
.95231 .16482 L
.95234 .16228 L
.95236 .16083 L
.95237 .16017 L
.9524 .16099 L
.95244 .16186 L
.95247 .16246 L
.95249 .16079 L
.95252 .15926 L
Mistroke
.95255 .15765 L
.95258 .16027 L
.9526 .16564 L
.95263 .17118 L
.95266 .17594 L
.95269 .17735 L
.95272 .17863 L
.95275 .18014 L
.95277 .18187 L
.95278 .18353 L
.95281 .18656 L
.95283 .18815 L
.95284 .18984 L
.95286 .18916 L
.95288 .18826 L
.95291 .18649 L
.95294 .18491 L
.95296 .18595 L
.95297 .18704 L
.95301 .18943 L
.95302 .19061 L
.95304 .19149 L
.95306 .19043 L
.95308 .18928 L
.95309 .18832 L
.95311 .18727 L
.95314 .18661 L
.95317 .19065 L
.95319 .19444 L
.95322 .19789 L
.95325 .19721 L
.95327 .19604 L
.95328 .19494 L
.95331 .19299 L
.95334 .18879 L
.9534 .17838 L
.95342 .17391 L
.95345 .17342 L
.95348 .17299 L
.95351 .17254 L
.95353 .17478 L
.95356 .17764 L
.95359 .18128 L
.9536 .18327 L
.95362 .18406 L
.95365 .18473 L
.95368 .18533 L
.95369 .18568 L
.95371 .18676 L
.95374 .19039 L
Mistroke
.95378 .19435 L
.95379 .19653 L
.95381 .19781 L
.95384 .19933 L
.95387 .20071 L
.95393 .20325 L
.95396 .20452 L
.95399 .20587 L
.954 .20558 L
.95402 .2048 L
.95405 .20344 L
.95408 .2021 L
.95411 .20437 L
.95415 .20769 L
.95418 .21071 L
.95421 .21511 L
.95423 .2196 L
.95426 .22439 L
.9543 .22805 L
.95432 .23006 L
.95435 .23227 L
.95438 .23412 L
.9544 .23479 L
.95443 .23557 L
.95446 .23631 L
.95449 .23932 L
.95452 .24319 L
.95455 .24742 L
.95458 .25051 L
.95461 .25265 L
.95464 .25502 L
.9547 .25919 L
.95473 .26152 L
.95476 .26342 L
.95479 .26155 L
.95482 .25951 L
.95488 .25469 L
.95492 .2514 L
.95493 .24978 L
.95495 .24859 L
.95497 .24907 L
.95499 .24958 L
.95502 .25048 L
.95505 .25066 L
.95508 .24759 L
.95511 .24422 L
.95514 .24133 L
.95517 .24217 L
.9552 .24296 L
.95525 .24444 L
Mistroke
.95529 .24527 L
.9553 .24573 L
.95532 .24616 L
.95534 .24682 L
.95535 .24793 L
.95539 .2499 L
.95551 .25531 L
.95597 .28261 L
.95599 .28057 L
.95602 .28147 L
.95605 .28311 L
.95607 .28461 L
.95613 .2873 L
.95616 .28866 L
.95619 .28991 L
.95622 .28963 L
.95625 .28928 L
.95628 .28894 L
.9563 .28975 L
.95632 .2907 L
.95634 .29241 L
.95638 .29426 L
.95641 .30134 L
.95643 .30902 L
.95654 .33344 L
.9566 .34397 L
.95662 .349 L
.95665 .35448 L
.95667 .35801 L
.9567 .35497 L
.95673 .35146 L
.95676 .34828 L
.95679 .3485 L
.9568 .3493 L
.95682 .35006 L
.95685 .35141 L
.95688 .35429 L
.95691 .3585 L
.95692 .36082 L
.95694 .36301 L
.95697 .36518 L
.957 .36549 L
.95703 .36584 L
.95706 .3661 L
.95708 .36618 L
.95709 .36627 L
.95711 .36638 L
.95713 .36647 L
.95716 .36641 L
.95719 .36609 L
Mistroke
.95722 .36579 L
.95724 .36554 L
.95727 .36652 L
.9573 .36759 L
.95733 .36854 L
.95736 .36554 L
.95739 .36249 L
.95742 .35926 L
.95744 .35841 L
.95745 .35878 L
.95748 .35943 L
.95754 .36062 L
.95757 .36127 L
.9576 .36189 L
.95763 .36283 L
.95766 .36623 L
.95768 .36907 L
.95771 .37219 L
.95773 .37266 L
.95776 .37163 L
.95781 .36976 L
.95794 .36414 L
.95797 .36033 L
.958 .35674 L
.95803 .35717 L
.95806 .35845 L
.95809 .3598 L
.95812 .36403 L
.95815 .37108 L
.95818 .37855 L
.9582 .38213 L
.95821 .38371 L
.95824 .38657 L
.95826 .38832 L
.95828 .38997 L
.9583 .39016 L
.95831 .38815 L
.95878 .34247 L
.95971 .25612 L
.95972 .25268 L
.95974 .25125 L
.95977 .25028 L
.9598 .24927 L
.95982 .24869 L
.95983 .24902 L
.95985 .24979 L
.95987 .25062 L
.95989 .25135 L
.9599 .25213 L
.95992 .25207 L
Mistroke
.95994 .24935 L
.95997 .24454 L
.96009 .21793 L
.96015 .204 L
.96017 .20058 L
.96019 .19693 L
.9602 .1936 L
.96022 .19262 L
.96025 .19074 L
.96028 .18872 L
.9603 .18758 L
.96031 .18782 L
.96034 .18867 L
.96037 .18944 L
.9604 .18985 L
.96043 .18879 L
.96046 .18761 L
.96049 .18651 L
.96051 .18084 L
.96057 .16932 L
.9606 .16396 L
.96062 .16078 L
.96065 .15702 L
.96068 .15367 L
.96071 .15182 L
.96074 .14987 L
.96076 .14792 L
.96079 .14845 L
.96082 .15044 L
.96085 .15258 L
.96088 .15361 L
.9609 .1489 L
.96093 .1433 L
.96096 .13737 L
.96097 .13572 L
.96099 .13581 L
.96102 .13598 L
.96105 .13614 L
.96108 .13512 L
.96111 .13354 L
.96114 .1321 L
.96117 .13218 L
.96119 .13417 L
.9612 .13598 L
.96123 .13955 L
.96126 .14231 L
.96127 .14189 L
.96129 .14144 L
.96132 .1405 L
.96135 .13977 L
Mistroke
.96137 .13958 L
.96139 .13941 L
.96142 .13908 L
.96145 .1386 L
.96147 .13634 L
.9615 .13388 L
.96153 .1312 L
.96155 .13046 L
.96157 .13037 L
.9616 .1302 L
.96162 .13005 L
.96165 .13056 L
.96168 .13165 L
.96174 .13392 L
.96178 .13502 L
.96181 .13605 L
.96184 .13633 L
.96187 .13483 L
.96197 .12968 L
.96203 .12699 L
.96206 .12564 L
.96209 .12437 L
.96211 .12366 L
.96212 .1219 L
.96215 .11697 L
.96217 .11437 L
.96219 .11191 L
.96222 .10871 L
.96223 .11003 L
.96225 .11145 L
.96229 .11437 L
.9623 .1157 L
.96232 .11652 L
.96235 .11769 L
.96238 .11879 L
.96241 .11886 L
.96244 .11619 L
.96246 .11376 L
.9625 .11091 L
.96251 .11092 L
.96253 .11101 L
.96256 .11118 L
.96259 .11134 L
.96262 .11259 L
.96265 .11408 L
.96268 .11544 L
.9627 .11449 L
.96273 .11119 L
.96276 .1082 L
.96282 .1019 L
Mistroke
.96285 .09935 L
.96288 .09665 L
.96291 .09459 L
.96293 .0928 L
.96299 .08954 L
.96304 .08736 L
.96307 .08615 L
.9631 .08555 L
.96313 .08503 L
.96316 .08453 L
.96322 .08339 L
.96325 .08272 L
.96328 .0827 L
.96331 .08356 L
.96334 .08447 L
.96336 .08495 L
.96338 .08515 L
.96341 .08551 L
.96344 .08585 L
.96347 .0873 L
.9635 .08986 L
.96354 .09261 L
.9636 .0974 L
.96363 .09979 L
.96365 .10098 L
.96366 .1008 L
.96369 .10048 L
.96372 .10018 L
.96374 .10002 L
.96375 .10085 L
.96378 .10306 L
.96385 .10814 L
.96388 .11094 L
.9639 .11231 L
.96392 .11357 L
.96394 .11441 L
.96395 .11423 L
.96399 .11385 L
.96402 .11354 L
.96403 .11316 L
.96405 .11249 L
.96428 .10529 L
.9643 .10444 L
.96431 .10357 L
.96433 .10317 L
.96435 .10281 L
.96436 .10246 L
.96438 .10209 L
.96441 .10172 L
.96444 .10317 L
Mistroke
.96447 .1045 L
.96453 .10817 L
.96465 .11852 L
.96466 .12041 L
.96468 .12245 L
.96471 .12421 L
.96474 .12404 L
.96477 .12389 L
.96482 .12359 L
.96485 .12345 L
.96487 .12332 L
.9649 .12188 L
.96493 .11932 L
.96496 .11673 L
.96499 .11483 L
.96502 .11667 L
.96505 .11862 L
.96511 .12175 L
.96514 .12334 L
.96516 .12424 L
.96518 .12452 L
.96521 .12282 L
.96524 .12103 L
.96527 .11986 L
.9653 .12221 L
.96533 .12424 L
.96536 .12645 L
.96538 .12688 L
.96539 .12688 L
.96542 .12688 L
.96545 .12688 L
.96548 .12866 L
.96551 .1307 L
.96555 .13292 L
.96557 .1359 L
.9656 .13906 L
.96571 .15072 L
.96577 .1595 L
.96583 .17029 L
.96595 .19115 L
.96618 .21811 L
.96639 .23627 L
.96663 .25981 L
.96669 .26507 L
.96672 .26924 L
.96675 .2743 L
.96681 .28612 L
.96688 .29767 L
.96699 .32128 L
.96704 .33254 L
Mistroke
.96707 .33866 L
.9671 .3415 L
.96713 .34262 L
.96716 .34382 L
.96719 .34476 L
.96722 .34461 L
.96724 .34447 L
.96727 .34434 L
.96729 .34794 L
.96732 .35398 L
.96781 .43201 L
.96784 .43967 L
.96787 .44156 L
.9679 .44057 L
.96792 .43967 L
.96795 .43919 L
.96797 .43984 L
.968 .44062 L
.96803 .44133 L
.96806 .44428 L
.96808 .44832 L
.96811 .45264 L
.96814 .45763 L
.96817 .46591 L
.9682 .47352 L
.96826 .49029 L
.96829 .49773 L
.96832 .50571 L
.96835 .50764 L
.96837 .50736 L
.9684 .50702 L
.96842 .50683 L
.96844 .50744 L
.9685 .50975 L
.96855 .51243 L
.96858 .514 L
.96861 .51564 L
.96864 .51621 L
.96867 .51684 L
.96869 .51742 L
.96872 .51702 L
.96875 .51527 L
.96877 .51368 L
.96881 .51262 L
.96883 .51937 L
.96886 .5263 L
.9689 .53363 L
.96891 .53553 L
.96893 .53719 L
.96896 .54011 L
Mistroke
.96898 .5417 L
.96899 .54301 L
.96903 .54185 L
.96904 .54119 L
.96906 .54049 L
.96908 .53989 L
.96909 .5384 L
.96912 .53258 L
.96915 .52712 L
.96922 .51705 L
.96945 .4896 L
.9697 .46704 L
.96973 .4678 L
.96976 .46866 L
.96978 .46941 L
.96979 .47024 L
.96982 .4717 L
.96985 .47308 L
.96988 .46925 L
.96994 .46156 L
.97015 .43199 L
.97038 .39763 L
.97062 .35755 L
.97106 .30357 L
.97154 .25018 L
.97205 .19531 L
.97229 .17088 L
.97232 .17088 L
.97234 .17097 L
.97236 .17134 L
.97239 .17211 L
.97241 .17249 L
.97242 .17282 L
.97245 .16681 L
.97249 .15872 L
.97252 .15122 L
.97255 .14953 L
.97258 .14938 L
.97261 .14921 L
.97263 .14894 L
.97266 .14847 L
.97269 .14796 L
.97271 .14768 L
.97273 .14759 L
.97276 .14759 L
.97279 .14759 L
.97282 .14745 L
.97284 .14548 L
.97287 .14378 L
.97289 .14194 L
Mistroke
.97292 .14203 L
.97295 .14424 L
.97298 .14635 L
.97301 .14795 L
.97304 .14666 L
.97306 .14549 L
.97309 .14422 L
.97312 .14549 L
.97315 .14713 L
.97318 .14887 L
.97321 .14706 L
.97323 .14256 L
.97327 .13715 L
.97328 .1342 L
.9733 .13213 L
.97331 .13096 L
.97333 .12967 L
.97335 .12851 L
.97336 .12742 L
.97339 .1263 L
.97342 .12781 L
.97345 .12943 L
.97347 .13035 L
.97349 .13026 L
.97351 .12403 L
.97355 .11732 L
.97356 .11364 L
.97358 .11104 L
.97361 .11306 L
.97364 .11481 L
.97367 .11667 L
.9737 .11427 L
.97373 .11112 L
.97374 .10933 L
.97376 .10745 L
.97378 .10604 L
.9738 .10509 L
.97387 .1015 L
.97393 .09626 L
.97396 .09373 L
.97399 .09277 L
.97402 .09189 L
.97405 .09091 L
.97408 .09041 L
.97409 .09023 L
.97411 .09006 L
.97416 .08949 L
.97422 .08889 L
.97425 .08856 L
.97426 .08721 L
Mistroke
.97428 .08595 L
.97431 .0836 L
.97434 .08138 L
.97435 .08072 L
.97437 .08054 L
.9744 .08023 L
.97446 .0794 L
.97449 .07898 L
.97452 .07854 L
.97455 .07937 L
.97457 .08243 L
.97461 .08586 L
.97464 .08844 L
.97466 .08772 L
.97469 .08693 L
.97472 .08625 L
.97474 .08629 L
.97477 .08683 L
.97479 .08743 L
.97482 .08802 L
.97485 .08577 L
.9749 .08149 L
.97497 .07633 L
.975 .07393 L
.97503 .07247 L
.97506 .07151 L
.97509 .07046 L
.97512 .06919 L
.97515 .06739 L
.97518 .06581 L
.97521 .06431 L
.97523 .06504 L
.97526 .0657 L
.97529 .06644 L
.97532 .06625 L
.97535 .06508 L
.97538 .06399 L
.97544 .06175 L
.97546 .06124 L
.97547 .06071 L
.9755 .06022 L
.97553 .06051 L
.97556 .06082 L
.97559 .06134 L
.97562 .06432 L
.97568 .07087 L
.97572 .07506 L
.97575 .07954 L
.97578 .083 L
.9758 .08348 L
Mistroke
.97582 .08394 L
.97585 .08474 L
.97588 .08547 L
.9759 .08547 L
.97592 .08547 L
.97594 .08547 L
.97596 .08547 L
.97598 .08551 L
.976 .08563 L
.97602 .08575 L
.97604 .08585 L
.97606 .08595 L
.97608 .08527 L
.9761 .08415 L
.97612 .08291 L
.97619 .07862 L
Mfstroke
1 0 0 r
.02381 .23251 m
.02384 .23729 L
.02386 .23914 L
.02392 .2421 L
.02403 .24593 L
.02426 .25217 L
.02451 .25711 L
.02474 .261 L
.02522 .26745 L
.02547 .27006 L
.02575 .27244 L
.02623 .2755 L
.02649 .27668 L
.02673 .27753 L
.02698 .2782 L
.02722 .27868 L
.02766 .2794 L
.02791 .27979 L
.02814 .28021 L
.02858 .28129 L
.02881 .28204 L
.02905 .28302 L
.02956 .28555 L
.03054 .29171 L
.03103 .29476 L
.03149 .29725 L
.03193 .2992 L
.0324 .30075 L
.03265 .30133 L
.03291 .30182 L
.03316 .30218 L
.0334 .30244 L
.03388 .30287 L
.03412 .30309 L
.03434 .30333 L
.03478 .30399 L
.03501 .30446 L
.03525 .30505 L
.03616 .30817 L
.03714 .31216 L
.03759 .31383 L
.03808 .31532 L
.03834 .31596 L
.03859 .31645 L
.03884 .31685 L
.03907 .31714 L
.03952 .31754 L
.04002 .31785 L
.04027 .31802 L
.04051 .3182 L
Mistroke
.04095 .31869 L
.04118 .31903 L
.04143 .31947 L
.04187 .32046 L
.04287 .32332 L
.04337 .32482 L
.04383 .32604 L
.04431 .32707 L
.04476 .32778 L
.04498 .32803 L
.04521 .32825 L
.04547 .32844 L
.04571 .32858 L
.04621 .32881 L
.04643 .32892 L
.04667 .32907 L
.04712 .32944 L
.04736 .32973 L
.04759 .33005 L
.04852 .33183 L
.04951 .33411 L
.05001 .33512 L
.05047 .33587 L
.05091 .33642 L
.05116 .33664 L
.05138 .3368 L
.05184 .33703 L
.05234 .33722 L
.05282 .33742 L
.05306 .33757 L
.05333 .33777 L
.0538 .33826 L
.0543 .33897 L
.05529 .34074 L
.05579 .34162 L
.05625 .34234 L
.05669 .3429 L
.05692 .34312 L
.05717 .34332 L
.05741 .34348 L
.05764 .34359 L
.05807 .34375 L
.05857 .3439 L
.05881 .34398 L
.05903 .34407 L
.05947 .34432 L
.05971 .3445 L
.05994 .34471 L
.06086 .34586 L
.06185 .3473 L
Mistroke
.06233 .34793 L
.06279 .34841 L
.06323 .34874 L
.06348 .34888 L
.0637 .34898 L
.06416 .34913 L
.06466 .34925 L
.06513 .34938 L
.06539 .34949 L
.06563 .34961 L
.0661 .34993 L
.0666 .3504 L
.06758 .35155 L
.06807 .35213 L
.06853 .3526 L
.06897 .35297 L
.06944 .35325 L
.06969 .35336 L
.06995 .35344 L
.0702 .35351 L
.07044 .35356 L
.07092 .35365 L
.07116 .35371 L
.07138 .35377 L
.07182 .35395 L
.07205 .35407 L
.07229 .35423 L
.0732 .35501 L
.07418 .35597 L
.07463 .35635 L
.07512 .35669 L
.07538 .35683 L
.07563 .35694 L
.07587 .35702 L
.07612 .35709 L
.07659 .35718 L
.07703 .35725 L
.07728 .35729 L
.07751 .35735 L
.07796 .3575 L
.07819 .3576 L
.07844 .35773 L
.07888 .35802 L
.07988 .35881 L
.08038 .35922 L
.08084 .35954 L
.08129 .35979 L
.08152 .35989 L
.08177 .35998 L
.08202 .36005 L
Mistroke
.08224 .3601 L
.08269 .36017 L
.08318 .36024 L
.0834 .36027 L
.08364 .36032 L
.08409 .36044 L
.08434 .36053 L
.08457 .36063 L
.0855 .36118 L
.08649 .36185 L
.08698 .36214 L
.08744 .36235 L
.08789 .3625 L
.08813 .36256 L
.08836 .3626 L
.08882 .36267 L
.08932 .36272 L
.0898 .36279 L
.09004 .36285 L
.09031 .36292 L
.09077 .36308 L
.09128 .36332 L
.09227 .36387 L
.09277 .36415 L
.09323 .36436 L
.09367 .36452 L
.0939 .36459 L
.09415 .36464 L
.09439 .36469 L
.09461 .36472 L
.09511 .36477 L
.09535 .36479 L
.09561 .36482 L
.09606 .36488 L
.09631 .36493 L
.09654 .36499 L
.09698 .36513 L
.0979 .36552 L
.09889 .36599 L
.09938 .36618 L
.09983 .36632 L
.10027 .36641 L
.10052 .36645 L
.10074 .36648 L
.10124 .36652 L
.1017 .36656 L
.10214 .36661 L
.10239 .36665 L
.10262 .36669 L
.10308 .36681 L
Mistroke
.10358 .36697 L
.10457 .36737 L
.10506 .36755 L
.10552 .3677 L
.10596 .36782 L
.1062 .36787 L
.10643 .3679 L
.10665 .36793 L
.10689 .36796 L
.10715 .36798 L
.10739 .36799 L
.10786 .36803 L
.10829 .36807 L
.10852 .3681 L
.10876 .36814 L
.10926 .36825 L
.11018 .36852 L
.11115 .36885 L
.1116 .36898 L
.11209 .36908 L
.11236 .36913 L
.11261 .36916 L
.11284 .36919 L
.11309 .36921 L
.114 .36926 L
.11447 .3693 L
.11473 .36933 L
.11497 .36937 L
.11543 .36945 L
.11593 .36957 L
.11691 .36985 L
.11739 .36998 L
.11785 .37009 L
.11828 .37016 L
.11853 .3702 L
.11875 .37022 L
.11921 .37026 L
.11947 .37027 L
.11971 .37028 L
.12015 .3703 L
.12041 .37032 L
.12064 .37034 L
.12089 .37036 L
.12115 .3704 L
.12164 .37048 L
.12255 .37068 L
.12352 .37091 L
.12396 .371 L
.12445 .37107 L
.12471 .3711 L
Mistroke
.12495 .37112 L
.12519 .37114 L
.12544 .37115 L
.12592 .37117 L
.12617 .37118 L
.12644 .37119 L
.12668 .37121 L
.12694 .37123 L
.1274 .37128 L
.12787 .37135 L
.12837 .37144 L
.12936 .37164 L
.12986 .37173 L
.13032 .3718 L
.13077 .37185 L
.13099 .37187 L
.13124 .37188 L
.13171 .37191 L
.13221 .37192 L
.13269 .37194 L
.13293 .37196 L
.1332 .37198 L
.13367 .37202 L
.13417 .37209 L
.13517 .37226 L
.13567 .37234 L
.13613 .37241 L
.13658 .37246 L
.13681 .37249 L
.13705 .3725 L
.1373 .37252 L
.13752 .37253 L
.13796 .37254 L
.13846 .37256 L
.1387 .37257 L
.13892 .37258 L
.13937 .3726 L
.13961 .37262 L
.13984 .37264 L
.14077 .37276 L
.14175 .37291 L
.14224 .37297 L
.1427 .37301 L
.14314 .37305 L
.14339 .37306 L
.14362 .37307 L
.14408 .37308 L
.14458 .37309 L
.14505 .37311 L
.14529 .37312 L
Mistroke
.14556 .37314 L
.14602 .37317 L
.14652 .37322 L
.14751 .37334 L
.14801 .3734 L
.14847 .37345 L
.14891 .37349 L
.14938 .37351 L
.14963 .37352 L
.1499 .37353 L
.15038 .37354 L
.15085 .37355 L
.15112 .37356 L
.15137 .37357 L
.15182 .37359 L
.15208 .37361 L
.15231 .37363 L
.15327 .37372 L
.15419 .37381 L
.15466 .37385 L
.1549 .37387 L
.15517 .37389 L
.15542 .3739 L
.15566 .37391 L
.15589 .37392 L
.15611 .37392 L
.15657 .37393 L
.15682 .37393 L
.15707 .37394 L
.1573 .37394 L
.15756 .37395 L
.158 .37397 L
.15848 .374 L
.15898 .37404 L
.15989 .37412 L
.1604 .37417 L
.16086 .3742 L
.16109 .37421 L
.16134 .37422 L
.16158 .37423 L
.1618 .37424 L
.16204 .37425 L
.16227 .37425 L
.16277 .37426 L
.16321 .37427 L
.16347 .37427 L
.1637 .37428 L
.16418 .3743 L
.16442 .37431 L
.16468 .37432 L
Mistroke
.16568 .37439 L
.16618 .37443 L
.16664 .37446 L
.16711 .37449 L
.16756 .37451 L
.16777 .37452 L
.16801 .37452 L
.16827 .37453 L
.1685 .37453 L
.169 .37454 L
.16924 .37454 L
.16946 .37454 L
.1699 .37455 L
.17014 .37456 L
.17037 .37457 L
.1713 .37462 L
.17228 .37468 L
.17277 .37471 L
.17323 .37473 L
.17367 .37475 L
.17391 .37476 L
.17414 .37476 L
.17438 .37477 L
.1746 .37477 L
.17509 .37477 L
.17535 .37478 L
.17559 .37478 L
.1758 .37478 L
.17604 .37479 L
.17652 .3748 L
.17702 .37482 L
.17794 .37487 L
.17845 .3749 L
.17891 .37492 L
.17939 .37494 L
.17985 .37496 L
.18008 .37496 L
.18033 .37497 L
.18054 .37497 L
.18077 .37497 L
.18127 .37497 L
.18151 .37498 L
.18174 .37498 L
.18197 .37498 L
.18221 .37499 L
.18267 .375 L
.18316 .37502 L
.18361 .37504 L
.18457 .37508 L
.18501 .3751 L
Mistroke
.1855 .37512 L
.18598 .37513 L
.18624 .37514 L
.18648 .37514 L
.18673 .37514 L
.18697 .37514 L
.18742 .37515 L
.18765 .37515 L
.18789 .37515 L
.18811 .37515 L
.18834 .37516 L
.1888 .37517 L
.1893 .37518 L
.19029 .37522 L
.19078 .37524 L
.19124 .37526 L
.19169 .37527 L
.19193 .37527 L
.19216 .37528 L
.1924 .37528 L
.19267 .37529 L
.19291 .37529 L
.19316 .37529 L
.19363 .37529 L
.19384 .37529 L
.19407 .37529 L
.1943 .3753 L
.19453 .3753 L
.19503 .37531 L
.19551 .37532 L
.19601 .37534 L
.19701 .37537 L
.19751 .37539 L
.19773 .37539 L
.19798 .3754 L
.19819 .3754 L
.19843 .37541 L
.19867 .37541 L
.1989 .37541 L
.19915 .37541 L
.19941 .37541 L
.19964 .37541 L
.1999 .37542 L
.20014 .37542 L
.20037 .37542 L
.20062 .37542 L
.20088 .37543 L
.20136 .37543 L
.20187 .37545 L
.20278 .37548 L
Mistroke
.2033 .37549 L
.20376 .3755 L
.20399 .37551 L
.20424 .37551 L
.20448 .37551 L
.2047 .37551 L
.20493 .37552 L
.20518 .37552 L
.20542 .37552 L
.20568 .37552 L
.20593 .37552 L
.20619 .37552 L
.20644 .37552 L
.20668 .37552 L
.20691 .37553 L
.20712 .37553 L
.20762 .37554 L
.20855 .37556 L
.20902 .37557 L
.20954 .37559 L
.21003 .3756 L
.21025 .3756 L
.21049 .3756 L
.21074 .3756 L
.21098 .37561 L
.21121 .37561 L
.21142 .37561 L
.21191 .37561 L
.21215 .37561 L
.21237 .37561 L
.21259 .37561 L
.21281 .37561 L
.21303 .37562 L
.21328 .37562 L
.21375 .37563 L
.21426 .37564 L
.21525 .37566 L
.21576 .37567 L
.21622 .37567 L
.21645 .37568 L
.21667 .37568 L
.21689 .37568 L
.21714 .37568 L
.2174 .37568 L
.21763 .37568 L
.21808 .37569 L
.21831 .37569 L
.21856 .37569 L
.21877 .37569 L
.219 .37569 L
Mistroke
.21924 .37569 L
.21947 .37569 L
.21997 .3757 L
.22092 .37572 L
.22183 .37573 L
.22231 .37574 L
.22257 .37574 L
.22281 .37575 L
.22305 .37575 L
.22327 .37575 L
.22351 .37575 L
.22364 .37575 L
.22377 .37575 L
.22403 .37575 L
.22428 .37575 L
.2245 .37575 L
.22463 .37575 L
.22474 .37575 L
.22497 .37575 L
.22522 .37575 L
.22546 .37576 L
.22567 .37576 L
.2266 .37577 L
.22759 .37579 L
.22808 .37579 L
.22854 .3758 L
.22876 .3758 L
.22898 .3758 L
.22923 .3758 L
.22945 .3758 L
.22956 .3758 L
.22968 .3758 L
.2298 .3758 L
.22993 .37581 L
.23016 .37581 L
.23037 .37581 L
.23062 .37581 L
.23075 .37581 L
.23088 .37581 L
.23111 .37581 L
.23136 .37581 L
.23161 .37581 L
.23188 .37581 L
.23236 .37582 L
.23335 .37583 L
.23384 .37584 L
.2343 .37584 L
.23474 .37585 L
.23498 .37585 L
.23521 .37585 L
Mistroke
.23532 .37585 L
.23545 .37585 L
.23567 .37585 L
.23579 .37585 L
.2359 .37585 L
.23603 .37585 L
.23616 .37585 L
.23664 .37585 L
.23676 .37585 L
.2369 .37585 L
.23703 .37585 L
.23715 .37585 L
.23739 .37585 L
.23752 .37585 L
.23764 .37586 L
.2381 .37586 L
.23855 .37586 L
.23905 .37587 L
.24002 .37588 L
.24046 .37588 L
.24095 .37589 L
.24121 .37589 L
.24146 .37589 L
.24169 .37589 L
.24182 .37589 L
.24194 .37589 L
.24206 .37589 L
.24218 .37589 L
.24229 .37589 L
.2424 .37589 L
.24267 .37589 L
.24291 .37589 L
.24302 .37589 L
.24315 .37589 L
.24326 .37589 L
.24337 .37589 L
.24362 .37589 L
.24374 .37589 L
.24388 .3759 L
.24434 .3759 L
.2446 .3759 L
.24484 .3759 L
.2458 .37591 L
.24671 .37592 L
.24718 .37592 L
.24745 .37592 L
.24769 .37593 L
.24781 .37593 L
.24793 .37593 L
.24803 .37593 L
Mistroke
.24815 .37593 L
.24827 .37593 L
.24834 .37593 L
.24841 .37593 L
.24847 .37593 L
.24853 .37593 L
.24865 .37593 L
.24877 .37593 L
.24889 .37593 L
.24901 .37593 L
.24912 .37593 L
.24924 .37593 L
.24936 .37593 L
.24949 .37593 L
.24963 .37593 L
.24975 .37593 L
.24987 .37593 L
.2501 .37593 L
.25034 .37593 L
.2506 .37593 L
.25158 .37594 L
.25253 .37595 L
.253 .37595 L
.25344 .37595 L
.25368 .37595 L
.2539 .37595 L
.25403 .37596 L
.25414 .37596 L
.25427 .37596 L
.25434 .37596 L
.25441 .37596 L
.25452 .37596 L
.25459 .37596 L
.25465 .37596 L
.2547 .37596 L
.25473 .37596 L
.25475 .37596 L
.25478 .37596 L
.25481 .37596 L
.25487 .37596 L
.2549 .37596 L
.25493 .37596 L
.25499 .37596 L
.25513 .37596 L
.25518 .37596 L
.25521 .37596 L
.25524 .37596 L
.25531 .37596 L
.25537 .37596 L
.2555 .37596 L
Mistroke
.25562 .37596 L
.25572 .37596 L
.25584 .37596 L
.25597 .37596 L
.2561 .37596 L
.25634 .37596 L
.25657 .37596 L
.25681 .37596 L
.25725 .37596 L
.25824 .37597 L
.25874 .37597 L
.2592 .37598 L
.25943 .37598 L
.25965 .37598 L
.25989 .37598 L
.26012 .37598 L
.26023 .37598 L
.26035 .37598 L
.26048 .37598 L
.26054 .37598 L
.2606 .37598 L
.26066 .37598 L
.26071 .37598 L
.26082 .37598 L
.26087 .37598 L
.26094 .37598 L
.26099 .37598 L
.26102 .37598 L
.26105 .37598 L
.26107 .37598 L
.2611 .37598 L
.26114 .37598 L
.26116 .37598 L
.26119 .37598 L
.26122 .37598 L
.26125 .37598 L
.26127 .37598 L
.2613 .37598 L
.26133 .37598 L
.26136 .37598 L
.2614 .37598 L
.26146 .37598 L
.26152 .37598 L
.26162 .37598 L
.26168 .37598 L
.26174 .37598 L
.26179 .37598 L
.26185 .37598 L
.26195 .37598 L
.26207 .37598 L
Mistroke
.2622 .37598 L
.26242 .37598 L
.26266 .37598 L
.26292 .37598 L
.26339 .37599 L
.26389 .37599 L
.26489 .376 L
.26539 .376 L
.26561 .376 L
.26585 .376 L
.26608 .376 L
.2663 .376 L
.26642 .376 L
.26653 .376 L
.26659 .376 L
.26665 .376 L
.26672 .376 L
.26677 .376 L
.26683 .376 L
.26687 .376 L
.2669 .376 L
.26696 .376 L
.26699 .376 L
.26702 .376 L
.26705 .376 L
.26708 .376 L
.2671 .376 L
.26713 .376 L
.26716 .376 L
.26719 .376 L
.26722 .376 L
.26725 .376 L
.26728 .376 L
.26731 .376 L
.26737 .376 L
.26751 .376 L
.26756 .376 L
.26762 .376 L
.26766 .376 L
.26769 .376 L
.26772 .376 L
.26775 .376 L
.26778 .376 L
.26781 .376 L
.26784 .376 L
.26786 .376 L
.26789 .376 L
.26792 .376 L
.26798 .376 L
.26805 .376 L
Mistroke
.26811 .376 L
.26823 .376 L
.26835 .376 L
.26846 .376 L
.26867 .376 L
.26891 .376 L
.26916 .376 L
.2696 .37601 L
.27052 .37601 L
.27103 .37601 L
.27149 .37602 L
.27172 .37602 L
.27197 .37602 L
.27221 .37602 L
.27243 .37602 L
.27254 .37602 L
.27265 .37602 L
.27278 .37602 L
.2729 .37602 L
.27297 .37602 L
.27303 .37602 L
.27306 .37602 L
.27309 .37602 L
.27313 .37602 L
.27314 .37602 L
.27316 .37602 L
.27319 .37602 L
.27322 .37602 L
.27325 .37602 L
.27328 .37602 L
.2733 .37602 L
.27331 .37602 L
.27334 .37602 L
.27337 .37602 L
.27341 .37602 L
.27352 .37602 L
.27363 .37602 L
.27376 .37602 L
.27382 .37602 L
.27388 .37602 L
.27394 .37602 L
.27397 .37602 L
.274 .37602 L
.27402 .37602 L
.27403 .37602 L
.27407 .37602 L
.2741 .37602 L
.27413 .37602 L
.27416 .37602 L
.27419 .37602 L
Mistroke
.27422 .37602 L
.27425 .37602 L
.27432 .37602 L
.27439 .37602 L
.27445 .37602 L
.2745 .37602 L
.27462 .37602 L
.27474 .37602 L
.27484 .37602 L
.27508 .37602 L
.27534 .37602 L
.27582 .37602 L
.27633 .37603 L
.27724 .37603 L
.27775 .37603 L
.27821 .37603 L
.27844 .37603 L
.27857 .37603 L
.27869 .37603 L
.27881 .37603 L
.27887 .37603 L
.27893 .37603 L
.27899 .37603 L
.27904 .37603 L
.27915 .37603 L
.27921 .37603 L
.27924 .37603 L
.27926 .37603 L
.27929 .37603 L
.27931 .37603 L
.27933 .37603 L
.27935 .37603 L
.27939 .37603 L
.27941 .37603 L
.27944 .37603 L
.2795 .37603 L
.2796 .37603 L
.27973 .37603 L
.27986 .37603 L
.27999 .37603 L
.28005 .37603 L
.2801 .37603 L
.28021 .37603 L
.28027 .37603 L
.2803 .37603 L
.28033 .37603 L
.28036 .37603 L
.28039 .37603 L
.2804 .37603 L
.28042 .37603 L
Mistroke
.28045 .37603 L
.28046 .37603 L
.28048 .37603 L
.28052 .37603 L
.28058 .37603 L
.28064 .37603 L
.2807 .37603 L
.28077 .37603 L
.28084 .37603 L
.28095 .37603 L
.28108 .37604 L
.28133 .37604 L
.28155 .37604 L
.28206 .37604 L
.28302 .37604 L
.28346 .37604 L
.28395 .37605 L
.28418 .37605 L
.28443 .37605 L
.28456 .37605 L
.28469 .37605 L
.28481 .37605 L
.28493 .37605 L
.28505 .37605 L
.28511 .37605 L
.28517 .37605 L
.28523 .37605 L
.28528 .37605 L
.28534 .37605 L
.28539 .37605 L
.28542 .37605 L
.28545 .37605 L
.28548 .37605 L
.28551 .37605 L
.28554 .37605 L
.28556 .37605 L
.28557 .37605 L
.2856 .37605 L
.28562 .37605 L
.28563 .37605 L
.28565 .37605 L
.28567 .37605 L
.2857 .37605 L
.28576 .37605 L
.28589 .37605 L
.28615 .37605 L
.28628 .37605 L
.28634 .37605 L
.2864 .37605 L
.28646 .37605 L
Mistroke
.28651 .37605 L
.28654 .37605 L
.28657 .37605 L
.2866 .37605 L
.28663 .37605 L
.28666 .37605 L
.28669 .37605 L
.28671 .37605 L
.28674 .37605 L
.28677 .37605 L
.28679 .37605 L
.28681 .37605 L
.28684 .37605 L
.28687 .37605 L
.28693 .37605 L
.28698 .37605 L
.28704 .37605 L
.2871 .37605 L
.28721 .37605 L
.28732 .37605 L
.28744 .37605 L
.28757 .37605 L
.28781 .37605 L
.28828 .37605 L
.28872 .37605 L
.28966 .37605 L
.29013 .37606 L
.29038 .37606 L
.29065 .37606 L
.29088 .37606 L
.29101 .37606 L
.29115 .37606 L
.29127 .37606 L
.29138 .37606 L
.29149 .37606 L
.29155 .37606 L
.29161 .37606 L
.29164 .37606 L
.29167 .37606 L
.29169 .37606 L
.29173 .37606 L
.29175 .37606 L
.29178 .37606 L
.29181 .37606 L
.29183 .37606 L
.29187 .37606 L
.29188 .37606 L
.2919 .37606 L
.29196 .37606 L
.29208 .37606 L
Mistroke
.29252 .37606 L
.29264 .37606 L
.29271 .37606 L
.29277 .37606 L
.29283 .37606 L
.29289 .37606 L
.29292 .37606 L
.29295 .37606 L
.29299 .37606 L
.29301 .37606 L
.29304 .37606 L
.29307 .37606 L
.2931 .37606 L
.29312 .37606 L
.29315 .37606 L
.29319 .37606 L
.29324 .37606 L
.2933 .37606 L
.29336 .37606 L
.29346 .37606 L
.29358 .37606 L
.29369 .37606 L
.29394 .37606 L
.29416 .37606 L
.29438 .37606 L
.2953 .37606 L
.29577 .37606 L
.29629 .37607 L
.29652 .37607 L
.29678 .37607 L
.29701 .37607 L
.29723 .37607 L
.29735 .37607 L
.29748 .37607 L
.29755 .37607 L
.29762 .37607 L
.29768 .37607 L
.29774 .37607 L
.2978 .37607 L
.29786 .37607 L
.29789 .37607 L
.29792 .37607 L
.29795 .37607 L
.29797 .37607 L
.29799 .37607 L
.29801 .37607 L
.29802 .37607 L
.29804 .37607 L
.29806 .37607 L
.29808 .37607 L
Mistroke
.29811 .37607 L
.29812 .37607 L
.29814 .37607 L
.29817 .37607 L
.29823 .37607 L
.29874 .37607 L
.29886 .37607 L
.29892 .37607 L
.29898 .37607 L
.29904 .37607 L
.29909 .37607 L
.29914 .37607 L
.2992 .37607 L
.29926 .37607 L
.29928 .37607 L
.29929 .37607 L
.29932 .37607 L
.29935 .37607 L
.29938 .37607 L
.2994 .37607 L
.29943 .37607 L
.29947 .37607 L
.2995 .37607 L
.29957 .37607 L
.29963 .37607 L
.29969 .37607 L
.2998 .37607 L
.29991 .37607 L
.30014 .37607 L
.30026 .37607 L
.30038 .37607 L
.3006 .37607 L
.3011 .37607 L
.30201 .37607 L
.30252 .37607 L
.30298 .37608 L
.30321 .37608 L
.30333 .37608 L
.30346 .37608 L
.30358 .37608 L
.3037 .37608 L
.30381 .37608 L
.30391 .37608 L
.30397 .37608 L
.30403 .37608 L
.30409 .37608 L
.30415 .37608 L
.30418 .37608 L
.3042 .37608 L
.30422 .37608 L
Mistroke
.30423 .37608 L
.30425 .37608 L
.30428 .37608 L
.30431 .37608 L
.30434 .37608 L
.30437 .37608 L
.3044 .37608 L
.30445 .37608 L
.3045 .37608 L
.30461 .37608 L
.30484 .37608 L
.3051 .37608 L
.30522 .37608 L
.30533 .37608 L
.30544 .37608 L
.30549 .37608 L
.30552 .37608 L
.30555 .37608 L
.30558 .37608 L
.30561 .37608 L
.30563 .37608 L
.30566 .37608 L
.30569 .37608 L
.30571 .37608 L
.30572 .37608 L
.30575 .37608 L
.30578 .37608 L
.30581 .37608 L
.30584 .37608 L
.30589 .37608 L
.30596 .37608 L
.30602 .37608 L
.30614 .37608 L
.30627 .37608 L
.30648 .37608 L
.30671 .37608 L
.30719 .37608 L
.30769 .37608 L
.3086 .37608 L
.30911 .37608 L
.30935 .37608 L
.30957 .37608 L
.3098 .37608 L
.30992 .37608 L
.31005 .37608 L
.31011 .37608 L
.31017 .37608 L
.31023 .37608 L
.31026 .37608 L
.31029 .37608 L
Mistroke
.31031 .37608 L
.31034 .37608 L
.31037 .37608 L
.3104 .37608 L
.31042 .37608 L
.31045 .37608 L
.31048 .37608 L
.3105 .37608 L
.31053 .37608 L
.31056 .37608 L
.31061 .37608 L
.31064 .37608 L
.31067 .37608 L
.31073 .37608 L
.31084 .37608 L
.31095 .37608 L
.31145 .37608 L
.31169 .37608 L
.31176 .37608 L
.3118 .37608 L
.31183 .37608 L
.31186 .37608 L
.31189 .37608 L
.31191 .37608 L
.31192 .37608 L
.31194 .37608 L
.31196 .37608 L
.31197 .37608 L
.31199 .37608 L
.31202 .37608 L
.31205 .37608 L
.31208 .37608 L
.31211 .37608 L
.31214 .37608 L
.31218 .37608 L
.31221 .37608 L
.31227 .37608 L
.31232 .37608 L
.31244 .37608 L
.31256 .37608 L
.31268 .37608 L
.3129 .37608 L
.31314 .37608 L
.3134 .37608 L
.31437 .37609 L
.31481 .37609 L
.3153 .37609 L
.31556 .37609 L
.31581 .37609 L
.31604 .37609 L
Mistroke
.31617 .37609 L
.31623 .37609 L
.31629 .37609 L
.31635 .37609 L
.31641 .37609 L
.31647 .37609 L
.3165 .37609 L
.31653 .37609 L
.31656 .37609 L
.31659 .37609 L
.31662 .37609 L
.31665 .37609 L
.31667 .37609 L
.3167 .37609 L
.31672 .37609 L
.31675 .37609 L
.31678 .37609 L
.31681 .37609 L
.31688 .37609 L
.31701 .37609 L
.31713 .37609 L
.31725 .37609 L
.31773 .37609 L
.31786 .37609 L
.318 .37609 L
.31806 .37609 L
.31812 .37609 L
.31815 .37609 L
.31819 .37609 L
.31822 .37609 L
.31825 .37609 L
.31828 .37609 L
.31831 .37609 L
.31834 .37609 L
.31836 .37609 L
.31837 .37609 L
.3184 .37609 L
.31843 .37609 L
.31846 .37609 L
.31848 .37609 L
.31855 .37609 L
.31861 .37609 L
.31868 .37609 L
.31874 .37609 L
.31886 .37609 L
.31898 .37609 L
.31921 .37609 L
.31944 .37609 L
.31966 .37609 L
.32015 .37609 L
Mistroke
.32108 .37609 L
.32156 .37609 L
.32181 .37609 L
.32207 .37609 L
.32221 .37609 L
.32233 .37609 L
.32244 .37609 L
.3225 .37609 L
.32257 .37609 L
.32262 .37609 L
.32268 .37609 L
.32272 .37609 L
.32275 .37609 L
.32278 .37609 L
.32281 .37609 L
.32283 .37609 L
.32286 .37609 L
.32289 .37609 L
.32292 .37609 L
.32295 .37609 L
.32297 .37609 L
.323 .37609 L
.32303 .37609 L
.32314 .37609 L
.32326 .37609 L
.32338 .37609 L
.32348 .37609 L
.32398 .37609 L
.3242 .37609 L
.32432 .37609 L
.32438 .37609 L
.32444 .37609 L
.3245 .37609 L
.32456 .37609 L
.32459 .37609 L
.32461 .37609 L
.32463 .37609 L
.32465 .37609 L
.32466 .37609 L
.32468 .37609 L
.3247 .37609 L
.32473 .37609 L
.32476 .37609 L
.32478 .37609 L
.32481 .37609 L
.32488 .37609 L
.32494 .37609 L
.32506 .37609 L
.32512 .37609 L
.32519 .37609 L
Mistroke
.32543 .37609 L
.32564 .37609 L
.32587 .37609 L
.32678 .3761 L
.32728 .3761 L
.32774 .3761 L
.32798 .3761 L
.3282 .3761 L
.32842 .3761 L
.32855 .3761 L
.32867 .3761 L
.32874 .3761 L
.3288 .3761 L
.32886 .3761 L
.32892 .3761 L
.32895 .3761 L
.32899 .3761 L
.32902 .3761 L
.32905 .3761 L
.32906 .3761 L
.32908 .3761 L
.3291 .3761 L
.32911 .3761 L
.32913 .3761 L
.32915 .3761 L
.32917 .3761 L
.32919 .3761 L
.32921 .3761 L
.32924 .3761 L
.3293 .3761 L
.32936 .3761 L
.32942 .3761 L
.32967 .3761 L
.33017 .3761 L
.33039 .3761 L
.3305 .3761 L
.33063 .3761 L
.33069 .3761 L
.33075 .3761 L
.33081 .3761 L
.33086 .3761 L
.33089 .3761 L
.33091 .3761 L
.33094 .3761 L
.33096 .3761 L
.33099 .3761 L
.33102 .3761 L
.33105 .3761 L
.33108 .3761 L
.33111 .3761 L
Mistroke
.33113 .3761 L
.33119 .3761 L
.33125 .3761 L
.3313 .3761 L
.33142 .3761 L
.33155 .3761 L
.33178 .3761 L
.33203 .3761 L
.33253 .3761 L
.3335 .3761 L
.33394 .3761 L
.33419 .3761 L
.33442 .3761 L
.33466 .3761 L
.33479 .3761 L
.33491 .3761 L
.33503 .3761 L
.3351 .3761 L
.33513 .3761 L
.33517 .3761 L
.3352 .3761 L
.33522 .3761 L
.33525 .3761 L
.33527 .3761 L
.33529 .3761 L
.33532 .3761 L
.33535 .3761 L
.33536 .3761 L
.33538 .3761 L
.3354 .3761 L
.33541 .3761 L
.33544 .3761 L
.33547 .3761 L
.33552 .3761 L
.33559 .3761 L
.33565 .3761 L
.3359 .3761 L
.33612 .3761 L
.33634 .3761 L
.33655 .3761 L
.33678 .3761 L
.33691 .3761 L
.33696 .3761 L
.33703 .3761 L
.33714 .3761 L
.33717 .3761 L
.3372 .3761 L
.33723 .3761 L
.33726 .3761 L
.33729 .3761 L
Mistroke
.33732 .3761 L
.33735 .3761 L
.33738 .3761 L
.33741 .3761 L
.33744 .3761 L
.33751 .3761 L
.33757 .3761 L
.33763 .3761 L
.33774 .3761 L
.33786 .3761 L
.33798 .3761 L
.33824 .3761 L
.3385 .3761 L
.33874 .3761 L
.33918 .3761 L
.34011 .3761 L
.34059 .3761 L
.34083 .3761 L
.34097 .3761 L
.3411 .3761 L
.34122 .3761 L
.34128 .3761 L
.34134 .3761 L
.3414 .3761 L
.34146 .3761 L
.34152 .3761 L
.34157 .3761 L
.3416 .3761 L
.34163 .3761 L
.34165 .3761 L
.34166 .3761 L
.34169 .3761 L
.34173 .3761 L
.34176 .3761 L
.34178 .3761 L
.34181 .3761 L
.34184 .3761 L
.34188 .3761 L
.34191 .3761 L
.34195 .3761 L
.34201 .3761 L
.34207 .3761 L
.34232 .3761 L
.34258 .3761 L
.34281 .3761 L
.34306 .3761 L
.34318 .3761 L
.34331 .3761 L
.34337 .3761 L
.34343 .3761 L
Mistroke
.34349 .3761 L
.34354 .3761 L
.34357 .3761 L
.3436 .3761 L
.34362 .3761 L
.34363 .3761 L
.34366 .3761 L
.34369 .3761 L
.34372 .3761 L
.34375 .3761 L
.34378 .3761 L
.3438 .3761 L
.34381 .3761 L
.34385 .3761 L
.34391 .3761 L
.34398 .3761 L
.34404 .3761 L
.34417 .3761 L
.3443 .3761 L
.34454 .3761 L
.34477 .3761 L
.34499 .3761 L
.34594 .37611 L
.34641 .37611 L
.34685 .37611 L
.34707 .37611 L
.34732 .37611 L
.34745 .37611 L
.34758 .37611 L
.34769 .37611 L
.34776 .37611 L
.34782 .37611 L
.34788 .37611 L
.34794 .37611 L
.34799 .37611 L
.34802 .37611 L
.34805 .37611 L
.34808 .37611 L
.34811 .37611 L
.34814 .37611 L
.34816 .37611 L
.34819 .37611 L
.34821 .37611 L
.34822 .37611 L
.34826 .37611 L
.34829 .37611 L
.34835 .37611 L
.34841 .37611 L
.34852 .37611 L
.34873 .37611 L
Mistroke
.34919 .37611 L
.34931 .37611 L
.34944 .37611 L
.34958 .37611 L
.34971 .37611 L
.34977 .37611 L
.34983 .37611 L
.34988 .37611 L
.34991 .37611 L
.34994 .37611 L
.34996 .37611 L
.34997 .37611 L
.34999 .37611 L
.35001 .37611 L
.35002 .37611 L
.35004 .37611 L
.35007 .37611 L
.3501 .37611 L
.35012 .37611 L
.35013 .37611 L
.35016 .37611 L
.35019 .37611 L
.35022 .37611 L
.35025 .37611 L
.35032 .37611 L
.35037 .37611 L
.35043 .37611 L
.35054 .37611 L
.35065 .37611 L
.3509 .37611 L
.35112 .37611 L
.35162 .37611 L
.35258 .37611 L
.35302 .37611 L
.35327 .37611 L
.3535 .37611 L
.35373 .37611 L
.35398 .37611 L
.3541 .37611 L
.35417 .37611 L
.35424 .37611 L
.3543 .37611 L
.35435 .37611 L
.35441 .37611 L
.35445 .37611 L
.35448 .37611 L
.35451 .37611 L
.35454 .37611 L
.35457 .37611 L
.35459 .37611 L
Mistroke
.35462 .37611 L
.35464 .37611 L
.35465 .37611 L
.35468 .37611 L
.35471 .37611 L
.35473 .37611 L
.35475 .37611 L
.35478 .37611 L
.35481 .37611 L
.35484 .37611 L
.3549 .37611 L
.35496 .37611 L
.3554 .37611 L
.35567 .37611 L
.35591 .37611 L
.35602 .37611 L
.35614 .37611 L
.3562 .37611 L
.35626 .37611 L
.35629 .37611 L
.35632 .37611 L
.35635 .37611 L
.35638 .37611 L
.35641 .37611 L
.35643 .37611 L
.35647 .37611 L
.3565 .37611 L
.35652 .37611 L
.35655 .37611 L
.35661 .37611 L
.35664 .37611 L
.35666 .37611 L
.35673 .37611 L
.35686 .37611 L
.35697 .37611 L
.35708 .37611 L
.35731 .37611 L
.35755 .37611 L
.35777 .37611 L
.35827 .37611 L
.35921 .37611 L
.35969 .37611 L
.35989 .37611 L
.36012 .37611 L
.36035 .37611 L
.36047 .37611 L
.36058 .37611 L
.36065 .37611 L
.36071 .37611 L
.36077 .37611 L
Mistroke
.36083 .37611 L
.36086 .37611 L
.36089 .37611 L
.36092 .37611 L
.36095 .37611 L
.36097 .37611 L
.36098 .37611 L
.36102 .37611 L
.36103 .37611 L
.36105 .37611 L
.36107 .37611 L
.36109 .37611 L
.36112 .37611 L
.36115 .37611 L
.36121 .37611 L
.36133 .37611 L
.36146 .37611 L
.3616 .37611 L
.36185 .37611 L
.36208 .37611 L
.36221 .37611 L
.36233 .37611 L
.36239 .37611 L
.36246 .37611 L
.36253 .37611 L
.3626 .37611 L
.36263 .37611 L
.36265 .37611 L
.36268 .37611 L
.3627 .37611 L
.36272 .37611 L
.36273 .37611 L
.36275 .37611 L
.36277 .37611 L
.36278 .37611 L
.36281 .37611 L
.36285 .37611 L
.36287 .37611 L
.3629 .37611 L
.36296 .37611 L
.36302 .37611 L
.36308 .37611 L
.36313 .37611 L
.36319 .37611 L
.36332 .37611 L
.36343 .37611 L
.36354 .37611 L
.36378 .37611 L
.36404 .37611 L
.36502 .37611 L
Mistroke
.36551 .37611 L
.36597 .37611 L
.36641 .37611 L
.36666 .37611 L
.36689 .37611 L
.367 .37611 L
.36713 .37611 L
.36723 .37611 L
.36735 .37611 L
.36741 .37611 L
.36747 .37611 L
.3675 .37611 L
.36754 .37611 L
.36757 .37611 L
.36761 .37611 L
.36764 .37611 L
.36767 .37611 L
.36769 .37611 L
.36772 .37611 L
.36775 .37611 L
.36777 .37611 L
.36779 .37611 L
.36782 .37611 L
.36785 .37611 L
.36788 .37611 L
.36789 .37611 L
.36791 .37611 L
.36794 .37611 L
.36797 .37611 L
.368 .37611 L
.36803 .37611 L
.3681 .37611 L
.36815 .37611 L
.36821 .37611 L
.36834 .37611 L
.36845 .37611 L
.36857 .37611 L
.36868 .37611 L
.36878 .37611 L
.3689 .37611 L
.36896 .37611 L
.36899 .37611 L
.36902 .37611 L
.36905 .37611 L
.36907 .37611 L
.3691 .37611 L
.36913 .37611 L
.36916 .37611 L
.36919 .37611 L
.36922 .37611 L
Mistroke
.36924 .37611 L
.36927 .37611 L
.36931 .37611 L
.36937 .37611 L
.3694 .37611 L
.36943 .37611 L
.3695 .37611 L
.36962 .37611 L
.36974 .37611 L
.36987 .37611 L
.36999 .37611 L
.37025 .37611 L
.37074 .37611 L
.37168 .37611 L
.37259 .37611 L
.37306 .37611 L
.37332 .37611 L
.37343 .37611 L
.37356 .37611 L
.37368 .37611 L
.37379 .37611 L
.37391 .37611 L
.37401 .37611 L
.37414 .37611 L
.37425 .37611 L
.37432 .37611 L
.37438 .37611 L
.37441 .37611 L
.37444 .37611 L
.37446 .37611 L
.37448 .37611 L
.37449 .37611 L
.37451 .37611 L
.37454 .37611 L
.37457 .37611 L
.3746 .37611 L
.37463 .37611 L
.37468 .37611 L
.37474 .37611 L
.3748 .37611 L
.37487 .37611 L
.37492 .37611 L
.37498 .37611 L
.37502 .37611 L
.37505 .37611 L
.37511 .37611 L
.37525 .37611 L
.3753 .37611 L
.37536 .37611 L
.37538 .37611 L
Mistroke
.3754 .37611 L
.37543 .37611 L
.37546 .37611 L
.37547 .37611 L
.37549 .37611 L
.37552 .37611 L
.37554 .37611 L
.37555 .37611 L
.37561 .37611 L
.37568 .37611 L
.37574 .37611 L
.3758 .37611 L
.37586 .37611 L
.37598 .37611 L
.37609 .37611 L
.37621 .37611 L
.37643 .37611 L
.37666 .37611 L
.37691 .37611 L
.37741 .37611 L
.37838 .37611 L
.37882 .37611 L
.37931 .37611 L
.37954 .37611 L
.37979 .37611 L
.37993 .37611 L
.38005 .37611 L
.38017 .37611 L
.3803 .37611 L
.38041 .37611 L
.38054 .37611 L
.38059 .37611 L
.38065 .37611 L
.38071 .37611 L
.38076 .37611 L
.38082 .37611 L
.38089 .37611 L
.38102 .37611 L
.38113 .37611 L
.38117 .37611 L
.3812 .37611 L
.38123 .37611 L
.38126 .37611 L
.38129 .37611 L
.38131 .37611 L
.38135 .37611 L
.38137 .37611 L
.3814 .37611 L
.38143 .37611 L
.38149 .37611 L
Mistroke
.38154 .37611 L
.38158 .37611 L
.38161 .37611 L
.38167 .37611 L
.38171 .37611 L
.38174 .37611 L
.38177 .37611 L
.3818 .37611 L
.38182 .37611 L
.38183 .37611 L
.38186 .37611 L
.38189 .37611 L
.38192 .37611 L
.38198 .37611 L
.38204 .37611 L
.38211 .37611 L
.38218 .37611 L
.38224 .37611 L
.38236 .37611 L
.38249 .37611 L
.38273 .37611 L
.38296 .37611 L
.38318 .37611 L
.38363 .37611 L
.38412 .37611 L
.38509 .37611 L
.38553 .37611 L
.38578 .37611 L
.38602 .37612 L
.38627 .37612 L
.3865 .37612 L
.38674 .37612 L
.38688 .37612 L
.38694 .37612 L
.387 .37612 L
.38711 .37612 L
.38724 .37612 L
.38748 .37612 L
.38759 .37612 L
.3877 .37612 L
.38775 .37612 L
.38782 .37612 L
.38787 .37612 L
.38793 .37612 L
.38799 .37612 L
.38806 .37612 L
.38811 .37612 L
.38818 .37612 L
.3884 .37612 L
.38864 .37612 L
Mistroke
.38878 .37612 L
.3889 .37612 L
.38915 .37612 L
.38937 .37612 L
.38988 .37612 L
.3908 .37612 L
.39178 .37612 L
.39227 .37612 L
.39251 .37612 L
.39272 .37612 L
.39293 .37612 L
.39316 .37612 L
.39339 .37612 L
.39352 .37612 L
.39363 .37612 L
.39412 .37612 L
.39457 .37612 L
.39503 .37612 L
.39529 .37612 L
.39553 .37612 L
.39577 .37612 L
.39598 .37612 L
.39648 .37612 L
.39741 .37612 L
.39841 .37612 L
.3989 .37612 L
.39912 .37612 L
.39936 .37612 L
.39958 .37612 L
.39981 .37612 L
.40005 .37612 L
.40028 .37612 L
.40075 .37612 L
.40127 .37612 L
.40151 .37612 L
.40176 .37612 L
.402 .37612 L
.40222 .37612 L
.40268 .37612 L
.40318 .37612 L
.40416 .37612 L
.40465 .37612 L
.40511 .37612 L
.40557 .37612 L
.40602 .37612 L
.40625 .37612 L
.4065 .37612 L
.40695 .37612 L
.40746 .37612 L
.40792 .37612 L
Mistroke
.40816 .37612 L
.40841 .37612 L
.40886 .37612 L
.40934 .37612 L
.40985 .37612 L
.41076 .37612 L
.41127 .37612 L
.41173 .37612 L
.41221 .37612 L
.41267 .37612 L
.4129 .37612 L
.41315 .37612 L
.41359 .37612 L
.4145 .37612 L
.415 .37612 L
.41546 .37612 L
.41592 .37612 L
.41639 .37612 L
.41731 .37612 L
.41828 .37612 L
.41922 .37612 L
.42022 .37612 L
.42118 .37612 L
.4221 .37612 L
.42309 .37612 L
.42403 .37612 L
.42494 .37612 L
.42591 .37612 L
.42685 .37612 L
.42784 .37612 L
.42879 .37612 L
.42971 .37612 L
.43069 .37612 L
.43163 .37612 L
.43263 .37612 L
.4336 .37612 L
.43452 .37612 L
.43551 .37612 L
.43646 .37612 L
.43737 .37612 L
.43835 .37612 L
.43928 .37612 L
.44028 .37612 L
.44124 .37612 L
.44216 .37612 L
.44314 .37612 L
.44409 .37612 L
.44499 .37612 L
.44596 .37612 L
.44689 .37612 L
Mistroke
.44788 .37612 L
.44884 .37612 L
.44975 .37612 L
.45073 .37612 L
.45167 .37612 L
.45267 .37612 L
.45363 .37612 L
.45455 .37612 L
.45554 .37612 L
.45649 .37612 L
.4574 .37612 L
.45837 .37612 L
.4593 .37612 L
.4603 .37612 L
.46125 .37612 L
.46217 .37612 L
.46315 .37612 L
.46409 .37612 L
.465 .37612 L
.46597 .37612 L
.4669 .37612 L
.46788 .37612 L
.46883 .37612 L
.46975 .37612 L
.47072 .37612 L
.47166 .37612 L
.47266 .37612 L
.47362 .37612 L
.47454 .37612 L
.47552 .37612 L
.47647 .37612 L
.47738 .37612 L
.47835 .37612 L
.47928 .37612 L
.48027 .37612 L
.48123 .37612 L
.48214 .37612 L
.48312 .37612 L
.48406 .37612 L
.48506 .37612 L
.48602 .37612 L
.48695 .37612 L
.48794 .37612 L
.48889 .37612 L
.4898 .37612 L
.49077 .37612 L
.49171 .37612 L
.4927 .37612 L
.49366 .37612 L
.49458 .37612 L
Mistroke
.49556 .37612 L
.4965 .37612 L
.49741 .37612 L
.49838 .37612 L
.49931 .37612 L
.5003 .37612 L
.50125 .37612 L
.50217 .37612 L
.50314 .37612 L
.50408 .37612 L
.50508 .37612 L
.50604 .37612 L
.50696 .37612 L
.50795 .37612 L
.5089 .37612 L
.50981 .37612 L
.51078 .37612 L
.51171 .37612 L
.5127 .37612 L
.51366 .37612 L
.51458 .37612 L
.51556 .37612 L
.5165 .37612 L
.5175 .37612 L
.51846 .37612 L
.51939 .37612 L
.52038 .37612 L
.52133 .37612 L
.52224 .37612 L
.52322 .37612 L
.52415 .37612 L
.52515 .37612 L
.52611 .37612 L
.52703 .37612 L
.52801 .37612 L
.52896 .37612 L
.52987 .37612 L
.53083 .37612 L
.53176 .37612 L
.53276 .37612 L
.53371 .37612 L
.53463 .37612 L
.5356 .37612 L
.53654 .37612 L
.53754 .37612 L
.5385 .37612 L
.53943 .37612 L
.54042 .37612 L
.54136 .37612 L
.54228 .37612 L
Mistroke
.54325 .37612 L
.54418 .37612 L
.54518 .37612 L
.54613 .37612 L
.54705 .37612 L
.54803 .37612 L
.54898 .37612 L
.54988 .37612 L
.55085 .37612 L
.55178 .37612 L
.55277 .37612 L
.55372 .37612 L
.55463 .37612 L
.55561 .37612 L
.55655 .37612 L
.55754 .37612 L
.5585 .37612 L
.55943 .37612 L
.56041 .37612 L
.56136 .37612 L
.56227 .37612 L
.56324 .37612 L
.56417 .37612 L
.56516 .37612 L
.56612 .37612 L
.56703 .37612 L
.56755 .37612 L
.56801 .37612 L
.5685 .37612 L
.56895 .37612 L
.56942 .37612 L
.56966 .37612 L
.56992 .37612 L
.57014 .37612 L
.57027 .37612 L
.57039 .37612 L
.5705 .37612 L
.57056 .37612 L
.57062 .37612 L
.57067 .37612 L
.57073 .37612 L
.57078 .37612 L
.57083 .37612 L
.57086 .37612 L
.57089 .37612 L
.57092 .37612 L
.57094 .37612 L
.57097 .37612 L
.57099 .37612 L
.57101 .37612 L
Mistroke
.57104 .37612 L
.57107 .37612 L
.5711 .37612 L
.57113 .37612 L
.57119 .37612 L
.57125 .37612 L
.57132 .37612 L
.57142 .37612 L
.57154 .37612 L
.57176 .37612 L
.57223 .37612 L
.57274 .37612 L
.57365 .37612 L
.57461 .37612 L
.57554 .37612 L
.57601 .37612 L
.57653 .37612 L
.57702 .37612 L
.57724 .37612 L
.57748 .37612 L
.57761 .37612 L
.57773 .37612 L
.57784 .37612 L
.5779 .37612 L
.57797 .37612 L
.57803 .37612 L
.57808 .37612 L
.57811 .37612 L
.57813 .37612 L
.57816 .37612 L
.57818 .37612 L
.57822 .37612 L
.57824 .37612 L
.57827 .37612 L
.57829 .37612 L
.5783 .37612 L
.57833 .37612 L
.57836 .37612 L
.57839 .37612 L
.57841 .37612 L
.57848 .37612 L
.57854 .37612 L
.57867 .37612 L
.57878 .37612 L
.5789 .37612 L
.57912 .37612 L
.57935 .37612 L
.57981 .37612 L
.58032 .37612 L
.5808 .37612 L
Mistroke
.5813 .37612 L
.58222 .37612 L
.5832 .37612 L
.58413 .37612 L
.58513 .37612 L
.58609 .37612 L
.58702 .37612 L
.588 .37612 L
.58895 .37612 L
.58986 .37612 L
.59083 .37612 L
.59176 .37612 L
.59275 .37612 L
.59371 .37612 L
.59463 .37612 L
.59561 .37612 L
.59655 .37612 L
.59755 .37612 L
.59851 .37612 L
.59944 .37612 L
.60043 .37612 L
.60138 .37612 L
.60229 .37612 L
.60326 .37612 L
.6042 .37612 L
.60471 .37612 L
.60519 .37612 L
.60567 .37612 L
.60612 .37612 L
.60635 .37612 L
.60657 .37612 L
.60681 .37612 L
.60694 .37612 L
.60706 .37612 L
.60718 .37612 L
.60724 .37612 L
.6073 .37612 L
.60735 .37612 L
.60741 .37612 L
.60744 .37612 L
.60747 .37612 L
.60749 .37612 L
.60752 .37612 L
.60755 .37612 L
.60758 .37612 L
.60761 .37612 L
.60763 .37612 L
.60764 .37612 L
.60767 .37612 L
.6077 .37612 L
Mistroke
.60773 .37612 L
.60776 .37612 L
.60782 .37612 L
.60788 .37612 L
.60802 .37612 L
.60813 .37612 L
.60825 .37612 L
.60847 .37612 L
.60897 .37612 L
.60996 .37612 L
.61046 .37612 L
.61092 .37612 L
.61137 .37612 L
.6116 .37612 L
.61173 .37612 L
.61185 .37612 L
.61196 .37612 L
.61203 .37612 L
.61209 .37612 L
.61215 .37612 L
.61221 .37612 L
.61223 .37612 L
.61226 .37612 L
.61229 .37612 L
.61231 .37612 L
.61234 .37612 L
.61238 .37612 L
.6124 .37612 L
.61243 .37612 L
.61246 .37612 L
.6125 .37612 L
.61256 .37612 L
.61262 .37612 L
.61269 .37612 L
.61282 .37612 L
.61293 .37612 L
.61304 .37612 L
.61329 .37612 L
.6135 .37612 L
.61372 .37612 L
.6142 .37612 L
.61464 .37612 L
.61513 .37612 L
.61558 .37612 L
.61654 .37612 L
.61747 .37612 L
.61845 .37612 L
.6194 .37612 L
.62031 .37612 L
.62128 .37612 L
Mistroke
.62221 .37612 L
.6232 .37612 L
.62416 .37612 L
.62508 .37612 L
.62606 .37612 L
.627 .37612 L
.62791 .37612 L
.62887 .37612 L
.6298 .37612 L
.63079 .37612 L
.63174 .37612 L
.63265 .37612 L
.63363 .37612 L
.63456 .37612 L
.63556 .37612 L
.63652 .37612 L
.63744 .37612 L
.63842 .37612 L
.63937 .37612 L
.64028 .37612 L
.64124 .37612 L
.64218 .37612 L
.64317 .37612 L
.64412 .37612 L
.64504 .37612 L
.64602 .37612 L
.64696 .37612 L
.64795 .37612 L
.64892 .37612 L
.64984 .37612 L
.65083 .37612 L
.65178 .37612 L
.65269 .37612 L
.65366 .37612 L
.6546 .37612 L
.65559 .37612 L
.65655 .37612 L
.65747 .37612 L
.65845 .37612 L
.65939 .37612 L
.6603 .37612 L
.66126 .37612 L
.66219 .37612 L
.66318 .37612 L
.66413 .37612 L
.66505 .37612 L
.66602 .37612 L
.66696 .37612 L
.66796 .37612 L
.66892 .37612 L
Mistroke
.66984 .37612 L
.67083 .37612 L
.67177 .37612 L
.67268 .37612 L
.67365 .37612 L
.67459 .37612 L
.67558 .37612 L
.67653 .37612 L
.67745 .37612 L
.67843 .37612 L
.67937 .37612 L
.68037 .37612 L
.68134 .37612 L
.68226 .37612 L
.68325 .37612 L
.6842 .37612 L
.68511 .37612 L
.68609 .37612 L
.68702 .37612 L
.68802 .37612 L
.68898 .37612 L
.6899 .37612 L
.69088 .37612 L
.69182 .37612 L
.69273 .37612 L
.6937 .37612 L
.69463 .37612 L
.69562 .37612 L
.69657 .37612 L
.69749 .37612 L
.69847 .37612 L
.6994 .37612 L
.7004 .37612 L
.70136 .37612 L
.70229 .37612 L
.70327 .37612 L
.70422 .37612 L
.70513 .37612 L
.7061 .37612 L
.70704 .37612 L
.70803 .37612 L
.70899 .37612 L
.70991 .37612 L
.71089 .37612 L
.71183 .37612 L
.71274 .37612 L
.7137 .37612 L
.71463 .37612 L
.71562 .37612 L
.71657 .37612 L
Mistroke
.71748 .37612 L
.71846 .37612 L
.7194 .37612 L
.72039 .37612 L
.72135 .37612 L
.72227 .37612 L
.72326 .37612 L
.7242 .37612 L
.72511 .37612 L
.72608 .37612 L
.72701 .37612 L
.728 .37612 L
.72896 .37612 L
.72988 .37612 L
.73085 .37612 L
.73179 .37612 L
.73279 .37612 L
.73376 .37612 L
.73468 .37612 L
.73567 .37612 L
.73662 .37612 L
.73753 .37612 L
.7385 .37612 L
.73944 .37612 L
.74043 .37612 L
.74139 .37612 L
.74231 .37612 L
.74329 .37612 L
.74424 .37612 L
.74514 .37612 L
.74611 .37612 L
.74704 .37612 L
.74803 .37612 L
.74898 .37612 L
.7499 .37612 L
.75087 .37612 L
.75181 .37612 L
.75281 .37612 L
.75377 .37612 L
.75469 .37612 L
.75568 .37612 L
.75663 .37612 L
.75754 .37612 L
.75851 .37612 L
.75944 .37612 L
.76043 .37612 L
.76139 .37612 L
.76231 .37612 L
.76328 .37612 L
.76423 .37612 L
Mistroke
.76523 .37612 L
.76619 .37612 L
.76712 .37612 L
.76811 .37612 L
.76906 .37612 L
.76997 .37612 L
.77094 .37612 L
.77188 .37612 L
.77288 .37612 L
.77384 .37612 L
.77476 .37612 L
.77574 .37612 L
.77668 .37612 L
.77759 .37612 L
.77856 .37612 L
.77949 .37612 L
.78048 .37612 L
.78098 .37612 L
.78144 .37612 L
.78188 .37612 L
.78213 .37612 L
.78235 .37612 L
.78247 .37612 L
.78259 .37612 L
.7827 .37612 L
.78276 .37612 L
.78282 .37612 L
.78285 .37612 L
.78288 .37612 L
.78291 .37612 L
.78294 .37612 L
.78297 .37612 L
.78299 .37612 L
.78301 .37612 L
.78302 .37612 L
.78304 .37612 L
.78306 .37612 L
.78307 .37612 L
.7831 .37612 L
.78313 .37612 L
.78316 .37612 L
.78319 .37612 L
.78325 .37612 L
.78332 .37612 L
.78343 .37612 L
.78355 .37612 L
.7838 .37612 L
.78403 .37612 L
.78424 .37612 L
.78517 .37612 L
Mistroke
.78616 .37612 L
.78712 .37612 L
.78804 .37612 L
.78901 .37612 L
.78996 .37612 L
.79096 .37612 L
.79192 .37612 L
.79285 .37612 L
.79383 .37612 L
.79478 .37612 L
.7957 .37612 L
.79667 .37612 L
.7976 .37612 L
.7986 .37612 L
.79956 .37612 L
.80048 .37612 L
.80146 .37612 L
.8024 .37612 L
.80331 .37612 L
.80428 .37612 L
.80521 .37612 L
.8062 .37612 L
.80715 .37612 L
.80807 .37612 L
.80904 .37612 L
.80998 .37612 L
.81098 .37612 L
.81194 .37612 L
.81287 .37612 L
.81385 .37612 L
.8148 .37612 L
.81571 .37612 L
.81668 .37612 L
.81761 .37612 L
.81861 .37612 L
.81956 .37612 L
.82048 .37612 L
.82146 .37612 L
.8224 .37612 L
.82331 .37612 L
.82428 .37612 L
.8252 .37612 L
.82619 .37612 L
.82714 .37612 L
.82806 .37612 L
.82903 .37612 L
.82997 .37612 L
.83096 .37612 L
.83192 .37612 L
.83285 .37612 L
Mistroke
.83383 .37612 L
.83477 .37612 L
.83568 .37612 L
.83665 .37612 L
.83758 .37612 L
.83857 .37612 L
.83953 .37612 L
.84045 .37612 L
.84142 .37612 L
.84236 .37612 L
.84336 .37612 L
.84432 .37612 L
.84525 .37612 L
.84624 .37612 L
.84719 .37612 L
.8481 .37612 L
.84907 .37612 L
.85 .37612 L
.851 .37612 L
.85196 .37612 L
.85288 .37612 L
.85386 .37612 L
.8548 .37612 L
.85571 .37612 L
.85667 .37612 L
.8576 .37612 L
.85859 .37612 L
.85954 .37612 L
.86046 .37612 L
.86143 .37612 L
.86237 .37612 L
.86337 .37612 L
.86433 .37612 L
.86526 .37612 L
.86624 .37612 L
.86719 .37612 L
.8681 .37612 L
.86907 .37612 L
.87 .37612 L
.87099 .37612 L
.87195 .37612 L
.87287 .37612 L
.87384 .37612 L
.87478 .37612 L
.87579 .37612 L
.87675 .37612 L
.87768 .37612 L
.87866 .37612 L
.87961 .37612 L
.88053 .37612 L
Mistroke
.8815 .37612 L
.88244 .37612 L
.88343 .37612 L
.88439 .37612 L
.88531 .37612 L
.88629 .37612 L
.88724 .37612 L
.88815 .37612 L
.88911 .37612 L
.89005 .37612 L
.89104 .37612 L
.89199 .37612 L
.89291 .37612 L
.89388 .37612 L
.89482 .37612 L
.89582 .37612 L
.89678 .37612 L
.89771 .37612 L
.89869 .37612 L
.89964 .37612 L
.90055 .37612 L
.90152 .37612 L
.90246 .37612 L
.90345 .37612 L
.90441 .37612 L
.90533 .37612 L
.90631 .37612 L
.90725 .37612 L
.90816 .37612 L
.90912 .37612 L
.91005 .37612 L
.91104 .37612 L
.91199 .37612 L
.9129 .37612 L
.91388 .37612 L
.91482 .37612 L
.91581 .37612 L
.91677 .37612 L
.9177 .37612 L
.91868 .37612 L
.91962 .37612 L
.92053 .37612 L
.9215 .37612 L
.92244 .37612 L
.92343 .37612 L
.92438 .37612 L
.9253 .37612 L
.92628 .37612 L
.92722 .37612 L
.92822 .37612 L
Mistroke
.92918 .37612 L
.93011 .37612 L
.93109 .37612 L
.93204 .37612 L
.93296 .37612 L
.93393 .37612 L
.93486 .37612 L
.93586 .37612 L
.93682 .37612 L
.93774 .37612 L
.93872 .37612 L
.93966 .37612 L
.94057 .37612 L
.94154 .37612 L
.94247 .37612 L
.94346 .37612 L
.94441 .37612 L
.94532 .37612 L
.9463 .37612 L
.94724 .37612 L
.94824 .37612 L
.9492 .37612 L
.95012 .37612 L
.95111 .37612 L
.95205 .37612 L
.95296 .37612 L
.95393 .37612 L
.95487 .37612 L
.95586 .37612 L
.95682 .37612 L
.95774 .37612 L
.95871 .37612 L
.95966 .37612 L
.96066 .37612 L
.96162 .37612 L
.96255 .37612 L
.96354 .37612 L
.96449 .37612 L
.9654 .37612 L
.96638 .37612 L
.96731 .37612 L
.96831 .37612 L
.96927 .37612 L
.97019 .37612 L
.97117 .37612 L
.97212 .37612 L
.97303 .37612 L
.97399 .37612 L
.97492 .37612 L
.97592 .37612 L
Mistroke
.97619 .37612 L
Mfstroke
0 0 0 r
.02381 .23248 m
.02474 .23248 L
.02575 .23248 L
.0267 .23248 L
.02761 .23248 L
.02859 .23248 L
.02952 .23248 L
.03052 .23248 L
.03148 .23248 L
.0324 .23248 L
.03338 .23248 L
.03433 .23248 L
.03524 .23248 L
.03621 .23248 L
.03714 .23248 L
.03813 .23248 L
.03908 .23248 L
.04 .23248 L
.04098 .23248 L
.04192 .23248 L
.04292 .23248 L
.04388 .23248 L
.0448 .23248 L
.04579 .23248 L
.04674 .23248 L
.04765 .23248 L
.04862 .23248 L
.04956 .23248 L
.05055 .23248 L
.05151 .23248 L
.05243 .23248 L
.05341 .23248 L
.05435 .23248 L
.05526 .23248 L
.05622 .23248 L
.05715 .23248 L
.05814 .23248 L
.05909 .23248 L
.06001 .23248 L
.06098 .23248 L
.06192 .23248 L
.06292 .23248 L
.06388 .23248 L
.0648 .23248 L
.06579 .23248 L
.06673 .23248 L
.06764 .23248 L
.06861 .23248 L
.06954 .23248 L
.07054 .23248 L
Mistroke
.07149 .23248 L
.07241 .23248 L
.07339 .23248 L
.07433 .23248 L
.07533 .23248 L
.07629 .23248 L
.07722 .23248 L
.07821 .23248 L
.07916 .23248 L
.08007 .23248 L
.08104 .23248 L
.08198 .23248 L
.08297 .23248 L
.08393 .23248 L
.08485 .23248 L
.08584 .23248 L
.08678 .23248 L
.08769 .23248 L
.08866 .23248 L
.08959 .23248 L
.09058 .23248 L
.09153 .23248 L
.09245 .23248 L
.09342 .23248 L
.09436 .23248 L
.09536 .23248 L
.09632 .23248 L
.09725 .23248 L
.09823 .23248 L
.09918 .23248 L
.10009 .23248 L
.10106 .23248 L
.10199 .23248 L
.10299 .23248 L
.10394 .23248 L
.10486 .23248 L
.10584 .23248 L
.10678 .23248 L
.10769 .23248 L
.10866 .23248 L
.10958 .23248 L
.11057 .23248 L
.11152 .23248 L
.11244 .23248 L
.11341 .23248 L
.11435 .23248 L
.11535 .23248 L
.1163 .23248 L
.11723 .23248 L
.11821 .23248 L
Mistroke
.11916 .23248 L
.12007 .23248 L
.12103 .23248 L
.12197 .23248 L
.12296 .23248 L
.12391 .23248 L
.12483 .23248 L
.12581 .23248 L
.12675 .23248 L
.12775 .23248 L
.12871 .23248 L
.12964 .23248 L
.13062 .23248 L
.13157 .23248 L
.13248 .23248 L
.13345 .23248 L
.13439 .23248 L
.13538 .23248 L
.13634 .23248 L
.13726 .23248 L
.13824 .23248 L
.13919 .23248 L
.14009 .23248 L
.14106 .23248 L
.14199 .23248 L
.14298 .23248 L
.14393 .23248 L
.14485 .23248 L
.14582 .23248 L
.14676 .23248 L
.14776 .23248 L
.14872 .23248 L
.14964 .23248 L
.15063 .23248 L
.15158 .23248 L
.15249 .23248 L
.15346 .23248 L
.15439 .23248 L
.15538 .23248 L
.15634 .23248 L
.15726 .23248 L
.15823 .23248 L
.15918 .23248 L
.16018 .23248 L
.16114 .23248 L
.16207 .23248 L
.16306 .23248 L
.16401 .23248 L
.16492 .23248 L
.16589 .23248 L
Mistroke
.16683 .23248 L
.16782 .23248 L
.16878 .23248 L
.16971 .23248 L
.17069 .23248 L
.17163 .23248 L
.17254 .23248 L
.17351 .23248 L
.17444 .23248 L
.17543 .23248 L
.17638 .23248 L
.1773 .23248 L
.17828 .23248 L
.17922 .23248 L
.18022 .23248 L
.18118 .23248 L
.1821 .23248 L
.18309 .23248 L
.18404 .23248 L
.18495 .23248 L
.18592 .23248 L
.18685 .23248 L
.18785 .23248 L
.1888 .23248 L
.18972 .23248 L
.1907 .23248 L
.19165 .23248 L
.19255 .23248 L
.19352 .23248 L
.19445 .23248 L
.19544 .23248 L
.19639 .23248 L
.1973 .23248 L
.19828 .23248 L
.19922 .23248 L
.20021 .23248 L
.20117 .23248 L
.2021 .23248 L
.20308 .23248 L
.20403 .23248 L
.20494 .23248 L
.2059 .23248 L
.20684 .23248 L
.20783 .23248 L
.20878 .23248 L
.2097 .23248 L
.21068 .23248 L
.21162 .23248 L
.21262 .23248 L
.21358 .23248 L
Mistroke
.21451 .23248 L
.2155 .23248 L
.21645 .23248 L
.21736 .23248 L
.21833 .23248 L
.21927 .23248 L
.22026 .23248 L
.22122 .23248 L
.22214 .23248 L
.22312 .23248 L
.22407 .23248 L
.22497 .23248 L
.22594 .23248 L
.22687 .23248 L
.22786 .23248 L
.22881 .23248 L
.22973 .23248 L
.23071 .23248 L
.23164 .23248 L
.23264 .23248 L
.2336 .23248 L
.23453 .23248 L
.23551 .23248 L
.23646 .23248 L
.23737 .23248 L
.23834 .23248 L
.23928 .23248 L
.24027 .23248 L
.24122 .23248 L
.24214 .23248 L
.24312 .23248 L
.24406 .23248 L
.24497 .23248 L
.24594 .23248 L
.24686 .23248 L
.24785 .23248 L
.2488 .23248 L
.24972 .23248 L
.25069 .23248 L
.25163 .23248 L
.25262 .23248 L
.25358 .23248 L
.25451 .23248 L
.25549 .23248 L
.25643 .23248 L
.25734 .23248 L
.25831 .23248 L
.25924 .23248 L
.26023 .23248 L
.26119 .23248 L
Mistroke
.2621 .23248 L
.26308 .23248 L
.26402 .23248 L
.26502 .23248 L
.26598 .23248 L
.26691 .23248 L
.26789 .23248 L
.26884 .23248 L
.26976 .23248 L
.27073 .23248 L
.27166 .23248 L
.27266 .23248 L
.27361 .23248 L
.27453 .23248 L
.27551 .23248 L
.27646 .23248 L
.27736 .23248 L
.27833 .23248 L
.27926 .23248 L
.28025 .23248 L
.2812 .23248 L
.28212 .23248 L
.28309 .23248 L
.28403 .23248 L
.28503 .23248 L
.28599 .23248 L
.28691 .23248 L
.28789 .23248 L
.28884 .23248 L
.28975 .23248 L
.29072 .23248 L
.29165 .23248 L
.29265 .23248 L
.2936 .23248 L
.29452 .23248 L
.2955 .23248 L
.29644 .23248 L
.29744 .23248 L
.2984 .23248 L
.29933 .23248 L
.30032 .23248 L
.30127 .23248 L
.30218 .23248 L
.30315 .23248 L
.30409 .23248 L
.30509 .23248 L
.30604 .23248 L
.30697 .23248 L
.30795 .23248 L
.30889 .23248 L
Mistroke
.3098 .23248 L
.31077 .23248 L
.3117 .23248 L
.31269 .23248 L
.31364 .23248 L
.31456 .23248 L
.31554 .23248 L
.31647 .23248 L
.31747 .23248 L
.31844 .23248 L
.31936 .23248 L
.32035 .23248 L
.32129 .23248 L
.3222 .23248 L
.32318 .23248 L
.32411 .23248 L
.3251 .23248 L
.32606 .23248 L
.32698 .23248 L
.32796 .23248 L
.3289 .23248 L
.32981 .23248 L
.33077 .23248 L
.3317 .23248 L
.33269 .23248 L
.33364 .23248 L
.33456 .23248 L
.33553 .23248 L
.33647 .23248 L
.33746 .23248 L
.33842 .23248 L
.33935 .23248 L
.34033 .23248 L
.34128 .23248 L
.34218 .23248 L
.34315 .23248 L
.34409 .23248 L
.34508 .23248 L
.34603 .23248 L
.34695 .23248 L
.34793 .23248 L
.34887 .23248 L
.34987 .23248 L
.35083 .23248 L
.35176 .23248 L
.35274 .23248 L
.35369 .23248 L
.3546 .23248 L
.35558 .23248 L
.35651 .23248 L
Mistroke
.35751 .23248 L
.35846 .23248 L
.35939 .23248 L
.36037 .23248 L
.36131 .23248 L
.36222 .23248 L
.36318 .23248 L
.36411 .23248 L
.3651 .23248 L
.36606 .23248 L
.36697 .23248 L
.36795 .23248 L
.36889 .23248 L
.36988 .23248 L
.37084 .23248 L
.37177 .23248 L
.37275 .23248 L
.3737 .23248 L
.37461 .23248 L
.37558 .23248 L
.37651 .23248 L
.37751 .23248 L
.37846 .23248 L
.37938 .23248 L
.38036 .23248 L
.3813 .23248 L
.3823 .23248 L
.38327 .23248 L
.3842 .23248 L
.38518 .23248 L
.38613 .23248 L
.38705 .23248 L
.38802 .23248 L
.38896 .23248 L
.38995 .23248 L
.39091 .23248 L
.39183 .23248 L
.39282 .23248 L
.39376 .23248 L
.39467 .23248 L
.39564 .23248 L
.39657 .23248 L
.39756 .23248 L
.39851 .23248 L
.39943 .23248 L
.40041 .23248 L
.40135 .23248 L
.40235 .23248 L
.40331 .23248 L
.40423 .23248 L
Mistroke
.40522 .23248 L
.40617 .23248 L
.40708 .23248 L
.40805 .23248 L
.40899 .23248 L
.40998 .23248 L
.41094 .23248 L
.41186 .23248 L
.41284 .23248 L
.41378 .23248 L
.41469 .23248 L
.41565 .23248 L
.41658 .23248 L
.41757 .23248 L
.41852 .23248 L
.41944 .23248 L
.42041 .23248 L
.42135 .23248 L
.42235 .23248 L
.42331 .23248 L
.42423 .23248 L
.42521 .23248 L
.42616 .23248 L
.42707 .23248 L
.42804 .23248 L
.42897 .23248 L
.42996 .23248 L
.43092 .23248 L
.43184 .23248 L
.43282 .23248 L
.43376 .23248 L
.43476 .23248 L
.43572 .23248 L
.43665 .23248 L
.43763 .23248 L
.43858 .23248 L
.4395 .23248 L
.44047 .23248 L
.44141 .23248 L
.4424 .23248 L
.44336 .23248 L
.44428 .23248 L
.44526 .23248 L
.44621 .23248 L
.44711 .23248 L
.44808 .23248 L
.44901 .23248 L
.45 .23248 L
.45095 .23248 L
.45187 .23248 L
Mistroke
.45285 .23248 L
.45379 .23248 L
.45478 .23248 L
.45574 .23248 L
.45667 .23248 L
.45765 .23248 L
.4586 .23248 L
.45951 .23248 L
.46048 .23248 L
.46142 .23248 L
.46241 .23248 L
.46337 .23248 L
.46429 .23248 L
.46527 .23248 L
.46621 .23248 L
.46711 .23248 L
.46808 .23248 L
.46901 .23248 L
.46999 .23248 L
.47095 .23248 L
.47186 .23248 L
.47283 .23248 L
.47377 .23248 L
.47477 .23248 L
.47573 .23248 L
.47665 .23248 L
.47763 .23248 L
.47858 .23248 L
.47949 .23248 L
.48046 .23248 L
.48139 .23248 L
.48238 .23248 L
.48333 .23248 L
.48425 .23248 L
.48523 .23248 L
.48617 .23248 L
.48717 .23248 L
.48813 .23248 L
.48906 .23248 L
.49004 .23248 L
.49099 .23248 L
.4919 .23248 L
.49288 .23248 L
.49381 .23248 L
.4948 .23248 L
.49576 .23248 L
.49668 .23248 L
.49766 .23248 L
.49861 .23248 L
.49951 .23248 L
Mistroke
.50048 .23248 L
.50141 .23248 L
.5024 .23248 L
.50335 .23248 L
.50427 .23248 L
.50524 .23248 L
.50618 .23248 L
.50718 .23248 L
.50814 .23248 L
.50906 .23248 L
.51005 .23248 L
.51099 .23248 L
.5119 .23248 L
.51287 .23248 L
.51381 .23248 L
.5148 .23248 L
.51575 .23248 L
.51667 .23248 L
.51765 .23248 L
.51859 .23248 L
.51959 .23248 L
.52056 .23248 L
.52149 .23248 L
.52247 .23248 L
.52342 .23248 L
.52434 .23248 L
.52531 .23248 L
.52625 .23248 L
.52724 .23248 L
.5282 .23248 L
.52912 .23248 L
.5301 .23248 L
.53105 .23248 L
.53196 .23248 L
.53292 .23248 L
.53386 .23248 L
.53485 .23248 L
.5358 .23248 L
.53672 .23248 L
.53769 .23248 L
.53863 .23248 L
.53963 .23248 L
.54059 .23248 L
.54152 .23248 L
.5425 .23248 L
.54345 .23248 L
.54436 .23248 L
.54533 .23248 L
.54627 .23248 L
.54726 .23248 L
Mistroke
.54822 .23248 L
.54914 .23248 L
.55012 .23248 L
.55106 .23248 L
.55197 .23248 L
.55293 .23248 L
.55386 .23248 L
.55485 .23248 L
.5558 .23248 L
.55672 .23248 L
.55769 .23248 L
.55863 .23248 L
.55962 .23248 L
.56058 .23248 L
.56151 .23248 L
.56249 .23248 L
.56344 .23248 L
.56435 .23248 L
.56532 .23248 L
.56625 .23248 L
.56724 .23248 L
.56819 .23248 L
.56911 .23248 L
.57009 .23248 L
.57103 .23248 L
.57203 .23248 L
.57299 .23248 L
.57392 .23248 L
.57491 .23248 L
.57586 .23248 L
.57677 .23248 L
.57774 .23248 L
.57868 .23248 L
.57967 .23248 L
.58063 .23248 L
.58155 .23248 L
.58253 .23248 L
.58348 .23248 L
.58438 .23248 L
.58535 .23248 L
.58628 .23248 L
.58727 .23248 L
.58822 .23248 L
.58914 .23248 L
.59011 .23248 L
.59105 .23248 L
.59205 .23248 L
.59301 .23248 L
.59394 .23248 L
.59492 .23248 L
Mistroke
.59587 .23248 L
.59678 .23248 L
.59775 .23248 L
.59868 .23248 L
.59968 .23248 L
.60063 .23248 L
.60155 .23248 L
.60253 .23248 L
.60347 .23248 L
.60438 .23248 L
.60534 .23248 L
.60627 .23248 L
.60726 .23248 L
.60821 .23248 L
.60912 .23248 L
.6101 .23248 L
.61103 .23248 L
.61203 .23248 L
.61299 .23248 L
.61391 .23248 L
.61489 .23248 L
.61584 .23248 L
.61675 .23248 L
.61772 .23248 L
.61865 .23248 L
.61964 .23248 L
.62059 .23248 L
.62151 .23248 L
.62249 .23248 L
.62343 .23248 L
.62442 .23248 L
.62539 .23248 L
.62631 .23248 L
.6273 .23248 L
.62825 .23248 L
.62916 .23248 L
.63013 .23248 L
.63107 .23248 L
.63206 .23248 L
.63302 .23248 L
.63394 .23248 L
.63492 .23248 L
.63586 .23248 L
.63677 .23248 L
.63773 .23248 L
.63866 .23248 L
.63965 .23248 L
.6406 .23248 L
.64152 .23248 L
.64249 .23248 L
Mistroke
.64343 .23248 L
.64443 .23248 L
.64539 .23248 L
.64631 .23248 L
.6473 .23248 L
.64824 .23248 L
.64915 .23248 L
.65012 .23248 L
.65106 .23248 L
.65205 .23248 L
.653 .23248 L
.65392 .23248 L
.6549 .23248 L
.65584 .23248 L
.65684 .23248 L
.6578 .23248 L
.65873 .23248 L
.65972 .23248 L
.66067 .23248 L
.66158 .23248 L
.66255 .23248 L
.66349 .23248 L
.66449 .23248 L
.66544 .23248 L
.66637 .23248 L
.66735 .23248 L
.66829 .23248 L
.6692 .23248 L
.67017 .23248 L
.6711 .23248 L
.67209 .23248 L
.67304 .23248 L
.67396 .23248 L
.67493 .23248 L
.67587 .23248 L
.67687 .23248 L
.67783 .23248 L
.67876 .23248 L
.67974 .23248 L
.68069 .23248 L
.6816 .23248 L
.68257 .23248 L
.68351 .23248 L
.6845 .23248 L
.68546 .23248 L
.68638 .23248 L
.68736 .23248 L
.6883 .23248 L
.6892 .23248 L
.69017 .23248 L
Mistroke
.6911 .23248 L
.69209 .23248 L
.69304 .23248 L
.69395 .23248 L
.69493 .23248 L
.69586 .23248 L
.69686 .23248 L
.69782 .23248 L
.69874 .23248 L
.69972 .23248 L
.70067 .23248 L
.70158 .23248 L
.70255 .23248 L
.70348 .23248 L
.70447 .23248 L
.70543 .23248 L
.70634 .23248 L
.70732 .23248 L
.70826 .23248 L
.70926 .23248 L
.71022 .23248 L
.71115 .23248 L
.71214 .23248 L
.71309 .23248 L
.714 .23248 L
.71497 .23248 L
.71591 .23248 L
.7169 .23248 L
.71786 .23248 L
.71878 .23248 L
.71976 .23248 L
.7207 .23248 L
.72161 .23248 L
.72258 .23248 L
.72351 .23248 L
.7245 .23248 L
.72545 .23248 L
.72636 .23248 L
.72734 .23248 L
.72828 .23248 L
.72928 .23248 L
.73024 .23248 L
.73116 .23248 L
.73215 .23248 L
.73309 .23248 L
.734 .23248 L
.73497 .23248 L
.73591 .23248 L
.7369 .23248 L
.73785 .23248 L
Mistroke
.73877 .23248 L
.73975 .23248 L
.74069 .23248 L
.74169 .23248 L
.74266 .23248 L
.74359 .23248 L
.74457 .23248 L
.74552 .23248 L
.74644 .23248 L
.74741 .23248 L
.74835 .23248 L
.74934 .23248 L
.7503 .23248 L
.75122 .23248 L
.75221 .23248 L
.75315 .23248 L
.75406 .23248 L
.75503 .23248 L
.75596 .23248 L
.75695 .23248 L
.7579 .23248 L
.75882 .23248 L
.7598 .23248 L
.76074 .23248 L
.76173 .23248 L
.7627 .23248 L
.76362 .23248 L
.76461 .23248 L
.76556 .23248 L
.76647 .23248 L
.76744 .23248 L
.76837 .23248 L
.76937 .23248 L
.77032 .23248 L
.77124 .23248 L
.77222 .23248 L
.77317 .23248 L
.77407 .23248 L
.77504 .23248 L
.77597 .23248 L
.77696 .23248 L
.77791 .23248 L
.77882 .23248 L
.7798 .23248 L
.78074 .23248 L
.78173 .23248 L
.78269 .23248 L
.78362 .23248 L
.7846 .23248 L
.78555 .23248 L
Mistroke
.78646 .23248 L
.78742 .23248 L
.78836 .23248 L
.78935 .23248 L
.7903 .23248 L
.79122 .23248 L
.7922 .23248 L
.79314 .23248 L
.79414 .23248 L
.7951 .23248 L
.79603 .23248 L
.79702 .23248 L
.79797 .23248 L
.79888 .23248 L
.79985 .23248 L
.80079 .23248 L
.80178 .23248 L
.80274 .23248 L
.80366 .23248 L
.80464 .23248 L
.80559 .23248 L
.8065 .23248 L
.80746 .23248 L
.80839 .23248 L
.80938 .23248 L
.81034 .23248 L
.81125 .23248 L
.81223 .23248 L
.81317 .23248 L
.81417 .23248 L
.81513 .23248 L
.81605 .23248 L
.81704 .23248 L
.81798 .23248 L
.81889 .23248 L
.81987 .23248 L
.8208 .23248 L
.82179 .23248 L
.82275 .23248 L
.82367 .23248 L
.82465 .23248 L
.82559 .23248 L
.82649 .23248 L
.82746 .23248 L
.82839 .23248 L
.82938 .23248 L
.83033 .23248 L
.83124 .23248 L
.83221 .23248 L
.83315 .23248 L
Mistroke
.83415 .23248 L
.83511 .23248 L
.83603 .23248 L
.83701 .23248 L
.83796 .23248 L
.83887 .23248 L
.83983 .23248 L
.84077 .23248 L
.84176 .23248 L
.84271 .23248 L
.84363 .23248 L
.84461 .23248 L
.84555 .23248 L
.84655 .23248 L
.84751 .23248 L
.84843 .23248 L
.84942 .23248 L
.85037 .23248 L
.85128 .23248 L
.85225 .23248 L
.85319 .23248 L
.85418 .23248 L
.85514 .23248 L
.85606 .23248 L
.85704 .23248 L
.85798 .23248 L
.85889 .23248 L
.85986 .23248 L
.86079 .23248 L
.86178 .23248 L
.86273 .23248 L
.86364 .23248 L
.86462 .23248 L
.86556 .23248 L
.86655 .23248 L
.86751 .23248 L
.86844 .23248 L
.86942 .23248 L
.87037 .23248 L
.87128 .23248 L
.87225 .23248 L
.87318 .23248 L
.87417 .23248 L
.87513 .23248 L
.87605 .23248 L
.87703 .23248 L
.87797 .23248 L
.87897 .23248 L
.87993 .23248 L
.88086 .23248 L
Mistroke
.88185 .23248 L
.8828 .23248 L
.88371 .23248 L
.88468 .23248 L
.88562 .23248 L
.88661 .23248 L
.88757 .23248 L
.8885 .23248 L
.88948 .23248 L
.89042 .23248 L
.89133 .23248 L
.8923 .23248 L
.89323 .23248 L
.89422 .23248 L
.89517 .23248 L
.89609 .23248 L
.89706 .23248 L
.898 .23248 L
.899 .23248 L
.89996 .23248 L
.90089 .23248 L
.90187 .23248 L
.90282 .23248 L
.90373 .23248 L
.9047 .23248 L
.90564 .23248 L
.90663 .23248 L
.90759 .23248 L
.90851 .23248 L
.90949 .23248 L
.91043 .23248 L
.91134 .23248 L
.9123 .23248 L
.91323 .23248 L
.91422 .23248 L
.91517 .23248 L
.91609 .23248 L
.91706 .23248 L
.918 .23248 L
.91899 .23248 L
.91995 .23248 L
.92088 .23248 L
.92186 .23248 L
.92281 .23248 L
.92372 .23248 L
.92468 .23248 L
.92562 .23248 L
.92661 .23248 L
.92756 .23248 L
.92848 .23248 L
Mistroke
.92946 .23248 L
.9304 .23248 L
.9314 .23248 L
.93236 .23248 L
.93329 .23248 L
.93427 .23248 L
.93522 .23248 L
.93614 .23248 L
.93711 .23248 L
.93804 .23248 L
.93904 .23248 L
.94 .23248 L
.94092 .23248 L
.9419 .23248 L
.94284 .23248 L
.94375 .23248 L
.94472 .23248 L
.94565 .23248 L
.94664 .23248 L
.94759 .23248 L
.94851 .23248 L
.94948 .23248 L
.95042 .23248 L
.95142 .23248 L
.95238 .23248 L
.9533 .23248 L
.95429 .23248 L
.95523 .23248 L
.95614 .23248 L
.95711 .23248 L
.95805 .23248 L
.95904 .23248 L
.96 .23248 L
.96092 .23248 L
.96189 .23248 L
.96284 .23248 L
.96384 .23248 L
.9648 .23248 L
.96573 .23248 L
.96672 .23248 L
.96767 .23248 L
.96858 .23248 L
.96956 .23248 L
.97049 .23248 L
.97149 .23248 L
.97245 .23248 L
.97337 .23248 L
.97435 .23248 L
.9753 .23248 L
.97619 .23248 L
Mistroke
Mfstroke
1 0 0 r
.02381 .23245 m
.02384 .22767 L
.02386 .22582 L
.02392 .22286 L
.02403 .21903 L
.02426 .21279 L
.02451 .20784 L
.02474 .20396 L
.02522 .19751 L
.02547 .1949 L
.02575 .19251 L
.02623 .18946 L
.02649 .18828 L
.02673 .18742 L
.02698 .18676 L
.02722 .18628 L
.02766 .18556 L
.02791 .18517 L
.02814 .18475 L
.02858 .18367 L
.02881 .18291 L
.02905 .18193 L
.02956 .17941 L
.03054 .17325 L
.03103 .1702 L
.03149 .1677 L
.03193 .16575 L
.0324 .16421 L
.03265 .16363 L
.03291 .16313 L
.03316 .16278 L
.0334 .16252 L
.03388 .16209 L
.03412 .16187 L
.03434 .16163 L
.03478 .16097 L
.03501 .1605 L
.03525 .15991 L
.03616 .15679 L
.03714 .15279 L
.03759 .15113 L
.03808 .14964 L
.03834 .14899 L
.03859 .14851 L
.03884 .14811 L
.03907 .14781 L
.03952 .14742 L
.04002 .14711 L
.04027 .14694 L
.04051 .14676 L
Mistroke
.04095 .14627 L
.04118 .14593 L
.04143 .14549 L
.04187 .1445 L
.04287 .14163 L
.04337 .14014 L
.04383 .13892 L
.04431 .13789 L
.04476 .13718 L
.04498 .13692 L
.04521 .1367 L
.04547 .13651 L
.04571 .13638 L
.04621 .13615 L
.04643 .13604 L
.04667 .13589 L
.04712 .13551 L
.04736 .13523 L
.04759 .13491 L
.04852 .13313 L
.04951 .13085 L
.05001 .12984 L
.05047 .12908 L
.05091 .12854 L
.05116 .12832 L
.05138 .12816 L
.05184 .12793 L
.05234 .12774 L
.05282 .12753 L
.05306 .12739 L
.05333 .12719 L
.0538 .1267 L
.0543 .12598 L
.05529 .12422 L
.05579 .12333 L
.05625 .12262 L
.05669 .12206 L
.05692 .12184 L
.05717 .12164 L
.05741 .12148 L
.05764 .12137 L
.05807 .12121 L
.05857 .12106 L
.05881 .12098 L
.05903 .12089 L
.05947 .12064 L
.05971 .12045 L
.05994 .12024 L
.06086 .1191 L
.06185 .11766 L
Mistroke
.06233 .11702 L
.06279 .11655 L
.06323 .11621 L
.06348 .11608 L
.0637 .11598 L
.06416 .11583 L
.06466 .11571 L
.06513 .11558 L
.06539 .11547 L
.06563 .11534 L
.0661 .11502 L
.0666 .11456 L
.06758 .11341 L
.06807 .11283 L
.06853 .11236 L
.06897 .11199 L
.06944 .11171 L
.06969 .1116 L
.06995 .11151 L
.0702 .11145 L
.07044 .1114 L
.07092 .11131 L
.07116 .11125 L
.07138 .11119 L
.07182 .11101 L
.07205 .11089 L
.07229 .11073 L
.0732 .10995 L
.07418 .10899 L
.07463 .1086 L
.07512 .10827 L
.07538 .10812 L
.07563 .10802 L
.07587 .10794 L
.07612 .10787 L
.07659 .10778 L
.07703 .10771 L
.07728 .10766 L
.07751 .10761 L
.07796 .10746 L
.07819 .10736 L
.07844 .10723 L
.07888 .10694 L
.07988 .10614 L
.08038 .10574 L
.08084 .10542 L
.08129 .10517 L
.08152 .10507 L
.08177 .10498 L
.08202 .10491 L
Mistroke
.08224 .10486 L
.08269 .10479 L
.08318 .10472 L
.0834 .10469 L
.08364 .10464 L
.08409 .10452 L
.08434 .10443 L
.08457 .10433 L
.0855 .10378 L
.08649 .10311 L
.08698 .10282 L
.08744 .10261 L
.08789 .10246 L
.08813 .1024 L
.08836 .10235 L
.08882 .10229 L
.08932 .10224 L
.0898 .10216 L
.09004 .10211 L
.09031 .10204 L
.09077 .10188 L
.09128 .10164 L
.09227 .10108 L
.09277 .10081 L
.09323 .1006 L
.09367 .10044 L
.0939 .10037 L
.09415 .10032 L
.09439 .10027 L
.09461 .10024 L
.09511 .10019 L
.09535 .10017 L
.09561 .10014 L
.09606 .10007 L
.09631 .10002 L
.09654 .09997 L
.09698 .09983 L
.0979 .09943 L
.09889 .09897 L
.09938 .09878 L
.09983 .09864 L
.10027 .09855 L
.10052 .09851 L
.10074 .09848 L
.10124 .09844 L
.1017 .0984 L
.10214 .09835 L
.10239 .09831 L
.10262 .09827 L
.10308 .09815 L
Mistroke
.10358 .09798 L
.10457 .09759 L
.10506 .0974 L
.10552 .09725 L
.10596 .09714 L
.1062 .09709 L
.10643 .09706 L
.10665 .09703 L
.10689 .097 L
.10715 .09698 L
.10739 .09697 L
.10786 .09693 L
.10829 .09689 L
.10852 .09686 L
.10876 .09682 L
.10926 .09671 L
.11018 .09643 L
.11115 .09611 L
.1116 .09598 L
.11209 .09587 L
.11236 .09583 L
.11261 .0958 L
.11284 .09577 L
.11309 .09575 L
.114 .0957 L
.11447 .09566 L
.11473 .09563 L
.11497 .09559 L
.11543 .09551 L
.11593 .09538 L
.11691 .09511 L
.11739 .09498 L
.11785 .09487 L
.11828 .0948 L
.11853 .09476 L
.11875 .09474 L
.11921 .0947 L
.11947 .09469 L
.11971 .09468 L
.12015 .09465 L
.12041 .09464 L
.12064 .09462 L
.12089 .09459 L
.12115 .09456 L
.12164 .09448 L
.12255 .09428 L
.12352 .09405 L
.12396 .09396 L
.12445 .09389 L
.12471 .09386 L
Mistroke
.12495 .09384 L
.12519 .09382 L
.12544 .09381 L
.12592 .09379 L
.12617 .09378 L
.12644 .09377 L
.12668 .09375 L
.12694 .09373 L
.1274 .09368 L
.12787 .09361 L
.12837 .09352 L
.12936 .09332 L
.12986 .09323 L
.13032 .09316 L
.13077 .09311 L
.13099 .09309 L
.13124 .09307 L
.13171 .09305 L
.13221 .09304 L
.13269 .09302 L
.13293 .093 L
.1332 .09298 L
.13367 .09293 L
.13417 .09287 L
.13517 .0927 L
.13567 .09261 L
.13613 .09255 L
.13658 .09249 L
.13681 .09247 L
.13705 .09245 L
.1373 .09244 L
.13752 .09243 L
.13796 .09241 L
.13846 .0924 L
.1387 .09239 L
.13892 .09238 L
.13937 .09236 L
.13961 .09234 L
.13984 .09231 L
.14077 .0922 L
.14175 .09205 L
.14224 .09199 L
.1427 .09194 L
.14314 .09191 L
.14339 .0919 L
.14362 .09189 L
.14408 .09188 L
.14458 .09186 L
.14505 .09185 L
.14529 .09184 L
Mistroke
.14556 .09182 L
.14602 .09179 L
.14652 .09174 L
.14751 .09162 L
.14801 .09156 L
.14847 .09151 L
.14891 .09147 L
.14938 .09145 L
.14963 .09144 L
.1499 .09143 L
.15038 .09142 L
.15085 .09141 L
.15112 .0914 L
.15137 .09139 L
.15182 .09137 L
.15208 .09135 L
.15231 .09133 L
.15327 .09124 L
.15419 .09114 L
.15466 .0911 L
.1549 .09109 L
.15517 .09107 L
.15542 .09106 L
.15566 .09105 L
.15589 .09104 L
.15611 .09104 L
.15657 .09103 L
.15682 .09102 L
.15707 .09102 L
.1573 .09101 L
.15756 .09101 L
.158 .09099 L
.15848 .09096 L
.15898 .09092 L
.15989 .09084 L
.1604 .09079 L
.16086 .09076 L
.16109 .09075 L
.16134 .09073 L
.16158 .09073 L
.1618 .09072 L
.16204 .09071 L
.16227 .09071 L
.16277 .0907 L
.16321 .09069 L
.16347 .09069 L
.1637 .09068 L
.16418 .09066 L
.16442 .09065 L
.16468 .09064 L
Mistroke
.16568 .09056 L
.16618 .09053 L
.16664 .09049 L
.16711 .09047 L
.16756 .09045 L
.16777 .09044 L
.16801 .09044 L
.16827 .09043 L
.1685 .09043 L
.169 .09042 L
.16924 .09042 L
.16946 .09041 L
.1699 .0904 L
.17014 .0904 L
.17037 .09039 L
.1713 .09034 L
.17228 .09027 L
.17277 .09025 L
.17323 .09022 L
.17367 .09021 L
.17391 .0902 L
.17414 .0902 L
.17438 .09019 L
.1746 .09019 L
.17509 .09018 L
.17535 .09018 L
.17559 .09018 L
.1758 .09018 L
.17604 .09017 L
.17652 .09016 L
.17702 .09014 L
.17794 .09009 L
.17845 .09006 L
.17891 .09003 L
.17939 .09002 L
.17985 .09 L
.18008 .09 L
.18033 .08999 L
.18054 .08999 L
.18077 .08999 L
.18127 .08998 L
.18151 .08998 L
.18174 .08998 L
.18197 .08998 L
.18221 .08997 L
.18267 .08996 L
.18316 .08994 L
.18361 .08992 L
.18457 .08988 L
.18501 .08986 L
Mistroke
.1855 .08984 L
.18598 .08983 L
.18624 .08982 L
.18648 .08982 L
.18673 .08982 L
.18697 .08982 L
.18742 .08981 L
.18765 .08981 L
.18789 .08981 L
.18811 .08981 L
.18834 .0898 L
.1888 .08979 L
.1893 .08978 L
.19029 .08974 L
.19078 .08972 L
.19124 .0897 L
.19169 .08969 L
.19193 .08968 L
.19216 .08968 L
.1924 .08968 L
.19267 .08967 L
.19291 .08967 L
.19316 .08967 L
.19363 .08967 L
.19384 .08967 L
.19407 .08966 L
.1943 .08966 L
.19453 .08966 L
.19503 .08965 L
.19551 .08964 L
.19601 .08962 L
.19701 .08958 L
.19751 .08957 L
.19773 .08956 L
.19798 .08956 L
.19819 .08956 L
.19843 .08955 L
.19867 .08955 L
.1989 .08955 L
.19915 .08955 L
.19941 .08954 L
.19964 .08954 L
.1999 .08954 L
.20014 .08954 L
.20037 .08954 L
.20062 .08954 L
.20088 .08953 L
.20136 .08952 L
.20187 .08951 L
.20278 .08948 L
Mistroke
.2033 .08947 L
.20376 .08946 L
.20399 .08945 L
.20424 .08945 L
.20448 .08945 L
.2047 .08944 L
.20493 .08944 L
.20518 .08944 L
.20542 .08944 L
.20568 .08944 L
.20593 .08944 L
.20619 .08944 L
.20644 .08944 L
.20668 .08943 L
.20691 .08943 L
.20712 .08943 L
.20762 .08942 L
.20855 .0894 L
.20902 .08938 L
.20954 .08937 L
.21003 .08936 L
.21025 .08936 L
.21049 .08936 L
.21074 .08935 L
.21098 .08935 L
.21121 .08935 L
.21142 .08935 L
.21191 .08935 L
.21215 .08935 L
.21237 .08935 L
.21259 .08935 L
.21281 .08934 L
.21303 .08934 L
.21328 .08934 L
.21375 .08933 L
.21426 .08932 L
.21525 .0893 L
.21576 .08929 L
.21622 .08928 L
.21645 .08928 L
.21667 .08928 L
.21689 .08928 L
.21714 .08928 L
.2174 .08927 L
.21763 .08927 L
.21808 .08927 L
.21831 .08927 L
.21856 .08927 L
.21877 .08927 L
.219 .08927 L
Mistroke
.21924 .08927 L
.21947 .08926 L
.21997 .08926 L
.22092 .08924 L
.22183 .08922 L
.22231 .08922 L
.22257 .08921 L
.22281 .08921 L
.22305 .08921 L
.22327 .08921 L
.22351 .08921 L
.22364 .08921 L
.22377 .08921 L
.22403 .08921 L
.22428 .08921 L
.2245 .08921 L
.22463 .08921 L
.22474 .08921 L
.22497 .08921 L
.22522 .0892 L
.22546 .0892 L
.22567 .0892 L
.2266 .08919 L
.22759 .08917 L
.22808 .08917 L
.22854 .08916 L
.22876 .08916 L
.22898 .08916 L
.22923 .08916 L
.22945 .08915 L
.22956 .08915 L
.22968 .08915 L
.2298 .08915 L
.22993 .08915 L
.23016 .08915 L
.23037 .08915 L
.23062 .08915 L
.23075 .08915 L
.23088 .08915 L
.23111 .08915 L
.23136 .08915 L
.23161 .08915 L
.23188 .08915 L
.23236 .08914 L
.23335 .08913 L
.23384 .08912 L
.2343 .08912 L
.23474 .08911 L
.23498 .08911 L
.23521 .08911 L
Mistroke
.23532 .08911 L
.23545 .08911 L
.23567 .08911 L
.23579 .08911 L
.2359 .08911 L
.23603 .08911 L
.23616 .08911 L
.23664 .08911 L
.23676 .08911 L
.2369 .08911 L
.23703 .0891 L
.23715 .0891 L
.23739 .0891 L
.23752 .0891 L
.23764 .0891 L
.2381 .0891 L
.23855 .0891 L
.23905 .08909 L
.24002 .08908 L
.24046 .08907 L
.24095 .08907 L
.24121 .08907 L
.24146 .08907 L
.24169 .08907 L
.24182 .08907 L
.24194 .08907 L
.24206 .08907 L
.24218 .08907 L
.24229 .08907 L
.2424 .08907 L
.24267 .08907 L
.24291 .08907 L
.24302 .08907 L
.24315 .08907 L
.24326 .08906 L
.24337 .08906 L
.24362 .08906 L
.24374 .08906 L
.24388 .08906 L
.24434 .08906 L
.2446 .08906 L
.24484 .08906 L
.2458 .08905 L
.24671 .08904 L
.24718 .08903 L
.24745 .08903 L
.24769 .08903 L
.24781 .08903 L
.24793 .08903 L
.24803 .08903 L
Mistroke
.24815 .08903 L
.24827 .08903 L
.24834 .08903 L
.24841 .08903 L
.24847 .08903 L
.24853 .08903 L
.24865 .08903 L
.24877 .08903 L
.24889 .08903 L
.24901 .08903 L
.24912 .08903 L
.24924 .08903 L
.24936 .08903 L
.24949 .08903 L
.24963 .08903 L
.24975 .08903 L
.24987 .08903 L
.2501 .08903 L
.25034 .08903 L
.2506 .08903 L
.25158 .08902 L
.25253 .08901 L
.253 .08901 L
.25344 .089 L
.25368 .089 L
.2539 .089 L
.25403 .089 L
.25414 .089 L
.25427 .089 L
.25434 .089 L
.25441 .089 L
.25452 .089 L
.25459 .089 L
.25465 .089 L
.2547 .089 L
.25473 .089 L
.25475 .089 L
.25478 .089 L
.25481 .089 L
.25487 .089 L
.2549 .089 L
.25493 .089 L
.25499 .089 L
.25513 .089 L
.25518 .089 L
.25521 .089 L
.25524 .089 L
.25531 .089 L
.25537 .089 L
.2555 .089 L
Mistroke
.25562 .089 L
.25572 .089 L
.25584 .089 L
.25597 .089 L
.2561 .089 L
.25634 .089 L
.25657 .089 L
.25681 .089 L
.25725 .089 L
.25824 .08899 L
.25874 .08898 L
.2592 .08898 L
.25943 .08898 L
.25965 .08898 L
.25989 .08898 L
.26012 .08898 L
.26023 .08898 L
.26035 .08898 L
.26048 .08898 L
.26054 .08898 L
.2606 .08898 L
.26066 .08898 L
.26071 .08898 L
.26082 .08898 L
.26087 .08898 L
.26094 .08898 L
.26099 .08898 L
.26102 .08898 L
.26105 .08898 L
.26107 .08898 L
.2611 .08898 L
.26114 .08898 L
.26116 .08898 L
.26119 .08898 L
.26122 .08898 L
.26125 .08898 L
.26127 .08898 L
.2613 .08898 L
.26133 .08898 L
.26136 .08898 L
.2614 .08898 L
.26146 .08898 L
.26152 .08898 L
.26162 .08898 L
.26168 .08898 L
.26174 .08898 L
.26179 .08898 L
.26185 .08898 L
.26195 .08898 L
.26207 .08898 L
Mistroke
.2622 .08898 L
.26242 .08898 L
.26266 .08898 L
.26292 .08897 L
.26339 .08897 L
.26389 .08897 L
.26489 .08896 L
.26539 .08896 L
.26561 .08896 L
.26585 .08896 L
.26608 .08896 L
.2663 .08896 L
.26642 .08896 L
.26653 .08896 L
.26659 .08896 L
.26665 .08896 L
.26672 .08896 L
.26677 .08896 L
.26683 .08896 L
.26687 .08896 L
.2669 .08896 L
.26696 .08896 L
.26699 .08896 L
.26702 .08896 L
.26705 .08896 L
.26708 .08896 L
.2671 .08896 L
.26713 .08896 L
.26716 .08896 L
.26719 .08896 L
.26722 .08896 L
.26725 .08896 L
.26728 .08896 L
.26731 .08896 L
.26737 .08896 L
.26751 .08896 L
.26756 .08896 L
.26762 .08896 L
.26766 .08896 L
.26769 .08896 L
.26772 .08896 L
.26775 .08896 L
.26778 .08896 L
.26781 .08896 L
.26784 .08896 L
.26786 .08896 L
.26789 .08896 L
.26792 .08896 L
.26798 .08896 L
.26805 .08896 L
Mistroke
.26811 .08896 L
.26823 .08896 L
.26835 .08896 L
.26846 .08896 L
.26867 .08896 L
.26891 .08896 L
.26916 .08895 L
.2696 .08895 L
.27052 .08895 L
.27103 .08894 L
.27149 .08894 L
.27172 .08894 L
.27197 .08894 L
.27221 .08894 L
.27243 .08894 L
.27254 .08894 L
.27265 .08894 L
.27278 .08894 L
.2729 .08894 L
.27297 .08894 L
.27303 .08894 L
.27306 .08894 L
.27309 .08894 L
.27313 .08894 L
.27314 .08894 L
.27316 .08894 L
.27319 .08894 L
.27322 .08894 L
.27325 .08894 L
.27328 .08894 L
.2733 .08894 L
.27331 .08894 L
.27334 .08894 L
.27337 .08894 L
.27341 .08894 L
.27352 .08894 L
.27363 .08894 L
.27376 .08894 L
.27382 .08894 L
.27388 .08894 L
.27394 .08894 L
.27397 .08894 L
.274 .08894 L
.27402 .08894 L
.27403 .08894 L
.27407 .08894 L
.2741 .08894 L
.27413 .08894 L
.27416 .08894 L
.27419 .08894 L
Mistroke
.27422 .08894 L
.27425 .08894 L
.27432 .08894 L
.27439 .08894 L
.27445 .08894 L
.2745 .08894 L
.27462 .08894 L
.27474 .08894 L
.27484 .08894 L
.27508 .08894 L
.27534 .08894 L
.27582 .08894 L
.27633 .08893 L
.27724 .08893 L
.27775 .08893 L
.27821 .08892 L
.27844 .08892 L
.27857 .08892 L
.27869 .08892 L
.27881 .08892 L
.27887 .08892 L
.27893 .08892 L
.27899 .08892 L
.27904 .08892 L
.27915 .08892 L
.27921 .08892 L
.27924 .08892 L
.27926 .08892 L
.27929 .08892 L
.27931 .08892 L
.27933 .08892 L
.27935 .08892 L
.27939 .08892 L
.27941 .08892 L
.27944 .08892 L
.2795 .08892 L
.2796 .08892 L
.27973 .08892 L
.27986 .08892 L
.27999 .08892 L
.28005 .08892 L
.2801 .08892 L
.28021 .08892 L
.28027 .08892 L
.2803 .08892 L
.28033 .08892 L
.28036 .08892 L
.28039 .08892 L
.2804 .08892 L
.28042 .08892 L
Mistroke
.28045 .08892 L
.28046 .08892 L
.28048 .08892 L
.28052 .08892 L
.28058 .08892 L
.28064 .08892 L
.2807 .08892 L
.28077 .08892 L
.28084 .08892 L
.28095 .08892 L
.28108 .08892 L
.28133 .08892 L
.28155 .08892 L
.28206 .08892 L
.28302 .08892 L
.28346 .08891 L
.28395 .08891 L
.28418 .08891 L
.28443 .08891 L
.28456 .08891 L
.28469 .08891 L
.28481 .08891 L
.28493 .08891 L
.28505 .08891 L
.28511 .08891 L
.28517 .08891 L
.28523 .08891 L
.28528 .08891 L
.28534 .08891 L
.28539 .08891 L
.28542 .08891 L
.28545 .08891 L
.28548 .08891 L
.28551 .08891 L
.28554 .08891 L
.28556 .08891 L
.28557 .08891 L
.2856 .08891 L
.28562 .08891 L
.28563 .08891 L
.28565 .08891 L
.28567 .08891 L
.2857 .08891 L
.28576 .08891 L
.28589 .08891 L
.28615 .08891 L
.28628 .08891 L
.28634 .08891 L
.2864 .08891 L
.28646 .08891 L
Mistroke
.28651 .08891 L
.28654 .08891 L
.28657 .08891 L
.2866 .08891 L
.28663 .08891 L
.28666 .08891 L
.28669 .08891 L
.28671 .08891 L
.28674 .08891 L
.28677 .08891 L
.28679 .08891 L
.28681 .08891 L
.28684 .08891 L
.28687 .08891 L
.28693 .08891 L
.28698 .08891 L
.28704 .08891 L
.2871 .08891 L
.28721 .08891 L
.28732 .08891 L
.28744 .08891 L
.28757 .08891 L
.28781 .08891 L
.28828 .08891 L
.28872 .08891 L
.28966 .0889 L
.29013 .0889 L
.29038 .0889 L
.29065 .0889 L
.29088 .0889 L
.29101 .0889 L
.29115 .0889 L
.29127 .0889 L
.29138 .0889 L
.29149 .0889 L
.29155 .0889 L
.29161 .0889 L
.29164 .0889 L
.29167 .0889 L
.29169 .0889 L
.29173 .0889 L
.29175 .0889 L
.29178 .0889 L
.29181 .0889 L
.29183 .0889 L
.29187 .0889 L
.29188 .0889 L
.2919 .0889 L
.29196 .0889 L
.29208 .0889 L
Mistroke
.29252 .0889 L
.29264 .0889 L
.29271 .0889 L
.29277 .0889 L
.29283 .0889 L
.29289 .0889 L
.29292 .0889 L
.29295 .0889 L
.29299 .0889 L
.29301 .0889 L
.29304 .0889 L
.29307 .0889 L
.2931 .0889 L
.29312 .0889 L
.29315 .0889 L
.29319 .0889 L
.29324 .0889 L
.2933 .0889 L
.29336 .0889 L
.29346 .0889 L
.29358 .0889 L
.29369 .0889 L
.29394 .0889 L
.29416 .0889 L
.29438 .0889 L
.2953 .0889 L
.29577 .08889 L
.29629 .08889 L
.29652 .08889 L
.29678 .08889 L
.29701 .08889 L
.29723 .08889 L
.29735 .08889 L
.29748 .08889 L
.29755 .08889 L
.29762 .08889 L
.29768 .08889 L
.29774 .08889 L
.2978 .08889 L
.29786 .08889 L
.29789 .08889 L
.29792 .08889 L
.29795 .08889 L
.29797 .08889 L
.29799 .08889 L
.29801 .08889 L
.29802 .08889 L
.29804 .08889 L
.29806 .08889 L
.29808 .08889 L
Mistroke
.29811 .08889 L
.29812 .08889 L
.29814 .08889 L
.29817 .08889 L
.29823 .08889 L
.29874 .08889 L
.29886 .08889 L
.29892 .08889 L
.29898 .08889 L
.29904 .08889 L
.29909 .08889 L
.29914 .08889 L
.2992 .08889 L
.29926 .08889 L
.29928 .08889 L
.29929 .08889 L
.29932 .08889 L
.29935 .08889 L
.29938 .08889 L
.2994 .08889 L
.29943 .08889 L
.29947 .08889 L
.2995 .08889 L
.29957 .08889 L
.29963 .08889 L
.29969 .08889 L
.2998 .08889 L
.29991 .08889 L
.30014 .08889 L
.30026 .08889 L
.30038 .08889 L
.3006 .08889 L
.3011 .08889 L
.30201 .08889 L
.30252 .08888 L
.30298 .08888 L
.30321 .08888 L
.30333 .08888 L
.30346 .08888 L
.30358 .08888 L
.3037 .08888 L
.30381 .08888 L
.30391 .08888 L
.30397 .08888 L
.30403 .08888 L
.30409 .08888 L
.30415 .08888 L
.30418 .08888 L
.3042 .08888 L
.30422 .08888 L
Mistroke
.30423 .08888 L
.30425 .08888 L
.30428 .08888 L
.30431 .08888 L
.30434 .08888 L
.30437 .08888 L
.3044 .08888 L
.30445 .08888 L
.3045 .08888 L
.30461 .08888 L
.30484 .08888 L
.3051 .08888 L
.30522 .08888 L
.30533 .08888 L
.30544 .08888 L
.30549 .08888 L
.30552 .08888 L
.30555 .08888 L
.30558 .08888 L
.30561 .08888 L
.30563 .08888 L
.30566 .08888 L
.30569 .08888 L
.30571 .08888 L
.30572 .08888 L
.30575 .08888 L
.30578 .08888 L
.30581 .08888 L
.30584 .08888 L
.30589 .08888 L
.30596 .08888 L
.30602 .08888 L
.30614 .08888 L
.30627 .08888 L
.30648 .08888 L
.30671 .08888 L
.30719 .08888 L
.30769 .08888 L
.3086 .08888 L
.30911 .08888 L
.30935 .08888 L
.30957 .08888 L
.3098 .08888 L
.30992 .08888 L
.31005 .08888 L
.31011 .08888 L
.31017 .08888 L
.31023 .08888 L
.31026 .08888 L
.31029 .08888 L
Mistroke
.31031 .08888 L
.31034 .08888 L
.31037 .08888 L
.3104 .08888 L
.31042 .08888 L
.31045 .08888 L
.31048 .08888 L
.3105 .08888 L
.31053 .08888 L
.31056 .08888 L
.31061 .08888 L
.31064 .08888 L
.31067 .08888 L
.31073 .08888 L
.31084 .08888 L
.31095 .08888 L
.31145 .08888 L
.31169 .08888 L
.31176 .08888 L
.3118 .08888 L
.31183 .08888 L
.31186 .08888 L
.31189 .08888 L
.31191 .08888 L
.31192 .08888 L
.31194 .08888 L
.31196 .08888 L
.31197 .08888 L
.31199 .08888 L
.31202 .08888 L
.31205 .08888 L
.31208 .08888 L
.31211 .08888 L
.31214 .08888 L
.31218 .08888 L
.31221 .08888 L
.31227 .08888 L
.31232 .08888 L
.31244 .08888 L
.31256 .08888 L
.31268 .08888 L
.3129 .08888 L
.31314 .08887 L
.3134 .08887 L
.31437 .08887 L
.31481 .08887 L
.3153 .08887 L
.31556 .08887 L
.31581 .08887 L
.31604 .08887 L
Mistroke
.31617 .08887 L
.31623 .08887 L
.31629 .08887 L
.31635 .08887 L
.31641 .08887 L
.31647 .08887 L
.3165 .08887 L
.31653 .08887 L
.31656 .08887 L
.31659 .08887 L
.31662 .08887 L
.31665 .08887 L
.31667 .08887 L
.3167 .08887 L
.31672 .08887 L
.31675 .08887 L
.31678 .08887 L
.31681 .08887 L
.31688 .08887 L
.31701 .08887 L
.31713 .08887 L
.31725 .08887 L
.31773 .08887 L
.31786 .08887 L
.318 .08887 L
.31806 .08887 L
.31812 .08887 L
.31815 .08887 L
.31819 .08887 L
.31822 .08887 L
.31825 .08887 L
.31828 .08887 L
.31831 .08887 L
.31834 .08887 L
.31836 .08887 L
.31837 .08887 L
.3184 .08887 L
.31843 .08887 L
.31846 .08887 L
.31848 .08887 L
.31855 .08887 L
.31861 .08887 L
.31868 .08887 L
.31874 .08887 L
.31886 .08887 L
.31898 .08887 L
.31921 .08887 L
.31944 .08887 L
.31966 .08887 L
.32015 .08887 L
Mistroke
.32108 .08887 L
.32156 .08887 L
.32181 .08887 L
.32207 .08887 L
.32221 .08886 L
.32233 .08886 L
.32244 .08886 L
.3225 .08886 L
.32257 .08886 L
.32262 .08886 L
.32268 .08886 L
.32272 .08886 L
.32275 .08886 L
.32278 .08886 L
.32281 .08886 L
.32283 .08886 L
.32286 .08886 L
.32289 .08886 L
.32292 .08886 L
.32295 .08886 L
.32297 .08886 L
.323 .08886 L
.32303 .08886 L
.32314 .08886 L
.32326 .08886 L
.32338 .08886 L
.32348 .08886 L
.32398 .08887 L
.3242 .08887 L
.32432 .08887 L
.32438 .08887 L
.32444 .08887 L
.3245 .08887 L
.32456 .08887 L
.32459 .08887 L
.32461 .08887 L
.32463 .08887 L
.32465 .08887 L
.32466 .08887 L
.32468 .08887 L
.3247 .08887 L
.32473 .08887 L
.32476 .08887 L
.32478 .08887 L
.32481 .08887 L
.32488 .08887 L
.32494 .08887 L
.32506 .08887 L
.32512 .08887 L
.32519 .08887 L
Mistroke
.32543 .08886 L
.32564 .08886 L
.32587 .08886 L
.32678 .08886 L
.32728 .08886 L
.32774 .08886 L
.32798 .08886 L
.3282 .08886 L
.32842 .08886 L
.32855 .08886 L
.32867 .08886 L
.32874 .08886 L
.3288 .08886 L
.32886 .08886 L
.32892 .08886 L
.32895 .08886 L
.32899 .08886 L
.32902 .08886 L
.32905 .08886 L
.32906 .08886 L
.32908 .08886 L
.3291 .08886 L
.32911 .08886 L
.32913 .08886 L
.32915 .08886 L
.32917 .08886 L
.32919 .08886 L
.32921 .08886 L
.32924 .08886 L
.3293 .08886 L
.32936 .08886 L
.32942 .08886 L
.32967 .08886 L
.33017 .08886 L
.33039 .08886 L
.3305 .08886 L
.33063 .08886 L
.33069 .08886 L
.33075 .08886 L
.33081 .08886 L
.33086 .08886 L
.33089 .08886 L
.33091 .08886 L
.33094 .08886 L
.33096 .08886 L
.33099 .08886 L
.33102 .08886 L
.33105 .08886 L
.33108 .08886 L
.33111 .08886 L
Mistroke
.33113 .08886 L
.33119 .08886 L
.33125 .08886 L
.3313 .08886 L
.33142 .08886 L
.33155 .08886 L
.33178 .08886 L
.33203 .08886 L
.33253 .08886 L
.3335 .08886 L
.33394 .08886 L
.33419 .08886 L
.33442 .08886 L
.33466 .08886 L
.33479 .08886 L
.33491 .08886 L
.33503 .08886 L
.3351 .08886 L
.33513 .08886 L
.33517 .08886 L
.3352 .08886 L
.33522 .08886 L
.33525 .08886 L
.33527 .08886 L
.33529 .08886 L
.33532 .08886 L
.33535 .08886 L
.33536 .08886 L
.33538 .08886 L
.3354 .08886 L
.33541 .08886 L
.33544 .08886 L
.33547 .08886 L
.33552 .08886 L
.33559 .08886 L
.33565 .08886 L
.3359 .08886 L
.33612 .08886 L
.33634 .08886 L
.33655 .08886 L
.33678 .08886 L
.33691 .08886 L
.33696 .08886 L
.33703 .08886 L
.33714 .08886 L
.33717 .08886 L
.3372 .08886 L
.33723 .08886 L
.33726 .08886 L
.33729 .08886 L
Mistroke
.33732 .08886 L
.33735 .08886 L
.33738 .08886 L
.33741 .08886 L
.33744 .08886 L
.33751 .08886 L
.33757 .08886 L
.33763 .08886 L
.33774 .08886 L
.33786 .08886 L
.33798 .08886 L
.33824 .08886 L
.3385 .08886 L
.33874 .08886 L
.33918 .08886 L
.34011 .08886 L
.34059 .08885 L
.34083 .08885 L
.34097 .08885 L
.3411 .08885 L
.34122 .08885 L
.34128 .08885 L
.34134 .08885 L
.3414 .08885 L
.34146 .08885 L
.34152 .08885 L
.34157 .08885 L
.3416 .08885 L
.34163 .08885 L
.34165 .08885 L
.34166 .08885 L
.34169 .08885 L
.34173 .08885 L
.34176 .08885 L
.34178 .08885 L
.34181 .08885 L
.34184 .08885 L
.34188 .08885 L
.34191 .08885 L
.34195 .08885 L
.34201 .08885 L
.34207 .08885 L
.34232 .08885 L
.34258 .08885 L
.34281 .08885 L
.34306 .08885 L
.34318 .08885 L
.34331 .08885 L
.34337 .08885 L
.34343 .08885 L
Mistroke
.34349 .08885 L
.34354 .08885 L
.34357 .08885 L
.3436 .08885 L
.34362 .08885 L
.34363 .08885 L
.34366 .08885 L
.34369 .08885 L
.34372 .08885 L
.34375 .08885 L
.34378 .08885 L
.3438 .08885 L
.34381 .08885 L
.34385 .08885 L
.34391 .08885 L
.34398 .08885 L
.34404 .08885 L
.34417 .08885 L
.3443 .08885 L
.34454 .08885 L
.34477 .08885 L
.34499 .08885 L
.34594 .08885 L
.34641 .08885 L
.34685 .08885 L
.34707 .08885 L
.34732 .08885 L
.34745 .08885 L
.34758 .08885 L
.34769 .08885 L
.34776 .08885 L
.34782 .08885 L
.34788 .08885 L
.34794 .08885 L
.34799 .08885 L
.34802 .08885 L
.34805 .08885 L
.34808 .08885 L
.34811 .08885 L
.34814 .08885 L
.34816 .08885 L
.34819 .08885 L
.34821 .08885 L
.34822 .08885 L
.34826 .08885 L
.34829 .08885 L
.34835 .08885 L
.34841 .08885 L
.34852 .08885 L
.34873 .08885 L
Mistroke
.34919 .08885 L
.34931 .08885 L
.34944 .08885 L
.34958 .08885 L
.34971 .08885 L
.34977 .08885 L
.34983 .08885 L
.34988 .08885 L
.34991 .08885 L
.34994 .08885 L
.34996 .08885 L
.34997 .08885 L
.34999 .08885 L
.35001 .08885 L
.35002 .08885 L
.35004 .08885 L
.35007 .08885 L
.3501 .08885 L
.35012 .08885 L
.35013 .08885 L
.35016 .08885 L
.35019 .08885 L
.35022 .08885 L
.35025 .08885 L
.35032 .08885 L
.35037 .08885 L
.35043 .08885 L
.35054 .08885 L
.35065 .08885 L
.3509 .08885 L
.35112 .08885 L
.35162 .08885 L
.35258 .08885 L
.35302 .08885 L
.35327 .08885 L
.3535 .08885 L
.35373 .08885 L
.35398 .08885 L
.3541 .08885 L
.35417 .08885 L
.35424 .08885 L
.3543 .08885 L
.35435 .08885 L
.35441 .08885 L
.35445 .08885 L
.35448 .08885 L
.35451 .08885 L
.35454 .08885 L
.35457 .08885 L
.35459 .08885 L
Mistroke
.35462 .08885 L
.35464 .08885 L
.35465 .08885 L
.35468 .08885 L
.35471 .08885 L
.35473 .08885 L
.35475 .08885 L
.35478 .08885 L
.35481 .08885 L
.35484 .08885 L
.3549 .08885 L
.35496 .08885 L
.3554 .08885 L
.35567 .08885 L
.35591 .08885 L
.35602 .08885 L
.35614 .08885 L
.3562 .08885 L
.35626 .08885 L
.35629 .08885 L
.35632 .08885 L
.35635 .08885 L
.35638 .08885 L
.35641 .08885 L
.35643 .08885 L
.35647 .08885 L
.3565 .08885 L
.35652 .08885 L
.35655 .08885 L
.35661 .08885 L
.35664 .08885 L
.35666 .08885 L
.35673 .08885 L
.35686 .08885 L
.35697 .08885 L
.35708 .08885 L
.35731 .08885 L
.35755 .08885 L
.35777 .08885 L
.35827 .08885 L
.35921 .08885 L
.35969 .08885 L
.35989 .08885 L
.36012 .08885 L
.36035 .08885 L
.36047 .08885 L
.36058 .08885 L
.36065 .08885 L
.36071 .08885 L
.36077 .08885 L
Mistroke
.36083 .08885 L
.36086 .08885 L
.36089 .08885 L
.36092 .08885 L
.36095 .08885 L
.36097 .08885 L
.36098 .08885 L
.36102 .08885 L
.36103 .08885 L
.36105 .08885 L
.36107 .08885 L
.36109 .08885 L
.36112 .08885 L
.36115 .08885 L
.36121 .08885 L
.36133 .08885 L
.36146 .08885 L
.3616 .08885 L
.36185 .08885 L
.36208 .08885 L
.36221 .08885 L
.36233 .08885 L
.36239 .08885 L
.36246 .08885 L
.36253 .08885 L
.3626 .08885 L
.36263 .08885 L
.36265 .08885 L
.36268 .08885 L
.3627 .08885 L
.36272 .08885 L
.36273 .08885 L
.36275 .08885 L
.36277 .08885 L
.36278 .08885 L
.36281 .08885 L
.36285 .08885 L
.36287 .08885 L
.3629 .08885 L
.36296 .08885 L
.36302 .08885 L
.36308 .08885 L
.36313 .08885 L
.36319 .08885 L
.36332 .08885 L
.36343 .08885 L
.36354 .08885 L
.36378 .08885 L
.36404 .08885 L
.36502 .08885 L
Mistroke
.36551 .08885 L
.36597 .08885 L
.36641 .08885 L
.36666 .08885 L
.36689 .08885 L
.367 .08885 L
.36713 .08885 L
.36723 .08885 L
.36735 .08885 L
.36741 .08885 L
.36747 .08885 L
.3675 .08885 L
.36754 .08885 L
.36757 .08885 L
.36761 .08885 L
.36764 .08885 L
.36767 .08885 L
.36769 .08885 L
.36772 .08885 L
.36775 .08885 L
.36777 .08885 L
.36779 .08885 L
.36782 .08885 L
.36785 .08885 L
.36788 .08885 L
.36789 .08885 L
.36791 .08885 L
.36794 .08885 L
.36797 .08885 L
.368 .08885 L
.36803 .08885 L
.3681 .08885 L
.36815 .08885 L
.36821 .08885 L
.36834 .08885 L
.36845 .08885 L
.36857 .08885 L
.36868 .08885 L
.36878 .08885 L
.3689 .08885 L
.36896 .08885 L
.36899 .08885 L
.36902 .08885 L
.36905 .08885 L
.36907 .08885 L
.3691 .08885 L
.36913 .08885 L
.36916 .08885 L
.36919 .08885 L
.36922 .08885 L
Mistroke
.36924 .08885 L
.36927 .08885 L
.36931 .08885 L
.36937 .08885 L
.3694 .08885 L
.36943 .08885 L
.3695 .08885 L
.36962 .08885 L
.36974 .08885 L
.36987 .08885 L
.36999 .08885 L
.37025 .08885 L
.37074 .08885 L
.37168 .08885 L
.37259 .08885 L
.37306 .08885 L
.37332 .08885 L
.37343 .08885 L
.37356 .08885 L
.37368 .08885 L
.37379 .08885 L
.37391 .08885 L
.37401 .08885 L
.37414 .08885 L
.37425 .08885 L
.37432 .08885 L
.37438 .08885 L
.37441 .08885 L
.37444 .08885 L
.37446 .08885 L
.37448 .08885 L
.37449 .08885 L
.37451 .08885 L
.37454 .08885 L
.37457 .08885 L
.3746 .08885 L
.37463 .08885 L
.37468 .08885 L
.37474 .08885 L
.3748 .08885 L
.37487 .08885 L
.37492 .08885 L
.37498 .08885 L
.37502 .08885 L
.37505 .08885 L
.37511 .08885 L
.37525 .08885 L
.3753 .08885 L
.37536 .08885 L
.37538 .08885 L
Mistroke
.3754 .08885 L
.37543 .08885 L
.37546 .08885 L
.37547 .08885 L
.37549 .08885 L
.37552 .08885 L
.37554 .08885 L
.37555 .08885 L
.37561 .08885 L
.37568 .08885 L
.37574 .08885 L
.3758 .08885 L
.37586 .08885 L
.37598 .08885 L
.37609 .08885 L
.37621 .08885 L
.37643 .08884 L
.37666 .08884 L
.37691 .08884 L
.37741 .08884 L
.37838 .08884 L
.37882 .08884 L
.37931 .08884 L
.37954 .08884 L
.37979 .08884 L
.37993 .08884 L
.38005 .08884 L
.38017 .08884 L
.3803 .08884 L
.38041 .08884 L
.38054 .08884 L
.38059 .08884 L
.38065 .08884 L
.38071 .08884 L
.38076 .08884 L
.38082 .08884 L
.38089 .08884 L
.38102 .08884 L
.38113 .08884 L
.38117 .08884 L
.3812 .08884 L
.38123 .08884 L
.38126 .08884 L
.38129 .08884 L
.38131 .08884 L
.38135 .08884 L
.38137 .08884 L
.3814 .08884 L
.38143 .08884 L
.38149 .08884 L
Mistroke
.38154 .08884 L
.38158 .08884 L
.38161 .08884 L
.38167 .08884 L
.38171 .08884 L
.38174 .08884 L
.38177 .08884 L
.3818 .08884 L
.38182 .08884 L
.38183 .08884 L
.38186 .08884 L
.38189 .08884 L
.38192 .08884 L
.38198 .08884 L
.38204 .08884 L
.38211 .08884 L
.38218 .08884 L
.38224 .08884 L
.38236 .08884 L
.38249 .08884 L
.38273 .08884 L
.38296 .08884 L
.38318 .08884 L
.38363 .08884 L
.38412 .08884 L
.38509 .08884 L
.38553 .08884 L
.38578 .08884 L
.38602 .08884 L
.38627 .08884 L
.3865 .08884 L
.38674 .08884 L
.38688 .08884 L
.38694 .08884 L
.387 .08884 L
.38711 .08884 L
.38724 .08884 L
.38748 .08884 L
.38759 .08884 L
.3877 .08884 L
.38775 .08884 L
.38782 .08884 L
.38787 .08884 L
.38793 .08884 L
.38799 .08884 L
.38806 .08884 L
.38811 .08884 L
.38818 .08884 L
.3884 .08884 L
.38864 .08884 L
Mistroke
.38878 .08884 L
.3889 .08884 L
.38915 .08884 L
.38937 .08884 L
.38988 .08884 L
.3908 .08884 L
.39178 .08884 L
.39227 .08884 L
.39251 .08884 L
.39272 .08884 L
.39293 .08884 L
.39316 .08884 L
.39339 .08884 L
.39352 .08884 L
.39363 .08884 L
.39412 .08884 L
.39457 .08884 L
.39503 .08884 L
.39529 .08884 L
.39553 .08884 L
.39577 .08884 L
.39598 .08884 L
.39648 .08884 L
.39741 .08884 L
.39841 .08884 L
.3989 .08884 L
.39912 .08884 L
.39936 .08884 L
.39958 .08884 L
.39981 .08884 L
.40005 .08884 L
.40028 .08884 L
.40075 .08884 L
.40127 .08884 L
.40151 .08884 L
.40176 .08884 L
.402 .08884 L
.40222 .08884 L
.40268 .08884 L
.40318 .08884 L
.40416 .08884 L
.40465 .08884 L
.40511 .08884 L
.40557 .08884 L
.40602 .08884 L
.40625 .08884 L
.4065 .08884 L
.40695 .08884 L
.40746 .08884 L
.40792 .08884 L
Mistroke
.40816 .08884 L
.40841 .08884 L
.40886 .08884 L
.40934 .08884 L
.40985 .08884 L
.41076 .08884 L
.41127 .08884 L
.41173 .08884 L
.41221 .08884 L
.41267 .08884 L
.4129 .08884 L
.41315 .08884 L
.41359 .08884 L
.4145 .08884 L
.415 .08884 L
.41546 .08884 L
.41592 .08884 L
.41639 .08884 L
.41731 .08884 L
.41828 .08884 L
.41922 .08884 L
.42022 .08884 L
.42118 .08884 L
.4221 .08884 L
.42309 .08884 L
.42403 .08884 L
.42494 .08884 L
.42591 .08884 L
.42685 .08884 L
.42784 .08884 L
.42879 .08884 L
.42971 .08884 L
.43069 .08884 L
.43163 .08884 L
.43263 .08884 L
.4336 .08884 L
.43452 .08884 L
.43551 .08884 L
.43646 .08884 L
.43737 .08884 L
.43835 .08884 L
.43928 .08884 L
.44028 .08884 L
.44124 .08884 L
.44216 .08884 L
.44314 .08884 L
.44409 .08884 L
.44499 .08884 L
.44596 .08884 L
.44689 .08884 L
Mistroke
.44788 .08884 L
.44884 .08884 L
.44975 .08884 L
.45073 .08884 L
.45167 .08884 L
.45267 .08884 L
.45363 .08884 L
.45455 .08884 L
.45554 .08884 L
.45649 .08884 L
.4574 .08884 L
.45837 .08884 L
.4593 .08884 L
.4603 .08884 L
.46125 .08884 L
.46217 .08884 L
.46315 .08884 L
.46409 .08884 L
.465 .08884 L
.46597 .08884 L
.4669 .08884 L
.46788 .08884 L
.46883 .08884 L
.46975 .08884 L
.47072 .08884 L
.47166 .08884 L
.47266 .08884 L
.47362 .08884 L
.47454 .08884 L
.47552 .08884 L
.47647 .08884 L
.47738 .08884 L
.47835 .08884 L
.47928 .08884 L
.48027 .08884 L
.48123 .08884 L
.48214 .08884 L
.48312 .08884 L
.48406 .08884 L
.48506 .08884 L
.48602 .08884 L
.48695 .08884 L
.48794 .08884 L
.48889 .08884 L
.4898 .08884 L
.49077 .08884 L
.49171 .08884 L
.4927 .08884 L
.49366 .08884 L
.49458 .08884 L
Mistroke
.49556 .08884 L
.4965 .08884 L
.49741 .08884 L
.49838 .08884 L
.49931 .08884 L
.5003 .08884 L
.50125 .08884 L
.50217 .08884 L
.50314 .08884 L
.50408 .08884 L
.50508 .08884 L
.50604 .08884 L
.50696 .08884 L
.50795 .08884 L
.5089 .08884 L
.50981 .08884 L
.51078 .08884 L
.51171 .08884 L
.5127 .08884 L
.51366 .08884 L
.51458 .08884 L
.51556 .08884 L
.5165 .08884 L
.5175 .08884 L
.51846 .08884 L
.51939 .08884 L
.52038 .08884 L
.52133 .08884 L
.52224 .08884 L
.52322 .08884 L
.52415 .08884 L
.52515 .08884 L
.52611 .08884 L
.52703 .08884 L
.52801 .08884 L
.52896 .08884 L
.52987 .08884 L
.53083 .08884 L
.53176 .08884 L
.53276 .08884 L
.53371 .08884 L
.53463 .08884 L
.5356 .08884 L
.53654 .08884 L
.53754 .08884 L
.5385 .08884 L
.53943 .08884 L
.54042 .08884 L
.54136 .08884 L
.54228 .08884 L
Mistroke
.54325 .08884 L
.54418 .08884 L
.54518 .08884 L
.54613 .08884 L
.54705 .08884 L
.54803 .08884 L
.54898 .08884 L
.54988 .08884 L
.55085 .08884 L
.55178 .08884 L
.55277 .08884 L
.55372 .08884 L
.55463 .08884 L
.55561 .08884 L
.55655 .08884 L
.55754 .08884 L
.5585 .08884 L
.55943 .08884 L
.56041 .08884 L
.56136 .08884 L
.56227 .08884 L
.56324 .08884 L
.56417 .08884 L
.56516 .08884 L
.56612 .08884 L
.56703 .08884 L
.56755 .08884 L
.56801 .08884 L
.5685 .08884 L
.56895 .08884 L
.56942 .08884 L
.56966 .08884 L
.56992 .08884 L
.57014 .08884 L
.57027 .08884 L
.57039 .08884 L
.5705 .08884 L
.57056 .08884 L
.57062 .08884 L
.57067 .08884 L
.57073 .08884 L
.57078 .08884 L
.57083 .08884 L
.57086 .08884 L
.57089 .08884 L
.57092 .08884 L
.57094 .08884 L
.57097 .08884 L
.57099 .08884 L
.57101 .08884 L
Mistroke
.57104 .08884 L
.57107 .08884 L
.5711 .08884 L
.57113 .08884 L
.57119 .08884 L
.57125 .08884 L
.57132 .08884 L
.57142 .08884 L
.57154 .08884 L
.57176 .08884 L
.57223 .08884 L
.57274 .08884 L
.57365 .08884 L
.57461 .08884 L
.57554 .08884 L
.57601 .08884 L
.57653 .08884 L
.57702 .08884 L
.57724 .08884 L
.57748 .08884 L
.57761 .08884 L
.57773 .08884 L
.57784 .08884 L
.5779 .08884 L
.57797 .08884 L
.57803 .08884 L
.57808 .08884 L
.57811 .08884 L
.57813 .08884 L
.57816 .08884 L
.57818 .08884 L
.57822 .08884 L
.57824 .08884 L
.57827 .08884 L
.57829 .08884 L
.5783 .08884 L
.57833 .08884 L
.57836 .08884 L
.57839 .08884 L
.57841 .08884 L
.57848 .08884 L
.57854 .08884 L
.57867 .08884 L
.57878 .08884 L
.5789 .08884 L
.57912 .08884 L
.57935 .08884 L
.57981 .08884 L
.58032 .08884 L
.5808 .08884 L
Mistroke
.5813 .08884 L
.58222 .08884 L
.5832 .08884 L
.58413 .08884 L
.58513 .08884 L
.58609 .08884 L
.58702 .08884 L
.588 .08884 L
.58895 .08884 L
.58986 .08884 L
.59083 .08884 L
.59176 .08884 L
.59275 .08884 L
.59371 .08884 L
.59463 .08884 L
.59561 .08884 L
.59655 .08884 L
.59755 .08884 L
.59851 .08884 L
.59944 .08884 L
.60043 .08884 L
.60138 .08884 L
.60229 .08884 L
.60326 .08884 L
.6042 .08884 L
.60471 .08884 L
.60519 .08884 L
.60567 .08884 L
.60612 .08884 L
.60635 .08884 L
.60657 .08884 L
.60681 .08884 L
.60694 .08884 L
.60706 .08884 L
.60718 .08884 L
.60724 .08884 L
.6073 .08884 L
.60735 .08884 L
.60741 .08884 L
.60744 .08884 L
.60747 .08884 L
.60749 .08884 L
.60752 .08884 L
.60755 .08884 L
.60758 .08884 L
.60761 .08884 L
.60763 .08884 L
.60764 .08884 L
.60767 .08884 L
.6077 .08884 L
Mistroke
.60773 .08884 L
.60776 .08884 L
.60782 .08884 L
.60788 .08884 L
.60802 .08884 L
.60813 .08884 L
.60825 .08884 L
.60847 .08884 L
.60897 .08884 L
.60996 .08884 L
.61046 .08884 L
.61092 .08884 L
.61137 .08884 L
.6116 .08884 L
.61173 .08884 L
.61185 .08884 L
.61196 .08884 L
.61203 .08884 L
.61209 .08884 L
.61215 .08884 L
.61221 .08884 L
.61223 .08884 L
.61226 .08884 L
.61229 .08884 L
.61231 .08884 L
.61234 .08884 L
.61238 .08884 L
.6124 .08884 L
.61243 .08884 L
.61246 .08884 L
.6125 .08884 L
.61256 .08884 L
.61262 .08884 L
.61269 .08884 L
.61282 .08884 L
.61293 .08884 L
.61304 .08884 L
.61329 .08884 L
.6135 .08884 L
.61372 .08884 L
.6142 .08884 L
.61464 .08884 L
.61513 .08884 L
.61558 .08884 L
.61654 .08884 L
.61747 .08884 L
.61845 .08884 L
.6194 .08884 L
.62031 .08884 L
.62128 .08884 L
Mistroke
.62221 .08884 L
.6232 .08884 L
.62416 .08884 L
.62508 .08884 L
.62606 .08884 L
.627 .08884 L
.62791 .08884 L
.62887 .08884 L
.6298 .08884 L
.63079 .08884 L
.63174 .08884 L
.63265 .08884 L
.63363 .08884 L
.63456 .08884 L
.63556 .08884 L
.63652 .08884 L
.63744 .08884 L
.63842 .08884 L
.63937 .08884 L
.64028 .08884 L
.64124 .08884 L
.64218 .08884 L
.64317 .08884 L
.64412 .08884 L
.64504 .08884 L
.64602 .08884 L
.64696 .08884 L
.64795 .08884 L
.64892 .08884 L
.64984 .08884 L
.65083 .08884 L
.65178 .08884 L
.65269 .08884 L
.65366 .08884 L
.6546 .08884 L
.65559 .08884 L
.65655 .08884 L
.65747 .08884 L
.65845 .08884 L
.65939 .08884 L
.6603 .08884 L
.66126 .08884 L
.66219 .08884 L
.66318 .08884 L
.66413 .08884 L
.66505 .08884 L
.66602 .08884 L
.66696 .08884 L
.66796 .08884 L
.66892 .08884 L
Mistroke
.66984 .08884 L
.67083 .08884 L
.67177 .08884 L
.67268 .08884 L
.67365 .08884 L
.67459 .08884 L
.67558 .08884 L
.67653 .08884 L
.67745 .08884 L
.67843 .08884 L
.67937 .08884 L
.68037 .08884 L
.68134 .08884 L
.68226 .08884 L
.68325 .08884 L
.6842 .08884 L
.68511 .08884 L
.68609 .08884 L
.68702 .08884 L
.68802 .08884 L
.68898 .08884 L
.6899 .08884 L
.69088 .08884 L
.69182 .08884 L
.69273 .08884 L
.6937 .08884 L
.69463 .08884 L
.69562 .08884 L
.69657 .08884 L
.69749 .08884 L
.69847 .08884 L
.6994 .08884 L
.7004 .08884 L
.70136 .08884 L
.70229 .08884 L
.70327 .08884 L
.70422 .08884 L
.70513 .08884 L
.7061 .08884 L
.70704 .08884 L
.70803 .08884 L
.70899 .08884 L
.70991 .08884 L
.71089 .08884 L
.71183 .08884 L
.71274 .08884 L
.7137 .08884 L
.71463 .08884 L
.71562 .08884 L
.71657 .08884 L
Mistroke
.71748 .08884 L
.71846 .08884 L
.7194 .08884 L
.72039 .08884 L
.72135 .08884 L
.72227 .08884 L
.72326 .08884 L
.7242 .08884 L
.72511 .08884 L
.72608 .08884 L
.72701 .08884 L
.728 .08884 L
.72896 .08884 L
.72988 .08884 L
.73085 .08884 L
.73179 .08884 L
.73279 .08884 L
.73376 .08884 L
.73468 .08884 L
.73567 .08884 L
.73662 .08884 L
.73753 .08884 L
.7385 .08884 L
.73944 .08884 L
.74043 .08884 L
.74139 .08884 L
.74231 .08884 L
.74329 .08884 L
.74424 .08884 L
.74514 .08884 L
.74611 .08884 L
.74704 .08884 L
.74803 .08884 L
.74898 .08884 L
.7499 .08884 L
.75087 .08884 L
.75181 .08884 L
.75281 .08884 L
.75377 .08884 L
.75469 .08884 L
.75568 .08884 L
.75663 .08884 L
.75754 .08884 L
.75851 .08884 L
.75944 .08884 L
.76043 .08884 L
.76139 .08884 L
.76231 .08884 L
.76328 .08884 L
.76423 .08884 L
Mistroke
.76523 .08884 L
.76619 .08884 L
.76712 .08884 L
.76811 .08884 L
.76906 .08884 L
.76997 .08884 L
.77094 .08884 L
.77188 .08884 L
.77288 .08884 L
.77384 .08884 L
.77476 .08884 L
.77574 .08884 L
.77668 .08884 L
.77759 .08884 L
.77856 .08884 L
.77949 .08884 L
.78048 .08884 L
.78098 .08884 L
.78144 .08884 L
.78188 .08884 L
.78213 .08884 L
.78235 .08884 L
.78247 .08884 L
.78259 .08884 L
.7827 .08884 L
.78276 .08884 L
.78282 .08884 L
.78285 .08884 L
.78288 .08884 L
.78291 .08884 L
.78294 .08884 L
.78297 .08884 L
.78299 .08884 L
.78301 .08884 L
.78302 .08884 L
.78304 .08884 L
.78306 .08884 L
.78307 .08884 L
.7831 .08884 L
.78313 .08884 L
.78316 .08884 L
.78319 .08884 L
.78325 .08884 L
.78332 .08884 L
.78343 .08884 L
.78355 .08884 L
.7838 .08884 L
.78403 .08884 L
.78424 .08884 L
.78517 .08884 L
Mistroke
.78616 .08884 L
.78712 .08884 L
.78804 .08884 L
.78901 .08884 L
.78996 .08884 L
.79096 .08884 L
.79192 .08884 L
.79285 .08884 L
.79383 .08884 L
.79478 .08884 L
.7957 .08884 L
.79667 .08884 L
.7976 .08884 L
.7986 .08884 L
.79956 .08884 L
.80048 .08884 L
.80146 .08884 L
.8024 .08884 L
.80331 .08884 L
.80428 .08884 L
.80521 .08884 L
.8062 .08884 L
.80715 .08884 L
.80807 .08884 L
.80904 .08884 L
.80998 .08884 L
.81098 .08884 L
.81194 .08884 L
.81287 .08884 L
.81385 .08884 L
.8148 .08884 L
.81571 .08884 L
.81668 .08884 L
.81761 .08884 L
.81861 .08884 L
.81956 .08884 L
.82048 .08884 L
.82146 .08884 L
.8224 .08884 L
.82331 .08884 L
.82428 .08884 L
.8252 .08884 L
.82619 .08884 L
.82714 .08884 L
.82806 .08884 L
.82903 .08884 L
.82997 .08884 L
.83096 .08884 L
.83192 .08884 L
.83285 .08884 L
Mistroke
.83383 .08884 L
.83477 .08884 L
.83568 .08884 L
.83665 .08884 L
.83758 .08884 L
.83857 .08884 L
.83953 .08884 L
.84045 .08884 L
.84142 .08884 L
.84236 .08884 L
.84336 .08884 L
.84432 .08884 L
.84525 .08884 L
.84624 .08884 L
.84719 .08884 L
.8481 .08884 L
.84907 .08884 L
.85 .08884 L
.851 .08884 L
.85196 .08884 L
.85288 .08884 L
.85386 .08884 L
.8548 .08884 L
.85571 .08884 L
.85667 .08884 L
.8576 .08884 L
.85859 .08884 L
.85954 .08884 L
.86046 .08884 L
.86143 .08884 L
.86237 .08884 L
.86337 .08884 L
.86433 .08884 L
.86526 .08884 L
.86624 .08884 L
.86719 .08884 L
.8681 .08884 L
.86907 .08884 L
.87 .08884 L
.87099 .08884 L
.87195 .08884 L
.87287 .08884 L
.87384 .08884 L
.87478 .08884 L
.87579 .08884 L
.87675 .08884 L
.87768 .08884 L
.87866 .08884 L
.87961 .08884 L
.88053 .08884 L
Mistroke
.8815 .08884 L
.88244 .08884 L
.88343 .08884 L
.88439 .08884 L
.88531 .08884 L
.88629 .08884 L
.88724 .08884 L
.88815 .08884 L
.88911 .08884 L
.89005 .08884 L
.89104 .08884 L
.89199 .08884 L
.89291 .08884 L
.89388 .08884 L
.89482 .08884 L
.89582 .08884 L
.89678 .08884 L
.89771 .08884 L
.89869 .08884 L
.89964 .08884 L
.90055 .08884 L
.90152 .08884 L
.90246 .08884 L
.90345 .08884 L
.90441 .08884 L
.90533 .08884 L
.90631 .08884 L
.90725 .08884 L
.90816 .08884 L
.90912 .08884 L
.91005 .08884 L
.91104 .08884 L
.91199 .08884 L
.9129 .08884 L
.91388 .08884 L
.91482 .08884 L
.91581 .08884 L
.91677 .08884 L
.9177 .08884 L
.91868 .08884 L
.91962 .08884 L
.92053 .08884 L
.9215 .08884 L
.92244 .08884 L
.92343 .08884 L
.92438 .08884 L
.9253 .08884 L
.92628 .08884 L
.92722 .08884 L
.92822 .08884 L
Mistroke
.92918 .08884 L
.93011 .08884 L
.93109 .08884 L
.93204 .08884 L
.93296 .08884 L
.93393 .08884 L
.93486 .08884 L
.93586 .08884 L
.93682 .08884 L
.93774 .08884 L
.93872 .08884 L
.93966 .08884 L
.94057 .08884 L
.94154 .08884 L
.94247 .08884 L
.94346 .08884 L
.94441 .08884 L
.94532 .08884 L
.9463 .08884 L
.94724 .08884 L
.94824 .08884 L
.9492 .08884 L
.95012 .08884 L
.95111 .08884 L
.95205 .08884 L
.95296 .08884 L
.95393 .08884 L
.95487 .08884 L
.95586 .08884 L
.95682 .08884 L
.95774 .08884 L
.95871 .08884 L
.95966 .08884 L
.96066 .08884 L
.96162 .08884 L
.96255 .08884 L
.96354 .08884 L
.96449 .08884 L
.9654 .08884 L
.96638 .08884 L
.96731 .08884 L
.96831 .08884 L
.96927 .08884 L
.97019 .08884 L
.97117 .08884 L
.97212 .08884 L
.97303 .08884 L
.97399 .08884 L
.97492 .08884 L
.97592 .08884 L
Mistroke
.97619 .08884 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00190476 -0.454198 0.000382626 [
[.21429 .01158 -9 -9 ]
[.21429 .01158 9 0 ]
[.40476 .01158 -9 -9 ]
[.40476 .01158 9 0 ]
[.59524 .01158 -9 -9 ]
[.59524 .01158 9 0 ]
[.78571 .01158 -9 -9 ]
[.78571 .01158 9 0 ]
[.97619 .01158 -9 -9 ]
[.97619 .01158 9 0 ]
[1.025 .02408 0 -6.4375 ]
[1.025 .02408 28 6.4375 ]
[.01131 .11974 -24 -4.5 ]
[.01131 .11974 0 4.5 ]
[.01131 .2154 -24 -4.5 ]
[.01131 .2154 0 4.5 ]
[.01131 .31105 -24 -4.5 ]
[.01131 .31105 0 4.5 ]
[.01131 .40671 -24 -4.5 ]
[.01131 .40671 0 4.5 ]
[.01131 .50237 -24 -4.5 ]
[.01131 .50237 0 4.5 ]
[.01131 .59802 -24 -4.5 ]
[.01131 .59802 0 4.5 ]
[.02381 .64303 -5 0 ]
[.02381 .64303 5 12.875 ]
[.5 .63053 -92 0 ]
[.5 .63053 92 12.875 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .02408 m
.21429 .03033 L
s
[(100)] .21429 .01158 0 1 Mshowa
.40476 .02408 m
.40476 .03033 L
s
[(200)] .40476 .01158 0 1 Mshowa
.59524 .02408 m
.59524 .03033 L
s
[(300)] .59524 .01158 0 1 Mshowa
.78571 .02408 m
.78571 .03033 L
s
[(400)] .78571 .01158 0 1 Mshowa
.97619 .02408 m
.97619 .03033 L
s
[(500)] .97619 .01158 0 1 Mshowa
.125 Mabswid
.0619 .02408 m
.0619 .02783 L
s
.1 .02408 m
.1 .02783 L
s
.1381 .02408 m
.1381 .02783 L
s
.17619 .02408 m
.17619 .02783 L
s
.25238 .02408 m
.25238 .02783 L
s
.29048 .02408 m
.29048 .02783 L
s
.32857 .02408 m
.32857 .02783 L
s
.36667 .02408 m
.36667 .02783 L
s
.44286 .02408 m
.44286 .02783 L
s
.48095 .02408 m
.48095 .02783 L
s
.51905 .02408 m
.51905 .02783 L
s
.55714 .02408 m
.55714 .02783 L
s
.63333 .02408 m
.63333 .02783 L
s
.67143 .02408 m
.67143 .02783 L
s
.70952 .02408 m
.70952 .02783 L
s
.74762 .02408 m
.74762 .02783 L
s
.82381 .02408 m
.82381 .02783 L
s
.8619 .02408 m
.8619 .02783 L
s
.9 .02408 m
.9 .02783 L
s
.9381 .02408 m
.9381 .02783 L
s
.25 Mabswid
0 .02408 m
1 .02408 L
s
gsave
1.025 .02408 -61 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(time) show
1.000 setlinewidth
grestore
.02381 .11974 m
.03006 .11974 L
s
[(1500)] .01131 .11974 1 0 Mshowa
.02381 .2154 m
.03006 .2154 L
s
[(1750)] .01131 .2154 1 0 Mshowa
.02381 .31105 m
.03006 .31105 L
s
[(2000)] .01131 .31105 1 0 Mshowa
.02381 .40671 m
.03006 .40671 L
s
[(2250)] .01131 .40671 1 0 Mshowa
.02381 .50237 m
.03006 .50237 L
s
[(2500)] .01131 .50237 1 0 Mshowa
.02381 .59802 m
.03006 .59802 L
s
[(2750)] .01131 .59802 1 0 Mshowa
.125 Mabswid
.02381 .04322 m
.02756 .04322 L
s
.02381 .06235 m
.02756 .06235 L
s
.02381 .08148 m
.02756 .08148 L
s
.02381 .10061 m
.02756 .10061 L
s
.02381 .13887 m
.02756 .13887 L
s
.02381 .158 m
.02756 .158 L
s
.02381 .17714 m
.02756 .17714 L
s
.02381 .19627 m
.02756 .19627 L
s
.02381 .23453 m
.02756 .23453 L
s
.02381 .25366 m
.02756 .25366 L
s
.02381 .27279 m
.02756 .27279 L
s
.02381 .29192 m
.02756 .29192 L
s
.02381 .33019 m
.02756 .33019 L
s
.02381 .34932 m
.02756 .34932 L
s
.02381 .36845 m
.02756 .36845 L
s
.02381 .38758 m
.02756 .38758 L
s
.02381 .42584 m
.02756 .42584 L
s
.02381 .44497 m
.02756 .44497 L
s
.02381 .4641 m
.02756 .4641 L
s
.02381 .48324 m
.02756 .48324 L
s
.02381 .5215 m
.02756 .5215 L
s
.02381 .54063 m
.02756 .54063 L
s
.02381 .55976 m
.02756 .55976 L
s
.02381 .57889 m
.02756 .57889 L
s
.02381 .00495 m
.02756 .00495 L
s
.02381 .61716 m
.02756 .61716 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
1.000 setlinewidth
grestore
gsave
.5 .63053 -153 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Steady) show
99.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(state) show
141.000 13.000 moveto
(fluctuations) show
219.000 13.000 moveto
(in) show
237.000 13.000 moveto
(Y) show
243.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 0 r
.5 Mabswid
.02381 .31105 m
.02384 .31026 L
.02386 .30954 L
.02389 .30871 L
.02392 .30857 L
.02395 .30888 L
.02397 .30917 L
.024 .30948 L
.02403 .31069 L
.02405 .31203 L
.02408 .31348 L
.02411 .31235 L
.02414 .30934 L
.02417 .30582 L
.02419 .30383 L
.0242 .30316 L
.02423 .30363 L
.02426 .30413 L
.02428 .30438 L
.02429 .30474 L
.02432 .30568 L
.02434 .30622 L
.02436 .30679 L
.02437 .30733 L
.02439 .30719 L
.02442 .30528 L
.02445 .30348 L
.02448 .30153 L
.0245 .30175 L
.02451 .30201 L
.02474 .30479 L
.02522 .30857 L
.02534 .31393 L
.02537 .31502 L
.02541 .31618 L
.02542 .31685 L
.02544 .31677 L
.02546 .31588 L
.02547 .31505 L
.02554 .31163 L
.02558 .31017 L
.0256 .30937 L
.02562 .30863 L
.02563 .30876 L
.02565 .30943 L
.02569 .31088 L
.02575 .31426 L
.02624 .33852 L
.02626 .34068 L
.0263 .34271 L
Mistroke
.02632 .34155 L
.02635 .34048 L
.02638 .33923 L
.0264 .33918 L
.02642 .33951 L
.02645 .34011 L
.02647 .34066 L
.0265 .34308 L
.02653 .34671 L
.02656 .35086 L
.02659 .35428 L
.02661 .35586 L
.02664 .35754 L
.02667 .3594 L
.02669 .36016 L
.02672 .36039 L
.02675 .36064 L
.02678 .36115 L
.02681 .36253 L
.02684 .36395 L
.02687 .36542 L
.02689 .36578 L
.0269 .36611 L
.02694 .36675 L
.02695 .36708 L
.02697 .36709 L
.027 .36609 L
.02702 .36552 L
.02704 .36492 L
.02706 .36435 L
.02707 .363 L
.02713 .35709 L
.0272 .34837 L
.02723 .34405 L
.02726 .34133 L
.02729 .34144 L
.02732 .34156 L
.02734 .34163 L
.02735 .34186 L
.02737 .3424 L
.02739 .34296 L
.02742 .34393 L
.02743 .34447 L
.02745 .34464 L
.02748 .34428 L
.02751 .34394 L
.02753 .34362 L
.02756 .34446 L
.02759 .34558 L
.02761 .34619 L
Mistroke
.02763 .34676 L
.02765 .34677 L
.02768 .3464 L
.02771 .34604 L
.02773 .34591 L
.02775 .3461 L
.02778 .34646 L
.0278 .34679 L
.02782 .34698 L
.02784 .34609 L
.02787 .34358 L
.0279 .34138 L
.02792 .34015 L
.02793 .33995 L
.02799 .33925 L
.02805 .33873 L
.02808 .33848 L
.0281 .33834 L
.02811 .33831 L
.02814 .34136 L
.02817 .34459 L
.0282 .34726 L
.02822 .3489 L
.02825 .35009 L
.02828 .35117 L
.02831 .35192 L
.02833 .35154 L
.02836 .35113 L
.02838 .35068 L
.02841 .35047 L
.02844 .35047 L
.02847 .35047 L
.0285 .35016 L
.02852 .34769 L
.02855 .34498 L
.02857 .3436 L
.02859 .34214 L
.02862 .34101 L
.02865 .33989 L
.02868 .33885 L
.02869 .33853 L
.02871 .33838 L
.02874 .33813 L
.02877 .33789 L
.02879 .33811 L
.0288 .33865 L
.02883 .3396 L
.02886 .34047 L
.02889 .3409 L
.02892 .3409 L
Mistroke
.02895 .3409 L
.02898 .34093 L
.029 .34103 L
.02903 .34115 L
.02906 .34125 L
.02908 .34121 L
.0291 .34114 L
.02912 .34107 L
.02915 .34094 L
.02918 .34318 L
.02921 .34653 L
.02928 .35529 L
.02931 .35959 L
.02933 .36186 L
.02934 .36425 L
.02938 .36613 L
.0294 .36704 L
.02946 .3691 L
.02953 .37246 L
.02959 .37529 L
.02961 .37651 L
.02964 .37748 L
.02966 .37687 L
.02968 .37619 L
.02971 .375 L
.02973 .37392 L
.02976 .37349 L
.02979 .37316 L
.02981 .37286 L
.02984 .37281 L
.02986 .373 L
.02988 .3732 L
.02989 .37341 L
.02991 .37361 L
.02994 .37459 L
.02997 .37611 L
.03 .37754 L
.03003 .37857 L
.03006 .37718 L
.03017 .37135 L
.03022 .36809 L
.03027 .36533 L
.0303 .36379 L
.03033 .36428 L
.03035 .36613 L
.03038 .36784 L
.03041 .36927 L
.03044 .36719 L
.0305 .36252 L
.03056 .35858 L
Mistroke
.03059 .35668 L
.03062 .35565 L
.03064 .35485 L
.03067 .35399 L
.03069 .35354 L
.03071 .3546 L
.03074 .35662 L
.03077 .35848 L
.0308 .35915 L
.03082 .35757 L
.03085 .35583 L
.03088 .35443 L
.03091 .35372 L
.03094 .35304 L
.03096 .35241 L
.03099 .35143 L
.03102 .35029 L
.03109 .34763 L
.0312 .34084 L
.03123 .33808 L
.03125 .33657 L
.03127 .33516 L
.03128 .33495 L
.0313 .33472 L
.03134 .33432 L
.03137 .33393 L
.0314 .33353 L
.03143 .33318 L
.03145 .33298 L
.03146 .33245 L
.03149 .33029 L
.03152 .3283 L
.03155 .32612 L
.03157 .32317 L
.03158 .31963 L
.03161 .31276 L
.03164 .30627 L
.03166 .3041 L
.03168 .30204 L
.03171 .29843 L
.03174 .29497 L
.03176 .29428 L
.03178 .29352 L
.03181 .29216 L
.03184 .29092 L
.03186 .28824 L
.03189 .28518 L
.03195 .27876 L
.03217 .24989 L
.0324 .21996 L
Mistroke
.03246 .21109 L
.03249 .20569 L
.03252 .20277 L
.03255 .20277 L
.03257 .20277 L
.0326 .20277 L
.03263 .19988 L
.03266 .19705 L
.03269 .19438 L
.03272 .19275 L
.03275 .19207 L
.03277 .19148 L
.0328 .19098 L
.03283 .19179 L
.03285 .19253 L
.03291 .19451 L
.03294 .19588 L
.03296 .19662 L
.03297 .19731 L
.033 .19696 L
.03303 .19546 L
.03309 .19283 L
.03321 .18756 L
.03328 .1856 L
.03332 .18415 L
.03333 .18344 L
.03335 .1828 L
.03338 .18195 L
.0334 .18175 L
.03341 .18156 L
.03343 .18137 L
.03345 .18117 L
.03346 .18104 L
.03348 .18187 L
.0336 .18663 L
.03363 .18733 L
.03366 .18826 L
.03368 .18903 L
.0337 .18987 L
.03373 .19134 L
.03375 .19254 L
.03379 .19304 L
.03381 .1935 L
.03384 .19393 L
.03387 .19364 L
.0339 .19324 L
.03393 .19289 L
.03396 .19322 L
.03399 .19366 L
.03402 .19407 L
Mistroke
.03405 .19339 L
.03408 .19062 L
.0341 .18815 L
.03413 .18565 L
.03416 .18778 L
.03419 .18976 L
.03421 .19168 L
.03424 .19279 L
.03426 .19268 L
.03429 .19258 L
.03432 .19247 L
.03435 .19272 L
.03437 .19305 L
.0344 .19336 L
.03443 .19314 L
.03445 .19246 L
.03446 .19182 L
.03449 .19059 L
.03452 .19003 L
.03455 .1909 L
.03458 .19185 L
.03464 .19335 L
.03467 .19387 L
.03469 .19415 L
.03471 .19463 L
.03474 .19673 L
.03477 .19903 L
.03483 .20308 L
.03486 .20501 L
.03488 .2068 L
.03491 .20779 L
.03493 .20789 L
.03496 .208 L
.03498 .2081 L
.03501 .20941 L
.03504 .21128 L
.03507 .21303 L
.03509 .21435 L
.03512 .21482 L
.03515 .21534 L
.03518 .21586 L
.03521 .21901 L
.03525 .2224 L
.03528 .22555 L
.03531 .22777 L
.03534 .23013 L
.03537 .23214 L
.0354 .23298 L
.03543 .23388 L
.03546 .2347 L
Mistroke
.0356 .2384 L
.03573 .24298 L
.03579 .24549 L
.03581 .2464 L
.03584 .24723 L
.03587 .24903 L
.0359 .25152 L
.03596 .25703 L
.03602 .26336 L
.03608 .26812 L
.0361 .26932 L
.03612 .27046 L
.03615 .27178 L
.03616 .27128 L
.03618 .27073 L
.0362 .27016 L
.03621 .26961 L
.03624 .26908 L
.03627 .26941 L
.0363 .26979 L
.03633 .27026 L
.03636 .27189 L
.03638 .27363 L
.03644 .27756 L
.03647 .28016 L
.03649 .28152 L
.03651 .28296 L
.03652 .28397 L
.03654 .28432 L
.03657 .28493 L
.0366 .28552 L
.03662 .2858 L
.03663 .2858 L
.03666 .2858 L
.03669 .2858 L
.03672 .28759 L
.03674 .29035 L
.03676 .29293 L
.03679 .29783 L
.03682 .30152 L
.03683 .3023 L
.03685 .30315 L
.03688 .30465 L
.03695 .30744 L
.03698 .30859 L
.03701 .30937 L
.03703 .30964 L
.03705 .30993 L
.03708 .31043 L
.03711 .31067 L
Mistroke
.03714 .31067 L
.03717 .31067 L
.0372 .31098 L
.03723 .31223 L
.03726 .3134 L
.03727 .31406 L
.03729 .31497 L
.0373 .31671 L
.03732 .31862 L
.03735 .3219 L
.03737 .32369 L
.03738 .32511 L
.03741 .32673 L
.03744 .3285 L
.03747 .33012 L
.03749 .32988 L
.03752 .32873 L
.03755 .32764 L
.0376 .32504 L
.03763 .32352 L
.03767 .32189 L
.0377 .32645 L
.03773 .33119 L
.03779 .33987 L
.03782 .34298 L
.03785 .34593 L
.03788 .34734 L
.03791 .34838 L
.03817 .35647 L
.0383 .36076 L
.03836 .36219 L
.03839 .36296 L
.03842 .3638 L
.03844 .36517 L
.03847 .3672 L
.03852 .37164 L
.03864 .37833 L
.03915 .4111 L
.04008 .4598 L
.04033 .47734 L
.04039 .48296 L
.04041 .4844 L
.04043 .48594 L
.04045 .48698 L
.04046 .48677 L
.0405 .48638 L
.04051 .48617 L
.04053 .48597 L
.04056 .48621 L
.04058 .48639 L
Mistroke
.04059 .48659 L
.04062 .48696 L
.04064 .48722 L
.04066 .48763 L
.04069 .48848 L
.04071 .48889 L
.04072 .48926 L
.04075 .49129 L
.04079 .49366 L
.04082 .49588 L
.04085 .497 L
.04087 .49786 L
.0409 .49882 L
.04093 .49872 L
.04096 .49745 L
.04099 .49634 L
.04102 .49555 L
.04105 .49577 L
.04108 .49598 L
.04111 .49622 L
.04114 .49907 L
.04116 .50191 L
.04119 .50492 L
.04122 .50658 L
.04125 .50658 L
.04128 .50658 L
.0413 .50658 L
.04131 .50734 L
.04134 .50938 L
.04137 .51131 L
.04142 .51618 L
.04145 .52024 L
.04148 .52406 L
.0415 .52613 L
.04153 .52624 L
.04156 .52636 L
.04159 .5265 L
.04161 .52669 L
.04162 .5269 L
.04165 .52726 L
.04168 .5276 L
.04171 .53078 L
.04174 .53389 L
.04177 .53676 L
.04178 .53739 L
.0418 .53556 L
.04184 .53169 L
.04187 .52834 L
.04189 .5278 L
.0419 .52806 L
Mistroke
.04197 .52907 L
.042 .52957 L
.04203 .53003 L
.04206 .53048 L
.04208 .52974 L
.04211 .52785 L
.04214 .52581 L
.0422 .52251 L
.04223 .5209 L
.04226 .51962 L
.04229 .51986 L
.04233 .52012 L
.04234 .52027 L
.04236 .52003 L
.04239 .51838 L
.04242 .51694 L
.04245 .51541 L
.04247 .51557 L
.04248 .51576 L
.04251 .51611 L
.04254 .51645 L
.04257 .51376 L
.0426 .51069 L
.04262 .50741 L
.04265 .50563 L
.04268 .50728 L
.04271 .50908 L
.04273 .51009 L
.04274 .51043 L
.04277 .50795 L
.0428 .50533 L
.04283 .50303 L
.04285 .50305 L
.04288 .50387 L
.04291 .50475 L
.04293 .50508 L
.04296 .50336 L
.04391 .41648 L
.04483 .30875 L
.04534 .24006 L
.0458 .18821 L
.04604 .15327 L
.04606 .15284 L
.04607 .15237 L
.0461 .15054 L
.04614 .14829 L
.04615 .14731 L
.04617 .14623 L
.0462 .13886 L
.04623 .13078 L
Mistroke
.04626 .12328 L
.04629 .12222 L
.04632 .12201 L
.04635 .12179 L
.04637 .12138 L
.0464 .12034 L
.04642 .11922 L
.04645 .11803 L
.04648 .11755 L
.04651 .11724 L
.04654 .11688 L
.04657 .11594 L
.0466 .11398 L
.04663 .11191 L
.04668 .10935 L
.04671 .10831 L
.04674 .10718 L
.04677 .10493 L
.0468 .10271 L
.04683 .10056 L
.04686 .10046 L
.04689 .1016 L
.04692 .10263 L
.04693 .1032 L
.04695 .10548 L
.04698 .11016 L
.04701 .1146 L
.04704 .11768 L
.04707 .117 L
.0471 .11624 L
.04713 .11559 L
.04715 .11856 L
.04721 .12612 L
.04727 .13339 L
.04733 .14039 L
.04736 .14304 L
.0474 .14596 L
.04743 .14809 L
.04746 .14958 L
.04771 .16442 L
.04815 .19163 L
.0484 .20788 L
.04852 .21342 L
.04864 .22027 L
.04869 .22402 L
.04872 .22645 L
.04874 .22778 L
.04876 .22922 L
.04878 .2335 L
.04881 .2382 L
Mistroke
.04884 .24216 L
.04887 .24498 L
.0489 .24757 L
.04893 .25002 L
.04899 .25352 L
.04902 .25534 L
.04904 .25626 L
.04906 .25835 L
.04912 .26581 L
.04913 .2678 L
.04915 .26861 L
.04917 .26945 L
.04918 .27036 L
.04924 .27383 L
.04931 .27882 L
.04938 .2859 L
.04962 .3058 L
.05062 .37816 L
.05158 .45542 L
.05202 .48321 L
.05227 .49879 L
.0525 .50991 L
.05253 .5109 L
.05256 .51194 L
.05258 .51255 L
.05259 .51231 L
.05262 .51124 L
.05265 .51025 L
.05268 .50963 L
.05271 .5145 L
.05273 .51899 L
.05275 .52169 L
.05277 .52458 L
.0528 .52666 L
.05283 .52793 L
.05284 .5286 L
.05286 .52932 L
.05289 .52837 L
.05292 .52705 L
.05298 .5247 L
.05301 .52365 L
.05304 .52252 L
.05306 .52188 L
.05307 .52202 L
.05311 .52228 L
.05314 .52253 L
.05316 .52252 L
.05317 .52186 L
.05321 .52043 L
.05323 .51973 L
Mistroke
.05324 .51908 L
.05327 .51983 L
.05329 .52052 L
.0533 .52124 L
.05333 .52241 L
.05336 .52261 L
.05339 .52175 L
.05342 .52082 L
.05346 .51964 L
.05348 .51825 L
.05351 .51688 L
.05354 .51495 L
.05357 .51181 L
.0536 .50892 L
.05363 .50554 L
.05365 .50566 L
.05366 .50594 L
.05369 .50642 L
.05372 .50687 L
.05375 .50624 L
.05378 .50539 L
.05381 .50441 L
.05384 .50395 L
.05386 .50405 L
.05389 .50415 L
.05391 .50426 L
.05394 .5053 L
.054 .50796 L
.05403 .50893 L
.05407 .50972 L
.05408 .51013 L
.0541 .51058 L
.05412 .51039 L
.05414 .50969 L
.05417 .50823 L
.0542 .50688 L
.05423 .50313 L
.05426 .49833 L
.05429 .49351 L
.05431 .49161 L
.05432 .49148 L
.05435 .49125 L
.05438 .49103 L
.05441 .48987 L
.05444 .48778 L
.05456 .47835 L
.05462 .47233 L
.05464 .46924 L
.05467 .46586 L
.0547 .46116 L
Mistroke
.05473 .45515 L
.05479 .44317 L
.05486 .43355 L
.05492 .42526 L
.05536 .34973 L
.0563 .16314 L
.05654 .11845 L
.05658 .1138 L
.05661 .10703 L
.05664 .09918 L
.05667 .09172 L
.05669 .08796 L
.05671 .08761 L
.05674 .08699 L
.05676 .08663 L
.05678 .08624 L
.05679 .08497 L
.05681 .08306 L
.05684 .07953 L
.05686 .0776 L
.05687 .07581 L
.05689 .07494 L
.05691 .07486 L
.05694 .07473 L
.05697 .07461 L
.057 .07545 L
.05706 .07773 L
.05712 .07979 L
.05715 .08088 L
.05716 .08143 L
.05718 .0816 L
.05721 .08185 L
.05724 .08207 L
.05727 .08133 L
.05729 .07613 L
.05732 .07065 L
.05735 .06548 L
.05737 .06381 L
.05738 .06253 L
.05741 .0603 L
.05744 .05817 L
.05747 .05745 L
.0575 .05755 L
.05752 .05766 L
.05754 .05773 L
.05756 .05795 L
.05759 .05855 L
.05762 .0592 L
.05764 .05956 L
.05765 .06063 L
Mistroke
.05771 .06557 L
.05778 .07235 L
.05781 .07634 L
.05783 .07852 L
.05784 .07944 L
.05786 .07915 L
.05788 .07884 L
.0579 .07856 L
.05791 .0783 L
.05793 .07805 L
.05795 .07888 L
.05798 .08042 L
.05804 .08369 L
.05828 .09534 L
.05926 .15476 L
.06021 .21742 L
.06112 .27429 L
.06209 .3366 L
.06302 .38082 L
.06401 .4252 L
.06404 .42439 L
.06407 .42505 L
.06408 .42631 L
.0641 .4277 L
.06413 .43014 L
.06425 .44173 L
.06428 .44454 L
.0643 .44608 L
.06432 .44754 L
.06433 .4489 L
.06435 .44899 L
.06438 .44714 L
.06441 .44531 L
.06443 .44431 L
.06444 .44367 L
.06447 .44312 L
.0645 .4425 L
.06453 .44196 L
.06456 .44309 L
.06459 .44435 L
.06462 .4457 L
.06465 .44779 L
.06467 .45008 L
.06472 .45455 L
.06478 .46248 L
.06485 .46943 L
.06487 .47153 L
.0649 .4738 L
.06493 .47482 L
.06496 .47482 L
Mistroke
.06499 .47482 L
.06502 .47477 L
.06505 .47465 L
.06508 .47454 L
.06511 .47453 L
.06513 .47603 L
.06519 .47938 L
.06525 .48432 L
.06531 .49024 L
.06543 .5008 L
.06549 .50473 L
.06555 .50798 L
.06557 .50962 L
.0656 .50917 L
.06562 .50789 L
.06564 .50668 L
.06566 .50441 L
.06569 .50331 L
.06572 .50386 L
.06577 .50485 L
.06582 .50591 L
.06585 .50651 L
.06588 .50698 L
.06591 .50709 L
.06594 .50721 L
.06597 .50734 L
.066 .50723 L
.06602 .50712 L
.06605 .50701 L
.06608 .50634 L
.0661 .50534 L
.06613 .50425 L
.06616 .50316 L
.06618 .50349 L
.06619 .5038 L
.06622 .5044 L
.06625 .50501 L
.06627 .50599 L
.06629 .50696 L
.06632 .50871 L
.06635 .51061 L
.06637 .51156 L
.0664 .51236 L
.06642 .51318 L
.06645 .51374 L
.06647 .51281 L
.0665 .51179 L
.06656 .5098 L
.06667 .50642 L
.0667 .50554 L
Mistroke
.06673 .5047 L
.06676 .50466 L
.06679 .50466 L
.06682 .50466 L
.06684 .50442 L
.06687 .50392 L
.0669 .50345 L
.06693 .50307 L
.06696 .50287 L
.06701 .50241 L
.06704 .50198 L
.06708 .50146 L
.06711 .50097 L
.06713 .50139 L
.06715 .50183 L
.06717 .50231 L
.06718 .50278 L
.0672 .50329 L
.06723 .50285 L
.06726 .50202 L
.06728 .50156 L
.0673 .50107 L
.06733 .50221 L
.06735 .50325 L
.06736 .50422 L
.0674 .50644 L
.06746 .50968 L
.06748 .51057 L
.0675 .5115 L
.06751 .51144 L
.06753 .51131 L
.06756 .51106 L
.06759 .51083 L
.0676 .50981 L
.06762 .50819 L
.06765 .50535 L
.06768 .50264 L
.06771 .50131 L
.06774 .50057 L
.06777 .49975 L
.06782 .49802 L
.06785 .49705 L
.06788 .49635 L
.0679 .49681 L
.06792 .4973 L
.06795 .49816 L
.06801 .49971 L
.06804 .50043 L
.06807 .5011 L
.06809 .49949 L
Mistroke
.06813 .49719 L
.06824 .48709 L
.0685 .45986 L
.06874 .44039 L
.06886 .43344 L
.06889 .43225 L
.06892 .43114 L
.06894 .43001 L
.06895 .42795 L
.06899 .42357 L
.06905 .41402 L
.06908 .40891 L
.06911 .40332 L
.06914 .39975 L
.06917 .39716 L
.06923 .39114 L
.06944 .36084 L
.06967 .31642 L
.07015 .23644 L
.07041 .20934 L
.07054 .19249 L
.07058 .18607 L
.07061 .17975 L
.07064 .17408 L
.07066 .17219 L
.07067 .17225 L
.0707 .17236 L
.07073 .17247 L
.07076 .17307 L
.07079 .17468 L
.07082 .17618 L
.07085 .17754 L
.07086 .1776 L
.07088 .17767 L
.07091 .17779 L
.07093 .17786 L
.07095 .17762 L
.07098 .17637 L
.07099 .17565 L
.07101 .1749 L
.07103 .17426 L
.07105 .17276 L
.07111 .16667 L
.07117 .15959 L
.0712 .15616 L
.07123 .15405 L
.07126 .15489 L
.07129 .15581 L
.07132 .1568 L
.07134 .1544 L
Mistroke
.07135 .15191 L
.07138 .147 L
.07141 .1425 L
.07144 .14105 L
.07147 .14037 L
.07149 .13968 L
.07153 .14056 L
.07155 .14316 L
.07158 .14595 L
.07163 .14991 L
.07167 .1517 L
.0717 .15338 L
.07173 .15285 L
.07174 .15219 L
.07176 .15147 L
.07179 .15028 L
.07182 .1528 L
.07185 .156 L
.07188 .15949 L
.0719 .16152 L
.07191 .16234 L
.07195 .16387 L
.07202 .16803 L
.07215 .17448 L
.07263 .20243 L
.07307 .22638 L
.07313 .22787 L
.07319 .2297 L
.07321 .2302 L
.07322 .23073 L
.07324 .23179 L
.07326 .23342 L
.07332 .23937 L
.07355 .25707 L
.07358 .26157 L
.0736 .26402 L
.07362 .26629 L
.07363 .26663 L
.07365 .26699 L
.07368 .26764 L
.0738 .27008 L
.07383 .27011 L
.07386 .27011 L
.07389 .27011 L
.07392 .27096 L
.07403 .27542 L
.07406 .27636 L
.07409 .27737 L
.07411 .27497 L
.07413 .27271 L
Mistroke
.07416 .26828 L
.07419 .26438 L
.07422 .26737 L
.07425 .27019 L
.07428 .27284 L
.07429 .27381 L
.07431 .27431 L
.07434 .27519 L
.07436 .27569 L
.07438 .27621 L
.07439 .27508 L
.07441 .27375 L
.07444 .27137 L
.07446 .27006 L
.07448 .26901 L
.07449 .26931 L
.07451 .26963 L
.07454 .27021 L
.07456 .27075 L
.07459 .27171 L
.07462 .27288 L
.07465 .27415 L
.07468 .27505 L
.07471 .27493 L
.07473 .27482 L
.07476 .2747 L
.07478 .27426 L
.0748 .27386 L
.07483 .27308 L
.07486 .27255 L
.07489 .27483 L
.07492 .27683 L
.07495 .27898 L
.07497 .28108 L
.07498 .28327 L
.07501 .28757 L
.07504 .29194 L
.07506 .2923 L
.07508 .2918 L
.07511 .2908 L
.07514 .28989 L
.07515 .29081 L
.07517 .29329 L
.07521 .2985 L
.07527 .30656 L
.07533 .31223 L
.07539 .31832 L
.07541 .32011 L
.07542 .32181 L
.07545 .32204 L
Mistroke
.07548 .32145 L
.0755 .32113 L
.07552 .3208 L
.07555 .32249 L
.07557 .32495 L
.0756 .32783 L
.07563 .32961 L
.07566 .33001 L
.07569 .33045 L
.07574 .33146 L
.07578 .33211 L
.07579 .33245 L
.07581 .33281 L
.07583 .33451 L
.07584 .33673 L
.07587 .34062 L
.07594 .34718 L
.07597 .34958 L
.07599 .3518 L
.07602 .35354 L
.07606 .35492 L
.07612 .35777 L
.07625 .36458 L
.0765 .37507 L
.07673 .39351 L
.07675 .39635 L
.07676 .39938 L
.0768 .40062 L
.07681 .40089 L
.07683 .40113 L
.07686 .40169 L
.07689 .40272 L
.07693 .40389 L
.07695 .40488 L
.07698 .40359 L
.07704 .39967 L
.07707 .39797 L
.0771 .39719 L
.07711 .39676 L
.07713 .39628 L
.07716 .39595 L
.07719 .39743 L
.07722 .3988 L
.07725 .40009 L
.07727 .40266 L
.0773 .40548 L
.07733 .40858 L
.07735 .41028 L
.07739 .40953 L
.07741 .4089 L
Mistroke
.07744 .40828 L
.07746 .40875 L
.07747 .40918 L
.0775 .41002 L
.07753 .41079 L
.07756 .41072 L
.07759 .4105 L
.07761 .4103 L
.07764 .41081 L
.07767 .41273 L
.0777 .41447 L
.07772 .41609 L
.07775 .41684 L
.07778 .41755 L
.0778 .4181 L
.07783 .41865 L
.07785 .41909 L
.07788 .41948 L
.07791 .41995 L
.07792 .42013 L
.07794 .42019 L
.07797 .42031 L
.078 .42042 L
.07802 .42011 L
.07805 .4192 L
.07811 .41719 L
.07816 .41497 L
.07819 .41372 L
.07822 .41141 L
.07825 .40752 L
.07829 .40387 L
.07832 .40212 L
.07835 .40212 L
.07838 .40212 L
.0784 .40169 L
.07844 .39967 L
.07847 .39776 L
.07858 .38867 L
.07864 .38553 L
.07871 .38184 L
.07883 .37285 L
.07888 .36953 L
.07891 .36781 L
.07894 .36618 L
.07896 .36526 L
.07898 .36491 L
.07901 .36629 L
.07907 .36908 L
.0791 .37113 L
.07914 .37307 L
Mistroke
.07915 .37414 L
.07917 .3738 L
.07919 .37268 L
.07921 .37165 L
.07922 .37066 L
.07924 .3696 L
.07927 .36864 L
.0793 .36914 L
.07932 .36942 L
.07933 .36969 L
.07936 .36949 L
.07938 .36881 L
.07939 .36807 L
.07946 .36429 L
.07952 .35799 L
.07955 .35508 L
.07958 .3552 L
.0796 .35527 L
.07961 .35534 L
.07963 .3554 L
.07965 .35555 L
.07966 .35583 L
.07968 .3561 L
.0797 .3564 L
.07972 .35668 L
.07975 .35605 L
.07976 .3548 L
.07978 .35346 L
.07979 .35215 L
.07981 .35075 L
.07984 .34905 L
.07986 .34871 L
.07988 .34839 L
.07991 .3478 L
.07992 .34746 L
.07994 .34771 L
.07995 .34812 L
.07997 .34855 L
.0801 .35271 L
.08015 .35431 L
.08018 .35502 L
.08021 .35568 L
.08022 .35586 L
.08024 .35593 L
.08027 .35605 L
.0803 .35617 L
.08033 .3559 L
.08036 .35544 L
.08038 .35496 L
.08041 .35512 L
Mistroke
.08044 .35679 L
.08047 .3586 L
.08048 .35959 L
.0805 .3603 L
.08053 .3586 L
.08056 .35706 L
.08058 .35558 L
.08061 .35573 L
.08064 .35659 L
.08066 .35753 L
.08069 .35868 L
.08072 .36268 L
.08078 .36991 L
.08084 .37635 L
.08086 .37802 L
.08088 .3798 L
.08089 .37943 L
.08091 .37795 L
.08094 .37532 L
.08096 .37394 L
.08097 .37248 L
.08099 .37238 L
.08101 .37251 L
.08103 .37274 L
.08107 .37299 L
.08109 .37487 L
.08112 .37743 L
.08114 .37877 L
.08116 .3802 L
.08119 .38132 L
.08122 .38166 L
.08124 .38197 L
.08127 .38136 L
.08133 .37512 L
.08135 .37333 L
.08136 .37223 L
.08139 .37198 L
.08143 .37171 L
.08145 .37156 L
.08147 .37169 L
.0815 .37219 L
.08151 .37247 L
.08153 .37272 L
.08156 .37373 L
.08159 .37599 L
.08162 .37812 L
.08165 .3798 L
.08168 .37789 L
.08171 .37582 L
.08174 .37428 L
Mistroke
.08176 .37471 L
.08178 .37518 L
.08181 .37599 L
.08184 .37685 L
.08186 .37543 L
.08189 .37382 L
.08192 .37208 L
.08194 .37131 L
.08196 .37087 L
.08202 .3692 L
.08224 .36338 L
.0823 .36198 L
.08231 .36158 L
.08233 .36138 L
.08236 .36102 L
.08239 .36068 L
.08242 .36 L
.08244 .35725 L
.08247 .35432 L
.08259 .34257 L
.08266 .33694 L
.08272 .33159 L
.08275 .32963 L
.08277 .32856 L
.08279 .32756 L
.08281 .32662 L
.08284 .3259 L
.08287 .3252 L
.0829 .3258 L
.08293 .32859 L
.08296 .33123 L
.08298 .3336 L
.08301 .33277 L
.08303 .33201 L
.08306 .3312 L
.08309 .33093 L
.08311 .33215 L
.08314 .33359 L
.08317 .33493 L
.0832 .33401 L
.08323 .33251 L
.08329 .32828 L
.08341 .31643 L
.08363 .29147 L
.08389 .26958 L
.08401 .26208 L
.08407 .25623 L
.0841 .25331 L
.08413 .25065 L
.08416 .24967 L
Mistroke
.08419 .24876 L
.08422 .24781 L
.08424 .2478 L
.08425 .2483 L
.08428 .24932 L
.08431 .25027 L
.08434 .25018 L
.08436 .24985 L
.08438 .2495 L
.08445 .24836 L
.08446 .24814 L
.08448 .24792 L
.0845 .2477 L
.08452 .24714 L
.08455 .24286 L
.08458 .23882 L
.08465 .23142 L
.08468 .22875 L
.0847 .22625 L
.08473 .22667 L
.08477 .22732 L
.08482 .22874 L
.08485 .22964 L
.08488 .23048 L
.08491 .23063 L
.08492 .22999 L
.08494 .2293 L
.08497 .22808 L
.085 .22815 L
.08502 .23031 L
.08503 .23229 L
.08507 .23676 L
.0851 .23999 L
.08511 .2408 L
.08513 .24168 L
.08516 .24321 L
.08519 .24429 L
.08521 .24384 L
.08522 .24333 L
.08526 .24245 L
.08529 .24149 L
.0853 .24068 L
.08532 .23995 L
.08535 .23851 L
.08538 .2372 L
.0854 .2369 L
.08543 .23657 L
.08546 .23621 L
.08548 .23844 L
.08554 .24783 L
Mistroke
.08557 .2521 L
.0856 .25173 L
.08563 .25133 L
.08566 .25102 L
.08569 .25136 L
.08572 .25173 L
.08574 .25194 L
.08576 .25231 L
.08578 .25338 L
.08579 .25437 L
.08583 .25636 L
.08586 .2578 L
.08589 .25744 L
.08592 .25705 L
.08595 .25663 L
.08598 .25533 L
.08601 .25381 L
.08604 .25238 L
.08607 .25274 L
.08608 .25314 L
.0861 .25356 L
.08622 .25542 L
.08628 .25634 L
.0863 .2566 L
.08631 .25689 L
.08633 .25755 L
.08635 .25964 L
.08638 .26427 L
.0864 .26672 L
.08642 .26932 L
.08644 .27057 L
.08645 .27116 L
.08649 .27233 L
.08652 .27347 L
.08653 .27509 L
.08655 .27673 L
.08661 .28295 L
.08667 .28764 L
.0867 .28987 L
.08673 .29078 L
.08676 .29078 L
.08678 .29078 L
.08682 .29153 L
.08683 .29291 L
.08685 .29419 L
.08697 .30299 L
.08703 .30864 L
.08706 .31233 L
.08708 .31414 L
.0871 .3156 L
Mistroke
.08712 .31761 L
.08715 .31976 L
.08718 .32193 L
.0872 .32266 L
.08722 .32322 L
.08725 .32421 L
.08727 .32526 L
.0873 .32533 L
.08733 .32488 L
.08736 .32443 L
.08738 .3243 L
.08741 .32658 L
.08744 .32874 L
.08746 .33059 L
.08749 .33192 L
.08752 .33294 L
.08755 .3339 L
.08756 .33448 L
.08758 .33562 L
.08761 .33846 L
.08768 .34537 L
.08771 .34941 L
.08774 .35372 L
.08776 .35581 L
.08778 .35687 L
.0878 .35885 L
.08783 .36063 L
.08786 .36236 L
.08789 .36272 L
.08792 .36306 L
.08795 .36342 L
.08798 .36319 L
.08801 .36281 L
.08802 .36261 L
.08804 .36241 L
.08807 .36083 L
.0881 .35907 L
.08811 .35807 L
.08813 .35701 L
.08816 .35627 L
.08818 .35637 L
.08821 .35648 L
.08824 .35665 L
.08827 .35709 L
.08833 .35809 L
.08839 .3588 L
.08841 .35899 L
.08842 .35919 L
.08844 .35823 L
.08846 .35679 L
Mistroke
.08849 .35405 L
.08852 .35155 L
.08855 .35326 L
.08858 .35571 L
.08865 .35978 L
.08876 .36846 L
.0888 .37267 L
.08881 .37495 L
.08883 .37482 L
.08886 .37457 L
.08889 .37433 L
.08891 .3742 L
.08892 .37329 L
.08896 .37121 L
.08898 .37035 L
.08899 .36942 L
.08901 .36892 L
.08903 .36913 L
.0895 .38337 L
.08963 .38704 L
.0897 .38966 L
.08974 .39078 L
.08975 .39127 L
.08977 .39179 L
.0898 .39191 L
.08983 .39204 L
.08985 .39211 L
.08987 .39205 L
.08989 .39143 L
.0899 .39087 L
.09002 .38541 L
.09025 .37775 L
.09032 .37542 L
.09039 .37331 L
.09042 .37253 L
.09045 .37195 L
.09046 .37209 L
.09048 .37222 L
.09051 .37247 L
.09054 .37272 L
.09057 .37318 L
.09062 .37402 L
.09067 .37511 L
.09069 .37542 L
.09071 .37575 L
.09074 .37587 L
.09077 .37525 L
.09078 .37493 L
.0908 .37458 L
.09083 .37423 L
Mistroke
.09086 .37435 L
.09089 .37447 L
.09092 .37413 L
.09095 .37176 L
.09097 .36917 L
.09099 .36773 L
.09101 .36622 L
.09104 .36597 L
.09107 .36622 L
.09109 .36637 L
.0911 .3665 L
.09113 .36654 L
.09115 .36654 L
.09116 .36654 L
.09119 .36654 L
.09122 .36487 L
.09125 .3627 L
.09128 .36031 L
.09131 .35963 L
.09134 .36127 L
.09137 .36277 L
.09139 .36419 L
.09142 .36344 L
.09145 .36269 L
.09148 .36181 L
.09151 .35891 L
.09154 .35481 L
.09156 .35265 L
.09157 .35036 L
.0916 .34812 L
.09163 .34697 L
.09166 .34579 L
.09169 .34416 L
.09172 .34115 L
.09175 .33791 L
.09181 .33321 L
.09188 .32875 L
.09191 .3264 L
.09195 .32387 L
.09198 .32237 L
.09201 .32146 L
.09204 .32053 L
.09207 .3199 L
.0921 .32013 L
.09213 .32038 L
.09216 .32062 L
.09217 .32055 L
.09219 .32049 L
.09222 .32038 L
.09224 .32027 L
Mistroke
.09228 .32215 L
.0923 .32454 L
.09233 .32661 L
.09235 .32822 L
.09238 .32799 L
.09241 .32777 L
.09291 .32417 L
.09297 .32598 L
.093 .32716 L
.09303 .32756 L
.09306 .32642 L
.09309 .32518 L
.09312 .3239 L
.09315 .32193 L
.09318 .3199 L
.0932 .31878 L
.09322 .31708 L
.09324 .3145 L
.09326 .31215 L
.09327 .30992 L
.09329 .30755 L
.09332 .30463 L
.09335 .30287 L
.09342 .29803 L
.09347 .29188 L
.09349 .29019 L
.09351 .28923 L
.09354 .28817 L
.09356 .28724 L
.09359 .28626 L
.09362 .28843 L
.09365 .29068 L
.09366 .29195 L
.09368 .29331 L
.0937 .29393 L
.09372 .29407 L
.09375 .29434 L
.09378 .29459 L
.09381 .29491 L
.09384 .29527 L
.09385 .29547 L
.09387 .29567 L
.0939 .29464 L
.09482 .2578 L
.09504 .24499 L
.09528 .23178 L
.09542 .22626 L
.09548 .22409 L
.09552 .22294 L
.09555 .2217 L
Mistroke
.09557 .22109 L
.09558 .22051 L
.09561 .2206 L
.09564 .22172 L
.09567 .22292 L
.09569 .22353 L
.0957 .22331 L
.09572 .22239 L
.09574 .22153 L
.0958 .218 L
.09586 .21289 L
.09587 .2115 L
.09589 .21048 L
.09592 .21085 L
.09595 .21122 L
.09598 .21156 L
.09601 .2106 L
.09604 .20957 L
.09609 .20765 L
.09612 .20669 L
.09615 .20579 L
.09617 .20515 L
.0962 .20659 L
.09625 .20965 L
.09632 .21259 L
.09633 .21335 L
.09635 .21415 L
.09637 .21459 L
.09638 .21446 L
.09641 .21421 L
.09643 .21408 L
.09645 .21394 L
.09648 .21255 L
.09651 .21082 L
.09654 .20914 L
.09657 .20917 L
.09659 .21142 L
.09662 .21347 L
.09665 .21581 L
.09667 .21615 L
.09668 .21646 L
.09671 .21707 L
.09674 .21764 L
.09677 .21739 L
.0968 .21702 L
.09683 .21668 L
.09685 .21649 L
.09688 .21637 L
.0969 .21631 L
.09692 .21624 L
Mistroke
.09695 .21616 L
.09697 .21616 L
.097 .21616 L
.09703 .21616 L
.09706 .2168 L
.09709 .21753 L
.09719 .22004 L
.09722 .22077 L
.09724 .22098 L
.09726 .22118 L
.09728 .22152 L
.0973 .22171 L
.09732 .22189 L
.09735 .22144 L
.09737 .22101 L
.0974 .22052 L
.09743 .22037 L
.09746 .22037 L
.09748 .22037 L
.0975 .22037 L
.09753 .22005 L
.09756 .21959 L
.09759 .21911 L
.0976 .21885 L
.09762 .21941 L
.09765 .22068 L
.09769 .22187 L
.09772 .22329 L
.09775 .22514 L
.0978 .2285 L
.09786 .23319 L
.09789 .23556 L
.09791 .23512 L
.09792 .23455 L
.09795 .2336 L
.09798 .2326 L
.09801 .23075 L
.09803 .22872 L
.09806 .22698 L
.09808 .22551 L
.09811 .22687 L
.09814 .22815 L
.09817 .22964 L
.09819 .23013 L
.0982 .23048 L
.09824 .2312 L
.09826 .23155 L
.09827 .23184 L
.0983 .23133 L
.09834 .23079 L
Mistroke
.09837 .23039 L
.0984 .23146 L
.09843 .23249 L
.09846 .23358 L
.09849 .23386 L
.09851 .23396 L
.09854 .23408 L
.09856 .2342 L
.09858 .2347 L
.09864 .23661 L
.09875 .24022 L
.09881 .2427 L
.09887 .24535 L
.0989 .24674 L
.09892 .24821 L
.09896 .24785 L
.09898 .24544 L
.09901 .24344 L
.09903 .24127 L
.09906 .24365 L
.09909 .24639 L
.09912 .24962 L
.09915 .25073 L
.09916 .25046 L
.09918 .25022 L
.09921 .24968 L
.09928 .24816 L
.09931 .24741 L
.09933 .24694 L
.09935 .24617 L
.09938 .24483 L
.09941 .24357 L
.09943 .24423 L
.09946 .24719 L
.09958 .25648 L
.10006 .28057 L
.10007 .28233 L
.10009 .2839 L
.10011 .28397 L
.10013 .28404 L
.10016 .28416 L
.10017 .28423 L
.10019 .28479 L
.10021 .28677 L
.10022 .28857 L
.10024 .2905 L
.10026 .29261 L
.10028 .2945 L
.1003 .29509 L
.10033 .29612 L
Mistroke
.10036 .29707 L
.10039 .29884 L
.10042 .30276 L
.10045 .30697 L
.10051 .31443 L
.10053 .31617 L
.10055 .3178 L
.10058 .31985 L
.1006 .31985 L
.10064 .31985 L
.10065 .31985 L
.10067 .31988 L
.1007 .32 L
.10073 .32012 L
.10075 .32019 L
.10076 .32024 L
.10078 .32024 L
.1008 .32024 L
.10081 .32024 L
.10083 .32024 L
.10086 .3205 L
.10089 .32149 L
.10092 .32243 L
.10095 .32329 L
.10098 .32293 L
.10101 .32252 L
.10104 .32216 L
.10108 .32387 L
.1011 .32544 L
.10113 .32693 L
.10116 .33001 L
.10119 .33345 L
.10121 .33672 L
.10124 .33965 L
.10127 .34181 L
.10129 .34418 L
.10132 .34659 L
.10135 .34622 L
.10138 .34461 L
.10141 .34314 L
.10147 .33912 L
.10153 .33549 L
.10156 .33412 L
.10159 .33264 L
.10162 .3314 L
.10165 .33235 L
.10168 .33336 L
.10171 .33444 L
.10172 .3349 L
.10174 .33516 L
Mistroke
.10177 .33565 L
.1018 .33607 L
.10182 .33642 L
.10185 .33664 L
.10188 .33684 L
.1019 .33704 L
.10193 .33687 L
.10196 .33665 L
.10199 .33641 L
.10202 .33776 L
.10204 .33907 L
.10205 .34028 L
.10211 .3444 L
.10215 .34613 L
.10218 .34775 L
.10219 .34855 L
.10221 .34855 L
.10225 .34855 L
.10228 .34855 L
.10229 .34893 L
.10231 .35108 L
.10237 .36006 L
.10243 .36774 L
.10246 .37193 L
.10249 .37517 L
.10252 .37612 L
.10255 .37717 L
.10258 .37799 L
.10261 .37739 L
.10264 .37673 L
.10266 .37636 L
.10268 .37616 L
.10271 .37664 L
.10274 .37716 L
.10277 .37768 L
.1028 .37873 L
.10285 .3807 L
.10291 .38361 L
.10298 .38714 L
.10342 .41416 L
.10345 .41503 L
.10348 .41477 L
.10351 .41453 L
.10354 .41471 L
.10356 .4156 L
.10357 .41639 L
.10361 .41818 L
.10367 .42244 L
.10378 .42936 L
.1039 .4359 L
Mistroke
.10393 .43739 L
.10394 .4379 L
.10396 .43846 L
.10402 .44009 L
.10414 .4431 L
.10417 .44538 L
.10419 .44662 L
.1042 .44756 L
.10422 .44672 L
.10424 .44579 L
.10426 .44499 L
.10427 .44415 L
.10429 .44341 L
.10431 .44372 L
.10434 .44573 L
.10435 .44696 L
.10437 .44811 L
.10439 .44915 L
.1044 .44944 L
.10442 .44925 L
.10443 .44905 L
.10446 .4487 L
.1045 .44795 L
.10451 .44689 L
.10453 .4459 L
.10465 .43653 L
.10487 .42158 L
.10537 .37584 L
.10631 .26639 L
.10654 .23385 L
.1066 .22178 L
.10663 .21577 L
.10666 .20942 L
.10669 .20461 L
.10671 .20293 L
.10672 .20137 L
.10675 .19845 L
.10678 .19585 L
.1068 .1955 L
.10682 .19513 L
.10685 .19448 L
.10687 .19411 L
.10689 .19267 L
.10692 .18904 L
.10695 .186 L
.10698 .18337 L
.107 .18243 L
.10702 .18157 L
.10703 .18075 L
.10705 .17988 L
Mistroke
.10708 .17698 L
.10711 .17311 L
.10718 .16405 L
.1073 .14622 L
.10736 .13742 L
.10742 .12722 L
.10744 .12465 L
.10746 .1227 L
.10747 .12156 L
.10749 .1205 L
.10751 .11953 L
.10753 .11849 L
.10756 .11734 L
.10759 .11709 L
.10761 .11695 L
.10762 .11681 L
.10765 .11586 L
.10767 .11486 L
.10768 .11378 L
.10771 .1119 L
.10774 .11108 L
.10777 .11247 L
.1078 .11398 L
.10783 .11552 L
.10786 .11506 L
.10789 .11463 L
.10791 .11419 L
.10794 .11249 L
.10797 .11025 L
.108 .10784 L
.10802 .10647 L
.10804 .10687 L
.10806 .10781 L
.10809 .10883 L
.10812 .10979 L
.10814 .1089 L
.10817 .10787 L
.1082 .10676 L
.10823 .10505 L
.10825 .10309 L
.10828 .10104 L
.10831 .09932 L
.10834 .10174 L
.10837 .10399 L
.10839 .1052 L
.10841 .10631 L
.10844 .10581 L
.10846 .10536 L
.1085 .10486 L
.10852 .10922 L
Mistroke
.10855 .11376 L
.10858 .11856 L
.10861 .12062 L
.10864 .12018 L
.10867 .11973 L
.10869 .11941 L
.10872 .12037 L
.10875 .12159 L
.10877 .12219 L
.10878 .12274 L
.10881 .12562 L
.10884 .12886 L
.10898 .13933 L
.10909 .14622 L
.10922 .1516 L
.10925 .15382 L
.10927 .15459 L
.10931 .1537 L
.10933 .1529 L
.10935 .15243 L
.10937 .15234 L
.10938 .15247 L
.1094 .15261 L
.10943 .15285 L
.10945 .15298 L
.10946 .15376 L
.10969 .16755 L
.10972 .17027 L
.10975 .1722 L
.10978 .17233 L
.10981 .17245 L
.10987 .17267 L
.1099 .17279 L
.10992 .17289 L
.10995 .17434 L
.10997 .17656 L
.11002 .18147 L
.11008 .18928 L
.1101 .19316 L
.11013 .1962 L
.11016 .19752 L
.11018 .19872 L
.11021 .20001 L
.11024 .19924 L
.11026 .1975 L
.11029 .19563 L
.11031 .19456 L
.11032 .19512 L
.11035 .19704 L
.11038 .19892 L
Mistroke
.1104 .19991 L
.11042 .20063 L
.11043 .20097 L
.11045 .2013 L
.11048 .20193 L
.11051 .20211 L
.11054 .20072 L
.11057 .19908 L
.1106 .19755 L
.11063 .19816 L
.11066 .19906 L
.11069 .19994 L
.11071 .19956 L
.11072 .19886 L
.11075 .1976 L
.11078 .19624 L
.11081 .1958 L
.11084 .19569 L
.11087 .19557 L
.1109 .19571 L
.11091 .19598 L
.11093 .19622 L
.11096 .19677 L
.111 .19743 L
.11103 .19829 L
.11105 .19868 L
.11107 .1991 L
.1111 .20107 L
.1121 .28154 L
.1126 .31493 L
.11306 .35622 L
.1133 .37191 L
.11351 .38563 L
.11354 .38626 L
.11357 .38725 L
.1136 .38925 L
.11362 .3911 L
.11365 .39325 L
.11368 .39238 L
.11371 .391 L
.11374 .38947 L
.11376 .38873 L
.11377 .3888 L
.1138 .38892 L
.11382 .38898 L
.11383 .38905 L
.11385 .38905 L
.11387 .38851 L
.1139 .38748 L
.11393 .3865 L
Mistroke
.11396 .38679 L
.11399 .38845 L
.1141 .39643 L
.11416 .40124 L
.11419 .40316 L
.11422 .40493 L
.11423 .40594 L
.11425 .40461 L
.11429 .40178 L
.1143 .40055 L
.11432 .39922 L
.11435 .398 L
.11438 .39752 L
.1144 .39708 L
.11444 .39659 L
.11447 .39606 L
.11448 .3958 L
.1145 .39555 L
.11453 .39568 L
.11456 .39699 L
.11459 .39841 L
.1146 .39921 L
.11462 .39991 L
.11463 .40037 L
.11465 .40088 L
.11468 .40171 L
.1147 .40215 L
.11471 .40236 L
.11473 .40173 L
.11475 .40115 L
.11478 .4 L
.11481 .39906 L
.11484 .39906 L
.11487 .39906 L
.11489 .39906 L
.11491 .399 L
.11494 .39874 L
.11496 .3986 L
.11497 .39848 L
.115 .39861 L
.11502 .39935 L
.11503 .40014 L
.11506 .40157 L
.11509 .4029 L
.11512 .40329 L
.11514 .40372 L
.1152 .40474 L
.11523 .40551 L
.11526 .40623 L
.11529 .40662 L
Mistroke
.11531 .40649 L
.11533 .40635 L
.11536 .4061 L
.11539 .40599 L
.11542 .4061 L
.11545 .40621 L
.11547 .40632 L
.1155 .40709 L
.11556 .40896 L
.11561 .41026 L
.11563 .41059 L
.11565 .4109 L
.11568 .41076 L
.1157 .40923 L
.11573 .40761 L
.11575 .40607 L
.11578 .40656 L
.1158 .40841 L
.11583 .41042 L
.11586 .412 L
.11589 .41148 L
.11684 .3915 L
.11687 .39209 L
.11689 .39265 L
.11692 .39242 L
.11694 .39186 L
.11695 .39127 L
.11697 .39062 L
.11699 .39001 L
.117 .3895 L
.11702 .38963 L
.11705 .38989 L
.11708 .39012 L
.11711 .38979 L
.11714 .38877 L
.1172 .38663 L
.11732 .38356 L
.11752 .37724 L
.11755 .3751 L
.11758 .3734 L
.11761 .37329 L
.11764 .37316 L
.11767 .37305 L
.11769 .37107 L
.11775 .36589 L
.11798 .35093 L
.11801 .34963 L
.11804 .34823 L
.11807 .34632 L
.11809 .34369 L
Mistroke
.11815 .33787 L
.11819 .33406 L
.11822 .3299 L
.11824 .32793 L
.11825 .32662 L
.11829 .32612 L
.1183 .32582 L
.11832 .32554 L
.11834 .32529 L
.11835 .32424 L
.11841 .31953 L
.11843 .31824 L
.11845 .31749 L
.11848 .31724 L
.1185 .3171 L
.11851 .31698 L
.11854 .31701 L
.11857 .31801 L
.11859 .31859 L
.11861 .31911 L
.11864 .3194 L
.11867 .31713 L
.11872 .31305 L
.11884 .30677 L
.11887 .30665 L
.1189 .30654 L
.11892 .30573 L
.11895 .30249 L
.11898 .2993 L
.119 .29592 L
.11903 .29444 L
.11906 .29376 L
.11909 .29302 L
.11912 .29121 L
.11915 .28807 L
.11917 .28631 L
.11919 .28468 L
.11922 .28442 L
.11923 .28576 L
.11925 .28719 L
.11927 .2887 L
.11929 .29012 L
.11931 .29034 L
.11932 .28937 L
.11935 .2876 L
.11937 .28664 L
.11939 .28573 L
.11942 .28266 L
.11945 .27889 L
.11948 .27515 L
Mistroke
.11951 .27355 L
.11953 .27303 L
.11956 .27245 L
.11969 .2702 L
.12015 .24441 L
.12021 .23629 L
.12023 .23399 L
.12025 .23153 L
.12028 .22947 L
.12031 .22782 L
.12033 .22689 L
.12035 .22626 L
.12037 .22745 L
.12039 .22874 L
.12042 .23099 L
.12053 .24499 L
.1206 .25215 L
.12062 .25419 L
.12063 .25612 L
.12065 .25618 L
.12067 .25598 L
.1207 .25561 L
.12071 .25541 L
.12073 .25522 L
.12076 .25786 L
.12079 .26045 L
.12082 .26311 L
.12084 .2627 L
.12087 .26049 L
.1209 .25814 L
.12093 .2569 L
.12095 .25717 L
.12097 .25742 L
.12102 .25874 L
.12106 .26141 L
.12107 .26287 L
.12109 .26424 L
.12112 .26518 L
.12114 .26396 L
.12116 .26265 L
.12118 .26049 L
.12121 .25896 L
.12124 .26049 L
.12127 .26217 L
.1213 .26399 L
.12131 .26386 L
.12133 .26312 L
.12136 .26166 L
.12139 .26031 L
.12141 .26084 L
Mistroke
.12144 .26274 L
.1215 .26662 L
.12155 .26907 L
.12158 .27046 L
.12161 .27088 L
.12182 .26549 L
.12185 .26441 L
.12187 .26385 L
.12189 .26353 L
.12192 .26328 L
.12194 .26306 L
.12197 .26285 L
.122 .26346 L
.12202 .26412 L
.12205 .26483 L
.12207 .26538 L
.12209 .26627 L
.12212 .26801 L
.12218 .2711 L
.12231 .27795 L
.12233 .27986 L
.12236 .28089 L
.12238 .28039 L
.1224 .27985 L
.12243 .27889 L
.12246 .27882 L
.12249 .2826 L
.12251 .28586 L
.12254 .28938 L
.12257 .28948 L
.1226 .28888 L
.12263 .28829 L
.12266 .28681 L
.12272 .28212 L
.12274 .28084 L
.12275 .28018 L
.12279 .279 L
.12285 .27681 L
.12288 .27591 L
.12291 .27508 L
.12293 .2749 L
.12295 .27601 L
.12298 .27837 L
.12302 .28033 L
.12303 .28013 L
.12305 .27895 L
.12308 .27675 L
.12311 .2747 L
.12314 .27578 L
.12315 .27729 L
Mistroke
.12317 .27891 L
.1232 .28178 L
.12323 .28312 L
.12325 .28312 L
.12328 .28312 L
.12331 .28318 L
.12333 .28366 L
.12334 .28411 L
.12338 .28502 L
.1234 .28553 L
.12341 .28531 L
.12344 .28318 L
.12347 .28086 L
.12353 .27779 L
.12366 .27295 L
.12372 .2708 L
.12375 .27003 L
.12378 .26918 L
.12381 .26982 L
.12383 .27094 L
.12386 .2722 L
.12389 .27317 L
.12392 .27317 L
.12394 .27317 L
.12397 .27317 L
.12401 .27212 L
.12403 .27095 L
.12407 .26969 L
.12408 .26871 L
.1241 .26759 L
.12413 .26539 L
.12416 .26325 L
.12418 .26412 L
.1242 .26591 L
.12423 .26976 L
.12425 .27165 L
.12427 .27324 L
.1243 .27419 L
.12433 .27521 L
.12436 .27608 L
.12438 .27605 L
.12441 .2758 L
.12444 .27558 L
.12448 .27583 L
.12449 .27618 L
.12451 .2765 L
.12454 .27708 L
.12457 .27817 L
.12458 .27901 L
.1246 .27992 L
Mistroke
.12463 .28153 L
.12466 .28204 L
.12469 .2813 L
.12472 .28065 L
.12475 .27999 L
.12479 .27941 L
.1248 .27914 L
.12482 .27886 L
.12484 .2786 L
.12485 .27874 L
.12488 .27923 L
.12501 .28199 L
.12506 .28513 L
.1251 .28748 L
.12511 .28877 L
.12513 .28998 L
.12514 .29037 L
.12516 .29077 L
.12519 .29146 L
.12525 .29324 L
.12527 .2945 L
.1253 .29568 L
.12533 .29604 L
.12536 .29444 L
.12539 .29308 L
.12541 .29179 L
.12544 .29221 L
.12546 .29293 L
.12549 .29371 L
.12552 .2951 L
.12555 .2971 L
.12557 .29932 L
.1256 .30169 L
.12562 .29991 L
.12564 .29783 L
.12567 .29376 L
.12569 .28996 L
.12572 .28839 L
.12575 .28768 L
.12577 .28727 L
.12578 .28689 L
.12581 .28683 L
.12584 .28733 L
.12587 .2878 L
.12589 .28804 L
.12591 .28794 L
.12592 .28773 L
.12594 .28754 L
.12597 .28721 L
.126 .28698 L
Mistroke
.12603 .28709 L
.12605 .2872 L
.12608 .2873 L
.1261 .28793 L
.12615 .28983 L
.12618 .29059 L
.12621 .28917 L
.12624 .28764 L
.12626 .28683 L
.12627 .28597 L
.1263 .2871 L
.12633 .28847 L
.12638 .29099 L
.12641 .29146 L
.12643 .29171 L
.12645 .29197 L
.12648 .29283 L
.1265 .29437 L
.12656 .29775 L
.1266 .29966 L
.12663 .30144 L
.12665 .30238 L
.12666 .30265 L
.12668 .30096 L
.1267 .29937 L
.12671 .29761 L
.12673 .29575 L
.12675 .29416 L
.12677 .29342 L
.1268 .29253 L
.12683 .2917 L
.12685 .29123 L
.12686 .29116 L
.12688 .29116 L
.1269 .29116 L
.12692 .29116 L
.12695 .291 L
.12697 .29075 L
.12699 .29049 L
.12702 .29001 L
.12704 .28929 L
.12707 .28714 L
.12713 .28328 L
.12716 .28174 L
.12719 .28032 L
.12722 .27898 L
.12725 .27944 L
.12726 .28032 L
.12728 .28112 L
.1273 .282 L
Mistroke
.12731 .28295 L
.12735 .28383 L
.12736 .28411 L
.12738 .28436 L
.12741 .28484 L
.12743 .28536 L
.12744 .28645 L
.12747 .2886 L
.1275 .29058 L
.12751 .29171 L
.12753 .29171 L
.12755 .29144 L
.12757 .29115 L
.12758 .2909 L
.1276 .29063 L
.12763 .29139 L
.12766 .29335 L
.12768 .29438 L
.12769 .29547 L
.12772 .29645 L
.12775 .29634 L
.12778 .29623 L
.12781 .29631 L
.12783 .29837 L
.12787 .30059 L
.12831 .32794 L
.12843 .33488 L
.12845 .33515 L
.12847 .33543 L
.12848 .33679 L
.1285 .33874 L
.12853 .34267 L
.12856 .34635 L
.12859 .34796 L
.12861 .34885 L
.12864 .34976 L
.12867 .35057 L
.12869 .35077 L
.12871 .35095 L
.12874 .35132 L
.12876 .35163 L
.12879 .35174 L
.12882 .35187 L
.12884 .35194 L
.12886 .35194 L
.12889 .35134 L
.12892 .35071 L
.12895 .35014 L
.12897 .35103 L
.12903 .35345 L
Mistroke
.1293 .36494 L
.12942 .37129 L
.12945 .37275 L
.12949 .37402 L
.12952 .37511 L
.12954 .37547 L
.12955 .37565 L
.12958 .37602 L
.12961 .37636 L
.12964 .37648 L
.12966 .37648 L
.1297 .37648 L
.12971 .37648 L
.12973 .37702 L
.12976 .3782 L
.12979 .37944 L
.12982 .38013 L
.12985 .37917 L
.12987 .37828 L
.1299 .37747 L
.12993 .37753 L
.12995 .37772 L
.12996 .37791 L
.12999 .37824 L
.13002 .37935 L
.13013 .3847 L
.13024 .39122 L
.13045 .40281 L
.13056 .40795 L
.13063 .41202 L
.13066 .41407 L
.13068 .41494 L
.13071 .41444 L
.13075 .41392 L
.13076 .41364 L
.13078 .41422 L
.13082 .41554 L
.13085 .41674 L
.13086 .41735 L
.13088 .41749 L
.13091 .41761 L
.13094 .41772 L
.13097 .41803 L
.131 .41873 L
.13103 .41937 L
.13105 .42004 L
.13109 .41795 L
.13111 .41577 L
.13113 .41443 L
.13115 .41318 L
Mistroke
.13118 .41252 L
.13162 .40242 L
.13168 .39998 L
.13171 .39851 L
.13174 .39804 L
.13176 .39816 L
.13177 .3983 L
.13179 .39844 L
.13181 .39858 L
.13184 .39854 L
.13185 .39841 L
.13187 .39828 L
.1319 .39803 L
.13193 .39769 L
.13196 .39721 L
.13198 .39694 L
.13199 .39668 L
.13202 .39546 L
.13205 .39299 L
.13211 .38745 L
.13258 .35199 L
.13283 .33814 L
.13284 .33929 L
.13286 .34055 L
.13288 .34113 L
.13289 .34076 L
.13293 .33987 L
.13295 .33946 L
.13296 .33906 L
.13298 .3377 L
.133 .33595 L
.13303 .33289 L
.13309 .3272 L
.13332 .30264 L
.13357 .26985 L
.13381 .24199 L
.13394 .22999 L
.13401 .22241 L
.13404 .21933 L
.13408 .21667 L
.13411 .21414 L
.13412 .21342 L
.13414 .21329 L
.13417 .21303 L
.13419 .21288 L
.13421 .21275 L
.13422 .21258 L
.13424 .21237 L
.13427 .21202 L
.1343 .21167 L
Mistroke
.13432 .20975 L
.13438 .20446 L
.13444 .19893 L
.13447 .19642 L
.1345 .19435 L
.13453 .19435 L
.13456 .19435 L
.13457 .19435 L
.13459 .19435 L
.13461 .19354 L
.13462 .19262 L
.13465 .19083 L
.13468 .18916 L
.13471 .19131 L
.13474 .19407 L
.13477 .19683 L
.13479 .19815 L
.1348 .19797 L
.13483 .19758 L
.13485 .19737 L
.13487 .19717 L
.1349 .19649 L
.13493 .19548 L
.13494 .19491 L
.13496 .19438 L
.13499 .19539 L
.13501 .19672 L
.13503 .19795 L
.13504 .19928 L
.13506 .20072 L
.13509 .20152 L
.13512 .20187 L
.13515 .2022 L
.13517 .20227 L
.13521 .2019 L
.13523 .20156 L
.13525 .20138 L
.13526 .20149 L
.13529 .20293 L
.13532 .2043 L
.13535 .20558 L
.13538 .20439 L
.13541 .20243 L
.13543 .20076 L
.13546 .19981 L
.13549 .20015 L
.13551 .20045 L
.13554 .2008 L
.13557 .20024 L
.1356 .19959 L
Mistroke
.13563 .1989 L
.13566 .19929 L
.13569 .20051 L
.1357 .20122 L
.13572 .20198 L
.13575 .20282 L
.13577 .20289 L
.13578 .20296 L
.13581 .20308 L
.13583 .20315 L
.13585 .20216 L
.13588 .19968 L
.13595 .19567 L
.13598 .1943 L
.13601 .19282 L
.13604 .19292 L
.13607 .19459 L
.13609 .19629 L
.13612 .19769 L
.13615 .1958 L
.13618 .1937 L
.13621 .19166 L
.13623 .19171 L
.13624 .19227 L
.13646 .20342 L
.13696 .22166 L
.13791 .26683 L
.13882 .30083 L
.1398 .34185 L
.14001 .35512 L
.14004 .35559 L
.14007 .35717 L
.1401 .35898 L
.14013 .36065 L
.14016 .36303 L
.14019 .36567 L
.14022 .36815 L
.14025 .36889 L
.14028 .36817 L
.1403 .3675 L
.14033 .36709 L
.14035 .36757 L
.14037 .36801 L
.1404 .36895 L
.14043 .3696 L
.14045 .3696 L
.14046 .3696 L
.14048 .3696 L
.1405 .3696 L
.14053 .3707 L
Mistroke
.14055 .37236 L
.14056 .37412 L
.14059 .37733 L
.14062 .37958 L
.14065 .37968 L
.14067 .37979 L
.14071 .37991 L
.14073 .38021 L
.14076 .38057 L
.14078 .38077 L
.1408 .38095 L
.14083 .38092 L
.14085 .3807 L
.14087 .38057 L
.14089 .38044 L
.14092 .37896 L
.14093 .37735 L
.14095 .37585 L
.14096 .37421 L
.14098 .37243 L
.141 .37126 L
.14102 .37178 L
.14105 .37281 L
.14108 .37375 L
.14111 .37287 L
.14113 .37152 L
.14115 .37007 L
.14116 .36879 L
.14118 .36744 L
.1412 .36751 L
.14121 .36864 L
.14125 .37063 L
.14137 .38007 L
.1414 .38236 L
.14143 .38421 L
.14146 .38587 L
.14148 .38616 L
.1415 .38555 L
.14161 .38118 L
.14164 .38018 L
.14167 .37919 L
.14168 .37953 L
.1417 .37984 L
.14173 .38045 L
.14176 .38099 L
.14178 .38032 L
.14181 .37934 L
.14184 .37843 L
.14187 .37934 L
.14189 .38181 L
Mistroke
.14192 .38469 L
.14195 .38742 L
.14198 .38699 L
.14201 .38642 L
.14204 .38581 L
.14206 .38587 L
.14207 .3862 L
.1421 .38675 L
.14213 .38735 L
.14216 .38778 L
.14219 .38809 L
.14221 .38844 L
.14224 .38822 L
.14228 .3857 L
.14229 .38425 L
.14231 .38294 L
.14233 .38157 L
.14234 .38116 L
.14236 .38129 L
.14238 .38144 L
.1424 .38157 L
.14241 .38171 L
.14244 .38121 L
.14247 .37996 L
.1425 .37862 L
.14256 .37567 L
.14259 .37365 L
.14261 .37265 L
.14262 .37197 L
.14265 .37278 L
.14268 .37365 L
.14274 .37511 L
.14278 .37576 L
.14281 .37637 L
.14282 .37632 L
.14284 .37605 L
.14287 .37547 L
.14289 .3752 L
.14291 .37486 L
.14294 .37134 L
.14299 .36486 L
.14305 .3574 L
.14308 .35346 L
.1431 .35174 L
.14312 .3524 L
.14315 .35354 L
.14318 .35479 L
.14321 .35515 L
.14323 .35451 L
.14329 .35313 L
Mistroke
.14339 .34979 L
.14342 .3487 L
.14345 .34768 L
.14348 .34676 L
.1435 .34762 L
.14353 .34883 L
.14355 .3495 L
.14357 .35012 L
.14359 .34919 L
.14362 .34714 L
.14365 .34509 L
.14367 .34405 L
.14369 .34409 L
.14372 .34432 L
.14374 .34455 L
.14381 .34505 L
.14382 .34519 L
.14384 .34533 L
.14386 .34546 L
.14387 .3461 L
.14399 .35176 L
.14402 .35348 L
.14405 .35506 L
.14408 .35517 L
.14411 .3553 L
.14423 .35578 L
.14428 .35599 L
.14434 .35629 L
.14439 .35729 L
.14442 .35786 L
.14445 .35701 L
.14448 .35445 L
.1445 .35201 L
.14453 .34978 L
.14456 .35057 L
.14459 .35152 L
.14462 .35253 L
.14464 .35261 L
.14465 .35232 L
.14469 .35181 L
.14472 .35133 L
.14473 .35055 L
.14475 .34957 L
.14478 .34763 L
.14481 .34584 L
.14483 .34523 L
.14486 .34546 L
.14489 .34569 L
.14492 .34567 L
.14495 .34502 L
Mistroke
.14498 .34431 L
.14501 .34365 L
.14503 .34349 L
.14506 .34337 L
.14509 .34324 L
.14512 .34215 L
.14515 .34054 L
.14518 .33863 L
.1452 .33756 L
.14521 .33799 L
.14525 .33914 L
.14528 .34023 L
.1453 .34017 L
.14534 .33794 L
.1454 .33325 L
.14553 .32518 L
.14556 .32378 L
.1456 .32253 L
.14562 .32175 L
.14565 .32093 L
.14567 .32047 L
.14569 .31908 L
.14572 .31529 L
.14575 .31154 L
.14578 .30872 L
.1458 .30858 L
.14581 .30844 L
.14583 .30829 L
.14585 .30815 L
.14586 .30803 L
.14588 .3076 L
.14592 .30651 L
.14594 .30558 L
.14598 .30409 L
.14599 .30272 L
.14601 .30146 L
.14603 .30016 L
.14604 .29899 L
.14607 .29821 L
.1461 .2996 L
.14616 .30194 L
.14619 .3023 L
.14622 .30269 L
.14624 .30289 L
.14626 .30351 L
.14628 .30464 L
.14629 .3057 L
.14632 .30773 L
.14635 .30945 L
.14636 .30888 L
Mistroke
.14638 .30826 L
.14641 .30718 L
.14653 .30274 L
.14751 .26236 L
.14845 .22613 L
.14851 .22864 L
.14852 .22937 L
.14854 .23006 L
.14857 .22845 L
.14859 .22622 L
.14862 .22417 L
.14865 .22345 L
.14868 .22594 L
.1487 .22817 L
.14873 .23057 L
.14876 .2288 L
.14879 .22693 L
.14881 .22589 L
.14883 .22476 L
.14884 .22257 L
.14886 .22032 L
.14889 .21612 L
.14892 .21157 L
.14895 .20877 L
.14898 .2065 L
.149 .20437 L
.14903 .20274 L
.14906 .20263 L
.14908 .20254 L
.1491 .20244 L
.14913 .2002 L
.14916 .19546 L
.14919 .19032 L
.14922 .18679 L
.14925 .18712 L
.14927 .18744 L
.1493 .18774 L
.14933 .18764 L
.14935 .18729 L
.14938 .18697 L
.14941 .18682 L
.14944 .18732 L
.14947 .18778 L
.1495 .18821 L
.14952 .18908 L
.14958 .19107 L
.1497 .19711 L
.14976 .19932 L
.14979 .20073 L
.14982 .2037 L
Mistroke
.14985 .20689 L
.14988 .2098 L
.14991 .20924 L
.14993 .20876 L
.14994 .2083 L
.14997 .2075 L
.15 .20606 L
.15006 .20244 L
.15012 .19705 L
.15014 .1955 L
.15015 .19385 L
.15018 .19211 L
.1502 .19176 L
.15022 .19144 L
.15025 .1907 L
.15029 .19002 L
.15032 .1894 L
.15035 .18879 L
.15037 .18877 L
.15038 .18918 L
.15042 .18997 L
.15043 .19041 L
.15045 .19082 L
.15047 .19096 L
.15048 .19103 L
.15051 .19115 L
.15055 .19128 L
.15057 .18812 L
.15061 .1841 L
.15064 .18031 L
.15066 .18065 L
.15069 .18341 L
.15072 .18642 L
.15074 .18794 L
.15075 .1876 L
.15079 .18625 L
.15081 .18499 L
.15084 .18428 L
.15087 .18562 L
.1509 .1868 L
.15093 .18805 L
.15095 .1878 L
.15098 .18724 L
.151 .18676 L
.15103 .18636 L
.15106 .18672 L
.15109 .18705 L
.15112 .18741 L
.15113 .18853 L
.15115 .18991 L
Mistroke
.15118 .19237 L
.1512 .1947 L
.15123 .19527 L
.15126 .19428 L
.15129 .19328 L
.15132 .19304 L
.15135 .19564 L
.15137 .198 L
.15144 .20432 L
.15147 .20766 L
.1515 .2107 L
.15152 .2108 L
.15156 .20968 L
.15157 .20908 L
.15159 .20845 L
.15161 .20819 L
.15162 .20831 L
.15165 .20855 L
.15168 .20878 L
.15171 .20889 L
.15173 .20889 L
.15174 .20889 L
.15177 .20889 L
.1518 .20957 L
.15183 .21186 L
.15186 .2143 L
.15197 .22429 L
.15219 .24306 L
.15221 .24656 L
.15224 .25031 L
.15227 .25368 L
.1523 .25398 L
.15232 .2543 L
.15235 .25464 L
.15238 .25613 L
.15241 .25836 L
.15244 .26081 L
.15246 .26204 L
.15248 .26159 L
.15251 .26077 L
.15254 .25989 L
.15257 .25985 L
.1526 .26077 L
.15265 .26274 L
.15271 .26696 L
.15274 .26934 L
.15276 .26941 L
.15279 .26846 L
.15281 .26741 L
.15284 .26632 L
Mistroke
.15287 .26822 L
.15297 .27612 L
.153 .27799 L
.15303 .27975 L
.15305 .27964 L
.15306 .27897 L
.15309 .27779 L
.15312 .27665 L
.15315 .27751 L
.15317 .27847 L
.15319 .27949 L
.15322 .28134 L
.15325 .28456 L
.15328 .28829 L
.15333 .29519 L
.15344 .30698 L
.15347 .30963 L
.1535 .31244 L
.15353 .3142 L
.15355 .31441 L
.15358 .31466 L
.1536 .31478 L
.15362 .3153 L
.15365 .31776 L
.15367 .32005 L
.15374 .32564 L
.15377 .32808 L
.15379 .32936 L
.15381 .33043 L
.15384 .33155 L
.15387 .33259 L
.1539 .33356 L
.15392 .33564 L
.15396 .33788 L
.15397 .33905 L
.15399 .34029 L
.15402 .34097 L
.15405 .34143 L
.15411 .34251 L
.15414 .34311 L
.15417 .34367 L
.1542 .34481 L
.15422 .34696 L
.15428 .35149 L
.15441 .36297 L
.15444 .36659 L
.15447 .37002 L
.15449 .37141 L
.15452 .37236 L
.15455 .37318 L
Mistroke
.15458 .37384 L
.1546 .37394 L
.15463 .37403 L
.15465 .37414 L
.15468 .37473 L
.15471 .37561 L
.15473 .37642 L
.15476 .37738 L
.15479 .37925 L
.15485 .38349 L
.15497 .39022 L
.15522 .40698 L
.15528 .41112 L
.15531 .41416 L
.15534 .41669 L
.15537 .41806 L
.1554 .41953 L
.15543 .42116 L
.15546 .42093 L
.15548 .4206 L
.15551 .4203 L
.15554 .42116 L
.15557 .42389 L
.15559 .42648 L
.15562 .4289 L
.15564 .42881 L
.15567 .4287 L
.1557 .42859 L
.15573 .42889 L
.15574 .42933 L
.15576 .42979 L
.15579 .43063 L
.15582 .43067 L
.15585 .42908 L
.1559 .42612 L
.15596 .41701 L
.15599 .41194 L
.156 .40971 L
.15602 .40924 L
.15605 .40839 L
.15608 .4076 L
.15611 .40716 L
.15613 .40738 L
.15617 .40763 L
.1562 .40787 L
.15622 .4083 L
.15625 .40876 L
.15627 .40903 L
.15628 .40929 L
.1563 .40852 L
Mistroke
.15632 .40693 L
.15635 .40432 L
.15636 .40294 L
.15638 .40148 L
.15641 .40174 L
.15644 .40262 L
.15647 .40353 L
.15649 .40317 L
.15652 .40105 L
.15654 .39875 L
.15657 .39659 L
.15659 .39706 L
.15662 .39895 L
.15665 .40101 L
.15669 .40238 L
.15671 .40294 L
.15674 .40349 L
.15677 .40401 L
.15679 .40363 L
.15682 .40315 L
.15685 .4027 L
.15688 .4008 L
.15691 .39724 L
.15694 .3935 L
.15697 .39098 L
.15699 .39232 L
.15703 .39389 L
.15706 .39523 L
.15708 .39523 L
.15711 .39523 L
.15714 .39523 L
.15716 .39459 L
.15722 .39197 L
.15725 .39075 L
.15728 .39175 L
.15731 .39285 L
.15733 .3939 L
.15736 .39374 L
.15739 .39327 L
.15752 .39092 L
.15758 .38944 L
.1576 .38906 L
.15761 .38866 L
.15763 .38901 L
.15765 .39111 L
.15768 .39486 L
.1577 .39691 L
.15771 .39882 L
.15774 .39904 L
.15777 .39781 L
Mistroke
.15822 .3781 L
.15846 .36802 L
.15871 .35838 L
.15877 .35667 L
.15884 .35407 L
.15885 .35329 L
.15887 .3521 L
.15889 .34992 L
.15891 .34755 L
.15894 .34287 L
.15896 .34084 L
.15897 .33936 L
.15901 .33719 L
.15904 .33515 L
.15905 .33401 L
.15907 .33363 L
.1591 .33363 L
.15913 .33363 L
.15916 .33316 L
.15919 .32956 L
.15922 .32571 L
.15935 .31343 L
.15947 .30344 L
.1595 .29957 L
.15953 .29594 L
.15955 .29328 L
.15958 .29102 L
.15961 .28875 L
.15963 .28747 L
.15965 .2888 L
.15967 .29178 L
.1597 .29501 L
.15974 .29683 L
.15976 .29276 L
.15979 .28913 L
.15982 .28514 L
.15985 .28545 L
.15987 .28626 L
.15988 .28702 L
.15991 .28837 L
.15994 .28862 L
.15997 .28828 L
.16 .28792 L
.16003 .28742 L
.16005 .28678 L
.16008 .28619 L
.1601 .28557 L
.16013 .28446 L
.16016 .28332 L
.16019 .28196 L
Mistroke
.16021 .28116 L
.16022 .27953 L
.16026 .27633 L
.16029 .27342 L
.16031 .27143 L
.16034 .2709 L
.16037 .27033 L
.1604 .26967 L
.16043 .26756 L
.16046 .26533 L
.16049 .26326 L
.16052 .263 L
.16055 .26275 L
.16057 .26261 L
.16059 .26249 L
.1606 .25991 L
.16062 .2565 L
.16066 .25052 L
.16072 .2414 L
.16075 .23724 L
.16078 .23335 L
.16079 .23352 L
.16081 .2342 L
.16085 .23564 L
.16091 .23816 L
.16103 .24428 L
.16109 .2474 L
.16112 .24846 L
.16115 .24963 L
.16118 .25043 L
.1612 .25085 L
.16123 .2513 L
.16126 .25162 L
.16129 .24929 L
.16132 .24716 L
.16135 .24486 L
.16137 .24433 L
.16138 .24414 L
.16149 .2428 L
.16154 .24222 L
.1616 .24157 L
.16163 .24121 L
.16165 .24109 L
.16168 .24121 L
.16172 .24134 L
.16175 .24148 L
.16179 .24162 L
.16182 .24174 L
.16183 .24179 L
.16185 .24166 L
Mistroke
.16188 .24141 L
.16191 .24118 L
.16194 .24073 L
.16196 .2397 L
.16199 .23858 L
.16201 .23802 L
.16203 .23787 L
.16206 .23946 L
.16209 .24094 L
.16214 .24405 L
.16217 .24565 L
.1622 .24712 L
.16222 .24761 L
.16225 .2468 L
.1623 .24508 L
.16253 .23545 L
.16256 .23117 L
.16259 .22659 L
.16262 .22591 L
.16264 .22611 L
.16267 .22634 L
.1627 .22638 L
.16273 .22591 L
.16276 .22541 L
.16277 .22517 L
.16279 .2251 L
.16281 .22566 L
.16282 .22618 L
.16286 .2272 L
.16289 .22798 L
.16291 .22764 L
.16294 .22731 L
.16297 .22697 L
.163 .22697 L
.16303 .22709 L
.16306 .2272 L
.16308 .22745 L
.16311 .22788 L
.16314 .22836 L
.16317 .229 L
.1632 .23017 L
.16323 .23146 L
.16344 .2417 L
.16347 .24416 L
.1635 .24516 L
.16354 .24625 L
.16357 .24707 L
.16359 .24762 L
.16362 .24821 L
.16364 .24855 L
Mistroke
.16366 .24848 L
.16369 .24775 L
.16371 .24712 L
.16374 .24644 L
.16377 .24464 L
.1638 .24291 L
.16383 .24114 L
.16386 .24042 L
.16388 .24012 L
.16391 .23979 L
.16394 .23972 L
.16397 .24054 L
.16404 .24245 L
.1641 .24453 L
.16412 .24513 L
.16414 .24615 L
.16417 .24827 L
.16441 .26019 L
.16465 .26977 L
.16468 .27061 L
.16471 .27228 L
.16472 .27437 L
.16474 .27665 L
.16477 .28066 L
.1648 .28348 L
.16482 .28341 L
.16483 .28335 L
.16486 .28323 L
.16489 .28298 L
.16494 .27809 L
.16497 .27563 L
.165 .27518 L
.16503 .27659 L
.16505 .27811 L
.1651 .28043 L
.16513 .28151 L
.16516 .28253 L
.16519 .28244 L
.16521 .28032 L
.16524 .27801 L
.16526 .27674 L
.16528 .27624 L
.16531 .27918 L
.16533 .28184 L
.16536 .28454 L
.16539 .28504 L
.16542 .28504 L
.16545 .28504 L
.16548 .2852 L
.16549 .2854 L
Mistroke
.16551 .28559 L
.16557 .28627 L
.1656 .28651 L
.16561 .28663 L
.16563 .28676 L
.16566 .28713 L
.16569 .28792 L
.16572 .2888 L
.16575 .28962 L
.16577 .29151 L
.16578 .29355 L
.16582 .29785 L
.16585 .30151 L
.16587 .30261 L
.16594 .3051 L
.16599 .30706 L
.16602 .30809 L
.16605 .3089 L
.16608 .30924 L
.1661 .30954 L
.16613 .30985 L
.16615 .31044 L
.16618 .31115 L
.1662 .3119 L
.16623 .31232 L
.16626 .3109 L
.16629 .30936 L
.16632 .30793 L
.16635 .30725 L
.16638 .30675 L
.16641 .30632 L
.16643 .30671 L
.16646 .30854 L
.16649 .31026 L
.16655 .3148 L
.16658 .31762 L
.16661 .32024 L
.16664 .32078 L
.16667 .32135 L
.16668 .32168 L
.1667 .32199 L
.16673 .32122 L
.16678 .31907 L
.1668 .31797 L
.16683 .31847 L
.16686 .31905 L
.16689 .3196 L
.16691 .32071 L
.16694 .32258 L
.16697 .32462 L
Mistroke
.167 .32641 L
.16703 .32699 L
.16706 .32763 L
.16708 .32818 L
.16711 .32911 L
.16714 .3303 L
.16717 .33137 L
.16719 .33184 L
.16722 .33101 L
.16725 .3303 L
.16728 .32951 L
.16731 .33074 L
.16734 .33229 L
.16737 .33373 L
.1674 .33419 L
.16741 .33431 L
.16743 .33445 L
.16746 .33469 L
.16749 .33231 L
.16752 .32871 L
.16755 .32481 L
.16756 .3226 L
.16758 .32302 L
.16761 .32525 L
.16765 .32765 L
.16768 .3294 L
.1677 .33038 L
.16776 .33259 L
.16782 .33411 L
.16785 .33496 L
.16788 .33384 L
.1679 .33221 L
.16793 .3305 L
.16796 .32933 L
.16799 .33053 L
.16801 .33157 L
.16803 .33269 L
.16806 .33246 L
.16809 .33112 L
.1681 .33032 L
.16812 .32946 L
.16815 .32884 L
.16818 .33135 L
.16822 .33411 L
.16827 .33808 L
.1683 .33999 L
.16833 .34202 L
.16835 .34129 L
.16837 .34059 L
.1684 .33921 L
Mistroke
.16842 .33854 L
.16844 .33919 L
.16846 .34083 L
.16847 .34234 L
.16854 .34843 L
.16857 .351 L
.1686 .35336 L
.16863 .35495 L
.16865 .35453 L
.16868 .35408 L
.16871 .35361 L
.16874 .35219 L
.16877 .35071 L
.1688 .34912 L
.16882 .3486 L
.16883 .34873 L
.16887 .34897 L
.16888 .3491 L
.1689 .34923 L
.16892 .34913 L
.16895 .34877 L
.16899 .34838 L
.16902 .34787 L
.16905 .34703 L
.16908 .34626 L
.16911 .34629 L
.16914 .34736 L
.16917 .34829 L
.16919 .3493 L
.16921 .34912 L
.16923 .34893 L
.16926 .34856 L
.16929 .34822 L
.16932 .35112 L
.16935 .35472 L
.16937 .35662 L
.16938 .35862 L
.1694 .35803 L
.16942 .35693 L
.16945 .355 L
.16948 .35312 L
.16951 .35297 L
.16954 .35321 L
.16956 .35342 L
.16959 .35258 L
.16962 .35071 L
.16965 .34909 L
.16967 .34743 L
.1697 .34824 L
.16973 .349 L
Mistroke
.16979 .35092 L
.16982 .35194 L
.16985 .35289 L
.16987 .35461 L
.1699 .35787 L
.16993 .36067 L
.16995 .36328 L
.16998 .36474 L
.17001 .36596 L
.17004 .36731 L
.17005 .36807 L
.17007 .36794 L
.1701 .3677 L
.17013 .36747 L
.17014 .36735 L
.17016 .36803 L
.17018 .36929 L
.1702 .37043 L
.17023 .37271 L
.17026 .37427 L
.17029 .3752 L
.17032 .37617 L
.17035 .37676 L
.17037 .37655 L
.17038 .37636 L
.1705 .37496 L
.17055 .37432 L
.17058 .37398 L
.17061 .37363 L
.17064 .37339 L
.17066 .37327 L
.17069 .37317 L
.17071 .37307 L
.17074 .37304 L
.17076 .37304 L
.17078 .37304 L
.17081 .37304 L
.17084 .37451 L
.17086 .37675 L
.17089 .37911 L
.17092 .38076 L
.17095 .38109 L
.17098 .38144 L
.17101 .38182 L
.17102 .38037 L
.17104 .37893 L
.17107 .37611 L
.1711 .37351 L
.17112 .37393 L
.17114 .37442 L
Mistroke
.17119 .37629 L
.17122 .37732 L
.17125 .37849 L
.17128 .3796 L
.1713 .3798 L
.17133 .37797 L
.17136 .37605 L
.17139 .37408 L
.17142 .37336 L
.17145 .37281 L
.17147 .37255 L
.17148 .3723 L
.17151 .3726 L
.17154 .37298 L
.17158 .37336 L
.17159 .37327 L
.17161 .37308 L
.17163 .37287 L
.17165 .37265 L
.17166 .37244 L
.17168 .37237 L
.17171 .37332 L
.17174 .37433 L
.1718 .37652 L
.17183 .37815 L
.17185 .37894 L
.17186 .37968 L
.17189 .37965 L
.17192 .37928 L
.17216 .37199 L
.17222 .36822 L
.17229 .36526 L
.17235 .36325 L
.17238 .36239 L
.17241 .36159 L
.17244 .36084 L
.17247 .36253 L
.1725 .36439 L
.17251 .36545 L
.17253 .36643 L
.17256 .36568 L
.17258 .36484 L
.17259 .36396 L
.17263 .36235 L
.17265 .36325 L
.17268 .36494 L
.17271 .36672 L
.17274 .36803 L
.17277 .36792 L
.17279 .36782 L
Mistroke
.17282 .36771 L
.17285 .36786 L
.17287 .36807 L
.1729 .36831 L
.17293 .36823 L
.17296 .3678 L
.17299 .36732 L
.17302 .36673 L
.17304 .36623 L
.17306 .36577 L
.17312 .36406 L
.17323 .36154 L
.17326 .3611 L
.17329 .36063 L
.1733 .3606 L
.17332 .36146 L
.17335 .36315 L
.17338 .36466 L
.17341 .3653 L
.17343 .36403 L
.17346 .36262 L
.17349 .36111 L
.17352 .3616 L
.17355 .36254 L
.17357 .36341 L
.1736 .36329 L
.17363 .3622 L
.17366 .36089 L
.17368 .35971 L
.17371 .35597 L
.17373 .35231 L
.17376 .3481 L
.17379 .34482 L
.17381 .34336 L
.17384 .3418 L
.1739 .33925 L
.17393 .33804 L
.17394 .3374 L
.17396 .33672 L
.17399 .33614 L
.17402 .33591 L
.17405 .33568 L
.17408 .33464 L
.17411 .33285 L
.17414 .3312 L
.17417 .32972 L
.17419 .32951 L
.1742 .32932 L
.17427 .32843 L
.17433 .32726 L
Mistroke
.17438 .32628 L
.1744 .3259 L
.17443 .3255 L
.17446 .32569 L
.17448 .32691 L
.17451 .32833 L
.17453 .32908 L
.17454 .32991 L
.17457 .33222 L
.1746 .33435 L
.17463 .3366 L
.17466 .33707 L
.17468 .33707 L
.17471 .33707 L
.17474 .33701 L
.17477 .33665 L
.1748 .3363 L
.17483 .33595 L
.17486 .33841 L
.17489 .34066 L
.17491 .34291 L
.17494 .34261 L
.17497 .33955 L
.175 .33629 L
.17503 .33411 L
.17506 .3347 L
.17509 .33533 L
.1751 .33568 L
.17512 .33569 L
.17515 .33392 L
.17518 .33224 L
.17562 .30903 L
.17574 .3106 L
.17576 .31035 L
.17577 .31008 L
.1758 .31044 L
.17584 .31133 L
.17585 .31179 L
.17587 .3123 L
.17589 .31231 L
.1759 .31168 L
.17593 .31044 L
.17599 .30786 L
.17605 .30485 L
.1761 .30062 L
.17654 .26901 L
.17665 .2555 L
.17668 .25278 L
.17671 .24991 L
.17674 .24747 L
Mistroke
.17676 .24799 L
.17678 .24893 L
.1768 .24979 L
.17681 .25071 L
.17683 .25171 L
.17686 .25242 L
.17689 .25278 L
.17692 .25314 L
.17694 .25345 L
.17695 .25419 L
.17701 .25673 L
.17708 .25996 L
.17709 .26088 L
.17711 .26186 L
.17713 .26206 L
.17715 .26103 L
.17718 .259 L
.1772 .25793 L
.17721 .2568 L
.17723 .25667 L
.17725 .25734 L
.17728 .25853 L
.17731 .25977 L
.17734 .26156 L
.17737 .26399 L
.1774 .2662 L
.17743 .26904 L
.17746 .27214 L
.17748 .27552 L
.17752 .27856 L
.17754 .27995 L
.17757 .28122 L
.1776 .28244 L
.17762 .2829 L
.17774 .28541 L
.17777 .28666 L
.1778 .28773 L
.17783 .28785 L
.17786 .28796 L
.17789 .28809 L
.17791 .28608 L
.17792 .28388 L
.17795 .27991 L
.17798 .27566 L
.17801 .27541 L
.17804 .27576 L
.17807 .2761 L
.1781 .27493 L
.17813 .27242 L
.17816 .27009 L
Mistroke
.17818 .26878 L
.17819 .26806 L
.17821 .26741 L
.17823 .26669 L
.17826 .26543 L
.17827 .2648 L
.17829 .26469 L
.17832 .26457 L
.17835 .26445 L
.17837 .26438 L
.17838 .26409 L
.17842 .26347 L
.17848 .26216 L
.17851 .26172 L
.17854 .26124 L
.17857 .2609 L
.1786 .26079 L
.17863 .26067 L
.17864 .2606 L
.17866 .26069 L
.17869 .2631 L
.17872 .26567 L
.17873 .26698 L
.17875 .26836 L
.17877 .26797 L
.17878 .2673 L
.17885 .26478 L
.1789 .26118 L
.17892 .26013 L
.17894 .25914 L
.17896 .26007 L
.17899 .2618 L
.17902 .26364 L
.17905 .26487 L
.17907 .26388 L
.17918 .26071 L
.1792 .26005 L
.17923 .25942 L
.17926 .25964 L
.17929 .25985 L
.17931 .26008 L
.17935 .26207 L
.17936 .26358 L
.17938 .26518 L
.17941 .26808 L
.17944 .26981 L
.17945 .27028 L
.17947 .27072 L
.17954 .2721 L
.17956 .27222 L
Mistroke
.1796 .27235 L
.17963 .2731 L
.17965 .27442 L
.17969 .27598 L
.1797 .27686 L
.17972 .27673 L
.17975 .2761 L
.17978 .2755 L
.1798 .27516 L
.17982 .27531 L
.17983 .27556 L
.17985 .27583 L
.17987 .27611 L
.17989 .27642 L
.1799 .27682 L
.17992 .27743 L
.17995 .27854 L
.17997 .27915 L
.17998 .27972 L
.18001 .282 L
.18004 .28527 L
.18017 .2956 L
.18023 .30054 L
.18026 .30352 L
.18028 .3061 L
.18031 .30634 L
.18035 .3066 L
.18037 .30683 L
.1804 .30696 L
.18044 .30708 L
.18045 .30714 L
.18047 .30721 L
.1805 .30994 L
.18053 .31288 L
.18059 .3194 L
.18063 .32221 L
.18066 .32481 L
.18069 .32638 L
.18072 .32786 L
.18078 .33159 L
.1809 .33669 L
.18134 .35841 L
.18137 .35819 L
.1814 .35795 L
.18143 .35776 L
.18145 .35876 L
.18148 .35982 L
.18151 .36097 L
.18154 .36318 L
.18157 .36612 L
Mistroke
.1816 .36933 L
.18163 .37208 L
.18167 .37397 L
.1817 .37574 L
.18172 .37709 L
.18175 .37789 L
.18178 .37878 L
.18181 .3797 L
.18184 .38189 L
.18187 .38421 L
.18188 .38554 L
.1819 .38679 L
.18193 .38652 L
.18196 .38574 L
.18198 .38502 L
.18204 .38323 L
.18206 .38247 L
.18209 .38167 L
.18212 .38239 L
.18214 .38353 L
.18217 .38481 L
.1822 .38516 L
.18222 .3836 L
.18225 .38189 L
.1825 .36876 L
.18255 .36221 L
.18262 .35682 L
.18264 .35489 L
.18267 .35282 L
.1827 .35207 L
.18273 .35142 L
.18276 .35068 L
.18279 .35244 L
.18281 .35499 L
.18284 .35775 L
.1829 .36344 L
.18293 .36645 L
.18295 .36811 L
.18297 .3689 L
.18298 .36905 L
.183 .36918 L
.18303 .36944 L
.18307 .3698 L
.1831 .37021 L
.18313 .37056 L
.18316 .36996 L
.18318 .36909 L
.1832 .36829 L
.18323 .36677 L
.18326 .36634 L
Mistroke
.18329 .3667 L
.18331 .36701 L
.18334 .3673 L
.18336 .3673 L
.18338 .3673 L
.18341 .3673 L
.18344 .36743 L
.18347 .36985 L
.1835 .37219 L
.18353 .37472 L
.18356 .37388 L
.18358 .37278 L
.18365 .3704 L
.18368 .36948 L
.18371 .36865 L
.18374 .36933 L
.18377 .37046 L
.18379 .37166 L
.18382 .37266 L
.18385 .37266 L
.18388 .37266 L
.18391 .37266 L
.18393 .37158 L
.18394 .37039 L
.18397 .36826 L
.184 .36624 L
.18402 .36524 L
.18405 .36492 L
.18411 .36422 L
.18416 .36336 L
.18419 .36292 L
.18421 .36147 L
.18424 .35915 L
.18428 .35662 L
.1843 .35518 L
.18433 .35565 L
.18436 .35609 L
.18438 .3565 L
.1844 .35597 L
.18442 .35497 L
.18445 .35287 L
.18452 .34941 L
.18454 .3481 L
.18457 .34669 L
.18459 .3452 L
.1846 .34312 L
.18463 .33904 L
.1847 .33043 L
.18473 .32645 L
.18476 .3228 L
Mistroke
.18478 .32134 L
.18479 .3212 L
.18483 .32091 L
.18486 .32066 L
.18488 .31961 L
.1849 .31824 L
.18501 .30514 L
.18507 .29639 L
.1851 .29206 L
.18512 .28969 L
.18514 .28746 L
.18517 .28468 L
.18518 .28391 L
.1852 .28308 L
.18526 .28054 L
.18538 .27499 L
.1856 .26157 L
.18566 .25961 L
.18569 .25859 L
.18572 .25766 L
.18575 .25585 L
.18579 .25374 L
.1858 .25264 L
.18582 .25145 L
.18584 .2492 L
.18586 .24706 L
.18588 .24354 L
.18591 .23976 L
.18594 .24081 L
.18597 .24338 L
.18599 .24476 L
.186 .24626 L
.18603 .24665 L
.18607 .24592 L
.18609 .24525 L
.18612 .24486 L
.18615 .24486 L
.18618 .24486 L
.1862 .24486 L
.18623 .24245 L
.18626 .24015 L
.18629 .23764 L
.18631 .23656 L
.18632 .236 L
.18635 .23498 L
.18638 .23389 L
.18641 .23397 L
.18644 .23536 L
.18646 .23659 L
.18649 .23792 L
Mistroke
.18652 .23787 L
.18654 .23778 L
.18657 .23766 L
.18659 .2376 L
.1866 .23798 L
.18663 .23871 L
.18666 .23938 L
.18668 .23977 L
.1867 .23974 L
.18671 .23954 L
.18673 .23932 L
.18675 .23912 L
.18676 .23892 L
.18679 .23939 L
.18691 .24439 L
.18694 .24576 L
.18697 .24706 L
.18699 .24593 L
.187 .2449 L
.18704 .24287 L
.1871 .23983 L
.18713 .23861 L
.18716 .23752 L
.18719 .23687 L
.18722 .23617 L
.18728 .2349 L
.18731 .23435 L
.18733 .23406 L
.18735 .23381 L
.18737 .23509 L
.18739 .23648 L
.18742 .23895 L
.18745 .24086 L
.18747 .24008 L
.18749 .23936 L
.18755 .23672 L
.18758 .23588 L
.18761 .23496 L
.18764 .234 L
.18767 .23153 L
.1877 .22863 L
.18772 .22705 L
.18774 .22563 L
.18777 .22398 L
.1878 .22218 L
.18783 .22048 L
.18786 .22016 L
.18788 .21995 L
.18791 .21973 L
.18794 .21978 L
Mistroke
.18797 .22012 L
.18798 .22032 L
.188 .22051 L
.18803 .22113 L
.18806 .22216 L
.18808 .22328 L
.18811 .22448 L
.18814 .2216 L
.18817 .21855 L
.18819 .21567 L
.18822 .21411 L
.18825 .21576 L
.18828 .21763 L
.18831 .2196 L
.18833 .22003 L
.18836 .22049 L
.18839 .22099 L
.18841 .22087 L
.18843 .22036 L
.18846 .21944 L
.18849 .21843 L
.18852 .21871 L
.18853 .21926 L
.18855 .21977 L
.18861 .2212 L
.18864 .22134 L
.18866 .22141 L
.18868 .22148 L
.18871 .22278 L
.18874 .22479 L
.1888 .22903 L
.18886 .23393 L
.18889 .23609 L
.18892 .23715 L
.18899 .23928 L
.1892 .25026 L
.18923 .25366 L
.18924 .25545 L
.18926 .25736 L
.18929 .25694 L
.18932 .25594 L
.18935 .25488 L
.18937 .25528 L
.1894 .25668 L
.18942 .25819 L
.18946 .25983 L
.18947 .26024 L
.18949 .26062 L
.18956 .26226 L
.18961 .26388 L
Mistroke
.18963 .26435 L
.18965 .26466 L
.18967 .26253 L
.1897 .26049 L
.18973 .25832 L
.18976 .25888 L
.18979 .26035 L
.18991 .26491 L
.19039 .28814 L
.19089 .30603 L
.19114 .31646 L
.1912 .31788 L
.19124 .31874 L
.19126 .31916 L
.19127 .31966 L
.1913 .32155 L
.19134 .3236 L
.19137 .32524 L
.1914 .32573 L
.19145 .32662 L
.19151 .32735 L
.19154 .32769 L
.19157 .32828 L
.19159 .32915 L
.19162 .33011 L
.19167 .33194 L
.1917 .33279 L
.19173 .33359 L
.19176 .33343 L
.19178 .33284 L
.1918 .33219 L
.19183 .33105 L
.19186 .33194 L
.19189 .33443 L
.19191 .3367 L
.19194 .33902 L
.19197 .33924 L
.19199 .33944 L
.19202 .33964 L
.19205 .34111 L
.19207 .3435 L
.1922 .35448 L
.19226 .3605 L
.19228 .36367 L
.19231 .36661 L
.19234 .36865 L
.19237 .37028 L
.19239 .37182 L
.19242 .37301 L
.19245 .37277 L
Mistroke
.19248 .37255 L
.19251 .37232 L
.19254 .37176 L
.19257 .3711 L
.1926 .37049 L
.19262 .37181 L
.19263 .37445 L
.19267 .38006 L
.19268 .38253 L
.1927 .38521 L
.19273 .38511 L
.19276 .38452 L
.19279 .38396 L
.19282 .38418 L
.19285 .3849 L
.19287 .38552 L
.1929 .38652 L
.19293 .38913 L
.19296 .39156 L
.19297 .39305 L
.19299 .39445 L
.19302 .39506 L
.19305 .39559 L
.19307 .39615 L
.1931 .39731 L
.19312 .3993 L
.19315 .40145 L
.19318 .40369 L
.19321 .40449 L
.19324 .40522 L
.19327 .40608 L
.19328 .40604 L
.1933 .40548 L
.19333 .40438 L
.19336 .40337 L
.19337 .40287 L
.19339 .40281 L
.19343 .40267 L
.19346 .40254 L
.19347 .40325 L
.19349 .40493 L
.19352 .40819 L
.19355 .41127 L
.19358 .41202 L
.19361 .41121 L
.19364 .41033 L
.19365 .40988 L
.19367 .41015 L
.1937 .41102 L
.19373 .41183 L
Mistroke
.19376 .41225 L
.19379 .41128 L
.19382 .41044 L
.19384 .40953 L
.19386 .40939 L
.19388 .40939 L
.19391 .40939 L
.19394 .40939 L
.19397 .40789 L
.194 .40601 L
.19403 .40422 L
.19404 .40325 L
.19406 .40278 L
.19409 .40196 L
.1941 .40148 L
.19412 .40098 L
.19414 .40066 L
.19415 .40141 L
.19419 .40276 L
.1942 .40349 L
.19422 .40418 L
.19424 .40324 L
.19428 .39975 L
.1943 .39659 L
.19433 .39371 L
.19436 .39395 L
.19439 .39416 L
.19441 .3944 L
.19443 .39447 L
.19445 .39447 L
.19447 .39447 L
.1945 .39447 L
.19452 .39437 L
.19455 .39395 L
.19458 .39347 L
.19461 .39301 L
.19463 .39236 L
.19466 .3916 L
.19469 .39076 L
.19472 .38925 L
.19474 .38802 L
.19476 .38668 L
.19479 .38431 L
.19482 .38133 L
.19485 .37695 L
.19491 .36894 L
.19517 .33879 L
.19542 .31726 L
.19565 .29388 L
.19577 .28456 L
Mistroke
.1958 .28238 L
.19583 .28003 L
.19585 .27868 L
.19587 .27841 L
.19588 .27885 L
.1959 .27931 L
.19593 .2802 L
.19595 .2807 L
.19596 .28031 L
.196 .27892 L
.19602 .2776 L
.19604 .27686 L
.19606 .27493 L
.19609 .27057 L
.19611 .26792 L
.19613 .26541 L
.19615 .26343 L
.19616 .26242 L
.19619 .26087 L
.19622 .25922 L
.19624 .25828 L
.19625 .25802 L
.19628 .25754 L
.19631 .25709 L
.19634 .25667 L
.19637 .25646 L
.19639 .25624 L
.19641 .25612 L
.19643 .25598 L
.19646 .25358 L
.19649 .25051 L
.19651 .24901 L
.19652 .24761 L
.19656 .24646 L
.19659 .24525 L
.19662 .24423 L
.19665 .24113 L
.19687 .21622 L
.197 .20435 L
.19706 .19615 L
.19709 .19207 L
.19712 .19076 L
.19714 .19054 L
.19717 .19034 L
.1972 .19 L
.19723 .18858 L
.19726 .18714 L
.19728 .18578 L
.19731 .18368 L
.19735 .18123 L
Mistroke
.19737 .17913 L
.1974 .17919 L
.19743 .18106 L
.19746 .18283 L
.19748 .18436 L
.1975 .18204 L
.19753 .17953 L
.19756 .17678 L
.19758 .17569 L
.19761 .17854 L
.19764 .1812 L
.19767 .18363 L
.1977 .18454 L
.19771 .18487 L
.19773 .18518 L
.19779 .18618 L
.198 .18961 L
.19803 .18903 L
.19806 .18897 L
.19809 .19001 L
.19812 .19097 L
.19815 .19196 L
.19818 .1925 L
.19821 .19302 L
.19824 .19352 L
.19826 .19337 L
.19828 .19311 L
.19829 .19284 L
.19831 .19254 L
.19833 .19226 L
.19834 .19249 L
.19838 .19672 L
.19841 .20093 L
.19844 .20485 L
.19847 .20622 L
.1985 .20754 L
.19899 .22155 L
.19901 .22189 L
.19904 .22178 L
.19907 .22166 L
.1991 .22154 L
.19913 .22034 L
.19915 .21889 L
.19918 .21717 L
.19921 .21592 L
.19923 .21722 L
.19926 .21845 L
.19931 .22193 L
.19943 .23104 L
.19955 .23779 L
Mistroke
.19958 .24029 L
.1996 .24088 L
.19961 .24122 L
.19965 .24184 L
.19967 .24241 L
.1997 .2433 L
.19973 .24427 L
.19976 .24537 L
.19979 .24713 L
.19981 .24971 L
.19984 .25245 L
.19986 .2552 L
.19989 .25587 L
.19993 .25574 L
.19995 .25563 L
.19998 .25592 L
.2 .25624 L
.20002 .25658 L
.20004 .25696 L
.20005 .25731 L
.20007 .25781 L
.20009 .25857 L
.20012 .25991 L
.20013 .26062 L
.20015 .26139 L
.20018 .26426 L
.20021 .26733 L
.20023 .26899 L
.20025 .27079 L
.20028 .27267 L
.20034 .27535 L
.20039 .2778 L
.20137 .33614 L
.20231 .39309 L
.20256 .40411 L
.20269 .41327 L
.20272 .41566 L
.20274 .41697 L
.20275 .41751 L
.20277 .41766 L
.20279 .41781 L
.20281 .41794 L
.20282 .41809 L
.20285 .41777 L
.20287 .41737 L
.20289 .41699 L
.20292 .41631 L
.20295 .41665 L
.20296 .41761 L
.20298 .41866 L
Mistroke
.20301 .42077 L
.20305 .42229 L
.20308 .42338 L
.20311 .42448 L
.20314 .42598 L
.20317 .42824 L
.2032 .43072 L
.20323 .43229 L
.20325 .43209 L
.20328 .43185 L
.20331 .43163 L
.20334 .43168 L
.20335 .43174 L
.20337 .43181 L
.2034 .43193 L
.20343 .4322 L
.20349 .43296 L
.20353 .43328 L
.20356 .43356 L
.20359 .43381 L
.20361 .43371 L
.20363 .43338 L
.20366 .43277 L
.20368 .43221 L
.20371 .43176 L
.20374 .43144 L
.20377 .43109 L
.2038 .43105 L
.20383 .43183 L
.20385 .43255 L
.20388 .43335 L
.20391 .43523 L
.20395 .43741 L
.20398 .43949 L
.204 .44 L
.20403 .44 L
.20406 .44 L
.20409 .44013 L
.20412 .4406 L
.20414 .44105 L
.20417 .44147 L
.20419 .44249 L
.20422 .44372 L
.20425 .44507 L
.20428 .44592 L
.20431 .44523 L
.20433 .44461 L
.20436 .44393 L
.20439 .44507 L
.20442 .44663 L
Mistroke
.20445 .44807 L
.20448 .44699 L
.20453 .44352 L
.20456 .44201 L
.20459 .44335 L
.20462 .44481 L
.20464 .44617 L
.20467 .44497 L
.2047 .44273 L
.20472 .44144 L
.20473 .44006 L
.20476 .43954 L
.20478 .44029 L
.2048 .441 L
.20482 .44182 L
.20483 .44261 L
.20485 .44283 L
.20486 .44203 L
.20489 .44064 L
.20491 .43986 L
.20493 .43902 L
.20496 .43887 L
.20499 .43948 L
.20501 .43981 L
.20502 .44015 L
.20505 .44023 L
.20508 .44 L
.20511 .43979 L
.20514 .43969 L
.20517 .44005 L
.2052 .44039 L
.20522 .44075 L
.20524 .43948 L
.20526 .43816 L
.20529 .43528 L
.20532 .43268 L
.20535 .43146 L
.20538 .43018 L
.20541 .4289 L
.20542 .42852 L
.20544 .42852 L
.20547 .42852 L
.20549 .42852 L
.20551 .42852 L
.20554 .42753 L
.20557 .42625 L
.20558 .42564 L
.2056 .42498 L
.20562 .42291 L
.20564 .42016 L
Mistroke
.20567 .41418 L
.20569 .41127 L
.20571 .40911 L
.20574 .41056 L
.20577 .4121 L
.20578 .41291 L
.2058 .41344 L
.20582 .41268 L
.20584 .41199 L
.20587 .41063 L
.2059 .40929 L
.20593 .40542 L
.20596 .40118 L
.20602 .39456 L
.20605 .39149 L
.20608 .38861 L
.2061 .38497 L
.20613 .38058 L
.20616 .37612 L
.20619 .37186 L
.20621 .37032 L
.20622 .36889 L
.20625 .36606 L
.20628 .36383 L
.20631 .36359 L
.20633 .36345 L
.20635 .3633 L
.20636 .36316 L
.20638 .36292 L
.20641 .36219 L
.20644 .36142 L
.20647 .36054 L
.2065 .35749 L
.20656 .35198 L
.20662 .3441 L
.20665 .3398 L
.20666 .33792 L
.20668 .33673 L
.20671 .33454 L
.20674 .33248 L
.20677 .33132 L
.2068 .3306 L
.20683 .3299 L
.20686 .32938 L
.20689 .32928 L
.20691 .32916 L
.20694 .32905 L
.20697 .32726 L
.20702 .32269 L
.20713 .31168 L
Mistroke
.20735 .29372 L
.20747 .28001 L
.20753 .27283 L
.20759 .26756 L
.20765 .26348 L
.20771 .26036 L
.20778 .25619 L
.20779 .25504 L
.20781 .25435 L
.20783 .25421 L
.20785 .25408 L
.20788 .25383 L
.20789 .25369 L
.20791 .25445 L
.20794 .25639 L
.20797 .25851 L
.208 .25996 L
.20803 .25887 L
.20806 .25772 L
.20809 .25647 L
.20812 .25809 L
.20815 .26016 L
.20818 .2621 L
.20821 .26308 L
.20824 .26399 L
.20826 .26446 L
.20828 .26498 L
.20831 .26484 L
.20832 .26463 L
.20834 .26444 L
.2084 .26364 L
.20843 .26318 L
.20845 .26275 L
.20848 .26204 L
.20852 .26097 L
.20858 .25875 L
.20902 .24357 L
.20914 .23455 L
.2092 .22905 L
.20923 .22663 L
.20926 .22527 L
.20929 .22416 L
.20931 .22355 L
.20932 .22298 L
.20934 .22209 L
.20936 .22083 L
.20939 .21855 L
.20942 .21663 L
.20945 .21674 L
.20947 .21711 L
Mistroke
.20948 .21751 L
.20951 .21823 L
.20954 .22051 L
.20957 .22324 L
.2096 .22624 L
.20962 .22758 L
.20964 .22655 L
.20975 .22066 L
.20978 .21983 L
.20981 .21895 L
.20984 .21852 L
.20986 .21818 L
.20989 .21783 L
.20992 .21595 L
.20994 .21323 L
.20997 .21028 L
.21 .20699 L
.21003 .20724 L
.21009 .20769 L
.21014 .2081 L
.21017 .20833 L
.2102 .20805 L
.21023 .20513 L
.21026 .20237 L
.21029 .19989 L
.21031 .20199 L
.21044 .21144 L
.2105 .21503 L
.21055 .21823 L
.21058 .21961 L
.21061 .21961 L
.21064 .21961 L
.21065 .21961 L
.21067 .21961 L
.2107 .22159 L
.21072 .22346 L
.21075 .22561 L
.21078 .22626 L
.21081 .22586 L
.21083 .22542 L
.21086 .22501 L
.21088 .22629 L
.21183 .27119 L
.21274 .32786 L
.21371 .39141 L
.21464 .44511 L
.21512 .47944 L
.21537 .49814 L
.21543 .50132 L
.2155 .50472 L
Mistroke
.21557 .50857 L
.2156 .51114 L
.21563 .51354 L
.21566 .51493 L
.21569 .51555 L
.21571 .51591 L
.21573 .51625 L
.21576 .5175 L
.21589 .52362 L
.21592 .5246 L
.21595 .52626 L
.21598 .52843 L
.216 .52965 L
.21602 .53082 L
.21605 .53212 L
.21607 .53264 L
.2161 .53321 L
.21613 .53366 L
.21616 .53297 L
.21618 .53236 L
.21624 .53094 L
.21626 .52978 L
.2163 .52854 L
.21632 .5277 L
.21635 .52839 L
.21638 .52908 L
.21641 .52981 L
.21643 .52971 L
.21644 .52946 L
.21647 .52896 L
.2165 .5285 L
.21653 .52867 L
.21656 .52902 L
.21659 .52934 L
.21662 .52949 L
.21665 .52937 L
.21667 .52926 L
.2167 .52915 L
.21673 .52997 L
.21676 .53074 L
.21677 .53122 L
.21679 .53167 L
.21682 .53423 L
.21687 .53928 L
.2169 .54146 L
.21692 .54191 L
.21696 .5424 L
.21698 .54285 L
.21701 .54284 L
.21704 .54273 L
Mistroke
.21707 .5426 L
.21709 .54252 L
.2171 .5424 L
.21714 .54211 L
.21715 .54198 L
.21717 .54185 L
.2172 .54116 L
.21724 .54022 L
.21726 .53939 L
.2173 .5375 L
.21735 .53334 L
.21738 .5314 L
.21741 .53029 L
.21742 .52966 L
.21744 .52897 L
.21747 .5285 L
.2175 .53074 L
.21753 .5328 L
.21756 .53485 L
.21759 .53301 L
.21762 .53136 L
.21764 .5296 L
.21767 .5283 L
.2177 .52752 L
.21772 .52705 L
.21773 .5266 L
.21776 .52469 L
.21779 .52152 L
.21782 .51811 L
.21785 .5149 L
.21787 .51391 L
.2179 .51309 L
.21792 .5122 L
.21795 .51037 L
.21798 .50695 L
.21811 .48782 L
.21822 .47497 L
.21835 .45493 L
.21848 .43236 L
.21942 .27318 L
.22032 .10765 L
.22044 .08554 L
.22047 .07883 L
.2205 .07249 L
.22052 .06759 L
.22055 .06683 L
.22058 .06608 L
.22061 .06529 L
.22064 .06104 L
.22066 .05572 L
Mistroke
.22069 .05034 L
.22072 .0471 L
.22074 .04717 L
.22076 .04723 L
.22079 .04736 L
.2208 .04742 L
.22082 .04666 L
.22085 .04519 L
.22087 .04428 L
.22089 .04343 L
.22091 .04243 L
.22092 .04043 L
.22105 .02547 L
.22108 .02171 L
.22111 .01908 L
.22114 .017 L
.22116 .01583 L
.22117 .01472 L
.2212 .01573 L
.22123 .01923 L
.22126 .02302 L
.22129 .02645 L
.22132 .0268 L
.22135 .02713 L
.22137 .02744 L
.2214 .02646 L
.22146 .02318 L
.22152 .02068 L
.22155 .0195 L
.22158 .01896 L
.22159 .01939 L
.22161 .01986 L
.22164 .02067 L
.22165 .02111 L
.22167 .02125 L
.22169 .02082 L
.22171 .02042 L
.22174 .01971 L
.22175 .01931 L
.22177 .01917 L
.2218 .01939 L
.22182 .01963 L
.22185 .01986 L
.22188 .02401 L
.22198 .03815 L
.22221 .0615 L
.22317 .14269 L
.2241 .23376 L
.22509 .33126 L
.22604 .4224 L
Mistroke
.22652 .45698 L
.22672 .47341 L
.22683 .48782 L
.22689 .49448 L
.22692 .49827 L
.22695 .49811 L
.22698 .4976 L
.22701 .49714 L
.22704 .49909 L
.22706 .5005 L
.22708 .50203 L
.22711 .5046 L
.22714 .50638 L
.22719 .50884 L
.22742 .52159 L
.22768 .53182 L
.22774 .5359 L
.22777 .53833 L
.2278 .54025 L
.22781 .5409 L
.22783 .54161 L
.22786 .54285 L
.22789 .5439 L
.22792 .54449 L
.22795 .54509 L
.22798 .54557 L
.22801 .54522 L
.22804 .54483 L
.22811 .54409 L
.22814 .54368 L
.22817 .5433 L
.22819 .54206 L
.2282 .54074 L
.22824 .53793 L
.22825 .5366 L
.22827 .53556 L
.2283 .53486 L
.22833 .53408 L
.22835 .53369 L
.22837 .53354 L
.22839 .53439 L
.2284 .53519 L
.22844 .53672 L
.22892 .55648 L
.22937 .58559 L
.22943 .59294 L
.22946 .59715 L
.22949 .60103 L
.22951 .60321 L
.22952 .60332 L
Mistroke
.22954 .60325 L
.22956 .60318 L
.22957 .60312 L
.22959 .60305 L
.22962 .60205 L
.22967 .599 L
.2297 .59763 L
.22973 .59751 L
.22975 .59744 L
.22977 .59738 L
.2298 .5972 L
.22983 .59597 L
.22985 .59485 L
.22987 .59423 L
.22989 .59357 L
.2299 .59208 L
.22992 .59054 L
.22996 .58721 L
.22997 .58558 L
.22999 .58429 L
.23002 .58246 L
.23006 .58048 L
.23012 .57687 L
.23024 .56829 L
.2303 .56227 L
.23036 .55423 L
.23085 .47292 L
.23181 .27827 L
.23193 .24729 L
.23203 .21791 L
.23206 .21148 L
.23209 .20484 L
.23211 .20258 L
.23212 .20011 L
.23215 .19576 L
.23226 .17699 L
.23251 .14364 L
.23275 .12155 L
.23301 .08949 L
.23326 .06668 L
.23338 .05527 L
.23344 .04806 L
.23349 .04172 L
.23352 .03822 L
.23354 .03761 L
.23355 .03693 L
.23359 .03561 L
.2336 .03487 L
.23362 .035 L
.23365 .03842 L
Mistroke
.23368 .04166 L
.23371 .04465 L
.23374 .04393 L
.23377 .0431 L
.2338 .04222 L
.23382 .04363 L
.23384 .04615 L
.23387 .05058 L
.2339 .05477 L
.23391 .05603 L
.23393 .05677 L
.23396 .05822 L
.23399 .05957 L
.23401 .05965 L
.23404 .05896 L
.23407 .05822 L
.2341 .05792 L
.23413 .05832 L
.23416 .05875 L
.23419 .05923 L
.23421 .05863 L
.23424 .05781 L
.23427 .05694 L
.2343 .05675 L
.23433 .05697 L
.23436 .05722 L
.23438 .05736 L
.2344 .05841 L
.23446 .06266 L
.23472 .07742 L
.23493 .09142 L
.23499 .09578 L
.23505 .09962 L
.23511 .10138 L
.23514 .10237 L
.23517 .10456 L
.2352 .1077 L
.23524 .11066 L
.23527 .1145 L
.2353 .11878 L
.23533 .12275 L
.23535 .12402 L
.23536 .12519 L
.23542 .12918 L
.23548 .13261 L
.2355 .13357 L
.23552 .13448 L
.23555 .1383 L
.23561 .14787 L
.23566 .15505 L
Mistroke
.23569 .15807 L
.23572 .16123 L
.23575 .1628 L
.23577 .16411 L
.23584 .16678 L
.23587 .16777 L
.2359 .16867 L
.23592 .17069 L
.23595 .17347 L
.23601 .17946 L
.23614 .19476 L
.23658 .24606 L
.23682 .26764 L
.23695 .28025 L
.23707 .29531 L
.23712 .30119 L
.23714 .30409 L
.23717 .30588 L
.2372 .30707 L
.23723 .30838 L
.23728 .31087 L
.23751 .32015 L
.23754 .32056 L
.23756 .32033 L
.23759 .32001 L
.23761 .31972 L
.23764 .31976 L
.23767 .32076 L
.23773 .32305 L
.23778 .32454 L
.2378 .32493 L
.23782 .32533 L
.23785 .32696 L
.23796 .33436 L
.23821 .35699 L
.23845 .3777 L
.23868 .40217 L
.23874 .40814 L
.23876 .40945 L
.23878 .41084 L
.23881 .41216 L
.23883 .41285 L
.23886 .41349 L
.23889 .41385 L
.23892 .4135 L
.23895 .41317 L
.23898 .41286 L
.239 .41582 L
.23903 .41937 L
.23913 .42866 L
Mistroke
.23919 .43265 L
.23922 .43453 L
.23924 .43627 L
.23927 .4372 L
.23929 .43627 L
.23931 .43528 L
.23933 .43353 L
.23936 .43201 L
.23939 .43321 L
.23942 .43452 L
.23945 .4358 L
.23948 .43545 L
.23951 .43452 L
.23954 .43364 L
.23956 .43377 L
.23959 .43589 L
.23962 .43841 L
.23965 .44076 L
.23968 .44064 L
.23971 .44051 L
.23974 .44039 L
.23977 .44218 L
.2398 .44427 L
.23983 .44649 L
.23986 .44764 L
.23989 .44817 L
.23991 .44872 L
.23994 .44924 L
.23997 .45017 L
.24 .45118 L
.24003 .45207 L
.24005 .45462 L
.2401 .45954 L
.24013 .46202 L
.24016 .46325 L
.24019 .4647 L
.24021 .46602 L
.24024 .46654 L
.24027 .46677 L
.2403 .46701 L
.24033 .46823 L
.24036 .47308 L
.24039 .47769 L
.24044 .48463 L
.24047 .48743 L
.2405 .49008 L
.24051 .49158 L
.24053 .49178 L
.24056 .49202 L
.24059 .49226 L
Mistroke
.24061 .49286 L
.24064 .49481 L
.24068 .49694 L
.24069 .49801 L
.24071 .49854 L
.24073 .49854 L
.24074 .49854 L
.24078 .49854 L
.24079 .49854 L
.24081 .49841 L
.24084 .49804 L
.24087 .4977 L
.24089 .4975 L
.2409 .49762 L
.24093 .4985 L
.24097 .49943 L
.24099 .49996 L
.241 .49941 L
.24103 .498 L
.24107 .49647 L
.2411 .49537 L
.24112 .49504 L
.24116 .49465 L
.24117 .49446 L
.24119 .495 L
.24122 .49788 L
.24125 .50058 L
.24128 .50318 L
.2413 .50351 L
.24131 .50382 L
.24134 .50441 L
.24137 .50496 L
.24139 .50519 L
.2414 .50538 L
.24144 .5058 L
.24147 .50617 L
.24148 .50578 L
.2415 .50533 L
.24156 .50368 L
.24161 .50234 L
.24165 .50161 L
.24166 .50114 L
.24168 .49991 L
.24171 .49776 L
.24174 .49545 L
.24176 .49436 L
.24179 .49568 L
.24184 .49827 L
.24195 .50295 L
.24198 .50418 L
Mistroke
.24201 .5055 L
.24204 .50675 L
.24206 .50629 L
.24209 .50536 L
.24212 .50449 L
.24215 .5043 L
.24217 .50489 L
.24218 .50544 L
.24221 .50652 L
.24224 .50713 L
.24227 .50621 L
.24229 .50521 L
.24233 .50412 L
.24234 .50381 L
.24236 .50369 L
.24239 .50345 L
.24242 .50323 L
.24244 .50365 L
.24247 .50465 L
.2425 .50574 L
.24253 .50648 L
.24255 .506 L
.24258 .50548 L
.24261 .50491 L
.24263 .5033 L
.24269 .49737 L
.24272 .49507 L
.24274 .495 L
.24276 .49494 L
.24279 .4948 L
.24281 .49473 L
.24282 .49477 L
.24284 .49483 L
.24286 .4949 L
.24289 .49503 L
.24292 .49449 L
.24295 .49322 L
.24301 .49 L
.24313 .48271 L
.24335 .4667 L
.24359 .45046 L
.24362 .44935 L
.24365 .4483 L
.24367 .44773 L
.24369 .4448 L
.24372 .43916 L
.24379 .42442 L
.24382 .41604 L
.24383 .41158 L
.24385 .40678 L
Mistroke
.24388 .40218 L
.24391 .39924 L
.24398 .39338 L
.24401 .39115 L
.24404 .38904 L
.24406 .3857 L
.24409 .37997 L
.24415 .36829 L
.24421 .35247 L
.24432 .33068 L
.24457 .27831 L
.2447 .25865 L
.24484 .24141 L
.24508 .21185 L
.24532 .17038 L
.24556 .14009 L
.24561 .13498 L
.24566 .13145 L
.24568 .12884 L
.24571 .12426 L
.24574 .12046 L
.24576 .11629 L
.24579 .11452 L
.24583 .11363 L
.24588 .11211 L
.24591 .11146 L
.24594 .11075 L
.24597 .11018 L
.24599 .11018 L
.24602 .11018 L
.24605 .11018 L
.24608 .10791 L
.24611 .10453 L
.24614 .10092 L
.24615 .09901 L
.24617 .09837 L
.2462 .09712 L
.24623 .09595 L
.24626 .09535 L
.24628 .09568 L
.24631 .09602 L
.24634 .09638 L
.24637 .09522 L
.2464 .09403 L
.24646 .0915 L
.24649 .08973 L
.24651 .08875 L
.24652 .08782 L
.24654 .08722 L
.24656 .08722 L
Mistroke
.24658 .08722 L
.2466 .08722 L
.24662 .08722 L
.24665 .08584 L
.24667 .08459 L
.24668 .08342 L
.2467 .08215 L
.24672 .08075 L
.24675 .08286 L
.24678 .08619 L
.24681 .08927 L
.24683 .0889 L
.24687 .08485 L
.2469 .08116 L
.24691 .07912 L
.24693 .07856 L
.24696 .07894 L
.24699 .07929 L
.24702 .07955 L
.24705 .07942 L
.24708 .07931 L
.2471 .0792 L
.24713 .07796 L
.24719 .07474 L
.24722 .07323 L
.24725 .07212 L
.24728 .07112 L
.24731 .07075 L
.24732 .07138 L
.24734 .07206 L
.24737 .07343 L
.24744 .07642 L
.24794 .1083 L
.24891 .17432 L
.24985 .25052 L
.25084 .31657 L
.2518 .36222 L
.25272 .40574 L
.2537 .451 L
.25419 .46833 L
.25443 .4796 L
.25445 .4797 L
.25448 .4799 L
.25451 .48125 L
.25453 .48248 L
.25456 .48384 L
.25459 .4861 L
.25462 .48841 L
.25465 .49095 L
.25467 .49269 L
Mistroke
.2547 .49227 L
.25473 .4918 L
.25476 .49136 L
.25478 .48976 L
.25481 .48793 L
.25483 .48582 L
.25486 .48402 L
.25489 .48444 L
.25491 .48489 L
.25494 .48531 L
.25497 .48609 L
.25502 .48899 L
.25505 .49048 L
.25508 .49012 L
.25511 .48976 L
.25514 .48943 L
.25517 .48889 L
.2552 .48827 L
.25523 .48773 L
.25526 .4865 L
.25528 .48475 L
.25531 .48314 L
.25534 .48141 L
.25537 .48054 L
.2554 .47964 L
.25543 .4788 L
.25544 .47864 L
.25546 .47864 L
.25549 .47864 L
.25552 .47864 L
.25555 .47983 L
.25558 .48131 L
.2556 .48212 L
.25562 .48287 L
.25564 .48259 L
.25567 .48161 L
.25569 .48111 L
.25571 .48056 L
.25574 .47987 L
.25577 .47931 L
.25579 .47904 L
.25581 .47879 L
.25584 .47488 L
.25587 .46879 L
.25588 .46566 L
.2559 .46236 L
.25593 .45958 L
.25596 .45864 L
.25599 .45762 L
.25602 .45684 L
Mistroke
.25605 .45684 L
.25607 .45684 L
.2561 .45679 L
.25613 .45393 L
.25616 .4513 L
.25621 .44609 L
.25626 .4415 L
.25629 .43913 L
.25632 .43847 L
.25635 .43847 L
.25637 .43847 L
.2564 .43813 L
.25643 .43724 L
.25646 .43646 L
.25649 .43535 L
.25651 .43419 L
.25652 .43291 L
.25655 .43068 L
.25662 .42412 L
.25674 .40813 L
.25697 .3863 L
.25747 .34713 L
.2575 .34643 L
.25753 .34578 L
.25755 .3438 L
.25759 .34055 L
.25765 .33416 L
.25768 .3318 L
.25771 .32932 L
.25774 .32609 L
.25777 .32047 L
.2578 .31529 L
.25782 .3106 L
.25785 .30866 L
.25788 .30714 L
.25791 .30573 L
.25794 .30209 L
.2582 .25961 L
.25826 .25389 L
.25829 .25085 L
.25832 .24549 L
.25833 .24112 L
.25835 .23636 L
.25838 .22803 L
.25841 .22147 L
.25844 .21714 L
.25847 .21329 L
.2585 .20964 L
.25853 .20952 L
.25856 .20941 L
Mistroke
.25859 .20928 L
.2586 .207 L
.25862 .20416 L
.25865 .19916 L
.25868 .19443 L
.25869 .19284 L
.25871 .19209 L
.25874 .19079 L
.25875 .19005 L
.25877 .18927 L
.25879 .18752 L
.2588 .18479 L
.25892 .16821 L
.25903 .1499 L
.25907 .14315 L
.2591 .14212 L
.25912 .14124 L
.25915 .1403 L
.25918 .13849 L
.25921 .13646 L
.25926 .1325 L
.25931 .12923 L
.25934 .12764 L
.25937 .1266 L
.2594 .12582 L
.25943 .12498 L
.25945 .12467 L
.25948 .12656 L
.25951 .12862 L
.25954 .1308 L
.25955 .13058 L
.25957 .12948 L
.2596 .12753 L
.25962 .12653 L
.25963 .12549 L
.25966 .12631 L
.2597 .12795 L
.25973 .12975 L
.25976 .13238 L
.25979 .13508 L
.25982 .13749 L
.25985 .13775 L
.25988 .13662 L
.25991 .13543 L
.25993 .13454 L
.25996 .13398 L
.25999 .13339 L
.26002 .13275 L
.26005 .13263 L
.26008 .13252 L
Mistroke
.26011 .13241 L
.26013 .1318 L
.26016 .13068 L
.26019 .1295 L
.26024 .12761 L
.26027 .12666 L
.26029 .12564 L
.26031 .12514 L
.26033 .12551 L
.26036 .12623 L
.26042 .12746 L
.26054 .1299 L
.26057 .13157 L
.2606 .13275 L
.26064 .13275 L
.26067 .13275 L
.26069 .13275 L
.2607 .13301 L
.26074 .13376 L
.26076 .13409 L
.26078 .13445 L
.26079 .1355 L
.26081 .13758 L
.26093 .15221 L
.261 .15868 L
.26103 .16127 L
.26106 .16366 L
.26109 .16425 L
.26112 .16278 L
.26113 .16202 L
.26115 .16119 L
.26118 .16035 L
.26121 .16046 L
.26124 .16056 L
.26127 .16071 L
.26129 .16208 L
.26221 .21664 L
.26319 .26835 L
.26322 .26927 L
.26325 .27024 L
.26328 .27152 L
.26331 .27339 L
.26333 .27536 L
.26336 .2775 L
.26338 .27667 L
.2634 .27537 L
.26343 .27281 L
.26346 .27026 L
.26347 .26973 L
.26349 .26973 L
Mistroke
.26353 .26973 L
.26354 .26973 L
.26356 .26973 L
.26359 .27518 L
.26362 .28063 L
.26363 .28366 L
.26365 .28688 L
.26368 .28838 L
.26371 .2887 L
.26373 .28904 L
.26376 .28973 L
.26379 .29091 L
.26381 .29215 L
.26384 .2935 L
.26387 .29656 L
.2639 .2999 L
.26396 .30686 L
.26402 .31232 L
.26408 .31651 L
.26411 .31836 L
.26414 .31995 L
.26416 .32081 L
.26419 .32174 L
.26425 .32402 L
.26432 .32663 L
.26435 .32803 L
.26438 .32953 L
.26441 .33088 L
.26444 .33043 L
.26447 .32897 L
.26449 .3276 L
.26452 .32647 L
.26455 .32702 L
.26458 .32761 L
.2646 .32794 L
.26461 .32825 L
.26464 .33146 L
.26466 .33451 L
.26469 .33741 L
.26471 .34019 L
.26474 .34074 L
.26476 .34124 L
.26479 .34184 L
.26482 .34278 L
.26485 .34404 L
.26488 .3454 L
.26494 .34788 L
.26504 .35345 L
.26553 .38974 L
.26559 .3944 L
Mistroke
.26562 .39677 L
.26564 .39808 L
.26566 .3993 L
.26569 .3993 L
.2657 .39893 L
.26572 .39853 L
.26575 .39782 L
.26577 .39869 L
.2658 .4009 L
.26583 .40296 L
.26589 .40727 L
.26599 .41603 L
.2661 .42321 L
.26613 .42395 L
.26616 .42526 L
.26621 .42845 L
.26623 .43021 L
.26626 .43033 L
.26628 .43027 L
.2663 .4302 L
.26633 .43008 L
.26635 .4298 L
.26638 .42946 L
.26641 .42916 L
.26643 .42961 L
.26647 .43326 L
.2665 .43669 L
.26651 .43849 L
.26653 .43997 L
.26654 .43983 L
.26656 .4397 L
.26659 .43948 L
.26662 .43924 L
.26664 .43824 L
.26665 .43732 L
.26668 .43552 L
.26674 .43263 L
.26677 .43146 L
.2668 .43022 L
.26682 .43032 L
.26685 .43176 L
.26688 .43298 L
.26691 .43426 L
.26694 .43401 L
.26697 .43377 L
.26698 .43363 L
.267 .4335 L
.26703 .43459 L
.26706 .43559 L
.26709 .43665 L
Mistroke
.2671 .43671 L
.26712 .43617 L
.26715 .43522 L
.26718 .43429 L
.26721 .43426 L
.26724 .43512 L
.26727 .43594 L
.26729 .43644 L
.26732 .43585 L
.26735 .43516 L
.26737 .43452 L
.2674 .43553 L
.26743 .43775 L
.26746 .43982 L
.26749 .44074 L
.26752 .43931 L
.26755 .43774 L
.26758 .43647 L
.2676 .43626 L
.26762 .43607 L
.26765 .43569 L
.26766 .4355 L
.26768 .43548 L
.2677 .43563 L
.26772 .43577 L
.26773 .43591 L
.26775 .43603 L
.26778 .43583 L
.26781 .43513 L
.26784 .43439 L
.26786 .43396 L
.26788 .43439 L
.26793 .43655 L
.26796 .43764 L
.26799 .43726 L
.26802 .43674 L
.26805 .43626 L
.26808 .43537 L
.26811 .4343 L
.26813 .43329 L
.26817 .43321 L
.26819 .43413 L
.26822 .43498 L
.26824 .43574 L
.26827 .43381 L
.26832 .42957 L
.26834 .42831 L
.26836 .4276 L
.26839 .42647 L
.26842 .42535 L
Mistroke
.26845 .42458 L
.26846 .42437 L
.26848 .42418 L
.2685 .42395 L
.26852 .42375 L
.26855 .423 L
.26856 .42235 L
.26858 .42167 L
.26869 .41579 L
.26882 .40711 L
.26933 .36377 L
.26957 .33797 L
.26979 .31474 L
.26982 .31107 L
.26985 .30711 L
.26988 .30386 L
.2699 .30252 L
.26993 .30112 L
.26996 .29959 L
.26999 .29901 L
.27 .29888 L
.27002 .29875 L
.27004 .29863 L
.27005 .29849 L
.27008 .29542 L
.27011 .29179 L
.27014 .28779 L
.27016 .2857 L
.27017 .28481 L
.27021 .28287 L
.27027 .28007 L
.27072 .25406 L
.27094 .24671 L
.27097 .24271 L
.271 .23849 L
.27101 .23628 L
.27103 .23612 L
.27106 .23624 L
.27109 .23635 L
.27112 .23667 L
.27115 .23757 L
.27117 .2384 L
.27124 .24072 L
.27127 .24193 L
.2713 .24272 L
.27133 .24037 L
.27136 .23787 L
.27142 .23315 L
.27154 .22645 L
.27155 .22564 L
Mistroke
.27157 .22475 L
.2716 .22164 L
.27163 .21659 L
.27166 .21189 L
.27169 .20809 L
.27172 .20947 L
.27175 .21096 L
.27177 .21175 L
.27178 .21228 L
.27181 .2119 L
.27184 .21156 L
.27187 .21123 L
.2719 .21119 L
.27192 .21119 L
.27193 .21119 L
.27197 .21119 L
.27198 .21205 L
.272 .21297 L
.27204 .21506 L
.27207 .21643 L
.27208 .21582 L
.2721 .21524 L
.27213 .2141 L
.27215 .21349 L
.27217 .21304 L
.2722 .2128 L
.27223 .21257 L
.27224 .21244 L
.27226 .21254 L
.27229 .21431 L
.27231 .21587 L
.27234 .21752 L
.27237 .21674 L
.2724 .21496 L
.27243 .21306 L
.27245 .21199 L
.27246 .21272 L
.27252 .21573 L
.27253 .21654 L
.27255 .21697 L
.27257 .21704 L
.27259 .21711 L
.2726 .21718 L
.27262 .21724 L
.27265 .2171 L
.27268 .21665 L
.27271 .21617 L
.27274 .2155 L
.27276 .21374 L
.27279 .21168 L
Mistroke
.27281 .2106 L
.27283 .20944 L
.27286 .21199 L
.27288 .21472 L
.27291 .21751 L
.27295 .21657 L
.27298 .21395 L
.273 .21155 L
.27303 .20941 L
.27305 .20859 L
.27307 .20782 L
.2731 .20627 L
.27312 .20554 L
.27313 .20705 L
.27316 .2096 L
.27319 .2123 L
.27322 .21396 L
.27324 .21186 L
.27327 .2096 L
.27329 .20835 L
.2733 .20717 L
.27333 .20895 L
.27336 .21092 L
.27358 .22181 L
.27401 .25622 L
.27413 .26098 L
.2742 .26288 L
.27423 .26384 L
.27426 .26473 L
.27429 .26584 L
.27432 .26705 L
.27434 .26774 L
.27435 .26839 L
.27438 .27184 L
.27444 .27866 L
.27447 .28158 L
.2745 .28317 L
.27453 .28485 L
.27455 .28618 L
.27458 .28618 L
.27461 .28618 L
.27464 .28618 L
.27467 .28649 L
.2747 .28681 L
.27472 .28712 L
.27474 .28731 L
.27476 .28825 L
.27479 .29003 L
.27485 .29382 L
.27497 .29905 L
Mistroke
.275 .30019 L
.27502 .30082 L
.27504 .30179 L
.27507 .30438 L
.2751 .30673 L
.27513 .30858 L
.27515 .30803 L
.27516 .30751 L
.2752 .30635 L
.27523 .30499 L
.27529 .30208 L
.27532 .30095 L
.27534 .30201 L
.27535 .30298 L
.27548 .31212 L
.27597 .34282 L
.27643 .38036 L
.27654 .39255 L
.27657 .39592 L
.2766 .39754 L
.27665 .40044 L
.27671 .4018 L
.27674 .40251 L
.27677 .40378 L
.27679 .40565 L
.27682 .4077 L
.27685 .40956 L
.27687 .40927 L
.2769 .4085 L
.27693 .40778 L
.27696 .40753 L
.27699 .40765 L
.277 .40771 L
.27702 .40778 L
.27705 .40839 L
.27707 .40918 L
.27708 .40992 L
.27712 .4116 L
.27715 .41268 L
.27717 .41324 L
.27723 .41427 L
.27728 .41539 L
.27731 .41602 L
.27734 .41829 L
.2774 .42505 L
.27742 .42828 L
.27745 .42996 L
.27749 .43179 L
.27752 .43349 L
.27754 .43239 L
Mistroke
.27757 .43121 L
.2776 .43016 L
.27763 .42986 L
.27765 .43027 L
.27768 .43072 L
.27771 .43118 L
.27774 .42808 L
.27776 .42528 L
.27779 .42223 L
.27781 .42115 L
.27783 .42198 L
.27786 .42361 L
.27789 .42506 L
.27791 .42564 L
.27793 .42596 L
.27796 .4266 L
.27799 .42718 L
.27802 .42676 L
.27803 .4263 L
.27805 .42582 L
.27808 .42502 L
.27811 .42455 L
.27814 .42432 L
.27816 .42411 L
.27823 .42344 L
.27829 .42266 L
.27835 .42127 L
.27841 .41989 L
.27844 .41928 L
.27847 .41871 L
.27849 .41926 L
.27852 .42028 L
.27855 .42135 L
.27858 .42207 L
.27861 .42219 L
.27864 .42229 L
.27865 .42236 L
.27867 .422 L
.27869 .42079 L
.2787 .4195 L
.27877 .41474 L
.27882 .40924 L
.27885 .40615 L
.27888 .40565 L
.2789 .40575 L
.27893 .40586 L
.27895 .40578 L
.27898 .40482 L
.279 .4038 L
.27903 .40269 L
Mistroke
.27906 .40283 L
.27909 .40407 L
.27912 .40539 L
.27914 .40606 L
.27915 .40537 L
.27918 .40263 L
.27921 .40009 L
.27924 .39749 L
.27926 .39731 L
.27927 .3971 L
.2793 .39673 L
.27933 .3964 L
.27935 .39632 L
.27936 .39626 L
.27938 .39618 L
.2794 .39612 L
.27943 .39592 L
.27945 .39444 L
.27946 .39287 L
.2797 .36922 L
.27976 .36628 L
.27979 .36506 L
.27981 .36444 L
.27982 .36263 L
.27985 .35845 L
.27988 .35455 L
.27991 .35129 L
.27994 .35219 L
.27996 .35307 L
.27999 .35402 L
.28002 .35318 L
.28005 .35172 L
.28007 .3503 L
.2801 .34897 L
.28012 .3502 L
.28015 .35162 L
.28018 .35318 L
.2802 .35391 L
.28021 .35391 L
.28024 .35391 L
.28027 .35391 L
.28028 .35391 L
.2803 .35252 L
.28034 .34847 L
.28037 .34492 L
.28038 .34297 L
.2804 .34194 L
.28043 .34011 L
.28046 .33845 L
.28048 .33731 L
Mistroke
.28051 .33948 L
.28054 .34186 L
.28056 .34316 L
.28058 .34428 L
.2806 .34144 L
.28064 .33831 L
.28074 .32564 L
.28076 .32229 L
.28079 .32079 L
.28082 .31925 L
.28085 .31781 L
.28087 .31742 L
.28088 .31857 L
.28091 .32066 L
.28094 .32269 L
.28097 .32258 L
.281 .32044 L
.28102 .31808 L
.28105 .31567 L
.28108 .31754 L
.28111 .31959 L
.28113 .32071 L
.28114 .32177 L
.28117 .3197 L
.2812 .31698 L
.28133 .30704 L
.28139 .30312 L
.28142 .30095 L
.28144 .29793 L
.28147 .29241 L
.28151 .28637 L
.28157 .27721 L
.2816 .27332 L
.28163 .2691 L
.28165 .26963 L
.28168 .27026 L
.2817 .27083 L
.28173 .27046 L
.28176 .26774 L
.28178 .26519 L
.28181 .26237 L
.28184 .26115 L
.28187 .26054 L
.28189 .25987 L
.28201 .25662 L
.28207 .25514 L
.28211 .25444 L
.28212 .25465 L
.28214 .25485 L
.28221 .2557 L
Mistroke
.28224 .2561 L
.28226 .2563 L
.28228 .25649 L
.28231 .25613 L
.28232 .25525 L
.28234 .2543 L
.28237 .25276 L
.2824 .25089 L
.28243 .24775 L
.28246 .2448 L
.28252 .23853 L
.28255 .23615 L
.28258 .2336 L
.2826 .23315 L
.28261 .23291 L
.28264 .23244 L
.2827 .2313 L
.28273 .23054 L
.28275 .23013 L
.28277 .22974 L
.28279 .22825 L
.28283 .22626 L
.28285 .22458 L
.28288 .22466 L
.28291 .22802 L
.28294 .23122 L
.28296 .23409 L
.28299 .2337 L
.28302 .2326 L
.28305 .23141 L
.28311 .22986 L
.28314 .22917 L
.28317 .22868 L
.2832 .22847 L
.28322 .22825 L
.28329 .22761 L
.28332 .22719 L
.28334 .22699 L
.28335 .22672 L
.28338 .22599 L
.28342 .2252 L
.28345 .22428 L
.28348 .21962 L
.2835 .21555 L
.28353 .21127 L
.28356 .21092 L
.28359 .21269 L
.28361 .21423 L
.28364 .21568 L
.28366 .21388 L
Mistroke
.28369 .21221 L
.28393 .19725 L
.28405 .18631 L
.28408 .18305 L
.28411 .17954 L
.28413 .17948 L
.28414 .18001 L
.28417 .18104 L
.28419 .18157 L
.28421 .18219 L
.28423 .18427 L
.28424 .18621 L
.28431 .19364 L
.28444 .20562 L
.28447 .20685 L
.28449 .20747 L
.2845 .209 L
.28454 .21339 L
.28456 .21551 L
.28457 .21743 L
.2846 .21945 L
.28462 .21925 L
.28463 .21905 L
.28466 .21871 L
.28469 .21945 L
.28475 .22516 L
.28477 .2268 L
.28478 .22797 L
.28481 .2275 L
.28484 .22708 L
.28487 .22664 L
.2849 .22641 L
.28492 .2263 L
.28495 .22618 L
.28497 .22612 L
.28499 .22782 L
.28504 .23475 L
.28515 .24535 L
.28521 .24936 L
.28522 .25038 L
.28524 .25146 L
.28527 .25212 L
.28529 .25166 L
.28531 .25116 L
.28532 .25072 L
.28534 .25025 L
.28535 .24984 L
.28537 .2503 L
.2854 .25113 L
.28543 .25202 L
Mistroke
.28545 .25247 L
.28547 .25394 L
.28553 .25923 L
.28554 .26077 L
.28556 .2614 L
.28558 .26201 L
.2856 .26256 L
.28563 .26357 L
.28564 .26436 L
.28566 .26573 L
.28569 .26803 L
.28572 .2705 L
.28573 .27191 L
.28575 .2718 L
.28578 .27132 L
.28581 .27082 L
.28583 .27054 L
.28584 .27076 L
.28587 .27136 L
.28591 .27199 L
.28594 .27219 L
.28595 .27178 L
.28597 .2714 L
.286 .27064 L
.28602 .27021 L
.28603 .27101 L
.28615 .27912 L
.28628 .28818 L
.28635 .29504 L
.28637 .29712 L
.28639 .29935 L
.2864 .30146 L
.28642 .30096 L
.28645 .30002 L
.28648 .29899 L
.2865 .29844 L
.28652 .29893 L
.28655 .30004 L
.28658 .301 L
.28661 .30261 L
.28662 .30398 L
.28664 .30546 L
.28667 .30806 L
.2867 .30969 L
.28673 .309 L
.28674 .30862 L
.28676 .3082 L
.28679 .30841 L
.28682 .31253 L
.28685 .31691 L
Mistroke
.28691 .32376 L
.28693 .32673 L
.28695 .32829 L
.28697 .32993 L
.287 .33071 L
.28702 .33038 L
.28705 .33005 L
.28708 .32977 L
.28711 .32953 L
.28713 .32932 L
.28716 .32909 L
.28718 .32912 L
.28719 .32925 L
.28722 .32949 L
.28725 .32971 L
.28728 .3295 L
.2873 .32925 L
.28732 .32897 L
.28733 .32868 L
.28735 .32841 L
.28737 .32839 L
.28738 .32866 L
.28742 .32921 L
.28743 .32948 L
.28745 .32973 L
.28748 .33067 L
.28751 .3318 L
.28754 .33293 L
.28756 .33394 L
.28758 .33521 L
.28761 .33793 L
.28763 .33927 L
.28765 .34052 L
.28767 .33887 L
.28771 .33708 L
.28774 .33547 L
.28776 .33481 L
.28779 .33435 L
.28781 .33408 L
.28782 .33384 L
.28786 .33363 L
.28787 .33363 L
.28789 .33363 L
.28792 .33363 L
.28794 .33368 L
.28795 .33392 L
.28798 .33437 L
.28801 .33486 L
.28804 .33551 L
.28806 .33653 L
Mistroke
.28809 .33761 L
.28812 .33879 L
.28815 .33846 L
.28818 .33786 L
.28821 .33728 L
.28824 .33801 L
.28825 .33894 L
.28827 .33982 L
.2883 .34145 L
.28833 .34277 L
.28835 .34319 L
.28836 .34358 L
.28839 .34419 L
.28842 .34466 L
.28844 .34435 L
.28847 .34407 L
.28849 .34374 L
.28852 .34266 L
.28855 .34107 L
.28858 .3396 L
.2886 .33822 L
.28863 .33822 L
.28866 .33822 L
.28869 .33822 L
.28872 .33705 L
.28874 .33509 L
.28878 .33294 L
.2888 .33216 L
.28883 .33336 L
.28887 .33465 L
.28889 .33567 L
.28892 .33626 L
.28895 .33676 L
.28898 .3373 L
.28901 .33833 L
.28903 .33944 L
.2891 .34239 L
.28913 .34421 L
.28916 .3459 L
.28919 .34608 L
.28922 .34492 L
.28928 .34237 L
.28933 .33966 L
.28936 .33813 L
.28939 .33801 L
.28941 .3382 L
.28944 .33841 L
.28946 .33847 L
.28949 .33707 L
.28952 .33538 L
Mistroke
.28955 .33379 L
.28957 .33414 L
.2896 .3357 L
.28963 .3374 L
.28965 .33833 L
.28966 .33877 L
.28969 .33921 L
.28972 .33969 L
.28975 .34004 L
.28978 .33894 L
.28981 .33767 L
.28984 .33652 L
.28986 .33727 L
.28987 .33857 L
.28991 .3415 L
.28994 .34405 L
.28995 .34439 L
.28997 .34446 L
.29 .34458 L
.29003 .34469 L
.29005 .34456 L
.29006 .34421 L
.29009 .34361 L
.29012 .34303 L
.29015 .34401 L
.29018 .34558 L
.29021 .34732 L
.29024 .34864 L
.29027 .349 L
.29029 .3493 L
.29032 .34963 L
.29035 .34894 L
.29038 .34807 L
.29041 .34712 L
.29042 .34662 L
.29044 .3465 L
.29047 .34627 L
.2905 .34603 L
.29052 .34512 L
.29055 .3417 L
.29058 .33866 L
.2906 .3354 L
.29063 .33559 L
.29065 .3372 L
.29068 .33932 L
.29071 .34075 L
.29074 .34013 L
.29077 .33945 L
.2908 .33871 L
.29081 .33896 L
Mistroke
.29083 .33951 L
.29089 .34139 L
.29095 .34278 L
.29098 .34351 L
.291 .34521 L
.29103 .34867 L
.29106 .35243 L
.29111 .3582 L
.29114 .36051 L
.29117 .363 L
.29119 .36414 L
.2912 .36342 L
.29124 .36202 L
.29125 .36132 L
.29127 .36058 L
.29129 .36027 L
.2913 .36096 L
.29134 .3622 L
.29135 .36286 L
.29137 .36355 L
.29139 .36338 L
.2914 .36239 L
.29143 .36065 L
.29147 .35889 L
.29149 .35977 L
.29152 .36136 L
.29155 .36286 L
.29158 .36361 L
.29161 .36287 L
.29164 .36216 L
.29166 .36175 L
.29167 .36193 L
.2917 .36328 L
.29173 .36471 L
.29174 .36546 L
.29176 .36611 L
.29179 .36563 L
.29182 .36511 L
.29184 .36481 L
.29186 .36415 L
.29189 .36128 L
.29192 .35824 L
.29195 .3558 L
.29198 .35555 L
.29201 .35532 L
.29204 .35508 L
.29207 .35433 L
.2921 .3536 L
.29254 .3358 L
.29276 .32901 L
Mistroke
.29279 .32662 L
.29282 .32548 L
.29284 .32579 L
.29286 .32613 L
.29289 .32674 L
.29291 .32642 L
.29294 .3241 L
.29297 .3221 L
.293 .31993 L
.29302 .3205 L
.29304 .32113 L
.29305 .32171 L
.29307 .32236 L
.2931 .324 L
.29312 .32633 L
.29314 .32852 L
.29316 .33244 L
.29319 .33622 L
.29321 .33546 L
.29323 .33462 L
.29326 .33316 L
.29332 .3298 L
.29335 .32769 L
.29338 .3257 L
.29341 .3257 L
.29344 .32583 L
.29347 .32595 L
.2935 .32546 L
.29355 .32396 L
.29358 .3229 L
.29361 .32122 L
.29364 .31962 L
.29366 .31813 L
.29369 .31795 L
.29372 .31864 L
.29374 .31933 L
.29377 .31969 L
.29379 .31937 L
.29381 .31903 L
.29384 .31842 L
.29387 .31793 L
.2939 .31781 L
.29392 .3177 L
.29395 .31759 L
.29397 .31678 L
.29398 .315 L
.29402 .31125 L
.29405 .308 L
.29407 .308 L
.29408 .30846 L
Mistroke
.29411 .30931 L
.29414 .31011 L
.29416 .30945 L
.29418 .30792 L
.29421 .30525 L
.29424 .30246 L
.29427 .30161 L
.29428 .30142 L
.2943 .30121 L
.29433 .30083 L
.29436 .29887 L
.29439 .29602 L
.29442 .29337 L
.29445 .29127 L
.29447 .2895 L
.29451 .28758 L
.29453 .28636 L
.29456 .28742 L
.29459 .2883 L
.29462 .28925 L
.29465 .28917 L
.29467 .28851 L
.29474 .28707 L
.29477 .28639 L
.2948 .28576 L
.29483 .2855 L
.29486 .28573 L
.29489 .28598 L
.29492 .28615 L
.29494 .28593 L
.29497 .2857 L
.295 .28546 L
.29502 .28546 L
.29504 .28553 L
.29506 .28564 L
.29509 .28574 L
.29512 .28467 L
.29515 .28266 L
.29517 .28084 L
.2952 .27891 L
.29523 .2785 L
.29525 .27814 L
.29528 .2777 L
.2953 .27757 L
.29533 .27812 L
.29536 .27863 L
.29539 .2792 L
.29542 .2794 L
.29543 .27946 L
.29545 .27953 L
Mistroke
.29548 .27965 L
.29551 .2795 L
.29554 .27925 L
.29557 .27902 L
.2956 .27826 L
.29563 .27677 L
.29566 .27514 L
.2957 .27284 L
.29573 .2702 L
.29576 .26773 L
.29579 .26837 L
.2958 .27017 L
.29582 .27211 L
.29585 .27564 L
.29588 .2783 L
.2959 .27968 L
.29594 .28133 L
.29597 .28276 L
.296 .28313 L
.29602 .28347 L
.29605 .28384 L
.29607 .28435 L
.29609 .28493 L
.29611 .28581 L
.29614 .28676 L
.29617 .28873 L
.29619 .29165 L
.29622 .29475 L
.29625 .2977 L
.29628 .29801 L
.29631 .29835 L
.29634 .29868 L
.29636 .2994 L
.2964 .30042 L
.29643 .30136 L
.29645 .30187 L
.29648 .30187 L
.29651 .30187 L
.29654 .30187 L
.29655 .30139 L
.29657 .30085 L
.2966 .29991 L
.29661 .29938 L
.29663 .29882 L
.29665 .29782 L
.29666 .29691 L
.29678 .28759 L
.29689 .27755 L
.29695 .2734 L
.29698 .27151 L
Mistroke
.29701 .26975 L
.29703 .26897 L
.29706 .26842 L
.29709 .26782 L
.29712 .26706 L
.29714 .26603 L
.29717 .26491 L
.29722 .26315 L
.29733 .25999 L
.29736 .25904 L
.29739 .25803 L
.29742 .25657 L
.29745 .25481 L
.29758 .24436 L
.2977 .23373 L
.29783 .22278 L
.2979 .21533 L
.29796 .20892 L
.29802 .20444 L
.29805 .20228 L
.29808 .2014 L
.29811 .20277 L
.29812 .20353 L
.29814 .20425 L
.29817 .20377 L
.2982 .20088 L
.29823 .19794 L
.29826 .19539 L
.29829 .19424 L
.29832 .1932 L
.29835 .19222 L
.29837 .1923 L
.2984 .19263 L
.29843 .19297 L
.29846 .19295 L
.29849 .19206 L
.29854 .19048 L
.29858 .18965 L
.29861 .18886 L
.29864 .18836 L
.29866 .18902 L
.29867 .18963 L
.29873 .19207 L
.2988 .19469 L
.29886 .19818 L
.29889 .2003 L
.29892 .20226 L
.29895 .20138 L
.29896 .20042 L
.29898 .1994 L
Mistroke
.29901 .19751 L
.29904 .19703 L
.29906 .19703 L
.29907 .19703 L
.29909 .19703 L
.29911 .19703 L
.29913 .19607 L
.29914 .19479 L
.29918 .19198 L
.29921 .18946 L
.29922 .18915 L
.29924 .18942 L
.29927 .18991 L
.2993 .19035 L
.29931 .19036 L
.29933 .18976 L
.29936 .18851 L
.29939 .18742 L
.29941 .18721 L
.29943 .18746 L
.29946 .18796 L
.29949 .18843 L
.29951 .18955 L
.29954 .19138 L
.29957 .19337 L
.29959 .19446 L
.29961 .19617 L
.29963 .19964 L
.29967 .20346 L
.29969 .20668 L
.29972 .20776 L
.29975 .20872 L
.29978 .20974 L
.29981 .21185 L
.29983 .21418 L
.29985 .2164 L
.29988 .21874 L
.29991 .21907 L
.29994 .21929 L
.29997 .21953 L
.29998 .22013 L
.3 .22131 L
.30011 .22965 L
.30105 .29965 L
.30204 .35271 L
.303 .40258 L
.30392 .44206 L
.30395 .44392 L
.30398 .44591 L
.30401 .44705 L
Mistroke
.30403 .44735 L
.30406 .44767 L
.30409 .44801 L
.30412 .44919 L
.30415 .45035 L
.30416 .45101 L
.30418 .45163 L
.30419 .453 L
.30421 .45498 L
.30424 .45853 L
.30427 .46177 L
.3043 .46369 L
.30433 .4651 L
.30436 .46657 L
.30439 .46755 L
.3044 .46755 L
.30442 .46755 L
.30444 .46755 L
.30445 .46755 L
.30448 .46837 L
.30452 .4704 L
.30453 .47148 L
.30455 .47264 L
.30457 .47368 L
.30458 .47387 L
.30462 .47427 L
.30463 .47449 L
.30465 .47472 L
.30467 .4751 L
.30469 .47576 L
.30472 .47693 L
.30478 .48006 L
.30481 .48187 L
.30483 .48286 L
.30484 .48381 L
.30487 .48405 L
.3049 .4836 L
.30493 .48311 L
.30496 .48337 L
.30499 .48441 L
.30502 .48553 L
.30505 .48669 L
.30506 .48682 L
.30508 .48695 L
.30511 .4872 L
.30514 .48742 L
.30516 .48511 L
.30519 .48258 L
.30525 .47732 L
.3053 .47369 L
Mistroke
.30533 .47164 L
.30535 .47119 L
.30538 .47097 L
.30541 .47073 L
.30544 .46888 L
.30547 .46562 L
.3055 .46171 L
.30553 .45868 L
.30556 .45831 L
.30558 .45812 L
.30559 .45791 L
.30561 .4577 L
.30563 .45727 L
.30566 .45589 L
.30572 .45329 L
.30585 .44668 L
.30608 .42729 L
.30621 .42038 L
.30634 .412 L
.30636 .4081 L
.30639 .40556 L
.30642 .40556 L
.30645 .40556 L
.30648 .40559 L
.3065 .40573 L
.30652 .40586 L
.30655 .40611 L
.30658 .4063 L
.3066 .40581 L
.30663 .40528 L
.30666 .4047 L
.30668 .4056 L
.30671 .40826 L
.30674 .41114 L
.30677 .41354 L
.30679 .41302 L
.30682 .41249 L
.30685 .41198 L
.30688 .41075 L
.3069 .40903 L
.307 .40213 L
.30703 .40012 L
.30706 .39676 L
.30709 .39117 L
.30711 .38609 L
.30714 .38011 L
.30716 .37893 L
.30718 .37824 L
.30724 .37566 L
.30729 .37374 L
Mistroke
.30732 .37274 L
.30735 .37124 L
.30738 .36936 L
.30741 .36732 L
.30744 .36519 L
.30746 .36195 L
.30758 .34863 L
.30761 .34543 L
.30764 .34069 L
.30768 .33533 L
.3077 .33033 L
.30773 .32677 L
.30776 .32457 L
.30782 .3199 L
.30785 .31782 L
.30788 .31586 L
.30791 .3141 L
.30794 .31557 L
.30796 .31756 L
.30799 .31975 L
.30802 .31991 L
.30805 .31766 L
.30815 .3091 L
.30865 .26903 L
.30886 .24062 L
.30909 .21652 L
.30913 .21179 L
.30914 .2093 L
.30916 .2074 L
.30918 .20626 L
.30919 .205 L
.30923 .2028 L
.30926 .20227 L
.30927 .20436 L
.30929 .20626 L
.30932 .21001 L
.30935 .21309 L
.30937 .21298 L
.3094 .21286 L
.30943 .21274 L
.30945 .21128 L
.30947 .20937 L
.30949 .2062 L
.30952 .20282 L
.30955 .20025 L
.30958 .19864 L
.30959 .19778 L
.30961 .19684 L
.30964 .19583 L
.30966 .19576 L
Mistroke
.30968 .19569 L
.30971 .19557 L
.30973 .19474 L
.30976 .19246 L
.3098 .19011 L
.30982 .18823 L
.30984 .18823 L
.30986 .18823 L
.30989 .18823 L
.30991 .18823 L
.30993 .19007 L
.30994 .19285 L
.30996 .19537 L
.30999 .20031 L
.31001 .20309 L
.31003 .20296 L
.31006 .2026 L
.31009 .20222 L
.31015 .20232 L
.31018 .20256 L
.31019 .20269 L
.31021 .20246 L
.31024 .201 L
.31027 .19963 L
.31032 .19622 L
.31035 .19363 L
.31038 .19116 L
.3104 .19128 L
.31042 .19284 L
.31045 .19556 L
.31048 .19807 L
.3105 .19817 L
.31051 .19763 L
.31054 .19664 L
.31057 .19556 L
.3106 .19615 L
.31063 .19801 L
.31066 .19973 L
.31069 .20027 L
.3107 .19908 L
.31072 .19796 L
.31075 .19585 L
.31078 .19414 L
.3108 .19471 L
.31081 .19524 L
.31084 .19606 L
.31087 .19694 L
.3109 .19909 L
.31093 .20123 L
.31096 .20349 L
Mistroke
.31099 .20506 L
.31104 .2071 L
.31107 .2076 L
.3111 .20705 L
.31112 .20657 L
.31115 .20606 L
.31118 .20758 L
.3112 .2102 L
.31123 .21259 L
.31125 .21499 L
.31128 .21452 L
.31131 .21408 L
.31133 .21381 L
.31134 .21355 L
.31137 .21338 L
.3114 .21327 L
.31143 .21317 L
.31146 .21412 L
.31149 .21676 L
.31173 .24333 L
.3118 .25312 L
.31182 .2555 L
.31183 .25731 L
.31185 .25855 L
.31187 .2597 L
.31189 .26076 L
.31191 .26191 L
.31192 .2628 L
.31194 .26248 L
.31197 .26189 L
.312 .26126 L
.31203 .26209 L
.31206 .26441 L
.31209 .26677 L
.31211 .26896 L
.31214 .26954 L
.31217 .27017 L
.31224 .27133 L
.31227 .27185 L
.3123 .27234 L
.31233 .27139 L
.31236 .27008 L
.31242 .26751 L
.31245 .26629 L
.31247 .26569 L
.31249 .26513 L
.31251 .26644 L
.31253 .26781 L
.31255 .26927 L
.3126 .2739 L
Mistroke
.31266 .27704 L
.31269 .27883 L
.31271 .27934 L
.31274 .27983 L
.31276 .28009 L
.31278 .28034 L
.3128 .28036 L
.31283 .28024 L
.31285 .28017 L
.31287 .28011 L
.3129 .28226 L
.31291 .28427 L
.31293 .28612 L
.31295 .2883 L
.31296 .2903 L
.31299 .2905 L
.31302 .28876 L
.31305 .28714 L
.31308 .28638 L
.31311 .28702 L
.31313 .28738 L
.31315 .2877 L
.31318 .28879 L
.31319 .28985 L
.31321 .29086 L
.31347 .30375 L
.31358 .30073 L
.31368 .29683 L
.31371 .29571 L
.31374 .2947 L
.31376 .29557 L
.31377 .29652 L
.3138 .2982 L
.31386 .30108 L
.31388 .30217 L
.31391 .30336 L
.31394 .30566 L
.31396 .30772 L
.31397 .30964 L
.31404 .31739 L
.3141 .32244 L
.31416 .32634 L
.31419 .3277 L
.31422 .32897 L
.31424 .32987 L
.31427 .33084 L
.3143 .33181 L
.31432 .33317 L
.31434 .33524 L
.31437 .33923 L
Mistroke
.3144 .34294 L
.31443 .34443 L
.31444 .34417 L
.31446 .34388 L
.31448 .34361 L
.3145 .34335 L
.31453 .34393 L
.31456 .34504 L
.31457 .34566 L
.31459 .34622 L
.31462 .34677 L
.31465 .34702 L
.31468 .34724 L
.3147 .34724 L
.31473 .34619 L
.31476 .34519 L
.31479 .34412 L
.31481 .34734 L
.31484 .35173 L
.31486 .35415 L
.31488 .35646 L
.31491 .35787 L
.31494 .35753 L
.31496 .3572 L
.31499 .35693 L
.31501 .35686 L
.31502 .3568 L
.31505 .35668 L
.31507 .35662 L
.31509 .35684 L
.31511 .35725 L
.31512 .35763 L
.31515 .35838 L
.31518 .35829 L
.3152 .35709 L
.31521 .35599 L
.31525 .35352 L
.31526 .35237 L
.31528 .35162 L
.3153 .35102 L
.31532 .35047 L
.31538 .34771 L
.31561 .33835 L
.31567 .33649 L
.3157 .33528 L
.31573 .33416 L
.31576 .33451 L
.31579 .33657 L
.31582 .33884 L
.31585 .34073 L
Mistroke
.31588 .34172 L
.31591 .34277 L
.31594 .34383 L
.31595 .3438 L
.31597 .34361 L
.316 .34328 L
.31602 .34297 L
.31605 .34436 L
.31608 .34679 L
.3161 .349 L
.31613 .35122 L
.31616 .35102 L
.31618 .35083 L
.31621 .35062 L
.31624 .35104 L
.31626 .35259 L
.31629 .35401 L
.31651 .36166 L
.31674 .37237 L
.31677 .3741 L
.31681 .37573 L
.31684 .37674 L
.31686 .3773 L
.31688 .37782 L
.31691 .3785 L
.31692 .37862 L
.31694 .37876 L
.317 .37934 L
.31706 .38057 L
.31709 .38101 L
.31711 .3808 L
.31712 .38061 L
.31715 .38027 L
.31718 .37995 L
.31721 .3817 L
.31724 .38339 L
.31727 .38506 L
.3173 .38503 L
.31732 .38413 L
.31735 .38331 L
.31738 .38257 L
.3174 .3825 L
.31741 .38244 L
.31744 .38233 L
.31747 .38193 L
.3175 .38017 L
.31753 .37827 L
.31759 .37539 L
.31762 .37406 L
.31764 .37334 L
Mistroke
.31766 .37267 L
.31769 .37195 L
.31772 .37117 L
.31775 .3705 L
.31778 .37132 L
.31781 .37245 L
.31783 .3735 L
.31786 .37429 L
.31788 .37471 L
.31793 .37555 L
.31799 .37606 L
.31802 .37629 L
.31804 .37658 L
.31806 .37709 L
.31808 .37763 L
.31811 .37858 L
.31814 .37954 L
.31816 .37823 L
.31819 .37672 L
.31822 .37531 L
.31825 .37449 L
.31829 .37382 L
.31832 .37323 L
.31835 .37369 L
.31838 .37482 L
.31841 .37589 L
.31843 .37598 L
.31846 .37462 L
.31851 .37216 L
.31857 .36926 L
.3186 .36798 L
.31863 .36718 L
.31866 .36695 L
.31869 .36671 L
.3187 .36658 L
.31872 .36677 L
.31875 .36739 L
.31878 .36801 L
.31881 .36839 L
.31884 .36818 L
.31887 .36795 L
.3189 .3677 L
.31892 .36775 L
.31893 .36782 L
.31897 .36795 L
.31899 .36803 L
.319 .36882 L
.31904 .37181 L
.31907 .37506 L
.31908 .37655 L
Mistroke
.3191 .37732 L
.31913 .37756 L
.31915 .37768 L
.31916 .37782 L
.31919 .37823 L
.31923 .37936 L
.31926 .38061 L
.31938 .38565 L
.31941 .38745 L
.31943 .3884 L
.31945 .3894 L
.31947 .39028 L
.31949 .39055 L
.3195 .39041 L
.31952 .39028 L
.31955 .39003 L
.31958 .38971 L
.3196 .38944 L
.31961 .38916 L
.31965 .38865 L
.31966 .3884 L
.31968 .38779 L
.31971 .38654 L
.31977 .38443 L
.3199 .38094 L
.32013 .37542 L
.32024 .37375 L
.3203 .37229 L
.32033 .37157 L
.32036 .37131 L
.32039 .37105 L
.32041 .37092 L
.32043 .37077 L
.32046 .36836 L
.32049 .36555 L
.32061 .35249 L
.32067 .34599 L
.32069 .34431 L
.3207 .34251 L
.32074 .34074 L
.32075 .34025 L
.32077 .3398 L
.32081 .33877 L
.32087 .33695 L
.32099 .33395 L
.32105 .33231 L
.32107 .33185 L
.32108 .33135 L
.3211 .33059 L
.32112 .32825 L
Mistroke
.32117 .31926 L
.32119 .31679 L
.32121 .31554 L
.32124 .31431 L
.32127 .31304 L
.3213 .31131 L
.32133 .30855 L
.32136 .30557 L
.32158 .28494 L
.32181 .2554 L
.32185 .24962 L
.32188 .24568 L
.3219 .24441 L
.32192 .24304 L
.32193 .2419 L
.32195 .24064 L
.32197 .23986 L
.32198 .2398 L
.32202 .23967 L
.32204 .23955 L
.32208 .23958 L
.32211 .23971 L
.32213 .23982 L
.32216 .23846 L
.32218 .23666 L
.3222 .23504 L
.32226 .22868 L
.32233 .22204 L
.32239 .2175 L
.32241 .21578 L
.32244 .21437 L
.32247 .21493 L
.3225 .21545 L
.32253 .21601 L
.32256 .21529 L
.32257 .21463 L
.32259 .21394 L
.32262 .21269 L
.32264 .21255 L
.32266 .21291 L
.32269 .21358 L
.32271 .2139 L
.32272 .21423 L
.32275 .21551 L
.32279 .21693 L
.3228 .21771 L
.32282 .21845 L
.32285 .21758 L
.32288 .21679 L
.32291 .21604 L
Mistroke
.32294 .21674 L
.32295 .21747 L
.32297 .21827 L
.32298 .21906 L
.323 .2199 L
.32303 .21942 L
.32306 .21813 L
.32312 .21547 L
.32318 .21296 L
.32321 .21126 L
.32323 .20984 L
.32324 .20852 L
.3233 .20388 L
.32334 .20181 L
.32337 .19987 L
.32339 .19889 L
.3234 .19871 L
.32342 .19894 L
.32344 .19915 L
.32347 .19953 L
.32349 .19985 L
.32351 .2007 L
.32354 .20226 L
.32355 .20308 L
.32357 .20394 L
.3236 .20387 L
.32363 .20245 L
.32365 .20109 L
.32368 .19973 L
.32371 .20009 L
.32374 .20043 L
.32376 .20064 L
.32377 .20084 L
.3238 .20317 L
.32383 .20559 L
.32385 .20692 L
.32387 .20816 L
.32389 .20778 L
.32392 .20682 L
.32394 .20628 L
.32396 .20577 L
.32398 .20648 L
.324 .20735 L
.32402 .20815 L
.32403 .20902 L
.32405 .20998 L
.32408 .20889 L
.3241 .20774 L
.32412 .20666 L
.32417 .20289 L
Mistroke
.32424 .19901 L
.32427 .1976 L
.32431 .19617 L
.32434 .19482 L
.32437 .1945 L
.32439 .19472 L
.32442 .19495 L
.32445 .19457 L
.32448 .19286 L
.32451 .191 L
.32453 .19002 L
.32455 .18949 L
.32457 .18994 L
.3246 .19037 L
.32463 .19085 L
.32466 .19177 L
.32468 .19268 L
.32471 .19367 L
.32474 .1943 L
.32476 .19411 L
.32479 .1939 L
.32481 .19367 L
.32485 .19177 L
.32487 .18913 L
.32489 .18772 L
.32491 .18618 L
.32494 .18546 L
.32497 .18677 L
.32499 .18797 L
.32594 .23691 L
.32684 .27939 L
.32734 .30506 L
.32757 .32049 L
.32763 .32337 L
.32765 .32467 L
.32768 .32586 L
.32771 .32804 L
.32775 .33089 L
.32781 .33601 L
.32783 .33861 L
.32787 .3414 L
.32789 .34338 L
.32792 .3439 L
.32798 .34505 L
.32804 .34607 L
.32815 .34847 L
.32821 .3501 L
.32823 .35087 L
.32826 .35171 L
.32829 .35118 L
Mistroke
.32832 .35008 L
.32835 .34882 L
.32838 .34863 L
.3284 .34954 L
.32843 .35054 L
.32849 .3533 L
.32852 .35533 L
.32855 .35726 L
.32857 .35733 L
.32858 .35653 L
.32861 .35513 L
.32865 .3538 L
.32866 .35419 L
.32868 .35541 L
.32871 .35757 L
.32873 .35958 L
.32876 .36016 L
.32879 .3597 L
.32881 .35943 L
.32882 .35918 L
.32885 .35937 L
.32888 .36073 L
.32891 .36199 L
.32894 .36322 L
.32896 .36354 L
.32898 .36389 L
.32901 .36446 L
.32903 .365 L
.32906 .36292 L
.32909 .36099 L
.32915 .357 L
.3292 .3531 L
.32923 .35118 L
.32926 .35094 L
.32929 .3507 L
.32931 .35056 L
.32932 .3508 L
.32935 .35273 L
.32938 .35486 L
.32941 .35707 L
.32944 .35735 L
.32946 .35735 L
.32947 .35735 L
.32949 .35735 L
.32951 .35735 L
.32954 .35975 L
.32957 .36241 L
.32964 .36798 L
.32967 .37016 L
.3297 .37218 L
Mistroke
.32973 .37227 L
.32976 .37227 L
.32977 .37227 L
.32979 .37227 L
.32982 .37203 L
.32985 .37171 L
.32987 .37141 L
.3299 .37142 L
.32993 .3736 L
.32996 .37579 L
.32999 .37813 L
.33002 .37891 L
.33004 .37944 L
.33007 .38005 L
.33009 .38056 L
.33011 .38141 L
.33014 .38296 L
.33015 .38378 L
.33017 .38464 L
.3302 .3867 L
.33022 .38908 L
.33025 .39134 L
.33027 .39376 L
.3303 .39358 L
.33032 .39245 L
.33036 .39112 L
.33038 .39089 L
.33041 .39311 L
.33044 .39515 L
.33047 .3974 L
.3305 .39812 L
.33052 .39862 L
.33055 .39916 L
.33058 .39862 L
.33061 .39717 L
.33063 .39631 L
.33064 .3955 L
.33067 .39543 L
.3307 .39867 L
.33074 .40218 L
.33077 .40464 L
.3308 .40552 L
.33085 .4071 L
.33091 .40881 L
.33093 .40931 L
.33095 .40979 L
.33098 .41215 L
.33105 .41751 L
.33108 .41955 L
.3311 .42064 L
Mistroke
.33112 .42181 L
.33115 .42298 L
.33118 .42242 L
.33124 .42114 L
.33129 .41965 L
.33132 .41881 L
.33135 .41928 L
.33138 .42039 L
.3314 .42096 L
.33141 .42158 L
.33143 .42189 L
.33145 .42155 L
.33148 .42091 L
.33151 .4203 L
.33153 .42065 L
.33154 .42234 L
.33157 .42514 L
.3316 .42812 L
.33163 .42942 L
.33166 .42895 L
.33169 .42845 L
.33171 .42817 L
.33173 .42826 L
.33176 .4285 L
.33178 .42871 L
.33181 .42938 L
.33185 .43166 L
.33195 .43874 L
.33198 .44048 L
.33201 .44164 L
.33204 .44187 L
.33207 .44209 L
.3321 .44222 L
.33212 .44196 L
.33213 .44169 L
.33216 .44119 L
.33219 .44087 L
.33221 .44183 L
.33223 .44274 L
.33226 .44475 L
.33233 .44824 L
.33236 .44976 L
.33239 .45084 L
.33242 .44955 L
.33244 .44837 L
.33257 .44276 L
.33263 .43985 L
.33266 .43843 L
.33269 .43777 L
.33272 .43731 L
Mistroke
.33275 .43682 L
.33276 .43657 L
.33278 .43709 L
.33281 .43811 L
.33292 .44101 L
.33297 .44236 L
.333 .44307 L
.33303 .44381 L
.33305 .4442 L
.33307 .44372 L
.3331 .44285 L
.33313 .44196 L
.33316 .44288 L
.33318 .44455 L
.33319 .44613 L
.33322 .44908 L
.33329 .45708 L
.33332 .46065 L
.33335 .46221 L
.33338 .46158 L
.33341 .46088 L
.33344 .46073 L
.33346 .46206 L
.33347 .46327 L
.3335 .46565 L
.33353 .46765 L
.33356 .46834 L
.33359 .46909 L
.33362 .46976 L
.33365 .47102 L
.33368 .47262 L
.33371 .47411 L
.33374 .47475 L
.33375 .47469 L
.33377 .47462 L
.3338 .47451 L
.33383 .47406 L
.33386 .47313 L
.33389 .47228 L
.33391 .4715 L
.33394 .47192 L
.33396 .47259 L
.33399 .47322 L
.33402 .4733 L
.33404 .47271 L
.33405 .47216 L
.33408 .47105 L
.3341 .47042 L
.33412 .47064 L
.33423 .47287 L
Mistroke
.33426 .47163 L
.33428 .47095 L
.3343 .4703 L
.33433 .4725 L
.33436 .4747 L
.33439 .477 L
.3344 .47762 L
.33442 .47781 L
.33446 .47824 L
.33447 .47845 L
.33449 .47864 L
.33452 .47843 L
.33454 .4782 L
.33457 .47796 L
.33461 .47813 L
.33464 .4785 L
.33466 .47884 L
.3347 .47809 L
.33471 .47703 L
.33473 .47608 L
.33476 .47437 L
.33478 .47407 L
.33481 .47685 L
.33484 .47978 L
.33487 .48233 L
.33489 .48088 L
.33492 .47888 L
.33495 .47703 L
.33498 .4767 L
.335 .47749 L
.33502 .47832 L
.33503 .47912 L
.33505 .47987 L
.33508 .48038 L
.33511 .48004 L
.33513 .47973 L
.33516 .47932 L
.33519 .47822 L
.33545 .47025 L
.33636 .43361 L
.33734 .3837 L
.33827 .32752 L
.33833 .32249 L
.33836 .31958 L
.33839 .31653 L
.33842 .3144 L
.33845 .31306 L
.33848 .31182 L
.3385 .31069 L
.33853 .30733 L
Mistroke
.33856 .30371 L
.33862 .29619 L
.33868 .28522 L
.33875 .27787 L
.33878 .27431 L
.3388 .27274 L
.33881 .2718 L
.33885 .26984 L
.33889 .26779 L
.33902 .2621 L
.33914 .25336 L
.33926 .24724 L
.33938 .24287 L
.33941 .24275 L
.33944 .24263 L
.33946 .24253 L
.33948 .24118 L
.33951 .23883 L
.33953 .23662 L
.33957 .23652 L
.33959 .23893 L
.33962 .24157 L
.33965 .24402 L
.33968 .24233 L
.33973 .23904 L
.33979 .23682 L
.33982 .23606 L
.33985 .23495 L
.33988 .23325 L
.33991 .23141 L
.33998 .22709 L
.3401 .21923 L
.34022 .2099 L
.34025 .20775 L
.34029 .20545 L
.34032 .20386 L
.34035 .20638 L
.34041 .21183 L
.34047 .21554 L
.34048 .21661 L
.3405 .2176 L
.34052 .21678 L
.34053 .21415 L
.3406 .20361 L
.34064 .19916 L
.34067 .19431 L
.34069 .1921 L
.3407 .19041 L
.34073 .18981 L
.34076 .18925 L
Mistroke
.34079 .18864 L
.34081 .18925 L
.34083 .18988 L
.34086 .19113 L
.34088 .19217 L
.34091 .19106 L
.34094 .18917 L
.34097 .18741 L
.34103 .18414 L
.34106 .18267 L
.34109 .18149 L
.3411 .18104 L
.34112 .18057 L
.34114 .18006 L
.34116 .17958 L
.34119 .17954 L
.3412 .18029 L
.34122 .18109 L
.34145 .19462 L
.34151 .19785 L
.34153 .1988 L
.34155 .1998 L
.34158 .20092 L
.3416 .20156 L
.34163 .20226 L
.34169 .20387 L
.34171 .20437 L
.34173 .20485 L
.34174 .20528 L
.34176 .20722 L
.34178 .21027 L
.3418 .21349 L
.34181 .21628 L
.34183 .21929 L
.34186 .22174 L
.34189 .2221 L
.34191 .2223 L
.34193 .22252 L
.34194 .22302 L
.34196 .22486 L
.34199 .22834 L
.34202 .23162 L
.34204 .23293 L
.34206 .23264 L
.34209 .23214 L
.34212 .23166 L
.34213 .23182 L
.34215 .2335 L
.34218 .23649 L
.34221 .23925 L
Mistroke
.34224 .24068 L
.34226 .24023 L
.34227 .23975 L
.3423 .23894 L
.34232 .23848 L
.34233 .23888 L
.34236 .24025 L
.34239 .24151 L
.34242 .24289 L
.34245 .24318 L
.34248 .24342 L
.34249 .24356 L
.34251 .24369 L
.34254 .24548 L
.34257 .24728 L
.34259 .24832 L
.3426 .24942 L
.34263 .25013 L
.34265 .25033 L
.34267 .25052 L
.34269 .25075 L
.3427 .25096 L
.34273 .25034 L
.34276 .24961 L
.34279 .24896 L
.34282 .24932 L
.34287 .25117 L
.3429 .25201 L
.34293 .25042 L
.34296 .24853 L
.34297 .24749 L
.34299 .24653 L
.34302 .24297 L
.34305 .23889 L
.34316 .22657 L
.34328 .21499 L
.34335 .20965 L
.34336 .20835 L
.34338 .20716 L
.3434 .20643 L
.34342 .20574 L
.34345 .20448 L
.34346 .20385 L
.34348 .20384 L
.34351 .20482 L
.34354 .20574 L
.34357 .20639 L
.34359 .20386 L
.34362 .20109 L
.34365 .19817 L
Mistroke
.34368 .19718 L
.34371 .19682 L
.34374 .19649 L
.34376 .19559 L
.34379 .1927 L
.34382 .19005 L
.34388 .18447 L
.34391 .18231 L
.34394 .18 L
.34397 .1801 L
.34399 .18166 L
.3441 .18666 L
.3451 .22883 L
.34534 .24699 L
.34547 .25502 L
.3455 .25668 L
.34554 .25828 L
.34555 .25905 L
.34557 .25978 L
.3456 .26003 L
.34563 .26026 L
.34566 .26048 L
.34569 .26017 L
.34572 .25954 L
.34574 .25901 L
.34577 .25908 L
.3458 .26124 L
.34582 .26329 L
.34606 .27669 L
.34628 .28946 L
.3464 .29746 L
.34642 .30082 L
.34645 .30262 L
.34648 .30353 L
.34651 .30453 L
.34652 .3051 L
.34654 .30549 L
.34657 .30597 L
.34659 .30627 L
.34661 .30654 L
.34662 .30679 L
.34664 .30652 L
.34667 .3058 L
.3467 .30503 L
.34676 .30349 L
.34679 .30272 L
.34682 .30189 L
.34684 .30231 L
.34687 .30272 L
.3469 .30322 L
Mistroke
.34693 .30389 L
.34696 .30473 L
.34699 .30565 L
.34724 .3159 L
.34727 .31889 L
.3473 .32097 L
.34733 .32194 L
.34737 .323 L
.3474 .32371 L
.34742 .32382 L
.34745 .32394 L
.34748 .32405 L
.34751 .32596 L
.34753 .32824 L
.34759 .33287 L
.3477 .3407 L
.34793 .36244 L
.34799 .36717 L
.34803 .36937 L
.34804 .37044 L
.34806 .37142 L
.34809 .37262 L
.34811 .37388 L
.34818 .37641 L
.34821 .37755 L
.34824 .37877 L
.34826 .37956 L
.34828 .38073 L
.34831 .3828 L
.34833 .38375 L
.34835 .38475 L
.34836 .38421 L
.34838 .38348 L
.34841 .38202 L
.34844 .3807 L
.34847 .38081 L
.3485 .38092 L
.34853 .38104 L
.34855 .38135 L
.34856 .38185 L
.34868 .3851 L
.34893 .39393 L
.34915 .40232 L
.34927 .40664 L
.34929 .40641 L
.34933 .40756 L
.34935 .40929 L
.34938 .41085 L
.34941 .41341 L
.34944 .41663 L
Mistroke
.34951 .42346 L
.34957 .42819 L
.34964 .43183 L
.34976 .43834 L
.34988 .44479 L
.3499 .44659 L
.34993 .44858 L
.34996 .45045 L
.34999 .45076 L
.35002 .44872 L
.35005 .44656 L
.35008 .44495 L
.35011 .44471 L
.35014 .44445 L
.35017 .44421 L
.35018 .44448 L
.3502 .44477 L
.35023 .44529 L
.35027 .44587 L
.35028 .44675 L
.3503 .44755 L
.35036 .45056 L
.35042 .4544 L
.35045 .45634 L
.35047 .45676 L
.35048 .45663 L
.35052 .45636 L
.35053 .45621 L
.35055 .45608 L
.35057 .45653 L
.35059 .45702 L
.35062 .45788 L
.35065 .45871 L
.35068 .45911 L
.35071 .45952 L
.35074 .45992 L
.35077 .46203 L
.3508 .464 L
.35083 .46615 L
.35085 .46656 L
.35086 .46613 L
.35089 .46537 L
.35092 .46456 L
.35095 .46435 L
.35098 .46481 L
.351 .46521 L
.35103 .46567 L
.35106 .46768 L
.35109 .46957 L
.35116 .47342 L
Mistroke
.35119 .47487 L
.35122 .47621 L
.35125 .47567 L
.35128 .47485 L
.35129 .47438 L
.35131 .47394 L
.35134 .47399 L
.35137 .4745 L
.3514 .47497 L
.35143 .47487 L
.35145 .47454 L
.35146 .47419 L
.3515 .47357 L
.35153 .4736 L
.35155 .47413 L
.35158 .47471 L
.35161 .47503 L
.35163 .4746 L
.35165 .4742 L
.35168 .47339 L
.3517 .47293 L
.35172 .47159 L
.35175 .46904 L
.35178 .46667 L
.35181 .46525 L
.35183 .46525 L
.35184 .46525 L
.35187 .46525 L
.35189 .46525 L
.35191 .46514 L
.35194 .46487 L
.35197 .46461 L
.352 .46476 L
.35203 .46532 L
.35206 .4659 L
.35207 .46623 L
.35209 .46634 L
.3521 .46622 L
.35212 .46608 L
.35214 .46595 L
.35216 .46581 L
.35217 .46569 L
.35219 .46518 L
.35222 .46388 L
.35225 .46234 L
.35227 .46149 L
.35229 .46109 L
.35232 .46039 L
.35234 .46006 L
.35236 .45975 L
Mistroke
.35238 .45971 L
.35242 .46008 L
.35244 .46044 L
.35246 .46064 L
.35248 .46163 L
.35254 .4658 L
.35259 .46872 L
.35262 .47002 L
.35265 .4712 L
.35267 .47158 L
.35268 .47183 L
.35272 .47239 L
.35275 .47288 L
.35278 .47216 L
.35284 .47038 L
.35287 .47005 L
.3529 .4698 L
.35293 .46958 L
.35295 .46873 L
.35298 .4669 L
.35302 .46495 L
.35307 .46134 L
.35318 .45255 L
.35321 .44947 L
.35324 .44695 L
.35326 .4455 L
.35329 .44392 L
.35332 .44231 L
.35334 .44358 L
.35336 .44477 L
.35339 .44707 L
.35342 .4492 L
.35344 .44957 L
.35347 .44957 L
.3535 .44957 L
.35353 .44851 L
.35356 .44604 L
.35359 .44339 L
.35365 .43875 L
.35379 .42708 L
.35426 .39352 L
.35452 .37895 L
.35455 .37676 L
.35458 .37372 L
.35462 .36911 L
.35463 .36706 L
.35465 .36488 L
.35467 .36334 L
.35468 .36298 L
.35471 .36226 L
Mistroke
.35473 .36186 L
.35475 .36143 L
.35477 .36047 L
.35478 .35882 L
.35491 .34479 L
.35494 .34109 L
.35496 .33838 L
.35497 .33483 L
.35501 .32669 L
.35502 .32299 L
.35504 .31905 L
.35507 .31993 L
.3551 .3216 L
.35512 .32263 L
.35513 .32359 L
.35516 .31936 L
.35528 .30229 L
.35574 .24535 L
.35666 .13145 L
.35691 .10852 L
.35694 .1059 L
.35696 .10405 L
.35697 .10143 L
.357 .09672 L
.35703 .09151 L
.35706 .0887 L
.35709 .0886 L
.35711 .08848 L
.35714 .08837 L
.35717 .08691 L
.3572 .0853 L
.35726 .08127 L
.35729 .07872 L
.35732 .076 L
.35734 .07472 L
.35735 .07588 L
.35738 .07814 L
.35741 .08043 L
.35743 .08149 L
.35745 .08163 L
.35749 .08193 L
.3575 .08207 L
.35752 .0822 L
.35754 .08167 L
.35755 .08086 L
.35759 .07906 L
.35762 .07751 L
.35763 .07845 L
.35765 .07995 L
.35768 .08291 L
Mistroke
.35771 .08567 L
.35774 .08724 L
.35775 .08781 L
.35777 .08842 L
.35779 .08909 L
.35781 .08972 L
.35782 .08928 L
.35784 .08832 L
.35787 .08663 L
.35789 .08574 L
.3579 .08477 L
.35793 .08745 L
.35796 .0906 L
.35798 .09235 L
.358 .0942 L
.35803 .09468 L
.35806 .09445 L
.35808 .09423 L
.35811 .09395 L
.35814 .09358 L
.35817 .09321 L
.3582 .09358 L
.35823 .09594 L
.35826 .09844 L
.35828 .10052 L
.3583 .10213 L
.35833 .10347 L
.35836 .10473 L
.35842 .10713 L
.35845 .10811 L
.35848 .10901 L
.3585 .11245 L
.35853 .11617 L
.35859 .1236 L
.35865 .12976 L
.35867 .13255 L
.35871 .13381 L
.35881 .13813 L
.35884 .13938 L
.35887 .14094 L
.35891 .14326 L
.35894 .14537 L
.35906 .15573 L
.35949 .20256 L
.35997 .23917 L
.36042 .26878 L
.36136 .32889 L
.36227 .36995 L
.36324 .40898 L
.36369 .42827 L
Mistroke
.36417 .4475 L
.3642 .44838 L
.36422 .44912 L
.36424 .45089 L
.36427 .45409 L
.3643 .4576 L
.36432 .45927 L
.36433 .45987 L
.36437 .46119 L
.3644 .46231 L
.36442 .46217 L
.36444 .46153 L
.36446 .46037 L
.3645 .45913 L
.36451 .45901 L
.36453 .45972 L
.36456 .46098 L
.36459 .46217 L
.36461 .46227 L
.36462 .46154 L
.36465 .46009 L
.36468 .45877 L
.36471 .45794 L
.36474 .45782 L
.36477 .4577 L
.36479 .45762 L
.36482 .45895 L
.36486 .46038 L
.36489 .46172 L
.36491 .46245 L
.36497 .46382 L
.36501 .46444 L
.36504 .46492 L
.36507 .46542 L
.3651 .46451 L
.36513 .46236 L
.36514 .46122 L
.36516 .46002 L
.36518 .45918 L
.36519 .45951 L
.36522 .4601 L
.36524 .46044 L
.36526 .4608 L
.36528 .46094 L
.36529 .46057 L
.36532 .45985 L
.36534 .45948 L
.36535 .45908 L
.36538 .45922 L
.36541 .46 L
Mistroke
.36544 .46075 L
.36547 .46102 L
.36549 .45853 L
.36552 .45625 L
.36564 .44443 L
.36569 .43851 L
.36572 .43526 L
.36575 .43287 L
.36577 .43334 L
.36579 .43385 L
.36582 .43474 L
.36584 .43518 L
.36585 .43599 L
.36588 .438 L
.36591 .44008 L
.36593 .44125 L
.36595 .44163 L
.36598 .44017 L
.36601 .43878 L
.36614 .43235 L
.36617 .43021 L
.36619 .42792 L
.36622 .42575 L
.36624 .42502 L
.36627 .42491 L
.36629 .42481 L
.36632 .4247 L
.36635 .42679 L
.36638 .42908 L
.36641 .43149 L
.36644 .43088 L
.36647 .42933 L
.3665 .42792 L
.36653 .42749 L
.36655 .4287 L
.36658 .4298 L
.36661 .4312 L
.36664 .42802 L
.36671 .42081 L
.36676 .41563 L
.36678 .41414 L
.3668 .41274 L
.36683 .41182 L
.36686 .41113 L
.36689 .41041 L
.36691 .41052 L
.36694 .4112 L
.36697 .41193 L
.36699 .41234 L
.367 .41068 L
Mistroke
.36703 .40573 L
.36706 .40104 L
.36729 .3731 L
.36754 .35083 L
.36804 .30073 L
.36828 .27992 L
.36852 .26134 L
.36863 .25349 L
.36866 .25172 L
.36868 .25075 L
.3687 .24985 L
.36872 .24913 L
.36876 .24925 L
.36877 .24932 L
.36879 .24939 L
.36881 .24938 L
.36882 .2487 L
.36888 .24603 L
.36891 .24497 L
.36893 .24461 L
.36895 .24428 L
.36897 .24393 L
.36898 .2436 L
.369 .24305 L
.36902 .24214 L
.36914 .23348 L
.36917 .23052 L
.3692 .22778 L
.36922 .22614 L
.36925 .22434 L
.36927 .22335 L
.36928 .22229 L
.36931 .22289 L
.36935 .22358 L
.36936 .22392 L
.36938 .22421 L
.36941 .22432 L
.36944 .22445 L
.36947 .22456 L
.3695 .22303 L
.36952 .22121 L
.36955 .21947 L
.36958 .21872 L
.36961 .22066 L
.36971 .22598 L
.36974 .22665 L
.36976 .22729 L
.36979 .22898 L
.36982 .23051 L
.36985 .2322 L
Mistroke
.36987 .23223 L
.36988 .23161 L
.36991 .23049 L
.36994 .22927 L
.36997 .22923 L
.37 .22991 L
.37005 .23116 L
.37017 .23359 L
.37028 .2366 L
.37031 .23729 L
.37034 .23793 L
.37036 .23735 L
.37039 .23682 L
.37042 .23623 L
.37044 .23559 L
.37045 .23467 L
.37049 .23269 L
.37052 .23083 L
.37053 .23041 L
.37055 .23062 L
.37058 .23099 L
.3706 .2312 L
.37062 .23142 L
.37063 .23063 L
.37065 .22938 L
.37068 .22719 L
.37071 .2251 L
.37072 .22573 L
.37074 .228 L
.37077 .23199 L
.3708 .23578 L
.37083 .23608 L
.37086 .23445 L
.37089 .23297 L
.37101 .22825 L
.37104 .22601 L
.37107 .22361 L
.3711 .22162 L
.37113 .22288 L
.37116 .22403 L
.37118 .22528 L
.37121 .22533 L
.37124 .22473 L
.37126 .22403 L
.37129 .22376 L
.37132 .22775 L
.37135 .23216 L
.37137 .23432 L
.37138 .23663 L
.37141 .23849 L
Mistroke
.37144 .24032 L
.37146 .24128 L
.37148 .24232 L
.37151 .24224 L
.37154 .24189 L
.37157 .24154 L
.37159 .24217 L
.37162 .24365 L
.37165 .24504 L
.37172 .24876 L
.37185 .25678 L
.37279 .3033 L
.37326 .33619 L
.37351 .35046 L
.37358 .35494 L
.37361 .35763 L
.37365 .36056 L
.37366 .36181 L
.37368 .36311 L
.3737 .36362 L
.37372 .3641 L
.37375 .365 L
.37378 .3657 L
.37381 .36472 L
.37384 .36366 L
.3739 .36174 L
.37393 .36084 L
.37396 .35999 L
.37398 .36039 L
.37401 .36173 L
.37427 .37804 L
.3743 .38184 L
.37433 .38596 L
.37436 .38901 L
.37438 .3899 L
.37444 .39205 L
.37449 .39437 L
.37453 .39573 L
.37455 .39649 L
.37459 .39674 L
.3746 .39688 L
.37462 .39701 L
.37465 .39782 L
.37467 .39931 L
.3747 .40091 L
.37473 .4023 L
.37476 .40025 L
.3748 .39808 L
.37483 .39607 L
.37485 .39696 L
Mistroke
.37488 .39806 L
.3749 .39866 L
.37492 .39922 L
.37493 .39871 L
.37495 .39746 L
.37498 .39527 L
.37501 .39317 L
.37504 .39253 L
.37507 .3921 L
.3751 .39166 L
.37513 .39241 L
.37516 .39431 L
.37522 .39829 L
.37528 .40034 L
.37534 .40272 L
.37537 .40386 L
.3754 .40507 L
.37543 .40705 L
.37545 .40891 L
.37556 .41675 L
.37561 .42132 L
.37564 .42415 L
.37567 .42678 L
.3757 .42814 L
.37571 .42649 L
.37573 .42472 L
.37575 .42184 L
.37578 .41871 L
.37581 .41903 L
.37584 .41948 L
.37587 .41991 L
.37589 .41951 L
.37601 .41643 L
.37604 .41693 L
.37607 .41741 L
.37609 .41661 L
.3761 .41567 L
.37614 .41403 L
.37616 .41259 L
.37619 .41342 L
.37622 .41434 L
.37625 .41534 L
.37627 .41404 L
.3763 .41013 L
.37633 .40636 L
.37635 .40284 L
.37638 .40086 L
.37641 .39953 L
.37644 .39824 L
.37647 .39807 L
Mistroke
.3765 .39912 L
.37652 .40011 L
.37655 .40092 L
.37658 .39929 L
.3766 .39765 L
.37663 .39592 L
.37666 .39499 L
.37669 .39465 L
.37672 .39434 L
.37675 .39389 L
.37677 .39283 L
.3768 .39183 L
.37682 .39127 L
.37683 .39067 L
.37685 .39064 L
.37687 .39064 L
.3769 .39064 L
.37692 .39064 L
.37693 .39061 L
.37696 .39002 L
.37699 .38949 L
.37702 .38887 L
.37705 .38954 L
.37707 .39013 L
.37708 .39069 L
.37711 .39172 L
.37714 .39165 L
.37716 .39116 L
.37718 .39071 L
.3772 .38995 L
.37723 .38965 L
.37726 .39002 L
.37729 .39037 L
.37731 .39057 L
.37733 .3898 L
.37734 .38859 L
.37736 .38747 L
.37742 .38285 L
.37749 .37623 L
.37752 .37191 L
.37756 .36544 L
.37758 .36064 L
.37761 .35807 L
.37763 .35921 L
.37764 .36024 L
.37767 .36227 L
.37771 .36321 L
.37772 .36168 L
.37774 .36027 L
.3778 .35456 L
Mistroke
.37783 .35034 L
.37785 .34581 L
.37788 .34153 L
.37791 .34081 L
.37793 .34126 L
.37796 .34169 L
.37799 .34175 L
.37802 .34025 L
.37852 .31114 L
.37875 .28823 L
.37886 .27433 L
.37893 .26585 L
.37899 .25954 L
.37901 .25777 L
.37902 .2561 L
.37905 .25414 L
.37907 .25354 L
.37909 .25288 L
.37911 .25224 L
.37913 .25153 L
.37914 .25136 L
.37916 .25136 L
.37919 .25136 L
.37922 .25136 L
.37925 .25233 L
.37928 .25348 L
.3793 .25409 L
.37932 .25474 L
.37934 .25365 L
.37935 .25247 L
.37938 .25015 L
.37941 .24792 L
.37943 .24763 L
.37944 .24775 L
.37947 .248 L
.3795 .24822 L
.37953 .24817 L
.37956 .24795 L
.37958 .24773 L
.37961 .24822 L
.37964 .25087 L
.37967 .25368 L
.37969 .25608 L
.37972 .25684 L
.37975 .25634 L
.37978 .25589 L
.37984 .25486 L
.37987 .25439 L
.3799 .25415 L
.37993 .25472 L
Mistroke
.37996 .25535 L
.37999 .25595 L
.38001 .25568 L
.38002 .25543 L
.38005 .25498 L
.38008 .25448 L
.38011 .25364 L
.38014 .2528 L
.38016 .25192 L
.38019 .25147 L
.38021 .2516 L
.38023 .25173 L
.38026 .25197 L
.38028 .25106 L
.38031 .24715 L
.38035 .24253 L
.38037 .24026 L
.38038 .23918 L
.38041 .23824 L
.38043 .23775 L
.38044 .23722 L
.38047 .23664 L
.3805 .23756 L
.38053 .23838 L
.38056 .23929 L
.38059 .24131 L
.38062 .24377 L
.38065 .24605 L
.38068 .24677 L
.38078 .24677 L
.38081 .24677 L
.38084 .24677 L
.38087 .24855 L
.3809 .25138 L
.38096 .258 L
.38099 .26096 L
.38102 .26416 L
.38105 .26657 L
.38108 .26737 L
.38114 .26893 L
.38139 .27904 L
.38161 .28863 L
.38184 .30063 L
.38188 .30312 L
.3819 .30444 L
.38191 .30522 L
.38193 .3056 L
.38195 .30603 L
.38198 .30677 L
.38201 .3066 L
Mistroke
.38203 .30564 L
.38204 .30476 L
.38207 .30303 L
.3821 .30193 L
.38213 .30215 L
.38216 .30238 L
.38222 .30297 L
.38225 .30337 L
.38228 .30375 L
.38231 .30429 L
.38234 .3049 L
.3824 .30603 L
.38243 .30666 L
.38246 .30725 L
.38249 .30727 L
.38252 .30619 L
.38257 .30431 L
.38264 .30137 L
.3827 .29907 L
.38273 .29829 L
.38276 .29747 L
.38277 .29721 L
.38279 .29708 L
.38282 .29684 L
.38285 .29659 L
.38287 .29684 L
.38288 .29742 L
.38294 .29963 L
.38301 .30197 L
.38308 .30501 L
.38311 .30664 L
.38313 .30753 L
.38315 .30837 L
.38317 .30644 L
.38321 .30429 L
.38327 .30012 L
.3833 .29808 L
.38332 .29623 L
.38335 .29599 L
.38338 .29705 L
.38344 .29939 L
.38356 .30606 L
.38359 .30883 L
.38362 .31142 L
.38365 .31252 L
.38368 .31342 L
.3837 .31389 L
.38371 .31433 L
.38373 .31396 L
.38375 .31323 L
Mistroke
.38378 .31181 L
.38381 .31052 L
.38384 .31091 L
.38386 .31164 L
.38392 .31371 L
.38397 .3175 L
.38399 .3194 L
.38402 .31859 L
.38405 .31557 L
.38408 .31275 L
.38411 .31053 L
.38413 .30976 L
.38425 .30592 L
.38428 .30485 L
.3843 .30445 L
.38431 .30427 L
.38434 .30395 L
.38437 .30359 L
.3844 .30276 L
.38443 .30147 L
.38445 .30074 L
.38447 .29996 L
.38448 .29923 L
.3845 .29971 L
.38457 .30228 L
.3846 .30395 L
.38464 .30564 L
.38467 .3072 L
.3847 .30628 L
.38473 .3045 L
.38475 .30357 L
.38476 .30255 L
.38478 .30216 L
.3848 .30204 L
.38483 .3018 L
.38486 .30158 L
.38489 .30263 L
.38492 .30465 L
.38495 .30656 L
.38496 .30759 L
.38498 .30684 L
.38502 .30516 L
.38504 .30391 L
.38507 .30313 L
.3851 .3035 L
.38513 .30385 L
.38514 .30403 L
.38516 .30474 L
.38519 .30778 L
.38522 .31076 L
Mistroke
.38525 .31348 L
.38528 .31458 L
.38531 .31547 L
.38537 .3175 L
.38542 .31938 L
.38545 .32017 L
.38548 .31983 L
.38551 .31944 L
.38553 .31924 L
.38554 .31907 L
.38556 .319 L
.38558 .31893 L
.38561 .31881 L
.38564 .31865 L
.38565 .31838 L
.38567 .31814 L
.3857 .31769 L
.38573 .31721 L
.38576 .31846 L
.38579 .31974 L
.38582 .32111 L
.38584 .32102 L
.38585 .32049 L
.38588 .31959 L
.38591 .31866 L
.38592 .3174 L
.38594 .3143 L
.38597 .30885 L
.38599 .30559 L
.386 .30252 L
.38604 .30047 L
.38605 .30026 L
.38607 .30007 L
.38609 .29984 L
.38611 .29963 L
.38613 .2981 L
.38617 .29618 L
.3862 .29431 L
.38622 .29234 L
.38623 .28986 L
.38626 .28541 L
.38629 .28061 L
.38632 .27811 L
.38635 .27693 L
.38637 .2757 L
.3864 .27486 L
.38644 .27549 L
.38645 .27583 L
.38647 .27615 L
.3865 .27586 L
Mistroke
.38652 .27217 L
.38655 .26787 L
.38658 .26389 L
.38661 .26202 L
.38663 .26045 L
.38666 .25874 L
.38669 .25724 L
.38672 .25601 L
.38675 .25488 L
.38678 .25367 L
.3868 .25475 L
.38681 .25577 L
.38684 .2576 L
.38687 .25932 L
.3869 .25701 L
.38693 .25373 L
.38696 .25005 L
.38699 .24755 L
.38702 .24557 L
.38704 .24446 L
.38705 .2434 L
.38707 .24274 L
.38709 .24332 L
.38712 .24464 L
.38719 .24754 L
.38721 .24907 L
.38724 .25073 L
.38727 .2511 L
.3873 .25069 L
.38733 .2502 L
.38736 .24957 L
.38739 .24826 L
.38742 .24682 L
.38749 .2428 L
.38752 .24044 L
.38755 .23843 L
.38761 .23572 L
.38763 .2343 L
.38767 .2337 L
.38769 .2333 L
.38772 .23287 L
.38774 .23314 L
.38777 .23436 L
.38788 .24179 L
.38811 .25285 L
.38816 .25213 L
.38819 .2519 L
.38822 .25135 L
.38825 .25039 L
.38828 .24933 L
Mistroke
.38831 .24837 L
.38833 .25208 L
.38839 .26192 L
.38842 .26757 L
.38845 .27307 L
.38848 .27803 L
.38851 .28012 L
.38854 .27878 L
.38857 .27755 L
.3886 .27616 L
.38863 .27559 L
.38866 .2749 L
.38869 .27442 L
.38871 .27505 L
.38872 .27573 L
.38876 .27699 L
.38877 .27768 L
.38879 .2778 L
.38881 .27689 L
.38882 .27606 L
.38885 .27456 L
.38888 .27322 L
.3889 .27341 L
.38892 .27362 L
.38895 .27399 L
.38898 .27439 L
.38901 .27614 L
.38906 .2793 L
.38913 .28361 L
.38916 .28584 L
.38917 .28651 L
.38919 .28637 L
.38922 .28615 L
.38925 .28592 L
.38928 .286 L
.38931 .28636 L
.38934 .28674 L
.38936 .28693 L
.38937 .28577 L
.38941 .28347 L
.38944 .28135 L
.38945 .28015 L
.38947 .28065 L
.38951 .28199 L
.38957 .28412 L
.3896 .28483 L
.38963 .2855 L
.38965 .28592 L
.38966 .28666 L
.38969 .28796 L
Mistroke
.38972 .2892 L
.38975 .28947 L
.38978 .28812 L
.3898 .28689 L
.38987 .28338 L
.3899 .28127 L
.38992 .28012 L
.38993 .27927 L
.38996 .27902 L
.39 .27876 L
.39003 .27853 L
.39006 .2789 L
.39009 .27928 L
.39012 .27964 L
.39015 .28213 L
.39018 .28513 L
.3903 .29312 L
.39036 .29868 L
.3904 .30169 L
.39041 .30283 L
.39043 .30204 L
.39046 .30038 L
.39048 .29946 L
.3905 .2986 L
.39052 .29921 L
.39054 .30029 L
.39057 .30218 L
.39105 .32715 L
.39117 .33531 L
.3912 .33813 L
.39124 .34127 L
.39125 .3427 L
.39127 .34423 L
.3913 .3448 L
.39133 .34532 L
.39136 .34582 L
.39139 .34539 L
.39142 .3448 L
.39145 .34424 L
.39148 .34421 L
.3915 .34461 L
.39153 .34505 L
.39156 .34547 L
.39159 .34536 L
.39162 .34524 L
.39164 .34517 L
.39165 .34516 L
.39168 .34597 L
.39171 .34683 L
.39174 .34758 L
Mistroke
.39177 .34761 L
.39179 .34747 L
.3918 .34733 L
.39184 .34708 L
.39185 .34731 L
.39187 .34776 L
.39191 .3488 L
.39192 .34927 L
.39194 .34966 L
.39197 .34678 L
.392 .34366 L
.39202 .34194 L
.39204 .34031 L
.39207 .34353 L
.39209 .34683 L
.39212 .34996 L
.39215 .35201 L
.39218 .35286 L
.39221 .35366 L
.39224 .35449 L
.39227 .35529 L
.3923 .35605 L
.39233 .3562 L
.39236 .35464 L
.39239 .353 L
.3924 .35213 L
.39242 .35115 L
.39245 .34743 L
.39248 .34304 L
.3925 .34111 L
.39252 .3396 L
.39255 .34173 L
.39257 .34397 L
.39259 .34515 L
.39261 .34642 L
.39264 .3462 L
.39267 .34572 L
.3927 .34526 L
.39272 .34613 L
.39275 .34794 L
.39278 .34969 L
.3928 .35148 L
.39283 .35564 L
.39286 .3594 L
.39288 .36273 L
.39291 .36513 L
.39294 .36634 L
.39296 .36746 L
.39308 .37159 L
.39314 .3742 L
Mistroke
.39316 .37542 L
.39319 .37664 L
.39322 .37747 L
.39325 .37835 L
.39327 .37882 L
.39329 .37897 L
.3933 .37836 L
.39332 .37781 L
.39335 .37675 L
.39337 .37577 L
.3934 .37703 L
.39343 .37853 L
.39349 .38146 L
.39352 .38303 L
.39355 .38449 L
.39357 .38555 L
.39359 .38434 L
.39362 .38302 L
.39365 .38181 L
.39367 .3816 L
.3937 .38287 L
.39373 .38407 L
.39376 .38518 L
.39378 .38593 L
.39382 .3867 L
.39384 .38738 L
.39387 .38732 L
.3939 .38699 L
.39393 .38663 L
.39396 .38706 L
.39399 .38833 L
.39402 .3895 L
.39404 .3906 L
.39407 .39008 L
.3941 .38955 L
.39413 .38896 L
.39416 .38803 L
.39419 .38706 L
.39422 .38602 L
.39425 .38636 L
.39428 .38926 L
.39434 .39607 L
.3944 .40284 L
.39441 .4047 L
.39443 .4061 L
.39446 .40373 L
.39452 .39911 L
.39457 .39555 L
.3946 .39391 L
.39462 .39296 L
Mistroke
.39465 .39499 L
.39468 .39685 L
.39471 .39853 L
.39473 .39869 L
.39475 .39809 L
.39478 .39744 L
.39503 .3898 L
.39506 .38814 L
.39508 .38732 L
.39509 .38658 L
.39511 .38611 L
.39513 .38569 L
.39516 .3848 L
.39519 .38424 L
.39521 .38498 L
.39523 .38567 L
.39526 .38706 L
.39527 .38785 L
.39529 .388 L
.39532 .38591 L
.39535 .3837 L
.39538 .38169 L
.39541 .3777 L
.39544 .37414 L
.39547 .37032 L
.3955 .3687 L
.39553 .36767 L
.39559 .36494 L
.39562 .363 L
.39564 .36193 L
.39565 .36093 L
.39567 .35993 L
.39569 .35792 L
.39572 .35443 L
.39575 .35088 L
.39577 .34965 L
.39583 .35336 L
.3959 .35624 L
.39595 .35804 L
.39601 .36018 L
.39603 .36075 L
.39605 .36137 L
.39606 .36081 L
.39608 .35982 L
.39615 .35623 L
.39627 .34837 L
.39673 .31457 L
.39716 .27422 L
.39739 .25289 L
.39745 .24335 L
Mistroke
.39747 .24074 L
.39749 .23843 L
.39752 .2364 L
.39755 .23463 L
.39758 .23274 L
.39759 .2334 L
.39761 .2342 L
.39764 .23578 L
.39771 .2402 L
.39778 .24491 L
.39781 .24655 L
.39784 .24828 L
.39785 .24918 L
.39787 .24939 L
.3979 .24713 L
.39793 .245 L
.39796 .24291 L
.39798 .24264 L
.398 .24236 L
.39803 .24186 L
.39806 .24131 L
.39809 .23979 L
.39812 .23846 L
.39815 .23704 L
.39816 .2356 L
.39818 .23369 L
.39821 .23033 L
.39828 .22334 L
.3984 .2141 L
.39843 .21257 L
.39845 .21184 L
.39848 .2116 L
.39851 .21138 L
.39854 .21011 L
.39856 .20713 L
.39857 .2044 L
.3986 .19913 L
.39863 .19444 L
.39866 .19759 L
.39869 .20104 L
.39872 .2044 L
.39874 .2048 L
.39875 .20493 L
.39878 .20516 L
.3988 .20529 L
.39882 .20542 L
.39885 .20272 L
.39887 .19983 L
.3989 .19708 L
.39893 .19545 L
Mistroke
.39895 .19534 L
.39898 .19524 L
.39901 .19514 L
.39904 .19399 L
.39906 .19273 L
.3991 .19136 L
.39911 .19106 L
.39913 .19139 L
.39916 .19203 L
.39919 .19265 L
.39922 .19363 L
.39925 .19487 L
.39927 .19558 L
.39929 .19623 L
.3993 .19647 L
.39932 .19601 L
.39936 .19501 L
.39941 .19313 L
.39944 .19177 L
.39947 .1905 L
.3995 .19023 L
.39952 .19076 L
.39954 .19133 L
.39957 .19235 L
.3996 .19299 L
.39963 .19335 L
.39966 .19368 L
.39972 .19427 L
.39974 .19448 L
.39977 .19469 L
.3998 .19572 L
.39983 .19683 L
.39986 .19802 L
.39987 .1984 L
.39989 .1976 L
.39995 .19459 L
.39996 .19378 L
.39998 .19328 L
.4 .19284 L
.40001 .19243 L
.40003 .19202 L
.40005 .19162 L
.40008 .19176 L
.40011 .19259 L
.40014 .19347 L
.40017 .19402 L
.4002 .19413 L
.40023 .19425 L
.40026 .19427 L
.40029 .19351 L
Mistroke
.40032 .19269 L
.40034 .19226 L
.40036 .19199 L
.40037 .19185 L
.40039 .1917 L
.40042 .19144 L
.40044 .1913 L
.40046 .19093 L
.40049 .19016 L
.40052 .18946 L
.40055 .18937 L
.40057 .18989 L
.40058 .19045 L
.4007 .19599 L
.40076 .19901 L
.40079 .20025 L
.40082 .20159 L
.40085 .20217 L
.40087 .20239 L
.40091 .20264 L
.40093 .20235 L
.40095 .20181 L
.40097 .2013 L
.401 .20035 L
.40106 .1984 L
.4011 .19748 L
.40111 .19706 L
.40113 .19793 L
.40116 .1995 L
.40119 .20092 L
.40121 .20194 L
.40123 .20351 L
.40127 .20695 L
.40133 .21341 L
.40136 .21642 L
.40138 .21807 L
.4014 .21962 L
.40142 .21971 L
.40145 .21934 L
.40147 .21915 L
.40148 .21895 L
.40151 .21934 L
.40153 .21974 L
.40155 .22011 L
.40156 .22052 L
.40158 .22096 L
.40161 .22428 L
.40164 .2281 L
.40171 .23715 L
.40174 .24163 L
Mistroke
.40177 .24644 L
.4018 .2488 L
.40183 .24956 L
.40185 .25029 L
.40188 .25134 L
.40191 .25412 L
.40193 .25669 L
.40196 .2597 L
.40199 .26155 L
.40202 .26269 L
.40205 .26394 L
.40208 .26486 L
.40211 .26523 L
.40214 .26557 L
.40216 .2659 L
.40219 .26819 L
.40222 .27031 L
.40229 .27582 L
.40242 .28663 L
.40254 .29732 L
.40347 .35506 L
.40371 .36667 L
.40383 .37518 L
.40386 .378 L
.40389 .38101 L
.40392 .38142 L
.40394 .38176 L
.40397 .38213 L
.404 .3823 L
.40403 .38242 L
.40406 .38253 L
.40409 .38295 L
.40412 .38374 L
.40415 .38467 L
.40418 .38539 L
.40421 .38575 L
.40424 .38613 L
.40426 .38635 L
.40428 .38753 L
.4043 .3892 L
.40431 .39101 L
.40435 .39473 L
.40436 .3966 L
.40438 .39704 L
.4044 .3973 L
.40442 .39758 L
.40445 .39809 L
.40451 .39908 L
.40454 .39957 L
.40457 .40023 L
Mistroke
.4046 .40127 L
.40464 .4024 L
.4047 .4051 L
.40472 .40634 L
.40475 .40733 L
.40478 .40623 L
.40481 .4052 L
.40483 .40464 L
.40484 .40404 L
.40487 .40452 L
.4049 .40499 L
.40493 .40543 L
.40495 .40622 L
.40496 .40775 L
.40499 .41042 L
.40502 .41333 L
.40504 .41455 L
.40506 .41524 L
.40512 .41767 L
.40517 .42008 L
.40544 .42826 L
.40547 .43079 L
.4055 .43315 L
.40553 .43473 L
.40555 .43519 L
.40556 .43568 L
.40558 .43621 L
.4056 .43672 L
.40562 .43671 L
.40563 .43621 L
.40567 .43525 L
.4057 .43437 L
.40571 .43485 L
.40573 .43572 L
.40576 .43728 L
.40578 .43815 L
.4058 .43907 L
.40583 .43923 L
.40586 .43923 L
.40588 .43923 L
.40591 .44076 L
.40593 .44204 L
.40595 .4432 L
.40619 .45646 L
.40629 .46282 L
.40635 .46644 L
.40641 .47031 L
.40644 .4722 L
.40646 .47419 L
.40649 .47454 L
Mistroke
.40652 .47465 L
.40655 .47477 L
.40658 .47419 L
.40661 .473 L
.40664 .47171 L
.40666 .47104 L
.40667 .47094 L
.40669 .47087 L
.40671 .4708 L
.40672 .47073 L
.40674 .47066 L
.40677 .47061 L
.4068 .47061 L
.40683 .47061 L
.40684 .47061 L
.40686 .47082 L
.40689 .47143 L
.40692 .47205 L
.40695 .47222 L
.40698 .47086 L
.40701 .46939 L
.40713 .46442 L
.40735 .45179 L
.40746 .44443 L
.40749 .44214 L
.40752 .44001 L
.40755 .44077 L
.40758 .44159 L
.40759 .44206 L
.40761 .4425 L
.40762 .44264 L
.40764 .44256 L
.40768 .44243 L
.40771 .44231 L
.40773 .44182 L
.40776 .44122 L
.40779 .44062 L
.40781 .44002 L
.40783 .43895 L
.40833 .41352 L
.40927 .35096 L
.40975 .33396 L
.40978 .33213 L
.4098 .33112 L
.40982 .33068 L
.40983 .33094 L
.40985 .33121 L
.40988 .3317 L
.4099 .33196 L
.40992 .33144 L
Mistroke
.40993 .33035 L
.40995 .32914 L
.40997 .32781 L
.40999 .3264 L
.41 .32519 L
.41002 .32213 L
.41008 .31175 L
.41015 .30221 L
.41027 .28365 L
.4103 .27937 L
.41032 .27776 L
.41033 .27626 L
.41036 .27358 L
.41038 .27205 L
.4104 .27155 L
.41042 .27134 L
.41045 .27111 L
.41048 .27079 L
.41051 .26966 L
.41054 .26844 L
.41056 .26777 L
.41057 .26713 L
.41059 .26685 L
.41061 .26665 L
.41064 .26625 L
.41067 .26584 L
.4107 .26514 L
.41073 .26439 L
.41075 .26397 L
.41077 .26354 L
.4108 .26226 L
.41082 .2611 L
.41088 .25881 L
.41099 .25233 L
.41102 .25004 L
.41105 .24789 L
.41108 .24659 L
.41111 .24535 L
.41114 .24411 L
.41116 .24384 L
.41117 .24409 L
.4112 .24455 L
.41123 .24505 L
.41126 .24591 L
.41129 .24695 L
.41132 .24788 L
.41135 .24862 L
.41138 .24825 L
.41139 .24806 L
.41141 .24786 L
Mistroke
.41144 .2473 L
.41147 .24537 L
.4115 .24345 L
.41153 .24136 L
.41155 .23997 L
.41158 .23879 L
.41161 .23764 L
.41163 .23675 L
.41166 .23641 L
.41169 .2361 L
.41172 .23575 L
.41175 .23588 L
.41176 .23601 L
.41178 .23615 L
.41181 .23639 L
.41184 .23733 L
.41187 .23838 L
.41193 .23994 L
.41196 .24006 L
.41199 .24018 L
.41202 .24082 L
.41203 .24192 L
.41205 .2431 L
.41212 .24793 L
.41215 .25038 L
.41218 .25259 L
.41221 .2532 L
.41224 .25237 L
.41228 .25149 L
.41229 .251 L
.41231 .25229 L
.41243 .26197 L
.41246 .26435 L
.41249 .2667 L
.41251 .26692 L
.41252 .26712 L
.41255 .26752 L
.41257 .26772 L
.41259 .26822 L
.41261 .26907 L
.41262 .26997 L
.41266 .27148 L
.41267 .27234 L
.41269 .27204 L
.41275 .27062 L
.41281 .26896 L
.41284 .26824 L
.41287 .26747 L
.4129 .27022 L
.41292 .27292 L
Mistroke
.41294 .27444 L
.41296 .27604 L
.41297 .27662 L
.41299 .27662 L
.41302 .27662 L
.41305 .27662 L
.41308 .2781 L
.41311 .27986 L
.41317 .2841 L
.4132 .28674 L
.41323 .28924 L
.41325 .29035 L
.41327 .29006 L
.4133 .28957 L
.41333 .28909 L
.41336 .28873 L
.41339 .28851 L
.41342 .28828 L
.41343 .28814 L
.41345 .28867 L
.41348 .29019 L
.4135 .29105 L
.41352 .29196 L
.41354 .29271 L
.41355 .29307 L
.41362 .2943 L
.41368 .29543 L
.41374 .29643 L
.41377 .29707 L
.4138 .29766 L
.41382 .29797 L
.41383 .29805 L
.41385 .29805 L
.41387 .29805 L
.41388 .29805 L
.4139 .29805 L
.41393 .2984 L
.41396 .29907 L
.41399 .29982 L
.41401 .30019 L
.41402 .30098 L
.41405 .3028 L
.41408 .3046 L
.41411 .30656 L
.41414 .30964 L
.41416 .31299 L
.41423 .31945 L
.41426 .32204 L
.41428 .32345 L
.41429 .32476 L
Mistroke
.41432 .32541 L
.41434 .32554 L
.41436 .32567 L
.41439 .32591 L
.41441 .3266 L
.41444 .32746 L
.41447 .32837 L
.4145 .32994 L
.41453 .33248 L
.41455 .33469 L
.41458 .33706 L
.41461 .33776 L
.41464 .33809 L
.41465 .33829 L
.41467 .3385 L
.4147 .3402 L
.41474 .34282 L
.41476 .34411 L
.41477 .34529 L
.41479 .34549 L
.41481 .34549 L
.41484 .34549 L
.41487 .34549 L
.41489 .3459 L
.4149 .34633 L
.41493 .34721 L
.41496 .34804 L
.41499 .3479 L
.41502 .34756 L
.41505 .34718 L
.41507 .34733 L
.41508 .34929 L
.41511 .35277 L
.41514 .35601 L
.41517 .35845 L
.4152 .3602 L
.41523 .36198 L
.41524 .36291 L
.41526 .36359 L
.41528 .36387 L
.41529 .36413 L
.41533 .36463 L
.41535 .36492 L
.41539 .36443 L
.41541 .36398 L
.41544 .36355 L
.41547 .364 L
.4155 .36457 L
.41553 .3651 L
.41555 .36608 L
Mistroke
.41558 .36793 L
.41561 .3699 L
.41562 .37102 L
.41564 .37184 L
.41567 .37146 L
.41574 .37058 L
.41577 .37011 L
.4158 .3696 L
.41582 .36932 L
.41584 .36942 L
.41586 .36975 L
.41587 .37006 L
.4159 .37064 L
.41593 .37139 L
.41596 .37254 L
.41598 .3738 L
.41611 .3789 L
.41614 .38028 L
.41617 .3818 L
.4162 .38323 L
.41623 .38369 L
.41626 .38357 L
.41629 .38345 L
.41632 .38361 L
.41634 .38396 L
.41635 .38428 L
.41646 .38716 L
.41652 .38908 L
.41657 .39083 L
.41661 .39156 L
.41663 .39191 L
.41665 .3921 L
.41667 .39231 L
.4167 .39251 L
.41672 .39241 L
.41675 .39229 L
.41678 .39218 L
.41681 .39253 L
.41685 .39291 L
.41686 .39312 L
.41688 .39331 L
.41691 .394 L
.41694 .39475 L
.41696 .39518 L
.41697 .39558 L
.41701 .39406 L
.41704 .3923 L
.41706 .39132 L
.41708 .39049 L
.41711 .38953 L
Mistroke
.41713 .38865 L
.41716 .38782 L
.41719 .38807 L
.41722 .38881 L
.41723 .38922 L
.41725 .3896 L
.41728 .39158 L
.41731 .39405 L
.41737 .39892 L
.41743 .40283 L
.41744 .40381 L
.41746 .4045 L
.41748 .40472 L
.41749 .40492 L
.41751 .40512 L
.41753 .40531 L
.41756 .40522 L
.41758 .40409 L
.41761 .40285 L
.41764 .40156 L
.41767 .402 L
.41769 .40271 L
.41772 .40337 L
.41777 .4051 L
.41779 .40604 L
.41782 .40704 L
.41785 .40696 L
.41788 .40617 L
.4179 .40574 L
.41791 .40527 L
.41794 .4048 L
.41797 .4048 L
.418 .4048 L
.41803 .40466 L
.41806 .40374 L
.41811 .40202 L
.41817 .40023 L
.41823 .39834 L
.41828 .39611 L
.41834 .39323 L
.41845 .38681 L
.41848 .38542 L
.4185 .38467 L
.41851 .38422 L
.41853 .3838 L
.41855 .38334 L
.41858 .38254 L
.41871 .38009 L
.41895 .37413 L
.41988 .34239 L
Mistroke
.42011 .33606 L
.42018 .33714 L
.42019 .33756 L
.42021 .33796 L
.42024 .33772 L
.42027 .33701 L
.4203 .33636 L
.42033 .33437 L
.42034 .33221 L
.42036 .33025 L
.42039 .32618 L
.42041 .32389 L
.42043 .32356 L
.42046 .32332 L
.42049 .32307 L
.42051 .32293 L
.42052 .32124 L
.42056 .31786 L
.42063 .31113 L
.42066 .30895 L
.42068 .3078 L
.4207 .30657 L
.42071 .30635 L
.42073 .30621 L
.42076 .30597 L
.42079 .30573 L
.42082 .30625 L
.42085 .30685 L
.42088 .3074 L
.42091 .30591 L
.42094 .30305 L
.42099 .29829 L
.42112 .28764 L
.42115 .28309 L
.42117 .2806 L
.42119 .27922 L
.4212 .27841 L
.42122 .27751 L
.42124 .2767 L
.42125 .27592 L
.42129 .27554 L
.42131 .27646 L
.42134 .27745 L
.42136 .27801 L
.42138 .27643 L
.4216 .25154 L
.42166 .24632 L
.42171 .24206 L
.42174 .23991 L
.42177 .23523 L
Mistroke
.4218 .22995 L
.42182 .22716 L
.42184 .22421 L
.42186 .22215 L
.42187 .22085 L
.42191 .21829 L
.42197 .21373 L
.42203 .20947 L
.42206 .20726 L
.42209 .20522 L
.42212 .20329 L
.42215 .2027 L
.42217 .20327 L
.42221 .20389 L
.42224 .20353 L
.42225 .20226 L
.42227 .20111 L
.4223 .19899 L
.42233 .19723 L
.42236 .19668 L
.42239 .19608 L
.42242 .19553 L
.42244 .19589 L
.42247 .19636 L
.4225 .19681 L
.42251 .19699 L
.42253 .19659 L
.42256 .19587 L
.42259 .19525 L
.42262 .19373 L
.42265 .18964 L
.42267 .1858 L
.4227 .18247 L
.42272 .18083 L
.42275 .17958 L
.42278 .17843 L
.42281 .17804 L
.42282 .17904 L
.42284 .17996 L
.42287 .18162 L
.4229 .18322 L
.42293 .18289 L
.42295 .18258 L
.42301 .18191 L
.42304 .18153 L
.42305 .18133 L
.42307 .18112 L
.42309 .18079 L
.4231 .18005 L
.42313 .1786 L
Mistroke
.42316 .17721 L
.42319 .17692 L
.42322 .1781 L
.42325 .17919 L
.4233 .18172 L
.42335 .18516 L
.42346 .19216 L
.42352 .19666 L
.42354 .19798 L
.42355 .19923 L
.42358 .19921 L
.42361 .19789 L
.42364 .19668 L
.42366 .1961 L
.42369 .20143 L
.42372 .20678 L
.42375 .21175 L
.42378 .21328 L
.42381 .21403 L
.42384 .21468 L
.42386 .21602 L
.42389 .21866 L
.42392 .22115 L
.42416 .23835 L
.4246 .27581 L
.42552 .33533 L
.42651 .3896 L
.427 .41111 L
.42706 .41691 L
.42712 .42327 L
.42715 .42585 L
.42718 .4286 L
.42721 .43021 L
.42724 .43053 L
.42726 .43085 L
.42729 .43118 L
.42732 .43085 L
.42735 .43052 L
.42737 .4302 L
.4274 .42962 L
.42743 .42866 L
.42745 .42763 L
.42748 .42671 L
.42751 .42911 L
.42754 .4317 L
.42756 .43307 L
.42757 .43454 L
.4276 .4362 L
.42763 .43757 L
.42766 .43914 L
Mistroke
.42768 .43961 L
.42771 .43865 L
.42773 .43775 L
.42776 .43678 L
.42779 .43674 L
.42782 .43696 L
.42784 .43716 L
.42787 .43743 L
.42789 .43823 L
.42792 .43911 L
.42795 .44005 L
.42797 .4402 L
.42798 .43977 L
.42801 .43892 L
.42804 .43805 L
.42806 .43791 L
.42808 .43857 L
.42811 .43984 L
.42814 .44103 L
.42816 .44138 L
.42819 .44105 L
.42822 .44072 L
.42825 .44034 L
.42828 .43951 L
.42831 .43863 L
.42836 .43743 L
.42839 .43708 L
.42843 .4367 L
.42844 .43637 L
.42846 .43558 L
.42849 .43419 L
.42852 .43288 L
.42854 .43177 L
.42855 .42987 L
.42861 .42268 L
.42867 .416 L
.42869 .4125 L
.42873 .40895 L
.42876 .40812 L
.42878 .40736 L
.42881 .40666 L
.42883 .40614 L
.42887 .40576 L
.42888 .40556 L
.4289 .40536 L
.42893 .40322 L
.42896 .39977 L
.42898 .39769 L
.429 .39544 L
.42901 .39365 L
Mistroke
.42903 .39338 L
.42906 .39285 L
.42909 .39236 L
.42912 .39267 L
.42915 .3936 L
.42921 .39553 L
.42927 .39724 L
.42931 .39839 L
.42934 .39988 L
.42937 .4013 L
.42938 .4021 L
.4294 .40225 L
.42943 .40123 L
.42946 .40016 L
.42948 .39917 L
.42951 .39735 L
.42954 .39524 L
.42957 .39294 L
.42959 .39182 L
.4296 .39207 L
.42963 .39256 L
.42966 .39304 L
.42969 .39332 L
.42971 .39332 L
.42972 .39332 L
.42975 .39332 L
.42977 .39332 L
.42979 .39214 L
.4298 .39048 L
.42982 .38866 L
.42995 .37852 L
.43008 .3702 L
.43033 .35335 L
.43132 .2891 L
.43156 .26678 L
.43162 .26162 L
.43166 .25889 L
.43169 .25633 L
.4317 .25598 L
.43172 .2556 L
.43176 .25494 L
.43177 .25461 L
.43179 .25394 L
.43182 .25207 L
.43188 .24844 L
.43191 .24605 L
.43195 .24352 L
.43197 .24143 L
.43199 .24156 L
.43201 .24169 L
Mistroke
.43204 .24192 L
.43206 .24214 L
.43209 .24052 L
.43212 .23821 L
.43214 .23629 L
.43217 .23458 L
.4322 .23493 L
.43223 .23529 L
.43226 .23563 L
.43228 .23701 L
.43231 .23858 L
.43234 .24026 L
.43237 .24105 L
.43239 .24014 L
.43243 .23911 L
.43246 .23795 L
.43248 .23632 L
.43251 .23454 L
.43254 .233 L
.43257 .23305 L
.4326 .23364 L
.43262 .23419 L
.43265 .23429 L
.43267 .23363 L
.4327 .23286 L
.43273 .23216 L
.43276 .23229 L
.43279 .23305 L
.43282 .23375 L
.43284 .23372 L
.43286 .23309 L
.43288 .23244 L
.4329 .23126 L
.43297 .22894 L
.43303 .22723 L
.43308 .22586 L
.4331 .22545 L
.43312 .22507 L
.43315 .22619 L
.4332 .22903 L
.43364 .24564 L
.43413 .26879 L
.4346 .30078 L
.43473 .31541 L
.4348 .32493 L
.43482 .32754 L
.43483 .32999 L
.43487 .33198 L
.43489 .33349 L
.43492 .33489 L
Mistroke
.43495 .33471 L
.43498 .33309 L
.43501 .33157 L
.43503 .33071 L
.43504 .33221 L
.43507 .33618 L
.43511 .3405 L
.43514 .3435 L
.43517 .34501 L
.43519 .34643 L
.43522 .34791 L
.43525 .34875 L
.43528 .34954 L
.4353 .35037 L
.43533 .35063 L
.43536 .35016 L
.43539 .34965 L
.43541 .34939 L
.43543 .34882 L
.43546 .34757 L
.43549 .34632 L
.43552 .34584 L
.43554 .34689 L
.43557 .34804 L
.4357 .35198 L
.43573 .35409 L
.43577 .35639 L
.43579 .35751 L
.4358 .35803 L
.43583 .35766 L
.43586 .35734 L
.43589 .357 L
.43592 .3572 L
.43595 .35743 L
.43596 .35756 L
.43598 .3577 L
.436 .35753 L
.43601 .35729 L
.43605 .35679 L
.43607 .35632 L
.4361 .35612 L
.43613 .356 L
.43616 .35588 L
.43619 .35649 L
.43622 .35828 L
.43625 .36026 L
.43626 .36125 L
.43628 .36197 L
.43631 .36209 L
.43634 .3622 L
Mistroke
.43636 .36231 L
.43639 .36349 L
.43642 .36496 L
.43647 .3676 L
.43653 .37153 L
.43654 .37271 L
.43656 .3738 L
.43659 .37367 L
.43662 .37355 L
.43665 .37343 L
.43668 .37372 L
.43671 .37406 L
.43674 .37444 L
.43677 .37618 L
.43702 .39162 L
.43724 .40451 L
.43731 .40885 L
.43737 .41182 L
.43739 .41298 L
.43742 .41396 L
.43745 .41384 L
.43748 .41373 L
.43751 .4136 L
.43753 .41366 L
.43754 .41372 L
.43758 .41385 L
.4376 .41396 L
.43762 .41488 L
.43764 .41618 L
.43767 .41894 L
.4377 .4212 L
.43772 .4202 L
.43774 .41927 L
.43777 .41753 L
.4378 .41593 L
.43783 .41888 L
.43785 .42209 L
.43789 .42557 L
.4379 .42671 L
.43792 .4269 L
.43795 .42727 L
.43798 .42762 L
.43801 .42904 L
.43803 .43145 L
.43806 .43391 L
.43808 .4353 L
.4381 .4353 L
.43811 .43447 L
.43813 .43358 L
.43816 .43195 L
Mistroke
.43819 .43111 L
.43822 .43259 L
.43825 .43388 L
.43827 .43523 L
.43831 .43443 L
.43833 .43341 L
.43844 .42848 L
.4385 .42612 L
.43853 .4252 L
.43856 .42433 L
.43859 .42511 L
.43862 .42598 L
.43865 .42678 L
.43868 .42662 L
.43871 .42599 L
.43874 .42541 L
.43876 .42507 L
.43877 .42391 L
.43881 .42129 L
.43894 .41391 L
.4394 .3813 L
.4399 .3352 L
.44087 .24435 L
.44133 .21375 L
.44156 .19755 L
.4416 .19471 L
.44163 .19238 L
.44164 .19218 L
.44166 .19196 L
.44168 .19178 L
.44169 .19157 L
.44172 .1904 L
.44174 .18832 L
.44176 .18637 L
.44178 .18284 L
.44181 .17925 L
.44183 .17809 L
.44185 .17683 L
.44188 .17462 L
.44189 .17337 L
.44191 .17226 L
.44193 .17326 L
.44194 .17417 L
.44198 .17624 L
.442 .17741 L
.44201 .17747 L
.44203 .17677 L
.44205 .17601 L
.44208 .17447 L
.4421 .17374 L
Mistroke
.44211 .17346 L
.44214 .17299 L
.44221 .17187 L
.44224 .17131 L
.44227 .17072 L
.44228 .17041 L
.4423 .17042 L
.44233 .17102 L
.44236 .17163 L
.44238 .17197 L
.44239 .17211 L
.44242 .17189 L
.44245 .17165 L
.44247 .17152 L
.44248 .17142 L
.44251 .17225 L
.44254 .17316 L
.44256 .17366 L
.44258 .17431 L
.44261 .17744 L
.44264 .18088 L
.44266 .18381 L
.44269 .18463 L
.44271 .18451 L
.44272 .18437 L
.44276 .18412 L
.44279 .18525 L
.44281 .18716 L
.44375 .24997 L
.44475 .34392 L
.44572 .40822 L
.44664 .45211 L
.44687 .4586 L
.44693 .46223 L
.44696 .464 L
.44698 .46488 L
.44699 .46523 L
.44702 .46586 L
.44705 .46646 L
.44708 .46678 L
.44711 .46678 L
.44715 .46678 L
.44716 .46678 L
.44718 .46888 L
.44725 .4766 L
.44728 .47946 L
.44732 .48206 L
.44733 .48331 L
.44735 .4845 L
.44738 .48523 L
Mistroke
.44763 .49003 L
.44774 .49206 L
.44777 .4924 L
.4478 .49273 L
.44782 .49302 L
.44785 .49371 L
.44788 .49483 L
.4479 .49586 L
.44796 .49818 L
.44802 .50071 L
.44808 .50241 L
.44811 .50329 L
.44813 .50344 L
.44815 .50331 L
.44818 .50306 L
.44821 .50283 L
.44824 .5021 L
.44827 .50102 L
.44834 .4982 L
.44837 .49647 L
.4484 .49484 L
.44842 .49488 L
.44845 .49579 L
.44851 .49772 L
.44854 .49884 L
.44856 .49945 L
.44858 .50002 L
.4486 .50022 L
.44862 .49873 L
.44864 .49715 L
.44866 .49457 L
.44869 .49177 L
.44872 .49052 L
.44875 .4894 L
.4488 .48675 L
.44905 .47427 L
.44929 .45703 L
.44956 .4424 L
.45003 .42335 L
.4501 .41865 L
.45017 .41235 L
.4502 .40911 L
.45022 .40748 L
.45024 .40755 L
.45025 .40804 L
.45027 .40858 L
.4503 .40954 L
.45033 .40963 L
.45035 .40877 L
.45036 .40797 L
Mistroke
.45043 .40505 L
.45045 .40473 L
.45048 .40438 L
.45051 .40384 L
.45054 .40117 L
.45057 .39849 L
.45059 .39707 L
.4506 .39554 L
.45063 .39407 L
.45066 .39284 L
.45069 .39157 L
.45072 .38793 L
.45074 .3829 L
.45077 .3774 L
.45078 .37405 L
.4508 .37139 L
.45083 .37023 L
.45086 .36887 L
.45089 .36753 L
.45092 .36425 L
.45095 .36079 L
.45101 .35333 L
.45151 .27626 L
.45199 .21623 L
.45209 .20435 L
.4522 .19112 L
.45225 .18176 L
.45232 .16837 L
.45237 .15662 L
.4524 .15153 L
.45242 .14672 L
.45245 .14556 L
.45248 .14434 L
.4525 .1437 L
.45252 .14289 L
.45255 .1394 L
.45258 .13586 L
.45261 .13253 L
.45264 .13328 L
.45266 .13432 L
.45269 .13531 L
.45272 .13477 L
.45275 .13275 L
.45278 .13086 L
.45289 .12313 L
.45292 .1211 L
.45296 .11892 L
.45297 .11792 L
.45299 .11686 L
.45302 .11646 L
Mistroke
.45305 .11621 L
.45308 .11598 L
.45311 .11629 L
.45314 .11686 L
.45317 .11749 L
.45318 .11789 L
.4532 .11875 L
.45324 .12066 L
.45325 .12149 L
.45327 .12239 L
.4533 .11967 L
.45333 .1157 L
.45335 .11349 L
.45336 .11114 L
.4534 .11122 L
.45342 .1132 L
.45346 .11535 L
.45349 .11585 L
.45351 .11507 L
.45354 .11432 L
.45357 .11369 L
.4536 .11696 L
.45362 .11993 L
.45386 .13956 L
.45389 .14016 L
.45392 .14081 L
.45394 .14143 L
.45397 .14309 L
.45402 .14782 L
.45407 .15278 L
.45419 .16454 L
.4543 .17592 L
.45433 .1787 L
.45436 .18016 L
.45439 .18176 L
.45442 .18326 L
.45445 .18495 L
.45448 .18676 L
.45451 .18831 L
.45454 .18756 L
.45456 .18622 L
.45457 .18495 L
.4546 .18258 L
.45462 .18138 L
.45463 .18187 L
.45467 .18297 L
.4547 .18392 L
.45473 .18554 L
.45475 .18812 L
.45479 .19096 L
Mistroke
.45523 .22462 L
.45568 .25932 L
.45591 .28193 L
.45604 .29129 L
.4561 .29593 L
.45613 .29803 L
.45616 .29938 L
.45618 .29958 L
.4562 .29976 L
.45621 .29997 L
.45623 .30017 L
.45625 .30029 L
.45626 .30009 L
.4563 .29964 L
.45633 .29927 L
.45636 .30045 L
.45643 .30412 L
.45667 .31416 L
.45715 .33624 L
.45764 .36657 L
.45788 .38013 L
.45793 .3858 L
.45796 .38892 L
.45798 .39023 L
.45802 .39085 L
.45804 .39142 L
.45807 .39144 L
.4581 .39018 L
.45813 .38895 L
.45815 .38781 L
.45818 .38776 L
.45821 .38799 L
.45824 .3882 L
.45826 .38876 L
.45829 .39083 L
.45831 .39279 L
.45834 .39485 L
.45837 .39569 L
.45839 .39579 L
.45842 .3959 L
.45845 .39604 L
.45848 .39642 L
.45851 .39675 L
.45854 .3971 L
.45857 .39673 L
.45859 .39629 L
.45861 .39602 L
.45863 .39577 L
.45866 .39649 L
.45869 .39786 L
Mistroke
.45872 .39912 L
.45878 .40219 L
.45881 .40358 L
.45884 .40464 L
.45887 .40512 L
.4589 .40556 L
.45893 .40616 L
.45895 .40774 L
.45898 .40958 L
.45901 .41127 L
.45903 .41139 L
.45906 .41007 L
.45909 .40883 L
.45912 .40796 L
.45915 .40863 L
.45918 .40936 L
.45921 .41008 L
.45922 .41091 L
.45924 .41176 L
.45926 .41321 L
.45929 .41474 L
.45932 .41551 L
.45935 .41551 L
.45937 .41551 L
.4594 .41551 L
.45943 .41529 L
.45946 .41507 L
.45949 .41482 L
.45952 .4153 L
.45953 .41577 L
.45955 .4162 L
.45957 .41669 L
.45958 .41715 L
.4596 .41742 L
.45962 .41742 L
.45965 .41742 L
.45968 .41742 L
.4597 .41832 L
.45971 .41963 L
.45975 .42208 L
.45977 .42441 L
.4598 .42394 L
.45983 .42211 L
.45986 .42013 L
.45988 .41903 L
.45989 .41942 L
.45992 .4204 L
.45995 .42132 L
.45998 .42181 L
.46001 .42064 L
Mistroke
.46007 .41818 L
.4601 .41644 L
.46013 .4148 L
.46016 .41332 L
.46019 .40966 L
.46022 .40607 L
.46025 .40271 L
.46028 .40108 L
.46031 .40058 L
.46034 .40016 L
.46036 .39965 L
.46039 .3985 L
.46042 .39744 L
.46092 .37154 L
.46183 .3091 L
.46234 .26696 L
.46246 .26067 L
.46253 .25706 L
.46259 .25248 L
.46261 .25005 L
.46264 .24775 L
.46267 .24343 L
.46269 .2386 L
.46272 .2336 L
.46275 .22929 L
.46278 .23004 L
.46281 .23074 L
.46286 .23202 L
.46289 .23269 L
.46292 .23339 L
.46293 .23376 L
.46295 .23232 L
.46298 .22979 L
.46304 .22486 L
.46307 .22226 L
.4631 .2198 L
.46312 .21845 L
.46314 .21857 L
.46316 .21917 L
.46317 .21972 L
.4632 .22073 L
.46323 .22116 L
.46325 .22053 L
.46326 .21987 L
.46329 .21865 L
.46375 .204 L
.46422 .17707 L
.46435 .166 L
.46437 .16558 L
.46439 .16394 L
Mistroke
.46442 .16097 L
.46444 .15957 L
.46446 .15808 L
.46449 .15961 L
.46452 .16187 L
.46455 .16429 L
.46458 .1632 L
.46461 .16112 L
.46462 .15994 L
.46464 .15868 L
.46466 .15771 L
.46468 .15804 L
.46471 .15866 L
.46472 .15899 L
.46474 .15931 L
.46477 .15927 L
.4648 .15877 L
.46485 .15791 L
.46488 .15742 L
.46491 .15697 L
.46493 .15671 L
.46494 .15668 L
.46497 .15956 L
.46519 .1773 L
.46523 .17679 L
.46524 .17816 L
.46526 .17966 L
.46529 .18236 L
.4653 .18378 L
.46532 .1853 L
.46534 .18601 L
.46535 .18652 L
.46538 .18751 L
.46545 .18976 L
.46549 .19075 L
.4655 .19127 L
.46552 .19205 L
.46553 .19326 L
.46555 .19459 L
.46558 .19692 L
.46561 .19919 L
.46564 .19702 L
.46567 .19475 L
.46569 .19262 L
.46572 .19267 L
.46574 .19355 L
.46576 .19449 L
.46582 .19794 L
.46594 .20383 L
.46597 .20589 L
Mistroke
.46599 .207 L
.46601 .20736 L
.46605 .20808 L
.46606 .20839 L
.46608 .20872 L
.46611 .20843 L
.46614 .20783 L
.46621 .20679 L
.46624 .20655 L
.46625 .20641 L
.46627 .20628 L
.4663 .20621 L
.46633 .20621 L
.46636 .20621 L
.46637 .20616 L
.46639 .20554 L
.46643 .20414 L
.46644 .20345 L
.46646 .20283 L
.46648 .20334 L
.46651 .20512 L
.46657 .20898 L
.4666 .21142 L
.46663 .21372 L
.46666 .21578 L
.46669 .21638 L
.46672 .21695 L
.46675 .21757 L
.46678 .21856 L
.4668 .21982 L
.46686 .2224 L
.46693 .22518 L
.46698 .22702 L
.46701 .2277 L
.46704 .22833 L
.46706 .2285 L
.46709 .22861 L
.46712 .22871 L
.46714 .22928 L
.46727 .23707 L
.4673 .23854 L
.46732 .23936 L
.46733 .23996 L
.46735 .24027 L
.46737 .24054 L
.46739 .2408 L
.4674 .24108 L
.46743 .24139 L
.46746 .24126 L
.46749 .24115 L
Mistroke
.46752 .24104 L
.46755 .23967 L
.46758 .23808 L
.46761 .23668 L
.46764 .23769 L
.46767 .23912 L
.4677 .24064 L
.46776 .24339 L
.46782 .24688 L
.46785 .24949 L
.46789 .25224 L
.46791 .25339 L
.46793 .25387 L
.46796 .2547 L
.46803 .25658 L
.46816 .2604 L
.46829 .26323 L
.46832 .26323 L
.46835 .26323 L
.46838 .26323 L
.46841 .26589 L
.46844 .26843 L
.46847 .27116 L
.4685 .27136 L
.46852 .27043 L
.46855 .26941 L
.46858 .26913 L
.4686 .27025 L
.46861 .27144 L
.46864 .27358 L
.46888 .29639 L
.46891 .29722 L
.46894 .298 L
.46897 .29946 L
.46898 .30063 L
.469 .30188 L
.46906 .30627 L
.46911 .3116 L
.46914 .31476 L
.46916 .31537 L
.46918 .3155 L
.46921 .31575 L
.46924 .31598 L
.46925 .31655 L
.46927 .31742 L
.4693 .31894 L
.46937 .32248 L
.4694 .32411 L
.46943 .32562 L
.46946 .32672 L
Mistroke
.4695 .32793 L
.46953 .32897 L
.46955 .32923 L
.46958 .32948 L
.46961 .32971 L
.46964 .32952 L
.46967 .32895 L
.4697 .32832 L
.46973 .32856 L
.46976 .3312 L
.46979 .33409 L
.4698 .33555 L
.46982 .33676 L
.46985 .33725 L
.46991 .3382 L
.46997 .33932 L
.46999 .33981 L
.47002 .34072 L
.47004 .34243 L
.47007 .34401 L
.4701 .34584 L
.47013 .34655 L
.47016 .34735 L
.47019 .34808 L
.47022 .34767 L
.47025 .34714 L
.47028 .34656 L
.47031 .34733 L
.47033 .34854 L
.47034 .34965 L
.47038 .35214 L
.47041 .35467 L
.47045 .35759 L
.47048 .36023 L
.47051 .3608 L
.47054 .3608 L
.47055 .3608 L
.47057 .3608 L
.4706 .36353 L
.47061 .36566 L
.47063 .36795 L
.47065 .37034 L
.47067 .37262 L
.4707 .37353 L
.47082 .37772 L
.47085 .38128 L
.47088 .38346 L
.47089 .38359 L
.47091 .38374 L
.47094 .38399 L
Mistroke
.47096 .38413 L
.47098 .38605 L
.47101 .3895 L
.47108 .3964 L
.47114 .40262 L
.47117 .40538 L
.4712 .40755 L
.47123 .40956 L
.47126 .41073 L
.47129 .41029 L
.47131 .40988 L
.47134 .4094 L
.47137 .40994 L
.4714 .41061 L
.47143 .41122 L
.47147 .4128 L
.4715 .4146 L
.47157 .41828 L
.47248 .45624 L
.47295 .47329 L
.47309 .47945 L
.47312 .48151 L
.47314 .48263 L
.47315 .48368 L
.47318 .4839 L
.4732 .48384 L
.47321 .48378 L
.47325 .48365 L
.47327 .4832 L
.4733 .48266 L
.47333 .48209 L
.47336 .48208 L
.47339 .483 L
.47342 .48399 L
.47344 .48456 L
.47345 .48449 L
.47348 .48365 L
.47352 .48274 L
.47355 .48171 L
.47358 .48056 L
.47361 .4795 L
.47363 .4789 L
.47365 .47926 L
.47367 .48124 L
.4737 .48334 L
.47373 .48548 L
.47375 .48477 L
.47377 .48412 L
.4738 .48284 L
.47383 .4818 L
Mistroke
.47384 .483 L
.47386 .48429 L
.4739 .48702 L
.47392 .4885 L
.47394 .4882 L
.47395 .48715 L
.47397 .48601 L
.47445 .46088 L
.47544 .40815 L
.4755 .4024 L
.47553 .39896 L
.47554 .39707 L
.47556 .39629 L
.47559 .39527 L
.47562 .39414 L
.47565 .39288 L
.47567 .38966 L
.47571 .38588 L
.47573 .38382 L
.47574 .38276 L
.47577 .38348 L
.47579 .38389 L
.47581 .38428 L
.47584 .38477 L
.47587 .384 L
.4759 .38317 L
.47591 .38273 L
.47593 .38226 L
.47596 .37904 L
.47598 .37592 L
.47604 .37015 L
.47615 .36284 L
.47618 .35955 L
.47619 .3578 L
.47621 .35595 L
.47624 .35437 L
.47627 .35321 L
.4763 .35199 L
.47633 .34816 L
.47639 .33863 L
.4773 .20178 L
.47774 .15541 L
.47777 .15443 L
.47778 .15409 L
.4778 .15378 L
.47783 .15321 L
.47786 .15088 L
.47793 .14407 L
.47799 .13674 L
.47802 .13342 L
Mistroke
.47805 .12736 L
.4781 .1134 L
.47813 .10633 L
.47815 .10457 L
.47816 .10264 L
.47819 .09947 L
.47822 .09663 L
.47824 .09777 L
.47826 .09883 L
.47829 .10092 L
.47831 .10281 L
.47834 .10145 L
.47837 .09991 L
.4784 .09826 L
.47842 .09798 L
.47844 .09804 L
.47847 .09817 L
.4785 .09829 L
.47853 .09771 L
.47856 .0968 L
.47859 .09598 L
.47862 .09721 L
.47864 .09986 L
.47867 .10287 L
.4787 .10507 L
.47873 .10424 L
.47876 .10334 L
.4788 .10257 L
.47881 .10293 L
.47883 .10325 L
.47886 .10382 L
.47889 .10447 L
.47892 .10672 L
.47895 .10879 L
.47898 .11117 L
.47901 .11153 L
.47902 .11139 L
.47904 .11127 L
.47906 .11113 L
.47907 .11099 L
.4791 .11253 L
.47914 .11474 L
.47921 .11852 L
.48015 .15965 L
.48038 .18068 L
.48044 .18503 L
.48047 .18766 L
.4805 .19015 L
.48051 .19141 L
.48053 .19206 L
Mistroke
.48056 .19321 L
.48063 .19537 L
.4809 .20353 L
.48115 .21226 L
.48211 .23704 L
.48214 .23834 L
.48217 .23759 L
.48219 .23677 L
.48223 .23589 L
.48224 .23675 L
.48226 .23852 L
.48229 .24249 L
.48232 .24615 L
.48235 .24754 L
.48238 .24842 L
.48241 .24936 L
.48247 .25096 L
.48252 .25229 L
.48258 .25415 L
.48261 .25514 L
.48264 .25827 L
.48267 .2616 L
.4827 .26469 L
.48273 .26649 L
.48274 .26669 L
.48276 .2669 L
.48278 .2671 L
.48279 .26729 L
.48282 .26844 L
.48284 .26936 L
.48285 .27037 L
.48287 .27136 L
.48289 .27242 L
.48292 .27529 L
.48295 .27858 L
.48309 .29103 L
.48315 .29594 L
.48318 .29834 L
.48321 .3023 L
.48323 .30763 L
.48327 .31337 L
.48328 .31645 L
.4833 .31789 L
.48331 .31919 L
.48333 .32061 L
.4834 .32574 L
.48344 .32824 L
.48345 .32946 L
.48347 .33059 L
.48349 .33045 L
Mistroke
.4835 .32965 L
.48354 .32798 L
.48357 .32658 L
.48358 .32655 L
.4836 .32679 L
.48363 .32727 L
.48364 .32752 L
.48366 .32779 L
.48369 .32857 L
.48372 .32936 L
.48375 .33019 L
.48378 .33133 L
.48383 .33406 L
.48408 .34984 L
.48432 .36665 L
.48433 .36683 L
.48435 .36758 L
.48438 .36976 L
.48441 .37228 L
.48445 .37482 L
.4845 .38042 L
.48456 .38608 L
.48459 .38831 L
.48462 .39071 L
.48465 .39167 L
.48468 .39201 L
.4847 .39233 L
.48473 .39289 L
.48475 .39391 L
.48478 .39503 L
.48481 .39638 L
.48484 .39646 L
.48485 .39621 L
.48487 .39595 L
.4849 .39546 L
.48493 .39445 L
.48496 .39277 L
.48498 .39121 L
.48501 .39 L
.48504 .39187 L
.48507 .39391 L
.48513 .39702 L
.48516 .39811 L
.48518 .39913 L
.48521 .39975 L
.48524 .39951 L
.48527 .39927 L
.4853 .39929 L
.48532 .40066 L
.48535 .40216 L
Mistroke
.48542 .40523 L
.48545 .40639 L
.48548 .40765 L
.48551 .40844 L
.48554 .4091 L
.48557 .40976 L
.48559 .41019 L
.48562 .4103 L
.48565 .41042 L
.48568 .41054 L
.48571 .41079 L
.48574 .41101 L
.48577 .41125 L
.48579 .41223 L
.48582 .41337 L
.48585 .41447 L
.48587 .41551 L
.4859 .41529 L
.48592 .41509 L
.48595 .41485 L
.48598 .41548 L
.486 .41623 L
.48601 .41706 L
.48604 .4185 L
.48607 .41867 L
.4861 .41685 L
.48613 .41527 L
.48616 .41363 L
.48619 .41548 L
.48621 .41722 L
.48627 .42073 L
.48631 .42218 L
.48633 .42298 L
.48634 .42371 L
.48637 .42206 L
.4864 .41961 L
.48646 .41529 L
.48649 .41325 L
.48652 .41137 L
.48654 .40988 L
.48657 .4117 L
.48659 .41371 L
.48662 .41554 L
.48665 .41647 L
.48668 .416 L
.48673 .41515 L
.48679 .41357 L
.4868 .41314 L
.48682 .41266 L
.48685 .41291 L
Mistroke
.48688 .41349 L
.48691 .4141 L
.48693 .41533 L
.48696 .41741 L
.48699 .41963 L
.48701 .42087 L
.48703 .42088 L
.48706 .41979 L
.48709 .41876 L
.48731 .40803 L
.48755 .39294 L
.4878 .37774 L
.48791 .37143 L
.48794 .36923 L
.48798 .36686 L
.48801 .3653 L
.48803 .36385 L
.48805 .36297 L
.48807 .36215 L
.48808 .36212 L
.4881 .36232 L
.48813 .36271 L
.48816 .36307 L
.48819 .36309 L
.48822 .36309 L
.48825 .36309 L
.48827 .36316 L
.48828 .36328 L
.48831 .3635 L
.48834 .36374 L
.48837 .36325 L
.4884 .3621 L
.4885 .35707 L
.48856 .35381 L
.48861 .35035 L
.48864 .34862 L
.48867 .34844 L
.48868 .34863 L
.4887 .34882 L
.48873 .34918 L
.48876 .35006 L
.48879 .35135 L
.48885 .35402 L
.48888 .35578 L
.4889 .35765 L
.48893 .35925 L
.48896 .35666 L
.48899 .35365 L
.48902 .35079 L
.48903 .35088 L
Mistroke
.48905 .35245 L
.48908 .3552 L
.48911 .35782 L
.48915 .35831 L
.48918 .35807 L
.4892 .35785 L
.48923 .3559 L
.48926 .35167 L
.48928 .34801 L
.48931 .3441 L
.48934 .34418 L
.48937 .3444 L
.48938 .34453 L
.4894 .34466 L
.48943 .34053 L
.48954 .32359 L
.48957 .32204 L
.48959 .32056 L
.48962 .31649 L
.48964 .31111 L
.48967 .30573 L
.4897 .3004 L
.48973 .30148 L
.48975 .30247 L
.48977 .30305 L
.48979 .30366 L
.48982 .30201 L
.48988 .29829 L
.49 .29039 L
.49003 .2871 L
.49005 .28529 L
.49006 .28357 L
.49008 .28198 L
.49009 .28204 L
.49012 .28216 L
.49015 .28227 L
.49018 .2823 L
.49021 .2821 L
.49023 .28188 L
.49026 .28164 L
.49028 .28227 L
.4903 .2832 L
.49033 .28502 L
.49035 .28671 L
.49038 .28712 L
.4904 .28671 L
.49046 .28584 L
.49051 .28461 L
.49054 .28395 L
.49057 .28364 L
Mistroke
.49058 .28384 L
.4906 .28402 L
.49063 .28439 L
.49064 .28458 L
.49066 .28262 L
.49068 .27969 L
.49069 .27696 L
.49072 .27176 L
.49075 .26758 L
.49077 .2669 L
.49078 .26617 L
.49081 .2649 L
.49088 .26192 L
.49091 .26043 L
.49093 .25958 L
.49095 .26052 L
.49097 .26185 L
.49098 .26311 L
.49101 .26547 L
.49104 .26586 L
.49106 .26407 L
.49108 .26241 L
.49131 .24272 L
.49137 .23797 L
.4914 .23533 L
.49143 .23335 L
.49145 .23261 L
.49147 .2318 L
.49148 .23106 L
.4915 .23038 L
.49152 .23026 L
.49153 .23121 L
.49156 .23293 L
.49159 .23454 L
.49162 .23497 L
.49165 .23427 L
.49168 .23351 L
.49174 .23199 L
.49177 .23124 L
.4918 .23089 L
.49183 .23164 L
.49186 .23244 L
.49189 .23324 L
.49192 .23168 L
.49194 .22999 L
.49197 .22818 L
.492 .22785 L
.49202 .22903 L
.49205 .23043 L
.49208 .2318 L
Mistroke
.49211 .23087 L
.49214 .23001 L
.49217 .22901 L
.49219 .22931 L
.49221 .2301 L
.49224 .23163 L
.49227 .23307 L
.4923 .23347 L
.49233 .23359 L
.49234 .23366 L
.49236 .23373 L
.49239 .23331 L
.49241 .233 L
.49242 .23266 L
.49245 .23205 L
.49247 .23212 L
.49249 .23268 L
.49252 .23374 L
.49255 .23463 L
.49258 .23373 L
.49261 .23215 L
.49264 .23072 L
.4927 .22577 L
.49273 .22329 L
.49276 .22109 L
.49279 .22085 L
.49282 .2206 L
.49284 .22046 L
.49285 .22009 L
.49287 .21936 L
.49289 .21868 L
.49292 .21735 L
.49294 .21616 L
.49297 .21616 L
.49301 .21616 L
.49303 .21616 L
.49306 .21498 L
.49309 .21371 L
.49312 .21237 L
.49314 .21164 L
.49317 .21186 L
.4932 .21207 L
.49322 .21226 L
.49325 .21162 L
.49328 .21064 L
.49334 .20817 L
.49339 .20519 L
.49342 .2036 L
.49345 .20706 L
.49348 .21091 L
Mistroke
.4935 .21302 L
.49351 .21498 L
.49354 .21283 L
.49357 .20964 L
.49359 .20784 L
.49361 .20615 L
.49364 .20516 L
.49365 .20496 L
.49367 .20477 L
.49369 .20456 L
.4937 .20434 L
.49373 .20501 L
.49376 .20576 L
.49379 .20658 L
.49381 .20701 L
.49382 .20719 L
.49385 .20757 L
.49387 .20777 L
.49389 .20796 L
.49391 .20731 L
.49394 .2056 L
.49397 .20403 L
.494 .20377 L
.49403 .20731 L
.49405 .21121 L
.49408 .21541 L
.4941 .21557 L
.49412 .21478 L
.49415 .21321 L
.49417 .21176 L
.4942 .21149 L
.49423 .21204 L
.49426 .21264 L
.49429 .21355 L
.49431 .21568 L
.49434 .21798 L
.49439 .22238 L
.49442 .22404 L
.49445 .2256 L
.49446 .22647 L
.49448 .226 L
.49451 .2233 L
.49454 .22096 L
.49456 .21844 L
.49459 .21703 L
.49462 .21591 L
.49464 .21523 L
.49465 .21458 L
.49468 .21487 L
.4947 .21534 L
Mistroke
.49472 .21577 L
.49473 .21628 L
.49475 .21676 L
.49478 .21594 L
.49481 .21483 L
.49487 .21211 L
.4949 .21045 L
.49493 .20891 L
.49496 .20832 L
.49498 .20852 L
.495 .20873 L
.49503 .2091 L
.49506 .21062 L
.49509 .21298 L
.49512 .21553 L
.49515 .21687 L
.49517 .21479 L
.49518 .21284 L
.49522 .20891 L
.49523 .2067 L
.49525 .20713 L
.49531 .20911 L
.49535 .21044 L
.49538 .21233 L
.49589 .23104 L
.49635 .25068 L
.49638 .24922 L
.49641 .25233 L
.49644 .25567 L
.49647 .25885 L
.4965 .26086 L
.49652 .2614 L
.49655 .26201 L
.49657 .26235 L
.49659 .26238 L
.4966 .26225 L
.49662 .26212 L
.49665 .26188 L
.49667 .26174 L
.49668 .26151 L
.49672 .2608 L
.49675 .2602 L
.49677 .25981 L
.4968 .25993 L
.49684 .26006 L
.49687 .26021 L
.4969 .26082 L
.49695 .26194 L
.497 .26311 L
.49703 .26375 L
Mistroke
.49706 .2643 L
.49709 .26344 L
.49712 .26263 L
.49713 .26216 L
.49715 .26171 L
.49718 .26205 L
.49721 .26237 L
.49723 .26271 L
.49726 .26476 L
.49729 .26761 L
.49731 .26917 L
.49732 .27085 L
.49735 .27294 L
.49739 .27407 L
.4974 .27467 L
.49742 .27531 L
.49744 .27574 L
.49745 .27464 L
.49748 .27247 L
.49751 .27051 L
.49754 .26865 L
.49757 .26739 L
.4976 .2662 L
.49762 .26551 L
.49764 .26607 L
.49765 .26769 L
.49767 .26947 L
.49774 .27654 L
.49777 .27904 L
.49779 .28036 L
.49781 .28176 L
.49782 .28285 L
.49784 .28347 L
.49787 .28455 L
.4979 .28566 L
.49793 .28624 L
.49794 .28631 L
.49796 .28637 L
.49798 .28644 L
.49799 .28651 L
.49802 .28657 L
.49804 .28657 L
.49806 .28657 L
.49809 .28657 L
.4981 .28657 L
.49812 .28745 L
.49818 .29078 L
.49824 .29427 L
.49827 .29607 L
.49829 .29773 L
Mistroke
.49832 .29823 L
.49835 .29848 L
.49838 .29869 L
.4984 .29948 L
.49843 .30105 L
.49845 .30188 L
.49847 .30275 L
.4985 .30353 L
.49853 .30285 L
.49855 .30227 L
.49858 .30165 L
.4986 .30294 L
.49863 .30473 L
.49866 .30684 L
.49869 .3075 L
.49872 .30645 L
.49874 .30531 L
.49877 .30442 L
.4988 .30755 L
.49884 .31126 L
.49887 .31459 L
.49889 .3156 L
.4989 .3167 L
.49893 .3187 L
.499 .32355 L
.49903 .32588 L
.49906 .32781 L
.49909 .32685 L
.49913 .32578 L
.49915 .32487 L
.49918 .32302 L
.49921 .32096 L
.49924 .31873 L
.49927 .3192 L
.4993 .32105 L
.49933 .32269 L
.49935 .32431 L
.49938 .32542 L
.4994 .32598 L
.49942 .32659 L
.49945 .32729 L
.49948 .32593 L
.4995 .32459 L
.49953 .32312 L
.49956 .32351 L
.49959 .32416 L
.49962 .32478 L
.49964 .32554 L
.49967 .3269 L
.49969 .32814 L
Mistroke
.49972 .32953 L
.49975 .33012 L
.49977 .33031 L
.49979 .33051 L
.49982 .33089 L
.49985 .33196 L
.49988 .33312 L
.49993 .3353 L
.49996 .33645 L
.49999 .33767 L
.50001 .3383 L
.50003 .33825 L
.50006 .33715 L
.50007 .33652 L
.50009 .33584 L
.50011 .33521 L
.50013 .33663 L
.50016 .34003 L
.50019 .34316 L
.50022 .34492 L
.50025 .34538 L
.50031 .34634 L
.50036 .34699 L
.50039 .34735 L
.50042 .34623 L
.50046 .3447 L
.50049 .34325 L
.50051 .34368 L
.50054 .34511 L
.50061 .3481 L
.50064 .34915 L
.50067 .35029 L
.5007 .35062 L
.50073 .35018 L
.50076 .34973 L
.50078 .34928 L
.50081 .34729 L
.50084 .34511 L
.5009 .33958 L
.50092 .33653 L
.50095 .33322 L
.50098 .33072 L
.501 .32996 L
.50103 .32907 L
.50106 .32813 L
.50109 .32934 L
.50111 .33164 L
.50114 .33406 L
.50117 .3364 L
.50121 .33829 L
Mistroke
.50124 .34005 L
.50125 .34092 L
.50127 .34124 L
.5013 .34112 L
.50133 .34101 L
.50136 .34096 L
.50138 .3427 L
.50141 .34433 L
.50144 .34605 L
.50147 .34613 L
.5015 .34545 L
.50153 .3448 L
.50158 .34383 L
.50169 .34178 L
.50172 .34123 L
.50175 .34079 L
.50177 .34065 L
.50179 .34052 L
.50182 .34027 L
.50185 .33943 L
.50187 .33857 L
.50188 .33777 L
.5019 .33694 L
.50192 .33615 L
.50194 .33572 L
.50195 .33619 L
.50198 .33701 L
.50201 .33787 L
.50203 .33818 L
.50205 .33796 L
.50208 .33759 L
.50211 .33724 L
.50214 .33728 L
.50217 .33777 L
.50219 .33822 L
.50223 .33891 L
.50224 .33968 L
.50226 .34039 L
.50229 .34175 L
.50232 .34264 L
.50234 .34172 L
.50237 .34073 L
.50243 .33841 L
.50255 .33279 L
.50281 .3226 L
.50305 .31447 L
.50308 .3138 L
.50311 .31363 L
.50312 .31356 L
.50314 .3135 L
Mistroke
.50317 .31338 L
.5032 .31082 L
.50323 .30721 L
.50325 .30381 L
.50328 .30283 L
.50331 .30571 L
.50334 .30884 L
.50337 .31138 L
.5034 .31094 L
.50343 .31042 L
.50346 .30994 L
.50349 .30695 L
.50352 .30349 L
.50359 .29816 L
.50365 .29446 L
.50369 .29253 L
.50371 .29152 L
.50373 .29044 L
.50374 .2894 L
.50376 .28919 L
.50378 .28912 L
.50379 .28906 L
.50382 .28894 L
.50384 .28888 L
.50386 .28854 L
.50389 .28782 L
.50391 .28716 L
.50393 .28676 L
.50395 .28605 L
.50396 .28492 L
.50398 .28369 L
.50404 .27963 L
.505 .22706 L
.50525 .21004 L
.50528 .20814 L
.50529 .20826 L
.50531 .20838 L
.50534 .20863 L
.50537 .20885 L
.50539 .20602 L
.50542 .2027 L
.50545 .1989 L
.50548 .19645 L
.5055 .19591 L
.50553 .19534 L
.50556 .19476 L
.50559 .19749 L
.50562 .20033 L
.50564 .20188 L
.50566 .20336 L
Mistroke
.50569 .20199 L
.50572 .2005 L
.50573 .19964 L
.50575 .19883 L
.50577 .19847 L
.50578 .19833 L
.50581 .19809 L
.50584 .19784 L
.50586 .19788 L
.50588 .19803 L
.50591 .19828 L
.50593 .19843 L
.50595 .19854 L
.50597 .1984 L
.50598 .19827 L
.50601 .19805 L
.50604 .19782 L
.50607 .19633 L
.5061 .19479 L
.50611 .19397 L
.50613 .19308 L
.50616 .19261 L
.50619 .19236 L
.50622 .19214 L
.50625 .1913 L
.50628 .1902 L
.5063 .18921 L
.50633 .18829 L
.50636 .18932 L
.50638 .19026 L
.50644 .19279 L
.50694 .21267 L
.50742 .22715 L
.50745 .22594 L
.50747 .22464 L
.5075 .22507 L
.50752 .22554 L
.50755 .22603 L
.50757 .22689 L
.5076 .22986 L
.50763 .23299 L
.50769 .23929 L
.50772 .24214 L
.50775 .24473 L
.50777 .24546 L
.5078 .24443 L
.50783 .24336 L
.50786 .24219 L
.50789 .24478 L
.50792 .24751 L
Mistroke
.50795 .25004 L
.50797 .24871 L
.50801 .2456 L
.50802 .24407 L
.50804 .24265 L
.50807 .24242 L
.5081 .24343 L
.50812 .24431 L
.50815 .24496 L
.50818 .24529 L
.50821 .24565 L
.50824 .246 L
.50826 .24763 L
.50829 .24941 L
.50833 .25132 L
.50836 .25116 L
.50839 .25046 L
.50842 .24976 L
.50844 .24951 L
.50847 .24963 L
.50849 .2497 L
.50851 .24977 L
.50854 .24954 L
.50855 .24921 L
.50857 .2489 L
.50859 .24858 L
.5086 .24823 L
.50864 .24902 L
.50867 .25113 L
.50869 .25308 L
.50883 .26227 L
.50977 .3212 L
.51025 .3447 L
.51031 .35432 L
.51033 .35686 L
.51035 .35902 L
.51038 .36206 L
.5104 .36354 L
.51041 .36512 L
.51044 .36647 L
.51047 .36536 L
.5105 .36414 L
.51053 .36296 L
.51055 .36253 L
.51057 .36214 L
.5106 .36142 L
.51063 .36132 L
.51065 .36292 L
.51066 .36464 L
.5107 .36772 L
Mistroke
.51071 .36949 L
.51073 .37079 L
.51077 .37275 L
.5108 .37449 L
.51082 .37529 L
.51083 .37503 L
.51087 .37445 L
.51089 .37419 L
.5109 .37391 L
.51093 .3758 L
.51096 .3782 L
.51098 .37953 L
.511 .38095 L
.51102 .38117 L
.51103 .38074 L
.51106 .37993 L
.51109 .37908 L
.51111 .37938 L
.51112 .3814 L
.51115 .38493 L
.51118 .38828 L
.51121 .38953 L
.51124 .38895 L
.51127 .38841 L
.5113 .38808 L
.51133 .38869 L
.51136 .38921 L
.51138 .38977 L
.51141 .39215 L
.51144 .39475 L
.51146 .39634 L
.51148 .39785 L
.51151 .39736 L
.51153 .39575 L
.51156 .39403 L
.51159 .39339 L
.51161 .39466 L
.51164 .39615 L
.51167 .39777 L
.5117 .39737 L
.51173 .39683 L
.51176 .39622 L
.51179 .39699 L
.51182 .39843 L
.51184 .4 L
.51196 .40602 L
.51201 .41 L
.51204 .41209 L
.51207 .4136 L
.5121 .4136 L
Mistroke
.51213 .4136 L
.51215 .4136 L
.51218 .41404 L
.51221 .41453 L
.51224 .415 L
.51226 .4152 L
.51228 .41534 L
.51231 .41558 L
.51233 .41572 L
.51234 .41587 L
.51236 .4152 L
.51238 .41423 L
.51241 .41235 L
.51244 .41063 L
.51247 .41192 L
.5125 .41331 L
.51253 .41478 L
.51255 .41497 L
.51256 .41471 L
.51259 .41425 L
.51262 .41382 L
.51265 .41212 L
.51268 .40973 L
.51271 .40737 L
.51274 .40536 L
.51277 .40468 L
.51279 .40407 L
.51282 .40335 L
.51284 .4026 L
.51285 .40184 L
.51289 .40036 L
.51291 .39897 L
.51294 .39902 L
.51297 .3995 L
.513 .39998 L
.51302 .4003 L
.51303 .40081 L
.51307 .40185 L
.51308 .40242 L
.5131 .40294 L
.51313 .40289 L
.51316 .40226 L
.51338 .39663 L
.51341 .39655 L
.51343 .39711 L
.51345 .39741 L
.51347 .39775 L
.5135 .39815 L
.51352 .39593 L
.51355 .39356 L
Mistroke
.51361 .3901 L
.51372 .3847 L
.51375 .3822 L
.51377 .38089 L
.51379 .3798 L
.51382 .37903 L
.51385 .37833 L
.51387 .3777 L
.5139 .37941 L
.51395 .38403 L
.51398 .38579 L
.51401 .38611 L
.51404 .38645 L
.51407 .38671 L
.5141 .38397 L
.51413 .38106 L
.51419 .37689 L
.51422 .37516 L
.51424 .3742 L
.51426 .37288 L
.51428 .36931 L
.51429 .36543 L
.51432 .35861 L
.51444 .33535 L
.5145 .3255 L
.51452 .32296 L
.51454 .32025 L
.51457 .31718 L
.5146 .31464 L
.51463 .31185 L
.5147 .3065 L
.51476 .30033 L
.51479 .29667 L
.51482 .29329 L
.51484 .29082 L
.51487 .2892 L
.51493 .28576 L
.51504 .27951 L
.51528 .26286 L
.51554 .24362 L
.51561 .23892 L
.51566 .23273 L
.51569 .22985 L
.51572 .22898 L
.51575 .2281 L
.51577 .22761 L
.51579 .22758 L
.51582 .22992 L
.51585 .2324 L
.51588 .23457 L
Mistroke
.51591 .23491 L
.51593 .23491 L
.51596 .23491 L
.51599 .23339 L
.51601 .23033 L
.51604 .22696 L
.51607 .22336 L
.5161 .22246 L
.51612 .22186 L
.51615 .22116 L
.51618 .21907 L
.51621 .21562 L
.51624 .21244 L
.51626 .20961 L
.51629 .20894 L
.51634 .20741 L
.51639 .20591 L
.51642 .20509 L
.51645 .20432 L
.51648 .20664 L
.51651 .20927 L
.51654 .21151 L
.51657 .21156 L
.51659 .21131 L
.51661 .21103 L
.51662 .21075 L
.51664 .21046 L
.51666 .21125 L
.51667 .21211 L
.5167 .21381 L
.51676 .2175 L
.51679 .21974 L
.51681 .22096 L
.51683 .2221 L
.51685 .22233 L
.51689 .22183 L
.51691 .2214 L
.51694 .22158 L
.51697 .22265 L
.517 .22364 L
.51703 .22493 L
.51704 .22621 L
.51706 .22763 L
.51709 .23 L
.51712 .23255 L
.51715 .2325 L
.51717 .2324 L
.5172 .2323 L
.51722 .23297 L
.51725 .23528 L
Mistroke
.51728 .23774 L
.51731 .24033 L
.51734 .24046 L
.51736 .24026 L
.51739 .24004 L
.51742 .23914 L
.51744 .23719 L
.51747 .23509 L
.5175 .23306 L
.51753 .23377 L
.51756 .23442 L
.51759 .23504 L
.51761 .2355 L
.51765 .23589 L
.51768 .23626 L
.51771 .23602 L
.51774 .23524 L
.51777 .23441 L
.51778 .23393 L
.5178 .23432 L
.51781 .23526 L
.51783 .23611 L
.51785 .23702 L
.51786 .23803 L
.5179 .23779 L
.51791 .23586 L
.51793 .23405 L
.51796 .23078 L
.51799 .22905 L
.518 .23014 L
.51802 .23133 L
.51805 .23343 L
.51807 .23461 L
.51809 .23508 L
.51811 .2353 L
.51812 .23549 L
.51815 .23585 L
.51818 .23649 L
.5182 .23702 L
.51822 .23759 L
.51825 .2386 L
.51828 .23998 L
.51831 .24201 L
.51837 .2456 L
.5184 .24724 L
.51843 .24879 L
.51845 .24964 L
.51847 .24965 L
.5185 .24704 L
.51853 .24453 L
Mistroke
.51856 .24242 L
.51858 .24425 L
.51861 .24625 L
.51868 .25187 L
.51872 .25567 L
.51873 .25753 L
.51875 .25849 L
.51877 .25812 L
.51878 .25772 L
.5188 .25728 L
.51882 .25688 L
.51885 .25647 L
.51886 .25678 L
.51888 .25711 L
.51891 .25771 L
.51893 .25804 L
.51894 .2586 L
.51896 .25983 L
.51898 .26095 L
.51901 .26314 L
.51907 .26733 L
.5191 .26914 L
.51913 .27088 L
.51916 .27088 L
.51918 .27088 L
.51921 .27088 L
.51924 .27133 L
.51926 .2717 L
.51927 .27211 L
.5193 .27284 L
.51933 .27381 L
.51936 .27491 L
.51939 .27605 L
.51942 .27657 L
.51945 .27474 L
.51947 .27274 L
.5195 .27057 L
.51952 .27087 L
.51954 .27197 L
.51957 .27415 L
.51959 .27615 L
.51962 .27666 L
.51965 .276 L
.51968 .27528 L
.5197 .27474 L
.51973 .27493 L
.51975 .27514 L
.51978 .27537 L
.51981 .27621 L
.51993 .28349 L
Mistroke
.51996 .28601 L
.51998 .28742 L
.52 .28698 L
.52002 .2861 L
.52003 .28514 L
.52006 .28341 L
.52009 .2824 L
.52011 .28247 L
.52012 .28253 L
.52014 .2826 L
.52016 .28266 L
.52019 .28274 L
.52022 .28274 L
.52025 .28274 L
.52028 .28313 L
.5203 .2868 L
.52033 .29043 L
.52036 .29425 L
.52039 .29451 L
.52042 .29384 L
.52047 .29252 L
.52051 .29201 L
.52054 .29152 L
.52057 .29092 L
.5206 .28957 L
.52062 .28845 L
.52065 .28722 L
.52068 .28865 L
.5207 .29102 L
.52075 .29515 L
.52088 .30334 L
.52091 .30698 L
.52093 .30889 L
.52095 .31084 L
.52096 .31198 L
.52098 .31324 L
.52101 .31547 L
.52104 .31759 L
.52106 .31787 L
.52107 .31813 L
.5211 .31859 L
.52114 .31904 L
.52116 .31686 L
.52119 .31483 L
.52122 .31268 L
.52125 .31318 L
.52128 .31532 L
.52131 .31766 L
.52134 .31974 L
.52138 .32178 L
Mistroke
.52139 .32276 L
.52141 .32369 L
.52144 .32412 L
.52147 .32357 L
.52149 .32298 L
.52151 .32262 L
.52153 .32319 L
.52155 .32398 L
.52156 .32484 L
.52158 .32578 L
.5216 .32678 L
.52162 .32748 L
.52163 .32727 L
.5217 .32646 L
.52176 .32572 L
.52179 .32537 L
.52181 .3252 L
.52182 .32513 L
.52185 .32501 L
.52188 .3249 L
.52191 .32451 L
.52193 .32406 L
.52194 .32358 L
.52196 .32311 L
.52198 .32261 L
.52199 .32218 L
.52201 .31995 L
.52204 .31572 L
.52207 .31174 L
.52209 .30953 L
.5221 .30945 L
.52213 .31124 L
.52216 .31294 L
.52219 .31445 L
.52222 .31414 L
.52225 .3138 L
.52228 .31342 L
.52231 .31546 L
.52234 .31862 L
.52237 .32148 L
.5224 .32287 L
.52243 .32376 L
.52246 .32472 L
.52249 .32618 L
.52252 .32778 L
.52255 .32953 L
.52257 .33135 L
.5226 .33471 L
.52263 .3386 L
.52265 .34229 L
Mistroke
.52268 .34396 L
.52271 .34396 L
.52277 .34396 L
.52281 .34396 L
.52284 .34396 L
.52286 .34431 L
.52289 .34578 L
.52292 .3474 L
.52295 .3489 L
.52297 .34931 L
.52299 .34972 L
.52301 .35018 L
.52302 .3506 L
.52304 .35101 L
.52306 .35102 L
.52309 .35026 L
.52312 .3495 L
.52314 .34912 L
.52315 .34945 L
.52319 .35107 L
.52321 .35258 L
.52327 .3564 L
.5233 .35883 L
.52333 .36112 L
.52335 .36165 L
.52337 .36218 L
.5234 .36331 L
.52342 .36382 L
.52344 .36418 L
.52347 .3637 L
.52349 .36324 L
.52352 .36275 L
.52355 .36312 L
.52358 .36353 L
.52361 .36402 L
.52363 .36387 L
.52364 .36214 L
.52367 .35899 L
.5237 .35561 L
.52373 .35541 L
.52376 .35856 L
.52378 .36176 L
.52381 .36473 L
.52383 .36577 L
.52386 .36577 L
.52389 .36577 L
.52392 .3661 L
.52395 .36717 L
.52398 .36833 L
.52401 .36929 L
Mistroke
.52404 .36962 L
.52407 .36995 L
.52409 .37026 L
.52412 .37139 L
.52415 .37303 L
.52437 .3846 L
.5246 .40198 L
.52463 .40425 L
.52465 .40663 L
.52467 .40788 L
.52469 .40834 L
.52472 .40858 L
.52473 .40872 L
.52475 .40887 L
.52477 .40901 L
.52479 .40982 L
.52482 .41156 L
.52485 .41317 L
.52488 .41418 L
.52491 .41465 L
.52492 .4149 L
.52494 .41517 L
.52497 .41544 L
.525 .41522 L
.52502 .41501 L
.52506 .41476 L
.52508 .41539 L
.5252 .42082 L
.52522 .42207 L
.52524 .42341 L
.52525 .42433 L
.52527 .42439 L
.5253 .42452 L
.52533 .42463 L
.52534 .42469 L
.52536 .42456 L
.5254 .42428 L
.52542 .42413 L
.52543 .42398 L
.52545 .42362 L
.52547 .42306 L
.5255 .42204 L
.52552 .42147 L
.52553 .42095 L
.52556 .42354 L
.5256 .42676 L
.52562 .42974 L
.52564 .4298 L
.52566 .4288 L
.52569 .42682 L
Mistroke
.52572 .42502 L
.52574 .42572 L
.52577 .42792 L
.5258 .43023 L
.52583 .43239 L
.52586 .43263 L
.52587 .43276 L
.52589 .43289 L
.52592 .43295 L
.52595 .43094 L
.52598 .42842 L
.526 .42718 L
.52602 .42648 L
.52605 .4293 L
.52608 .43238 L
.52611 .43506 L
.52614 .43646 L
.52616 .43749 L
.52619 .4386 L
.52622 .4394 L
.52625 .43973 L
.52626 .43994 L
.52628 .44013 L
.52631 .43989 L
.52634 .43841 L
.52636 .43684 L
.52641 .43432 L
.52647 .43218 L
.5265 .43118 L
.52653 .43106 L
.52656 .43094 L
.52657 .43087 L
.52659 .43098 L
.52662 .43251 L
.52665 .43414 L
.52668 .43574 L
.52671 .43466 L
.52674 .43363 L
.52677 .43249 L
.5268 .43 L
.52683 .42643 L
.52686 .42313 L
.52689 .42322 L
.52691 .42509 L
.52692 .42686 L
.52695 .43017 L
.52697 .43191 L
.52699 .43045 L
.52702 .42716 L
.52705 .42454 L
Mistroke
.52708 .42412 L
.52711 .42575 L
.52713 .42754 L
.52716 .42921 L
.52718 .42873 L
.5272 .4283 L
.52723 .42746 L
.52725 .42668 L
.52728 .42389 L
.52731 .4207 L
.52734 .41722 L
.52737 .41487 L
.52739 .41371 L
.52742 .41245 L
.52744 .41107 L
.52747 .41157 L
.5275 .41243 L
.52752 .4129 L
.52753 .41334 L
.52756 .41217 L
.52759 .40984 L
.52762 .40748 L
.52764 .40627 L
.52766 .4057 L
.52767 .40508 L
.52769 .40441 L
.52771 .40384 L
.52773 .40323 L
.52776 .40017 L
.52779 .3965 L
.52781 .39322 L
.52784 .3908 L
.52787 .39017 L
.52789 .38984 L
.52791 .3895 L
.52794 .38934 L
.52797 .38992 L
.528 .39055 L
.52803 .3908 L
.52804 .39021 L
.52806 .38957 L
.52809 .38846 L
.52812 .38764 L
.52815 .38802 L
.52818 .38837 L
.52821 .38869 L
.52824 .38723 L
.52827 .38547 L
.52831 .38383 L
.52834 .38014 L
Mistroke
.52837 .37599 L
.52839 .37373 L
.5284 .3716 L
.52842 .37075 L
.52844 .36988 L
.52847 .36835 L
.5285 .36725 L
.52853 .36688 L
.52856 .36655 L
.52859 .36623 L
.52862 .3641 L
.52864 .3617 L
.52867 .35903 L
.52869 .35765 L
.52871 .35698 L
.52872 .3563 L
.52874 .35555 L
.52877 .35424 L
.52879 .35353 L
.5288 .35366 L
.52884 .35394 L
.52887 .35418 L
.52888 .35449 L
.5289 .35579 L
.52893 .35813 L
.52896 .3607 L
.52899 .36087 L
.52901 .35876 L
.52902 .35679 L
.52905 .35305 L
.52908 .35016 L
.5291 .34952 L
.52911 .34882 L
.52914 .3476 L
.52918 .34586 L
.52921 .34361 L
.52924 .34169 L
.52927 .34024 L
.5293 .34111 L
.52933 .3419 L
.52936 .34277 L
.52937 .34061 L
.52939 .33838 L
.52942 .33412 L
.52945 .3301 L
.52948 .32814 L
.52951 .32619 L
.52956 .32248 L
.52967 .31103 L
.52979 .2973 L
Mistroke
.5299 .28619 L
.52993 .28489 L
.52996 .2819 L
.52998 .27899 L
.53001 .27589 L
.53002 .27418 L
.53004 .27435 L
.53007 .27519 L
.5301 .27596 L
.53013 .27634 L
.53014 .27553 L
.53016 .27465 L
.53019 .2731 L
.53021 .27222 L
.53022 .27151 L
.53024 .27117 L
.53026 .27086 L
.53029 .27026 L
.5303 .26992 L
.53032 .26889 L
.53035 .26489 L
.53038 .26064 L
.53041 .25632 L
.53044 .25552 L
.53047 .25465 L
.53048 .25419 L
.5305 .2537 L
.53053 .25378 L
.53056 .25389 L
.53059 .25401 L
.53062 .25163 L
.53069 .24332 L
.53075 .23324 L
.53078 .22796 L
.5308 .22659 L
.53081 .22775 L
.53085 .23042 L
.53087 .2316 L
.53088 .23289 L
.53091 .22907 L
.53094 .22467 L
.53096 .22237 L
.53098 .21988 L
.53101 .22061 L
.53104 .22215 L
.53106 .22359 L
.53109 .22393 L
.53113 .22342 L
.53115 .22295 L
.53118 .22161 L
Mistroke
.53121 .21803 L
.53124 .21466 L
.53127 .21158 L
.53129 .21294 L
.53132 .21456 L
.53135 .21604 L
.53138 .21588 L
.53141 .21339 L
.53144 .21105 L
.53146 .2096 L
.53149 .21174 L
.53153 .21406 L
.53156 .21563 L
.53157 .21514 L
.53159 .2146 L
.53162 .21361 L
.53164 .21306 L
.53165 .21231 L
.53167 .21093 L
.53169 .20943 L
.53172 .20678 L
.53185 .19514 L
.53191 .18927 L
.53194 .18632 L
.53195 .18611 L
.53197 .18593 L
.532 .18553 L
.53202 .18531 L
.53204 .18492 L
.53205 .18417 L
.53207 .18336 L
.5321 .18188 L
.53213 .18001 L
.53216 .17636 L
.53219 .17242 L
.53221 .17035 L
.53222 .16842 L
.53225 .17051 L
.53228 .17243 L
.53231 .17441 L
.53234 .17557 L
.53236 .17648 L
.53239 .17748 L
.53242 .1782 L
.53245 .17787 L
.53247 .17756 L
.5325 .17723 L
.53252 .17593 L
.53255 .17397 L
.53261 .16961 L
Mistroke
.53264 .16754 L
.53267 .16535 L
.5327 .16343 L
.53273 .16336 L
.53276 .16336 L
.53278 .16336 L
.53281 .16661 L
.53283 .16922 L
.53285 .17209 L
.53288 .17722 L
.53291 .17955 L
.53292 .17968 L
.53294 .17981 L
.53296 .17996 L
.53297 .18009 L
.533 .179 L
.53302 .17791 L
.53304 .17674 L
.53307 .17463 L
.53309 .17368 L
.5331 .17361 L
.53313 .1735 L
.53316 .17337 L
.53319 .17358 L
.53322 .17411 L
.53328 .17541 L
.53333 .17885 L
.53336 .18054 L
.53338 .18171 L
.5334 .18252 L
.53343 .18339 L
.53346 .18429 L
.53349 .18367 L
.53352 .18289 L
.53355 .18205 L
.53356 .18204 L
.53358 .18292 L
.53361 .18463 L
.53364 .18618 L
.53367 .18725 L
.5337 .18759 L
.53372 .1879 L
.53375 .1883 L
.53378 .18898 L
.53381 .18978 L
.53384 .19052 L
.53386 .19172 L
.53388 .19306 L
.53391 .1955 L
.53397 .20114 L
Mistroke
.53401 .20386 L
.53403 .20641 L
.53406 .20716 L
.5341 .20783 L
.53412 .20837 L
.53415 .20937 L
.53418 .21061 L
.53421 .21175 L
.53466 .23395 L
.53557 .27422 L
.53563 .27813 L
.53567 .28003 L
.53568 .27918 L
.5357 .27839 L
.53577 .27502 L
.5358 .27354 L
.53582 .27281 L
.53584 .27213 L
.53587 .27219 L
.53588 .27365 L
.5359 .27519 L
.53593 .27772 L
.53596 .27996 L
.53597 .27953 L
.53599 .27914 L
.53602 .27836 L
.53605 .27778 L
.53608 .27791 L
.53611 .27802 L
.53614 .27813 L
.53617 .28016 L
.5362 .28232 L
.5363 .2886 L
.53636 .29339 L
.53639 .29651 L
.53642 .29944 L
.53645 .30478 L
.53648 .31162 L
.5365 .31509 L
.53652 .3188 L
.53655 .32318 L
.53658 .32635 L
.5366 .32934 L
.53663 .33139 L
.53666 .3315 L
.53669 .33162 L
.53672 .33175 L
.53674 .33188 L
.53675 .33202 L
.53678 .33226 L
Mistroke
.53684 .33279 L
.53687 .33315 L
.53689 .33349 L
.53692 .33403 L
.53695 .33482 L
.537 .33621 L
.53748 .34788 L
.53755 .35585 L
.53756 .35794 L
.53758 .35992 L
.53761 .36193 L
.53765 .36411 L
.53768 .36654 L
.53772 .36887 L
.53775 .37103 L
.53776 .37209 L
.53778 .37194 L
.5378 .37154 L
.53782 .3711 L
.53783 .37073 L
.53785 .37032 L
.53788 .37077 L
.53791 .37229 L
.53794 .37374 L
.53797 .37476 L
.538 .37535 L
.53803 .37598 L
.53806 .37688 L
.53809 .3792 L
.53811 .38172 L
.53815 .38447 L
.53816 .38464 L
.53818 .38422 L
.53821 .38348 L
.53824 .38279 L
.53827 .38236 L
.53829 .38203 L
.53833 .38166 L
.53835 .38121 L
.53841 .38018 L
.53843 .37963 L
.53846 .38082 L
.53852 .38362 L
.53854 .38464 L
.53857 .38499 L
.53864 .38577 L
.53867 .38625 L
.53869 .38668 L
.53872 .38713 L
.53875 .38729 L
Mistroke
.53878 .3874 L
.53881 .38752 L
.53883 .38767 L
.53886 .38789 L
.53891 .3883 L
.53897 .38877 L
.53899 .3889 L
.539 .38903 L
.53903 .38903 L
.53906 .38892 L
.53909 .38881 L
.53912 .38873 L
.53915 .38873 L
.53918 .38873 L
.5392 .38873 L
.53922 .38821 L
.53928 .38558 L
.5394 .38052 L
.54035 .33546 L
.54127 .29232 L
.5413 .28968 L
.54133 .28847 L
.54136 .28749 L
.54138 .28696 L
.54139 .28641 L
.54141 .28524 L
.54143 .2838 L
.54146 .28055 L
.54153 .27519 L
.54166 .2633 L
.54172 .25653 L
.54175 .25358 L
.54178 .25039 L
.54181 .24861 L
.54183 .24723 L
.54186 .24583 L
.54188 .24481 L
.54191 .2446 L
.54194 .24436 L
.54197 .24413 L
.542 .24665 L
.54203 .24977 L
.54205 .25142 L
.54206 .25317 L
.54208 .25172 L
.5421 .24855 L
.54212 .24296 L
.54215 .23755 L
.54218 .23475 L
.54221 .23347 L
Mistroke
.54224 .23228 L
.54227 .23163 L
.54229 .23204 L
.54232 .23249 L
.54235 .23297 L
.54238 .23162 L
.54241 .23027 L
.54243 .22899 L
.54246 .22821 L
.54249 .2289 L
.54251 .22954 L
.54254 .2303 L
.54257 .2301 L
.5426 .22986 L
.54262 .22973 L
.54264 .2296 L
.54267 .23038 L
.5427 .23131 L
.54271 .23181 L
.54273 .23235 L
.54276 .23236 L
.54277 .23216 L
.54279 .23197 L
.54281 .23176 L
.54283 .23155 L
.54286 .23137 L
.54288 .23126 L
.54291 .23114 L
.54293 .23098 L
.54295 .2306 L
.54306 .22737 L
.54309 .2263 L
.54311 .22514 L
.54313 .22555 L
.54315 .22628 L
.54318 .22771 L
.54321 .22918 L
.54324 .22947 L
.54326 .22937 L
.54329 .22925 L
.54332 .22917 L
.54335 .22917 L
.54338 .22917 L
.54339 .22917 L
.54341 .22879 L
.54344 .22695 L
.54347 .22521 L
.54353 .22074 L
.54355 .2181 L
.54358 .21528 L
Mistroke
.5436 .21407 L
.54363 .21711 L
.54366 .22075 L
.54368 .22274 L
.5437 .22403 L
.54371 .2232 L
.54373 .22228 L
.54377 .22067 L
.5438 .21913 L
.54383 .21785 L
.54386 .2167 L
.54389 .21625 L
.54392 .21787 L
.54395 .21959 L
.54401 .22234 L
.54403 .22357 L
.54406 .2249 L
.54408 .22509 L
.5441 .22452 L
.54413 .2234 L
.54419 .22106 L
.54422 .21967 L
.54424 .21839 L
.54427 .21774 L
.54429 .21859 L
.54431 .21948 L
.54433 .22094 L
.54436 .22235 L
.54439 .22281 L
.54442 .22322 L
.54444 .22364 L
.54447 .22474 L
.54458 .22993 L
.54508 .24929 L
.546 .28511 L
.54603 .28456 L
.54606 .28398 L
.54609 .28365 L
.54611 .28455 L
.54614 .2855 L
.54617 .28652 L
.5462 .28672 L
.54623 .28637 L
.54626 .28599 L
.54627 .2858 L
.54629 .28587 L
.54632 .28599 L
.54635 .28612 L
.54638 .28694 L
.54641 .28842 L
Mistroke
.54647 .29122 L
.54673 .30094 L
.5468 .30475 L
.54683 .30736 L
.54685 .30863 L
.54686 .3092 L
.54689 .31017 L
.54692 .31122 L
.54698 .31365 L
.54701 .3149 L
.54704 .31623 L
.54707 .31567 L
.54709 .31487 L
.54711 .31445 L
.54713 .31398 L
.54716 .31416 L
.54719 .31475 L
.54721 .31529 L
.54724 .31647 L
.54727 .31839 L
.54729 .31951 L
.5473 .32068 L
.54734 .32211 L
.54737 .322 L
.5474 .32187 L
.54741 .3218 L
.54743 .32254 L
.54745 .32383 L
.54747 .32501 L
.54749 .32718 L
.54752 .32918 L
.54755 .3298 L
.54758 .33049 L
.54764 .33246 L
.54767 .33368 L
.5477 .33483 L
.54773 .33494 L
.54776 .33459 L
.54778 .3343 L
.54781 .33399 L
.54784 .33376 L
.54787 .33351 L
.5479 .33328 L
.54792 .33171 L
.54798 .32803 L
.54801 .32642 L
.54804 .32565 L
.54805 .32521 L
.54807 .32473 L
.5481 .32463 L
Mistroke
.54813 .32709 L
.54816 .32936 L
.54822 .33368 L
.54825 .33551 L
.54828 .33718 L
.54831 .33676 L
.54834 .33588 L
.54836 .33541 L
.54838 .33491 L
.54839 .33566 L
.54841 .33679 L
.54844 .33881 L
.54847 .34099 L
.54849 .34212 L
.54852 .34276 L
.54862 .34584 L
.54865 .34677 L
.54868 .34732 L
.54871 .34708 L
.54873 .34686 L
.54877 .3463 L
.5488 .34402 L
.54883 .34178 L
.54885 .33973 L
.54888 .34145 L
.54891 .34417 L
.54894 .34657 L
.54896 .34737 L
.54899 .34496 L
.54902 .34272 L
.54904 .34146 L
.54905 .34029 L
.54908 .33893 L
.54912 .3375 L
.54915 .33646 L
.54917 .3379 L
.5492 .33942 L
.54923 .34105 L
.54926 .34118 L
.54928 .34112 L
.5493 .34105 L
.54931 .34098 L
.54933 .34092 L
.54936 .34109 L
.54939 .34132 L
.54941 .34153 L
.54944 .34277 L
.54947 .34634 L
.5495 .34962 L
.54956 .35625 L
Mistroke
.54961 .36107 L
.54964 .363 L
.54966 .36417 L
.54972 .36655 L
.54977 .36906 L
.5498 .37037 L
.54982 .37068 L
.54984 .37055 L
.54986 .37032 L
.54989 .37009 L
.54991 .37012 L
.54993 .37108 L
.54996 .37278 L
.54997 .37373 L
.54999 .37475 L
.55001 .37506 L
.55003 .37444 L
.55008 .37208 L
.55012 .37106 L
.55015 .37032 L
.55017 .36968 L
.5502 .36954 L
.55023 .37052 L
.55026 .37144 L
.55071 .38965 L
.55074 .39158 L
.55077 .39334 L
.5508 .39393 L
.55083 .39458 L
.5509 .39607 L
.55093 .3968 L
.55094 .3972 L
.55096 .3975 L
.55099 .39704 L
.55102 .39654 L
.55105 .39611 L
.55107 .39617 L
.55109 .39629 L
.55111 .39643 L
.55114 .39668 L
.55117 .39652 L
.5512 .39618 L
.55122 .39588 L
.55125 .39588 L
.55128 .39713 L
.5513 .39828 L
.55133 .39962 L
.55136 .39977 L
.55139 .39908 L
.55141 .39845 L
Mistroke
.55144 .39748 L
.55147 .3959 L
.55153 .39295 L
.55164 .38561 L
.55188 .37266 L
.55194 .36927 L
.55197 .36764 L
.552 .36611 L
.55201 .36542 L
.55203 .36564 L
.55206 .36603 L
.55208 .36622 L
.5521 .36642 L
.55213 .36531 L
.55215 .36366 L
.55218 .36215 L
.55221 .3611 L
.55224 .36283 L
.55226 .36425 L
.55228 .36576 L
.55231 .3656 L
.55234 .36395 L
.55237 .36202 L
.55238 .36101 L
.5524 .36041 L
.55243 .36041 L
.55246 .36041 L
.55249 .36041 L
.55251 .35896 L
.55254 .35713 L
.55257 .35547 L
.5526 .35447 L
.55262 .35427 L
.55263 .35408 L
.55269 .35317 L
.55272 .35211 L
.55274 .35154 L
.55276 .351 L
.55279 .35047 L
.5528 .35047 L
.55282 .35047 L
.55285 .35047 L
.55288 .35039 L
.55291 .35018 L
.55293 .34995 L
.55297 .3497 L
.55298 .34769 L
.553 .34546 L
.55303 .34156 L
.55306 .33785 L
Mistroke
.55309 .33677 L
.55312 .33592 L
.55314 .33515 L
.55317 .33487 L
.5532 .33511 L
.55321 .33524 L
.55323 .33537 L
.55326 .33545 L
.55329 .33511 L
.55332 .33478 L
.55334 .33446 L
.55337 .3359 L
.5534 .33796 L
.5535 .3462 L
.55353 .34886 L
.55355 .34964 L
.55357 .35018 L
.5536 .35115 L
.55362 .35203 L
.55364 .35201 L
.55366 .35082 L
.55369 .3483 L
.55372 .3461 L
.55374 .34528 L
.55375 .34491 L
.55378 .34418 L
.55381 .34349 L
.55384 .34303 L
.55387 .34269 L
.5539 .34231 L
.55392 .34212 L
.55393 .34279 L
.55396 .34477 L
.55399 .34661 L
.55405 .35043 L
.55408 .35236 L
.5541 .35414 L
.55413 .3532 L
.55415 .35087 L
.55418 .3483 L
.55421 .34594 L
.55424 .34611 L
.55427 .34637 L
.5543 .3466 L
.55433 .34734 L
.55435 .34804 L
.55438 .34879 L
.55441 .34902 L
.55444 .34825 L
.55447 .34735 L
Mistroke
.5545 .34676 L
.55453 .34764 L
.55457 .3486 L
.55459 .34966 L
.55462 .35194 L
.55468 .35707 L
.55481 .36678 L
.55488 .3711 L
.55491 .37346 L
.55493 .37463 L
.55495 .3757 L
.55498 .37663 L
.555 .37508 L
.55501 .37344 L
.55504 .37057 L
.55507 .3681 L
.5551 .36852 L
.55513 .36896 L
.55516 .36946 L
.55518 .36944 L
.55522 .36918 L
.55525 .36895 L
.55526 .3688 L
.55528 .36805 L
.55531 .36655 L
.55537 .36373 L
.5554 .36177 L
.55542 .36069 L
.55543 .35968 L
.55545 .35869 L
.55546 .35975 L
.55549 .36241 L
.55552 .36489 L
.55555 .36696 L
.55558 .36396 L
.55561 .36077 L
.55565 .35834 L
.55567 .36042 L
.5557 .36248 L
.55573 .36445 L
.55575 .36507 L
.55578 .36518 L
.55581 .36529 L
.55584 .36484 L
.55587 .36274 L
.5559 .36084 L
.55593 .35858 L
.55594 .35868 L
.55596 .35888 L
.55599 .35925 L
Mistroke
.55602 .35959 L
.55604 .35935 L
.55605 .35897 L
.55609 .35811 L
.55612 .35738 L
.55614 .35583 L
.55615 .35433 L
.55618 .35163 L
.55622 .34872 L
.55624 .3471 L
.55627 .34568 L
.5563 .3442 L
.55633 .34312 L
.55635 .34272 L
.55636 .34235 L
.55638 .34196 L
.5564 .34154 L
.55643 .342 L
.55644 .34261 L
.55646 .34318 L
.55649 .34419 L
.55652 .34448 L
.55654 .34421 L
.55655 .34392 L
.55657 .34366 L
.55659 .34338 L
.5566 .34333 L
.55662 .3437 L
.55665 .34443 L
.55668 .34517 L
.55671 .34519 L
.55674 .34457 L
.55676 .34425 L
.55677 .34391 L
.5568 .34262 L
.55683 .34048 L
.55686 .33796 L
.55689 .33591 L
.55692 .3358 L
.55695 .33568 L
.55698 .33556 L
.55699 .3347 L
.55701 .33355 L
.55704 .33153 L
.55706 .3296 L
.55709 .32915 L
.55712 .32993 L
.55715 .33065 L
.55718 .33124 L
.5572 .33031 L
Mistroke
.55722 .32947 L
.55725 .32848 L
.55728 .32794 L
.55731 .32806 L
.55734 .32816 L
.55736 .32827 L
.55739 .32709 L
.55742 .32602 L
.55745 .32489 L
.55746 .32469 L
.55748 .32559 L
.55751 .32717 L
.55754 .32872 L
.55757 .32907 L
.5576 .32843 L
.55762 .32776 L
.55765 .32718 L
.55767 .32703 L
.5577 .32692 L
.55773 .3268 L
.55776 .32662 L
.55779 .32641 L
.55782 .32616 L
.55783 .32603 L
.55785 .32691 L
.55788 .32959 L
.55791 .3321 L
.55793 .3336 L
.55794 .33364 L
.55798 .33045 L
.55801 .32697 L
.55803 .32506 L
.55804 .32373 L
.55808 .32175 L
.5581 .31996 L
.55813 .31831 L
.55816 .31762 L
.55822 .31617 L
.55825 .31558 L
.55828 .31509 L
.55831 .31463 L
.55834 .31659 L
.55837 .31923 L
.5584 .32168 L
.55843 .32319 L
.55846 .32387 L
.55851 .32531 L
.55858 .33324 L
.55859 .33516 L
.55861 .33707 L
Mistroke
.55863 .337 L
.55864 .33693 L
.55866 .33687 L
.55868 .3368 L
.55871 .33654 L
.55874 .33535 L
.55876 .33425 L
.55879 .33308 L
.55881 .33192 L
.55882 .33062 L
.55886 .32782 L
.55889 .32517 L
.55891 .32503 L
.55892 .32531 L
.55895 .32581 L
.55897 .3261 L
.55899 .32635 L
.55901 .32628 L
.55902 .32622 L
.55905 .3261 L
.55909 .32599 L
.5591 .32644 L
.55912 .32694 L
.55915 .32782 L
.55921 .33016 L
.55924 .33147 L
.55927 .33292 L
.5593 .33334 L
.55932 .33341 L
.55933 .33347 L
.55936 .33358 L
.55939 .33318 L
.55942 .3324 L
.55944 .33199 L
.55946 .33156 L
.55947 .33124 L
.55949 .33105 L
.55952 .33068 L
.55955 .33031 L
.55957 .33027 L
.55959 .33046 L
.55961 .3308 L
.55965 .33118 L
.55967 .33012 L
.5597 .32809 L
.55976 .32354 L
.55982 .31822 L
.55985 .3156 L
.55987 .31454 L
.5599 .31379 L
Mistroke
.55992 .31296 L
.55995 .31239 L
.55998 .3146 L
.56003 .3192 L
.56006 .32187 L
.56009 .32479 L
.56012 .32736 L
.56015 .32674 L
.56018 .32351 L
.56021 .32051 L
.56024 .3176 L
.56025 .31773 L
.56027 .31786 L
.5603 .3181 L
.56033 .31833 L
.56034 .31874 L
.56036 .31912 L
.5604 .31997 L
.56043 .32058 L
.56044 .32037 L
.56046 .32018 L
.56049 .31984 L
.56052 .31947 L
.56055 .31888 L
.56057 .31835 L
.56061 .31772 L
.56062 .31782 L
.56064 .31837 L
.56067 .31934 L
.5607 .32025 L
.56073 .31938 L
.56076 .31711 L
.56078 .31521 L
.56081 .31344 L
.56084 .31428 L
.56087 .31518 L
.56093 .31657 L
.56098 .31764 L
.56101 .31849 L
.56104 .31948 L
.56107 .32043 L
.56109 .32132 L
.56112 .32025 L
.56114 .31891 L
.56117 .31743 L
.56119 .3169 L
.56121 .31772 L
.56127 .32053 L
.5613 .32193 L
.56133 .32319 L
Mistroke
.56135 .32381 L
.56137 .32439 L
.5614 .32381 L
.56143 .32207 L
.56146 .32043 L
.56149 .31931 L
.5615 .31912 L
.56152 .31891 L
.56155 .31856 L
.56158 .31828 L
.56161 .31817 L
.56164 .31806 L
.56166 .31795 L
.56169 .31922 L
.56172 .32065 L
.56175 .32221 L
.56177 .32185 L
.5618 .31991 L
.56182 .31808 L
.56185 .3161 L
.56188 .31626 L
.5619 .31699 L
.56196 .31861 L
.562 .31938 L
.56203 .32011 L
.56205 .32133 L
.56208 .32492 L
.56211 .3285 L
.56214 .3321 L
.56216 .3321 L
.56218 .3321 L
.5622 .3321 L
.56221 .3321 L
.56224 .33201 L
.56226 .33134 L
.56227 .33071 L
.56233 .32838 L
.56238 .3257 L
.56241 .32433 L
.56244 .32411 L
.56247 .32688 L
.5625 .32948 L
.56256 .33419 L
.56259 .33674 L
.56262 .33911 L
.56265 .33726 L
.56268 .33469 L
.56271 .33246 L
.56274 .33324 L
.56277 .33484 L
Mistroke
.5628 .33636 L
.56306 .3523 L
.56309 .35588 L
.56312 .3579 L
.56313 .35865 L
.56315 .35947 L
.56318 .36091 L
.56324 .36369 L
.56327 .36524 L
.56329 .36654 L
.56331 .36654 L
.56333 .36654 L
.56335 .36654 L
.56338 .36654 L
.56341 .36418 L
.56344 .36116 L
.56347 .35835 L
.56351 .35863 L
.56352 .35924 L
.56354 .35988 L
.56357 .36088 L
.5636 .36135 L
.56361 .36147 L
.56363 .36161 L
.56366 .36184 L
.56369 .36132 L
.56372 .36011 L
.56375 .35898 L
.56377 .35833 L
.5638 .35952 L
.56383 .36082 L
.56386 .36197 L
.56388 .3609 L
.56393 .35742 L
.56396 .35545 L
.56398 .35666 L
.56402 .35824 L
.56405 .35967 L
.56406 .3611 L
.56408 .36297 L
.56411 .36708 L
.56414 .37038 L
.56417 .3727 L
.5642 .37463 L
.56423 .37641 L
.56426 .37781 L
.5643 .37891 L
.56431 .37941 L
.56433 .37994 L
.56436 .37974 L
Mistroke
.56438 .3792 L
.56439 .37863 L
.56441 .37813 L
.56443 .37759 L
.56445 .37659 L
.56446 .37525 L
.5645 .37274 L
.56453 .37057 L
.56456 .37066 L
.56459 .37103 L
.56461 .37123 L
.56462 .37142 L
.56464 .37121 L
.56466 .37063 L
.56469 .36957 L
.56472 .3686 L
.56474 .36845 L
.56475 .36845 L
.56478 .36845 L
.56481 .36845 L
.56482 .36908 L
.56484 .37139 L
.56487 .37546 L
.56493 .38305 L
.56498 .38892 L
.56501 .39175 L
.56504 .39138 L
.56507 .391 L
.56509 .39079 L
.56511 .39023 L
.56514 .38746 L
.56517 .38492 L
.56523 .38058 L
.56545 .36944 L
.56596 .33665 L
.56598 .3354 L
.56601 .33517 L
.56604 .33493 L
.56607 .33459 L
.56609 .33406 L
.56612 .33356 L
.56615 .33302 L
.56618 .3305 L
.56624 .32329 L
.5663 .31767 L
.56633 .31513 L
.56636 .31305 L
.56638 .31226 L
.56641 .31153 L
.56644 .31067 L
Mistroke
.56647 .31113 L
.56654 .31219 L
.56657 .31272 L
.5666 .31329 L
.56664 .31382 L
.56665 .31437 L
.56667 .31489 L
.5667 .31581 L
.56672 .31667 L
.56676 .31449 L
.56678 .3121 L
.56685 .30651 L
.56688 .30362 L
.56691 .30097 L
.56694 .30061 L
.56696 .30165 L
.56699 .30276 L
.56702 .30363 L
.56705 .30242 L
.56708 .30129 L
.56714 .29874 L
.56717 .29754 L
.5672 .29628 L
.56722 .29497 L
.56724 .2933 L
.56727 .29038 L
.5673 .28762 L
.56731 .28711 L
.56733 .28687 L
.56739 .28594 L
.56745 .28387 L
.56748 .28266 L
.56749 .28206 L
.56751 .28186 L
.56754 .28161 L
.56757 .28139 L
.56759 .28141 L
.56762 .28275 L
.56765 .28406 L
.56767 .28528 L
.5677 .2851 L
.56773 .2838 L
.56776 .2827 L
.56778 .28165 L
.56781 .28419 L
.56783 .28668 L
.56786 .28946 L
.56789 .29131 L
.56792 .29165 L
.56794 .29196 L
Mistroke
.56797 .29226 L
.56799 .29151 L
.568 .29082 L
.56803 .28956 L
.56806 .2882 L
.56808 .28804 L
.5681 .28798 L
.56813 .28785 L
.56816 .28774 L
.56818 .28709 L
.56831 .28307 L
.56852 .2746 L
.56858 .27214 L
.56861 .2706 L
.56864 .26888 L
.56867 .26573 L
.5687 .2623 L
.56873 .25919 L
.56876 .25971 L
.56878 .26119 L
.56881 .26256 L
.56884 .26344 L
.56887 .26272 L
.5689 .26199 L
.56891 .26159 L
.56893 .26133 L
.56896 .26145 L
.56899 .26156 L
.56901 .26167 L
.56904 .26045 L
.56909 .25743 L
.56912 .25596 L
.56915 .25596 L
.56918 .25596 L
.5692 .25596 L
.56924 .25615 L
.56927 .25641 L
.5693 .25665 L
.56933 .25735 L
.56936 .25808 L
.56938 .25887 L
.56941 .25838 L
.56944 .25594 L
.56948 .2531 L
.56951 .25106 L
.56952 .25062 L
.56954 .25014 L
.56956 .24966 L
.56958 .24913 L
.56959 .24869 L
Mistroke
.56961 .24869 L
.56964 .24869 L
.56967 .24869 L
.5697 .24842 L
.56973 .24772 L
.56976 .24696 L
.56979 .24569 L
.56982 .24259 L
.56985 .23957 L
.56987 .23673 L
.5699 .2364 L
.56993 .23735 L
.56996 .23842 L
.56999 .23989 L
.57004 .24346 L
.57007 .24567 L
.5701 .24953 L
.57017 .25841 L
.57022 .26741 L
.57025 .27216 L
.57028 .27459 L
.5703 .275 L
.57033 .27545 L
.57036 .27591 L
.57038 .27909 L
.57041 .28278 L
.57044 .28666 L
.57045 .28841 L
.57047 .28774 L
.5705 .28656 L
.57053 .28547 L
.57056 .28532 L
.57058 .2874 L
.57061 .2893 L
.57064 .29149 L
.57066 .28963 L
.57069 .28645 L
.57073 .28303 L
.57074 .28148 L
.57076 .28072 L
.57079 .27934 L
.57082 .278 L
.57085 .27801 L
.57088 .2793 L
.57091 .2805 L
.57096 .28285 L
.57107 .28798 L
.57131 .30115 L
.57157 .31334 L
.57168 .31682 L
Mistroke
.57171 .31799 L
.57174 .31952 L
.57177 .32096 L
.5718 .32115 L
.57182 .32026 L
.57183 .31928 L
.57185 .31833 L
.57187 .3173 L
.57189 .31644 L
.5719 .31693 L
.57193 .31789 L
.57196 .31885 L
.57198 .31938 L
.57199 .31947 L
.57202 .31947 L
.57205 .31947 L
.57208 .31991 L
.57211 .32167 L
.57214 .32356 L
.57216 .32457 L
.57217 .3256 L
.5722 .32571 L
.57223 .32582 L
.57226 .32594 L
.57229 .32576 L
.57231 .32543 L
.57234 .32513 L
.57237 .32488 L
.5724 .3257 L
.57242 .32636 L
.57244 .32708 L
.57247 .3288 L
.5725 .33151 L
.57253 .33459 L
.57256 .33747 L
.57257 .3384 L
.57259 .33941 L
.57262 .34117 L
.57265 .34286 L
.57268 .34377 L
.5727 .34444 L
.57273 .34505 L
.57276 .34498 L
.57277 .34425 L
.57279 .34357 L
.57285 .34102 L
.57288 .33967 L
.57291 .33824 L
.57293 .33741 L
.57295 .33719 L
Mistroke
.57296 .33739 L
.57298 .33758 L
.57301 .33794 L
.57303 .33814 L
.57304 .33772 L
.57307 .33595 L
.57311 .33406 L
.57316 .33092 L
.57319 .32926 L
.57322 .32751 L
.57324 .32814 L
.57326 .32884 L
.57329 .33006 L
.57333 .33117 L
.57336 .33214 L
.57338 .3326 L
.57339 .33309 L
.57343 .33354 L
.57345 .33331 L
.57349 .33305 L
.5735 .33293 L
.57352 .33372 L
.57355 .3369 L
.57358 .34061 L
.5736 .34242 L
.57361 .34329 L
.57364 .34362 L
.57367 .34398 L
.57369 .34417 L
.5737 .3444 L
.57373 .34526 L
.57384 .3486 L
.5739 .35067 L
.57396 .35312 L
.57398 .35379 L
.57399 .35437 L
.57402 .35487 L
.57405 .35535 L
.57409 .35563 L
.5741 .35402 L
.57412 .35256 L
.57415 .3497 L
.57417 .34809 L
.57419 .3467 L
.5742 .34592 L
.57422 .34519 L
.57425 .344 L
.57428 .34289 L
.57429 .34349 L
.57431 .34403 L
Mistroke
.57434 .34511 L
.57437 .3462 L
.57439 .34651 L
.5744 .34677 L
.57443 .34723 L
.57446 .34774 L
.57449 .34722 L
.57453 .34656 L
.57456 .34596 L
.57458 .34664 L
.57462 .34769 L
.57465 .34868 L
.57466 .34831 L
.57468 .34705 L
.57472 .34483 L
.57475 .34271 L
.57478 .34163 L
.57481 .34065 L
.57482 .34012 L
.57484 .33957 L
.57487 .33901 L
.5749 .33858 L
.57496 .33763 L
.57501 .33677 L
.57504 .33622 L
.57507 .3336 L
.57517 .32311 L
.5752 .31996 L
.57523 .31663 L
.57524 .31399 L
.57526 .31095 L
.57529 .30559 L
.57535 .29503 L
.5754 .28521 L
.57543 .28127 L
.57546 .27928 L
.5755 .27713 L
.57553 .27552 L
.57556 .27468 L
.57559 .27377 L
.57565 .27177 L
.57568 .27059 L
.5757 .2695 L
.57573 .26716 L
.57576 .2644 L
.57579 .26206 L
.57581 .26039 L
.57584 .25911 L
.57587 .25795 L
.5759 .25655 L
Mistroke
.57592 .25386 L
.57593 .25134 L
.57596 .24583 L
.57599 .24092 L
.57602 .23887 L
.57605 .23692 L
.57611 .23218 L
.57618 .22567 L
.57622 .22198 L
.57625 .21853 L
.57628 .21539 L
.57631 .21403 L
.57634 .21291 L
.57636 .21229 L
.57637 .21171 L
.5764 .21292 L
.57643 .21433 L
.57645 .21565 L
.57648 .21587 L
.57651 .21393 L
.57654 .21187 L
.57657 .21034 L
.5766 .20986 L
.57663 .20938 L
.57666 .20882 L
.57668 .20744 L
.5767 .20594 L
.57673 .2033 L
.57679 .19752 L
.57682 .19457 L
.57685 .19184 L
.57687 .19007 L
.5769 .18842 L
.57696 .18582 L
.57701 .18515 L
.57703 .18497 L
.57705 .18465 L
.57708 .18166 L
.5771 .17889 L
.57713 .17627 L
.57715 .17691 L
.57718 .18021 L
.57721 .18374 L
.57724 .18745 L
.57726 .1859 L
.57729 .18449 L
.57732 .18286 L
.57734 .18282 L
.57737 .18436 L
.57741 .18601 L
Mistroke
.57742 .18683 L
.57744 .18668 L
.57747 .18567 L
.5775 .18477 L
.57753 .18336 L
.57756 .18093 L
.57759 .17865 L
.57761 .17624 L
.57765 .17676 L
.57767 .17751 L
.5777 .1783 L
.57773 .17878 L
.57775 .17897 L
.57778 .17922 L
.57781 .17923 L
.57783 .17837 L
.57784 .17757 L
.57788 .17577 L
.57794 .17292 L
.57796 .17222 L
.57798 .17147 L
.578 .17076 L
.57801 .17073 L
.57804 .17096 L
.57807 .17121 L
.5781 .17158 L
.57813 .17233 L
.57816 .17319 L
.57819 .17399 L
.5782 .17504 L
.57822 .17635 L
.57825 .17862 L
.57828 .18088 L
.57831 .18151 L
.57834 .18177 L
.57837 .18201 L
.5784 .18193 L
.57842 .18163 L
.57845 .18129 L
.57848 .18108 L
.57851 .18264 L
.57854 .1841 L
.5786 .18857 L
.57873 .19498 L
.57924 .22358 L
.57971 .25087 L
.57974 .25125 L
.57976 .25089 L
.57977 .25049 L
.57979 .25006 L
Mistroke
.57981 .24966 L
.57983 .25021 L
.57984 .25207 L
.57996 .26314 L
.57998 .26422 L
.58 .2654 L
.58002 .26757 L
.58004 .27037 L
.58007 .27557 L
.58008 .27833 L
.5801 .2813 L
.58013 .28484 L
.58016 .28807 L
.58018 .28987 L
.5802 .29176 L
.58023 .29216 L
.58026 .29241 L
.58029 .29264 L
.5803 .29373 L
.58032 .29563 L
.58035 .29907 L
.58038 .3023 L
.58041 .30439 L
.58044 .30565 L
.58047 .30702 L
.58072 .31734 L
.58078 .3215 L
.58084 .32593 L
.58085 .32724 L
.58087 .32833 L
.5809 .32893 L
.58093 .3295 L
.58096 .3301 L
.58099 .33037 L
.58102 .3306 L
.58104 .33081 L
.58107 .33138 L
.5811 .33303 L
.58112 .33452 L
.58118 .33858 L
.58121 .34092 L
.58124 .34341 L
.58126 .34415 L
.58128 .3445 L
.58131 .34513 L
.58134 .34572 L
.58137 .34472 L
.5814 .34328 L
.58143 .34196 L
.58145 .34149 L
Mistroke
.58148 .34189 L
.58151 .34237 L
.58154 .3428 L
.58156 .34215 L
.58159 .34151 L
.58162 .34077 L
.58165 .34037 L
.58168 .34014 L
.5817 .34001 L
.58171 .33989 L
.58174 .34055 L
.58176 .34151 L
.58178 .34242 L
.58189 .35078 L
.58192 .35323 L
.58194 .35367 L
.58196 .35416 L
.58202 .35581 L
.58215 .35997 L
.58218 .3602 L
.58221 .36048 L
.58224 .36277 L
.58227 .36485 L
.58233 .36867 L
.58238 .3718 L
.58241 .37297 L
.58243 .37263 L
.58249 .37192 L
.58252 .37075 L
.58256 .36941 L
.58259 .36815 L
.58262 .37031 L
.58265 .37273 L
.58268 .37531 L
.58269 .37627 L
.58271 .37659 L
.58274 .37721 L
.58276 .37756 L
.58278 .37794 L
.5828 .37746 L
.58281 .37681 L
.58285 .37545 L
.58286 .37478 L
.58288 .37419 L
.5829 .37473 L
.58293 .37531 L
.58297 .37593 L
.58299 .37516 L
.58303 .37381 L
.58305 .37256 L
Mistroke
.58308 .37305 L
.5831 .37418 L
.58312 .37542 L
.58315 .37753 L
.58317 .37776 L
.5832 .37464 L
.58324 .37132 L
.58325 .36964 L
.58327 .36914 L
.5833 .37016 L
.58333 .37106 L
.58336 .37151 L
.58339 .36941 L
.58342 .36745 L
.58345 .36537 L
.58348 .36583 L
.5835 .36675 L
.58353 .36762 L
.58356 .36811 L
.58358 .36821 L
.5836 .36828 L
.58362 .36835 L
.58363 .36842 L
.58365 .36789 L
.58368 .36579 L
.58371 .36357 L
.58374 .36145 L
.58376 .36082 L
.58377 .36025 L
.58379 .35958 L
.58381 .35894 L
.58383 .35835 L
.58384 .36029 L
.5839 .37226 L
.58393 .37672 L
.58395 .37637 L
.58397 .37604 L
.58408 .37372 L
.58414 .37256 L
.58417 .37193 L
.5842 .37134 L
.58422 .37166 L
.58424 .37321 L
.58427 .37592 L
.5843 .37843 L
.58432 .37943 L
.58433 .37993 L
.58439 .38186 L
.58446 .38367 L
.58451 .38531 L
Mistroke
.58454 .38611 L
.58457 .38685 L
.5846 .38759 L
.58462 .38926 L
.58465 .39108 L
.58468 .39279 L
.58471 .39384 L
.58473 .39476 L
.58478 .39669 L
.58484 .40144 L
.58487 .40411 L
.5849 .40523 L
.58493 .40579 L
.58496 .4064 L
.58499 .40718 L
.58502 .4082 L
.58507 .41051 L
.58513 .4131 L
.58515 .41441 L
.58518 .41479 L
.5852 .41439 L
.58522 .41401 L
.58524 .4133 L
.58528 .41352 L
.58529 .41461 L
.58531 .41559 L
.58534 .41752 L
.58537 .41854 L
.58538 .41734 L
.5854 .41607 L
.58542 .41468 L
.58543 .41339 L
.58546 .41188 L
.58548 .41226 L
.5855 .41267 L
.58553 .41343 L
.58555 .41386 L
.58556 .41345 L
.58559 .412 L
.58562 .41047 L
.58566 .40966 L
.58567 .41021 L
.58569 .41074 L
.58572 .41184 L
.58574 .41246 L
.58576 .41415 L
.58582 .41994 L
.58589 .42599 L
.58591 .42872 L
.58595 .43007 L
Mistroke
.58597 .42931 L
.586 .42848 L
.58602 .42802 L
.58604 .42768 L
.58606 .42733 L
.58613 .42654 L
.58619 .42586 L
.5862 .42567 L
.58622 .42548 L
.58625 .42375 L
.58628 .42187 L
.5863 .42088 L
.58631 .41984 L
.58633 .42004 L
.58635 .42044 L
.58637 .42115 L
.58641 .42205 L
.58645 .42276 L
.58648 .4234 L
.5865 .42376 L
.58651 .42363 L
.58654 .42262 L
.58657 .42151 L
.58659 .42095 L
.58661 .42047 L
.58664 .42035 L
.58665 .42028 L
.58667 .42021 L
.58669 .42014 L
.5867 .42056 L
.58673 .42285 L
.58676 .42528 L
.58679 .42726 L
.58681 .42657 L
.58683 .42595 L
.58686 .42481 L
.58689 .42356 L
.58691 .42355 L
.58694 .42355 L
.58697 .42355 L
.587 .4236 L
.58703 .42372 L
.58706 .42385 L
.58708 .42391 L
.58709 .42404 L
.58712 .42429 L
.58715 .42453 L
.58719 .4251 L
.58721 .42606 L
.58724 .42711 L
Mistroke
.58726 .42775 L
.58728 .42823 L
.58731 .42874 L
.58734 .42928 L
.58736 .42959 L
.58738 .42892 L
.58741 .42702 L
.58743 .42597 L
.58745 .42497 L
.58746 .42404 L
.58748 .42363 L
.58751 .42304 L
.58754 .42248 L
.58757 .42232 L
.58759 .42357 L
.58762 .42469 L
.58768 .42716 L
.58771 .42805 L
.58774 .42903 L
.58777 .42867 L
.5878 .42778 L
.58787 .42542 L
.58793 .42242 L
.58799 .41882 L
.58893 .36079 L
.58992 .29273 L
.59016 .28279 L
.59023 .281 L
.59026 .27978 L
.5903 .27857 L
.59033 .27745 L
.59035 .27606 L
.59036 .27468 L
.59042 .26968 L
.59045 .26935 L
.59048 .26935 L
.59051 .26935 L
.59054 .26705 L
.59056 .26349 L
.59059 .25957 L
.59064 .25144 L
.59076 .23536 L
.59088 .22157 L
.59094 .21546 L
.59097 .21265 L
.591 .21063 L
.59103 .21196 L
.59105 .21337 L
.59108 .21479 L
.59111 .21437 L
Mistroke
.59113 .2135 L
.59114 .21258 L
.59117 .21094 L
.5912 .2101 L
.59122 .21017 L
.59124 .21024 L
.59127 .21036 L
.5913 .21122 L
.59133 .21326 L
.59136 .21518 L
.59138 .2171 L
.59141 .22061 L
.59144 .22404 L
.59147 .22772 L
.5915 .22628 L
.59152 .22385 L
.59155 .22155 L
.59157 .21922 L
.5916 .21922 L
.59163 .21922 L
.59165 .21922 L
.59166 .21922 L
.59169 .21843 L
.59172 .21753 L
.59175 .21656 L
.59178 .21616 L
.5918 .21616 L
.59183 .21616 L
.59186 .21591 L
.59189 .21421 L
.59192 .21264 L
.59194 .21093 L
.59198 .21125 L
.59199 .21181 L
.59201 .21243 L
.59204 .21353 L
.59207 .21337 L
.59209 .21296 L
.5921 .21258 L
.59212 .21218 L
.59213 .21181 L
.59215 .21288 L
.59217 .21556 L
.5922 .2201 L
.59223 .22491 L
.59224 .22728 L
.59226 .22762 L
.59229 .22821 L
.59232 .2288 L
.59234 .22894 L
Mistroke
.59237 .22833 L
.5924 .22767 L
.59243 .22695 L
.59244 .2272 L
.59246 .22757 L
.59249 .22828 L
.59252 .22894 L
.59254 .22839 L
.59257 .22707 L
.5926 .22564 L
.59263 .22485 L
.59265 .22601 L
.59268 .22724 L
.59273 .22962 L
.59285 .23502 L
.59288 .23741 L
.5929 .23874 L
.59291 .2395 L
.59293 .2395 L
.59295 .2395 L
.59298 .2395 L
.59299 .2395 L
.59301 .23905 L
.59304 .2365 L
.59306 .23493 L
.59308 .23345 L
.5931 .23212 L
.59311 .23249 L
.59313 .23317 L
.59315 .23391 L
.59318 .23542 L
.59321 .23728 L
.59324 .23941 L
.59327 .24141 L
.5933 .24301 L
.59332 .24314 L
.59333 .24327 L
.59336 .24351 L
.59339 .24412 L
.59342 .24766 L
.59345 .25071 L
.59348 .25405 L
.59349 .25438 L
.59351 .25374 L
.59354 .25233 L
.59357 .25112 L
.59359 .25218 L
.59361 .25354 L
.59364 .25614 L
.59365 .25751 L
Mistroke
.59367 .25896 L
.5937 .2588 L
.59373 .25813 L
.59378 .25663 L
.59381 .25557 L
.59384 .25444 L
.59387 .25363 L
.5939 .25352 L
.59393 .25341 L
.59395 .25331 L
.59398 .25474 L
.59402 .25679 L
.59405 .2586 L
.59408 .25783 L
.59411 .25644 L
.59414 .25515 L
.59416 .25528 L
.5942 .25716 L
.59464 .27775 L
.59563 .32949 L
.59659 .37326 L
.59662 .37501 L
.59664 .37655 L
.59667 .37686 L
.59669 .37715 L
.59672 .37747 L
.59674 .37731 L
.59677 .37656 L
.5968 .37573 L
.59683 .37505 L
.59686 .37658 L
.59689 .37799 L
.59692 .37931 L
.59694 .38139 L
.59697 .38385 L
.59703 .38889 L
.59716 .39795 L
.59722 .40246 L
.59728 .40683 L
.59731 .40895 L
.59733 .40854 L
.59737 .40803 L
.5974 .40754 L
.59742 .40898 L
.59745 .41089 L
.59751 .41472 L
.59757 .41772 L
.59758 .41854 L
.5976 .41892 L
.59763 .4188 L
Mistroke
.59765 .41873 L
.59767 .41866 L
.59768 .41859 L
.5977 .41938 L
.59773 .42162 L
.59776 .424 L
.59779 .42572 L
.59782 .42445 L
.59784 .42334 L
.59787 .42214 L
.59788 .42167 L
.5979 .4218 L
.59793 .42204 L
.59796 .42226 L
.59799 .42312 L
.59805 .42704 L
.59812 .43022 L
.59816 .43151 L
.59817 .43207 L
.59819 .43243 L
.59825 .43366 L
.59831 .43467 L
.59833 .43495 L
.59835 .43521 L
.59838 .43358 L
.59841 .43069 L
.59843 .42801 L
.59846 .42554 L
.59849 .4243 L
.59852 .42313 L
.59855 .42203 L
.59858 .42224 L
.59861 .4225 L
.59864 .42271 L
.59866 .42358 L
.59872 .42626 L
.59875 .42747 L
.59878 .42781 L
.59881 .42819 L
.59883 .4284 L
.59884 .42886 L
.59887 .43041 L
.5989 .43208 L
.59893 .43386 L
.59896 .43399 L
.59899 .4341 L
.59902 .43422 L
.59904 .43238 L
.59907 .42952 L
.5991 .42615 L
Mistroke
.59913 .42361 L
.59916 .42599 L
.59919 .42817 L
.59921 .43022 L
.59924 .43055 L
.59926 .43013 L
.59929 .42968 L
.59932 .42894 L
.59935 .42704 L
.59937 .42518 L
.5994 .42348 L
.59943 .42368 L
.59946 .42523 L
.59951 .42802 L
.59963 .43334 L
.59975 .43759 L
.59977 .43846 L
.59978 .4394 L
.59981 .44031 L
.59983 .4406 L
.59985 .44087 L
.59988 .44138 L
.59991 .43989 L
.59994 .43713 L
.59997 .43444 L
.6 .43319 L
.60003 .43426 L
.60005 .43523 L
.60008 .43609 L
.60011 .43416 L
.60022 .42625 L
.60032 .41995 L
.60035 .4185 L
.60037 .41717 L
.6004 .41621 L
.60043 .41533 L
.60046 .41436 L
.60049 .41738 L
.60052 .42089 L
.60055 .42421 L
.60058 .42469 L
.6006 .42469 L
.60062 .42469 L
.60064 .42469 L
.60067 .42612 L
.6007 .4285 L
.60073 .43073 L
.60075 .43191 L
.60077 .43044 L
.6008 .42714 L
Mistroke
.60124 .38014 L
.60146 .3537 L
.60149 .3512 L
.60152 .34763 L
.60154 .34455 L
.60155 .34117 L
.60158 .33523 L
.60161 .33022 L
.60164 .32802 L
.60167 .32611 L
.6017 .32405 L
.60172 .32335 L
.60174 .32293 L
.60177 .3221 L
.6018 .32141 L
.60182 .32167 L
.60183 .32195 L
.60187 .32244 L
.60188 .32271 L
.6019 .32276 L
.60193 .32137 L
.60196 .31991 L
.60199 .31853 L
.60202 .31811 L
.60205 .31788 L
.60207 .31767 L
.6021 .31838 L
.60212 .31922 L
.60214 .31999 L
.60217 .32141 L
.6022 .32202 L
.60222 .32181 L
.60225 .32158 L
.60228 .32095 L
.60231 .31931 L
.60237 .31611 L
.60242 .31312 L
.60245 .31149 L
.60248 .31223 L
.6025 .31379 L
.60252 .31544 L
.60255 .31839 L
.60267 .32878 L
.60272 .33384 L
.60275 .33668 L
.60278 .33589 L
.6028 .33459 L
.60283 .33318 L
.60285 .33278 L
.60288 .33606 L
Mistroke
.60291 .33991 L
.60294 .34406 L
.60296 .34635 L
.60299 .3476 L
.60302 .34889 L
.60305 .34999 L
.60306 .34966 L
.60308 .34935 L
.60311 .34875 L
.60314 .34826 L
.60315 .34895 L
.60317 .3497 L
.6032 .35105 L
.60323 .35228 L
.60325 .35208 L
.60326 .35176 L
.6033 .35106 L
.60333 .3505 L
.60335 .35112 L
.60336 .3517 L
.60339 .35266 L
.60342 .35369 L
.60345 .35582 L
.60348 .35806 L
.60354 .36295 L
.60357 .36606 L
.60359 .36778 L
.6036 .36939 L
.60363 .36887 L
.60366 .36584 L
.60369 .36297 L
.60371 .36025 L
.60374 .35917 L
.60377 .35818 L
.6038 .35711 L
.60382 .35687 L
.60383 .35674 L
.60395 .35567 L
.60397 .35534 L
.604 .35504 L
.60402 .35495 L
.60405 .35485 L
.60408 .35473 L
.60411 .3538 L
.60414 .352 L
.60417 .35009 L
.60418 .34915 L
.6042 .34721 L
.60423 .34323 L
.6043 .33446 L
Mistroke
.60433 .3309 L
.60435 .32903 L
.60436 .32704 L
.60439 .32647 L
.60442 .3288 L
.60445 .33088 L
.60448 .33294 L
.60451 .33368 L
.60454 .33437 L
.60456 .33504 L
.60459 .33482 L
.60462 .33436 L
.60465 .33388 L
.60466 .33363 L
.60468 .33269 L
.60471 .331 L
.60474 .32948 L
.60477 .32834 L
.6048 .32856 L
.60482 .32877 L
.60485 .32899 L
.60488 .32857 L
.60491 .32802 L
.60493 .3275 L
.60496 .3273 L
.60498 .32821 L
.60504 .33023 L
.6051 .332 L
.60513 .33278 L
.60515 .33325 L
.60518 .33325 L
.60521 .33325 L
.60522 .33325 L
.60524 .33324 L
.60527 .33264 L
.60534 .3313 L
.60539 .32968 L
.60541 .32924 L
.60543 .32877 L
.60546 .33063 L
.60549 .33297 L
.60552 .33519 L
.60553 .33562 L
.60555 .33477 L
.60558 .3333 L
.60561 .3319 L
.60564 .32885 L
.60567 .32511 L
.6057 .32167 L
.60571 .31953 L
Mistroke
.60573 .31989 L
.60575 .32088 L
.60577 .32197 L
.60583 .32583 L
.60587 .32771 L
.60588 .32875 L
.6059 .32973 L
.60593 .32874 L
.60596 .32701 L
.60599 .32537 L
.60602 .32473 L
.60604 .32529 L
.60607 .3258 L
.6061 .32636 L
.60613 .32661 L
.60616 .32687 L
.60619 .32711 L
.60621 .32675 L
.60622 .32628 L
.60625 .32544 L
.60627 .32497 L
.60629 .32448 L
.60632 .32628 L
.60635 .32792 L
.60638 .32968 L
.60639 .32949 L
.60641 .3282 L
.60644 .32567 L
.60647 .32338 L
.6065 .32233 L
.60652 .32266 L
.60655 .32295 L
.60661 .32395 L
.60664 .32451 L
.60667 .3251 L
.60669 .32189 L
.60672 .31724 L
.60675 .31296 L
.60677 .3095 L
.6068 .30928 L
.60683 .30904 L
.60686 .30881 L
.60688 .30822 L
.60691 .30745 L
.60694 .30662 L
.60697 .30643 L
.60699 .30746 L
.60702 .30866 L
.60704 .30929 L
.60705 .30978 L
Mistroke
.60709 .30705 L
.60711 .30452 L
.60718 .29981 L
.60721 .29811 L
.60724 .29654 L
.60727 .29857 L
.6073 .30078 L
.60733 .30299 L
.60735 .30376 L
.60736 .3037 L
.60739 .30359 L
.60742 .30347 L
.60745 .30359 L
.60747 .30401 L
.6075 .30441 L
.60752 .30479 L
.60755 .30448 L
.60757 .3037 L
.6076 .30292 L
.60763 .30222 L
.60766 .30179 L
.60769 .30132 L
.60772 .30084 L
.60773 .30068 L
.60775 .30062 L
.60778 .30051 L
.6078 .3004 L
.60783 .3005 L
.60786 .30084 L
.60788 .30104 L
.60789 .30123 L
.60792 .30125 L
.60795 .30027 L
.60798 .29936 L
.60801 .29828 L
.60803 .29717 L
.60804 .29616 L
.60807 .29445 L
.6081 .29264 L
.60813 .28883 L
.60816 .28497 L
.60818 .28162 L
.60821 .27881 L
.60824 .2773 L
.60826 .27589 L
.60828 .27505 L
.6083 .27432 L
.60833 .27432 L
.6084 .27432 L
.60843 .27432 L
Mistroke
.60846 .27432 L
.60848 .27432 L
.60849 .27452 L
.60851 .27496 L
.60853 .27542 L
.60855 .27622 L
.60859 .277 L
.60861 .277 L
.60864 .277 L
.60867 .277 L
.60869 .27556 L
.6087 .27325 L
.60874 .26878 L
.60876 .26453 L
.60879 .26376 L
.60882 .26462 L
.60888 .26613 L
.60894 .26777 L
.60897 .26861 L
.60898 .26969 L
.609 .2707 L
.60902 .2724 L
.60905 .27419 L
.60908 .27398 L
.60911 .27307 L
.60914 .2723 L
.60916 .27164 L
.60919 .27164 L
.60922 .27164 L
.60923 .27164 L
.60925 .27164 L
.60928 .27082 L
.60932 .26982 L
.60933 .26932 L
.60935 .2688 L
.60938 .26741 L
.60941 .26591 L
.60943 .26513 L
.60944 .26416 L
.60946 .26237 L
.60948 .2607 L
.60951 .25738 L
.60954 .25426 L
.60956 .25472 L
.60959 .25551 L
.60962 .25638 L
.60964 .25652 L
.60965 .25543 L
.60971 .25172 L
.60974 .25016 L
Mistroke
.60977 .24923 L
.60984 .24718 L
.60996 .24222 L
.60998 .24028 L
.61001 .23819 L
.61004 .23758 L
.61007 .23718 L
.61009 .23675 L
.61012 .23679 L
.61015 .23794 L
.61018 .23921 L
.6102 .23987 L
.61021 .24033 L
.61023 .24046 L
.61025 .24059 L
.61028 .24083 L
.61031 .24095 L
.61034 .24033 L
.61036 .23997 L
.61037 .23965 L
.61039 .2393 L
.61041 .23869 L
.61042 .23766 L
.61044 .23654 L
.61047 .23465 L
.6105 .23352 L
.61052 .23378 L
.61054 .23406 L
.61057 .23455 L
.6106 .23472 L
.61063 .23385 L
.61068 .23228 L
.61071 .23168 L
.61074 .23104 L
.61078 .23043 L
.6108 .23104 L
.61083 .23184 L
.61086 .23272 L
.61088 .23424 L
.61091 .23706 L
.61094 .24006 L
.61097 .24334 L
.611 .24548 L
.61103 .24748 L
.61105 .24867 L
.61106 .24979 L
.61108 .24983 L
.6111 .24931 L
.61112 .24838 L
.61116 .24737 L
Mistroke
.61118 .24724 L
.61121 .24734 L
.61124 .24745 L
.61127 .24797 L
.61129 .24939 L
.61132 .25073 L
.61137 .25343 L
.61142 .25683 L
.61145 .25867 L
.61148 .25954 L
.61151 .26049 L
.61152 .26103 L
.61154 .26153 L
.61157 .26196 L
.6116 .26232 L
.61162 .26264 L
.61165 .26241 L
.61168 .26118 L
.61171 .26005 L
.61174 .25902 L
.61176 .25932 L
.61182 .25999 L
.61188 .26088 L
.61189 .26115 L
.61191 .26141 L
.61194 .26239 L
.61199 .26541 L
.61202 .26703 L
.61205 .26637 L
.61208 .26559 L
.61212 .26484 L
.61214 .26466 L
.61217 .26453 L
.61219 .26446 L
.61221 .2644 L
.61223 .26442 L
.61224 .26449 L
.61228 .26463 L
.61231 .26475 L
.61234 .26476 L
.61237 .26476 L
.6124 .26476 L
.61242 .26298 L
.61246 .25995 L
.61247 .25829 L
.61249 .25675 L
.61252 .25532 L
.61255 .25482 L
.61258 .25437 L
.6126 .25459 L
Mistroke
.61263 .2579 L
.61266 .26104 L
.61269 .2644 L
.61272 .26525 L
.61275 .26585 L
.61276 .26619 L
.61278 .2665 L
.61281 .26833 L
.61283 .271 L
.61286 .2735 L
.61288 .27582 L
.61291 .27618 L
.61294 .27654 L
.61297 .27686 L
.613 .27666 L
.61303 .27603 L
.61306 .27537 L
.61308 .2751 L
.6131 .27518 L
.61313 .27531 L
.61316 .27544 L
.61318 .27513 L
.6132 .27455 L
.61323 .27341 L
.61326 .27236 L
.61329 .27271 L
.61332 .27379 L
.61333 .27436 L
.61335 .27497 L
.61338 .2756 L
.61341 .27583 L
.61343 .27604 L
.61346 .2773 L
.61349 .28232 L
.61352 .28744 L
.61354 .29014 L
.61355 .29252 L
.61359 .28959 L
.61361 .28689 L
.61364 .2843 L
.61367 .28344 L
.61369 .28333 L
.61372 .28321 L
.61375 .28287 L
.61377 .28244 L
.61379 .28204 L
.61382 .28131 L
.61383 .28094 L
.61385 .28174 L
.61388 .28401 L
Mistroke
.61391 .2864 L
.61394 .28812 L
.61397 .28823 L
.614 .28834 L
.61403 .28846 L
.61405 .28949 L
.61408 .29059 L
.61411 .29188 L
.61414 .29264 L
.61417 .29252 L
.6142 .29241 L
.61422 .29231 L
.61425 .29231 L
.61427 .29231 L
.6143 .29231 L
.61433 .29255 L
.61435 .29318 L
.61441 .29455 L
.61447 .29372 L
.61448 .29347 L
.6145 .2932 L
.61453 .29418 L
.61456 .2956 L
.61458 .29693 L
.61461 .29874 L
.61464 .30189 L
.61471 .3091 L
.61474 .31276 L
.61477 .31674 L
.6148 .31995 L
.61483 .32042 L
.61486 .32086 L
.61489 .32133 L
.61491 .32446 L
.61494 .32769 L
.61497 .33097 L
.61499 .33356 L
.61502 .33292 L
.61504 .33223 L
.61507 .33156 L
.6151 .33247 L
.61513 .33413 L
.61515 .335 L
.61516 .33592 L
.61519 .33531 L
.61522 .33297 L
.61525 .33087 L
.61527 .3287 L
.6153 .33186 L
.61533 .33481 L
Mistroke
.61536 .33795 L
.61537 .3389 L
.61539 .33871 L
.61542 .3383 L
.61546 .33793 L
.61548 .33921 L
.61551 .34117 L
.61557 .3453 L
.6156 .34746 L
.61562 .34865 L
.61564 .34977 L
.61565 .35082 L
.61567 .35033 L
.6157 .34939 L
.61577 .34708 L
.6158 .34553 L
.61582 .34468 L
.61584 .34387 L
.61585 .34358 L
.61587 .34358 L
.6159 .34358 L
.61593 .34358 L
.61596 .34406 L
.61598 .34446 L
.61599 .34484 L
.61602 .34556 L
.61604 .34556 L
.61606 .3442 L
.61609 .34114 L
.61612 .33868 L
.61614 .3387 L
.61617 .34165 L
.6162 .34481 L
.61622 .3464 L
.61623 .34726 L
.61626 .34666 L
.61629 .34606 L
.61632 .34552 L
.61635 .34799 L
.61638 .35076 L
.61641 .35378 L
.61644 .35563 L
.61649 .35814 L
.61655 .36035 L
.61658 .36139 L
.61661 .36229 L
.61664 .36164 L
.61667 .36092 L
.61669 .36052 L
.6167 .36014 L
Mistroke
.61672 .36022 L
.61674 .36051 L
.61677 .36102 L
.6168 .3615 L
.61683 .36244 L
.61686 .36353 L
.61692 .36575 L
.61695 .36691 L
.61698 .36801 L
.61701 .37098 L
.61704 .37452 L
.61707 .37848 L
.61709 .38028 L
.61711 .37986 L
.61717 .37841 L
.61718 .37801 L
.6172 .37781 L
.61722 .37758 L
.61724 .37737 L
.61727 .37699 L
.61729 .37791 L
.6173 .38034 L
.61733 .38478 L
.61736 .389 L
.61739 .39112 L
.61741 .39134 L
.61744 .39159 L
.61746 .39172 L
.61748 .39195 L
.61751 .39267 L
.61753 .39335 L
.61756 .39398 L
.61759 .39352 L
.61761 .39294 L
.61764 .39232 L
.61767 .39191 L
.6177 .39251 L
.61775 .3936 L
.61782 .3968 L
.61785 .39845 L
.61788 .39897 L
.61791 .39933 L
.61792 .39954 L
.61794 .39972 L
.61796 .40004 L
.61797 .40054 L
.61801 .40154 L
.61804 .40241 L
.61807 .40114 L
.6181 .39975 L
Mistroke
.61812 .39828 L
.61815 .39805 L
.61818 .39896 L
.61825 .40161 L
.6183 .40588 L
.61833 .40757 L
.61836 .40608 L
.61843 .4026 L
.61849 .39864 L
.61851 .3976 L
.61852 .39689 L
.61856 .39777 L
.61858 .39831 L
.61859 .39881 L
.61861 .39927 L
.61863 .39916 L
.61864 .39879 L
.61866 .39837 L
.61868 .39797 L
.61869 .39754 L
.61871 .39715 L
.61873 .39727 L
.61876 .39751 L
.61879 .39775 L
.6188 .39787 L
.61882 .39786 L
.61885 .39774 L
.61888 .39763 L
.61889 .39757 L
.61891 .39713 L
.61894 .39522 L
.61901 .39093 L
.61906 .38752 L
.61909 .38562 L
.61912 .38511 L
.61913 .38498 L
.61915 .38484 L
.61918 .38459 L
.61921 .38375 L
.61924 .38272 L
.61927 .38163 L
.6193 .38208 L
.61932 .38404 L
.61935 .38617 L
.61942 .38985 L
.61945 .39117 L
.61947 .39241 L
.6195 .39281 L
.61952 .39312 L
.61955 .39347 L
Mistroke
.61958 .39269 L
.61961 .38892 L
.61963 .38478 L
.61966 .38047 L
.61969 .37954 L
.62019 .35977 L
.62022 .3591 L
.62024 .35851 L
.62027 .35863 L
.6203 .35874 L
.62033 .35884 L
.62035 .35906 L
.62041 .35973 L
.62046 .36059 L
.62049 .36114 L
.62052 .36173 L
.62053 .36159 L
.62055 .36072 L
.62058 .359 L
.62064 .35595 L
.62067 .3547 L
.6207 .35335 L
.62071 .35258 L
.62073 .35067 L
.62076 .34595 L
.62079 .34111 L
.62081 .33855 L
.62083 .3372 L
.62084 .33645 L
.62086 .33562 L
.62089 .33416 L
.62092 .33298 L
.62095 .33232 L
.62101 .33069 L
.62107 .32784 L
.6211 .32625 L
.62112 .32679 L
.62116 .32794 L
.62119 .32902 L
.62121 .3277 L
.62124 .32458 L
.62131 .31795 L
.62134 .31384 L
.62136 .31184 L
.62137 .31 L
.62139 .30857 L
.62141 .30982 L
.62144 .31258 L
.62146 .31389 L
.62147 .31528 L
Mistroke
.62149 .31495 L
.62151 .31299 L
.62164 .30011 L
.62212 .26491 L
.62237 .25059 L
.6225 .24425 L
.62257 .242 L
.6226 .24061 L
.62264 .23949 L
.62267 .23937 L
.62269 .23925 L
.62272 .23913 L
.62274 .23934 L
.62276 .23959 L
.62279 .24012 L
.62282 .24062 L
.62284 .23923 L
.62285 .23748 L
.62289 .23377 L
.62292 .23083 L
.62295 .22987 L
.62301 .22813 L
.62304 .22754 L
.62307 .22695 L
.6231 .22639 L
.62312 .22694 L
.62324 .23803 L
.62327 .24257 L
.62329 .24688 L
.62332 .24713 L
.62335 .24595 L
.62337 .24479 L
.6234 .24366 L
.62343 .24317 L
.62346 .24272 L
.62352 .24181 L
.62355 .24143 L
.62358 .24109 L
.62361 .24163 L
.62364 .24236 L
.62367 .2431 L
.62369 .24312 L
.62371 .24267 L
.62374 .24172 L
.62376 .24126 L
.62377 .24083 L
.62379 .23934 L
.62381 .23711 L
.62384 .23321 L
.62387 .23011 L
Mistroke
.6239 .22851 L
.62393 .22713 L
.62396 .22583 L
.62398 .22568 L
.62399 .22693 L
.62402 .22919 L
.62408 .23324 L
.62414 .23694 L
.62418 .23979 L
.62421 .24311 L
.62424 .24602 L
.62427 .24727 L
.62428 .24647 L
.6243 .24561 L
.62433 .24405 L
.62436 .24301 L
.62439 .24326 L
.62442 .24349 L
.62445 .24372 L
.62448 .24382 L
.6245 .24394 L
.62453 .24405 L
.62456 .24425 L
.62459 .24461 L
.62462 .245 L
.62463 .24519 L
.62465 .24498 L
.62468 .24435 L
.62474 .24325 L
.62477 .24278 L
.6248 .24229 L
.62482 .24201 L
.62484 .24188 L
.62485 .24209 L
.62487 .24228 L
.6249 .24267 L
.62492 .24288 L
.62494 .24398 L
.625 .24998 L
.62506 .2551 L
.62509 .2575 L
.62512 .2597 L
.62515 .259 L
.62517 .25835 L
.6252 .25767 L
.62523 .25758 L
.62525 .25764 L
.62527 .25771 L
.6253 .25783 L
.62533 .25982 L
Mistroke
.62536 .2629 L
.62538 .26562 L
.62541 .26761 L
.62544 .26802 L
.62547 .26848 L
.62549 .2689 L
.62552 .26864 L
.62555 .26815 L
.62556 .26789 L
.62558 .26761 L
.62561 .26952 L
.62564 .27245 L
.62576 .28254 L
.62582 .28983 L
.62586 .29456 L
.62588 .29687 L
.62589 .29769 L
.62592 .2986 L
.62595 .29958 L
.62597 .30009 L
.62598 .30098 L
.62602 .30312 L
.62603 .30416 L
.62605 .30529 L
.62608 .30647 L
.62611 .30484 L
.62613 .30399 L
.62614 .30305 L
.62617 .30202 L
.62621 .30266 L
.62624 .30324 L
.62626 .30381 L
.62628 .30455 L
.6263 .30535 L
.62633 .30676 L
.6264 .31009 L
.62643 .31166 L
.62645 .31245 L
.62647 .31252 L
.62648 .31246 L
.6265 .3124 L
.62653 .31228 L
.62655 .31221 L
.62656 .31152 L
.62659 .31008 L
.62661 .3092 L
.62663 .30837 L
.62664 .30763 L
.62666 .30951 L
.62678 .32118 L
Mistroke
.6269 .33279 L
.62696 .33854 L
.62699 .34054 L
.62701 .34238 L
.62704 .34332 L
.62707 .34356 L
.6271 .34378 L
.62712 .34411 L
.62715 .34553 L
.62718 .34709 L
.62721 .34861 L
.62724 .35237 L
.62728 .35685 L
.62731 .36101 L
.62732 .36187 L
.62734 .36174 L
.62737 .36146 L
.62739 .36134 L
.62741 .3612 L
.62744 .36118 L
.62747 .36118 L
.62749 .36118 L
.62752 .36313 L
.62755 .36679 L
.62761 .37319 L
.62765 .3765 L
.62766 .37814 L
.62768 .37965 L
.62771 .38087 L
.62772 .38 L
.62774 .37908 L
.62777 .37736 L
.62779 .3764 L
.6278 .37665 L
.62783 .37817 L
.62786 .37976 L
.62793 .3822 L
.628 .3842 L
.62897 .40561 L
.629 .40506 L
.62903 .40452 L
.62906 .40611 L
.62909 .40799 L
.62914 .41182 L
.62919 .41588 L
.62922 .41792 L
.62924 .41796 L
.62927 .41699 L
.6293 .41612 L
.62933 .41538 L
Mistroke
.62935 .41517 L
.62936 .41499 L
.62939 .41464 L
.62942 .41528 L
.62945 .41916 L
.62949 .42332 L
.62952 .42645 L
.62954 .42556 L
.62958 .42451 L
.62959 .42396 L
.62961 .42357 L
.62963 .42363 L
.62965 .4237 L
.62968 .42383 L
.62971 .42387 L
.62974 .42354 L
.62977 .42319 L
.62978 .423 L
.6298 .4228 L
.62983 .42498 L
.62985 .42711 L
.62991 .43164 L
.62994 .43396 L
.62996 .43523 L
.62998 .43642 L
.63 .43684 L
.63001 .43504 L
.63005 .43187 L
.63012 .42572 L
.63015 .42309 L
.63016 .42171 L
.63018 .42023 L
.63021 .42022 L
.63024 .42034 L
.63027 .42046 L
.6303 .41979 L
.63033 .41867 L
.63034 .41808 L
.63036 .41746 L
.63038 .4167 L
.63039 .4151 L
.63042 .41228 L
.63054 .40335 L
.63061 .39823 L
.63067 .39315 L
.63073 .38916 L
.63075 .38807 L
.63077 .3875 L
.6308 .38726 L
.63082 .38705 L
Mistroke
.63085 .38683 L
.63088 .3849 L
.63091 .38298 L
.6319 .31463 L
.63214 .28665 L
.63221 .27979 L
.63224 .27721 L
.63227 .27483 L
.6323 .27327 L
.63233 .27207 L
.63239 .26959 L
.63285 .24739 L
.63332 .22795 L
.63338 .22603 L
.6334 .22553 L
.63341 .225 L
.63344 .22491 L
.63347 .22547 L
.6335 .22599 L
.63353 .22621 L
.63356 .22352 L
.63377 .20972 L
.6338 .20916 L
.63383 .20733 L
.63385 .20464 L
.63388 .20219 L
.63391 .1997 L
.63394 .19959 L
.63397 .19947 L
.634 .19934 L
.63402 .20153 L
.63405 .2044 L
.63407 .20704 L
.6341 .20917 L
.63413 .20753 L
.63415 .20577 L
.63421 .20131 L
.63424 .19726 L
.63426 .19345 L
.63429 .19036 L
.63432 .19115 L
.63435 .19203 L
.63437 .19249 L
.63439 .19307 L
.63442 .19447 L
.63445 .19575 L
.63448 .19696 L
.63451 .19692 L
.63453 .19681 L
.63456 .19671 L
Mistroke
.63459 .19729 L
.63461 .19803 L
.63462 .19871 L
.63465 .19996 L
.63468 .20051 L
.63471 .19952 L
.63474 .19844 L
.63477 .1972 L
.6348 .19498 L
.63482 .19294 L
.63485 .19101 L
.63488 .19151 L
.6349 .19353 L
.63493 .19577 L
.63496 .19767 L
.63499 .19892 L
.63502 .20029 L
.63505 .20156 L
.63507 .20063 L
.63509 .19978 L
.63512 .19825 L
.63515 .19659 L
.63517 .19382 L
.6352 .19076 L
.63523 .18797 L
.63526 .18722 L
.63529 .1884 L
.63531 .18948 L
.63534 .19064 L
.63537 .19123 L
.6354 .19175 L
.63542 .19223 L
.63545 .19134 L
.63548 .18935 L
.6355 .18745 L
.63553 .18551 L
.63556 .18507 L
.63559 .18466 L
.63562 .18418 L
.63565 .18567 L
.63567 .18793 L
.6357 .19039 L
.63576 .19454 L
.63579 .19645 L
.63582 .19817 L
.63585 .19794 L
.63588 .1977 L
.63593 .1972 L
.63596 .19688 L
.63599 .19654 L
Mistroke
.63601 .19637 L
.63604 .19929 L
.6363 .22364 L
.63653 .24152 L
.63659 .24505 L
.63665 .24814 L
.63668 .24975 L
.6367 .25016 L
.63671 .25049 L
.63674 .25108 L
.63677 .2517 L
.6368 .25325 L
.63683 .25505 L
.63688 .25801 L
.63691 .2593 L
.63694 .26068 L
.63697 .2618 L
.637 .26224 L
.63703 .26274 L
.63705 .26301 L
.63707 .26341 L
.63709 .26555 L
.63713 .2679 L
.63714 .26921 L
.63716 .27045 L
.63719 .2705 L
.63722 .2705 L
.63724 .2705 L
.63726 .27059 L
.63729 .27121 L
.63732 .2718 L
.63735 .27234 L
.63738 .27417 L
.6375 .28539 L
.63756 .29131 L
.63761 .29604 L
.63764 .29818 L
.63766 .29852 L
.63768 .29883 L
.63773 .29996 L
.6378 .30072 L
.63781 .3009 L
.63783 .3011 L
.63785 .30173 L
.63786 .30234 L
.63798 .30597 L
.63849 .32382 L
.63896 .34233 L
.63909 .3492 L
.63912 .35178 L
Mistroke
.63914 .35319 L
.63915 .35451 L
.63918 .35611 L
.63921 .35733 L
.63923 .35805 L
.63925 .35874 L
.63928 .35965 L
.63932 .36035 L
.63935 .3611 L
.63941 .36209 L
.63943 .36236 L
.63945 .36264 L
.63946 .3616 L
.63948 .35993 L
.63951 .35681 L
.63953 .35511 L
.63954 .35353 L
.63957 .35343 L
.6396 .35379 L
.63962 .354 L
.63964 .35419 L
.63967 .35595 L
.6397 .35848 L
.63972 .35986 L
.63973 .36116 L
.63976 .3624 L
.63979 .36352 L
.63985 .36523 L
.63988 .36572 L
.6399 .36597 L
.63991 .36625 L
.63994 .36713 L
.63997 .36842 L
.64003 .37115 L
.64006 .37252 L
.64009 .37401 L
.64012 .37549 L
.64014 .37467 L
.64017 .37347 L
.64019 .37221 L
.64022 .3711 L
.64025 .37098 L
.64028 .37088 L
.64031 .37076 L
.64033 .37079 L
.64034 .37086 L
.64037 .37099 L
.6404 .3711 L
.64043 .37325 L
.64046 .37587 L
Mistroke
.64049 .37831 L
.64052 .37913 L
.64055 .37824 L
.64058 .37749 L
.6406 .3769 L
.64063 .37726 L
.64066 .37758 L
.64069 .37793 L
.64072 .3812 L
.64075 .38475 L
.64077 .38857 L
.64081 .39076 L
.64083 .391 L
.64085 .39114 L
.64087 .39127 L
.6409 .39092 L
.64095 .38922 L
.64098 .38843 L
.64101 .38939 L
.64111 .39402 L
.64114 .39579 L
.64117 .39766 L
.64118 .39714 L
.6412 .396 L
.64123 .394 L
.64126 .39211 L
.64129 .39172 L
.64131 .39217 L
.64134 .39258 L
.6414 .39309 L
.64142 .39315 L
.64143 .39322 L
.64147 .39352 L
.6415 .39453 L
.64153 .39547 L
.64155 .39633 L
.64158 .39616 L
.64162 .3959 L
.64165 .39565 L
.64167 .39782 L
.6417 .4006 L
.64177 .40588 L
.6418 .40805 L
.64182 .40924 L
.64184 .41038 L
.64187 .411 L
.6419 .41146 L
.64193 .41189 L
.64196 .41155 L
.64199 .41068 L
Mistroke
.642 .4102 L
.64202 .40976 L
.64205 .40921 L
.64208 .40883 L
.6423 .4051 L
.64233 .40498 L
.64236 .40426 L
.64239 .40358 L
.64241 .40295 L
.64244 .4044 L
.64247 .40592 L
.6425 .40761 L
.64251 .40827 L
.64253 .40841 L
.64256 .40863 L
.64258 .40883 L
.64261 .40892 L
.64263 .40771 L
.64274 .4019 L
.64277 .40011 L
.6428 .39883 L
.64282 .3992 L
.64284 .39953 L
.64287 .40017 L
.64293 .40165 L
.64296 .40251 L
.64298 .40299 L
.64299 .4032 L
.64302 .40285 L
.64305 .40246 L
.64308 .40213 L
.64311 .40033 L
.64314 .39843 L
.64317 .39663 L
.64319 .39594 L
.64322 .39583 L
.64325 .39571 L
.64328 .3954 L
.64331 .39363 L
.64334 .39177 L
.64339 .38901 L
.64342 .38785 L
.64345 .38674 L
.64346 .38612 L
.64348 .3846 L
.64351 .38177 L
.64357 .37622 L
.64363 .36999 L
.6437 .36384 L
.64373 .36118 L
Mistroke
.64375 .35971 L
.64376 .35913 L
.64378 .35895 L
.6438 .35875 L
.64383 .35839 L
.64384 .3582 L
.64386 .35773 L
.6439 .35645 L
.64396 .35437 L
.64408 .35067 L
.64411 .34892 L
.64413 .34796 L
.64414 .34735 L
.64417 .34711 L
.6442 .34688 L
.64423 .34665 L
.64426 .34307 L
.64432 .33439 L
.64435 .33137 L
.64438 .32878 L
.64444 .32175 L
.6445 .31176 L
.64456 .30504 L
.64462 .29954 L
.64467 .29503 L
.6447 .29248 L
.64473 .29135 L
.64474 .29156 L
.64476 .29176 L
.64479 .29213 L
.64481 .29236 L
.64482 .29297 L
.64486 .29407 L
.64487 .29464 L
.64489 .29525 L
.64491 .29562 L
.64493 .29512 L
.64496 .29425 L
.64497 .29379 L
.64499 .2933 L
.64501 .29343 L
.64502 .2943 L
.64505 .29584 L
.64508 .29733 L
.64511 .29784 L
.64514 .29749 L
.64517 .29718 L
.6452 .29657 L
.64523 .29529 L
.64525 .29413 L
Mistroke
.64528 .2929 L
.64531 .29002 L
.64534 .28709 L
.64537 .28394 L
.64539 .28267 L
.6454 .28248 L
.64543 .28214 L
.64546 .28181 L
.64548 .28116 L
.64551 .27916 L
.64554 .27699 L
.64557 .27469 L
.6456 .27404 L
.64562 .27372 L
.64565 .27335 L
.64568 .27277 L
.64571 .27193 L
.64575 .271 L
.64576 .27051 L
.64578 .27037 L
.64581 .27008 L
.64583 .26996 L
.64585 .26982 L
.64588 .27092 L
.646 .27429 L
.64612 .27652 L
.64615 .27777 L
.64618 .27789 L
.6462 .278 L
.64623 .27811 L
.64625 .27801 L
.64626 .2777 L
.64629 .27709 L
.64632 .27649 L
.64635 .27612 L
.64638 .27591 L
.64641 .27568 L
.64643 .27549 L
.64646 .27598 L
.64649 .2764 L
.64652 .27685 L
.64654 .27637 L
.64657 .2755 L
.64706 .25985 L
.64709 .26008 L
.64712 .26024 L
.64716 .26038 L
.64719 .2605 L
.64722 .26055 L
.64724 .26055 L
Mistroke
.64727 .26055 L
.6473 .2601 L
.64732 .25941 L
.64734 .25866 L
.64737 .25729 L
.6474 .25723 L
.64743 .26012 L
.64746 .26362 L
.64749 .26598 L
.64751 .26515 L
.64752 .26426 L
.64754 .26335 L
.64756 .26237 L
.64759 .26004 L
.64762 .25651 L
.64768 .24881 L
.6478 .23802 L
.64783 .2347 L
.64786 .23111 L
.64789 .23023 L
.64792 .23012 L
.64794 .23003 L
.64797 .22979 L
.64799 .22879 L
.64802 .22786 L
.64805 .22686 L
.64808 .22457 L
.64811 .22133 L
.64814 .21834 L
.64817 .21747 L
.64819 .21851 L
.64825 .22087 L
.64836 .22499 L
.64838 .22695 L
.64841 .22905 L
.64844 .23103 L
.64847 .22885 L
.64849 .22632 L
.64852 .22358 L
.64854 .22245 L
.64855 .22338 L
.64858 .2252 L
.64861 .22686 L
.64864 .22797 L
.64866 .22776 L
.64869 .22752 L
.64871 .2274 L
.64873 .22727 L
.64876 .22749 L
.64881 .22794 L
Mistroke
.64885 .2282 L
.64888 .22847 L
.6489 .2286 L
.64891 .22873 L
.64894 .22701 L
.64897 .22464 L
.649 .2221 L
.64903 .2213 L
.64905 .22244 L
.64908 .22378 L
.6491 .22448 L
.64912 .22489 L
.64915 .22452 L
.64918 .22417 L
.64921 .22382 L
.64924 .21831 L
.64926 .21351 L
.64929 .20827 L
.64931 .20805 L
.64933 .20972 L
.64936 .21302 L
.64939 .21602 L
.64941 .21659 L
.64942 .21665 L
.64945 .21676 L
.64948 .21688 L
.64951 .21758 L
.64953 .21902 L
.64956 .22056 L
.64958 .22141 L
.6496 .22188 L
.64963 .22176 L
.64965 .22165 L
.64968 .22154 L
.64971 .22109 L
.64973 .22061 L
.64976 .22009 L
.64978 .21975 L
.64981 .22089 L
.64987 .22349 L
.65035 .23887 L
.65086 .25287 L
.65177 .27656 L
.65275 .30318 L
.65286 .31692 L
.65289 .32053 L
.65292 .32397 L
.65294 .32632 L
.65297 .3261 L
.65299 .3259 L
Mistroke
.65302 .32568 L
.65305 .3249 L
.65308 .32391 L
.65309 .32334 L
.65311 .32272 L
.65314 .32209 L
.65317 .32197 L
.6532 .32186 L
.65323 .32239 L
.65326 .32466 L
.65329 .32737 L
.65332 .3292 L
.65334 .32852 L
.65335 .32778 L
.65338 .32644 L
.6534 .3257 L
.65342 .32563 L
.65343 .32655 L
.65345 .32757 L
.65348 .32927 L
.65351 .33101 L
.65352 .33151 L
.65354 .33206 L
.65357 .33302 L
.6536 .33393 L
.65363 .33423 L
.65366 .33445 L
.65369 .33467 L
.6537 .33508 L
.65372 .33675 L
.65375 .33969 L
.65377 .34135 L
.65379 .34313 L
.65381 .34368 L
.65382 .34382 L
.65385 .34406 L
.65389 .34431 L
.6539 .3445 L
.65392 .34472 L
.65395 .34511 L
.65398 .34549 L
.654 .34542 L
.65402 .34536 L
.65408 .34511 L
.65414 .34488 L
.65417 .34477 L
.65418 .34422 L
.6542 .343 L
.65423 .34059 L
.65424 .33933 L
Mistroke
.65426 .33799 L
.65429 .33731 L
.65432 .33765 L
.65435 .33798 L
.65437 .33875 L
.6544 .34145 L
.65443 .34436 L
.6545 .34995 L
.65453 .35233 L
.65456 .35424 L
.65459 .3538 L
.65462 .35333 L
.65464 .35306 L
.65465 .3528 L
.65468 .35417 L
.65492 .36762 L
.65504 .37526 L
.65508 .37794 L
.65511 .38049 L
.65513 .38251 L
.65516 .38109 L
.65519 .37986 L
.65522 .37855 L
.65524 .37792 L
.65527 .37771 L
.65529 .37749 L
.65532 .37726 L
.65535 .37757 L
.65538 .37787 L
.6554 .37821 L
.65543 .37744 L
.65546 .37484 L
.65549 .37206 L
.6555 .37066 L
.65552 .3696 L
.65555 .3696 L
.65558 .3696 L
.65561 .3696 L
.65564 .37002 L
.65567 .37045 L
.65569 .37092 L
.65573 .37068 L
.65575 .37002 L
.65578 .36931 L
.65581 .36877 L
.65584 .36857 L
.65587 .36832 L
.65588 .36819 L
.6559 .36807 L
.65591 .3678 L
Mistroke
.65593 .36751 L
.65596 .367 L
.656 .36658 L
.65602 .36726 L
.65605 .36797 L
.65607 .36838 L
.65609 .36877 L
.65612 .37125 L
.65615 .37406 L
.65621 .37835 L
.65624 .38021 L
.65628 .38199 L
.65629 .38206 L
.65631 .38183 L
.65633 .38162 L
.65635 .38143 L
.65636 .38124 L
.65638 .3813 L
.65641 .38354 L
.65644 .38598 L
.65646 .38731 L
.65647 .38838 L
.6565 .38873 L
.65654 .38912 L
.65656 .38944 L
.65659 .38919 L
.65662 .38884 L
.65665 .38846 L
.65668 .38884 L
.65671 .3895 L
.65674 .3902 L
.65677 .39024 L
.6568 .38924 L
.65684 .38814 L
.65685 .38757 L
.65687 .38731 L
.65689 .387 L
.65691 .38671 L
.65697 .38545 L
.657 .38474 L
.65704 .38398 L
.65705 .38403 L
.65707 .38475 L
.6571 .38602 L
.65759 .40114 L
.65761 .40068 L
.65764 .40145 L
.65767 .40269 L
.6577 .40382 L
.65773 .40389 L
Mistroke
.65775 .40333 L
.65776 .40281 L
.6578 .40181 L
.65782 .40118 L
.65785 .40087 L
.65788 .40054 L
.65791 .40038 L
.65794 .40248 L
.658 .40711 L
.65805 .41221 L
.65808 .4151 L
.6581 .41594 L
.65812 .414 L
.65815 .41023 L
.65817 .40826 L
.65819 .40618 L
.6582 .40613 L
.65822 .40707 L
.65825 .40871 L
.65827 .40952 L
.65828 .41038 L
.65831 .40829 L
.65835 .40568 L
.65836 .4043 L
.65838 .40285 L
.65841 .40295 L
.65844 .40341 L
.65847 .40386 L
.65849 .4051 L
.65852 .40705 L
.65855 .40915 L
.65858 .41016 L
.6586 .40943 L
.65862 .40874 L
.65865 .40724 L
.65868 .40616 L
.65871 .40572 L
.65874 .40526 L
.65877 .40484 L
.65878 .40668 L
.6588 .40839 L
.65883 .41226 L
.65885 .41416 L
.65886 .4156 L
.65889 .4163 L
.65893 .41707 L
.65896 .41775 L
.65898 .41682 L
.65899 .41594 L
.65903 .41418 L
Mistroke
.65905 .41318 L
.65906 .41283 L
.65909 .41283 L
.65911 .41283 L
.65913 .41283 L
.65916 .413 L
.65918 .41356 L
.65924 .41462 L
.6593 .41597 L
.65933 .41669 L
.65934 .41681 L
.65936 .41517 L
.65939 .41209 L
.65942 .40918 L
.65943 .40754 L
.65945 .40715 L
.65948 .40727 L
.6595 .40733 L
.65951 .40741 L
.65953 .40747 L
.65955 .40706 L
.66051 .37639 L
.66144 .33508 L
.66191 .32078 L
.66198 .3231 L
.66199 .32378 L
.66201 .32449 L
.66203 .32461 L
.66204 .32407 L
.66207 .3231 L
.66209 .32256 L
.6621 .32206 L
.66214 .31951 L
.66216 .3166 L
.66223 .3098 L
.66227 .3064 L
.66229 .30453 L
.6623 .30278 L
.66232 .30221 L
.66234 .30171 L
.66237 .30083 L
.66238 .30039 L
.6624 .29996 L
.66243 .29984 L
.66246 .29972 L
.66249 .2996 L
.6625 .29961 L
.66252 .29968 L
.66255 .2998 L
.66258 .29992 L
Mistroke
.66261 .29829 L
.66264 .2961 L
.66267 .29369 L
.66279 .27774 L
.66292 .26284 L
.66295 .2587 L
.66298 .25554 L
.66301 .25338 L
.66305 .25102 L
.66308 .24923 L
.6631 .2484 L
.66313 .24742 L
.66316 .24653 L
.66319 .2435 L
.66322 .23988 L
.66327 .23268 L
.66333 .22757 L
.66336 .22466 L
.66338 .22532 L
.66344 .22696 L
.6635 .2289 L
.66352 .2294 L
.66353 .22993 L
.66355 .23007 L
.66357 .22938 L
.66363 .22687 L
.66369 .22486 L
.66372 .22388 L
.66374 .22356 L
.66376 .2242 L
.66382 .22655 L
.66387 .22906 L
.6639 .23033 L
.66392 .23167 L
.66396 .22808 L
.66398 .22412 L
.66403 .21755 L
.66409 .21222 L
.66412 .20926 L
.66414 .20861 L
.66417 .20829 L
.6642 .20798 L
.66423 .20879 L
.66425 .21157 L
.66428 .21458 L
.6643 .21628 L
.66432 .21679 L
.66435 .21394 L
.66438 .21093 L
.66444 .20696 L
Mistroke
.66447 .20535 L
.6645 .20392 L
.66452 .20385 L
.66454 .20378 L
.66455 .20371 L
.66457 .20364 L
.6646 .20365 L
.66463 .20568 L
.66466 .20782 L
.66469 .20967 L
.66472 .20977 L
.66475 .20989 L
.66478 .21 L
.66481 .2088 L
.66492 .20103 L
.66495 .19826 L
.66498 .19567 L
.66501 .19473 L
.66504 .19382 L
.66507 .19302 L
.66509 .19282 L
.66512 .19282 L
.66515 .19282 L
.66518 .19314 L
.6652 .1941 L
.66526 .19628 L
.66529 .19804 L
.66532 .19987 L
.66538 .20413 L
.66541 .20789 L
.66543 .20995 L
.66544 .21186 L
.66547 .213 L
.66549 .2125 L
.6655 .21198 L
.66553 .21104 L
.66556 .21039 L
.66559 .21029 L
.66561 .21018 L
.66564 .21007 L
.66567 .21348 L
.66573 .22127 L
.66579 .22961 L
.66582 .23423 L
.66585 .23749 L
.66588 .23899 L
.66591 .24062 L
.66594 .24187 L
.66597 .24219 L
.66598 .24239 L
Mistroke
.666 .24261 L
.66602 .24281 L
.66603 .24322 L
.66606 .24511 L
.6661 .24712 L
.66623 .25789 L
.66626 .26115 L
.66629 .2647 L
.66632 .26741 L
.66635 .2673 L
.66638 .26719 L
.6664 .26709 L
.66643 .26679 L
.66646 .26631 L
.66652 .26543 L
.66655 .26505 L
.66658 .2647 L
.66661 .26474 L
.66663 .26614 L
.66664 .26765 L
.6667 .27262 L
.66714 .30772 L
.66717 .3107 L
.66719 .31095 L
.66721 .31083 L
.66723 .3106 L
.66726 .31036 L
.66729 .3128 L
.66732 .31619 L
.66734 .31827 L
.66736 .32022 L
.66739 .32182 L
.66741 .32215 L
.66742 .32251 L
.66746 .32326 L
.66753 .32434 L
.6676 .32583 L
.66762 .32665 L
.66766 .3275 L
.66769 .32738 L
.66771 .32727 L
.66774 .32716 L
.66777 .32748 L
.6678 .32809 L
.66783 .32866 L
.66786 .32944 L
.66789 .3305 L
.66792 .33144 L
.66795 .33219 L
.66798 .33243 L
Mistroke
.66801 .33265 L
.66803 .33277 L
.66804 .33289 L
.66807 .33301 L
.66811 .33313 L
.66812 .33321 L
.66814 .33266 L
.66817 .33012 L
.6682 .32775 L
.66823 .32514 L
.66826 .32449 L
.66827 .3243 L
.66829 .32409 L
.66832 .32372 L
.66835 .32602 L
.66838 .32841 L
.66841 .33048 L
.66843 .33162 L
.66846 .33139 L
.66849 .33117 L
.66852 .33098 L
.66855 .33159 L
.66858 .33216 L
.6686 .33269 L
.66863 .33142 L
.66866 .3296 L
.66869 .32763 L
.66871 .32674 L
.66873 .32674 L
.66875 .32674 L
.66878 .32674 L
.66881 .32625 L
.66884 .32401 L
.66886 .32285 L
.66887 .32158 L
.66889 .32038 L
.66891 .32022 L
.66894 .3215 L
.66897 .32287 L
.66903 .32577 L
.66907 .32722 L
.66908 .32805 L
.6691 .32777 L
.66912 .3271 L
.66913 .32647 L
.66916 .32528 L
.66918 .32466 L
.6692 .32346 L
.66921 .32187 L
.66923 .3204 L
Mistroke
.66926 .31801 L
.66929 .31614 L
.6693 .31641 L
.66932 .31665 L
.66935 .31713 L
.66937 .31738 L
.66938 .31703 L
.66941 .31416 L
.66948 .30786 L
.66952 .30535 L
.66953 .30412 L
.66955 .30298 L
.66958 .30175 L
.6696 .30162 L
.66962 .30148 L
.66967 .30102 L
.66971 .30076 L
.66974 .30052 L
.66976 .29994 L
.66979 .29754 L
.66985 .29334 L
.66991 .28513 L
.66993 .28264 L
.66995 .28029 L
.66996 .27968 L
.66998 .27968 L
.67001 .27968 L
.67003 .27968 L
.67004 .27968 L
.67007 .28055 L
.6701 .28165 L
.67013 .28275 L
.67015 .28298 L
.67016 .28251 L
.67022 .28089 L
.67035 .27603 L
.67038 .27354 L
.67041 .27083 L
.67044 .2691 L
.67047 .26857 L
.6705 .26794 L
.67052 .26759 L
.67053 .2675 L
.67056 .26774 L
.67059 .26797 L
.67062 .2682 L
.67065 .26936 L
.67067 .27038 L
.6707 .27148 L
.67073 .27209 L
Mistroke
.67076 .2722 L
.67078 .27227 L
.67079 .27233 L
.67082 .27224 L
.67085 .27183 L
.67088 .27139 L
.67093 .27052 L
.67104 .2684 L
.67194 .25614 L
.67241 .25164 L
.67242 .25059 L
.67244 .2498 L
.67246 .24966 L
.67247 .24953 L
.67249 .24941 L
.67251 .24928 L
.67254 .24894 L
.67257 .24783 L
.6726 .24663 L
.67262 .24601 L
.67263 .24614 L
.67265 .24777 L
.67267 .24953 L
.6727 .25236 L
.67272 .25386 L
.67273 .25505 L
.67277 .25683 L
.6728 .25847 L
.67285 .26091 L
.67288 .26196 L
.67291 .26307 L
.67293 .26154 L
.67294 .2595 L
.67297 .25551 L
.67299 .25336 L
.67301 .25102 L
.67302 .25114 L
.67304 .25176 L
.67316 .25736 L
.67322 .26088 L
.67325 .26281 L
.67327 .26387 L
.67328 .26485 L
.6733 .26558 L
.67332 .26574 L
.67336 .26601 L
.67337 .26615 L
.67339 .26628 L
.67341 .26779 L
.67342 .26926 L
Mistroke
.67345 .27178 L
.67348 .27445 L
.67351 .27507 L
.67354 .27553 L
.67357 .27602 L
.67358 .27622 L
.6736 .27616 L
.67363 .27604 L
.67366 .27592 L
.67368 .27585 L
.67369 .2748 L
.67372 .27267 L
.67375 .27035 L
.67377 .26905 L
.67379 .26915 L
.67382 .26952 L
.67383 .26972 L
.67385 .2699 L
.67388 .26965 L
.67391 .2683 L
.67394 .26696 L
.67396 .26628 L
.67397 .26624 L
.674 .26743 L
.67403 .26855 L
.6741 .27114 L
.67413 .27222 L
.67414 .27279 L
.67416 .27312 L
.67419 .27288 L
.67422 .27265 L
.67425 .27242 L
.67428 .27272 L
.67431 .27309 L
.67432 .27328 L
.67434 .27348 L
.67437 .27486 L
.6744 .27636 L
.67443 .27779 L
.67445 .27858 L
.67448 .2787 L
.67451 .2788 L
.67454 .27891 L
.67456 .27733 L
.67461 .27346 L
.67464 .27174 L
.67467 .2708 L
.6747 .26969 L
.67473 .26866 L
.67475 .2691 L
Mistroke
.67478 .2697 L
.67481 .2703 L
.67483 .27141 L
.67485 .2735 L
.67488 .27753 L
.6749 .2813 L
.67493 .28382 L
.67495 .28452 L
.67497 .28526 L
.67499 .28607 L
.675 .28684 L
.67502 .2871 L
.67504 .28621 L
.67507 .28449 L
.6751 .28292 L
.67513 .28211 L
.67516 .28176 L
.67519 .28139 L
.67521 .28131 L
.67522 .28213 L
.67534 .28791 L
.67578 .30679 L
.67673 .33645 L
.67698 .34922 L
.67701 .34982 L
.67704 .35069 L
.67707 .35188 L
.6771 .35318 L
.67713 .35474 L
.67715 .3569 L
.67718 .35942 L
.67721 .36177 L
.67724 .36272 L
.67726 .36362 L
.67731 .36551 L
.67734 .36631 L
.67737 .36707 L
.67739 .36774 L
.67742 .36699 L
.67747 .36322 L
.67753 .36007 L
.67756 .35879 L
.67759 .35761 L
.67762 .35938 L
.67765 .36184 L
.67767 .36428 L
.6777 .36547 L
.67772 .36511 L
.67774 .3647 L
.67777 .36399 L
Mistroke
.6778 .36367 L
.67781 .36402 L
.67783 .36435 L
.67786 .36498 L
.67789 .3655 L
.67792 .3658 L
.67794 .36613 L
.67797 .36649 L
.678 .36597 L
.67803 .36529 L
.67806 .36454 L
.67809 .36464 L
.67812 .36529 L
.67815 .36599 L
.67818 .36591 L
.67821 .36368 L
.67823 .36164 L
.6783 .35485 L
.67833 .35065 L
.67836 .347 L
.67839 .34663 L
.67841 .34644 L
.67843 .34623 L
.67846 .346 L
.67848 .34966 L
.67852 .354 L
.67854 .35638 L
.67855 .35821 L
.67859 .35895 L
.67862 .35976 L
.67868 .36179 L
.67871 .3632 L
.67874 .36453 L
.67876 .36457 L
.67877 .3645 L
.67881 .36436 L
.67882 .36429 L
.67884 .36421 L
.67887 .36397 L
.6789 .36375 L
.67893 .3635 L
.67896 .36487 L
.67898 .36633 L
.67905 .37042 L
.67908 .3727 L
.67911 .37521 L
.67914 .37606 L
.67916 .37513 L
.67919 .37408 L
.67922 .37309 L
Mistroke
.67925 .37407 L
.67928 .37505 L
.67934 .3771 L
.67936 .37782 L
.67939 .3786 L
.67942 .37882 L
.67944 .3775 L
.67947 .37593 L
.6795 .37423 L
.67953 .37138 L
.67955 .36833 L
.67959 .36478 L
.67961 .36209 L
.67964 .36063 L
.67967 .35905 L
.67973 .35446 L
.67976 .3518 L
.67979 .34931 L
.67981 .34853 L
.67984 .34801 L
.67987 .34743 L
.6799 .34726 L
.67992 .34836 L
.67995 .34956 L
.68001 .35175 L
.68004 .3531 L
.68007 .35438 L
.6801 .35366 L
.68013 .35218 L
.68017 .35057 L
.68018 .34992 L
.6802 .34947 L
.68024 .34867 L
.68027 .34794 L
.6803 .34418 L
.68033 .33987 L
.68039 .33109 L
.68045 .32417 L
.68051 .31867 L
.68062 .31057 L
.68068 .30673 L
.68074 .30276 L
.68079 .29972 L
.68082 .29832 L
.68086 .29756 L
.68087 .29803 L
.68089 .29846 L
.6809 .29892 L
.68092 .29941 L
.68095 .29922 L
Mistroke
.68098 .29742 L
.68143 .26357 L
.68167 .25136 L
.68179 .24445 L
.68185 .24105 L
.68187 .23915 L
.6819 .23743 L
.68193 .23668 L
.68196 .23599 L
.68202 .23442 L
.68205 .23334 L
.68208 .23233 L
.68211 .23213 L
.68214 .23201 L
.68216 .23195 L
.68218 .23188 L
.68219 .23292 L
.68221 .23455 L
.68225 .23805 L
.68227 .23978 L
.68228 .24094 L
.6823 .2405 L
.68231 .24004 L
.68233 .23954 L
.68235 .23907 L
.68238 .23791 L
.68241 .23358 L
.68244 .22972 L
.68247 .22559 L
.6825 .22609 L
.68252 .22682 L
.68259 .22853 L
.68261 .2292 L
.68265 .22994 L
.68267 .22858 L
.68271 .22471 L
.68274 .22077 L
.68276 .21856 L
.68277 .21783 L
.68281 .21655 L
.68284 .21534 L
.68286 .21397 L
.68289 .21201 L
.68292 .21037 L
.68295 .2086 L
.68298 .20863 L
.68301 .20874 L
.68304 .20886 L
.68305 .20898 L
.68307 .20918 L
Mistroke
.68312 .20986 L
.68317 .21046 L
.6832 .21079 L
.68323 .2111 L
.68325 .21159 L
.68329 .2122 L
.68331 .21275 L
.68334 .21314 L
.68335 .2132 L
.68337 .21326 L
.6834 .21338 L
.68343 .21351 L
.68347 .21364 L
.68348 .21371 L
.6835 .21377 L
.68353 .2138 L
.68356 .21347 L
.68359 .21311 L
.68361 .21279 L
.68364 .21291 L
.68367 .21316 L
.6837 .21339 L
.68373 .21242 L
.68375 .21077 L
.68378 .209 L
.68381 .20705 L
.68384 .20806 L
.68387 .20926 L
.6839 .21036 L
.68393 .21064 L
.68396 .21089 L
.68398 .21103 L
.684 .21116 L
.68401 .21065 L
.68403 .20989 L
.68407 .20856 L
.68408 .20795 L
.6841 .20744 L
.68413 .20878 L
.68416 .20996 L
.68419 .21126 L
.6842 .21111 L
.68422 .21037 L
.68425 .20874 L
.68428 .20733 L
.68431 .20843 L
.6853 .23775 L
.68533 .23729 L
.68536 .23802 L
.6854 .23909 L
Mistroke
.68543 .24007 L
.68546 .23837 L
.68548 .23611 L
.68551 .23364 L
.68554 .23352 L
.68556 .23504 L
.68558 .23669 L
.68561 .23968 L
.68565 .24193 L
.68568 .24404 L
.68571 .24597 L
.68573 .24663 L
.68574 .24611 L
.68577 .24514 L
.6858 .24424 L
.68583 .2439 L
.68586 .2444 L
.68589 .24487 L
.68592 .24541 L
.68594 .24668 L
.68597 .24787 L
.68602 .25071 L
.68605 .25256 L
.68608 .25451 L
.68611 .25646 L
.68614 .26069 L
.68626 .27564 L
.68632 .2811 L
.68635 .28366 L
.68638 .28602 L
.6864 .28718 L
.68643 .28761 L
.68646 .28809 L
.68649 .28849 L
.68652 .28861 L
.68655 .28873 L
.68658 .28884 L
.68661 .28962 L
.68664 .29058 L
.68665 .2911 L
.68667 .2916 L
.68669 .2916 L
.6867 .29093 L
.68673 .28963 L
.68676 .28852 L
.68679 .28804 L
.68682 .28793 L
.68685 .28781 L
.68687 .28782 L
.68689 .28923 L
Mistroke
.68692 .29077 L
.68695 .29241 L
.68698 .2935 L
.687 .29361 L
.68702 .29368 L
.68704 .29374 L
.68707 .29377 L
.68709 .29344 L
.68712 .29312 L
.68715 .29278 L
.68718 .29295 L
.68721 .29331 L
.68722 .29349 L
.68724 .29369 L
.68727 .29493 L
.6873 .2966 L
.68741 .30124 L
.68744 .30204 L
.68747 .30451 L
.68749 .30708 L
.68752 .3099 L
.68754 .31141 L
.68755 .31091 L
.68759 .30981 L
.68765 .30791 L
.68768 .30713 L
.68771 .30629 L
.68774 .30564 L
.68776 .30543 L
.68779 .30523 L
.68781 .30501 L
.68784 .30487 L
.68786 .30478 L
.68789 .30467 L
.68792 .30456 L
.68795 .30309 L
.68797 .30151 L
.688 .29987 L
.68803 .29989 L
.68806 .30095 L
.68809 .30191 L
.68834 .31381 L
.68859 .32472 L
.6887 .33082 L
.68873 .33217 L
.68876 .33345 L
.68879 .33439 L
.68881 .33439 L
.68885 .33439 L
.68886 .33439 L
Mistroke
.68888 .33443 L
.68891 .33493 L
.68894 .33539 L
.68897 .33586 L
.689 .3352 L
.68903 .33419 L
.68906 .33327 L
.68908 .33037 L
.68911 .32626 L
.68914 .32156 L
.68917 .31919 L
.6892 .32042 L
.68923 .32172 L
.68925 .32303 L
.68928 .32282 L
.6893 .32249 L
.68932 .32217 L
.68934 .32158 L
.68936 .32152 L
.68938 .32183 L
.68941 .32252 L
.68947 .32394 L
.6895 .32479 L
.68953 .32557 L
.68956 .32606 L
.68958 .32626 L
.68961 .32647 L
.68964 .3267 L
.68966 .32592 L
.68969 .32497 L
.68975 .32252 L
.68978 .32083 L
.6898 .31994 L
.68981 .319 L
.68984 .31842 L
.68987 .31956 L
.68998 .32334 L
.69004 .32485 L
.69007 .3256 L
.6901 .3263 L
.69012 .3267 L
.69013 .32641 L
.69017 .32579 L
.69018 .32548 L
.6902 .32515 L
.69023 .32557 L
.69028 .32857 L
.69031 .33008 L
.69034 .32757 L
.69037 .3246 L
Mistroke
.6904 .32179 L
.69043 .32214 L
.69046 .32312 L
.69052 .32506 L
.69057 .32719 L
.6906 .32826 L
.69062 .33168 L
.69065 .33519 L
.69067 .33705 L
.69068 .33903 L
.69071 .34121 L
.69074 .34295 L
.69077 .3449 L
.69079 .34652 L
.69082 .34742 L
.69085 .3484 L
.69087 .3493 L
.69089 .34942 L
.69092 .34877 L
.69095 .34808 L
.69098 .34742 L
.691 .34721 L
.69103 .34698 L
.69105 .34686 L
.69106 .34673 L
.69109 .34679 L
.69112 .34701 L
.69115 .34724 L
.69118 .3476 L
.69121 .34817 L
.69123 .3487 L
.69126 .34929 L
.69128 .34823 L
.6913 .34712 L
.69133 .34471 L
.69136 .34249 L
.69139 .34219 L
.69143 .34191 L
.69146 .34168 L
.69147 .34161 L
.69149 .34154 L
.69152 .34143 L
.69154 .34132 L
.69157 .34009 L
.6916 .33824 L
.69163 .33639 L
.69165 .33549 L
.69167 .33525 L
.6917 .33467 L
.69172 .3344 L
Mistroke
.69174 .33414 L
.69177 .333 L
.6918 .3315 L
.69186 .32789 L
.69192 .32337 L
.69195 .3215 L
.69197 .32083 L
.692 .32019 L
.69203 .31959 L
.69205 .31972 L
.69208 .32007 L
.69211 .32044 L
.69214 .32015 L
.69217 .31903 L
.69219 .31846 L
.6922 .31785 L
.69223 .3156 L
.69226 .31107 L
.69229 .30571 L
.69232 .30078 L
.69233 .29996 L
.69235 .29948 L
.69238 .29847 L
.69242 .29764 L
.69243 .2975 L
.69245 .29737 L
.69248 .29713 L
.69251 .2969 L
.69252 .29607 L
.69254 .29517 L
.69257 .2936 L
.69263 .29057 L
.69267 .28899 L
.6927 .28749 L
.69273 .28888 L
.69276 .29077 L
.69279 .29249 L
.69281 .29024 L
.69284 .28545 L
.69287 .28024 L
.6929 .27617 L
.69292 .27457 L
.69299 .27077 L
.69302 .26921 L
.69305 .26775 L
.69307 .26648 L
.6931 .26723 L
.69313 .2698 L
.69315 .27215 L
.69318 .27422 L
Mistroke
.69321 .27314 L
.69324 .27219 L
.69326 .27116 L
.69328 .27069 L
.6933 .27036 L
.69333 .26973 L
.69336 .26915 L
.69339 .27042 L
.69341 .2715 L
.69342 .27266 L
.69345 .27475 L
.69347 .27514 L
.69349 .27443 L
.69352 .2731 L
.69355 .27195 L
.69358 .27239 L
.69361 .27323 L
.69364 .27415 L
.69367 .27465 L
.69369 .27458 L
.6937 .27452 L
.69373 .2744 L
.69376 .2749 L
.69468 .28978 L
.69471 .29018 L
.69474 .29185 L
.69477 .29358 L
.69479 .29456 L
.6948 .29528 L
.69482 .29456 L
.69484 .29391 L
.69487 .29243 L
.69491 .29136 L
.69492 .291 L
.69494 .29067 L
.69495 .29036 L
.69497 .29002 L
.695 .28898 L
.69503 .28719 L
.69506 .28555 L
.69512 .28278 L
.69515 .28178 L
.69517 .28121 L
.69519 .28111 L
.69522 .28283 L
.69525 .2847 L
.6953 .2877 L
.69533 .28889 L
.69536 .29015 L
.69538 .29094 L
Mistroke
.69541 .29137 L
.69544 .29184 L
.69547 .2923 L
.69549 .29224 L
.6955 .29217 L
.69553 .29204 L
.69556 .29193 L
.69559 .29696 L
.69562 .30145 L
.69565 .30639 L
.69568 .30875 L
.6957 .30936 L
.69571 .30992 L
.69574 .31093 L
.69577 .3131 L
.6959 .32345 L
.69593 .32468 L
.69595 .32553 L
.69597 .32681 L
.696 .32911 L
.69601 .33034 L
.69603 .33166 L
.69606 .3326 L
.69608 .33206 L
.69611 .33145 L
.69614 .33097 L
.69617 .33107 L
.6962 .33118 L
.69623 .33131 L
.69626 .33253 L
.69631 .33573 L
.69637 .33849 L
.6964 .3396 L
.69643 .34163 L
.69646 .34596 L
.69648 .35072 L
.69651 .35517 L
.69654 .35697 L
.69656 .35697 L
.69659 .35697 L
.69662 .35678 L
.69665 .35493 L
.69667 .35325 L
.6967 .35148 L
.69673 .35298 L
.69676 .35589 L
.69679 .35906 L
.69681 .3608 L
.69683 .36111 L
.69688 .36218 L
Mistroke
.69693 .36328 L
.69696 .36396 L
.69699 .3647 L
.69702 .36685 L
.69704 .36987 L
.69707 .37307 L
.6971 .37598 L
.69713 .37703 L
.69716 .37799 L
.69729 .38256 L
.69754 .39383 L
.69776 .40124 L
.69783 .40374 L
.69786 .40499 L
.69789 .40566 L
.69791 .40617 L
.69794 .40673 L
.69797 .4086 L
.698 .41298 L
.69813 .42737 L
.69825 .44128 L
.69837 .45182 L
.6984 .45436 L
.69844 .45677 L
.69846 .45782 L
.69849 .45892 L
.69947 .48821 L
.69959 .49251 L
.69961 .49332 L
.69964 .49408 L
.69967 .49476 L
.69969 .49705 L
.69972 .50083 L
.69975 .50432 L
.69977 .50809 L
.6998 .50799 L
.69983 .50788 L
.69986 .50776 L
.69988 .50821 L
.69989 .50909 L
.69992 .51082 L
.69996 .51255 L
.69998 .51316 L
.70002 .51328 L
.70005 .51342 L
.70007 .5135 L
.70008 .51365 L
.70012 .51392 L
.70013 .51404 L
.70015 .51418 L
Mistroke
.70018 .51217 L
.70021 .50973 L
.70024 .5071 L
.70027 .50624 L
.70029 .50707 L
.70035 .50896 L
.70041 .51074 L
.70044 .51157 L
.70046 .51171 L
.70048 .51184 L
.70051 .51208 L
.70054 .51219 L
.70056 .51087 L
.70057 .50942 L
.70061 .50688 L
.70062 .50544 L
.70064 .50448 L
.70066 .50412 L
.70068 .50379 L
.70071 .50319 L
.70072 .50286 L
.70074 .50232 L
.70076 .50158 L
.70077 .50078 L
.70081 .49935 L
.70087 .49662 L
.70088 .49585 L
.7009 .49503 L
.70093 .49444 L
.70095 .49546 L
.70096 .49641 L
.70099 .4982 L
.70102 .49963 L
.70105 .49913 L
.7011 .49828 L
.70116 .49714 L
.70118 .49682 L
.7012 .49648 L
.70123 .49778 L
.70124 .49923 L
.70126 .5006 L
.70128 .50185 L
.70129 .50317 L
.70132 .50407 L
.70135 .50429 L
.70138 .50453 L
.7014 .50466 L
.70141 .50317 L
.70234 .41799 L
.70283 .36427 L
Mistroke
.70307 .32762 L
.70314 .31859 L
.70317 .31463 L
.70319 .31247 L
.70321 .31044 L
.70324 .30498 L
.70327 .2983 L
.70333 .28551 L
.70336 .27855 L
.70338 .27488 L
.70339 .27097 L
.70342 .26721 L
.70345 .2653 L
.70347 .26406 L
.70349 .26289 L
.7035 .26205 L
.70352 .26192 L
.70355 .26168 L
.70356 .26156 L
.70358 .26142 L
.70361 .25985 L
.70364 .25732 L
.7037 .25203 L
.70381 .24504 L
.70383 .24271 L
.70386 .24021 L
.70389 .23895 L
.70392 .23947 L
.70395 .24001 L
.70397 .2406 L
.70401 .2388 L
.70404 .23687 L
.70406 .23509 L
.70409 .23156 L
.70415 .22134 L
.70425 .20486 L
.70431 .19753 L
.70433 .19573 L
.70434 .19382 L
.70437 .19334 L
.7044 .19581 L
.70443 .19812 L
.70446 .19999 L
.70448 .19972 L
.70449 .19947 L
.70451 .19921 L
.70453 .19893 L
.70456 .1979 L
.70458 .19657 L
.70459 .19533 L
Mistroke
.70463 .19248 L
.70469 .18812 L
.70471 .18696 L
.70473 .18574 L
.70474 .18489 L
.70476 .18624 L
.70482 .19124 L
.70488 .19596 L
.70491 .19858 L
.70493 .20005 L
.70495 .19871 L
.70501 .19352 L
.70504 .19202 L
.70507 .1919 L
.7051 .19179 L
.70512 .19168 L
.70514 .18931 L
.70516 .18712 L
.70519 .18285 L
.70524 .17496 L
.70527 .17125 L
.7053 .16734 L
.70532 .16562 L
.70533 .16542 L
.70536 .16506 L
.70539 .16472 L
.70542 .16521 L
.70545 .16682 L
.70548 .16828 L
.7055 .16984 L
.70553 .16895 L
.70556 .16795 L
.70559 .16684 L
.70562 .16731 L
.70564 .1688 L
.70569 .17207 L
.70576 .17688 L
.70579 .17932 L
.7058 .17981 L
.70582 .17981 L
.70585 .17981 L
.70587 .17981 L
.70591 .17996 L
.70593 .18018 L
.70596 .18043 L
.70598 .18056 L
.706 .18046 L
.70603 .18021 L
.70606 .17999 L
.70607 .17985 L
Mistroke
.70609 .18014 L
.70611 .18062 L
.70613 .18114 L
.70614 .1816 L
.70616 .18208 L
.70619 .18078 L
.70622 .17794 L
.70625 .17483 L
.70631 .17009 L
.70634 .16824 L
.70636 .16649 L
.70639 .16425 L
.70642 .16179 L
.70645 .15887 L
.70648 .1593 L
.70651 .1627 L
.70654 .16631 L
.70657 .16871 L
.7066 .17022 L
.70666 .17362 L
.70671 .17634 L
.70674 .17768 L
.70677 .17824 L
.70682 .17902 L
.70684 .17943 L
.70687 .17878 L
.7069 .17807 L
.70691 .1777 L
.70693 .1773 L
.70696 .17972 L
.70699 .1828 L
.70701 .18557 L
.70704 .18792 L
.70707 .18827 L
.7071 .1886 L
.70716 .18967 L
.70719 .19038 L
.70721 .19104 L
.70724 .19129 L
.70727 .19129 L
.70729 .19129 L
.70731 .19129 L
.70732 .1913 L
.70734 .19137 L
.70738 .19151 L
.70739 .19157 L
.70741 .19164 L
.70743 .19287 L
.70745 .19561 L
.70748 .20038 L
Mistroke
.70751 .20453 L
.70753 .20538 L
.70754 .20576 L
.70757 .20651 L
.70759 .20691 L
.70761 .20734 L
.70762 .20877 L
.70764 .21013 L
.70767 .21278 L
.70773 .21649 L
.70784 .22293 L
.70796 .23206 L
.70803 .23713 L
.70806 .24026 L
.70809 .24263 L
.70812 .24298 L
.70815 .2433 L
.70817 .24365 L
.70821 .24473 L
.70824 .24599 L
.70825 .24668 L
.70827 .24733 L
.7083 .24744 L
.70832 .24738 L
.70833 .24732 L
.70836 .2472 L
.70839 .24754 L
.70842 .24813 L
.70845 .24867 L
.70847 .24985 L
.7085 .25257 L
.70853 .25548 L
.70855 .25868 L
.70859 .25936 L
.7086 .25901 L
.70862 .25869 L
.70865 .25812 L
.70868 .25887 L
.70869 .25983 L
.70871 .26087 L
.70873 .26179 L
.70875 .26277 L
.70876 .26411 L
.70878 .26613 L
.70881 .26969 L
.70884 .27313 L
.70887 .27535 L
.7089 .27679 L
.70893 .2781 L
.70896 .28077 L
Mistroke
.70899 .28471 L
.70902 .28902 L
.70904 .29138 L
.70905 .29261 L
.70908 .29422 L
.70911 .296 L
.70917 .29938 L
.7093 .30795 L
.70952 .32325 L
.70958 .32536 L
.7096 .32598 L
.70961 .32656 L
.70964 .32614 L
.70966 .32573 L
.70967 .32534 L
.70969 .32493 L
.70971 .32448 L
.70974 .32755 L
.70978 .331 L
.7099 .34051 L
.70996 .3461 L
.70999 .34905 L
.71002 .351 L
.71004 .35167 L
.71005 .35242 L
.71008 .35373 L
.71011 .35557 L
.71014 .35764 L
.71017 .35984 L
.71019 .36105 L
.7102 .36151 L
.71022 .36191 L
.71024 .36236 L
.71025 .36273 L
.71027 .36314 L
.7103 .36242 L
.71033 .36058 L
.71036 .35894 L
.71039 .35746 L
.71042 .35844 L
.71045 .35948 L
.71048 .36051 L
.71051 .36355 L
.71053 .36653 L
.71056 .36978 L
.71059 .37136 L
.71062 .3722 L
.71064 .37302 L
.71067 .37379 L
.7107 .37316 L
Mistroke
.71072 .37256 L
.71075 .37185 L
.71078 .37167 L
.71079 .37186 L
.71081 .37206 L
.71084 .37242 L
.71087 .37221 L
.7109 .37054 L
.71092 .36909 L
.71095 .36753 L
.71098 .36796 L
.71101 .36869 L
.71104 .36955 L
.71106 .36941 L
.71109 .36808 L
.71111 .36738 L
.71113 .36663 L
.71116 .36577 L
.71119 .36577 L
.71122 .36577 L
.71124 .36577 L
.71125 .36634 L
.71128 .36779 L
.7113 .36855 L
.71132 .36937 L
.71135 .36982 L
.71137 .36815 L
.71141 .36626 L
.71144 .36465 L
.71146 .3651 L
.71149 .36557 L
.71152 .36605 L
.71154 .36684 L
.71155 .36792 L
.71167 .37458 L
.71177 .37985 L
.7118 .38151 L
.71183 .38265 L
.71185 .38275 L
.71188 .38286 L
.71191 .38299 L
.71194 .38334 L
.71201 .38413 L
.71206 .38459 L
.71208 .38471 L
.7121 .38485 L
.71213 .38585 L
.71224 .39066 L
.71226 .39217 L
.7123 .39373 L
Mistroke
.71232 .39431 L
.71235 .39484 L
.71242 .39613 L
.71249 .39757 L
.71255 .40176 L
.71256 .4029 L
.71258 .40392 L
.7126 .40246 L
.71261 .40086 L
.71264 .39789 L
.71266 .39626 L
.71268 .39486 L
.71271 .39498 L
.71274 .3951 L
.71277 .39521 L
.71279 .39628 L
.71282 .3977 L
.71285 .3992 L
.71288 .39917 L
.71291 .39783 L
.71294 .39659 L
.71297 .39573 L
.713 .39682 L
.71303 .39798 L
.71306 .39906 L
.71309 .39816 L
.7133 .38835 L
.71354 .37593 L
.7136 .36984 L
.71362 .36808 L
.71364 .36707 L
.71367 .36803 L
.7137 .36909 L
.71372 .36965 L
.71373 .37008 L
.71375 .37027 L
.71377 .37048 L
.7138 .37085 L
.71383 .37168 L
.71384 .37278 L
.71386 .37398 L
.71389 .37613 L
.71392 .37806 L
.71393 .37886 L
.71395 .37961 L
.71398 .38127 L
.71405 .38385 L
.71408 .38487 L
.71411 .38595 L
.71413 .38496 L
Mistroke
.71416 .38362 L
.71419 .38217 L
.71421 .3815 L
.71422 .38181 L
.71425 .38238 L
.71428 .38299 L
.71431 .38341 L
.71434 .38352 L
.71436 .38363 L
.71439 .38373 L
.71442 .38328 L
.71445 .38264 L
.71448 .38208 L
.71451 .38063 L
.71456 .37724 L
.71459 .37534 L
.71461 .37564 L
.71464 .376 L
.71467 .37634 L
.7147 .37603 L
.71472 .37512 L
.71475 .37416 L
.71478 .37357 L
.71481 .3745 L
.71484 .37552 L
.71486 .37605 L
.71487 .37645 L
.71489 .37616 L
.71491 .3759 L
.71494 .37543 L
.71497 .37487 L
.715 .37334 L
.71503 .37165 L
.71508 .36895 L
.71511 .36775 L
.71513 .36709 L
.71514 .36647 L
.71517 .36363 L
.7152 .35899 L
.71523 .35414 L
.71526 .34946 L
.71529 .34783 L
.71531 .34636 L
.71535 .34462 L
.71536 .34259 L
.71538 .34035 L
.71541 .33624 L
.71544 .33184 L
.71546 .33062 L
.71547 .33014 L
Mistroke
.7155 .32919 L
.71552 .32866 L
.71554 .32808 L
.71555 .32693 L
.71557 .32554 L
.7157 .31198 L
.71594 .28579 L
.71619 .26137 L
.71631 .25025 L
.71634 .2465 L
.71637 .24251 L
.7164 .23907 L
.71643 .23865 L
.71654 .23666 L
.71656 .23598 L
.71659 .2353 L
.71662 .23542 L
.71665 .23552 L
.71668 .23563 L
.7167 .23403 L
.71673 .23069 L
.71676 .22753 L
.71678 .22461 L
.71681 .22449 L
.71683 .22439 L
.71686 .22428 L
.71689 .22396 L
.71691 .22313 L
.71694 .22223 L
.71697 .22125 L
.717 .21888 L
.71703 .21619 L
.71706 .21371 L
.71709 .21367 L
.71712 .21449 L
.71715 .21538 L
.71718 .21578 L
.71721 .21578 L
.71723 .21578 L
.71726 .21578 L
.71729 .21372 L
.71732 .2118 L
.71738 .20789 L
.71741 .20637 L
.71743 .20495 L
.71746 .20396 L
.71748 .20403 L
.7175 .2041 L
.71753 .20423 L
.71756 .20403 L
Mistroke
.71759 .20321 L
.71762 .20233 L
.71765 .20187 L
.71768 .20338 L
.7177 .20497 L
.71773 .2067 L
.71775 .20668 L
.71777 .2063 L
.7178 .20554 L
.71783 .20491 L
.71785 .20505 L
.71788 .2057 L
.71791 .2064 L
.71794 .20679 L
.71797 .20556 L
.71799 .20444 L
.71802 .20338 L
.71805 .20285 L
.71808 .2025 L
.71811 .20214 L
.71813 .20256 L
.71814 .20397 L
.71817 .20652 L
.7182 .2089 L
.71823 .21038 L
.71826 .21026 L
.71828 .21019 L
.71829 .21012 L
.71831 .21005 L
.71833 .21057 L
.71839 .21322 L
.71846 .21764 L
.71849 .21987 L
.7185 .22113 L
.71852 .22127 L
.71858 .2217 L
.7186 .22192 L
.71863 .22203 L
.71866 .22215 L
.71869 .22226 L
.71872 .22219 L
.71874 .22212 L
.71875 .22206 L
.71878 .22196 L
.7188 .22164 L
.71883 .221 L
.71886 .22031 L
.71889 .21965 L
.71892 .22113 L
.71894 .22256 L
Mistroke
.71897 .22391 L
.719 .22444 L
.71903 .22421 L
.71906 .22397 L
.71908 .22383 L
.71909 .22331 L
.71915 .22131 L
.71917 .2205 L
.71921 .22259 L
.71927 .22696 L
.71931 .22881 L
.71934 .23056 L
.71937 .23172 L
.71939 .23137 L
.7194 .23104 L
.71943 .23046 L
.71946 .23019 L
.71949 .23174 L
.71952 .23343 L
.71957 .23657 L
.71969 .24652 L
.71991 .26916 L
.72005 .28261 L
.72017 .2952 L
.72028 .30335 L
.72034 .30773 L
.72037 .30959 L
.72039 .31062 L
.72041 .31159 L
.72042 .31203 L
.72044 .3115 L
.72047 .31056 L
.7205 .30959 L
.72053 .30898 L
.72056 .3086 L
.72057 .3084 L
.72059 .30819 L
.72062 .30835 L
.72065 .30905 L
.72068 .30977 L
.72071 .3102 L
.72074 .30973 L
.72077 .30923 L
.72082 .30821 L
.72085 .30756 L
.72088 .30686 L
.72089 .30647 L
.72091 .30688 L
.72094 .30764 L
.72097 .30836 L
Mistroke
.72099 .30876 L
.72101 .30974 L
.72103 .3116 L
.72107 .31357 L
.72109 .31501 L
.72112 .31559 L
.72114 .31591 L
.72115 .31626 L
.72119 .31724 L
.72121 .31892 L
.72122 .32047 L
.72126 .32339 L
.72132 .32988 L
.72135 .33285 L
.72138 .33537 L
.72141 .3361 L
.72144 .33677 L
.72149 .3382 L
.72152 .33904 L
.72155 .33984 L
.72158 .3412 L
.72161 .34303 L
.72164 .34452 L
.72167 .34472 L
.72169 .34299 L
.72172 .3411 L
.72175 .33906 L
.72178 .34023 L
.72181 .34219 L
.72183 .34396 L
.72186 .34494 L
.72188 .34475 L
.7219 .34455 L
.72193 .34418 L
.72196 .34347 L
.72209 .34013 L
.72221 .3372 L
.72224 .33605 L
.72227 .33547 L
.7223 .3349 L
.72233 .33444 L
.72236 .33555 L
.72239 .33675 L
.72245 .33961 L
.72248 .34144 L
.72251 .34315 L
.72253 .34426 L
.72254 .34571 L
.72258 .3488 L
.72261 .3515 L
Mistroke
.72263 .35162 L
.72264 .35111 L
.72267 .35019 L
.7227 .34917 L
.72273 .34893 L
.72276 .34893 L
.72279 .34893 L
.72282 .34882 L
.72284 .34848 L
.72287 .34817 L
.7229 .34783 L
.72293 .34615 L
.72296 .34439 L
.72297 .34346 L
.72299 .34247 L
.72302 .34177 L
.72305 .34144 L
.72308 .34111 L
.7231 .34113 L
.72313 .34192 L
.72316 .34277 L
.72321 .34416 L
.72324 .34472 L
.72326 .34532 L
.72329 .34691 L
.72332 .35049 L
.72335 .35431 L
.72337 .35639 L
.72339 .35797 L
.72342 .3602 L
.72345 .36264 L
.72348 .3646 L
.72351 .36414 L
.72354 .36359 L
.72356 .3633 L
.72358 .36312 L
.72359 .36318 L
.72361 .36326 L
.72363 .36333 L
.72364 .36339 L
.72368 .36387 L
.72369 .36457 L
.72371 .36523 L
.72373 .36589 L
.72374 .36652 L
.72377 .36726 L
.7238 .36715 L
.72383 .36703 L
.72384 .36697 L
.72386 .36694 L
Mistroke
.72389 .36705 L
.72392 .36716 L
.72394 .36727 L
.72397 .36565 L
.724 .36351 L
.72402 .36231 L
.72403 .36103 L
.72405 .3604 L
.72407 .36163 L
.7241 .36401 L
.72413 .36625 L
.72416 .36583 L
.72419 .36404 L
.72421 .36308 L
.72422 .36206 L
.72425 .36248 L
.72428 .36496 L
.7243 .36627 L
.72432 .36766 L
.72435 .36864 L
.72437 .3673 L
.7244 .36609 L
.72443 .3648 L
.72446 .36576 L
.72448 .36698 L
.72451 .36837 L
.72453 .3684 L
.72455 .36741 L
.72461 .36367 L
.72473 .35518 L
.72478 .34733 L
.72481 .3429 L
.72484 .34153 L
.72494 .33656 L
.72497 .33511 L
.725 .33377 L
.72503 .33374 L
.72504 .3338 L
.72506 .33386 L
.72509 .33398 L
.72512 .33464 L
.72514 .33549 L
.72517 .33628 L
.7252 .3368 L
.72523 .33347 L
.72528 .32746 L
.72534 .3213 L
.72537 .3181 L
.72539 .31638 L
.7254 .31595 L
Mistroke
.72543 .31505 L
.72546 .31421 L
.72549 .31472 L
.72552 .3175 L
.72555 .32045 L
.72557 .32194 L
.72559 .32159 L
.72562 .31895 L
.72565 .31649 L
.72609 .28884 L
.72631 .26665 L
.72636 .26005 L
.72639 .25616 L
.72642 .25206 L
.72643 .24988 L
.72645 .25096 L
.72648 .25419 L
.72651 .25745 L
.72654 .25912 L
.72655 .2576 L
.72657 .25595 L
.7266 .25306 L
.72662 .25142 L
.72664 .25136 L
.72665 .2526 L
.72667 .25397 L
.7267 .2564 L
.72672 .25777 L
.72673 .25795 L
.72676 .25698 L
.72679 .25606 L
.72684 .25411 L
.72687 .25292 L
.7269 .25181 L
.72692 .2507 L
.72694 .24836 L
.72697 .24427 L
.72702 .23775 L
.72715 .22694 L
.72719 .22203 L
.7272 .21971 L
.72722 .22055 L
.72726 .22247 L
.72729 .22426 L
.72735 .23147 L
.72737 .23357 L
.72738 .23581 L
.72742 .23334 L
.72744 .2292 L
.72747 .22485 L
Mistroke
.72749 .22264 L
.7275 .22204 L
.72753 .22098 L
.72756 .21991 L
.7276 .21938 L
.72763 .21974 L
.72765 .22006 L
.72768 .22034 L
.72771 .21987 L
.72774 .21942 L
.72776 .219 L
.72779 .22051 L
.72781 .2218 L
.72783 .22319 L
.72785 .22465 L
.72786 .22603 L
.72788 .22618 L
.7279 .22564 L
.72793 .22466 L
.72794 .22412 L
.72796 .22362 L
.72799 .22353 L
.72802 .22364 L
.72805 .22376 L
.72808 .22382 L
.7281 .22382 L
.72813 .22382 L
.72816 .22331 L
.72818 .22139 L
.72819 .21961 L
.72825 .21296 L
.72831 .20835 L
.72833 .20709 L
.72834 .20573 L
.72837 .20825 L
.72841 .21179 L
.72842 .21353 L
.72844 .21515 L
.72847 .21433 L
.7285 .21305 L
.72853 .21194 L
.72856 .21331 L
.72859 .21568 L
.72861 .21786 L
.72872 .22513 L
.72895 .23949 L
.72916 .25099 L
.7294 .26296 L
.72943 .26483 L
.72947 .2667 L
Mistroke
.72948 .26755 L
.7295 .26822 L
.72953 .26834 L
.72956 .26846 L
.72959 .26858 L
.72961 .26735 L
.72962 .26608 L
.72965 .26359 L
.72968 .26128 L
.72971 .26075 L
.72974 .26051 L
.72977 .26026 L
.72979 .26023 L
.7298 .26051 L
.72983 .26101 L
.72989 .26188 L
.73001 .2642 L
.73012 .26691 L
.73019 .2678 L
.73022 .26833 L
.73025 .26881 L
.73028 .26954 L
.73031 .27049 L
.73037 .27249 L
.7304 .2735 L
.73042 .27403 L
.73044 .27459 L
.73045 .27508 L
.73047 .27642 L
.7305 .27879 L
.73061 .28618 L
.73088 .29989 L
.731 .31208 L
.73107 .3175 L
.73114 .32137 L
.73117 .3234 L
.73118 .32447 L
.7312 .32559 L
.73123 .32663 L
.73126 .32641 L
.73129 .32618 L
.73132 .32621 L
.73133 .32682 L
.73135 .32746 L
.73138 .32862 L
.73141 .32929 L
.73144 .32847 L
.73147 .32772 L
.73149 .32701 L
.73152 .32797 L
Mistroke
.73155 .32964 L
.73158 .33151 L
.73161 .33259 L
.73164 .33171 L
.73167 .3309 L
.73168 .33041 L
.7317 .33061 L
.73173 .33211 L
.73176 .33341 L
.73179 .33479 L
.73182 .33776 L
.73185 .34048 L
.73191 .34629 L
.73194 .34976 L
.73197 .35303 L
.73199 .35458 L
.732 .35555 L
.73204 .35724 L
.73205 .35808 L
.73207 .35897 L
.7321 .35956 L
.73213 .3599 L
.73216 .36027 L
.73219 .36041 L
.73221 .36041 L
.73224 .36041 L
.73226 .36041 L
.73228 .36029 L
.73231 .35994 L
.73234 .35956 L
.73245 .35113 L
.73251 .34768 L
.73252 .34681 L
.73254 .34587 L
.73257 .34537 L
.7326 .34581 L
.73263 .34629 L
.73266 .34692 L
.73268 .34808 L
.73278 .35226 L
.73281 .35333 L
.73283 .35389 L
.73284 .3546 L
.73288 .3563 L
.7329 .35786 L
.73293 .35948 L
.73296 .35884 L
.733 .35788 L
.73301 .3574 L
.73303 .35697 L
Mistroke
.73305 .35697 L
.73307 .35697 L
.7331 .35697 L
.73311 .35697 L
.73313 .35672 L
.73315 .35596 L
.73317 .35525 L
.73318 .35464 L
.7332 .35398 L
.73323 .35345 L
.73325 .35403 L
.73327 .35456 L
.73328 .35509 L
.7333 .35558 L
.73333 .35594 L
.73334 .35555 L
.73336 .35515 L
.73339 .35446 L
.73342 .35282 L
.73345 .34913 L
.73348 .34517 L
.73351 .34144 L
.73353 .34256 L
.73356 .34411 L
.73359 .34577 L
.73361 .34626 L
.73363 .34626 L
.73366 .34626 L
.73369 .34626 L
.73371 .34585 L
.73372 .34516 L
.73378 .34258 L
.73424 .32751 L
.73436 .32352 L
.73443 .32102 L
.7345 .31869 L
.73452 .31764 L
.73456 .31651 L
.73457 .31625 L
.73459 .31604 L
.73462 .31566 L
.73465 .31532 L
.73468 .31631 L
.73474 .3185 L
.7348 .32077 L
.73483 .32189 L
.73485 .32253 L
.73486 .32082 L
.73489 .31795 L
.73492 .31493 L
Mistroke
.73495 .3127 L
.73498 .31305 L
.73501 .31343 L
.73503 .31364 L
.73505 .31359 L
.73508 .31309 L
.73511 .31261 L
.73512 .31234 L
.73514 .31217 L
.73516 .3121 L
.73517 .31204 L
.73521 .3119 L
.73523 .31182 L
.73525 .3102 L
.73527 .30763 L
.7353 .30488 L
.73532 .30331 L
.73534 .30292 L
.73537 .30268 L
.73539 .30246 L
.73542 .30193 L
.73545 .2999 L
.73548 .29804 L
.73573 .28399 L
.73668 .24455 L
.73715 .2214 L
.73718 .2223 L
.73721 .22328 L
.73723 .22419 L
.73726 .22231 L
.73731 .21821 L
.73736 .21483 L
.73742 .21207 L
.73748 .20846 L
.73753 .20473 L
.73756 .2018 L
.73759 .19903 L
.73762 .19687 L
.73765 .19768 L
.73768 .19862 L
.73771 .19924 L
.73774 .1988 L
.73777 .19834 L
.73783 .19727 L
.73786 .19673 L
.73789 .19614 L
.73791 .19447 L
.73794 .19206 L
.73797 .18923 L
.73798 .18774 L
Mistroke
.738 .18668 L
.73803 .18656 L
.73806 .18645 L
.73808 .18638 L
.73809 .18623 L
.73812 .18498 L
.73814 .18428 L
.73816 .18353 L
.73818 .18282 L
.7382 .18281 L
.73823 .18406 L
.73826 .18524 L
.73832 .18744 L
.73856 .1969 L
.73948 .22325 L
.74047 .26017 L
.74141 .30226 L
.74232 .34438 L
.74282 .37964 L
.74329 .40316 L
.74334 .4043 L
.7434 .40556 L
.74343 .40628 L
.74344 .40668 L
.74346 .40768 L
.74352 .4115 L
.74355 .41318 L
.74356 .41304 L
.74358 .41292 L
.74361 .41266 L
.74363 .41252 L
.74364 .41216 L
.74367 .41107 L
.74371 .40991 L
.74373 .40901 L
.74376 .40901 L
.74379 .40901 L
.74382 .40901 L
.74385 .40808 L
.74388 .40704 L
.7439 .4059 L
.74394 .40616 L
.74395 .40735 L
.74397 .40862 L
.744 .41091 L
.74403 .41238 L
.74406 .41214 L
.74411 .41169 L
.74414 .41146 L
.74417 .41125 L
Mistroke
.74419 .41106 L
.74422 .41066 L
.74425 .40984 L
.74427 .40907 L
.7443 .40825 L
.74434 .40874 L
.74437 .40921 L
.74439 .40966 L
.74442 .41108 L
.74445 .41302 L
.74446 .41416 L
.74448 .41537 L
.74451 .41625 L
.74453 .41572 L
.74454 .41523 L
.74458 .41411 L
.7447 .40942 L
.74496 .39695 L
.74507 .39042 L
.74513 .38421 L
.74515 .38251 L
.74517 .38108 L
.74518 .38108 L
.7452 .38108 L
.74523 .38108 L
.74525 .38108 L
.74526 .38096 L
.74529 .37953 L
.74532 .37818 L
.74535 .37691 L
.74537 .3761 L
.74541 .37549 L
.74543 .37493 L
.74546 .37484 L
.74549 .37544 L
.74551 .37577 L
.74553 .37613 L
.74556 .37545 L
.74559 .37317 L
.74562 .37074 L
.74565 .36927 L
.74568 .36951 L
.74571 .36972 L
.74573 .36993 L
.74576 .36913 L
.74579 .36815 L
.74581 .3673 L
.74584 .36596 L
.74587 .36196 L
.74589 .35823 L
Mistroke
.74592 .35391 L
.74594 .3523 L
.74595 .35148 L
.74598 .35002 L
.74601 .34842 L
.74604 .34754 L
.74607 .34712 L
.7461 .34664 L
.74612 .34612 L
.74615 .34468 L
.74618 .34314 L
.74621 .34171 L
.74624 .33856 L
.74637 .32811 L
.74661 .3026 L
.74705 .26471 L
.74798 .19928 L
.74801 .19999 L
.74803 .20039 L
.74804 .19991 L
.74807 .19856 L
.7481 .19712 L
.74817 .19423 L
.74823 .19184 L
.74828 .19014 L
.74831 .18918 L
.74834 .1858 L
.74837 .18127 L
.7484 .1765 L
.74843 .17348 L
.74846 .17102 L
.74849 .16847 L
.74852 .16873 L
.74854 .17064 L
.74855 .17272 L
.74858 .1765 L
.74861 .17752 L
.74865 .1744 L
.74867 .17148 L
.7487 .16937 L
.74873 .17227 L
.74877 .17538 L
.74883 .17979 L
.74886 .18171 L
.74888 .18279 L
.7489 .18192 L
.74892 .17952 L
.74893 .17735 L
.74897 .17248 L
.74903 .16515 L
Mistroke
.74906 .16183 L
.74908 .15902 L
.74911 .15776 L
.74914 .15641 L
.74921 .15431 L
.74943 .14757 L
.74949 .14594 L
.74952 .14476 L
.74955 .14365 L
.74957 .14368 L
.74959 .14403 L
.74962 .14476 L
.74964 .1451 L
.74966 .14554 L
.74969 .14738 L
.74974 .15076 L
.7498 .15416 L
.74982 .15516 L
.74984 .1561 L
.74987 .15538 L
.7499 .15409 L
.74991 .15337 L
.74993 .15268 L
.74996 .15379 L
.74999 .15584 L
.75002 .15823 L
.75005 .15977 L
.75007 .16028 L
.7501 .16081 L
.75013 .16135 L
.75016 .15921 L
.75019 .15653 L
.7502 .15507 L
.75022 .15372 L
.75024 .15392 L
.75026 .15575 L
.75029 .15896 L
.75032 .16203 L
.75035 .16206 L
.75036 .16169 L
.75038 .16129 L
.75041 .16055 L
.75044 .16138 L
.75047 .16291 L
.75049 .16384 L
.7505 .16473 L
.75052 .16529 L
.75054 .16536 L
.75057 .16549 L
.75059 .16556 L
Mistroke
.7506 .16562 L
.75062 .16578 L
.75064 .16599 L
.75067 .16639 L
.7507 .16675 L
.75073 .1683 L
.75079 .17142 L
.75091 .17985 L
.75183 .23059 L
.7528 .2799 L
.75373 .345 L
.75473 .39401 L
.75497 .42046 L
.75503 .42611 L
.75506 .42833 L
.75509 .43066 L
.75511 .43173 L
.75513 .43234 L
.75516 .4334 L
.75523 .43623 L
.75534 .44464 L
.75536 .44611 L
.75538 .4477 L
.75541 .449 L
.75544 .44863 L
.75546 .44829 L
.75549 .44821 L
.75552 .44911 L
.75555 .45017 L
.75557 .45113 L
.7556 .4511 L
.75563 .45057 L
.75566 .45 L
.75569 .44997 L
.75572 .4513 L
.75575 .45274 L
.75581 .45603 L
.75592 .46049 L
.75617 .46908 L
.75622 .47343 L
.75628 .47682 L
.75634 .47981 L
.75639 .48233 L
.75642 .48347 L
.75645 .48452 L
.75647 .48498 L
.7565 .48549 L
.75652 .48603 L
.75655 .48636 L
.75658 .48648 L
Mistroke
.75661 .48658 L
.75664 .48672 L
.75666 .48705 L
.7567 .48744 L
.75673 .48779 L
.75675 .49105 L
.75678 .49451 L
.75681 .49815 L
.75684 .49999 L
.75687 .49889 L
.7569 .49773 L
.75696 .49594 L
.75699 .49503 L
.75701 .49451 L
.75703 .4947 L
.75704 .49526 L
.75706 .49587 L
.75709 .49698 L
.75712 .49726 L
.75715 .49561 L
.75718 .49365 L
.7572 .49279 L
.75722 .49238 L
.75725 .49225 L
.75728 .49212 L
.7573 .49205 L
.75732 .49112 L
.75735 .48922 L
.7576 .47746 L
.75762 .47401 L
.75766 .47029 L
.75769 .46728 L
.75771 .46828 L
.75774 .46932 L
.75777 .47045 L
.75779 .47013 L
.75781 .46954 L
.75784 .46837 L
.75786 .46772 L
.75788 .46717 L
.75789 .46717 L
.75791 .46717 L
.75793 .46717 L
.75795 .46717 L
.75796 .46717 L
.75798 .46765 L
.758 .46846 L
.75801 .46919 L
.75803 .46998 L
.75805 .47084 L
Mistroke
.75808 .47115 L
.75811 .4697 L
.75814 .46835 L
.75817 .46706 L
.75818 .46671 L
.7582 .46639 L
.75823 .46577 L
.75826 .46527 L
.75828 .46534 L
.75829 .4654 L
.75833 .46553 L
.75834 .4656 L
.75836 .46496 L
.75859 .45516 L
.75909 .4317 L
.7592 .4243 L
.75926 .41988 L
.75929 .41757 L
.75931 .41599 L
.75934 .41649 L
.75936 .41675 L
.75938 .41703 L
.75941 .41711 L
.75944 .4149 L
.75947 .41282 L
.7595 .41058 L
.75953 .41123 L
.75955 .41188 L
.75958 .41251 L
.75961 .41138 L
.75963 .40877 L
.75966 .40638 L
.75972 .40023 L
.75974 .39739 L
.75977 .39428 L
.7598 .38994 L
.75983 .38419 L
.75989 .37302 L
.76 .35589 L
.76048 .29563 L
.7606 .27082 L
.76074 .25072 L
.7608 .23571 L
.76082 .23135 L
.76083 .22726 L
.76087 .22675 L
.76089 .22631 L
.76092 .22584 L
.76094 .2259 L
.76096 .22623 L
Mistroke
.76098 .22683 L
.76102 .22745 L
.76105 .2263 L
.76107 .22449 L
.7611 .22254 L
.76113 .22195 L
.76115 .22315 L
.76116 .22448 L
.7612 .22682 L
.76122 .22726 L
.76125 .22335 L
.76128 .21922 L
.76133 .2137 L
.76145 .20445 L
.76147 .20059 L
.7615 .19654 L
.76153 .19485 L
.76156 .19328 L
.76159 .19146 L
.7616 .19076 L
.76162 .19036 L
.76168 .18899 L
.76189 .18325 L
.76192 .18181 L
.76195 .18026 L
.76199 .179 L
.76201 .17878 L
.76205 .17851 L
.76206 .17836 L
.76208 .17756 L
.7621 .17589 L
.76211 .17409 L
.76214 .17082 L
.7622 .16596 L
.76227 .16219 L
.76232 .15982 L
.76238 .15786 L
.76262 .14938 L
.76268 .14505 L
.76271 .14189 L
.76274 .13893 L
.76276 .13841 L
.76279 .1383 L
.76282 .13818 L
.76285 .13869 L
.76288 .14054 L
.76291 .14257 L
.76298 .14578 L
.76301 .14744 L
.76303 .14836 L
Mistroke
.76305 .15066 L
.76308 .15547 L
.76311 .1599 L
.76314 .16255 L
.76317 .16402 L
.7632 .16549 L
.76322 .16633 L
.76324 .16517 L
.76335 .15522 L
.76341 .15056 L
.76347 .14368 L
.76349 .14194 L
.7635 .14006 L
.76352 .14023 L
.76354 .14092 L
.76357 .14212 L
.76359 .14276 L
.7636 .14344 L
.76363 .1468 L
.76366 .14996 L
.76368 .15166 L
.7637 .1535 L
.76373 .15492 L
.76376 .15615 L
.76379 .15728 L
.76381 .1589 L
.76384 .1609 L
.76429 .18387 L
.7652 .2476 L
.7657 .28447 L
.76573 .28689 L
.76576 .28977 L
.76579 .29248 L
.76582 .29286 L
.76585 .29173 L
.76587 .29111 L
.76588 .29053 L
.76591 .29225 L
.76594 .29729 L
.76597 .30202 L
.766 .30597 L
.76602 .30735 L
.76605 .30885 L
.7661 .31218 L
.76614 .31442 L
.76616 .31653 L
.76619 .31771 L
.76622 .31687 L
.76625 .31603 L
.76628 .31565 L
Mistroke
.76631 .31829 L
.76634 .32118 L
.76637 .32379 L
.76639 .32497 L
.76641 .32541 L
.76643 .32589 L
.76646 .32673 L
.76647 .32704 L
.76649 .32647 L
.76652 .32544 L
.76655 .32449 L
.76658 .32435 L
.76661 .32496 L
.76664 .32561 L
.76667 .32607 L
.7667 .3263 L
.76673 .32655 L
.76675 .32667 L
.76676 .32725 L
.76679 .32897 L
.76682 .33083 L
.76688 .33427 L
.76698 .3415 L
.76702 .34392 L
.76704 .34621 L
.76707 .34576 L
.7671 .3452 L
.76713 .3446 L
.76716 .34479 L
.76719 .34545 L
.76722 .34616 L
.76724 .34698 L
.76727 .34828 L
.76733 .35064 L
.76739 .35484 L
.76741 .35587 L
.76743 .35696 L
.76746 .35795 L
.76749 .3589 L
.76751 .35979 L
.76753 .35901 L
.76755 .35689 L
.76758 .35319 L
.76761 .34926 L
.76764 .34867 L
.76766 .34907 L
.76767 .34944 L
.76771 .35027 L
.76774 .35056 L
.76775 .35062 L
Mistroke
.76777 .35069 L
.76779 .35077 L
.76781 .35084 L
.76782 .35196 L
.76784 .3533 L
.76791 .35825 L
.76793 .36019 L
.76797 .36231 L
.768 .36434 L
.76802 .365 L
.76805 .36547 L
.76808 .36597 L
.76811 .36593 L
.76813 .36573 L
.76815 .36554 L
.76818 .36516 L
.7682 .3653 L
.76821 .36627 L
.76824 .36799 L
.76827 .36986 L
.7683 .36973 L
.76833 .36784 L
.76836 .36567 L
.7684 .36364 L
.76843 .36229 L
.76846 .36088 L
.76848 .36008 L
.7685 .36151 L
.76853 .36428 L
.76855 .36559 L
.76857 .367 L
.7686 .36777 L
.76863 .3679 L
.76864 .36796 L
.76866 .36802 L
.76868 .3685 L
.76869 .36976 L
.76873 .37198 L
.76876 .37395 L
.76879 .37534 L
.76882 .37654 L
.76885 .37765 L
.76888 .37825 L
.7689 .37845 L
.76891 .37864 L
.76894 .37899 L
.76897 .38016 L
.769 .38189 L
.76902 .38351 L
.76905 .3853 L
Mistroke
.76908 .389 L
.76911 .39268 L
.76913 .39462 L
.76914 .39668 L
.76917 .39725 L
.7692 .39737 L
.76923 .39747 L
.76925 .39689 L
.76928 .39536 L
.76931 .3937 L
.76937 .39051 L
.76941 .38887 L
.76944 .38762 L
.76947 .38784 L
.76949 .38807 L
.76951 .3882 L
.76953 .38833 L
.76956 .38802 L
.76958 .38769 L
.76961 .38738 L
.76964 .38792 L
.76967 .3897 L
.76969 .39121 L
.76972 .39265 L
.76974 .39248 L
.76977 .39198 L
.7698 .39143 L
.76983 .39132 L
.76985 .39221 L
.76988 .39302 L
.76991 .39397 L
.76992 .39398 L
.76994 .39386 L
.76997 .39363 L
.77 .39339 L
.77003 .39297 L
.77006 .39251 L
.77008 .3921 L
.77011 .39137 L
.77014 .3899 L
.77016 .38915 L
.77017 .38834 L
.7702 .38774 L
.77023 .3901 L
.77026 .39252 L
.77029 .39477 L
.77032 .3946 L
.77035 .39375 L
.77037 .393 L
.7704 .39306 L
Mistroke
.77042 .39483 L
.77045 .3965 L
.77048 .39833 L
.77051 .39847 L
.77053 .39834 L
.77054 .3982 L
.77057 .39795 L
.77061 .3972 L
.77063 .39639 L
.77066 .39565 L
.77069 .3955 L
.77071 .39585 L
.77072 .39618 L
.77075 .3968 L
.77077 .39714 L
.77079 .3981 L
.77082 .40025 L
.77085 .40214 L
.77088 .40302 L
.77091 .40326 L
.77093 .40339 L
.77095 .40353 L
.77098 .40407 L
.77099 .40454 L
.77101 .40498 L
.77107 .40716 L
.7711 .41011 L
.77112 .41156 L
.77114 .41291 L
.77117 .41391 L
.77118 .41333 L
.7712 .41272 L
.77126 .41066 L
.77131 .40911 L
.77134 .40825 L
.77136 .40909 L
.77138 .40987 L
.77141 .41124 L
.77144 .4127 L
.77147 .41354 L
.77149 .41425 L
.77152 .41497 L
.77154 .41546 L
.77157 .41512 L
.7716 .41475 L
.77163 .41443 L
.77165 .41436 L
.77168 .41436 L
.77171 .41436 L
.77174 .41368 L
Mistroke
.77176 .41206 L
.77179 .41011 L
.77182 .4083 L
.77185 .40813 L
.77187 .40807 L
.77188 .408 L
.77191 .40788 L
.77193 .40722 L
.77195 .40633 L
.77198 .4044 L
.77201 .40264 L
.77204 .40272 L
.77207 .40294 L
.77213 .40351 L
.77219 .40425 L
.77226 .40483 L
.77228 .40499 L
.7723 .40514 L
.77231 .40509 L
.77233 .40495 L
.77236 .40467 L
.77238 .40454 L
.7724 .40442 L
.77242 .40464 L
.77245 .40489 L
.77247 .40501 L
.77249 .40515 L
.77252 .40397 L
.77255 .40253 L
.77257 .40174 L
.77259 .40099 L
.77262 .40258 L
.77265 .40439 L
.77268 .40596 L
.77271 .40399 L
.77273 .40144 L
.77276 .39865 L
.77279 .39617 L
.77281 .39529 L
.77282 .39449 L
.77288 .39138 L
.77384 .34375 L
.77477 .30788 L
.77575 .27059 L
.7767 .245 L
.77682 .23667 L
.77685 .23449 L
.77687 .23329 L
.77688 .23217 L
.77691 .23224 L
Mistroke
.77693 .23249 L
.77694 .23276 L
.77697 .23321 L
.777 .23273 L
.77702 .23223 L
.77703 .2317 L
.77706 .23074 L
.77709 .23019 L
.77712 .22996 L
.77715 .22976 L
.77718 .22951 L
.7772 .22908 L
.77723 .22867 L
.77725 .22823 L
.77728 .22682 L
.77731 .22478 L
.77734 .22284 L
.77736 .2211 L
.77738 .22376 L
.77741 .22807 L
.77744 .23213 L
.77747 .23383 L
.7775 .2314 L
.77753 .22925 L
.77755 .22699 L
.77758 .2271 L
.77761 .22732 L
.77764 .22755 L
.77767 .22589 L
.7777 .22245 L
.77773 .21919 L
.77775 .21687 L
.77778 .21668 L
.7778 .21646 L
.77783 .21623 L
.77786 .21625 L
.77789 .21636 L
.77791 .21642 L
.77792 .21649 L
.77795 .21736 L
.77798 .21912 L
.77801 .22075 L
.77808 .22552 L
.77814 .23043 L
.77817 .23334 L
.7782 .23641 L
.77823 .23855 L
.77825 .23895 L
.77826 .23932 L
.77829 .24002 L
Mistroke
.77832 .24062 L
.77834 .2403 L
.77835 .23994 L
.77839 .23931 L
.7784 .23896 L
.77842 .23927 L
.77844 .24049 L
.77846 .24158 L
.77849 .24367 L
.7785 .24477 L
.77852 .24556 L
.77855 .24656 L
.77858 .24747 L
.77883 .26433 L
.77895 .27404 L
.77897 .27659 L
.779 .27892 L
.77903 .28086 L
.77906 .28267 L
.77909 .28423 L
.77911 .28371 L
.77913 .28325 L
.77916 .28275 L
.77919 .28249 L
.77921 .28299 L
.77927 .28412 L
.7793 .28497 L
.77933 .28598 L
.77936 .28695 L
.77939 .28677 L
.77941 .28587 L
.77944 .28488 L
.77947 .28388 L
.77949 .28378 L
.77952 .28366 L
.77955 .28353 L
.77958 .28415 L
.77961 .28493 L
.77964 .28568 L
.77966 .28672 L
.77969 .28863 L
.77972 .29074 L
.77975 .29288 L
.77978 .29353 L
.77984 .29443 L
.7799 .2954 L
.77991 .29566 L
.77993 .29595 L
.77995 .29578 L
.77996 .29475 L
Mistroke
.77999 .29261 L
.78001 .29144 L
.78003 .29035 L
.78006 .2897 L
.78009 .28982 L
.78011 .28989 L
.78012 .28996 L
.78015 .29149 L
.78017 .29287 L
.78019 .29416 L
.78022 .29707 L
.78025 .29942 L
.78028 .30195 L
.78031 .30434 L
.78034 .30507 L
.78036 .30482 L
.78037 .30455 L
.78039 .30429 L
.78041 .30401 L
.78044 .30584 L
.78047 .30931 L
.78048 .31116 L
.7805 .31315 L
.78053 .31551 L
.78056 .31613 L
.78059 .31682 L
.78065 .3181 L
.78067 .31848 L
.78068 .31887 L
.78071 .31906 L
.78073 .31745 L
.78075 .31593 L
.78078 .31308 L
.7808 .31151 L
.78081 .31132 L
.78083 .31176 L
.78085 .31221 L
.78088 .31292 L
.78091 .31424 L
.78093 .31546 L
.78095 .31656 L
.78098 .31873 L
.78123 .33539 L
.78135 .34175 L
.78141 .34456 L
.78143 .34598 L
.78146 .34753 L
.78149 .34829 L
.78152 .34852 L
.78155 .34876 L
Mistroke
.78158 .34873 L
.7816 .34797 L
.78163 .34727 L
.78166 .34647 L
.78168 .34803 L
.78171 .35065 L
.78174 .35347 L
.78177 .35534 L
.7818 .35597 L
.78182 .35663 L
.78185 .35736 L
.78187 .35831 L
.78189 .35919 L
.78192 .36093 L
.78195 .36271 L
.78198 .36065 L
.78201 .35842 L
.78203 .35725 L
.78204 .35601 L
.78207 .35797 L
.7821 .36013 L
.78213 .36235 L
.78216 .36323 L
.78219 .36347 L
.7822 .3636 L
.78222 .36374 L
.78225 .3631 L
.78228 .36171 L
.78232 .36007 L
.78233 .35934 L
.78235 .36162 L
.78239 .36566 L
.78242 .36943 L
.78244 .36957 L
.78247 .36746 L
.7825 .36532 L
.78252 .36419 L
.78253 .36348 L
.78255 .36292 L
.78257 .3624 L
.7826 .36138 L
.78263 .3608 L
.78266 .3608 L
.78269 .3608 L
.78271 .36074 L
.78275 .35757 L
.78277 .35457 L
.7828 .35198 L
.78283 .35079 L
.78285 .35067 L
Mistroke
.78288 .35056 L
.7829 .35049 L
.78292 .35136 L
.78295 .35408 L
.78302 .35969 L
.78305 .36135 L
.78307 .36226 L
.78308 .36313 L
.7831 .36399 L
.78312 .36561 L
.78314 .36843 L
.78317 .37119 L
.7832 .373 L
.78323 .37289 L
.78326 .37278 L
.78329 .37268 L
.78331 .37296 L
.78332 .37321 L
.78335 .37371 L
.78338 .37418 L
.78341 .37509 L
.78344 .37608 L
.78347 .37699 L
.7835 .37725 L
.78353 .37725 L
.78356 .37725 L
.78357 .37725 L
.78359 .37878 L
.78362 .38203 L
.78365 .38507 L
.78368 .38773 L
.78371 .38831 L
.78373 .38884 L
.78378 .39007 L
.78381 .39092 L
.78384 .39181 L
.78387 .39237 L
.7839 .39169 L
.78392 .39105 L
.78395 .39036 L
.78398 .38819 L
.78401 .38598 L
.78403 .38463 L
.78405 .38335 L
.78408 .38267 L
.78411 .38229 L
.78413 .38209 L
.78414 .3819 L
.78417 .38522 L
.7842 .38969 L
Mistroke
.78422 .39218 L
.78424 .39455 L
.78427 .39571 L
.78428 .39578 L
.7843 .39584 L
.78432 .39591 L
.78434 .39599 L
.78437 .39902 L
.7844 .40256 L
.78443 .40587 L
.78446 .40746 L
.78449 .40905 L
.78451 .40986 L
.78453 .41074 L
.78454 .41119 L
.78456 .4115 L
.78459 .41212 L
.78462 .41266 L
.78465 .41299 L
.78468 .41324 L
.78471 .41348 L
.78474 .41508 L
.78475 .41647 L
.78477 .41799 L
.7848 .42067 L
.78483 .42207 L
.78486 .42218 L
.78489 .42231 L
.78492 .42271 L
.78494 .42442 L
.78497 .42644 L
.785 .42833 L
.78503 .42824 L
.78504 .42774 L
.78506 .4272 L
.78509 .42632 L
.78512 .4259 L
.78515 .42602 L
.78517 .42612 L
.7852 .42625 L
.78522 .42691 L
.78525 .42763 L
.78528 .4284 L
.78531 .4286 L
.78533 .42783 L
.78539 .42607 L
.78552 .42331 L
.78574 .41781 L
.78624 .40108 L
.78672 .3879 L
Mistroke
.78673 .38669 L
.78675 .38629 L
.78678 .38556 L
.7868 .38512 L
.78682 .38472 L
.78683 .38443 L
.78685 .38423 L
.78688 .38384 L
.78691 .38347 L
.78694 .38281 L
.78697 .38197 L
.78699 .3815 L
.787 .38107 L
.78702 .3804 L
.78704 .37863 L
.78707 .3755 L
.7871 .37254 L
.78711 .37104 L
.78713 .37045 L
.78716 .36941 L
.78718 .36883 L
.7872 .3682 L
.78722 .36797 L
.78724 .36782 L
.78727 .36757 L
.78728 .36743 L
.7873 .36731 L
.78733 .36354 L
.78736 .35934 L
.78738 .35698 L
.78739 .35475 L
.78742 .3532 L
.78746 .35185 L
.78748 .35112 L
.78749 .35041 L
.78752 .34845 L
.78755 .3463 L
.78761 .34096 L
.78773 .33222 L
.78819 .28863 L
.78913 .20398 L
.78924 .19134 L
.78937 .18022 L
.78939 .17843 L
.78941 .17685 L
.78943 .17604 L
.78944 .1753 L
.78947 .17393 L
.78949 .17315 L
.78951 .17293 L
Mistroke
.78954 .17293 L
.78957 .17293 L
.78959 .17293 L
.7896 .17242 L
.78964 .17117 L
.78969 .16884 L
.78975 .16666 L
.78978 .16557 L
.7898 .1651 L
.78982 .16497 L
.78984 .16484 L
.78987 .1646 L
.78988 .16463 L
.7899 .16503 L
.78993 .16575 L
.78995 .1662 L
.78997 .16661 L
.78998 .16659 L
.79 .16612 L
.79003 .16526 L
.79004 .16479 L
.79006 .16436 L
.79009 .16242 L
.79012 .15974 L
.79015 .15707 L
.79016 .15572 L
.79018 .15604 L
.79021 .15664 L
.79024 .1572 L
.79025 .15751 L
.79027 .1574 L
.79029 .15706 L
.79031 .1567 L
.79032 .15638 L
.79034 .15604 L
.79037 .15587 L
.79061 .15463 L
.79063 .15519 L
.79066 .15504 L
.79069 .1547 L
.79072 .15439 L
.79075 .15321 L
.79078 .15089 L
.79081 .14835 L
.79082 .14696 L
.79084 .14624 L
.79087 .14667 L
.79089 .14707 L
.79091 .14745 L
.79094 .14822 L
Mistroke
.79099 .15078 L
.79102 .15224 L
.79105 .15226 L
.79108 .15226 L
.7911 .15226 L
.79111 .15226 L
.79113 .15416 L
.79115 .15678 L
.79118 .16168 L
.79121 .16632 L
.79124 .16812 L
.79127 .16909 L
.7913 .17017 L
.79156 .1836 L
.79205 .20387 L
.79208 .20634 L
.79211 .20693 L
.79213 .20726 L
.79214 .20761 L
.79218 .208 L
.7922 .20728 L
.79224 .20652 L
.79226 .20587 L
.79229 .20561 L
.79232 .20536 L
.79234 .20522 L
.79236 .20509 L
.79239 .20662 L
.79242 .20822 L
.79245 .20997 L
.79247 .21069 L
.79248 .21113 L
.79252 .21214 L
.79253 .21259 L
.79255 .21308 L
.79258 .21512 L
.79261 .21731 L
.79267 .22096 L
.79279 .2288 L
.79301 .2441 L
.79394 .31652 L
.79418 .32861 L
.7943 .33735 L
.79433 .33966 L
.79436 .34215 L
.79439 .34369 L
.79441 .34391 L
.79443 .34404 L
.79445 .34417 L
.79447 .34469 L
Mistroke
.79451 .34606 L
.79454 .34756 L
.79456 .34835 L
.79457 .34774 L
.79459 .34646 L
.79461 .34524 L
.79464 .34308 L
.79466 .34223 L
.79468 .34328 L
.79492 .35514 L
.79515 .35959 L
.79519 .35945 L
.7952 .35939 L
.79522 .35931 L
.79524 .35947 L
.79525 .36032 L
.79529 .36182 L
.79532 .36326 L
.79533 .36426 L
.79535 .36562 L
.79541 .37078 L
.79551 .38506 L
.79557 .39129 L
.7956 .39409 L
.79562 .39549 L
.79566 .39512 L
.79567 .39493 L
.79569 .39472 L
.79572 .39503 L
.79575 .39714 L
.79578 .39925 L
.79581 .40143 L
.79584 .40439 L
.79586 .40762 L
.79589 .41073 L
.79592 .41236 L
.79595 .41325 L
.79597 .41405 L
.796 .41468 L
.79602 .41455 L
.79604 .41443 L
.79606 .4142 L
.79609 .41412 L
.79612 .41628 L
.79615 .41859 L
.79617 .42058 L
.7962 .42216 L
.79623 .42264 L
.79625 .4231 L
.79628 .42355 L
Mistroke
.79631 .42478 L
.79636 .42729 L
.79639 .42842 L
.79642 .42906 L
.79648 .43054 L
.79651 .43126 L
.79653 .43192 L
.79656 .43258 L
.79659 .43228 L
.79661 .43195 L
.79662 .43164 L
.79665 .43105 L
.79668 .43158 L
.79671 .43272 L
.79678 .43542 L
.79689 .44067 L
.79692 .4421 L
.79695 .44343 L
.79698 .44221 L
.79701 .44089 L
.79704 .43961 L
.79706 .43965 L
.79709 .44038 L
.79712 .44106 L
.79715 .44148 L
.79717 .44128 L
.7972 .44105 L
.79723 .44084 L
.79726 .44129 L
.79729 .44215 L
.79734 .44367 L
.79747 .44717 L
.7975 .44827 L
.79751 .44882 L
.79753 .44904 L
.79755 .44868 L
.79757 .44834 L
.7976 .44769 L
.79763 .44692 L
.79766 .4459 L
.79772 .44378 L
.79818 .42355 L
.79868 .39352 L
.79915 .37236 L
.79921 .37103 L
.79923 .37068 L
.79925 .37018 L
.79927 .36921 L
.79929 .36815 L
.79941 .36046 L
Mistroke
.79947 .35713 L
.79951 .35541 L
.79954 .35407 L
.79957 .35605 L
.7996 .3582 L
.79963 .36015 L
.79965 .35822 L
.79968 .3555 L
.79971 .35263 L
.79974 .35189 L
.79976 .35356 L
.79979 .35537 L
.79981 .35636 L
.79983 .35677 L
.79986 .35568 L
.79988 .35469 L
.79991 .35374 L
.79994 .35423 L
.79996 .35499 L
.79999 .35583 L
.80002 .35697 L
.80005 .35939 L
.80007 .36151 L
.8001 .36377 L
.80012 .36447 L
.80013 .36478 L
.80016 .36539 L
.80018 .36574 L
.8002 .36611 L
.80022 .36487 L
.80023 .36351 L
.80029 .35845 L
.80033 .35633 L
.80036 .35414 L
.80039 .35214 L
.80042 .35179 L
.80045 .35156 L
.80047 .35134 L
.8005 .35286 L
.80053 .35564 L
.80056 .35868 L
.80058 .36022 L
.8006 .35931 L
.8011 .31902 L
.80113 .31976 L
.80116 .32056 L
.80118 .31963 L
.80121 .31864 L
.80124 .31747 L
.80127 .31547 L
Mistroke
.80129 .31298 L
.80132 .31025 L
.80145 .30016 L
.80148 .29778 L
.80151 .29552 L
.80153 .2935 L
.80156 .2927 L
.80159 .29224 L
.80162 .29176 L
.80165 .29223 L
.80168 .29384 L
.80171 .29552 L
.80172 .29647 L
.80174 .29667 L
.80177 .29587 L
.8018 .29502 L
.80202 .28742 L
.80207 .2842 L
.8021 .28252 L
.80214 .28153 L
.80216 .28098 L
.80219 .28036 L
.80222 .27965 L
.80225 .27882 L
.80228 .2778 L
.80231 .27689 L
.80233 .27656 L
.80234 .27619 L
.80238 .27555 L
.80244 .27464 L
.80247 .27428 L
.80249 .27396 L
.80252 .27214 L
.80256 .27007 L
.80258 .26825 L
.80261 .26865 L
.80264 .26963 L
.80267 .27053 L
.80269 .27091 L
.80272 .26949 L
.80275 .26798 L
.80277 .26713 L
.80279 .26731 L
.80282 .27009 L
.80285 .27305 L
.80288 .27542 L
.80291 .27489 L
.80294 .2743 L
.80295 .27399 L
.80297 .27366 L
Mistroke
.803 .27438 L
.80302 .27531 L
.80305 .27638 L
.80308 .27669 L
.8031 .27589 L
.80313 .27503 L
.80316 .27421 L
.80318 .27479 L
.80321 .27633 L
.80323 .27776 L
.80326 .27922 L
.80329 .27608 L
.80332 .27279 L
.80335 .26967 L
.80338 .2704 L
.80341 .27169 L
.80347 .27441 L
.8035 .27583 L
.80352 .27661 L
.80354 .27734 L
.80357 .27801 L
.80358 .2782 L
.8036 .2784 L
.80363 .27877 L
.80366 .27867 L
.80369 .27821 L
.80371 .27778 L
.80374 .27736 L
.80377 .27724 L
.8038 .27714 L
.80382 .27703 L
.80385 .27936 L
.80388 .28235 L
.80391 .28572 L
.80393 .28733 L
.80395 .28733 L
.80398 .28733 L
.804 .28733 L
.80402 .28733 L
.80405 .28713 L
.80408 .28686 L
.80411 .28661 L
.80413 .28675 L
.80415 .28708 L
.80418 .28768 L
.80421 .28826 L
.80422 .28879 L
.80424 .28992 L
.80427 .29189 L
.8043 .29377 L
Mistroke
.80433 .29482 L
.80436 .29514 L
.80439 .29549 L
.80442 .29572 L
.80445 .29559 L
.80448 .29547 L
.8045 .29545 L
.80453 .29753 L
.80456 .2995 L
.80459 .30162 L
.80461 .30064 L
.80463 .29922 L
.80465 .29703 L
.80468 .29469 L
.80471 .29412 L
.80474 .29532 L
.80477 .29666 L
.8048 .29761 L
.80482 .2974 L
.80485 .29718 L
.80487 .29704 L
.80488 .2969 L
.8049 .29741 L
.80492 .2979 L
.80495 .29889 L
.80498 .29981 L
.80501 .304 L
.80504 .30918 L
.80506 .31175 L
.80508 .31452 L
.80509 .31578 L
.80511 .31694 L
.80514 .31907 L
.80517 .32133 L
.8052 .32221 L
.80523 .32314 L
.80526 .32413 L
.80528 .32402 L
.80529 .32313 L
.80532 .32141 L
.80535 .31978 L
.80538 .32032 L
.80541 .32268 L
.80544 .32464 L
.80547 .32631 L
.8055 .32607 L
.80551 .32594 L
.80553 .32581 L
.80556 .32565 L
.80559 .3261 L
Mistroke
.80562 .32654 L
.80565 .32703 L
.80568 .32768 L
.8057 .32832 L
.80575 .32957 L
.80581 .33132 L
.80584 .33231 L
.80587 .33413 L
.80589 .3362 L
.80592 .33813 L
.80595 .33947 L
.80597 .33959 L
.80598 .33972 L
.806 .33986 L
.80602 .33999 L
.80605 .34139 L
.8063 .35259 L
.80654 .36671 L
.80678 .38525 L
.80702 .39957 L
.80712 .40812 L
.80714 .40989 L
.80717 .41179 L
.8072 .41266 L
.80723 .41297 L
.80726 .41331 L
.80729 .4134 L
.80732 .41258 L
.80734 .41182 L
.80737 .4111 L
.8074 .41231 L
.80743 .41419 L
.80745 .41594 L
.8077 .43129 L
.80791 .44264 L
.80794 .44521 L
.80795 .44629 L
.80797 .44672 L
.808 .44749 L
.80803 .44834 L
.80805 .44859 L
.80808 .44808 L
.80811 .4475 L
.80814 .44697 L
.80816 .4499 L
.80819 .45364 L
.80822 .45714 L
.80825 .45875 L
.80828 .45875 L
.8083 .45875 L
Mistroke
.80831 .45875 L
.80834 .45931 L
.80837 .46103 L
.80843 .46451 L
.80847 .46643 L
.80849 .46737 L
.8085 .46825 L
.80853 .46939 L
.80855 .46927 L
.80856 .46913 L
.80862 .46874 L
.80865 .46919 L
.80868 .46967 L
.80871 .47013 L
.80873 .46919 L
.80876 .46768 L
.80879 .46624 L
.80882 .46525 L
.80884 .46525 L
.80885 .46525 L
.80888 .46525 L
.8089 .46525 L
.80893 .46515 L
.80896 .46505 L
.80898 .46494 L
.80901 .46518 L
.80904 .46579 L
.80907 .46644 L
.80908 .46685 L
.8091 .46716 L
.80913 .46704 L
.80914 .46697 L
.80916 .4669 L
.80918 .46684 L
.80919 .4667 L
.80922 .46575 L
.80925 .46487 L
.80931 .46257 L
.80935 .46104 L
.80937 .46028 L
.80938 .45959 L
.80941 .45962 L
.80943 .45969 L
.80944 .45975 L
.80946 .45982 L
.80948 .45989 L
.80949 .4596 L
.80951 .45929 L
.80954 .45858 L
.80956 .45822 L
Mistroke
.80958 .45853 L
.80961 .46066 L
.80964 .46298 L
.80967 .46463 L
.8097 .46305 L
.80974 .4612 L
.80975 .46019 L
.80977 .45969 L
.8098 .46075 L
.80983 .46192 L
.81007 .47086 L
.81012 .47504 L
.81014 .47624 L
.81016 .4767 L
.81019 .47658 L
.81022 .47645 L
.81024 .47638 L
.81025 .47639 L
.81028 .47651 L
.8103 .47658 L
.81032 .47664 L
.81034 .47644 L
.81037 .47499 L
.8104 .47363 L
.81043 .47237 L
.81046 .47296 L
.81048 .47348 L
.81049 .47402 L
.81052 .47494 L
.81055 .47492 L
.81058 .47458 L
.81061 .47422 L
.81064 .47379 L
.81066 .47312 L
.81069 .47241 L
.81071 .47201 L
.81072 .47144 L
.81076 .46952 L
.81078 .46776 L
.81081 .466 L
.81084 .46187 L
.81087 .45633 L
.81089 .45127 L
.81092 .44813 L
.81094 .44842 L
.81097 .44876 L
.811 .44907 L
.81103 .44963 L
.81105 .45025 L
.81108 .45091 L
Mistroke
.81111 .45109 L
.81114 .4491 L
.81117 .44699 L
.8112 .44538 L
.81123 .44562 L
.81126 .44588 L
.81129 .44612 L
.81131 .44502 L
.81133 .44379 L
.81136 .44164 L
.81139 .43963 L
.8114 .44012 L
.81142 .44066 L
.81145 .44154 L
.81148 .4425 L
.81151 .44201 L
.81154 .44122 L
.81156 .44045 L
.81159 .43855 L
.81162 .43384 L
.81165 .42956 L
.81168 .42493 L
.81171 .42338 L
.81192 .41274 L
.81216 .40275 L
.81222 .40051 L
.81224 .39987 L
.81225 .39906 L
.81228 .39666 L
.8124 .38805 L
.81243 .38618 L
.81246 .38324 L
.81248 .37968 L
.81251 .37574 L
.81254 .37271 L
.81256 .37121 L
.81262 .36782 L
.81267 .36504 L
.8127 .36369 L
.81273 .36188 L
.81276 .35345 L
.81279 .34561 L
.8128 .34099 L
.81282 .33663 L
.81285 .33386 L
.81288 .33159 L
.81291 .32943 L
.81292 .32872 L
.81294 .32893 L
.81297 .32928 L
Mistroke
.813 .32962 L
.81303 .32783 L
.81306 .32417 L
.81308 .32086 L
.81314 .31045 L
.81317 .3048 L
.8132 .29883 L
.81321 .2973 L
.81323 .29621 L
.81326 .2943 L
.81328 .29323 L
.8133 .29207 L
.81331 .2891 L
.81333 .28612 L
.81377 .20412 L
.81383 .19931 L
.81386 .19686 L
.81389 .19312 L
.81394 .18386 L
.81399 .1738 L
.81411 .1511 L
.81417 .13945 L
.81423 .12536 L
.81426 .11904 L
.81429 .11642 L
.81436 .11043 L
.81442 .10286 L
.81445 .09921 L
.81449 .09645 L
.81452 .09411 L
.81454 .09279 L
.81455 .09252 L
.81458 .09241 L
.81461 .09228 L
.81465 .09134 L
.81467 .08839 L
.8147 .08551 L
.81473 .08286 L
.81476 .08143 L
.81479 .08001 L
.81484 .0769 L
.8149 .07154 L
.81491 .07008 L
.81493 .06936 L
.81496 .06985 L
.81498 .0701 L
.81499 .07037 L
.81502 .07112 L
.81505 .07302 L
.81508 .07477 L
Mistroke
.81511 .07664 L
.81513 .07709 L
.81514 .07734 L
.81517 .07784 L
.81519 .0781 L
.81521 .07838 L
.81524 .0807 L
.81526 .08301 L
.81532 .0873 L
.81542 .09461 L
.81545 .09772 L
.81547 .09935 L
.81548 .10108 L
.81551 .10259 L
.81554 .1027 L
.81557 .1028 L
.81559 .10292 L
.81562 .10363 L
.81565 .10429 L
.81568 .10499 L
.8157 .10491 L
.81571 .10435 L
.81575 .10311 L
.81578 .10198 L
.8158 .10467 L
.81583 .10862 L
.81589 .1168 L
.81593 .12089 L
.81594 .12314 L
.81596 .12526 L
.81598 .12698 L
.81599 .12672 L
.81602 .12625 L
.81604 .12596 L
.81606 .12568 L
.81607 .12591 L
.81609 .12755 L
.81613 .13023 L
.81614 .13165 L
.81616 .13316 L
.81618 .13331 L
.81619 .13306 L
.81622 .13258 L
.81625 .13209 L
.81628 .13366 L
.81631 .13565 L
.81634 .13774 L
.81637 .13889 L
.81639 .13789 L
.81642 .13682 L
Mistroke
.81644 .13622 L
.81646 .13633 L
.81649 .14023 L
.81651 .14392 L
.81653 .14601 L
.81655 .14822 L
.81658 .14912 L
.81664 .15077 L
.81667 .15158 L
.8167 .15246 L
.81673 .1533 L
.81676 .15768 L
.81679 .16249 L
.81682 .16771 L
.81684 .17138 L
.81687 .17309 L
.81693 .17724 L
.81699 .18015 L
.81702 .18166 L
.81703 .18217 L
.81705 .1823 L
.81708 .18254 L
.8171 .18267 L
.81711 .18281 L
.81714 .18384 L
.81717 .18505 L
.81722 .18749 L
.81732 .19167 L
.81755 .20423 L
.81778 .22193 L
.81784 .22517 L
.81787 .22725 L
.8179 .22846 L
.81791 .22852 L
.81793 .22859 L
.81796 .22872 L
.818 .23008 L
.81803 .23278 L
.81807 .23724 L
.81813 .24068 L
.81816 .24259 L
.81818 .24336 L
.81821 .24238 L
.81824 .24146 L
.81826 .2405 L
.81829 .24185 L
.81832 .24378 L
.81834 .24552 L
.81837 .24697 L
.8184 .24598 L
Mistroke
.81843 .24505 L
.81846 .24418 L
.81849 .24849 L
.81851 .25373 L
.81854 .25905 L
.81856 .26153 L
.81858 .26233 L
.81861 .26408 L
.81864 .26573 L
.8187 .2688 L
.81873 .27008 L
.81875 .27173 L
.81878 .27524 L
.81881 .27854 L
.81892 .29346 L
.81898 .29908 L
.81902 .30174 L
.81905 .30355 L
.81907 .30417 L
.81908 .30476 L
.81912 .30605 L
.81915 .30755 L
.81918 .30941 L
.81921 .31101 L
.81925 .31148 L
.81926 .31116 L
.81928 .31081 L
.81931 .31019 L
.81934 .31124 L
.81937 .31358 L
.8194 .31586 L
.81942 .31766 L
.81945 .31826 L
.81949 .31891 L
.81955 .32045 L
.81957 .32133 L
.8196 .32216 L
.81963 .32192 L
.81966 .32075 L
.81967 .32013 L
.81969 .31947 L
.81972 .31875 L
.81975 .31887 L
.81977 .31898 L
.8198 .31908 L
.81982 .31902 L
.81984 .31895 L
.81987 .31883 L
.81989 .31875 L
.8199 .31895 L
Mistroke
.81993 .32048 L
.81996 .32211 L
.82001 .32462 L
.82013 .32873 L
.82023 .33512 L
.82026 .33727 L
.82029 .33887 L
.82032 .33839 L
.82034 .33795 L
.82036 .33768 L
.82038 .3376 L
.8204 .33821 L
.82041 .33877 L
.82044 .33982 L
.82046 .34037 L
.82047 .34089 L
.8205 .34077 L
.82053 .34066 L
.82055 .3406 L
.82056 .34053 L
.82059 .33982 L
.82062 .33893 L
.82064 .33844 L
.82066 .33798 L
.82067 .33817 L
.82069 .33871 L
.82072 .33964 L
.82074 .34023 L
.82075 .34077 L
.82077 .34068 L
.82079 .34037 L
.82086 .33914 L
.82092 .33639 L
.82098 .33363 L
.82101 .33248 L
.82104 .33127 L
.82107 .33235 L
.82109 .33411 L
.82112 .33631 L
.82114 .33743 L
.82116 .33702 L
.82119 .3363 L
.82121 .33591 L
.82122 .3355 L
.82125 .33585 L
.82128 .33708 L
.82131 .33846 L
.82134 .33933 L
.82137 .33921 L
.82139 .33915 L
Mistroke
.8214 .33908 L
.82144 .3387 L
.82145 .33804 L
.82147 .33734 L
.8215 .33626 L
.82153 .33526 L
.82154 .33626 L
.82156 .33718 L
.82159 .33896 L
.8216 .33996 L
.82162 .34084 L
.82165 .33996 L
.82169 .33892 L
.82171 .33842 L
.82172 .33769 L
.82175 .33602 L
.82179 .33423 L
.8218 .33329 L
.82182 .33387 L
.82184 .33552 L
.82185 .33704 L
.82188 .3397 L
.82191 .34187 L
.82194 .34097 L
.82196 .34014 L
.82199 .33922 L
.82202 .33899 L
.82204 .33899 L
.82206 .33899 L
.82209 .33899 L
.8221 .34008 L
.82212 .34219 L
.82216 .34695 L
.82219 .35115 L
.8222 .35181 L
.82222 .35147 L
.82234 .34949 L
.82237 .34914 L
.8224 .34861 L
.82243 .34779 L
.82246 .34704 L
.82248 .34666 L
.82249 .34832 L
.82252 .35159 L
.82255 .35474 L
.82258 .35742 L
.82261 .35925 L
.82264 .36125 L
.82267 .36321 L
.8227 .36401 L
Mistroke
.82273 .36459 L
.82275 .36513 L
.82278 .36466 L
.8228 .36296 L
.82284 .36095 L
.82285 .35989 L
.82287 .35896 L
.8229 .35768 L
.82293 .35651 L
.82296 .35553 L
.82298 .35595 L
.82299 .35633 L
.82303 .35715 L
.82305 .35761 L
.82306 .35701 L
.82312 .35343 L
.82314 .35245 L
.82316 .35196 L
.82319 .35183 L
.82322 .35172 L
.82324 .35166 L
.82328 .35318 L
.82331 .35461 L
.82332 .35541 L
.82334 .35616 L
.82337 .3562 L
.8234 .3562 L
.82341 .3562 L
.82343 .3562 L
.82346 .35642 L
.82349 .35667 L
.82352 .3569 L
.82355 .35629 L
.82358 .35516 L
.82361 .35393 L
.82365 .3531 L
.82368 .3525 L
.8237 .35214 L
.82371 .3518 L
.82373 .35203 L
.82375 .35303 L
.82381 .35643 L
.82384 .35839 L
.82388 .36058 L
.82391 .36265 L
.82394 .36169 L
.82396 .35989 L
.82399 .35826 L
.82405 .35505 L
.82408 .3535 L
Mistroke
.82409 .35265 L
.82411 .35224 L
.82413 .35384 L
.82414 .3556 L
.82418 .3587 L
.82421 .36096 L
.82423 .35973 L
.8243 .35697 L
.82441 .35088 L
.82444 .34979 L
.82448 .3486 L
.82451 .34703 L
.82454 .34532 L
.82456 .34373 L
.82459 .34259 L
.82461 .34392 L
.82464 .34538 L
.82467 .3469 L
.8247 .34646 L
.82473 .34473 L
.82476 .3431 L
.82482 .33791 L
.82485 .33497 L
.82487 .33245 L
.8249 .332 L
.82493 .33151 L
.82495 .33126 L
.82496 .33098 L
.82499 .33107 L
.82503 .33121 L
.82505 .33128 L
.82506 .33133 L
.82508 .33133 L
.8251 .33133 L
.82513 .33133 L
.82516 .33117 L
.82518 .33067 L
.82519 .33011 L
.82525 .32811 L
.82531 .32406 L
.82534 .32202 L
.82537 .32247 L
.82539 .32325 L
.8254 .32409 L
.82544 .32561 L
.82547 .32339 L
.8255 .32027 L
.82552 .31748 L
.82555 .31565 L
.82558 .31565 L
Mistroke
.82561 .31565 L
.82564 .31568 L
.82567 .31592 L
.82572 .31636 L
.82576 .31662 L
.82579 .31689 L
.82582 .31712 L
.82585 .319 L
.82588 .32146 L
.8259 .32282 L
.82592 .32407 L
.82594 .3242 L
.82596 .32435 L
.82599 .3246 L
.82602 .32483 L
.82605 .32686 L
.82608 .32884 L
.82609 .32988 L
.82611 .33095 L
.82614 .33057 L
.82617 .33023 L
.8262 .32991 L
.82623 .32851 L
.82674 .30396 L
.8272 .28262 L
.82731 .27315 L
.82737 .26966 L
.82743 .26616 L
.82746 .26463 L
.8275 .26337 L
.82751 .26276 L
.82753 .26218 L
.82756 .2619 L
.82759 .26226 L
.82762 .26259 L
.82765 .26134 L
.82767 .2586 L
.82768 .25613 L
.82771 .25158 L
.82774 .24742 L
.82776 .24487 L
.82779 .24208 L
.82782 .23925 L
.82784 .23823 L
.82786 .23754 L
.82789 .2362 L
.82792 .23496 L
.82794 .23215 L
.82797 .2281 L
.82803 .21989 L
Mistroke
.82814 .20787 L
.82836 .17371 L
.82848 .1589 L
.82854 .15112 L
.82858 .14697 L
.8286 .14423 L
.82863 .14325 L
.82866 .14232 L
.82868 .14134 L
.82871 .14403 L
.82874 .14755 L
.82876 .14947 L
.82878 .15128 L
.8288 .15189 L
.82883 .15128 L
.82886 .15078 L
.82889 .15017 L
.82893 .14859 L
.82896 .14765 L
.82899 .14943 L
.82902 .15277 L
.82904 .15632 L
.82907 .15986 L
.82909 .15952 L
.82911 .1592 L
.82912 .15885 L
.82914 .15851 L
.82917 .15808 L
.8292 .15841 L
.82923 .15877 L
.82925 .15896 L
.82926 .15914 L
.82929 .15855 L
.82932 .15792 L
.82934 .15759 L
.82936 .15725 L
.82937 .15836 L
.82939 .15957 L
.82942 .1617 L
.82949 .1678 L
.82952 .17075 L
.82956 .17359 L
.82959 .17555 L
.82962 .17735 L
.82965 .17875 L
.82968 .17911 L
.82971 .17947 L
.82973 .17967 L
.82974 .17992 L
.82976 .18043 L
Mistroke
.82978 .1809 L
.82981 .18181 L
.82984 .18275 L
.82987 .18479 L
.82992 .18845 L
.83004 .19538 L
.83095 .24117 L
.83192 .30951 L
.83236 .34726 L
.83248 .3609 L
.83255 .36767 L
.83258 .37002 L
.83261 .37218 L
.83264 .37293 L
.83267 .37366 L
.8327 .37439 L
.83272 .37552 L
.83273 .37706 L
.83279 .38217 L
.83282 .38452 L
.83284 .38608 L
.83287 .38776 L
.83289 .38868 L
.83291 .38927 L
.83294 .38989 L
.83297 .39045 L
.83299 .391 L
.83302 .3922 L
.83308 .39497 L
.83332 .40376 L
.83383 .42612 L
.83407 .43833 L
.8341 .44108 L
.83412 .44253 L
.83414 .44407 L
.83415 .44447 L
.83417 .44426 L
.8342 .44389 L
.83423 .44353 L
.83425 .44389 L
.83426 .44457 L
.83432 .44716 L
.83438 .45249 L
.83441 .45581 L
.83444 .45784 L
.83447 .45742 L
.83449 .45695 L
.83452 .45653 L
.83455 .45755 L
.83457 .45912 L
Mistroke
.8346 .46059 L
.83463 .4616 L
.83466 .46051 L
.83469 .45942 L
.83472 .45838 L
.83473 .4588 L
.83475 .45928 L
.83478 .46014 L
.83481 .46097 L
.83483 .46002 L
.83484 .45891 L
.83487 .4569 L
.8349 .45471 L
.83493 .45416 L
.83495 .45416 L
.83498 .45416 L
.83501 .45432 L
.83504 .4552 L
.83508 .45617 L
.83514 .45776 L
.83517 .4584 L
.83519 .45909 L
.83523 .46057 L
.83525 .46199 L
.83528 .46341 L
.83531 .4632 L
.83534 .46259 L
.83537 .46193 L
.83539 .46069 L
.83543 .45804 L
.83546 .45556 L
.83548 .45342 L
.83551 .45397 L
.83554 .45456 L
.83557 .45508 L
.83559 .45358 L
.83562 .45101 L
.83564 .4486 L
.83567 .44601 L
.83569 .44408 L
.83572 .44226 L
.83576 .44032 L
.83579 .43897 L
.83581 .43796 L
.83584 .43686 L
.83586 .43631 L
.83588 .43628 L
.8359 .43642 L
.83591 .43656 L
.83593 .43668 L
Mistroke
.83594 .43682 L
.83598 .4361 L
.836 .43458 L
.83603 .43322 L
.83606 .43213 L
.83609 .43325 L
.83611 .43382 L
.83612 .43443 L
.83615 .43496 L
.83618 .43119 L
.83621 .42753 L
.83624 .42363 L
.83626 .42219 L
.83627 .42133 L
.8363 .41965 L
.83633 .41807 L
.83636 .41705 L
.83639 .41647 L
.83642 .41594 L
.83644 .41531 L
.83646 .41417 L
.83649 .4128 L
.83652 .41156 L
.83655 .40871 L
.83657 .40463 L
.8366 .39993 L
.83663 .39563 L
.83666 .39561 L
.83669 .39561 L
.83671 .39561 L
.83674 .3952 L
.83677 .39435 L
.8368 .39356 L
.83683 .39264 L
.83686 .39177 L
.83689 .39093 L
.83691 .39045 L
.83692 .38898 L
.83695 .38488 L
.83698 .38055 L
.83704 .37341 L
.83711 .3676 L
.83755 .32513 L
.83802 .28954 L
.83808 .28116 L
.83812 .27801 L
.83814 .27629 L
.83815 .27467 L
.83818 .27399 L
.8382 .27379 L
Mistroke
.83822 .27357 L
.83823 .27339 L
.83825 .27319 L
.83828 .27115 L
.83831 .26909 L
.83834 .2669 L
.83837 .26653 L
.8384 .26685 L
.83843 .26722 L
.83844 .26743 L
.83846 .26781 L
.83849 .26856 L
.83852 .26927 L
.83855 .26952 L
.83858 .26879 L
.83861 .26811 L
.83863 .2675 L
.83866 .26854 L
.83869 .26983 L
.83872 .27102 L
.83875 .26993 L
.83878 .26834 L
.83881 .26666 L
.83886 .2639 L
.83888 .26255 L
.83891 .2611 L
.83894 .25806 L
.83897 .2545 L
.83899 .2525 L
.839 .25037 L
.83903 .25068 L
.83905 .25265 L
.83907 .25451 L
.83908 .25657 L
.8391 .25874 L
.83914 .25814 L
.83916 .25605 L
.83923 .25272 L
.83947 .24207 L
.83958 .23732 L
.83961 .23631 L
.83964 .23512 L
.83967 .2341 L
.8397 .23394 L
.83971 .23479 L
.83973 .23571 L
.83976 .23737 L
.83977 .23836 L
.83979 .23821 L
.83981 .23741 L
Mistroke
.83982 .23655 L
.83985 .23502 L
.83988 .23451 L
.83991 .23758 L
.83994 .24036 L
.83999 .24575 L
.84002 .24855 L
.84005 .25116 L
.84008 .25308 L
.84009 .25333 L
.84011 .25359 L
.84017 .25425 L
.84019 .25321 L
.84022 .2521 L
.84025 .25105 L
.84027 .25126 L
.8403 .25265 L
.84032 .25397 L
.84038 .25773 L
.84041 .26009 L
.84044 .26262 L
.84046 .2631 L
.84048 .2629 L
.84051 .26252 L
.84054 .26217 L
.84057 .26074 L
.84063 .25754 L
.84069 .25461 L
.84071 .25396 L
.84073 .25326 L
.84075 .2529 L
.84077 .2529 L
.8408 .2529 L
.84082 .2529 L
.84083 .2529 L
.84086 .25347 L
.84089 .25411 L
.84092 .25466 L
.84095 .25436 L
.84098 .25379 L
.841 .25328 L
.84103 .25255 L
.84106 .25142 L
.84113 .24917 L
.84116 .24814 L
.84119 .24717 L
.84121 .24663 L
.84123 .24639 L
.84126 .24639 L
.84129 .24639 L
Mistroke
.8413 .24639 L
.84132 .24765 L
.84135 .25184 L
.84138 .25576 L
.84141 .25974 L
.84142 .25927 L
.84144 .25885 L
.84147 .258 L
.8415 .25723 L
.84151 .25774 L
.84153 .25867 L
.84156 .26063 L
.84159 .26232 L
.84161 .26264 L
.84163 .26283 L
.84165 .26317 L
.84169 .26354 L
.84171 .2637 L
.84174 .26381 L
.84177 .26393 L
.84179 .26393 L
.84181 .2631 L
.84186 .26029 L
.84189 .25921 L
.84192 .25869 L
.84194 .25815 L
.84197 .25756 L
.842 .25568 L
.84204 .2535 L
.84207 .25147 L
.84209 .25122 L
.84212 .25156 L
.84215 .25186 L
.84217 .25259 L
.8422 .25496 L
.84223 .25689 L
.84225 .25896 L
.84228 .25957 L
.84231 .25925 L
.84278 .25155 L
.84285 .24595 L
.84288 .24385 L
.84291 .24193 L
.84293 .24084 L
.84295 .24167 L
.84297 .2429 L
.84299 .24425 L
.843 .24537 L
.84302 .24657 L
.84305 .24697 L
Mistroke
.84307 .24684 L
.84308 .24672 L
.84312 .24644 L
.84315 .2462 L
.84318 .24593 L
.84321 .24569 L
.84324 .2457 L
.84327 .24582 L
.8433 .24595 L
.84333 .24733 L
.84335 .24878 L
.84336 .25008 L
.8434 .25267 L
.84342 .25404 L
.84344 .25404 L
.84346 .25404 L
.84348 .25404 L
.84349 .25404 L
.84352 .25475 L
.84354 .25546 L
.84356 .25623 L
.84362 .25895 L
.84365 .26059 L
.84368 .26232 L
.84371 .26356 L
.84373 .26402 L
.84374 .26446 L
.84377 .26522 L
.8438 .26584 L
.84383 .26549 L
.84386 .26512 L
.84392 .26427 L
.84395 .26364 L
.84396 .2633 L
.84398 .26298 L
.84401 .26538 L
.84404 .26833 L
.84407 .27108 L
.84409 .27275 L
.84412 .27265 L
.84414 .27254 L
.84417 .27243 L
.8442 .27281 L
.84423 .27326 L
.84426 .27368 L
.84427 .27393 L
.84429 .27362 L
.84432 .27303 L
.84434 .2727 L
.84435 .27235 L
Mistroke
.84438 .27101 L
.84441 .26902 L
.84444 .26715 L
.84447 .26565 L
.8445 .26611 L
.84453 .26662 L
.84455 .26688 L
.84457 .26727 L
.8446 .26829 L
.84463 .26923 L
.84464 .26975 L
.84466 .27006 L
.84468 .26993 L
.84469 .26981 L
.84473 .26953 L
.84475 .26939 L
.84477 .26847 L
.8448 .2665 L
.84483 .26465 L
.84486 .26468 L
.84489 .2678 L
.84492 .2712 L
.84494 .27292 L
.84495 .27351 L
.84497 .27345 L
.84499 .27338 L
.84502 .27326 L
.84505 .27317 L
.84506 .27317 L
.84508 .27317 L
.84511 .27317 L
.84514 .27343 L
.84517 .27517 L
.84519 .27681 L
.84522 .2786 L
.84525 .27922 L
.84528 .2791 L
.84531 .27899 L
.84534 .27922 L
.84537 .27994 L
.84539 .28056 L
.84542 .28121 L
.84545 .28145 L
.84548 .28167 L
.84551 .28191 L
.84553 .28278 L
.84554 .28413 L
.84557 .28678 L
.8456 .28924 L
.84561 .29019 L
Mistroke
.84563 .28892 L
.84567 .28624 L
.84568 .28492 L
.8457 .28367 L
.84573 .28471 L
.84576 .2867 L
.84579 .28889 L
.84583 .29211 L
.84586 .29552 L
.84589 .29865 L
.84591 .30002 L
.84594 .30015 L
.84597 .30026 L
.84599 .30032 L
.84601 .3017 L
.84604 .30549 L
.84607 .30905 L
.8461 .31132 L
.84612 .31172 L
.84613 .31214 L
.84615 .3126 L
.84617 .31303 L
.8462 .3146 L
.84624 .31696 L
.84627 .31905 L
.84628 .31971 L
.8463 .31903 L
.84633 .31781 L
.84636 .3167 L
.84637 .31603 L
.84639 .31603 L
.84643 .31603 L
.84646 .31603 L
.84647 .31627 L
.84649 .31742 L
.84652 .31967 L
.84655 .32179 L
.84658 .32292 L
.84661 .32292 L
.84664 .32292 L
.84665 .32292 L
.84667 .32343 L
.8467 .32538 L
.84673 .32721 L
.84718 .3558 L
.84811 .41074 L
.84859 .42893 L
.84872 .43927 L
.84873 .44188 L
.84875 .44473 L
Mistroke
.84878 .44815 L
.84881 .44985 L
.84884 .45142 L
.84887 .45231 L
.8489 .45104 L
.84893 .44977 L
.84895 .44906 L
.84897 .44908 L
.84899 .4496 L
.849 .45014 L
.84902 .45065 L
.84904 .45114 L
.84907 .45163 L
.84909 .45177 L
.84911 .45191 L
.84914 .45216 L
.84915 .45178 L
.84917 .45032 L
.84921 .44726 L
.84922 .44579 L
.84924 .44443 L
.84927 .44569 L
.84931 .44744 L
.84934 .44899 L
.84937 .44896 L
.8494 .44873 L
.84943 .44849 L
.84946 .44873 L
.84948 .44915 L
.84951 .44964 L
.84953 .44992 L
.84955 .45092 L
.84961 .45503 L
.84966 .45816 L
.84969 .45975 L
.84971 .46125 L
.84974 .46224 L
.84977 .46282 L
.8498 .46342 L
.84983 .46363 L
.84986 .4634 L
.84989 .46317 L
.84992 .46285 L
.84994 .46094 L
.84997 .45886 L
.85 .45666 L
.85002 .45613 L
.85004 .45627 L
.85007 .45652 L
.8501 .45677 L
Mistroke
.85013 .45575 L
.85014 .45496 L
.85016 .45409 L
.85018 .45317 L
.85019 .45232 L
.85022 .45136 L
.85025 .45059 L
.85028 .44991 L
.85031 .45091 L
.85034 .45326 L
.85037 .45581 L
.85039 .45808 L
.85042 .45899 L
.85045 .46005 L
.85048 .46117 L
.85051 .46043 L
.85054 .45893 L
.8506 .45564 L
.85063 .45412 L
.85066 .45274 L
.85069 .45103 L
.85072 .44885 L
.85074 .44656 L
.85078 .44424 L
.85081 .44475 L
.85082 .44501 L
.85084 .44529 L
.85087 .44543 L
.8509 .4425 L
.85104 .43204 L
.85107 .43069 L
.85109 .43 L
.85113 .42924 L
.85116 .42854 L
.85118 .42958 L
.85121 .4306 L
.85124 .43172 L
.85127 .43126 L
.85128 .43002 L
.8513 .42867 L
.85133 .42622 L
.85139 .4201 L
.85142 .41671 L
.85145 .41424 L
.85148 .41307 L
.85151 .4118 L
.85153 .41105 L
.85154 .40931 L
.85156 .40633 L
.85158 .40306 L
Mistroke
.85165 .38879 L
.85178 .3685 L
.85203 .33404 L
.85228 .28057 L
.85241 .25604 L
.85252 .23341 L
.85255 .22723 L
.85258 .22057 L
.8526 .21636 L
.85263 .21411 L
.85265 .21177 L
.85268 .2092 L
.85271 .20778 L
.85274 .20645 L
.85277 .20508 L
.8528 .202 L
.85286 .19315 L
.85298 .17121 L
.85309 .1498 L
.85315 .1376 L
.85318 .13319 L
.85322 .12913 L
.85325 .12557 L
.85328 .12425 L
.85331 .12413 L
.85334 .12402 L
.85339 .12381 L
.85342 .12369 L
.85344 .12358 L
.85346 .12204 L
.85348 .11995 L
.85351 .11629 L
.85357 .10905 L
.8537 .09154 L
.85376 .08381 L
.8538 .08001 L
.85383 .07649 L
.85386 .07541 L
.85389 .07425 L
.8539 .07359 L
.85392 .07296 L
.85395 .07374 L
.85397 .07507 L
.854 .07649 L
.85403 .07539 L
.85406 .07128 L
.85409 .06648 L
.8541 .06394 L
.85412 .06169 L
.85415 .05984 L
Mistroke
.85418 .05813 L
.8542 .0572 L
.85421 .05623 L
.85423 .05659 L
.85425 .05692 L
.85428 .05757 L
.85431 .05811 L
.85434 .05768 L
.85437 .05721 L
.85438 .05695 L
.8544 .05669 L
.85443 .05738 L
.85445 .05826 L
.85448 .05909 L
.85451 .05921 L
.85454 .05766 L
.85456 .05642 L
.85459 .05511 L
.85461 .05619 L
.85464 .05812 L
.85467 .06022 L
.8547 .0618 L
.85472 .06114 L
.85475 .06053 L
.85481 .05862 L
.85484 .05749 L
.85487 .05628 L
.8549 .05607 L
.85493 .0564 L
.85495 .05673 L
.85498 .05707 L
.85501 .05767 L
.85504 .05833 L
.85507 .0589 L
.8551 .05803 L
.85513 .0572 L
.85516 .05632 L
.85518 .05565 L
.8552 .05485 L
.85523 .05346 L
.85526 .05214 L
.85528 .05202 L
.85529 .05202 L
.85532 .05202 L
.85535 .05202 L
.85538 .0527 L
.85541 .05376 L
.85544 .05483 L
.85545 .05544 L
.85547 .05705 L
Mistroke
.8555 .06004 L
.85553 .06319 L
.85555 .06561 L
.85558 .06686 L
.85561 .06797 L
.85563 .06902 L
.85566 .06979 L
.85568 .07009 L
.85571 .07041 L
.85574 .07077 L
.85577 .07098 L
.85579 .07119 L
.85582 .07143 L
.85585 .07359 L
.85588 .07696 L
.85591 .08062 L
.85597 .08702 L
.856 .08942 L
.85603 .09168 L
.85605 .09101 L
.85608 .09009 L
.85611 .08925 L
.85613 .08945 L
.85616 .09163 L
.85619 .09402 L
.85624 .10024 L
.85674 .14432 L
.85721 .17504 L
.85771 .20455 L
.85823 .24574 L
.85871 .29346 L
.85915 .32789 L
.85927 .3406 L
.8594 .35184 L
.85963 .36701 L
.85976 .37263 L
.85979 .3748 L
.85982 .37714 L
.85985 .37935 L
.85988 .38004 L
.85991 .38057 L
.85994 .38115 L
.85996 .38155 L
.85999 .38176 L
.86002 .382 L
.86005 .38222 L
.86008 .38418 L
.86011 .38635 L
.86061 .4193 L
.86073 .43159 L
Mistroke
.86078 .43687 L
.8608 .43918 L
.86083 .44071 L
.86086 .44174 L
.86088 .44283 L
.86094 .44588 L
.86106 .45435 L
.86108 .45554 L
.86109 .45683 L
.86112 .45732 L
.86114 .45739 L
.86116 .45746 L
.86118 .45753 L
.86119 .45759 L
.86122 .4599 L
.86125 .46264 L
.86131 .46806 L
.86134 .47058 L
.86137 .47297 L
.8614 .47374 L
.86143 .47307 L
.86146 .47233 L
.86147 .47192 L
.86149 .47203 L
.86152 .47299 L
.86155 .4739 L
.86167 .47879 L
.8617 .48049 L
.86173 .48238 L
.86175 .4833 L
.86176 .48417 L
.86179 .48469 L
.86182 .48507 L
.86184 .48526 L
.86186 .48548 L
.86188 .48526 L
.8619 .48487 L
.86191 .48451 L
.86193 .48417 L
.86196 .48398 L
.86198 .48549 L
.862 .48709 L
.86206 .49281 L
.86212 .49955 L
.86213 .50149 L
.86215 .50332 L
.86218 .50363 L
.86221 .50374 L
.86223 .50384 L
.86226 .50379 L
Mistroke
.86229 .50355 L
.86232 .50331 L
.86234 .50317 L
.86235 .50322 L
.86238 .50346 L
.86241 .50368 L
.86243 .50381 L
.86244 .5037 L
.86247 .50273 L
.86251 .50167 L
.86252 .50111 L
.86254 .50064 L
.86257 .50005 L
.8626 .4995 L
.86263 .49898 L
.86266 .49967 L
.86269 .5003 L
.86271 .501 L
.86274 .50072 L
.86277 .50002 L
.86288 .49529 L
.86301 .49134 L
.86306 .48926 L
.86309 .48806 L
.86312 .48867 L
.86314 .49131 L
.86317 .49418 L
.8632 .4969 L
.86322 .49669 L
.86325 .49562 L
.86328 .49462 L
.8633 .494 L
.86333 .49422 L
.86336 .49445 L
.86339 .49471 L
.86342 .49431 L
.86345 .49384 L
.86369 .48881 L
.86375 .48971 L
.86378 .49004 L
.86381 .48903 L
.86384 .48818 L
.86386 .48726 L
.86389 .48496 L
.86392 .48247 L
.86404 .46802 L
.86417 .45543 L
.8642 .45173 L
.86422 .4497 L
.86424 .44778 L
Mistroke
.86427 .44547 L
.86429 .44492 L
.86432 .44429 L
.86435 .4438 L
.86439 .44368 L
.8644 .44361 L
.86442 .44354 L
.86445 .44347 L
.86448 .44358 L
.86451 .44369 L
.86453 .4438 L
.86456 .44274 L
.86459 .44119 L
.86462 .43975 L
.86465 .43687 L
.86476 .42265 L
.86479 .41907 L
.86482 .41523 L
.86484 .41294 L
.86487 .4115 L
.8649 .4099 L
.86493 .40856 L
.86495 .40842 L
.86496 .40829 L
.86499 .40804 L
.86502 .4076 L
.86505 .40562 L
.86508 .40356 L
.86511 .4016 L
.86512 .39992 L
.86514 .39789 L
.86517 .39433 L
.86524 .38455 L
.86527 .3793 L
.86529 .37641 L
.86531 .37429 L
.86534 .37542 L
.86537 .37645 L
.86539 .37745 L
.86542 .37485 L
.86548 .3688 L
.86554 .36324 L
.86557 .36053 L
.86558 .35915 L
.8656 .35858 L
.86562 .35872 L
.86563 .35885 L
.86565 .35899 L
.86567 .35911 L
.8657 .35804 L
Mistroke
.86571 .35625 L
.86573 .35437 L
.86576 .3513 L
.86579 .34859 L
.8658 .34872 L
.86582 .34885 L
.86585 .34908 L
.86588 .34931 L
.86591 .3454 L
.86593 .34185 L
.86596 .33803 L
.86599 .33524 L
.86601 .33393 L
.86608 .33095 L
.8661 .32962 L
.86613 .32817 L
.86616 .32681 L
.86619 .32264 L
.86624 .31444 L
.86626 .31084 L
.86629 .30951 L
.86632 .30792 L
.86636 .30646 L
.86638 .30612 L
.86641 .30575 L
.86643 .30555 L
.86645 .30533 L
.86647 .3042 L
.86648 .3031 L
.86652 .30089 L
.86655 .29882 L
.86657 .2948 L
.8666 .29045 L
.86666 .28217 L
.86669 .2789 L
.86671 .27712 L
.86673 .27546 L
.86675 .27467 L
.86679 .27528 L
.86681 .27585 L
.86684 .27518 L
.86687 .27242 L
.8669 .26987 L
.86695 .26533 L
.867 .26176 L
.86703 .26025 L
.86706 .26092 L
.86711 .26233 L
.86717 .2643 L
.86719 .26486 L
Mistroke
.8672 .26546 L
.86723 .26547 L
.86725 .2651 L
.86726 .2647 L
.86729 .264 L
.86733 .26175 L
.86734 .25956 L
.86736 .25751 L
.86739 .25389 L
.86742 .25113 L
.86745 .24923 L
.86748 .2475 L
.86749 .24651 L
.86751 .24524 L
.86752 .24348 L
.86754 .24155 L
.86757 .23815 L
.8676 .23582 L
.86762 .23615 L
.86764 .23651 L
.86767 .23715 L
.86771 .23783 L
.86774 .23839 L
.86777 .23888 L
.86779 .23904 L
.86781 .23841 L
.86784 .23721 L
.86786 .2361 L
.86789 .23409 L
.86791 .23218 L
.86793 .23013 L
.86799 .22191 L
.86802 .21783 L
.86804 .21568 L
.86806 .2134 L
.86809 .21114 L
.86811 .21193 L
.86814 .21265 L
.86817 .21341 L
.8682 .21183 L
.86823 .21014 L
.86828 .20631 L
.86831 .20378 L
.86834 .20138 L
.86837 .20056 L
.8684 .20178 L
.86843 .20287 L
.86846 .2039 L
.86849 .20273 L
.86852 .20141 L
Mistroke
.86854 .20074 L
.86855 .20011 L
.86857 .20087 L
.86859 .2016 L
.86861 .20282 L
.86864 .20412 L
.86866 .20446 L
.86868 .20465 L
.86871 .20501 L
.86872 .20521 L
.86874 .20539 L
.86875 .20586 L
.86877 .2065 L
.8688 .20761 L
.86883 .20867 L
.86885 .20861 L
.86887 .20811 L
.8689 .20723 L
.86892 .20673 L
.86893 .20617 L
.86895 .20444 L
.86897 .20254 L
.869 .19932 L
.86903 .19594 L
.86905 .19532 L
.86906 .19468 L
.86909 .19356 L
.86921 .18824 L
.86927 .18355 L
.8693 .18082 L
.86933 .17991 L
.86936 .18104 L
.86938 .18169 L
.8694 .18229 L
.86943 .18215 L
.86946 .18039 L
.86957 .17518 L
.86962 .17262 L
.86966 .17096 L
.86969 .16941 L
.8697 .16842 L
.86972 .16661 L
.86976 .16277 L
.86977 .16105 L
.86979 .15924 L
.86982 .15952 L
.86985 .16041 L
.86988 .16124 L
.86995 .16384 L
.87001 .16651 L
Mistroke
.87004 .16802 L
.87007 .16942 L
.8701 .16982 L
.87011 .16936 L
.87013 .16888 L
.87016 .16802 L
.87019 .16762 L
.87022 .16773 L
.87025 .16786 L
.87028 .16802 L
.87031 .16837 L
.87034 .16873 L
.87036 .16906 L
.87039 .1691 L
.87042 .1691 L
.87045 .1691 L
.87046 .1691 L
.87048 .16774 L
.87051 .16446 L
.87054 .16147 L
.87057 .16022 L
.8706 .16088 L
.87063 .16158 L
.87066 .1619 L
.87069 .16015 L
.87071 .15852 L
.87074 .15672 L
.87077 .1574 L
.8708 .15932 L
.87083 .16134 L
.87086 .16237 L
.87089 .16273 L
.8711 .16462 L
.87116 .16618 L
.87119 .1672 L
.87121 .16777 L
.87123 .16829 L
.87126 .16833 L
.87127 .16833 L
.87129 .16833 L
.87132 .16833 L
.87135 .1675 L
.87137 .16654 L
.8714 .16551 L
.87143 .16517 L
.87146 .16575 L
.87149 .16634 L
.87152 .16734 L
.87154 .17012 L
.87157 .17312 L
Mistroke
.87207 .21437 L
.87306 .27401 L
.87401 .3333 L
.87493 .38978 L
.87498 .39282 L
.87501 .39504 L
.87504 .39712 L
.87507 .39807 L
.87509 .3982 L
.87511 .39835 L
.87517 .39883 L
.8752 .39907 L
.87521 .39919 L
.87523 .39932 L
.87526 .40042 L
.87529 .40222 L
.8754 .41107 L
.87541 .41267 L
.87543 .41437 L
.87545 .41518 L
.87547 .41567 L
.8755 .41664 L
.87552 .41712 L
.87553 .41735 L
.87556 .41689 L
.87559 .4164 L
.87561 .41614 L
.87563 .41578 L
.87564 .41491 L
.87566 .41411 L
.87568 .41273 L
.87571 .41123 L
.87574 .41163 L
.87577 .41246 L
.87584 .41485 L
.8759 .41792 L
.87595 .42259 L
.87598 .42533 L
.87601 .42792 L
.87604 .42877 L
.87607 .4297 L
.87609 .43055 L
.87612 .43082 L
.87615 .43082 L
.87618 .43082 L
.87619 .43082 L
.87621 .43152 L
.87624 .43326 L
.87627 .43482 L
.8763 .43604 L
Mistroke
.87633 .43536 L
.87635 .43475 L
.87637 .43437 L
.87639 .43396 L
.87642 .43463 L
.87645 .43563 L
.87647 .43612 L
.87649 .43655 L
.87651 .43517 L
.87654 .43369 L
.87656 .43292 L
.87658 .43208 L
.87661 .4322 L
.87664 .43243 L
.87667 .43268 L
.87669 .43327 L
.8767 .43417 L
.87673 .43579 L
.87676 .43732 L
.87679 .43658 L
.87682 .43532 L
.87685 .43394 L
.87687 .4332 L
.87688 .433 L
.87691 .43276 L
.87694 .43251 L
.87696 .43236 L
.87698 .43322 L
.87701 .43516 L
.87704 .43699 L
.87707 .4382 L
.8771 .43855 L
.87712 .43888 L
.87715 .43923 L
.87718 .4404 L
.87721 .44172 L
.87723 .4431 L
.87727 .44338 L
.87729 .44256 L
.87732 .4418 L
.87783 .42399 L
.87878 .39377 L
.87969 .3552 L
.88016 .32895 L
.88066 .29516 L
.88166 .23687 L
.88169 .23439 L
.88172 .23203 L
.88174 .23073 L
.88175 .23112 L
Mistroke
.88178 .23186 L
.88181 .23257 L
.88185 .23241 L
.88188 .2311 L
.8819 .22992 L
.88193 .22885 L
.88195 .22905 L
.88196 .22924 L
.882 .2296 L
.88202 .2299 L
.88206 .22839 L
.88209 .22674 L
.88211 .22592 L
.88212 .22535 L
.88214 .22535 L
.88216 .22535 L
.88219 .22535 L
.88221 .22534 L
.88224 .22315 L
.88227 .22109 L
.8823 .2193 L
.88232 .21596 L
.88235 .21102 L
.88238 .20649 L
.88241 .20212 L
.88244 .20347 L
.88247 .20464 L
.88249 .20591 L
.88251 .20511 L
.88253 .20342 L
.88256 .20009 L
.88259 .19707 L
.88262 .19599 L
.88265 .19564 L
.88268 .1953 L
.8827 .19512 L
.88273 .19512 L
.88276 .19512 L
.88279 .19504 L
.88282 .19396 L
.88285 .19299 L
.88287 .192 L
.8829 .19019 L
.88293 .18768 L
.88296 .18494 L
.88298 .18363 L
.88301 .18867 L
.88303 .19441 L
.88306 .19971 L
.88309 .2019 L
Mistroke
.8831 .20101 L
.88312 .20006 L
.88315 .19847 L
.88318 .1983 L
.88321 .20029 L
.88324 .20244 L
.88327 .20427 L
.88329 .20397 L
.88332 .20361 L
.88334 .20342 L
.88335 .20322 L
.88339 .20355 L
.88341 .204 L
.88343 .20425 L
.88345 .20452 L
.88346 .20436 L
.88348 .20368 L
.88351 .2024 L
.88354 .20122 L
.88357 .20112 L
.88359 .20131 L
.88361 .20151 L
.88363 .20186 L
.88367 .2037 L
.88369 .20623 L
.88372 .20889 L
.88375 .21026 L
.88378 .20969 L
.8838 .20916 L
.88383 .2086 L
.88386 .20841 L
.88389 .20829 L
.88392 .20818 L
.88395 .20955 L
.88397 .21189 L
.884 .21443 L
.88403 .21729 L
.88406 .21659 L
.88409 .21576 L
.88412 .21502 L
.88414 .21515 L
.88416 .21528 L
.88419 .21553 L
.88421 .21567 L
.88422 .21561 L
.88424 .21506 L
.88426 .21455 L
.88429 .21363 L
.88432 .21277 L
.88433 .21315 L
Mistroke
.88435 .21357 L
.88438 .21431 L
.88441 .215 L
.88444 .2144 L
.88447 .21383 L
.8845 .21328 L
.88453 .21441 L
.88454 .2154 L
.88456 .21648 L
.88457 .21755 L
.88459 .21867 L
.88462 .2185 L
.88465 .21756 L
.88468 .2167 L
.88471 .21731 L
.88474 .22011 L
.88478 .22315 L
.88479 .22468 L
.88481 .22526 L
.88488 .22743 L
.88494 .22962 L
.88497 .23074 L
.88499 .23208 L
.88501 .23413 L
.88507 .2419 L
.88513 .24805 L
.88515 .25064 L
.88518 .2523 L
.88521 .25158 L
.88524 .25091 L
.88526 .2505 L
.88527 .25065 L
.88529 .25263 L
.88531 .25472 L
.88534 .25855 L
.88537 .26161 L
.8854 .2628 L
.88543 .26408 L
.88549 .26737 L
.88555 .27103 L
.88561 .27562 L
.88564 .2779 L
.88567 .28092 L
.88572 .28802 L
.88575 .29143 L
.88578 .29025 L
.88581 .28886 L
.88584 .28755 L
.88585 .28841 L
.88587 .29012 L
Mistroke
.8859 .29309 L
.88597 .29918 L
.88604 .30464 L
.88607 .30746 L
.88609 .30884 L
.88611 .3101 L
.88614 .31132 L
.88615 .31015 L
.88617 .30903 L
.8862 .30668 L
.88622 .30549 L
.88624 .30506 L
.88625 .30524 L
.88627 .30544 L
.8863 .30581 L
.88636 .30677 L
.88639 .30743 L
.88641 .30779 L
.88642 .30831 L
.88645 .30973 L
.88649 .31128 L
.88655 .31455 L
.88661 .31852 L
.88673 .32848 L
.88695 .34997 L
.88701 .35614 L
.88705 .35982 L
.88707 .36319 L
.88711 .36455 L
.88712 .36448 L
.88714 .36442 L
.88715 .36435 L
.88717 .36428 L
.88719 .36487 L
.88721 .36633 L
.88724 .3689 L
.88725 .37026 L
.88727 .37169 L
.8873 .37326 L
.88733 .37442 L
.88736 .37546 L
.88739 .37624 L
.88742 .37661 L
.88745 .37696 L
.88747 .37768 L
.88749 .37909 L
.88751 .38041 L
.88754 .3833 L
.88757 .38522 L
.8876 .385 L
Mistroke
.88763 .38477 L
.88766 .38453 L
.88767 .38499 L
.88769 .38549 L
.88782 .39115 L
.88796 .3996 L
.88844 .42083 L
.88867 .43529 L
.8888 .4426 L
.88892 .44774 L
.88895 .44953 L
.88898 .45122 L
.889 .45215 L
.88902 .45198 L
.88903 .45172 L
.88905 .45147 L
.88906 .45122 L
.88908 .45095 L
.8891 .45077 L
.88912 .45104 L
.88919 .45221 L
.88931 .4541 L
.88934 .45463 L
.88936 .45491 L
.88938 .45518 L
.88939 .45527 L
.88941 .4552 L
.88944 .45509 L
.88947 .45497 L
.88948 .45465 L
.8895 .45379 L
.88953 .4519 L
.88957 .45018 L
.88959 .44913 L
.88962 .44847 L
.88965 .44777 L
.88968 .44766 L
.8897 .44829 L
.88972 .44888 L
.88975 .44999 L
.88982 .45286 L
.88984 .45413 L
.88988 .45517 L
.88989 .45549 L
.88991 .45585 L
.88994 .45646 L
.88997 .45629 L
.89 .455 L
.89003 .45382 L
.89005 .45261 L
Mistroke
.89009 .45225 L
.89011 .45191 L
.89014 .45154 L
.89016 .45054 L
.89018 .4493 L
.8902 .44723 L
.89023 .44504 L
.89026 .4441 L
.89028 .44389 L
.89031 .44365 L
.89034 .44339 L
.8904 .44272 L
.89043 .44237 L
.89045 .44185 L
.89046 .44118 L
.8905 .43966 L
.89053 .43827 L
.89056 .43839 L
.89058 .43873 L
.89061 .43908 L
.89063 .43914 L
.89065 .43877 L
.89067 .43813 L
.8907 .43744 L
.89073 .4366 L
.89076 .43528 L
.89079 .43374 L
.89082 .43211 L
.89084 .43009 L
.89087 .42778 L
.89137 .39315 L
.89188 .36416 L
.892 .35735 L
.89212 .34934 L
.89215 .34714 L
.89218 .34596 L
.8922 .34492 L
.89223 .34397 L
.89226 .34317 L
.89229 .34304 L
.89232 .34292 L
.89235 .34281 L
.89238 .34006 L
.89241 .33753 L
.89247 .33147 L
.89258 .32259 L
.89283 .30239 L
.89328 .27309 L
.89373 .24411 L
.89375 .23721 L
Mistroke
.89377 .23357 L
.89379 .23073 L
.89382 .22889 L
.89385 .22719 L
.89386 .22626 L
.89388 .22532 L
.8939 .22503 L
.89391 .22475 L
.89393 .2245 L
.89395 .22424 L
.89398 .22319 L
.894 .21803 L
.89403 .21252 L
.89406 .20776 L
.89409 .20472 L
.8941 .20341 L
.89412 .2022 L
.89415 .19983 L
.89418 .19673 L
.89421 .19277 L
.89424 .18891 L
.89427 .18583 L
.89428 .18491 L
.8943 .18391 L
.89433 .18216 L
.89444 .17688 L
.89457 .17081 L
.89463 .16761 L
.89469 .16375 L
.8947 .16269 L
.89472 .16156 L
.89475 .16125 L
.89478 .16219 L
.89482 .16322 L
.89488 .16512 L
.8949 .16565 L
.89492 .16615 L
.89493 .16716 L
.89495 .16926 L
.89498 .17308 L
.895 .17518 L
.89502 .17714 L
.89505 .17844 L
.89508 .1792 L
.89511 .17991 L
.89513 .1813 L
.89516 .18355 L
.89519 .18568 L
.89522 .18745 L
.89525 .1887 L
Mistroke
.89528 .18974 L
.89531 .19088 L
.89534 .19079 L
.89537 .19066 L
.8954 .19054 L
.89543 .19083 L
.89546 .19118 L
.89549 .1915 L
.89551 .1922 L
.89554 .19368 L
.89556 .19528 L
.8956 .19699 L
.89562 .19673 L
.89565 .19639 L
.89568 .19601 L
.8957 .19603 L
.89571 .19652 L
.89574 .19738 L
.89577 .19817 L
.89579 .19879 L
.89581 .19989 L
.89584 .20233 L
.89591 .20719 L
.89594 .20976 L
.89597 .21248 L
.89599 .21211 L
.89602 .20944 L
.89605 .20658 L
.89607 .20497 L
.89609 .20686 L
.89612 .2121 L
.89615 .21708 L
.89621 .22608 L
.89624 .2301 L
.89627 .23361 L
.89629 .23545 L
.89632 .2374 L
.89638 .24198 L
.89662 .26437 L
.89665 .26704 L
.89668 .26759 L
.8967 .26807 L
.89672 .26858 L
.89675 .27015 L
.89678 .27323 L
.89681 .27604 L
.89683 .27907 L
.89686 .27808 L
.89689 .27623 L
.89695 .27159 L
Mistroke
.89698 .26899 L
.89701 .26624 L
.89704 .2646 L
.89706 .26583 L
.8971 .26722 L
.89713 .26853 L
.89716 .26942 L
.89719 .27037 L
.89726 .27189 L
.89728 .27215 L
.8973 .27243 L
.89731 .2727 L
.89733 .27333 L
.89739 .27684 L
.89745 .28084 L
.89751 .28628 L
.89755 .29005 L
.89758 .29351 L
.8976 .29672 L
.89763 .29657 L
.89766 .29622 L
.89768 .29601 L
.89769 .29583 L
.89772 .29583 L
.89775 .29594 L
.89778 .29605 L
.8978 .29574 L
.89783 .2932 L
.89786 .29051 L
.89789 .28821 L
.89791 .29003 L
.89795 .29311 L
.89798 .29642 L
.89804 .3033 L
.89816 .31411 L
.89822 .32093 L
.89825 .32431 L
.89828 .32769 L
.89831 .32925 L
.89834 .33072 L
.8984 .33383 L
.89853 .34065 L
.89856 .34219 L
.89859 .34304 L
.89861 .34368 L
.89864 .34435 L
.89866 .34473 L
.89867 .34568 L
.8987 .34735 L
.89876 .35109 L
Mistroke
.89881 .35777 L
.89884 .36153 L
.89887 .36067 L
.8989 .3593 L
.89893 .35784 L
.89895 .35713 L
.89898 .35751 L
.899 .35792 L
.89903 .35836 L
.89906 .3585 L
.89909 .3585 L
.89912 .3585 L
.89915 .35901 L
.89918 .35997 L
.89921 .36103 L
.89922 .36163 L
.89924 .36162 L
.89927 .36032 L
.8993 .35879 L
.89932 .35805 L
.89933 .35773 L
.89936 .35773 L
.89939 .35773 L
.89941 .35773 L
.89943 .35813 L
.89946 .36181 L
.89949 .36535 L
.89952 .36915 L
.89954 .36844 L
.89955 .36771 L
.89958 .36629 L
.8996 .36558 L
.89962 .36512 L
.89964 .36565 L
.89965 .36614 L
.89972 .36858 L
.89978 .37326 L
.89981 .37559 L
.89983 .37388 L
.89987 .37196 L
.89988 .37091 L
.8999 .3699 L
.89993 .36613 L
.89996 .362 L
.89999 .35805 L
.90001 .35815 L
.90003 .3587 L
.90006 .35967 L
.90008 .36056 L
.9001 .36091 L
Mistroke
.90012 .3611 L
.90015 .36152 L
.90018 .36189 L
.9002 .36235 L
.90022 .36286 L
.90025 .36386 L
.90028 .36481 L
.9003 .36363 L
.90033 .36168 L
.90036 .35956 L
.90038 .3585 L
.90039 .35822 L
.90043 .35774 L
.90045 .35728 L
.90048 .35729 L
.90051 .35839 L
.90054 .35931 L
.90057 .36031 L
.9006 .36063 L
.90063 .36089 L
.90066 .36113 L
.90069 .3604 L
.90071 .35948 L
.90074 .35848 L
.90076 .35782 L
.90079 .35821 L
.90082 .35867 L
.90085 .35915 L
.90088 .35992 L
.9009 .36074 L
.90093 .3616 L
.90096 .36272 L
.90099 .36471 L
.90102 .36658 L
.90108 .37076 L
.90111 .37289 L
.90114 .37486 L
.90117 .37373 L
.9012 .37236 L
.90123 .37099 L
.90126 .37066 L
.90128 .37108 L
.90131 .37153 L
.90134 .37177 L
.90136 .37109 L
.90139 .37027 L
.90142 .3694 L
.90145 .36785 L
.90148 .36624 L
.90161 .35859 L
Mistroke
.90186 .34508 L
.90189 .34483 L
.90192 .34499 L
.90194 .34525 L
.90196 .34553 L
.90199 .34602 L
.90202 .34542 L
.90205 .34366 L
.90211 .34007 L
.90214 .33667 L
.90217 .33299 L
.9022 .33014 L
.90223 .32991 L
.90226 .32963 L
.90228 .3295 L
.9023 .32977 L
.90231 .33034 L
.90233 .33096 L
.90236 .33207 L
.90239 .33147 L
.90242 .32689 L
.90245 .32196 L
.90247 .31934 L
.90249 .31696 L
.90252 .31427 L
.90254 .31174 L
.9026 .30449 L
.90263 .30007 L
.90266 .29597 L
.90269 .29409 L
.90272 .29384 L
.90274 .29363 L
.90277 .29356 L
.9028 .29478 L
.90282 .29593 L
.90285 .29716 L
.90288 .29811 L
.90291 .29878 L
.90294 .29941 L
.90297 .29963 L
.90299 .29833 L
.90302 .29689 L
.90304 .29609 L
.90305 .29532 L
.90308 .29169 L
.90311 .28768 L
.90313 .28424 L
.90316 .28107 L
.90318 .27895 L
.90321 .277 L
Mistroke
.90324 .27491 L
.90327 .27414 L
.9033 .2739 L
.90331 .27378 L
.90333 .27365 L
.90336 .27286 L
.90339 .27186 L
.9034 .2713 L
.90342 .2707 L
.90344 .27036 L
.90345 .27267 L
.90349 .27698 L
.90352 .28097 L
.90355 .28279 L
.90356 .28241 L
.90358 .28201 L
.90361 .28127 L
.90364 .27931 L
.90366 .27498 L
.90369 .27035 L
.90372 .26597 L
.90375 .26832 L
.90377 .2709 L
.9038 .27371 L
.90383 .27571 L
.90386 .27678 L
.9039 .27791 L
.90391 .27848 L
.90393 .27847 L
.90396 .27835 L
.90399 .27823 L
.90402 .278 L
.90404 .27731 L
.90407 .27672 L
.90409 .27608 L
.90412 .27509 L
.90415 .27403 L
.90421 .27211 L
.90471 .25898 L
.90483 .251 L
.90486 .24773 L
.90489 .24768 L
.90491 .2484 L
.90492 .24905 L
.90494 .24967 L
.90496 .25033 L
.90497 .25082 L
.90499 .25115 L
.90503 .2519 L
.9051 .25355 L
Mistroke
.90522 .25657 L
.90571 .26771 L
.90619 .28552 L
.90626 .29012 L
.90627 .29142 L
.90629 .29266 L
.90632 .29377 L
.90634 .29402 L
.90635 .29429 L
.90639 .29484 L
.90642 .29529 L
.90646 .29575 L
.90647 .29594 L
.90649 .29613 L
.90652 .29613 L
.90654 .29613 L
.90656 .29613 L
.90657 .29613 L
.90659 .29615 L
.90662 .29639 L
.90665 .29665 L
.90668 .29689 L
.90671 .29742 L
.90674 .29799 L
.90676 .29853 L
.9068 .2979 L
.90682 .2964 L
.90685 .29508 L
.90688 .29397 L
.90691 .29527 L
.90693 .29647 L
.90699 .29941 L
.90702 .30113 L
.90705 .3027 L
.90707 .30316 L
.90711 .30131 L
.90714 .2994 L
.90715 .29844 L
.90717 .29919 L
.9072 .3027 L
.90724 .306 L
.90725 .30783 L
.90727 .30639 L
.90731 .30333 L
.90734 .3004 L
.90735 .29931 L
.90737 .30001 L
.90743 .30242 L
.9075 .3048 L
.90753 .30594 L
Mistroke
.90756 .30761 L
.90761 .31179 L
.90767 .31511 L
.9077 .31636 L
.90773 .31754 L
.90776 .31819 L
.90779 .31887 L
.90782 .31962 L
.90784 .31905 L
.90785 .31676 L
.90791 .30892 L
.90798 .29959 L
.90799 .29684 L
.90801 .29424 L
.90803 .29364 L
.90804 .29487 L
.90807 .29692 L
.9081 .29913 L
.90812 .30013 L
.90814 .30058 L
.90817 .30147 L
.9082 .30223 L
.90823 .3019 L
.90826 .30042 L
.90829 .29904 L
.90835 .29521 L
.90838 .29339 L
.90841 .29217 L
.90844 .2931 L
.90847 .29395 L
.90852 .29547 L
.90855 .29617 L
.90857 .29682 L
.9086 .29819 L
.90863 .30129 L
.90875 .31092 L
.90882 .3152 L
.90885 .31769 L
.90887 .31891 L
.90888 .31988 L
.90891 .32022 L
.90894 .32059 L
.90897 .32097 L
.90899 .3209 L
.90901 .32076 L
.90904 .32053 L
.90907 .32028 L
.9091 .32051 L
.90912 .32083 L
.90915 .32116 L
Mistroke
.90918 .32298 L
.9092 .32661 L
.90923 .33061 L
.90926 .33489 L
.90928 .33546 L
.90929 .33576 L
.90932 .33636 L
.90935 .33692 L
.90938 .33707 L
.9094 .33707 L
.90946 .33707 L
.90949 .33707 L
.90952 .33707 L
.90954 .33707 L
.90957 .33857 L
.9096 .34104 L
.90962 .34338 L
.90964 .34467 L
.90966 .34497 L
.90969 .34462 L
.90971 .34429 L
.90974 .34379 L
.90977 .34187 L
.9098 .33975 L
.90981 .33855 L
.90983 .33728 L
.90986 .33749 L
.90987 .33809 L
.90989 .33864 L
.90991 .33929 L
.90993 .33991 L
.90996 .33925 L
.90998 .33824 L
.91001 .33716 L
.91003 .33667 L
.91005 .33661 L
.91008 .33648 L
.91011 .33636 L
.91014 .33754 L
.91016 .33879 L
.91017 .33997 L
.9102 .34192 L
.91023 .34342 L
.91026 .34405 L
.91029 .34463 L
.91031 .34496 L
.91032 .34507 L
.91034 .34499 L
.91036 .34492 L
.91038 .34486 L
Mistroke
.91039 .34479 L
.91041 .34499 L
.91043 .34722 L
.91046 .35165 L
.91048 .35384 L
.91049 .35585 L
.91052 .35735 L
.91055 .35735 L
.91058 .35735 L
.91061 .35829 L
.91064 .36044 L
.91066 .36278 L
.91072 .3682 L
.91075 .3715 L
.91078 .37461 L
.91081 .37525 L
.91084 .37513 L
.91087 .37501 L
.9109 .37441 L
.91092 .37315 L
.91095 .37177 L
.911 .3692 L
.91104 .36787 L
.91107 .36661 L
.91109 .36609 L
.91113 .36596 L
.91114 .36589 L
.91116 .36583 L
.91118 .36585 L
.91119 .36659 L
.91123 .36784 L
.91124 .36852 L
.91126 .36915 L
.91129 .37114 L
.91132 .3739 L
.91137 .37866 L
.91144 .38359 L
.9115 .38693 L
.91153 .38826 L
.91156 .3895 L
.91159 .3901 L
.91162 .39075 L
.91164 .39109 L
.91165 .39139 L
.91168 .3903 L
.91175 .38798 L
.91178 .3881 L
.91181 .38822 L
.91183 .38828 L
.91184 .38829 L
Mistroke
.91187 .38695 L
.9119 .38567 L
.91193 .38448 L
.91196 .38252 L
.91199 .38006 L
.91202 .37786 L
.91204 .37691 L
.91207 .37835 L
.9121 .37967 L
.91212 .38089 L
.91215 .38021 L
.91217 .37907 L
.9122 .37785 L
.91225 .37515 L
.91228 .37359 L
.91231 .37196 L
.91233 .37151 L
.91235 .37151 L
.91238 .37151 L
.91241 .37151 L
.91243 .37181 L
.91247 .3723 L
.91248 .37257 L
.9125 .37282 L
.91253 .37227 L
.91256 .37056 L
.91269 .3603 L
.91275 .35643 L
.91278 .3548 L
.9128 .35344 L
.91283 .35282 L
.91287 .35215 L
.9129 .35149 L
.91293 .34953 L
.91295 .34771 L
.91298 .3458 L
.913 .34519 L
.91302 .34471 L
.91305 .34387 L
.91308 .34308 L
.91311 .34256 L
.91316 .3419 L
.91322 .34122 L
.91325 .34089 L
.91327 .34058 L
.9133 .34073 L
.91332 .34103 L
.91335 .34136 L
.91337 .34166 L
.9134 .33936 L
Mistroke
.91343 .33682 L
.91349 .33193 L
.91352 .32945 L
.91354 .32711 L
.91357 .32535 L
.9136 .32578 L
.91363 .32625 L
.91366 .32668 L
.91369 .32425 L
.91372 .32159 L
.91375 .31871 L
.91376 .31761 L
.91378 .31703 L
.91384 .31484 L
.91428 .303 L
.91452 .28832 L
.91478 .2763 L
.91488 .27174 L
.91494 .26941 L
.91497 .26785 L
.915 .26639 L
.91503 .26722 L
.91506 .2683 L
.91509 .26922 L
.91512 .26924 L
.91515 .26911 L
.91518 .26899 L
.91521 .26928 L
.91524 .26974 L
.91526 .27015 L
.91529 .27024 L
.91532 .26871 L
.91535 .2673 L
.9154 .26393 L
.91545 .25973 L
.91548 .25756 L
.9155 .25797 L
.91551 .25834 L
.91554 .25899 L
.91557 .2597 L
.9156 .25874 L
.91562 .25761 L
.91565 .25643 L
.91568 .25652 L
.91569 .25818 L
.91571 .25972 L
.91574 .2632 L
.91581 .26813 L
.91584 .27015 L
.91586 .27136 L
Mistroke
.91589 .26996 L
.91593 .26842 L
.91595 .26707 L
.91598 .26983 L
.91604 .27476 L
.91607 .27672 L
.9161 .27805 L
.91616 .28107 L
.91622 .28382 L
.91628 .28693 L
.91631 .28841 L
.91634 .28997 L
.91636 .29031 L
.91639 .29065 L
.91641 .29084 L
.91642 .29103 L
.91644 .29221 L
.91646 .29452 L
.91652 .30325 L
.91657 .31011 L
.91661 .31392 L
.91664 .31627 L
.91667 .31686 L
.9167 .3175 L
.91671 .31783 L
.91673 .3185 L
.91676 .31999 L
.91688 .32506 L
.91694 .32714 L
.91697 .32807 L
.917 .32895 L
.91702 .32916 L
.91704 .32931 L
.91708 .32958 L
.91709 .32972 L
.91711 .32881 L
.91713 .32668 L
.91714 .32434 L
.91717 .32029 L
.9172 .31665 L
.91722 .318 L
.91724 .31922 L
.91727 .3216 L
.9173 .32369 L
.91733 .32382 L
.91736 .32393 L
.91739 .32405 L
.91741 .32436 L
.91744 .32469 L
.9175 .32566 L
Mistroke
.91755 .3271 L
.91758 .32789 L
.91761 .328 L
.91764 .32813 L
.91766 .3282 L
.91767 .32826 L
.9177 .32774 L
.91774 .32709 L
.91776 .32651 L
.91779 .32659 L
.91782 .32694 L
.91785 .32731 L
.91788 .32564 L
.9179 .32342 L
.91791 .32139 L
.91795 .31742 L
.91797 .31455 L
.91799 .31358 L
.91801 .31255 L
.91803 .31143 L
.91804 .31038 L
.91808 .30952 L
.91809 .30952 L
.91811 .30952 L
.91813 .30952 L
.91814 .30952 L
.91817 .31039 L
.9182 .31201 L
.91822 .31285 L
.91824 .31377 L
.91827 .3145 L
.9183 .3145 L
.91833 .3145 L
.91835 .31467 L
.91837 .31506 L
.91839 .3155 L
.9184 .31588 L
.91842 .31628 L
.91845 .31675 L
.91848 .31663 L
.91851 .31651 L
.91853 .31644 L
.91855 .31629 L
.91858 .31585 L
.91862 .31543 L
.91865 .31495 L
.91868 .31432 L
.91871 .31377 L
.91874 .31291 L
.91876 .31197 L
Mistroke
.91877 .3111 L
.9188 .30938 L
.91883 .30817 L
.91887 .30753 L
.91899 .30535 L
.91905 .30441 L
.91907 .304 L
.9191 .30355 L
.91913 .30282 L
.91916 .3019 L
.91919 .3009 L
.91922 .30068 L
.91925 .30145 L
.91927 .30217 L
.9193 .30295 L
.91933 .30313 L
.91936 .30324 L
.91939 .30337 L
.91942 .30255 L
.91945 .30148 L
.91948 .30022 L
.91949 .29964 L
.91951 .3003 L
.91957 .30279 L
.91968 .31165 L
.91974 .31679 L
.91976 .3193 L
.91979 .32072 L
.91981 .31939 L
.91984 .31798 L
.91986 .31724 L
.91987 .31644 L
.9199 .31653 L
.91993 .31664 L
.91996 .31676 L
.91999 .31643 L
.92001 .31577 L
.92004 .31505 L
.92007 .31477 L
.92009 .31557 L
.9201 .31645 L
.92013 .31798 L
.92016 .31943 L
.92019 .31677 L
.92025 .3118 L
.9203 .30766 L
.92032 .30557 L
.92035 .30336 L
.92038 .30281 L
.92041 .30258 L
Mistroke
.92043 .30237 L
.92046 .30331 L
.92049 .30552 L
.92051 .30669 L
.92053 .30792 L
.92056 .30926 L
.92059 .30949 L
.92062 .30975 L
.92064 .3099 L
.92066 .31045 L
.92069 .31149 L
.92072 .31247 L
.92075 .31291 L
.92078 .31279 L
.92081 .31267 L
.92084 .3125 L
.92087 .31188 L
.9209 .31121 L
.92093 .31067 L
.92096 .31067 L
.92099 .31067 L
.92102 .31067 L
.92105 .31058 L
.92107 .31047 L
.9211 .31035 L
.92112 .31039 L
.92114 .31134 L
.92117 .3132 L
.9212 .31495 L
.92122 .31572 L
.92125 .31477 L
.92128 .3138 L
.9213 .31329 L
.92132 .31294 L
.92133 .31287 L
.92135 .3128 L
.92137 .31274 L
.92138 .31267 L
.9214 .31261 L
.92141 .31246 L
.92144 .31211 L
.92147 .3118 L
.9215 .31147 L
.92153 .31426 L
.92156 .31711 L
.92162 .32431 L
.92165 .32877 L
.92167 .33289 L
.9217 .33563 L
.92173 .33684 L
Mistroke
.92176 .33816 L
.92179 .33938 L
.92181 .33966 L
.92183 .33996 L
.92189 .3406 L
.92191 .34093 L
.92194 .34129 L
.92197 .34162 L
.922 .34257 L
.92203 .34378 L
.92205 .34444 L
.92206 .34506 L
.92209 .34479 L
.92212 .3435 L
.92215 .3421 L
.92218 .34095 L
.92222 .33996 L
.92223 .33952 L
.92225 .33905 L
.92228 .33872 L
.92231 .33894 L
.92232 .33908 L
.92234 .33921 L
.92237 .34 L
.92261 .34742 L
.92263 .34722 L
.92265 .34708 L
.92266 .34789 L
.92268 .34863 L
.92271 .35024 L
.92273 .35115 L
.92275 .35115 L
.92278 .34939 L
.92281 .34776 L
.92283 .34684 L
.92284 .34632 L
.92286 .34651 L
.92288 .34672 L
.9229 .34706 L
.92293 .34762 L
.92296 .3506 L
.92299 .35331 L
.92302 .35649 L
.92304 .35761 L
.92305 .35805 L
.92311 .35974 L
.92336 .36711 L
.92381 .37713 L
.92426 .38632 L
.92429 .38844 L
Mistroke
.92432 .39056 L
.92435 .39256 L
.92438 .39291 L
.9244 .39252 L
.92442 .3921 L
.92443 .39168 L
.92445 .39123 L
.92447 .39106 L
.92448 .39112 L
.92451 .39124 L
.92454 .39136 L
.92457 .39123 L
.9246 .39088 L
.92463 .39051 L
.92465 .39032 L
.92466 .38992 L
.9247 .38904 L
.92473 .38818 L
.92475 .38755 L
.92478 .38744 L
.92481 .38733 L
.92484 .38721 L
.92487 .38808 L
.92498 .39209 L
.92505 .39501 L
.92508 .39634 L
.92511 .39756 L
.92514 .39841 L
.92517 .39876 L
.92523 .39949 L
.92536 .40101 L
.92539 .40138 L
.92541 .40159 L
.92542 .40158 L
.92544 .40083 L
.92546 .40012 L
.92548 .39947 L
.92549 .39875 L
.92552 .39801 L
.92555 .39839 L
.92558 .39874 L
.92561 .39904 L
.92564 .39804 L
.92567 .39695 L
.92574 .39499 L
.92579 .39311 L
.92585 .39154 L
.92588 .39068 L
.9259 .39032 L
.92591 .39083 L
Mistroke
.92594 .39179 L
.92597 .39269 L
.926 .39314 L
.92602 .39219 L
.92605 .39123 L
.92608 .39018 L
.92611 .38621 L
.92614 .38138 L
.92616 .37703 L
.92619 .37314 L
.92621 .3718 L
.92623 .37057 L
.92626 .36815 L
.92629 .36638 L
.92632 .36577 L
.92635 .36515 L
.92636 .36481 L
.92638 .36465 L
.9264 .36472 L
.92642 .36479 L
.92643 .36485 L
.92645 .36492 L
.92648 .36543 L
.92651 .3669 L
.92656 .36955 L
.92669 .37501 L
.92672 .37779 L
.92675 .38075 L
.92677 .38129 L
.92678 .38103 L
.92681 .38053 L
.92687 .37954 L
.9269 .37894 L
.92693 .3783 L
.92696 .37892 L
.92699 .38092 L
.92702 .38277 L
.92705 .38377 L
.92707 .38172 L
.9271 .37953 L
.92715 .37577 L
.92728 .36729 L
.92734 .36196 L
.92738 .35768 L
.9274 .35581 L
.92742 .35376 L
.92744 .35235 L
.92747 .35173 L
.92749 .35141 L
.92751 .35106 L
Mistroke
.92754 .3486 L
.92757 .34533 L
.9276 .34187 L
.92763 .34009 L
.92766 .33997 L
.92768 .33986 L
.92772 .33975 L
.92773 .33975 L
.92775 .33975 L
.92778 .33975 L
.92781 .33985 L
.92784 .3426 L
.92787 .34523 L
.9279 .34761 L
.92792 .34764 L
.92795 .347 L
.92798 .34633 L
.92801 .34624 L
.92804 .34709 L
.92806 .34799 L
.92809 .34876 L
.92811 .34684 L
.92824 .33837 L
.92825 .33805 L
.92827 .33771 L
.92829 .33686 L
.92831 .33514 L
.92834 .3318 L
.92837 .32866 L
.9284 .32864 L
.92843 .32975 L
.92845 .33034 L
.92847 .33097 L
.9285 .32962 L
.92861 .32597 L
.92864 .32752 L
.92867 .32897 L
.92868 .32848 L
.9287 .32794 L
.92873 .327 L
.92876 .3261 L
.92879 .3239 L
.92884 .31957 L
.92897 .30863 L
.92909 .30156 L
.92912 .3019 L
.92914 .30225 L
.92916 .30102 L
.92918 .2996 L
.92921 .2971 L
Mistroke
.92926 .29238 L
.92929 .28976 L
.92932 .287 L
.92935 .28526 L
.92938 .28479 L
.9294 .28435 L
.92943 .28395 L
.92945 .2838 L
.92948 .28369 L
.92951 .28359 L
.92953 .28315 L
.92956 .2795 L
.92959 .27558 L
.92964 .26909 L
.92976 .25831 L
.92983 .25368 L
.92986 .2512 L
.92989 .24889 L
.92992 .2475 L
.92995 .24738 L
.92996 .24732 L
.92998 .24725 L
.93001 .24651 L
.93003 .24311 L
.93006 .23939 L
.93012 .23243 L
.93015 .22978 L
.93017 .22693 L
.9302 .22467 L
.93022 .22533 L
.93025 .2261 L
.93028 .22692 L
.93029 .22708 L
.93031 .22614 L
.93034 .22448 L
.93037 .22292 L
.9304 .22052 L
.93043 .21723 L
.93045 .21421 L
.93051 .20873 L
.93054 .20681 L
.93057 .20503 L
.9306 .20702 L
.93061 .20924 L
.93063 .21159 L
.93066 .21559 L
.93069 .21763 L
.93072 .21752 L
.93074 .21741 L
.93079 .21721 L
Mistroke
.93082 .2171 L
.93085 .21698 L
.93088 .2172 L
.93091 .21763 L
.93115 .2227 L
.93118 .22292 L
.9312 .22305 L
.93122 .2232 L
.93123 .22333 L
.93125 .22385 L
.93128 .22648 L
.93131 .22904 L
.93133 .23048 L
.93135 .23079 L
.93138 .22545 L
.9314 .2204 L
.93143 .21554 L
.93146 .21552 L
.93149 .21653 L
.93151 .21745 L
.93154 .21808 L
.93157 .21808 L
.93159 .21808 L
.93161 .21808 L
.93164 .2183 L
.93165 .2187 L
.93167 .21907 L
.93169 .21947 L
.9317 .21991 L
.93173 .22117 L
.93175 .22235 L
.93177 .22346 L
.9318 .22553 L
.93182 .22727 L
.93185 .2274 L
.93188 .22752 L
.93191 .22762 L
.93194 .22747 L
.93197 .22723 L
.93199 .22701 L
.93202 .22537 L
.93204 .22142 L
.93207 .21711 L
.9321 .21251 L
.93212 .21321 L
.93215 .21673 L
.93218 .22056 L
.93221 .22392 L
.93222 .22419 L
.93224 .22443 L
Mistroke
.93227 .22492 L
.9323 .22539 L
.93233 .22782 L
.93236 .23024 L
.93239 .23288 L
.93242 .23357 L
.93244 .2338 L
.93247 .23402 L
.9325 .23442 L
.93253 .23534 L
.93255 .23621 L
.93267 .24133 L
.9328 .24775 L
.93282 .25051 L
.93285 .25347 L
.93288 .2548 L
.93291 .25388 L
.93293 .25291 L
.93296 .25186 L
.933 .25118 L
.93303 .25058 L
.93305 .25003 L
.93308 .24971 L
.93311 .24949 L
.93313 .24926 L
.93316 .24885 L
.93318 .24633 L
.93324 .24064 L
.93327 .23821 L
.9333 .23705 L
.93332 .23599 L
.93335 .23499 L
.93338 .23715 L
.93341 .23914 L
.93347 .24387 L
.9335 .24596 L
.93353 .2482 L
.93355 .24872 L
.93358 .24708 L
.9336 .24516 L
.93364 .24306 L
.93366 .24568 L
.93369 .24837 L
.93376 .25404 L
.93379 .25609 L
.93382 .25797 L
.93384 .25877 L
.93387 .25899 L
.9339 .25922 L
.93393 .2599 L
Mistroke
.934 .26369 L
.93401 .26473 L
.93403 .26537 L
.93405 .26569 L
.93406 .26603 L
.93409 .26666 L
.93411 .26701 L
.93413 .26673 L
.93419 .26529 L
.93422 .2643 L
.93425 .26279 L
.93427 .26187 L
.93428 .261 L
.93431 .25998 L
.93434 .26065 L
.93437 .26137 L
.93443 .26299 L
.93446 .26382 L
.93449 .26458 L
.93452 .26753 L
.93455 .27141 L
.93466 .28578 L
.93472 .29324 L
.93476 .29619 L
.93479 .29887 L
.93481 .30005 L
.93484 .30131 L
.9349 .30363 L
.93493 .30444 L
.93496 .3053 L
.93498 .30583 L
.93499 .30709 L
.93502 .30931 L
.9351 .31505 L
.93513 .31845 L
.93516 .32159 L
.93519 .32215 L
.93522 .32215 L
.93525 .32215 L
.93527 .32294 L
.93529 .32448 L
.93532 .32745 L
.93535 .33027 L
.93538 .33151 L
.93541 .33234 L
.93544 .3331 L
.93546 .33416 L
.93549 .33558 L
.93552 .33687 L
.93554 .33837 L
Mistroke
.93558 .33935 L
.93563 .34093 L
.93575 .34909 L
.93578 .35141 L
.93581 .35395 L
.93584 .35571 L
.93587 .35525 L
.93591 .35469 L
.93592 .35441 L
.93594 .35429 L
.93596 .35429 L
.93598 .35429 L
.93601 .35429 L
.93602 .35429 L
.93604 .35477 L
.93607 .356 L
.93611 .35713 L
.93614 .35733 L
.93639 .35941 L
.93641 .36038 L
.93644 .36017 L
.93647 .35996 L
.9365 .35972 L
.93653 .35981 L
.93654 .35995 L
.93656 .36007 L
.93659 .3603 L
.93662 .36169 L
.93668 .36723 L
.93669 .36875 L
.93671 .36956 L
.93674 .37045 L
.93677 .37121 L
.9368 .37175 L
.93681 .37128 L
.93683 .37084 L
.93686 .37 L
.93689 .36934 L
.93692 .37039 L
.93696 .37165 L
.93699 .37254 L
.937 .37203 L
.93702 .37148 L
.93705 .37047 L
.93707 .36991 L
.93709 .3696 L
.9371 .3696 L
.93712 .3696 L
.93715 .3696 L
.93718 .3698 L
Mistroke
.93721 .37081 L
.93725 .37188 L
.93726 .37238 L
.93728 .37266 L
.93731 .37266 L
.93734 .37266 L
.93737 .37266 L
.93739 .36923 L
.93742 .36535 L
.93745 .36157 L
.93748 .36064 L
.93751 .36156 L
.93754 .36242 L
.93756 .36289 L
.93759 .36129 L
.93762 .35955 L
.93765 .35767 L
.93767 .3571 L
.93768 .35677 L
.93771 .35613 L
.93775 .3555 L
.93776 .35486 L
.93778 .3542 L
.93782 .35278 L
.93783 .35208 L
.93785 .35163 L
.93788 .35175 L
.93791 .35187 L
.93794 .35198 L
.93797 .35291 L
.93799 .35394 L
.93802 .35505 L
.93804 .35483 L
.93806 .35342 L
.93809 .35065 L
.93814 .3456 L
.93817 .34259 L
.9382 .33941 L
.93823 .33711 L
.93826 .33734 L
.93829 .33756 L
.93831 .33776 L
.93834 .33446 L
.93836 .33166 L
.93838 .32902 L
.93841 .32393 L
.93844 .32079 L
.93846 .3188 L
.93849 .31669 L
.93855 .31155 L
Mistroke
.93858 .30861 L
.93859 .30698 L
.93861 .30581 L
.93864 .30705 L
.93867 .30819 L
.93869 .30884 L
.9387 .30949 L
.93873 .30637 L
.93877 .30297 L
.93879 .30118 L
.93881 .29988 L
.93882 .29969 L
.93884 .29947 L
.93887 .2991 L
.9389 .29893 L
.93893 .2994 L
.93896 .29985 L
.93899 .30028 L
.93902 .2998 L
.93905 .29924 L
.93928 .2881 L
.93933 .28381 L
.93936 .2814 L
.93939 .2823 L
.93941 .28335 L
.93943 .2845 L
.93944 .28563 L
.93946 .28683 L
.93948 .28722 L
.93949 .28703 L
.93952 .28667 L
.93955 .28634 L
.93958 .2856 L
.93963 .28372 L
.93975 .27945 L
.93997 .26852 L
.94002 .26718 L
.94008 .26588 L
.94011 .26532 L
.94014 .26459 L
.94017 .26102 L
.94019 .25779 L
.94022 .25375 L
.94024 .25209 L
.94026 .25124 L
.94029 .24971 L
.9403 .24889 L
.94032 .24802 L
.94035 .24882 L
.94038 .25056 L
Mistroke
.94044 .25475 L
.94049 .2602 L
.94051 .2617 L
.94052 .26297 L
.94055 .2638 L
.94058 .26452 L
.94061 .2653 L
.94064 .26419 L
.94067 .26249 L
.94069 .26083 L
.94072 .26008 L
.94075 .26104 L
.94078 .2621 L
.9408 .26302 L
.94082 .2633 L
.94085 .2634 L
.94088 .2635 L
.9409 .26365 L
.94093 .2646 L
.94096 .26543 L
.94099 .26633 L
.941 .26704 L
.94102 .26792 L
.94105 .26966 L
.94108 .27123 L
.94111 .27203 L
.94113 .27203 L
.94114 .27203 L
.94117 .27203 L
.9412 .27189 L
.94123 .27154 L
.94126 .27116 L
.94129 .27103 L
.94131 .27143 L
.94132 .2718 L
.94136 .27263 L
.94138 .27352 L
.94141 .27552 L
.94144 .27724 L
.94147 .2791 L
.9415 .27976 L
.94152 .27987 L
.94154 .27994 L
.94155 .28 L
.94158 .28173 L
.94161 .28464 L
.94164 .28774 L
.94166 .29066 L
.94169 .29041 L
.94172 .28997 L
Mistroke
.94175 .28948 L
.9418 .28845 L
.94183 .28786 L
.94186 .28729 L
.94187 .28673 L
.94189 .28613 L
.94192 .28508 L
.94195 .28407 L
.94198 .287 L
.94203 .29379 L
.94206 .29663 L
.94207 .29735 L
.94209 .29802 L
.94212 .29925 L
.94215 .29965 L
.94216 .29733 L
.94218 .29485 L
.94221 .29038 L
.94223 .28765 L
.94225 .28594 L
.94226 .28544 L
.94228 .2849 L
.94231 .28396 L
.94234 .28329 L
.94236 .28387 L
.94237 .2844 L
.94241 .28544 L
.94242 .28596 L
.94244 .28638 L
.94246 .28676 L
.94248 .2871 L
.94249 .28746 L
.94251 .28779 L
.94254 .28739 L
.94257 .28609 L
.9426 .28471 L
.94266 .28225 L
.94269 .28096 L
.94272 .27972 L
.94274 .28008 L
.94275 .2804 L
.94279 .28104 L
.94281 .28159 L
.94284 .28159 L
.94287 .28159 L
.9429 .28159 L
.94293 .28177 L
.94296 .28201 L
.94299 .28226 L
.94301 .28232 L
Mistroke
.94302 .28219 L
.94305 .28196 L
.94308 .28175 L
.9431 .28129 L
.94313 .27981 L
.94316 .27819 L
.94319 .27648 L
.94322 .27736 L
.94324 .27885 L
.94331 .28232 L
.94334 .2842 L
.94337 .28595 L
.94339 .28692 L
.9434 .28634 L
.94344 .28503 L
.9435 .2829 L
.94353 .2821 L
.94356 .28124 L
.94359 .28128 L
.94362 .28213 L
.94365 .28307 L
.94366 .28361 L
.94368 .28348 L
.94371 .28159 L
.94374 .27957 L
.94381 .27661 L
.94387 .27409 L
.94399 .27067 L
.94402 .26966 L
.94404 .2691 L
.94405 .26856 L
.94407 .26758 L
.94409 .26651 L
.94412 .26463 L
.94413 .26348 L
.94415 .26255 L
.94417 .2642 L
.94419 .26569 L
.94422 .2684 L
.94424 .26992 L
.94426 .26939 L
.94428 .26624 L
.94431 .26288 L
.94434 .25985 L
.94437 .26202 L
.94443 .26741 L
.94449 .27194 L
.94452 .27419 L
.94455 .2743 L
.94458 .27303 L
Mistroke
.9446 .2723 L
.94462 .27164 L
.94465 .27134 L
.94466 .27141 L
.94468 .27147 L
.94471 .27158 L
.94474 .27127 L
.94477 .2705 L
.9448 .2698 L
.94482 .26943 L
.94483 .26822 L
.94487 .26536 L
.9449 .26285 L
.94491 .26144 L
.94493 .26165 L
.94496 .26236 L
.94499 .26304 L
.94501 .26351 L
.94504 .26272 L
.94507 .26203 L
.94509 .26128 L
.94513 .26131 L
.94516 .26191 L
.94521 .26309 L
.94524 .26392 L
.94527 .2648 L
.94529 .26531 L
.94531 .26475 L
.94532 .26329 L
.94534 .26191 L
.94537 .25891 L
.94539 .25727 L
.94541 .25635 L
.94544 .25487 L
.94547 .25324 L
.94553 .25035 L
.94556 .24909 L
.94559 .24818 L
.94562 .25005 L
.94565 .25182 L
.94571 .25559 L
.94574 .25727 L
.94578 .25901 L
.94579 .25875 L
.94581 .25846 L
.94584 .25795 L
.94587 .25754 L
.94589 .25842 L
.9459 .25922 L
.94593 .26079 L
Mistroke
.94596 .26224 L
.94599 .26112 L
.94602 .25942 L
.94605 .25756 L
.94608 .2566 L
.9461 .2564 L
.94613 .25618 L
.94616 .25596 L
.94619 .25584 L
.94622 .25571 L
.94625 .2556 L
.94627 .25633 L
.94628 .25735 L
.94632 .25926 L
.94639 .26346 L
.94642 .26531 L
.94643 .26628 L
.94645 .26684 L
.94648 .26556 L
.94651 .26436 L
.94654 .26299 L
.94657 .26284 L
.9466 .26284 L
.94662 .26284 L
.94663 .26284 L
.94666 .26246 L
.94669 .26196 L
.94672 .26153 L
.94675 .26243 L
.94678 .26463 L
.94681 .26669 L
.94684 .26848 L
.94686 .26927 L
.9469 .27019 L
.94693 .27092 L
.94695 .27114 L
.94698 .27136 L
.94701 .27158 L
.94704 .2709 L
.94715 .26872 L
.94718 .26885 L
.94721 .26896 L
.94724 .26776 L
.94727 .26643 L
.94729 .26573 L
.9473 .26519 L
.94732 .26579 L
.94734 .26633 L
.94737 .26732 L
.94739 .26786 L
Mistroke
.9474 .26812 L
.94743 .26766 L
.94746 .26715 L
.94749 .26673 L
.94752 .26778 L
.94758 .27041 L
.94761 .27154 L
.94765 .27243 L
.94768 .27326 L
.94769 .27338 L
.94771 .27296 L
.94774 .27208 L
.94775 .27162 L
.94777 .27112 L
.9478 .27071 L
.94783 .27049 L
.94786 .27024 L
.94789 .26981 L
.94795 .26823 L
.94797 .26781 L
.94799 .26758 L
.94803 .26717 L
.94806 .26679 L
.94809 .26699 L
.9481 .26726 L
.94812 .26752 L
.94816 .26808 L
.94819 .26829 L
.9482 .26836 L
.94822 .26842 L
.94825 .26853 L
.94828 .26921 L
.94829 .26981 L
.94831 .27037 L
.94833 .27104 L
.94834 .27165 L
.94837 .27409 L
.94841 .27754 L
.94844 .28077 L
.94846 .28179 L
.94849 .28046 L
.94853 .27904 L
.94858 .27678 L
.94861 .27563 L
.94864 .27443 L
.94867 .27392 L
.9487 .27343 L
.94875 .27229 L
.94878 .27127 L
.94881 .27031 L
Mistroke
.94883 .26944 L
.94886 .26972 L
.94889 .27022 L
.94892 .27069 L
.94895 .27264 L
.94896 .27408 L
.94898 .27567 L
.94901 .27832 L
.94904 .27936 L
.94907 .27877 L
.94909 .27824 L
.94913 .27751 L
.94914 .27689 L
.94916 .27633 L
.94919 .27522 L
.94922 .27435 L
.94923 .27448 L
.94925 .27461 L
.94929 .27489 L
.94932 .27509 L
.94933 .27509 L
.94935 .27509 L
.94938 .27509 L
.94941 .27552 L
.94944 .27776 L
.94947 .28019 L
.94953 .28617 L
.94956 .28998 L
.94958 .29206 L
.94959 .294 L
.94962 .29489 L
.94964 .29508 L
.94965 .29527 L
.94968 .29563 L
.94971 .2964 L
.94974 .29748 L
.94977 .29865 L
.94979 .30018 L
.94982 .30354 L
.94985 .30755 L
.94987 .30975 L
.94988 .31184 L
.94991 .31355 L
.94994 .31489 L
.95 .31766 L
.95007 .32035 L
.95031 .32996 L
.95034 .33185 L
.95036 .3328 L
.95038 .33241 L
Mistroke
.95041 .33139 L
.95043 .3309 L
.95045 .33045 L
.95048 .33211 L
.9505 .33363 L
.95051 .33507 L
.95057 .3395 L
.9508 .35449 L
.95083 .35522 L
.95086 .35759 L
.95089 .3609 L
.95092 .36455 L
.95094 .36618 L
.95095 .3663 L
.95099 .36658 L
.951 .36671 L
.95102 .36684 L
.95105 .36524 L
.95108 .36303 L
.95111 .36065 L
.95114 .35931 L
.95116 .35941 L
.95119 .35953 L
.95121 .35959 L
.95122 .35984 L
.95125 .36147 L
.95128 .363 L
.95131 .36455 L
.95133 .36486 L
.95136 .36467 L
.95138 .36447 L
.95141 .36424 L
.95144 .36343 L
.95147 .36266 L
.95149 .36194 L
.95152 .36029 L
.95155 .35754 L
.95158 .35463 L
.95161 .3534 L
.95164 .35543 L
.95166 .35735 L
.95172 .36125 L
.95175 .36303 L
.95178 .3649 L
.95181 .36489 L
.95184 .36277 L
.95187 .3605 L
.95188 .35925 L
.9519 .35875 L
.95192 .35857 L
Mistroke
.95193 .35837 L
.95196 .35802 L
.95202 .35747 L
.95205 .35725 L
.95207 .35704 L
.9521 .35705 L
.95212 .35711 L
.95213 .35718 L
.95216 .35728 L
.95219 .35856 L
.95222 .36133 L
.95224 .36386 L
.95227 .36658 L
.9523 .36818 L
.95235 .3707 L
.9524 .37295 L
.95246 .37544 L
.95249 .3769 L
.95252 .37832 L
.95255 .37964 L
.95258 .37936 L
.9526 .37772 L
.95263 .3762 L
.95264 .37526 L
.95266 .37457 L
.95269 .37457 L
.95275 .37457 L
.95278 .37457 L
.95282 .37457 L
.95285 .37457 L
.95286 .37626 L
.95288 .37789 L
.95291 .38116 L
.95293 .38288 L
.95294 .38451 L
.95296 .38445 L
.95298 .38438 L
.95301 .38426 L
.95303 .38415 L
.95307 .3862 L
.95309 .38831 L
.95312 .39028 L
.95315 .38956 L
.95317 .38842 L
.95319 .38719 L
.95321 .38591 L
.95322 .38469 L
.95324 .38463 L
.95326 .38476 L
.95329 .38502 L
Mistroke
.95331 .38516 L
.95332 .38531 L
.95335 .38828 L
.95338 .39155 L
.95341 .39468 L
.95343 .39569 L
.95344 .3963 L
.95347 .39751 L
.9535 .39861 L
.95352 .39889 L
.95353 .3983 L
.95357 .397