      SUBROUTINE SUMM(H1,H2,G1,G2,JJ,K,ELL,KOUT,TJ,
     1  TJ1,N,M,ITER,JOUT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION H1(N),H2(N),G1(N),G2(N),JJ(N)
      INTEGER ELL
      COMMON /UNITS/ IIN,IOUT
C
      ZERO = 0.D0
      WRITE(IOUT,8000) ITER
C  WRITE ACTIVE SET
      WRITE(IOUT,8010) (I,I=1,N)
      WRITE(IOUT,8020) (JJ(I),I=1,N)
C  WRITE OPTIMAL PRIMAL SOLUTION
      WRITE(IOUT,8030)
      WRITE(IOUT,8040) (I,H1(I),H2(I),I=1,N)
C  WRITE OPTIMAL DUAL SOLUTION
      WRITE(IOUT,8050)
      DO 300 I=1,M
      DO 100 J=1,N
      IF(JJ(J).NE.I) GO TO 100
      J1 = J
      GO TO 200
  100 CONTINUE
C  HERE, CONSTRAINT I MUST BE INACTIVE
      WRITE(IOUT,8040) I,ZERO,ZERO
      GO TO 300
  200 WRITE(IOUT,8040) I,G1(J1),G2(J1)
  300 CONTINUE
      IF(JOUT.EQ.1) GO TO 400
C
C  RESULTS FROM STEP 2
      IF(KOUT.EQ.1) WRITE(IOUT,8060) JJ(K),K
      IF(KOUT.EQ.2) WRITE(IOUT,8070) ELL,ELL
      IF(JOUT.GT.0) GO TO 400
C  RESULTS FROM STEPS 3 AND 4
      IF(KOUT.EQ.1) WRITE(IOUT,8080) ELL,ELL
      IF(KOUT.EQ.2) WRITE(IOUT,8090) JJ(K),K
C
  400 ITER1 = ITER + 1
      WRITE(IOUT,8100) ITER,TJ,ITER1,TJ1
      IF(JOUT.EQ.1) WRITE(IOUT,8110)
      IF(JOUT.EQ.2) WRITE(IOUT,8120) TJ1
      IF(JOUT.EQ.3) WRITE(IOUT,8130) TJ1
      RETURN
C
 8000 FORMAT(///,18X,'ITERATION',I4)
 8010 FORMAT(/,20X,10I3)
 8020 FORMAT(10X,'ACTIVE SET',10I3)
 8030 FORMAT(/,15X,'OPTIMAL PRIMAL SOLUTION',
     1  /,10X,'I',6X,'H1(I)',7X,'H2(I)')
 8040 FORMAT(8X,I3,2F12.4)
 8050 FORMAT(//,15X,'OPTIMAL DUAL SOLUTION',
     1   /,10X,'I',6X,'G1(I)',7X,'G2(I)')
 8060 FORMAT(//,' STEP',/,2X,'2.1',2X,'NEW ',
     1  'INACTIVE CONSTRAINT IS',I3,3X,'K =',I3)
 8070 FORMAT(//,' STEP',/,2X,'2.2',2X,'NEW ',
     1  '  ACTIVE CONSTRAINT IS',I3,3X,'L =',I3)
 8080 FORMAT(2X,'3',4X,'NEW   ACTIVE CONSTRAINT',
     1  ' IS',I3,3X,'L =',I3)
 8090 FORMAT(2X,'4',4X,'NEW INACTIVE CONSTRAINT',
     1  ' IS',I3,3X,'K =',I3)
 8100 FORMAT(//,15X,'CRITICAL INTERVAL:',/,6X,
     1  'T(',I2,') =',F9.4,3X,'T(',I2,') =',F9.4)
 8110 FORMAT(/,6X,'END OF PARAMETRIC INTERVAL')
 8120 FORMAT(/,6X,'PROBLEM IS UNBOUNDED FROM',
     1  ' BELOW FOR',/,10X,'  T GREATER THAN',
     2  F9.4)
 8130 FORMAT(/,6X,'PROBLEM HAS NO FEASIBLE',
     1  ' SOLUTION FOR',/,10X,' T GREATER THAN',
     2  F9.4)
      END
