      SUBROUTINE PDSOLN(JOUT,X,N,M,R,OBJ,C,DINV,JJ)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(N),C(N),DINV(N,N),JJ(N)
      INTEGER R
      COMMON /UNITS/ IIN,IOUT
C
      MTOT = M + R
      ZERO = 0.D0
      IF(JOUT.GE.2) GO TO 600
      WRITE(IOUT,8000) OBJ
C
C  WRITE OPTIMAL PRIMAL SOLUTION
      WRITE(IOUT,8010)
      DO 100 I=1,N
  100 WRITE(IOUT,8020) I,X(I)
C
C  WRITE OPTIMAL DUAL SOLUTION
      WRITE(IOUT,8030)
      DO 500 I=1,MTOT
      DO 200 J=1,N
      IF(JJ(J).NE.I) GO TO 200
      K = J
      GO TO 300
  200 CONTINUE
C  HERE, CONSTRAINT I MUST BE INACTIVE, OR,
C  REDUNDANT
      IF(I.LE.M) WRITE(IOUT,8040) I,ZERO
      IF(I.GT.M) WRITE(IOUT,8050) I
      GO TO 500
  300 CONTINUE
      SUM = 0.D0
      DO 400 J=1,N
  400 SUM = SUM + C(J)*DINV(J,K)
      SUM = - SUM
      WRITE(IOUT,8040) I,SUM
  500 CONTINUE
      RETURN
  600 CONTINUE
      IF(JOUT.EQ.2) WRITE(IOUT,8060)
      IF(JOUT.EQ.3) WRITE(IOUT,8070)
      RETURN
C
 8000 FORMAT(//,6X,'OPTIMAL OBJECTIVE FUNCTION ',
     1  'VALUE IS',F12.5)
 8010 FORMAT(//,17X,'OPTIMAL PRIMAL SOLUTION')
 8020 FORMAT(18X,'X(',I2,') =',F14.7)
 8030 FORMAT(//,18X,'OPTIMAL DUAL SOLUTION')
 8040 FORMAT(18X,'U(',I2,') =',F14.7)
 8050 FORMAT(10X,'CONSTRAINT',I2,5X,
     1  'IS REDUNDANT')
 8060 FORMAT(//,6X,'PROBLEM IS UNBOUNDED FROM ',
     1  'BELOW')
 8070 FORMAT(//,6X,'PROBLEM HAS NO FEASIBLE ',
     1  'SOLUTION')
      END
