function [A1,n1,b1] = lpmovie(A,n,b,digits,noscroll)

% LPMOVIE [A1,n1,b1] = LPMOVIE(A)
%         [A1,n1,b1] = LPMOVIE(A,n,b)
%         [A1,n1,b1] = LPMOVIE(A,n,b,digits)
%         [A1,n1,b1] = LPMOVIE(A,n,b,digits,clr)
% This routine allows the user to input a dictionary for LP and to specify
% pivot elements. The pivot is done and the new dictionary is displayed.
% A is the coefficient matrix for dictionary (objective coefficients on bottom)
%
% The following are optional arguments:
%  n : vector of nonbasis variable subscripts
%  b : vector of basis variable subscripts
%  digits : specify the field width for each real number.
%           If insufficient space is provided for a number,
%           the field is filled with '*'s.
%  clr : clear the screen before each pivot. Useful for large
%        dictionaries that cause screen scrolling.
%
% Version 1.1: Returns A1 : final dictionary
%                   n1,b1 : variable subscripts for final dictionary
%         1.2: Allow equation format for output (see lpmovie2)

% NOTE: This program does not make any choices on its own (mail optimize@watmath
%       lp library for such routines)
% David M. Mates, University of Waterloo,  29/1/93
% Version 1.1 : David M. Mates, 12/2/93
%         1.2 : David M. Mates,  9/7/93

% Initialize default optional arguments
% and some minor idiot proofing ... very dull
perr = 0; % a flag to tell iut error type.. probably shouldn't bother
hor = 2; vert = 1;  % vert = blanks lines on top of screen, hor = left margin
msg = 'ERROR in ==> lpmovie.m                                         '; 
err = 0;
if nargin==0 
 msg = [msg;'-Coefficient matrix missing                                    '];
 err=err+1;
else 
 [Am,An] = size(A);
 if nargin==1 b=1:Am-1; n=Am:Am+An-2;
 elseif nargin==2
   msg=[msg;'-Neither or both of the n and b subscripts must be specified   '];
   err = err + 1;
 elseif length(b)~=Am-1 | length(n)~=An-1
   msg=[msg;'-Incorrect number of subscripts specified in n or b            '];
   err = err + 1;
 end
 if nargin < 4 digits = 8; end
 if nargin == 5  clr = 1; else clr = 0; end
 if digits > 15 digits = 15; end
% output in equation form instead of dictionary?
 if digits < 0 
    eqn = 1;
    digits = -digits;
 else
    eqn = 0;
 end
end
if err disp(msg); return; end

% loops to draw dictionaries
clc;
if eqn 
   drawdic2(A,n,b,digits,vert,hor);
else 
   drawdic(A,n,b,digits,vert,hor);
end
while input('Input 0 to quit, 1 to do a pivot ');
   [leavevar, lerr] = input1(b,'Input leaving variable (subscript index) ');
   leaveindex = find(b==leavevar);
   [entervar, eerr] = input1(n,'Input entering variable (subscript index) ');
   enterindex = find(n==entervar) + 1; % +1 to skip the b column
   if A(leaveindex,enterindex) == 0
      disp('You can not pivot on a zero element');
      err = err + 1; perr = 1;
   else
      if clr | lerr | eerr | perr clc; perr = 0;
      else home; end
      [A,n,b] = pivot(A,n,b,enterindex,leaveindex);
      if eqn 
         drawdic2(A,n,b,digits,vert,hor);
      else 
         drawdic(A,n,b,digits,vert,hor);
      end
   end
end
% Strip off column X0
b1 = b;
if any(n==0)
   j = length(n);
   i = find(n==0);
   A1 = A(:,1:i);
   n1 = n(1:i-1);
   A1(:,i+1:j) = A(:,i+2:j+1);
   n1(i:j-1) = n(i+1:j);
else
   A1 = A;
   n1 = n;
end
disp(blanks(4)'); % crude clean up... not very good
