function drawdic2(A,n,b,digits,vert,hor)
% DRAWDIC2  Simply draw an LP on the screen in easy to read equation form. 
%	    If there is not enough room to print a given entry, the field is 
%	    filled with '*'. See also lpmovie, drawdic

% David M. Mates, University of Waterloo,  9/7/93

[Am,An] = size(A);
vspace = blanks(vert)'; % vertical spacing
hspace = blanks(hor);   % horizontal spacing
disp(vspace);           % move cursor down some lines

% figure out total width needed by basis variables
bwid = 0;
for i=1:Am-1
   bwid = bwid + ((b(i) > 9)+5);
end

% draw the dictionary in equation form
for i=1:Am-1
   lead = [];
   for k=1:i-1
      for j=1:((b(k) > 9)+5)
         lead = [lead,' '];
      end
   end
   trail = [];
   for j=1:bwid-length(lead)-((b(i) > 9)+5)
      trail = [trail,' '];
   end
   line = [lead,num2strfix(1,2),'X',int2str(b(i)),trail,' '];
   for j=2:An 
      line = [line,num2strfix(-A(i,j),digits),'X',int2str(n(j-1)),' '];
   end
   line = [line,'= ',num2strfix(A(i,1),digits)];
   disp([hspace,line]);
end
t = length(line); 
line = [];
for i=1:t
   line=[line,'-'];
end
disp([hspace,line]);
line = [num2strfix(0,2),'X',int2str(b(1)),' '];
for i = 2:Am-1
   line = [line,num2strfix(0,2),'X',int2str(b(i)),' '];
end
for j=2:An
   line = [line,num2strfix((-A(Am,j)),digits),'X',int2str(n(j-1)),' '];
end
line = [line,'= ',num2strfix(A(Am,1),digits)];
disp([hspace,line]);
disp(vspace);
