function fixstr = num2strfix(num,digits)
% NUM2STRFIX fixstr = NUM2STRFIX(num,digits)
%            The string equivalent of "num" is returned.
%	     If "num" > 0 then a leading '+' is added. "num" will have 
%	     a fixed size of "digits"

% David M. Mates, University of Waterloo, 29/1/93

tstr = num2str(num);
if (num >= 0) tstr = ['+',tstr]; end
if (length(tstr) < digits)
   fixstr = [blanks(digits-length(tstr)),tstr];
elseif length(tstr) > digits
   fixstr = [];
   for i=1:digits fixstr = [fixstr,'*']; end
else
   fixstr = tstr;
end
