function [A1,n1,b1] = lpmovie2(A,n,b,digits,noscroll)

% LPMOVIE2 [A1,n1,b1] = LPMOVIE2(A)
%          [A1,n1,b1] = LPMOVIE2(A,n,b)
%          [A1,n1,b1] = LPMOVIE2(A,n,b,digits)
%          [A1,n1,b1] = LPMOVIE2(A,n,b,digits,clr)
% This routine allows the user to input a dictionary for LP and to specify
% pivot elements. The pivot is done and the new dictionary is displayed in
% equation form.
% A is the coefficient matrix for dictionary (objective coefficients on bottom)
%
% The following are optional arguments:
%  n : vector of nonbasis variable subscripts
%  b : vector of basis variable subscripts
%  digits : specify the field width for each real number.
%           If insufficient space is provided for a number,
%           the field is filled with '*'s.
%  clr : clear the screen before each pivot. Useful for large
%        dictionaries that cause screen scrolling.
%
% Version 1.1: Returns A1 : final dictionary
%                   n1,b1 : variable subscripts for final dictionary
%         1.2: Output in equation format

% NOTE: This program does not make any choices on its own (mail optimize@watmath
%       lp library for such routines)
% David M. Mates, University of Waterloo,  29/1/93
% Version 1.1 : David M. Mates, 12/2/93
%         1.2 : David M. Mates,  9/7/93

% Initialize default optional arguments
% and some minor idiot proofing ... very dull
msg = 'ERROR in ==> lpmovie2.m                                         '; 
err = 0;
if nargin==0 
 msg = [msg;'-Coefficient matrix missing                                    '];
 err=err+1;
else 
 [Am,An] = size(A);
 if nargin==1 b=1:Am-1; n=Am:Am+An-2;
 elseif nargin==2
   msg=[msg;'-Neither or both of the n and b subscripts must be specified   '];
   err = err + 1;
 elseif length(b)~=Am-1 | length(n)~=An-1
   msg=[msg;'-Incorrect number of subscripts specified in n or b            '];
   err = err + 1;
 end
 if nargin < 4 digits = 8; end
end
if err disp(msg); return; end
if nargin == 5 
   if nargout == 1 
      [A1] = lpmovie(A,n,b,-digits,noscroll);
   else 
      [A1,n1,b1] = lpmovie(A,n,b,-digits,noscroll);
   end
else
   if (nargout == 1 | nargout == 0)
      [A1] = lpmovie(A,n,b,-digits);
   else
      [A1,n1,b1] = lpmovie(A,n,b,-digits);
   end
end
