##################################################################################################################################################
# Sets
##################################################################################################################################################

set Topics;
set Scenarios;
          
##################################################################################################################################################
# Decision Variables.
##################################################################################################################################################

var x {t in Topics} >= 0; # Amount of preparation-time to assign to each topic. (1st stage)
var y {t in Topics, s in Scenarios} >= 0; # Amount of thinking-time to assigned to each topic in each scenario. (2nd stage)
var M {t in Topics, s in Scenarios} >= 0; # Number of marks attained for each topic in each scenario. (2nd stage)

##################################################################################################################################################
# Parameters.
##################################################################################################################################################

param worth {t in Topics, s in Scenarios}; # Maximum number of amounts available for each topic.
param diff {t in Topics, s in Scenarios}; # Difficulty rating of each topic in each scenario.
param req {t in Topics}; # Scaling term for number of minutes required to get full-marks.
param think_avail {s in Scenarios}; # Thinking time available during the exam in each scenario.
param prep_avail; # Preparation time available before the exam.
param prob {s in Scenarios}; # Probability of each scenario occuring.
param think_const; # Value of thinking-time in exam.

##################################################################################################################################################
# Objective Function.
##################################################################################################################################################

# The objective is to maximize total marks scored on the midterm.

maximize Total_Marks:
          sum {s in Scenarios, t in Topics} prob[s]*M[t,s];


##################################################################################################################################################
# Constraints.
##################################################################################################################################################

# Relates total marks obtained with study-time.
subject to Study_Time {t in Topics, s in Scenarios}:
     req[t]*diff[t,s]*M[t,s] <= worth[t,s]*(x[t] + think_const*y[t,s]);

# Bounds the number of marks obtained by the number available.
subject to Max_Marks {t in Topics, s in Scenarios}:
     M[t,s] <= worth[t,s];

##################################################################################################################################################

# Ensure that the available of study time is not exceeded:

# Prep time:
subject to Max_Prep:
     sum {t in Topics} x[t] <= prep_avail;

# Think time:
subject to Max_Think {s in Scenarios}:
     sum {t in Topics} y[t,s] <= think_avail[s];
