function [A,n,b] = pivot(Ai,ni,bi,enter,leave)
% PIVOT   [A,n,b] = pivot(Ai,ni,bi,enter,leave)
%         Preforms a standard dictionary pivot on element A(leave,enter)
% NOTE: Assumes pivot is nonzero

% David M. Mates, University of Waterloo, 29/1/93

[Am,An] = size(Ai);
A(leave,:) = -Ai(leave,:)/Ai(leave,enter);  % pivot row
A(leave,enter) = 1/Ai(leave,enter);         % old pivot element
for i=1:Am
   if i ~= leave
      A(i,:) = Ai(i,:) + Ai(i,enter)*A(leave,:);
   end
end
A(:,enter) = Ai(:,enter)*A(leave,enter);   % update new nonbasic column
A(leave,enter) = 1/Ai(leave,enter);        % old pivot element (yuck)
b = bi; b(leave) = ni(enter-1);
n = ni; n(enter-1) = bi(leave);
