function drawdic(A,n,b,digits,vert,hor)
% DRAWDIC  Simply draw an LP on the screen in easy to read dictionary form. 
%	   If there is not enough room to print a given entry, the field is 
%	   filled with '*'. See also lpmovie

% David M. Mates, University of Waterloo,  29/1/93

[Am,An] = size(A);
vspace = blanks(vert)'; % vertical spacing
hspace = blanks(hor);   % horizontal spacing
disp(vspace);           % move cursor down some lines
for i=1:Am-1
   if any(b > 9) & length(int2str(b(i))) == 1 sp = '  '; else sp = ' '; end
   line = ['X',int2str(b(i)),sp,'= ',num2strfix(A(i,1),digits)];
   for j=2:An 
      line = [line,' ',num2strfix(A(i,j),digits),'X',int2str(n(j-1))];
   end
   disp([hspace,line]);
end
t = length(line); 
line = [];
for i=1:t
   line=[line,'-'];
end
disp([hspace,line]);
if any(b > 9) sp = '   '; else sp = '  '; end
line = ['z',sp,'= ',num2strfix(A(Am,1),digits)];
for j=2:An
   line = [line,' ',num2strfix(A(Am,j),digits),'X',int2str(n(j-1))];
end
disp([hspace,line]);
disp(vspace);
