% ------------------------------------------------------------------------
% Demonstration package for regularization algorithms.
%
% This requires Hansen package to be installed, more specifically blur
% and shaw functions should be present.
%
% ------------------------------------------------------------------------
% Developed by Oleg Grodzevich as a part of Master of Mathematics Thesis,
% University of Waterloo, Combinatorics and Optimization department.
%
% E-mail: illinar@mindon.net
% ------------------------------------------------------------------------

clear all;
close all;
m = 20; n = m*m;

[G, d_bar, x_bar] = blur(m, 5, 1);
[U,S,V] = svd(full(G));
s = diag(S);

A = G'*G;

fig_res = figure; set(fig_res, 'Name', 'Relative accuracy results');

results = [];
for i = 1:n
  r = normrnd(0,0.05,n,1);
  e = zeros(size(U(:,1)));

  for j = 1:i, e = e + r(j)*U(:,j); end

  d = d_bar + e;
  a = G'*d;
  x = A\a;

  ra = 100*norm(x - x_bar)/norm(x_bar);
  results = [results; ra];
  disp(['>> rel.acc. = ', num2str(ra), ' ', num2str(norm(x-x_bar))]);
end

plot ((1:n), results, 'ko', 'MarkerSize', 5);
xlabel ('instance, k');
ylabel ('relative accuracy \times 100');
