function [norm_x, norm_r, rel_acc] = l_calc (G, d, x_bar)

% ------------------------------------------------------------------------
% Calculate L-curve alongside with the ideal Tikhonov solution
% >> adopted from A. Nemirovski code
%
% ------------------------------------------------------------------------
% Developed by Oleg Grodzevich as a part of Master of Mathematics Thesis,
% University of Waterloo, Combinatorics and Optimization department.
%
% E-mail: illinar@mindon.net
% ------------------------------------------------------------------------

reg     = 1.e-12;               % regularization parameter
reg_par = [];                   % history on regularization parameter
norm_x  = [];
norm_r  = [];
rel_acc = [];
nx_bar  = norm(x_bar);

GG      = G'*G; 
Grhs    = G'*d;
Gn      = size(GG,1);
GG2     = sparse(GG);
diagGG  = diag(GG);

while reg < 0.5
  reg_par         = [reg_par;reg];
  GGdiagr         = diagGG+reg*ones(Gn,1);
  GG2(1:Gn+1:end) = GGdiagr;
  Ch              = chol(GG2);  % cholesky decomposition
  tmp             = Ch\(Ch'\Grhs);
  norm_x          = [norm_x  ; norm(tmp)];
  norm_r          = [norm_r  ; norm(G*tmp-d)];
  rel_acc         = [rel_acc ; norm(tmp-x_bar)/nx_bar];
  reg             = sqrt(sqrt(10))*reg;
end
