function l_build (G, d, x_bar)

% ------------------------------------------------------------------------
% Build L-curve
%
% ------------------------------------------------------------------------
% Developed by Oleg Grodzevich as a part of Master of Mathematics Thesis,
% University of Waterloo, Combinatorics and Optimization department.
%
% E-mail: illinar@mindon.net
% ------------------------------------------------------------------------

disp(['>> Wait till L-curve is calculated...']);
[norm_x, norm_r, rel_acc] = l_calc (G, d, x_bar);

% find out the point of ideal Tikhonov solution
[Y,I] = min(rel_acc);
ideal = norm_x(I(1));

% build L-curve
loglog(norm_x, rel_acc, '-b', norm_x, norm_r, '-m', [ideal, ideal], ...
       [1.5*max(norm_r), 0.7*min(norm_r)], '-g');

disp(['>> Ideal Tikhonov accuracy: ', num2str(min(rel_acc)*100), '%']);
