// -----------------------------------------------------------------------
// ubidiagqtx.c, MATLAB version 6+
//
// The calling syntax is:
//
// y = ubidiagqtx (Q, x)
//
// This procedure computes the product: y = Q'*x
// The matrix Q must originate from the procedure ubidiagqr.
//
// original code by Urs von Matt     October 26, 1994
// this     code by Oleg Grodzevich     July 05, 2004
// -----------------------------------------------------------------------

#include <math.h>
#include "mex.h"
#include "blas.c"

static void ubidiagQTx (int n, double* Q, double* x, double* y)
{
    int i, ldQ ;
    ldQ = n*2 - 1 ;

    for (i = 0 ; i < n*2 ; ++i) y[i] = x[i] ;
    rot (&y[0], &y[n], Q[0], Q[ldQ]) ;

    for (i = 1 ; i < n   ; ++i)
    {
        rot (&y[n+i], &y[n+i-1], Q[i*2-1], Q[i*2-1+ldQ]) ;
        rot (&y[  i], &y[n+i],   Q[i*2],   Q[i*2  +ldQ]) ;
    }
}

// input arguments
#define Q prhs[0]
#define x prhs[1]

// output arguments
#define y plhs[0]

void mexFunction (int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[])
{
    int n ;

    // check for proper number of arguments
    if (nrhs != 2) mexErrMsgTxt ("ubidiagQTx requires two input arguments.")  ; else
    if (nlhs != 1) mexErrMsgTxt ("ubidiagQTx requires one output arguments.") ;

    // check the dimensions of x
    n =  mxGetM (x) / 2 ;
    if ((mxGetM (x) != n*2) || (mxGetN (x) != 1))
        mexErrMsgTxt ("x must be an (2*n)-by-1 matrix.") ;

    // check the dimensions of Q
    if ((mxGetM (Q) != n*2-1) || (mxGetN (Q) != 2))
        mexErrMsgTxt ("Q must be an (2*n-1)-by-2 matrix.") ;

    // create matrices for the return arguments
    y = mxCreateDoubleMatrix (n*2, 1, mxREAL) ;

    // do the actual computations in a subroutine
    ubidiagQTx (n, mxGetPr (Q), mxGetPr (x), mxGetPr (y)) ;
}
