// -----------------------------------------------------------------------
// lbidiagqtx.c, MATLAB version 6+
//
// The calling syntax is:
//
// y = lbidiagqtx (Q, x)
//
// This procedure computes the product: y = Q'*x
// The matrix Q must originate from the procedure lbidiagqr.
//
// original code by Urs von Matt     October 26, 1994
// this     code by Oleg Grodzevich     July 05, 2004
// -----------------------------------------------------------------------

#include <math.h>
#include "mex.h"
#include "blas.c"

static void lbidiagQTx (int n, double* Q, double* x, double* y)
{
    int i, ldQ ;
    ldQ = n*2  ;

    for (i = 0 ; i <= n*2 ; ++i) y[i] = x[i] ;
    for (i = 0 ; i <  n   ; ++i)
    {
        rot (&y[i], &y[n+i+1], Q[i*2],   Q[i*2  +ldQ]) ;
        rot (&y[i], &y[  i+1], Q[i*2+1], Q[i*2+1+ldQ]) ;
    }
}

// input arguments
#define Q prhs[0]
#define x prhs[1]

// output arguments
#define y plhs[0]

void mexFunction (int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[])
{
    int n ;

    // check for proper number of arguments
    if (nrhs != 2) mexErrMsgTxt ("lbidiagQTx requires two input arguments.")  ; else
    if (nlhs != 1) mexErrMsgTxt ("lbidiagQTx requires one output arguments.") ;

    // check the dimensions of x
    n = (mxGetM (x) - 1) / 2 ;
    if ((mxGetM (x) != n*2+1) || (mxGetN (x) != 1))
        mexErrMsgTxt ("x must be an (2*n+1)-by-1 matrix.") ;

    // check the dimensions of Q
    if ((mxGetM (Q) != n*2) || (mxGetN (Q) != 2))
        mexErrMsgTxt ("Q must be an (2*n)-by-2 matrix.") ;

    // create matrices for the return arguments
    y = mxCreateDoubleMatrix (n*2+1, 1, mxREAL) ;

    // do the actual computations in a subroutine
    lbidiagQTx (n, mxGetPr (Q), mxGetPr (x), mxGetPr (y)) ;
}
