/*  C. L. Lawson, R. J. Hanson, D. R. Kincaid and F. T. Krogh,
    Basic Linear Algebra Subprograms for Fortran Usage,
    ACM Trans. Math. Softw., 5 (1979), pp. 308--325.

    J. J. Dongarra, C. B. Moler, J. R. Bunch and G. W. Stewart,
    LINPACK Users' Guide,
    SIAM Publications, Philadelphia, 1979.  */


static void rotg (x1, x2, c, s)
  double *x1, *x2, *c, *s;

/* construct a Givens plane rotation */

{ double temp;

  if (*x2 == 0.0) {
    *c = 1.0;  *s = 0.0;
  }
  else if (*x1 == 0.0) {
    *c = 0.0;  *s = 1.0;
  }
  else if (fabs (*x1) > fabs (*x2)) {
    temp = -(*x2 / *x1);
    *c = 1.0 / sqrt (1.0 + temp * temp);
    *s = *c * temp;
  }
  else {
    temp = -(*x1 / *x2);
    *s = 1.0 / sqrt (1.0 + temp * temp);
    *c = *s * temp;
  };
  *x1 = *c * *x1 - *s * *x2;
  *x2 = 0.0;
}



static void rot (x1, x2, c, s)
  double *x1, *x2, c, s;

/* apply a Givens plane rotation */

{ double temp;

  temp = c * *x1 - s * *x2;
  *x2  = s * *x1 + c * *x2;
  *x1  = temp;
}
