function okay = psd_feas( X,y, Z, C, a, store_a, nonz);
% check feasibility and interiority of X,y,Z
% okay = 0 means everything is fine
% call: okay = psd_feas( X,y, Z, C, a, store_a, nonz);

[n, n1] = size(C);
okay = 0;
tolerance = 1e-10;
posdef = pd_check( X);
if posdef == 0, okay = 1; disp('X not positive definite.'); end
if norm( op_a( X, store_a, nonz) - a) > tolerance,
        okay = 1; disp('X violates A(X)=a.'); end;
posdef = pd_check( Z);
if posdef == 0, okay = 1; disp('Z not positive definite.'); end
Z1 = op_at( y, store_a, nonz, n) - C;
if norm(Z-Z1,1) > tolerance,
        okay = 1; disp('Z violates A^t(y)-C=Z.'); end;
