function  matrix = op_at( y, store_a, nonz, n)
% evaluate A'(y) .. A is stored in store_a and nonz; dimension n needed
% call:  matrix = op_at( y, store_a, nonz, n)

[ m, m1] = size( nonz);         % dimension of dual
matrix = zeros( n);             % initialise
last = 0;
for i = 1 : m;
        first = last + 1;
        last  = first + nonz( i) - 1;
        for j = first : last;
                i1 = store_a( 1, j); i2 = store_a( 2, j); w = store_a(3,j);
                matrix( i1, i2) = matrix( i1, i2) + w * y( i);
                matrix( i2, i1) = matrix( i1, i2);
                end;
        end;
