	subroutine loadmat( type, mrows, ncols, imagf, namlen, name,
     $			rpart, ipart, lunit, irec, rdflg )
c
c LOADMAT - A Fortran subroutine that reads a double-precision matrix
c           from a data file in the .MAT-file format used by MATLAB.
c
c For more information consult LOAD in the reference section of the MATLAB
c users guide.  See also LOADMAT.FOR, TESTLS.FOR, and FORMAT.FOR.
c
c	Description of inputs:
c
c	lunit	- logical unit number of input file
c
c
c	Description of outputs:
c
c	type	- matrix type flag; considering the type flag as a
c		  decimal integer the ones decimal place is used to
c		  indicate numeric or textual interpretation of the
c		  matrix data (0 for numeric or 1 for textual); 
c		  the 1000's decimal place is used to indicate the
c		  machine format for the matrix data (0 for Intel 8086 
c		  based machines, 1 for Motorola 68000 based machines,
c		  and 2 for Vax d format). A flag of 1000 indicates 
c		  numeric data in a 68000 machine format and a flag of
c		  1001 indicates textual interpretation of the 68000
c		  machine format data.
c	mrows	- number of rows in matrix
c	ncols	- number of columns in matrix
c	imagf	- imaginary flag; 0 for no imaginary part or 1 if the 
c		  data has an imaginary part
c	namlen	- number of characters in matrix name plus 1 (for zero 
c		  byte string terminator)
c	name	- character array holding the matrix name. (Be sure 
c		  character array has room for the zero byte terminator)
c	rpart	- real part of matrix (mrows x ncols double precision 
c		  elements stored column wise)
c	ipart	- imaginary part of matrix (only used if imagf = 1)
c	lunit	- logical fortran unit
c	irec	- direct access record counter (set to 1 for a start
c		  from the beginning of the file)
c	rdflg	- read status flag; = 0 good read, = 1 end of file, 
c		  = -1 error reading file
c
c
c	NOTES : THE OUTPUT FILE MUST BE OPENED WITH THE FOLLOWING
c		STATEMENT:
c		open(unit=lunit, file='file_name', form='unformatted',
c			access='direct', recl=1) 
c
c
c	NOTES : 
c
c	     o  THE OUTPUT FILE MUST BE OPENED WITH THE FOLLOWING STATEMENT:
c		  open(unit=lunit, file='file_name', form='unformatted',
c			  access=direct, recl=1) 
c
c	     o	Each call to this routine will read another MATLAB
c		matrix until an error occurs or an end-of-file is 
c		reached.
c
c	Author: S.N. Bangert 5-31-85
c	Revised 5-27-86 SNB
c
c  20 byte header
	integer  type, mrows, ncols, imagf, namlen
c
c  character string for name (length of name plus one)
	character  name(*)*1
c
c  double precision data arrays for example
	double precision  rpart(*), ipart(*)
c
c  output file logical unit number
	integer lunit
c
c  read flag
	integer  rdflg
c
c  direct access record counter
	integer irec
c
c
c  read header
	if (readc(lunit, irec, 4, type)) 998,10,999
10	if (readc(lunit, irec, 4, mrows)) 998,20,999
20	if (readc(lunit, irec, 4, ncols)) 998,30,999
30	if (readc(lunit, irec, 4, imagf)) 998,40,999
40	if (readc(lunit, irec, 4, namlen)) 998,50,999
50	if (readc(lunit, irec, namlen, name)) 998,60,999
c
60	mn = mrows*ncols
c
	if (readc(lunit, irec, 8*mn, rpart)) 998,70,999
c
70	if ( imagf .eq. 1 ) then 
		if (readc(lunit, irec, 8*mn, ipart)) 998,80,999
	end if
c
c set read flag to ok and return
80	rdflg =0
	return
c
c error during read
998	rdflg = -1
	return
c
c  end of file
999	rdflg = 1
	return
	end
	integer function readc( lunit, irec, nc, carray )
c
	integer lunit, nc,irec 
c
	character carray(*)*1
c
	do 10 i=1,nc
		read(lunit,rec=irec,err=998,end=999) carray(i)
		irec = irec + 1
10	continue
c
	readc = 0
	return
998	readc = -1
	return
999	readc = 1
	return
	end
                                                                                                                                                                                                                                                                                                                                                                      