function x = qls(A,b)
%SSNE	Solution of sparse linear least squares problems.
%       @(#)qls.m Version 1.6 6/23/93
%       Pontus Matstoms, Linkoping University.
%       e-mail: pomat@math.liu.se
%
%       x=qls(A,b) solves the sparse linear least squares problem
%                    min ||Ax-b||
%                     x          2
%       using QR factorization and application of Q to the right-hand 
%       side b.

[m,n]=size(A);

% Minimum-degree ordering of A.

q=colmmd(A);
A=A(:,q);

[R,p,c]=sqr(A,b);

% Resulting column permutation.

Pc=q(p);

% Compute the least squares solution.

x=R\c;

% Permute the computed solution

x(Pc)=x;


