% Calling program for main.m - to solve 
%         approx closest Euclidean distance matrix problem.
%  Generates random matrices A,H symmetric and >= 0 elementwise.
%   Solves  min ||H.*(D-A)|| s.t. D is a distance matrix
%
% USER:  Can change the following parameters below:
%   n  -  dimension of matrices H and A
%   spH  -  percentage nonzeros in H and A (excluding diagonal)
%   noprobs  - number of problems to solve
%   toler    - tolerance value for relative duality gap, i.e. stopping
%                   criteria for interior-point method
%   algor    -  1 for QR solution of lss using qls.m
%               2  for NAG with Lanczos approach for lss solution
%
%  OUTPUT: Output is saved, after each problem, in data.mat
%            X      -  primal optimum matrix
%            Lam    -  dual optimum matrix
%             D     -  optimal distance matrix
%          itersum  -  iteration count for all problems - saved
%          optvals   -  optimal values for all problems  - saved
%%%%%%%%%%%%%%%%%%%%%%%
clear all
profile on
%warning off    % in matlab 5 only
%profile main    % in matlab 5 only
n=42;
spH=.5;
noprobs=1;
toler=1*10^(-9);
algor=1;         % QR or Lanczos
kind=1;     %   1 indicates random A generated
            %   2 indicates that A is a distance matrix so optval=0
            %      in this case H = ones.
            %   2 indicates that A has banded structure
%%%%%%%%%%%%%%%%%%%%%%%
%Initialization:
rand('seed',sum(100*clock));  
randn('seed',sum(100*clock));
itersum=[];
optvals=[];
rankXs=[];
%%%%%%%%%%%%%%%%%%%%%%%
%Generate and solve noprobs problems
for ii=1:noprobs,
   % for fixed seed, use next 3 lines
   % iseed=ii;             
   % randn('seed',iseed);
   % rand('seed',iseed);
  disp(['generating test problem number and dim : ' ...
   ' prob no. ',num2str(ii),'  of  ',num2str(noprobs), ' and dim=',num2str(n)]);
  tg=cputime;
  if kind==1,   % random problem
    A=sprandsym(n,spH);
    A=abs(A);
    A=sparse(A-diag(diag(A)));
    A=.5*sparse(A+A');
    if spH ==1,  % dense case
         H=randn(n);
       else
         H=sprandsym(n,spH);
    end
    H=abs(H);   % nonnegative weights
    H=sparse(H+H')/2;
  %%%%%%%%%%%%beginning of special structure problems
  elseif kind==2,   % A is a distance matrix
    H=ones(n);
    kk=floor(n/2);
    x=rand(n,kk);
    A=K(x*x');
    A=.5*(A+A');
%   A=ones(n)-eye(n);  % to generate the simplex 
  elseif kind==3  % band structure for A
    A=zeros(n) ;
    for iii=1:n-1, 
     A(iii,iii+1)= 1+floor(5*rand(1)) ;
    end ;
    A=A+A' ;
    for iii=1:n-1, 
     H(iii,iii+1)= 10 ;
    end ;
    H(1,n)= 10 ;
    H=H+H' ;
  end
  %%%%%%%%%%%%end of special structure problems
  
  
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
  save probdata      % save for debugging
  disp(['problem saved in   probdata.mat']);
  disp(['cpu time for problem generation is  :  ',num2str(cputime-tg)]);
     [optval,Lam,X,D,iter]=main(A,H,toler,algor);  % solve the problem
                       % using p-d i-p method
  X=.5*(X+X');
  rankX=rank(full(X),.0001);
  probi=num2str(ii);
  probi=['Problem number  ' probi];
% title(probi)
% hold off
% figure(1)
  itersum=[itersum iter];
  optvals=[optvals optval];
  rankXs=[rankXs rankX];
%'at end of problem in gendist'
%keyboard
  save data
  save tempdata n spH noprobs toler itersum optvals rankXs kind algor
  emerg
  clear
  load tempdata
end
profile report
