% example of entering matrices and finding the completion
%      using dualcomp.m
% This example actually solves 5 problems, i.e. it uses the principal
%     submatrices first
toler=.000001;    % tolerance for duality gap
A0=[1 1 0 0 0
1 1 0 -1/2 -1/2
0 0 1 -1/2 -1/2
0 -1/2 -1/2 1 -1/2
0 -1/2 -1/2 -1/2 1
];       

H0=[1 1 1 0 0
1 1 0 1 1
1 0 1 1 1
0 1 1 1 1 
0 1 1 1 1 ];

optvals=[];
for i=1:5,
  if i==1,
     A=A0(2:5,2:5);
     H=H0(2:5,2:5);
  elseif i==5,
     A=A0(1:4,1:4);
     H=H0(1:4,1:4);
  else
     A=A0([1:i-1 i+1:5],[1:i-1 i+1:5]);
     H=H0([1:i-1 i+1:5],[1:i-1 i+1:5]);
  end
  [optval,L,P,iter]=dualcomp(A,H,toler);
  optvals=[optvals optval];
  keyboard
end
A=A0;H=H0;
[optval,L,P,iter]=dualcomp(A,H,toler);
  optvals=[optvals optval]
