function [icol, ad, irow, a] = setsp(A) 
% generate sparse format of symmetric a for dnlaso
% input: A ... symmetric sparse matrix
% out:   data for spg.mex
% call [ icol, ad, irow, a] = setsp( A);

[n, n1] = size( A);		% get the problem size
ad = diag( A);			% ad is main diag of A
ad = full(ad);			% make it a full vector
A2 = tril(A, -1);		% now we only need lower triangle
A1 = abs(A2)>0;			% find the nonzero positions of A
icol = sum(A1); 		% icol contains # of nonzeros per col.
icol = full(icol);		% make it a full column vector
icol = icol';
last = n;			% remove trailing zeros
while icol( last) == 0,
	last = last - 1; end;
nzl = last;
icol = icol(1:nzl); 		% now icol is as needed
nzs = sum( icol);		% number of lowerdiag nonzeros
[irow, dummy, a] = find(A2);
