%
%function [crit] = critical(A0,H0,toler)
% check if the given matrix A is critical
% call: crit = critical(A0,H0,toler)

toler=.000001;    % tolerance for duality gap
A0=[1 1/2 -1/3 0 -1/3 -1/2 1/3;
1/2 1 0 -1/2 0 -1/3 -1/3;
-1/3 0 1 -1/2 -1/3 0 -1/3;
0 -1/2 -1/2 1 -1/2 1/2 1/2;
-1/3 0 -1/3 -1/2 1 0 -1/2;
-1/2 -1/3 0 1/2 0 1 1/2;
1/3 -1/3 -1/3 1/2 -1/2 1/2 1];

H0=[100 100 100 0 100 100 100;
100 100 100 100 0 100 100;
100 100 100 100 100 0 100;
0 100 100 100 100 100 100;
100 0 100 100 100 100 100;
100 100 0 100 100 100 100;
100 100 100 100 100 100 100];

[n,n]=size(A0);
crit = 1;

for i=0:n,
    if i==0,
       A=A0;
       H=H0;
    elseif i==1,
       A=A0(2:n,2:n);
       H=H0(2:n,2:n);
    elseif i==n,
       A=A0(1:n-1,1:n-1);
       H=H0(1:n-1,1:n-1);
    else
       A=A0([1:i-1, i+1:n],[1:i-1, i+1:n]);
       H=H0([1:i-1, i+1:n],[1:i-1, i+1:n]);
    end

 [optval,L,P,iter]=dualcomp(A,H,toler);
  optvals=[optvals optval];

 [k,k]=size(A); 
    if (optval<=toler & k==n),    % A0 is completable
    crit=0, break,
    elseif (optval>=toler & k<n), % submatrix is not completable
    crit=0,break,
    end

end

