% Calling program for complalg.m - approx compl problem
%  Generates random matrices A,H and solves
%    min ||H.*(P-A)|| s.t. P psd
%
% USER:  Can change the following parameters:
%   n  -  dimension of matrices H and A
%   psdA -   1,0 to decide whether A is chosen pos def or not.
%   psdH -   1,0 to decide whether H is chosen pos def or not.
%   spH  -  percentage nonzeros in H not counting values >=100
%   infH -  percentage of values >= 100 in H
%            >=100 denotes a definitely fixed element of matrix A
%   noprobs  - number of problems to solve
%   toler    - tolerance values for duality gap
%
%  OUTPUT: Output is saved, after each problem, in data.mat
%          itersum  -  iteration count for each problem
%          optvals  -  optimal values for each problem
%          densesum -  density of nonzeros in H for each problem
%          rcondAsum-  reciprocal of condition numbers of A matrices
%          rcondHsum-  reciprocal of condition numbers of H matrices
%%%%%%%%%%%%%%%%%%%%%%%
n=155;
psdA=0;
psdH=0;
spH=.01;
infH=0;
noprobs=20;
toler=1*10^(-6);
kind=1;         % for sprandsym calls
%%%%%%%%%%%%%%%%%%%%%%%
%Initialization:
rand('seed',sum(100*clock));  % reset 
randn('seed',sum(100*clock));  % reset 
itersum=[];
rcondHsum=[];
rcondAsum=[];
densesum=[];
optvals=[];
meP=[];    % save mineig(P) to check pos def of P
%%%%%%%%%%%%%%%%%%%%%%%
%Generate and solve noprobs problems
for i=1:noprobs,
disp(['generating test problem number:  ',num2str(i),'  of  ',num2str(noprobs)]);
tg=cputime;
if psdA,
   A=randn(n);
   [H,H2]=qr(A);
   d=rand(n-2,1);
% allow for increased condition number
   d=[.1*rand
       d
       10*rand];
   A=H*diag(d)*H';
else
   A=randn(n);
end
A=(A+A')/2;
rcondA=1/cond(A);
rcondAsum=[rcondAsum rcondA];
if psdH,
   rcondH=.01*rand;  % reciprocal of condition number
   rcondHsum=[rcondHsum rcondH];
   H=sprandsym(n,spH,rcondH,kind);
else
   if spH ==1,  % dense case
     H=randn(n);
   else
     H=sprandsym(n,spH);
   end
end
% Now choose elements which are fixed - diagonal is never fixed
if infH>0,
  H=tril((200*ones(n)),-1   );
  H=H+H';
  H2=sprandsym(n,(1-infH));
  ind=find(H2~=0);
  H(ind)=zeros(size(ind)); 
end
d=.1*rand(n,1);   % positive diagonal - wlog
H=H+diag(d);  
H=abs(H);   % nonnegative weights
H=(H+H')/2;
H=sparse(H);
ind=find(H==0);
A(ind)=zeros(size(ind)); % zero out the completely free els of A
A=sparse(A);
save probdata      % save in case of crash
disp(['cpu time for problem generation is  :  ',num2str(cputime-tg)]);
if infH > 0,
   [optval,Q,P,iter]=primcomp(A,H,toler);
else
   [optval,Q,P,iter]=dualcomp(A,H,toler);
end
itersum=[itersum iter];
optvals=[optvals optval];
densesum=[densesum (nnz(H)/n^2)];
%% check pos def on P
[ icol, ad, irow, ar] = setsp( P);  % set up data for Lanczos call
ee=ones(n,1); % !!!Need better initial estimate for SMALLEST eig
[ae, xnew] = mineig1( P, icol, ad, irow, ar, ee); % Lanczos version
meP=[meP ae];
save data
save tempdata rcondAsum rcondHsum itersum optvals n infH spH psdA psdH noprobs toler densesum kind meP
clear
load tempdata
end
