function Y = sum_congruence_nosym(X,List,transpose_flag)
%function Y = sum_congruence(X,List,transpose_flag) 
% This function computes the image of sum of congruences at X WITHOUT
% symmetrization
% Y = sum_{i=1} List{i}*X*List{i}'   if transpose_flag == 0
% Y = sum_{i=1} List{i}'*X*List{i}   if transpose_flag == 1, which is the adjoint
% INPUTS : X : current point
%          List : cell array containg the matrices
%          transpose_flag : 1 for taking the conjugate, 0 for not taking the conjugate
% OUTPUT : the image under the mapping at X without symmetrization
    
    if transpose_flag == 0

    Y = zeros(size(List{1},1));
    for ii = 1:length(List)
        temp = (List{ii}* X) * List{ii}' ;
        Y = Y + temp;
    end
    %Y = (Y+Y')/2; NOT symmerizing

    elseif transpose_flag ==1
    Y = zeros(size(List{1},2));
    for ii = 1:length(List)
        temp = List{ii}'*( X * List{ii} );
        Y = Y + temp;
    end
    %Y = (Y+Y')/2; NOT symmerizing
        
    end
end %of function
