function data_check(Gamma,gamma,Klist,Zlist)
% function data_check(Gamma,gamma,Klist,Zlist)
% This function checks if the data meets the requirements of the problem
% description. It only prints out the messages.
% It checks if Gamma is Hermitian, gamma is real and the cardinalities |Gamma|=|gamma|.
%              Klist satisfies G(I) <=I
%              Zlist satisfies each Zlist being orthog. projection and they sum to I 
% Inputs : Gamma, gamma : the constraint data for Gamma(rho) = gamma
%          Klist : data for the map G(rho) = sum_j Klist{j} rho Klist{j}'
%          Zlist : data for the map Z(delta) = sum_j Zlist{j} delta Zlist{j}'
% Outputs : no output, it only prints out ths messages



mlist = [1:1:length(Gamma)];


%% check Gamma eligibility


Gamma_check = cellfun(@ishermitian,Gamma);
Gamma_nonhermitian = mlist(Gamma_check==0);

if ~isempty(Gamma_nonhermitian)
   % fprintf('  Gamma : PASS \n')
%else
    fprintf('  Gamma : FAIL \n')
    fprintf('          Gamma{%g} is not hermitan \n',Gamma_nonhermitian)
end


%% check gamma eligibility


gamma_check = isreal(gamma);
gamma_nonreal = mlist(gamma_check==0);

if ~isempty(gamma_nonreal) || (length(gamma) ~= length(Gamma))
    %fprintf('  gamma : PASS \n')
%else
    fprintf('  gamma : FAIL \n')
    if ~isempty(gamma_nonreal)
        fprintf('          gamma(%g) is not-real \n',gamma_nonreal)
    elseif (length(gamma) ~= length(Gamma))
        fprintf('          number of Gamma{i} ~= length of gamma \n')
    end
end


n_rho = size(Klist{1},1);

%% check Klist eligibility
temp = zeros(n_rho);  % compute G(I)
for ii = 1:length(Klist)
    temp = temp + Klist{ii}*Klist{ii}';
end

if min( eig( eye(n_rho)-temp))  < -1e-13  %G(I)=<I
    %fprintf('  Klist : PASS \n')
%else
    fprintf('  Klist : FAIL \n')
    fprintf('           Klist does not satisfy G(I) <= I \n')
end


%% check Zlist eligibility  %%


% check if Zlist contains hermitian matrices
znums = [1:1:length(Zlist)];
Zlist_check = cellfun(@ishermitian,Gamma);
Zlist_nonhermitian = znums(Zlist_check==0);

Zherm_check = isempty(Zlist_nonhermitian);  % flag for being hermitian



% check if Zlist contains idempotent matrices
Zlist_nonidemp = [];
for ii =1:length(Zlist)
    if norm(Zlist{ii}- Zlist{ii}*Zlist{ii}','fro') >1e-13
        Zlist_nonidemp = [Zlist_nonidemp ;ii];
    end
end
Zidemp_check = isempty(Zlist_nonidemp); % flag for being idempotent

% check if Zlist sum to I
k = size(Zlist{1},1);
temp = zeros(k);
for ii =1:length(Zlist)
    temp = temp + Zlist{ii};
end

if norm( temp - eye(k), 'fro') <1e-13
    ZsumtoI_check = 1;     % flag for summing to the identity
else
    ZsumtoI_check = 0;
end


if Zherm_check + Zidemp_check + ZsumtoI_check < 3  % no successful case
    %fprintf('  Zlist : PASS \n')
%else
    fprintf('  Zlist : FAIL \n')
    if Zherm_check == 0 
        fprintf('          Zlist{%g} is not hermitan \n',Zlist_nonhermitian)
    elseif Zidemp_check == 0
        fprintf('          Zlist{%g} is not idempotent \n',Zlist_nonidemp)
    elseif ZsumtoI == 0
        fprintf('          Zlist does not sum to the identity. \n')
    end
end



end   % end of function data_check
