clc
clear
opt = [];
addpath(genpath('./Solver')); % solver path

%%%%% User Option %%%%%
opt.iterbnd = 100;  % max number of iterations
opt.verbose = 1;    % output log levels in the command window 
                    %    -> (0,1,2)=(no output, minimal output, all output)
opt.tolerGN = 1e-9;     % tolerance for Gauss-Newton solver 
opt.tol_licols = 1e-9;  % tolerance for sorting out lin.indep contraints
opt.tolerFR = 1e-12;    % tolerance for the facial reduction algorithm


%%%%% Load the data %%%%%
% data contains Gamma, gamma, Klist, Zlist, rhoA
% - see the manuscipt for the details of the data description 
% - The manuscript can be found from https://arxiv.org/abs/2104.03847


instancenumb = 1;

if instancenumb == 1          %%% Instance 1 %%%
    load('instance_ebBB84.mat')  
elseif instancenumb == 2      %%% Instance 2 %%%
    load('instance_pmBB84.mat')  
    opt.rhoA = rhoA;  % reduced density operator 
elseif instancenumb == 3      %%% Instance 3 %%%   
    load('instance_mdiBB84.mat')  
    opt.rhoA = rhoA;  % reduced density operator 
elseif instancenumb == 4      %%% Instance 4 %%%
    load('instance_TFQKD.mat')  
elseif instancenumb == 5      %%% Instance 5 %%% 
    load('instance_DMCV.mat')  
    opt.rhoA = rhoA;  % reduced density operator 
elseif instancenumb == 6      %%% Instance 6 %%%
    load('instance_dprBB84.mat')  
    opt.rhoA = rhoA;  % reduced density operator 
end

%%%%% call the solver %%%%%
[ubd,lbd,Out] = GaussNewton(Gamma,gamma,Klist,Zlist,opt);
