%% Runfile for SNLSDPclique
%
% =====================
% Citation information:
% =====================
% [1]	N.Krislock and H.Wolkowicz. Explicit sensor network 
%       localization using semidefinite representations and clique 
%       reductions. Technical report, University of Waterloo, 2009.
% <http://www.optimization-online.org/DB_HTML/2009/05/2297.html>

% SNLSDPclique_run, version 0.1
% Copyright (C) 2009 by
% Nathan Krislock, Henry Wolkowicz
% Last Modified May 27, 2009

disp(' ');
disp('SNLSDPclique_run, version 0.1');
disp('Copyright (C) 2009 by Nathan Krislock and Henry Wolkowicz');
disp('This program comes with ABSOLUTELY NO WARRANTY. This is free');
disp('software, and you are welcome to redistribute it under certain');
disp('conditions; see Copyright_SNLSDPclique.txt and glp.txt for');
disp('details.');

disp(' ');
disp('Enter values for n (eg. n = 6000) and R (eg. R = .5):');
n = input('n = ');
R = input('R = ');

tic
disp(' ');
disp('Running [Xorig,A,Dpartial] = SNLSDPclique_gen(n,R)...');
[Xorig,A,Dpartial] = SNLSDPclique_gen(n,R);
toc

% disp(' ');
% disp('Enter values for OPTS.level {1,2} and OPTS.verbose {0,1,2,3}:');
% OPTS.level = input('OPTS.level = ');
% OPTS.verbose = input('OPTS.verbose = ');

% see 'help SNLSDPclique' for a description of the OPTS parameter
OPTS.level = 2;
OPTS.verbose = 0;

tic
disp(' ');
disp('Runnig [X,exitflag,OUTPUT] = SNLSDPclique(Dpartial,A,R,OPTS)...');
[X,exitflag,OUTPUT] = SNLSDPclique(Dpartial,A,R,OPTS);
toc

if exitflag == 1
    [m,r] = size(A);
    
    P = [X; A];
    
    [mcsize,ic] = max(OUTPUT.cliques);
    
    inds = find(OUTPUT.cliquematrix(:,ic));
    inds = setdiff(inds,n-m+1:n);
    
    disp(' ');
    disp([num2str(length(inds)),'/',num2str(n-m),' sensors localized']);
    
    XmXorig = X - Xorig(inds,:);
    XmXorig2 = XmXorig*XmXorig';
    max_sensor_err = sqrt( max(diag(XmXorig2)) );
    rmsd_error = sqrt( trace(XmXorig2)/length(inds) );
    
    disp(' ');
    disp(['norm(X-Xorig(inds,:)) = ', num2str(norm(XmXorig,'fro'))]);
    disp(['max_sensor_err        = ', num2str(max_sensor_err)]);
    disp(['rmsd_error            = ', num2str(rmsd_error)]);
else
    disp(' ');
    disp('No sensors could be positioned -- try increasing OPTS.level');
end

disp(' ');