function x = proj_sim(y,a,w)
% this function solves projection to weighted simplex problem
% min ||T^*(x) - y||^2 s.t. w'*x == a, x>=0
% where T^* is an operator satisfying TT^* = Diag(w)
%
% INPUTS: y,a,w are the problem parameters
% OUTPUTS: x is the solution
% From Hao Hu on 2019-12-26

if nargin < 3
    % this is the case when w = 1
    n = length(y);
    [u,I] = sort(y,'descend');
    yw = y(I);
    
    tau = yw(1)-a; % initial value of tau if the loop stops at k =1
    
    s = 0;
    for k = 1:n
        s = s + yw(k);
        tau_temp = (s-a)/k;
        if u(k) - tau_temp < 0 %min(k+1,n)
            break
        end
        tau = tau_temp;
    end
    
    x = max(y - tau,0);
    
    
else
    % this the case when w ~= 1
    n = length(y);
    [u,I] = sort(y./w,'descend');
    yw = y(I);
    ws = w(I);
    
    tau = (yw(1)-a)/ws(1); % initial value of tau if the loop stops at k =1
    
    s = 0;
    t = 0;
    for k = 1:n
        s = s + yw(k);
        t = t + ws(k);
        tau_temp = (s-a)/t;
        if u(k) - tau_temp < 0
            break
        end
        tau = tau_temp;
    end
    
    x = max(y./w - tau,0);
    
end


end
% % check k
% FID = fopen('proj_sim_test','a');
% fprintf(FID,'%i \n',k);
% fclose(FID);
% k