function W = orth_col(W)

% input: a matrix W
% output: a new matrix W with the same columns space, but the columns are 
% orthogonal now, i.e., W'*W = I

W(:,1)  = W(:,1)/norm(W(:,1));
for i = 2:size(W,2)
    alpha = W(:,1:i-1)'*W(:,i);
    W(:,i) = W(:,i) - W(:,1:i-1)*alpha;
    W(:,i) = W(:,i)/norm(W(:,i));
end

end