function P = hamming_eigmat(q,d)

% this function returns the character table of the hamming scheme (q,d)
% P(i,j) is the eigenvalue of the eigenspace Ei for the basis matrix Aj
% i.e., all the matrices in the algebra share the same eigenspace

P = zeros(d+1);
P1 = zeros(d+1);


% q = 2;
for k = 0:d
    for u = 0:d
        P(u+1,k+1) = get_K_k_u(k,u,q,d);
        
        for j = 0:k
            if u >= j
                a = nchoosek(u,j);
            else
                a = 0;
            end
            
            if d-u >= k-j
                b = nchoosek(d-u,k-j);
            else
                b = 0;
            end
            
            P1(u+1,k+1) = P1(u+1,k+1) + (-1)^j*(q-1)^(k-j)*a*b;
            
%             P(u+1,k+1) = P(u+1,k+1) + (-1)^j*(q-1)^(k-j)*nck(u,j)*nck(n-u,k-j);
        end
    end
end

if norm(P-P1)> 0
    error
end

end


function r = get_K_k_u(k,u,q,d)

r = 0;

for j = 0:k
    if u >= j
        a = nchoosek(u,j);
    else
        a = 0;
    end
    
    if d-u >= k-j
        b = nchoosek(d-u,k-j);
    else
        b = 0;
    end
    
%     [a b]
%     (-1)^j*(q-1)^(k-j)*a*b
    r = r + (-1)^j*(q-1)^(k-j)*a*b;
    
    %             P(u+1,k+1) = P(u+1,k+1) + (-1)^j*(q-1)^(k-j)*nck(u,j)*nck(n-u,k-j);
end



end
% function r = nck(n,k)
% 
% 
% r = prod(n-k+1:n)/factorial(k);
% 
% end