function [A,V,basis] = get_hamming(q,d)
% this function returns the adjacency matrix A and the set of vertices V of
% the hamming graph H(q,d)

% find the vertex list,
if q == 2
    % easy for q = 2
    V = dec2bin(0:(2^d)-1)-'0';
else
    % find V by recursion
    V  = vertex_list(q,d);
end

n = q^d;

% get the adjacency matrix
r = zeros((n-1)*n/2,1);
c = zeros((n-1)*n/2,1);
s = zeros((n-1)*n/2,1);

basis = cell(d+1,1);
for i = 1:d+1
    basis{i} = zeros(q^d);
end

k = 0;
for i = 1:q^d-1
    for j = i+1:q^d
            k = k +1;
            % the (r,c)-entry has value s(k) = d_{Hamming}(vi,vj)
            r(k) = i;
            c(k) = j;
            s(k) = sum(V(i,:)~=V(j,:));
    end
end

A = sparse(r,c,s,n,n);
A = A+A';

for i = 0:d
    basis{i+1} = sparse(A==i);
end

A = sparse(A==1);

end


function V  = vertex_list(q,d)

%list all the vertices recursively
V = zeros(q^d,d);
V = vertex_recur(q,d,1,0,zeros(1,d),V);

end

function [V,k] = vertex_recur(q,d,p,k,v,V)

% return V the list of the vertices of H(q,d)
% v is the current vertex
% p is the current position v(p)
% k is the listed vertices so far

if p == d+1
    k = k + 1;
    V(k,:) = v;
    return
end

for i = 1:q
    v(p) = i;
    [V,k] = vertex_recur(q,d,p+1,k,v,V);
end

end