clear
clc


addpath(genpath('..\'));
%addpath(genpath('.\'));

% Choose which table to construct
experiment = 'random'; %'random' or 'protein'

if strcmp(experiment,'random')

    runfile_testsSF_random
    
    namefile = 'Tables\table_SF_random.tex';

elseif strcmp(experiment, 'protein')

    runfile_testsSF_protein

    namefile = 'Tables\table_SF_protein.tex';


end

[ncol,~] = size(datatable.m);

fmt0 = '%i & %i & %1.4e & %1.4e & %1.4e & %i';
fmt1 = '%i & %i & %1.4e & %.2f & %1.4e & %i';

fid = fopen(namefile, 'w');

fprintf(fid,'%s\n', '\begin{tabular}{lcccccc} \toprule');

 fprintf(fid, '%s', ...
         ["&    $n$ & $m$ & $\beps^k$(rel. res.)  &",...
   "$\mathrm{cond}(F'(y_k))$ & $\lambda_n(y_k)$ & $k$ \\[5pt]"]);

fprintf(fid, ...
    '\n  \\hline \n');

% First column - No FR yet done:
fprintf(fid,'%s &', 'Before \textbf{FR}');

fprintf(fid,fmt0, datatable.n(1),datatable.m(1),datatable.eps(1), datatable.cond(1),...
    datatable.mineig(1), datatable.k(1));

fprintf(fid, '%s \n', '\\[5pt]');


fprintf(fid, ...
    '\n  \\hline \n');

for jj=2:ncol
    if ncol == 2
        fprintf(fid,'%s &', 'After \textbf{FR}');
    else
        fprintf(fid,'%s %i &', 'After \textbf{FR} ', jj-1);
    end

    if jj==ncol
        fprintf(fid,fmt1, datatable.n(jj),datatable.m(jj),datatable.eps(jj), datatable.cond(jj),...
    datatable.mineig(jj), datatable.k(jj));
    else
        fprintf(fid,fmt0, datatable.n(jj),datatable.m(jj),datatable.eps(jj), datatable.cond(jj),...
    datatable.mineig(jj), datatable.k(jj));
    end

    fprintf(fid, '%s \n', '\\[5pt]');


    fprintf(fid, ...
    '\n  \\hline \n');

end

fprintf(fid, '\\end{tabular}\n');


