clear
clc
% profile clear
% profile on
% restoredefaultpath

seed = 454259257; %for figure in paper
rng(seed);
% rngsave = rng('shuffle');
% save('rngsavefile','rngsave');

addpath(genpath('..\..\codesAltProj'));
%addpath(genpath('.\'));

% Data for the table:
datatable.n = [];
datatable.m = [];
datatable.eps = [];
datatable.cond = [];
datatable.mineig = [];
datatable.k = [];

% Select parameters problem:
n = 15;             % dim of Sn
n2 = n^2;
tn = n*(n+1)/2;     %triangular number
m = 7;              % # of constraints
mc = 5;             % # of constraints for singularity degree 1, 0 for SF
%m2 = m^2;
%tm = m*(m+1)/2;     %triangular number

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% choosing indexes for svec and sMat for n and m
% For n:
svindn = find(triu(ones(n),1)); % matrix indices for the strictly upper triangular
sMindn = zeros(n2,1); %matrix indices with respect to linear indices of the diagonal and the strictly upper triangle
sMindn(svindn) = 1:tn-n; %strictly upper triangle
sMindn(1:n+1:n2) = tn-n+1:tn;%the diagonal
%calculate the linear indices of the strictly lower triangle
indMn = zeros(n); %matrix indices
indMn(:) = 1:n2;
indMn = indMn';
lsvindn = indMn(svindn); %strictly lower triangular
sMindn(lsvindn) = 1:tn-n; %strictly lower triangular


%%%%% Saving them for the solver:
options.svindn = svindn;
options.sMindn = sMindn;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Generate Data:

tic
W = randn(n);
W = (W + W')/2;   % random symm. matrix to project
w = ssvec(W,svindn);
%%%% following for getting strict feasibility
[q,~] = qr(randn(n));
tempsvd = 2*(rand(n,1)+.1);
%tempsvd(end) = 1e-2*max(temp);
xhat = q*diag(tempsvd)*q';
xhat = (xhat + xhat')/2;  % to guarantee strict feas. for spectrah.
mineigxhat = min(eig(xhat));
if mineigxhat < 1e-10
	fprintf('xhat not suff pos. def.; dbquit and run again\n')
	keyboard
else
	fprintf('[mineig cond] Slater pt xhat = [%g %g]\n', ...
		        mineigxhat,cond(xhat))
end
xhat = ssvec(xhat,svindn);



%%% construct random constraints for the spectrahedron
b = zeros(m,1);
A = zeros(m,tn);

cstart = mc + 1;
[q,~]=qr(randn(n));  % q has n orthonormal columns
r = floor(n/2);  % rank for X in relint min face
Vx = q(:,1:r);    % range for X using first r cols of q
Vz = q(:,r+1:n);    % nullspace for X last n-r cols of q; Vz'*Vx = 0
%% We now const xhat in rel int of minimal face; A0 orthog.; xhat+A0 > 0
xhat = Vx*diag(rand(r,1)+.1)*Vx';  % range xhat = range Vx; psd ri  min. face
xhat = ssvec(xhat,svindn);
save('savexhat','Vx');
A0 = Vz*diag(rand(n-r,1)+.1)*Vz';  % exposing vector for min face; A0*xhat=0 
A0 = (A0+A0')/2;
A0 = ssvec(A0,svindn);
%%% want A0 = lam1*A1 + lam2*A2 + lam3*A3 + ...
%%% want 0 = lam1*b1 + lam2*b2 + lam3*b3 + ...
if mc > 1   % number of constraints for exposing vector
        lam = 2*randn(mc,1);  
	lam = lam + sign(lam);  
	if lam(1) < 0
		lam(1) = -lam(1);
	end
	fprintf('generating mc=%i constraints with exposing vector',mc)
        Acs = zeros(tn,1);
        bcs = 0;
        for ii = 2:mc
                Ac{ii} = randn(n);
	        bc{ii} = randn;
                Ac{ii} = (Ac{ii}+Ac{ii}')/2;
                Ac{ii} = ssvec(Ac{ii},svindn);
	        Acs = Acs + lam(ii)*Ac{ii};
	        bcs = bcs + lam(ii)*bc{ii};
	       end
        Ac{1} = (A0-Acs)/lam(1);
        bc{1} = -bcs/lam(1);
else  % mc == 1
        Ac{1} = A0;
	       bc{1} = 0;
end
%%Acell{1} = A1;
for ii = cstart:m
	temp = randn(n);
	temp = (temp + temp')/2;
    temp = ssvec(temp,svindn);
	%Acell{ii} = temp;
	Ac{ii} = temp;
	bc{ii} = temp'*xhat;   
end   
for ii = 1:m
	A(ii,:) = Ac{ii}';
	b(ii) = bc{ii};
end

fprintf('random data generated time = %g\n',toc)


%%%%%%%%%%%%% Here starts  the solver %%%%%%%%%%%%%%%%%%%%%%%

%%% Options for the solver:
clear options
verboseplot = true;
options.verbose=verboseplot;
options.modprint = 5; % >0 for showing iterations
options.maxiter = 2000;
options.tol = 1e-13;
options.saveeigs = true; % for saving the eigenvectors for the plot
noSlater = true; % we assume Slater does not hold

start3 = tic;
output_SS = semismoothsolverK_preconditioner(A,b,w,options); 

% Save data for table:
datatable.n = [datatable.n;n];
datatable.m = [datatable.m;m];
datatable.eps = [datatable.eps; output_SS.relresid];
datatable.cond = [datatable.cond; output_SS.condestJac];
datatable.mineig = [datatable.mineig; output_SS.mineig];
datatable.k = [datatable.k; output_SS.iter];

while output_SS.noSlater   % we procceed with the algorithm until no more FR are needed


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% HERE FOR FACCIAL REDUCTION %% (TO FIX...)
if output_SS.noSlater  % then we apply facial reduction

    if isfield(options, 'saveeigs')  %the we do the plot
        eigsk = output_SS.saveeigs;
        optionsplot.k = output_SS.iter;
        optionsplot.savename = 'TestSingularityDegree1EigPlot';
        eigplotgenerator(eigsk,optionsplot);
    end


    %%% We call for FRGNPC for performing Facial Reduction
    % Data:
    MGamma = output_SS.AFR;
    gamma = output_SS.bFR;
    for ii=1:size(MGamma,1)
        Gamma{ii} = ssMat(MGamma(ii,:),n,sMindn);
    end
    opt.tolerFR = 1e-13;
    V = FRGNPC(Gamma,MGamma,gamma,opt);
%     keyboard;
%     ZZ = output_SS.AFR'*yy; %is the exposing vector
%     ZZ = ssMat(ZZ,n,sMindn);
%     rr=rank(ZZ,1e-8); 
%     [qq,~]=qr(ZZ); 
%     keyboard
%     V = qq(:,rr+1:n); %matrix for facial reduction
%     V = null(ZZ,1e-8);
    [~, rr] = size(V);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % the new linear transf. lies in Srr, so we compute the new indices for ssvec
    rr2 = rr^2;
    trr = rr*(rr+1)/2;     %triangular number
    svindrr = find(triu(ones(rr),1)); % matrix indices for the strictly upper triangular
    sMindrr = zeros(rr2,1); %matrix indices with respect to linear indices of the diagonal and the strictly upper triangle
    sMindrr(svindrr) = 1:trr-rr; %strictly upper triangle
    sMindrr(1:rr+1:rr2) = trr-rr+1:trr;%the diagonal
    %calculate the linear indices of the strictly lower triangle
    indMrr = zeros(rr); %matrix indices
    indMrr(:) = 1:rr2;
    indMrr = indMrr';
    lsvindrr = indMrr(svindrr); %strictly lower triangular
    sMindrr(lsvindrr) = 1:trr-rr; %strictly lower triangular

    options.svindn = svindrr;
    options.sMindn = sMindrr;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %We now change the problem for facial reduction:
    W = V'*W*V; % we change W
    w = ssvec(W,svindrr);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    


    AV = zeros(m,trr); % for new linear transformation
    for mm = 1:m
        AmmM = ssMat(A(mm,:)',n,sMindn);
        temp = V'*AmmM*V;
        AV(mm,:) =  ssvec(temp,svindrr);
    end

    % Protocol in Haesol's thesis page 27
    [AT, lindpc] = licols(AV'); %extracts linear indep columns and idices
    A = AT';
    b = b(lindpc);
    m = length(b);

end   % of if
% We run the solver again:
output_SS = semismoothsolverK_preconditioner(A,b,w,options); 

datatable.n = [datatable.n;n];
datatable.m = [datatable.m;m];
datatable.eps = [datatable.eps; output_SS.relresid];
datatable.cond = [datatable.cond; output_SS.condestJac];
datatable.mineig = [datatable.mineig; output_SS.mineig];
datatable.k = [datatable.k; output_SS.iter];

end % end while
stop3 = toc(start3);
xfinalI = output_SS.xfinal;
XfinalI = ssMat(xfinalI,rr,sMindrr);
zfinalI = output_SS.zfinal;
ZfinalI = ssMat(zfinalI,rr,sMindrr);
YfinalI = output_SS.yfinal;
fprintf(' Residual, Min eig  and obj. value for I. NONsmooth: %g %g %g\n', ...
	   norm(A*xfinalI-b),min(eig(XfinalI)),1/2*norm(W-XfinalI,'fro')^2);


fprintf('Time for efficient semismooth solver: %g \n',stop3)





