clear
clc
% profile clear
% profile on
% restoredefaultpath

seed = 454259257; %for figure in paper
rng(seed);
% rngsave = rng('shuffle');
% save('rngsavefile','rngsave');

addpath(genpath('..\..\codesAltProj'));
%addpath(genpath('.\'));

% Data for the table:
datatable.n = [];
datatable.m = [];
datatable.eps = [];
datatable.cond = [];
datatable.mineig = [];
datatable.k = [];

% Load data:
tempLoadData 
m = length(b);
%%%%%%%%%%%%%
W = randn(n);
W = (W + W')/2;   % random symm. matrix to project
w = ssvec(W,svindn);


%%%%%%%%%%%%% Here starts  the solver %%%%%%%%%%%%%%%%%%%%%%%

verboseplot = true;
options.verbose=verboseplot;
options.modprint = 5; % >0 for showing iterations
options.maxiter = 2000;
options.tol = 1e-13;
options.saveeigs = true; % for saving the eigenvectors for the plot
noSlater = true; % we assume Slater does not hold
options.svindn = svindn;
options.sMindn = sMindn;

start3 = tic;
nFR = -1; %number of FR

output_SS = semismoothsolverK_preconditioner(A,b,w,options); 

% Save data for table:
datatable.n = [datatable.n;n];
datatable.m = [datatable.m;m];
datatable.eps = [datatable.eps; output_SS.relresid];
datatable.cond = [datatable.cond; output_SS.condestJac];
datatable.mineig = [datatable.mineig; output_SS.mineig];
datatable.k = [datatable.k; output_SS.iter];


while output_SS.noSlater % we procceed with the algorithm until no more FR are needed

%% HERE FOR FACCIAL REDUCTION 
if output_SS.noSlater  % then we apply facial reduction
    nFR = nFR +1;
    if isfield(options, 'saveeigs')  %the we do the plot
        eigsk = output_SS.saveeigs;
        optionsplot.k = output_SS.iter;
        optionsplot.savename = ['TestHaesolProteinEigPlot_', num2str(nFR)];
        eigplotgenerator(eigsk,optionsplot);
    end


    %%% We call for FRGNPC for performing Facial Reduction
    % Data
    MGamma = output_SS.AFR;
    gamma = output_SS.bFR;
    clear Gamma
    for ii=1:size(MGamma,1)
        Gamma{ii} = ssMat(MGamma(ii,:),n,sMindn);
    end
    opt.tolerFR = 1e-13;
    V = FRGNPC(Gamma,MGamma,gamma,opt);

    [~, rr] = size(V);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % the new linear transf. lies in Srr, so we compute the new indices for ssvec
    rr2 = rr^2;
    trr = rr*(rr+1)/2;     %triangular number
    svindrr = find(triu(ones(rr),1)); % matrix indices for the strictly upper triangular
    sMindrr = zeros(rr2,1); %matrix indices with respect to linear indices of the diagonal and the strictly upper triangle
    sMindrr(svindrr) = 1:trr-rr; %strictly upper triangle
    sMindrr(1:rr+1:rr2) = trr-rr+1:trr;%the diagonal
    %calculate the linear indices of the strictly lower triangle
    indMrr = zeros(rr); %matrix indices
    indMrr(:) = 1:rr2;
    indMrr = indMrr';
    lsvindrr = indMrr(svindrr); %strictly lower triangular
    sMindrr(lsvindrr) = 1:trr-rr; %strictly lower triangular

    options.svindn = svindrr;
    options.sMindn = sMindrr;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %We now change the problem for facial reduction:
    W = V'*W*V; % we change W
    w = ssvec(W,svindrr);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    


    AV = zeros(m,trr); % for new linear transformation
    for mm = 1:m
        AmmM = ssMat(A(mm,:)',n,sMindn);
        temp = V'*AmmM*V;
        AV(mm,:) =  ssvec(temp,svindrr);
    end
    sMindn = sMindrr;
    svindn = svindrr;
    n = rr; n2 = rr2; tn = trr;

    % Protocol in Haesol's thesis page 27
    [AT, lindpc] = licols(AV'); %extracts linear indep columns and idices
    A = AT';
    b = b(lindpc);
    m = length(b);


end

% We run the solver again:
output_SS = semismoothsolverK_preconditioner(A,b,w,options); 

datatable.n = [datatable.n;n];
datatable.m = [datatable.m;m];
datatable.eps = [datatable.eps; output_SS.relresid];
datatable.cond = [datatable.cond; output_SS.condestJac];
datatable.mineig = [datatable.mineig; output_SS.mineig];
datatable.k = [datatable.k; output_SS.iter];
end % end while

stop3 = toc(start3);
xfinalI = output_SS.xfinal;
XfinalI = ssMat(xfinalI,rr,sMindn);
zfinalI = output_SS.zfinal;
ZfinalI = ssMat(zfinalI,rr,sMindn);
YfinalI = output_SS.yfinal;
fprintf(' Residual, Min eig  and obj. value for I. NONsmooth: %g %g %g\n', ...
	   norm(A*xfinalI-b),min(eig(XfinalI)),1/2*norm(W-XfinalI,'fro')^2);




fprintf('Time for efficient semismooth solver: %g \n',stop3)



