%% Comparison between strict feasibility and strong duality %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% In this file we compare the behaviour of the algorithm in three cases:
%%%%%
% Case 1: Strict feasibility holds
%%%%%
% Case 2: Strict feasibility fails but strong duality hold
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear
seed = 2;
rng(seed);

%seed = 451789895;
%rng(seed);
%  rngsave = rng('shuffle');
%  save('rngsavefile','rngsave');
addpath(genpath('..\..\codesAltProj'));

% profile clear
% profile on



nn = [10,20,50,100];  %sizes n
mm = [5,7,20,30]; %sizes m
ncS = [3,4,5,10]; %number of constraints causing strict feasibilty to fail
rep = 20;  %number

%counter for success:
countcase1 = zeros(length(nn) ,1);
itcase1 = 0;
maxitcase1 = 0;
countcase2 = zeros(length(nn) ,1);
countcase3 = zeros(length(nn) ,1);

tol = 1e-7;
maxiter = 1000;

verboseplot = false;
options.verbose=verboseplot;

for jj=1:length(nn)
    %%% Initialization of parameters
    n = nn(jj);
    m = mm(jj);
    mc = ncS(jj);
    n2 = n^2;
    tn = n*(n+1)/2;     %triangular number
    m2 = m^2;
    tm = m*(m+1)/2;     %triangular number
    
    
    % for ssvec and ssmat:
    svindn = find(triu(ones(n),1)); % matrix indices for the strictly upper triangular
    sMindn = zeros(n2,1); %matrix indices with respect to linear indices of the diagonal and the strictly upper triangle
    sMindn(svindn) = 1:tn-n; %strictly upper triangle
    sMindn(1:n+1:n2) = tn-n+1:tn;%the diagonal
    %calculate the linear indices of the strictly lower triangle
    indMn = zeros(n); %matrix indices
    indMn(:) = 1:n2;
    indMn = indMn';
    lsvindn = indMn(svindn); %strictly lower triangular
    sMindn(lsvindn) = 1:tn-n; %strictly lower triangular
    
    %%%%% Saving them for the solver:
    % options.svindn = svindn;
    % options.sMindn = sMindn;
    % options.slater = mc;   
    % options.tol = tol;
    % options.modprint = 10; % >0 for showing iterations


    %%% Case 1: Strict feasibility holds

    for rr=1:rep

        tic
        W = randn(n);
        W = (W + W')/2;   % random symm. matrix to project
        w = ssvec(W,svindn);
        %%%% following for getting strict feasibility
        [q,~] = qr(randn(n));
        tempsvd = 2*(rand(n,1)+.1);
        xhat = q*diag(tempsvd)*q';
        xhat = (xhat + xhat')/2;  % to guarantee strict feas. for spectrah.
        mineigxhat = min(eig(xhat));
        if mineigxhat < tol
	        fprintf('xhat not suff pos. def.; dbquit and run again\n')
	        keyboard
        else
	        fprintf('[mineig cond] Slater pt xhat = [%g %g]\n', ...
		                mineigxhat,cond(xhat))
        end
        xhat = ssvec(xhat,svindn);
        
        
        
        %%% construct random constraints; ensure strict feasibility
        b = zeros(m,1);
        A = zeros(m,tn);
        
        %%% For Slater:
        for ii=1:m
            tempA = rand(n);
            tempA = (tempA+tempA')/2;
            tempA = ssvec(tempA,svindn);
            A(ii,:) = tempA';
            b(ii) = tempA'*xhat;
        end
    
            %%%%%%%%%% Algorithm %%%%%%%%%%%%%
        
        clear options
        verboseplot = false;
        options.verbose=verboseplot;
        options.modprint = 5; % >0 for showing iterations
        options.maxiter = maxiter;
        options.tol = tol;
        options.saveeigs = true; % for saving the eigenvectors for the plot
        start3 = tic;
        
        %% first iter should be before while
        output_SS = semismoothsolverK_preconditioner(A,b,w,options); 
    
        if (output_SS.relresid) < tol
            countcase1(jj,1) =  countcase1(jj,1)+1;
        end
        if (output_SS.iter) > 10
            itcase1 = itcase1+1;
        end

        if output_SS.iter > maxitcase1
            maxitcase1 = output_SS.iter;
        end


    end % for rep case 1


    %%% Case 2: Strict feasibility fails and strong duality holds
    for rr=1:rep
            %%%%%%%%%%% generate random data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %%%% choose xhat psd  and A0 psd so that xhat*A0 = 0 and choose b =0
        tic
        % % W = randn(n);
        % % W = (W + W')/2;   % random symm. matrix to project
        % % w = ssvec(W,svindn);
        %%%% following for getting strict feasibility
        [q,~] = qr(randn(n));
        tempsvd = 2*(rand(n,1)+.1);
        %tempsvd(end) = 1e-2*max(temp);
        xhat = q*diag(tempsvd)*q';
        xhat = (xhat + xhat')/2;  % to guarantee strict feas. for spectrah.
        mineigxhat = min(eig(xhat));
        if mineigxhat < tol
	        fprintf('xhat not suff pos. def.; dbquit and run again\n')
	        keyboard
        else
	        fprintf('[mineig cond] Slater pt xhat = [%g %g]\n', ...
		                mineigxhat,cond(xhat))
        end
        xhat = ssvec(xhat,svindn);
        
        
        
        %%% construct random constraints for the spectrahedron
        b = zeros(m,1);
        A = zeros(m,tn);
        
        
        %Acell = cell([m,1]);
        %%%%%%% following is for NO Slater
        cstart = mc + 1;
        [q,~]=qr(randn(n));  % q has n orthonormal columns
        r = floor(n/2);  % rank for X in relint min face
        Vx = q(:,1:r);    % range for X using first r cols of q
        Vz = q(:,r+1:n);    % nullspace for X last n-r cols of q; Vz'*Vx = 0
        %% We now const xhat in rel int of minimal face; A0 orthog.; xhat+A0 > 0
        xhat = Vx*diag(rand(r,1)+.1)*Vx';  % range xhat = range Vx; psd ri  min. face
        xhat = ssvec(xhat,svindn);
        save('savexhat','Vx');
        A0 = Vz*diag(rand(n-r,1)+.1)*Vz';  % exposing vector for min face; A0*xhat=0 
        A0 = (A0+A0')/2;
        A0 = ssvec(A0,svindn);
        %%% want A0 = lam1*A1 + lam2*A2 + lam3*A3 + ...
        %%% want 0 = lam1*b1 + lam2*b2 + lam3*b3 + ...
        if mc > 1   % number of constraints for exposing vector
                lam = 2*randn(mc,1);  % >=0 restriction was removed
	        lam = lam + sign(lam);  % assume no zeros???? fix???
	        if lam(1) < 0
		        lam(1) = -lam(1);
	        end
% 	        fprintf('generating mc=%i constraints with exposing vector',mc)
% 	        fprintf(' lam with lam(1)>0\n')
% 	        fprintf('????why make all lam >=0??? there is NO need???\n');
% 	        save('lamsave','lam','A0')  % temp testing
                Acs = zeros(tn,1);
                bcs = 0;
                for ii = 2:mc
                        Ac{ii} = randn(n);
	                bc{ii} = randn;
                        Ac{ii} = (Ac{ii}+Ac{ii}')/2;
                        Ac{ii} = ssvec(Ac{ii},svindn);
	                Acs = Acs + lam(ii)*Ac{ii};
	                bcs = bcs + lam(ii)*bc{ii};
	               end
                Ac{1} = (A0-Acs)/lam(1);
                bc{1} = -bcs/lam(1);
        else  % mc == 1
                Ac{1} = A0;
	               bc{1} = 0;
        end
        %%Acell{1} = A1;
        for ii = cstart:m
	        temp = randn(n);
	        temp = (temp + temp')/2;
            temp = ssvec(temp,svindn);
	        %Acell{ii} = temp;
	        Ac{ii} = temp;
	        bc{ii} = temp'*xhat;   
        end   
        for ii = 1:m
	        A(ii,:) = Ac{ii}';
	        b(ii) = bc{ii};
        end
        
        
        %% permute position of matrices for singularity????
        %rperm = randperm(m);
        %A = A(rperm,:);
        %b = b(rperm);
        %%%%   [vals,inds] = sort(rperm,'ascend'); puts positions in inds(1:mc)
        %%% see file   testFR.m  to identify exposing vector for rotation
        
        % Now, we define w appropiately to make sure there is attainment of
        % the dual solution
        yhat = rand(size(A,1)); %y in dual solution
        rankz = randi([1,n]); %rank z
        ztemp = randn(n,rankz);
        zhat =  ztemp*ztemp'; %z in dual soution
        zhat = ssvec(zhat,svindn);
        
        w = xhat-A'*yhat-zhat;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% end of data generation
        fprintf('random data generated time = %g\n',toc)
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        
        %%%%%%%%%% Algorithm %%%%%%%%%%%%%
        
        clear options
        verboseplot = false;
        options.verbose=verboseplot;
        options.modprint = 5; % >0 for showing iterations
        options.maxiter = maxiter;
        options.tol = tol;
        options.saveeigs = true; % for saving the eigenvectors for the plot
        start3 = tic;
        
        output_SS = semismoothsolverK_preconditioner(A,b,w,options); 
        
        if (output_SS.relresid) < tol
            countcase2(jj,1) =  countcase2(jj,1)+1;
        end
 
    end % end for rep case 2
    


  

end %end for dimensions



