clear
clc
% profile clear
% profile on
% restoredefaultpath

seed = 1;
rngsave = rng(seed);
%rngsave = rng('shuffle');
%save('rngsavefile','rngsave');

addpath(genpath('..\SolversAux'));
addpath(genpath('.'));
%addpath(genpath('.\'));


% profile on;

%% options for solver
tol = 1e-11;
verbose = false;
verbosePlot = false;
options.verbose=verbose;
options.verbosePlot=verbosePlot;
options.maxiter = 2000;
options.tol = tol;
options.modprint = 10; % >0 for showing iterations


%% options for problem generation (This is only used for generating probs)
% problem order 
% for MC, var X in Sn; 
% for QAPFR var X in S^{(n-1)^2+1})
% for QAPnoFR var X in S^{n^2+1}
optionsProbGen.probOrder = 10; %(=n)

% number of times problems are generated; 
optionsProbGen.genNum = 15;    

% output file name
optionsProbGen.filename = 'tempfileMCQAP.tex';

%% Call instances and solver
% set problem list 
problemList = ["MC"',"QAPFR","QAPnoFR"];
tablegeneratorMCQAP(problemList,optionsProbGen,options)


 % profile report;
