function tablegeneratorMCQAP(problemList,optionsProbGen,options)

% This function generates the tables for each one of the experiments
% It is particularly made for MC and QAP instances.  
% This function calls the function 'runMCQAP.m' to form the instances and
% call the algorithm. 

% INPUT:
%       problemList : problem names = ["MC"',"QAPFR","QAPnoFR"]
%       optionsProbGen : options used for generating problems
%            .isXrankOne = boolean; 
%                  true = generate problem so that rank(optimal solution)=1
%                  false = random
%       options : solver (algorithm) options
% OUTPUT: .tex file named 'filename'

if isfield(optionsProbGen,'filename')
    filename = optionsProbGen.filename;
else
    filename = 'noNameFile';
end

% experiment 1: run under the rank(opt.X)=1 setting
optionsProbGen.isXrankOne = true; % true for setting rank-one.
fprintf(2, 'from tablegeneratorMCQAP.m: ')
fprintf(2, 'Start first loop of test under the setting, isXrankOne=true\n\n')
[resultSemiXrankOne,resultCvxXrankOne] = runMCQAP(problemList,optionsProbGen,options);
% output of runMCQAP is an averageed values

% experiment 2: run under the random W setting
optionsProbGen.isXrankOne = false; % false for setting random W
fprintf(2, 'from tablegeneratorMCQAP.m: ')
fprintf(2, 'Start second loopg of test under the setting, isXrankOne=false\n\n')
[resultSemiRandomW,resultCvxRandomW] = runMCQAP(problemList,optionsProbGen,options);


% tables are ready
dataXrankOne = [resultSemiXrankOne, resultCvxXrankOne];
dataRandomW = [resultSemiRandomW, resultCvxRandomW];


% form the .tex table format
fid = fopen(filename, 'w');
 
fprintf(fid, '%s\n', '\begin{tabular}{c|l|cccccc|ccccc}'); 
fprintf(fid, '%s\n', '\toprule'); 
fprintf(fid, '%s\n', '\multirow{2}{*}{$W$ Generation} & \multirow{2}{*}{Problem} & \multicolumn{6}{c|}{Semi-Smooth Newton} & \multicolumn{5}{c}{SDPT3}  \\'); 
fprintf(fid, '%s\n', ' & & pf & df & cs &   $k$ & time  & $\mathrm{cond}(F^\prime(y^k))$ & pf & df & cs &    $k$ & time\\'); 
fprintf(fid, '%s\n', '\midrule'); 

fmt1 = ['%1.0e & %1.0e &  %1.0e & %4.1f & %1.0e  & %1.0e & %1.0e & %1.0e &  %1.0e & %4.1f & %1.0e \\\\'];

probHeaders = ["& Elliptope",
               "$W$, $\\rank(\\bar{X})=1$ & $\\QAPp_{\\FR}$",
               "& \\QAP"];
for jj = 1:3
    fprintf(fid, probHeaders(jj));
    fprintf(fid,  ' & ');
    fprintf(fid, fmt1, dataXrankOne(jj,:) );
end % end of  'for jj = 1:numRows'

fprintf(fid, '%s\n', '\midrule'); 
probHeaders = ["& Elliptope",
               "random $W$ & $\\QAPp_{\\FR}$",
               "& \\QAP"];

for jj = 1:3
    fprintf(fid, probHeaders(jj));
    fprintf(fid,  ' & ');
    fprintf(fid, fmt1, dataRandomW(jj,:) ); 
end % end of  'for jj = 1:numRows'


fprintf(fid, '%s\n', '\bottomrule'); 
fprintf(fid, '\\end{tabular}\n');
fclose(fid);
end % function
