%****************************************************
%  The formulation is inspired by the example, corrmat, from SDPT3 package;
%  Modified from corrmat.m script from SDPT3 package by
%  Kim-Chuan Toh, Michael J. Todd, Reha H. Tutuncu
%  
%  Formulate this minimization problem
%  min || X - W ||_F
%  s.t.  trace(Ai,X) = b_i, X psd.
%
%  this problem (using the second order and semidefinite cone)
%  min   t
%  s.t.  trace(Ai,X) = b_i
%        svec(X) + y = svec(H),
%        X psd, ||y||_2 <= t.
%*****************************************************************



function [blk,At,C,b] = formSDPT3Const(W,Acell,bconst)
%function [blk,At,C,b] = formSDPT3Const(W,Acell,bconst)

n = length(W);
n2 = n*(n+1)/2;

Acell = reshape(Acell,1,length(bconst));
blk{1,1} = 's'; blk{1,2} = n;
%    for k=1:n;
%        AA{1,k} = spconvert([k,k,1; n,n,0]);
%    end;
matrepdiag = svec(blk(1,:),Acell);
At{1,1} = [matrepdiag{1},  speye(n2)];

%    At{1,1} = [Aconst',  speye(n2)];

blk{2,1} = 'q'; blk{2,2} = n2+1;
%    At{2,1} = [sparse(n,n2+1); sparse(n2,1), speye(n2)];
At{2,1} = [sparse(length(bconst),n2+1); sparse(n2,1), speye(n2)];
b = [bconst; svec(blk(1,:),W)];

C{1,1} = sparse(n,n); C{2,1} = [1; zeros(n2,1)];

end