function [A,b,options] = MakeProblemMC(n,options)
%function [A,b] = MakeProblemMC(n,svind)
%%%%% MakeProblemMC
%
%Create data for an elliptope = {X psd : diag(X) = e}
% input:  n : order of Elliptope
%         options : solver options passed to this function to append svindn, sMindn
% output: (A,b) data for A*svec(X) = b
%         options: solver options  
%         options.Acell for sdpt3 solver
%         options.svindn = svindn;
%         options.sMindn = sMindn;



fprintf('In MakeProblemMC.m: Generating the elliptope of order=%d \n',n)

%% for ssMat/ssvec
[svindn, sMindn] = svecIsoInd(n);
options.svindn = svindn;
options.sMindn = sMindn;

tn = n*(n+1)/2;
A = zeros(n,tn);
Zn = zeros(n,n);
for ii = 1:n
    temp = Zn;
    temp(ii,ii) = 1;
    A(ii,:) = ssvec(temp,svindn)';
    Acell{ii} = temp;
end

b = ones(n,1);  % rhs
options.Acell = Acell;

end     %end function










