function [lindsp,PS,NS] = projK(S)
%function [lindsp,PS,NS] = projK(S)
%% Project the given/input symmetric S onto the SDP+ and SDP- cone
%% This is an application of the Eckart-Young Theorem.
%%INPUT  S symm. matrix
%%OUTPUT  lindsp #of nonneg. eigs in projected matrix PS
if ~issymmetric(S)
	fprintf('ERROR in symmetry in projK\n')
	keyboard
end
[u,d] = eig(S);
d = diag(d);
indsp = find(d>=0);
indsn = setdiff(1:length(S),indsp);
lindsp = length(indsp);
PS = u(:,indsp)*diag(d(indsp))*u(:,indsp)';
NS = -u(:,indsn)*diag(d(indsn))*u(:,indsn)';  % **pos** semidef
%PS = (PS + PS')/2;  % no need to symmetrize as svec is used?????
end
