function h = eigplotgenerator(eigsk,options)
% Generates a plot showing the evolution of the eigenvalues of
% the Jacobian along the iterations of the method
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Input:
%       eigsk - column k contains the eigvalues of Jac at iteration k
%       options - 
%               options.k  - number of iterations run by the method
%               options.savename - name for saving the plot
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

k = options.k;
eigsk = eigsk(1:k,:);
if isfield(options,'savename')
    savename = options.savename;
end


m = size(eigsk,2);
xaxis = 1:k;

h = figure;
for ii=1:m
semilogy(xaxis,eigsk(:,ii),'linewidth', 1);hold on;
end
%legend("Location", "best",'Interpreter','latex','fontsize',11);
axis tight
xlabel('k')
ylabel("\lambda_i(F'(y_k))")

if isfield(options,'savename')
    set(h,'Units','Inches');
    pos = get(h,'Position');
    set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)])
    %filename = ['..\latexfileAltProjDRnDikstra\Images\' ,savename,'.pdf'];
    filename = ['Images\' ,savename,'.pdf'];
    %filename = [savename,'.pdf'];
    print(h,filename,'-dpdf','-r0');
end

