function isdegen = degenChecker(X,A,options)
%function isdegen = degenChecker(X,A,options)

% This function checks the consition
%   'conguate face of face(X,Snp)' intersection 'range(A^*)' = {0}
% Citation: 
% X: a point of interest, size n-by-n, psd
% A: linear mapping from R^{t(n)} to R^m
% options : .svindn  - indices used for ssvec
%           .sMindn  - indices used for ssMat
%           .tol     - used for 0 eigenvalue cutoff

% output : isgen : boolean, true for indicating X is degenerate

% Note: This function does NOT check the feasibility of the point X 
%       It assumes the feasibility to A(X)=b




n = size(X,1);
if isfield(options,'svindn')
    svindn = options.svindn;
else
    svindn = find(triu(ones(n),1)); % matrix indices for the strictly upper triangular
end
if isfield(options,'sMindn')
    sMindn = options.sMindn;
else
    sMindn = zeros(n^2,1); %matrix indices with respect to linear indices of the diagonal and the strictly upper triangle
    tn = n*(n+1)/2;
    sMindn(svindn) = 1:tn-n; %strictly upper triangle
    sMindn(1:n+1:n^2) = tn-n+1:tn;%the diagonal
    %calculate the linear indices of the strictly lower triangle
    indMn = zeros(n); %matrix indices
    indMn(:) = 1:n^2;
    indMn = indMn';
    lsvindn = indMn(svindn); %strictly lower triangular
    sMindn(lsvindn) = 1:tn-n; %strictly lower triangular
end

m = size(A,1);

% The steps below follow prof.Pataki 
[U,d] =  eig(X,'vector');
dposInd = find(d>options.tol);
V = U(:,dposInd);  % range(V) = range(X)
Vbar = U(:,setdiff(1:n,dposInd));
r = length(dposInd);

Acell  = cell(m,1);
for ii=1:m
    Acell{ii} = ssMat(A(ii,:)',n,sMindn);
end

% Neds some improvements here! 
% Do not consider the zero bottom diagonal block for accuracy
% Check matrices in Acell are linearly indepedent by forming matrix L
Zn = zeros(n);
L = zeros(n*(n+1)/2,m);
for ii=1:m
    temp = Zn;
    temp(1:r,1:r) = V'*Acell{ii}*V;
    tempOff = V'*Acell{ii}*Vbar;
    temp(1:r,r+1:end) = tempOff;
    temp(r+1:end,1:r) = tempOff';
    L(:,ii) = ssvec( temp,svindn);
end

% check the rank of L
if rank(L)<m
    isdegen = true;
else
    isdegen = false;
end

end
