%using fastlinux: cpu157.math.private 	Dell PowerEdge R660 	Two Intel Xeon Gold 6434 %8-core 3.7 GHz (Sapphire Rapids) 	256 GB`
% For Figure 4.1  size versus cpu time illustrating slow growth in time.
% The default is for all sets to have the same size n.
clear
%profile clear
%profile on
addpath(genpath('.'))

%%% Start options for table testing, test type, and file name
numProbs = 2;    % number of problems per data type

% type of test:
% use 'sizeK' for varying m
% use 'sizeN' for varying n
% use dense for varying density 
%teststr = 'sizeN'; 
%teststr = 'sizeK'; 
teststr = 'sizeDKN'; 

% file number
numstr = '2';  % number of instances per test for average
% file name for saving the table in runTablestests.m
filename = strcat(teststr,numstr,'.tex');

% Options for run-file

options.admm = true;   % use admm solver or set false
options.cvx = false;   % use cvx solver or set false
options.algo3 = false;   % use new algo solver or set false; not available
%%%% currently on have the option of ALL 3 or only FIRST TWO!!!!
%%%% or just admm

if options.cvx
	%%%% set the default solver in cvx by uncommenting the line
	%options.solver = 'SDPT3';  % use one of: Mosek; SDPT3; SeDuMi
	options.solver = 'Mosek';  % use one of: Mosek; SDPT3; SeDuMi
	%options.solver = 'SeDuMi';  % use one of: Mosek; SDPT3; SeDuMi
	[solver, ~] = cvx_solver;  % find current solver
	if strcmp(options.solver,'SDPT3')
		if ~strcmp(options.solver,solver)
			cvx_solver sdpt3
		end
		cvx_precision low
	elseif strcmp(options.solver,'Mosek')
		if ~strcmp(options.solver,solver)
			cvx_solver mosek
		end
		cvx_precision high
	elseif strcmp(options.solver,'SeDuMi')
		if ~strcmp(options.solver,solver)
			cvx_solver sedumi
		end
		cvx_precision medium
	end
	fprintf('setting default solver to %s \n',options.solver)
end



if mod(eval(numstr),2) == 1
    options.tol = 1e-8;
else
    options.tol = 1e-12;
end
maxiter = 12000;  % for ADMM solver
options.maxiter = maxiter;
verbose = false;
options.verbose = verbose;
epsilon = 1e-13;  % stopping accuracy
options.epsilon = epsilon;
eta = 1e-10;      % rounding accuracy for Y
options.eta = eta;
gamma = .9;   % should be < 1 for convergence
options.gamma = gamma;

dd = [];
nn = [];
kk = [];

%%% three column vectors with the data for generating problems
%%% the lengths of the vectors should all be the same 
%%% as they are solved as  dd(i) kk(i) nn(i) i=1,2...
%% to get increasing sizes use e.g. kron(ones(3,1),dd)
switch teststr
    case 'sizeDKN'
    % %%% increasing size
    %%% the following three lines are used for the figure 4.1 in paper
    dd = (3:3:27)';   % embedding dimensions
    kk = (36:2:50)';   % sumber of sets
    nn = (47:1:60)';  % sumber of points per set
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% the following three lines with small values are used to test this  file 
    %dd = (2:1:3)';  %(2:1:5)'; % embedding dimensions
    %kk = (6:1:7)';  %(5:1:8)'; % sumber of sets
    %nn = (7:1:8)'; %(7:1:10)'; % sumber of points per set
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%% following for kron approach
    %dd = kron(ones(3,1),(2:1:4)');  %(2:1:5)'; % embedding dimensions
    %kk = kron(ones(3,1),(5:1:7)');  %(5:1:8)'; % sumber of sets
    %nn = kron(ones(3,1),(7:1:9)'); %(7:1:10)'; % sumber of points per set
    
    case 'sizeN'  % changing only n
    %dd = (2:1:8)'; % embedding dimensions
    %kk = (5:1:11)'; % sumber of sets
    %nn = (7:1:13)'; % sumber of points per set
    dd = 5; % embedding dimensions
    kk = 22; % sumber of sets
    nn = (7:1:12)'; % sumber of points per set
    
    otherwise
        fprintf('Entered incorrect case value, make sure str is equal to one of [Msize;Nsize;dense]')
        keyboard
end
    %% Run tests
runMainvaryingnj(nn, dd, kk, numProbs, filename, teststr, numstr, options);
%profile report
