%% For large problems using sADMM on biglinux
%cpu160.math.private 	Dell PowerEdge R6625 	
%two AMD EPYC 9754 128-core 2.25 GHz 	1.5 TB
clear
%% to have matlab run/not-run profile change to true/false
profileon = false;
if profileon
	profile clear
	profile on
end
addpath(genpath('.'))  % the solvers/auxiliary files are in subfolders

%%% Start options for table testing, test type, and file name
numProbs = 2;    % number of problems/instances per data type/per test

% type of test:
% use 'sizeK' for varying m
% use 'sizeN' for varying n
%teststr = 'sizeN'; 
%teststr = 'sizeK'; 
teststr = 'sizeDKN';   % varies all d,k,n

% add file number to filename
numstr = num2str(numProbs);  % number of instances per test for average
% file name for saving the table in runTablestests.m
filename = strcat(teststr,numstr,'.tex');

% Options for run-file

options.admm = true;   % use admm solver or set false
options.cvx = false;   % use cvx solver or set false
options.algo3 = false;   % use new algo solver or set false; not available
%%%% currently on have the option of only admm, admm and cvx, all three

if options.cvx
	%%%% set the default solver in cvx by uncommenting the line
	%options.solver = 'SDPT3';  % use one of: Mosek; SDPT3; SeDuMi
	%options.solver = 'Mosek';  % use one of: Mosek; SDPT3; SeDuMi
	options.solver = 'SeDuMi';  % use one of: Mosek; SDPT3; SeDuMi
	[solver, ~] = cvx_solver;  % find current solver
	if strcmp(options.solver,'SDPT3')
		if ~strcmp(options.solver,solver)
			cvx_solver sdpt3
		end
		cvx_precision low
	elseif strcmp(options.solver,'Mosek')
		if ~strcmp(options.solver,solver)
			cvx_solver mosek
		end
		cvx_precision high
	elseif strcmp(options.solver,'SeDuMi')
		if ~strcmp(options.solver,solver)
			cvx_solver sedumi
		end
		cvx_precision medium
	end
	fprintf('setting default solver to %s \n',options.solver)
end



if mod(eval(numstr),2) == 1
    options.tol = 1e-8;
else
    options.tol = 1e-12;
end
maxiter = 12000;  % for ADMM solver
options.maxiter = maxiter;
verbose = false;
options.verbose = verbose;
epsilon = 1e-13;  % stopping accuracy
options.epsilon = epsilon;
eta = 1e-10;      % rounding accuracy for Y
options.eta = eta;
gamma = .9;   % should be < 1 for convergence
options.gamma = gamma;

options.varyingn = false;   % to vary size of n for each set
if options.varyingn
	options.nnvary = 5;   % size of interval for varying n
end
	

dd = [];
nn = [];
kk = [];

%%% three column vectors with the data for generating problems
%%% the lengths of the vectors should all be the same 
%%% as they are solved as  dd(i) kk(i) nn(i) i=1,2...
%% to get increasing sizes use e.g. kron(ones(3,1),dd)
switch teststr
    case 'sizeDKN'
    % %%% 
    %%% following three lines are for testing the large scale problems
    dd = (8:1:9)';  %(2:1:5)'; % embedding dimensions
    kk = (60:1:62)';  %(5:1:8)'; % sumber of sets
    nn = (80:1:81)'; %(7:1:10)'; % sumber of points per set
    %%% following three lines are for testing the file
    %dd = (2:1:3)';  %(2:1:5)'; % embedding dimensions
    %kk = (6:1:7)';  %(5:1:8)'; % sumber of sets
    %nn = (8:1:9)'; %(7:1:10)'; % sumber of points per set
    %% number of points per set could be n_j for n_j in interval
    %dd = kron(ones(3,1),(2:1:4)');  %(2:1:5)'; % embedding dimensions
    %kk = kron(ones(3,1),(5:1:7)');  %(5:1:8)'; % sumber of sets
    %nn = kron(ones(3,1),(7:1:9)'); %(7:1:10)'; % sumber of points per set
    
    case 'sizeN'  % changing only n
    %dd = (2:1:8)'; % embedding dimensions
    %kk = (5:1:11)'; % sumber of sets
    %nn = (7:1:13)'; % sumber of points per set
    dd = 5; % embedding dimensions
    kk = 22; % sumber of sets
    nn = (7:1:12)'; % sumber of points per set
    
    otherwise
        fprintf('Entered incorrect case value, make sure str is equal to one of [Msize;Nsize;dense]')
        keyboard
end
    %% Run tests
runMainvaryingnj(nn, dd, kk, numProbs, filename, teststr, numstr, options);
if profileon
	profile report
end
