function  ...
   runMainvaryingnj(nn, dd, kk, numProbs, filename, ...
         teststr, numstr, options)
%%% This function draws tables and plots that compare the performances of 
%%% ADMM??? with ????? algors in Jason's paper? and with cvx?
%INPUT: nn,dd,kk   % col. vectors with data for generating problems
%  numProbs   # of probs for each choice of nn,dd,kk
%  filename   filename to use for the output table
%  teststr   name to add to filename for output table
%  numstr   ?????????? numProbs????

%%% Options for solvers
if isfield(options,'maxiter')
    maxiter = options.maxiter;
else
    maxiter = 1e5;
end
if isfield(options,'verbose')
    verbose = options.verbose;
else
    verbose = false;
end
if isfield(options,'epsilon')  % stopping criteria accuracy
    epsilon = options.epsilon;
else
    epsilon = 1e-13;
end
if isfield(options,'eta')  % rounding accuracy for Y
    eta = options.eta;
else
    eta = 1e-13;
end
if isfield(options,'gamma')  % dual step length
    gamma = options.gamma;
else
    gamma = .9;
end
params.gamma = gamma;  % should be < 1 for convergence
if isfield(options,'admm')  % use admm as one solver
    admm = options.admm;
else
    admm = true;
end
if isfield(options,'cvx')  % use cvx as one solver
    cvx = options.cvx;
else
    cvx = true;
end
if isfield(options,'algo3')  % use algo3 as one solver
    algo3 = options.algo3;
else
    algo3 = true;
end
if isfield(options,'varyingn')  % value of size n_j varies for j in [k]
	varyingn = options.varyingn;
	if isfield(options,'nnvary')  % value of size n_j varies for j in [k]
		nnvary = options.nnvary;
	else
		nnvary = 5;
	end
else
        varyingn = false;
end




if admm %%% For ADMM solver
	timeADMM = zeros(length(nn), numProbs);
	iterADMM = zeros(length(nn), numProbs);
	relgapsADMM = zeros(length(nn), numProbs);
	relKKTresADMM = zeros(length(nn), numProbs);
end

if cvx %%% For CVX solver
	timeCVX = zeros(length(nn), numProbs);
	relgapsCVX = zeros(length(nn), numProbs);
end


if algo3 %%% For algo3 solver
	timealgo3 = zeros(length(nn), numProbs);
	relgapsalgo3 = zeros(length(nn), numProbs);
end


lls = 0;
for td = 1:size(dd,1)
	for tk = 1:size(kk,1)
		for tn = 1:size(nn,1)
			lls = lls + 1;
			ddkknn(lls,:) = [dd(td) kk(tk)  nn(tn)]; 
		end
	end
end
knsizes = ddkknn(:,2).*ddkknn(:,3);   % total number of points for instance
[~,indsknsizes]  = sort(knsizes);   % indices for nondecreasing sizes for plot
for ll = 1:lls  % running instance ll
    %%% Problem parameters
    params.d    = ddkknn(ll,1);
    d=params.d;
    params.k    = ddkknn(ll,2);
    k=params.k;

    %%%%% take average over numProbs (done in the end) %%%%
    for pp=1:numProbs %%% so this is to test numProbs for each test class
        params.n    = ddkknn(ll,3);   % to avoid reset in generate function
        n=params.n;
        params.seed = pp;
	beta = (k*n)/2;  % usual penalty param.  ???? what is correct???
	params.beta = beta;
       %params.seed = 'shuffle';  % parameter for rng(seed)
        if options.verbose
            disp('-------------------------------------------------');
            disp(params);
        end
	%% generate random problem
       [V , Gtmp, Dbar0, params] = generateWassProbvaryingnj(params,options);
       n = params.n; % is changed to vector if varyingn is true
       if length(n) == 1
	       N(pp) = k*n;  % total number of points/size of prob
       else
	       N(pp) = sum(n);  % total number of points/size of prob
       end
       Gtmp0 = Gtmp;
       Gtmp0(1,1) = 0;  % for gangster without Y(1,1)
       fprintf('New Problem with (d k sum(n)) = (%i  %i  %i) \n',d,k,sum(n))
    %% solve for the generated problem
        %%% Solve problem with ADMM
	%[outputADMM, Yadmm, Radmm, Zadmm] = ...   % if needed
	if admm  
        	tic 
		[outputADMM, ~, ~, ~] = ... 
			ADMMsolver(V, n, k, d,  Gtmp, Dbar0, params,  options);
        	timeADMM(ll,pp) = toc;
        	iterADMM(ll,pp) = outputADMM.iter;
        	relgapsADMM(ll,pp) = outputADMM.relgaps(end);
        	relKKTresADMM(ll,pp) = outputADMM.KKTres;
	end
        
	if cvx  
        	tic
    		[outputCVX, ~, ~] = CVXsolver(Dbar0, n, k, Gtmp, V);
        	timeCVX(ll,pp) = toc;
        	relgapsCVX(ll,pp) = outputCVX.relgap;
        	%timeCVX(ll,pp) = 0;  % temporary
        	%relgapsCVX(ll,pp) = 0;  % temporary
	end
	if exist('outputCVX.lbd') && outputCVX.lbd > max(outputADMM.LBS)
		fprintf('error in lower bound for cvx?? \n')
		keyboard
	end

        
	if algo3  
        	tic
    		%[outputalgo3, ~, ~] = algo3(Dbar0, n, k);  %???? not done yet
        	%timealgo3(ll,pp) = toc;
        	%relgapsalgo3(ll,pp) = outputalgo3.relgap;
        	timealgo3(ll,pp) = 0;  % ???? not done yet???
        	relgapsalgo3(ll,pp) = 0;  % ???? not done yet???
	end
    end   %for pp=1:numProbs
    ddkknn(ll,3) = mean(N);  % set to N/size after generateW.... for fprintf
end %for ll = 1:lls  % running instance ll

%%% Organize strings for tables in LaTeX


if admm && cvx && algo3
   
   %allLocalized=true;   % should include the number of failures in the table
   
   fmt1 = '%5.0f & %5.0f & %5.0f &';
   
   % if allLocalized
   %     fmt2 = '';
   % else
   %     fmt2 = '%9.1f & ';
   % end
   
   % fmt3 = [strcat('%7.2e & %7.2e & %7.2e & %7.2e &', ...
   %         ' %7.2f & %7.2f & %7.2f & %7.2f &',... 
   %         ' %7.2e & %7.2e & %7.2e & %7.2e &',...
   %         ' % 7.2e & %7.2e & %7.2e & %7.2e &',...
   %         ' %7.2f & %7.2f & %7.2f & %7.2f &')];
   
   
   fmt3 = '%7.2f & %7.2f & %7.2f & %7.1e & % 7.1e & %7.1e';
   
   %fmt3 = '%7.2f & %7.2f & %7.2f & %7.2f & %7.2f & %7.2e & %7.2e';
   fmt4 = ' \\cr\\hline\n';
   fmt5 = '\\cr\\cline{1-9}\n';
   
   hfmt1 = regexprep(fmt1, '(\.[0-9])*[def] ', 's');
   %hfmt2 = regexprep(fmt2, '(\.[0-9])*[def]', 's');
   hfmt3 = regexprep(fmt3, '([0-9]\.[0-9])*[defi]', '7s');
   
   localfilename = strcat('AdmmCvxAlgo3',filename);
   fid = fopen(localfilename, 'w');
   
   fprintf(fid, '%s\n', '\begin{tabular}{|ccc||ccc|ccc|} \hline');
   % fprintf(fid, '%s', [...
   %     '\multicolumn{3}{|c||}{dim/sets/size} & ', ...
   %     '\multicolumn{4}{|c|}{Time (s)} & ', ...
   %     '\multicolumn{4}{|c|}{Iter.} &', ... 
   %     '\multicolumn{4}{|c|}{Rel. Resid.} &', ...
   %     '\multicolumn{4}{|c|}{Rel. Dist. to Sol.} &', ...
   %     '\multicolumn{4}{|c|}{Max. Iter.}']);
   
   fprintf(fid, '%s', [...
       '\multicolumn{3}{|c||}{dim/sets/size} & ', ...
       '\multicolumn{3}{|c|}{time (s)} & ', ...
       '\multicolumn{3}{|c|}{rel. duality gap}']);
   
   fprintf(fid, fmt5);
   fprintf(fid, hfmt1, '$d$', '$k$', '$N$');
   fprintf(fid, hfmt3, ...
       'ADMM', 'CVXsolver', ...
       'algo3', 'ADMM', ...
       'CVXsolver', 'algo3');
   
   fprintf(fid, fmt4);
   
   %%% Organize Data for tables
   
   for jj = 1:lls  % all instances
       fprintf(fid, fmt1, ddkknn(jj,1), ddkknn(jj,2), ddkknn(jj,3));
       %%% Computing averages of ADMM testing solver performance across 
       %%% i = 1:length(nn) datasets
       ADMM.avertimeADMM(jj) = mean(timeADMM(jj,:));
       ADMM.averiterADMM(jj) = mean(iterADMM(jj,:));
       ADMM.averrelgapsADMM(jj) = mean(relgapsADMM(jj,:));
       ADMM.averrelKKTresADMM(jj) = mean(relKKTresADMM(jj,:));
       
       CVX.avertimeCVX(jj) = mean(timeCVX(jj,:));
       ALGO3.avertimealgo3(jj) = mean(timealgo3(jj,:));
   
       %%% Computing medians of ADMM testing solver performance across 
       %%% i = 1:length(nn) datasets
       ADMM.medtimeADMM(jj) = median(timeADMM(jj,:));
       ADMM.mediterADMM(jj) = median(iterADMM(jj,:));
       ADMM.medrelgapsADMM(jj) = median(relgapsADMM(jj,:));
       ADMM.medrelKKTresADMM(jj) = median(relKKTresADMM(jj,:));
   
       fprintf(fid, fmt3, ADMM.avertimeADMM(jj), CVX.avertimeCVX(jj), ...
                          ALGO3.avertimealgo3(jj), ...
			  mean(relgapsADMM(jj,:)), ...
                          mean(relgapsCVX(jj,:)), mean(relgapsalgo3(jj,:)));
       fprintf(fid, fmt4);
   end
   fprintf(fid, '\\end{tabular}\n');
   fclose(fid);
   
   %%% Save structs for plots in loadData.m  ???????change???????
   %ADMM1str = strcat('ADMM');
   %CVXstr = strcat('CVX');
   %%% Save Averages
   % Average CPU Time
   %%%%%%%%%%%%???????remove try and catch?????????
   %%try 
   %%    save(strcat('data_tables/',teststr,'HLWB1',numstr,'.mat'),'-struct',HLWB1str)
   %%    save(strcat('data_tables/',teststr,'HLWB2',numstr,'.mat'),'-struct',HLWB2str)
   %%catch
   %%    %%% You are probably in the wrong file directory if this happens, just
   %%    %%% go to the tabletestresultsfiles folder and copy the code in the try
   %%    %%% section
   %%end
   %%
   


   elseif admm && cvx && ~algo3   % only first two
      fmt1 = '%5.0f & %5.0f & %5.0f &';
      fmt3 = '%7.2f & %7.2f & %7.1e & % 7.1e ';
      fmt4 = ' \\cr\\hline\n';
      fmt5 = '\\cr\\hline';
      hfmt1 = regexprep(fmt1, '(\.[0-9])*[def] ', 's');
      hfmt3 = regexprep(fmt3, '([0-9]\.[0-9])*[defi]', '7s');
      
      localfilename = strcat('AdmmCvx',filename);
      fid = fopen(strcat('AdmmCvx',filename), 'w');
      
      fprintf(fid, '%s\n', '\begin{tabular}{|ccc||cc|cc|} \hline');
      fprintf(fid, '%s', [...
          '\multicolumn{3}{|c||}{dim/sets/size} & ', ...
          '\multicolumn{2}{|c|}{Time (s)} & ', ...
          '\multicolumn{2}{|c|}{rel. duality gap}']);
      
      fprintf(fid, fmt5);
      fprintf(fid, hfmt1, '$d$', '$k$', '$N$');
      fprintf(fid, hfmt3, ...
          'ADMM', 'CVXsolver', ...
           'ADMM', 'CVXsolver');
      
      fprintf(fid, fmt4);
      
      %%% Organize Data for tables
      
      for jj = 1:lls  % all instances
          fprintf(fid, fmt1, ddkknn(jj,1), ddkknn(jj,2), ddkknn(jj,3));
          %%% Computing averages of ADMM testing solver performance across 
          %%% i = 1:length(nn) datasets
	  if admm
          	ADMM.avertimeADMM(jj) = mean(timeADMM(jj,:));
          	ADMM.averiterADMM(jj) = mean(iterADMM(jj,:));
          	ADMM.averrelgapsADMM(jj) = mean(relgapsADMM(jj,:));
          	ADMM.averrelKKTresADMM(jj) = mean(relKKTresADMM(jj,:));
	  end
          
	  if cvx
          	CVX.avertimeCVX(jj) = mean(timeCVX(jj,:));
	  end
	  if algo3
          	ALGO3.avertimealgo3(jj) = mean(timealgo3(jj,:));
	  end
      
          %%% Computing medians of ADMM testing solver performance across 
          %%% i = 1:length(nn) datasets
	  if admm
          	ADMM.medtimeADMM(jj) = median(timeADMM(jj,:));
          	ADMM.mediterADMM(jj) = median(iterADMM(jj,:));
          	ADMM.medrelgapsADMM(jj) = median(relgapsADMM(jj,:));
          	ADMM.medrelKKTresADMM(jj) = median(relKKTresADMM(jj,:));
	  end
      
          fprintf(fid, fmt3, ADMM.avertimeADMM(jj), CVX.avertimeCVX(jj), ...
                              mean(relgapsADMM(jj,:)), ...
                             mean(relgapsCVX(jj,:)));
          fprintf(fid, fmt4);
      end
      fprintf(fid, '\\end{tabular}\n');
      fclose(fid);
      
      %%% Save structs for plots in loadData.m  ???????change???????
      %ADMM1str = strcat('ADMM');
      %CVXstr = strcat('CVX');
      %%% Save Averages
      % Average CPU Time
      %%%%%%%%%%%%???????remove try and catch?????????
      %%try 
      %%    save(strcat('data_tables/',teststr,'HLWB1',numstr,'.mat'),'-struct',HLWB1str)
      %%    save(strcat('data_tables/',teststr,'HLWB2',numstr,'.mat'),'-struct',HLWB2str)
      %%catch
      %%    %%% You are probably in the wrong file directory if this happens, just
      %%    %%% go to the tabletestresultsfiles folder and copy the code in the try
      %%    %%% section
      %%end
      %%
      

   elseif admm && ~cvx && ~algo3   % only admm
      fmt1 = '%5.0f & %5.0f & %5.0f & ';
      fmt3 = '%7.2f & % 7.1e ';
      fmt4 = ' \\cr\\hline\n';
      fmt5 = '\\cr\\cline{1-9}\n';
      hfmt1 = regexprep(fmt1, '(\.[0-9])*[def] ', 's');
      hfmt3 = regexprep(fmt3, '([0-9]\.[0-9])*[defi]', '7s');
      
      localfilename = strcat('Admm',filename);
      fid = fopen(strcat('Admm',filename), 'w');
      
      fprintf(fid, '%s\n', '\begin{tabular}{|ccc||c|c|} \hline');
      fprintf(fid, '%s', [...
          '\multicolumn{3}{|c||}{dim/sets/size} & ', ...
          '{Time (s)} & ', ...
          '{rel.duality gap}']);
      
      fprintf(fid, fmt4);
      fprintf(fid, hfmt1, '$d$', '$k$', '$N$');
      fprintf(fid, hfmt3, 'ADMM',  'ADMM');
      
      fprintf(fid, fmt4);
      
      %%% Organize Data for tables
      
      for jj = 1:lls  % all instances
          fprintf(fid, fmt1, ddkknn(jj,1), ddkknn(jj,2), ddkknn(jj,3));
          %%% Computing averages of ADMM testing solver performance across 
          %%% i = 1:length(nn) datasets
	  if admm
          	ADMM.avertimeADMM(jj) = mean(timeADMM(jj,:));
          	ADMM.averiterADMM(jj) = mean(iterADMM(jj,:));
          	ADMM.averrelgapsADMM(jj) = mean(relgapsADMM(jj,:));
          	ADMM.averrelKKTresADMM(jj) = mean(relKKTresADMM(jj,:));
	  end
          
      
          %%% Computing medians of ADMM testing solver performance across 
          %%% i = 1:length(nn) datasets
	  if admm
          	ADMM.medtimeADMM(jj) = median(timeADMM(jj,:));
          	ADMM.mediterADMM(jj) = median(iterADMM(jj,:));
          	ADMM.medrelgapsADMM(jj) = median(relgapsADMM(jj,:));
          	ADMM.medrelKKTresADMM(jj) = median(relKKTresADMM(jj,:));
	  end
      
	  %% why does this echo 20????????????????
          %fprintf(fid, fmt3, ADMM.avertimeADMM(jj),mean(relKKTresADMM(jj,:)));
          fprintf(fid, fmt3, ADMM.avertimeADMM(jj),mean(relgapsADMM(jj,:)));
          fprintf(fid, fmt4);
      end
      fprintf(fid, '\\end{tabular}\n');
      fclose(fid);
      
      %%% Save structs for plots in loadData.m  ???????change???????
      %ADMM1str = strcat('ADMM');
      %CVXstr = strcat('CVX');
      %%% Save Averages
      % Average CPU Time
      %%%%%%%%%%%%???????remove try and catch?????????
      %%try 
      %%    save(strcat('data_tables/',teststr,'HLWB1',numstr,'.mat'),'-struct',HLWB1str)
      %%    save(strcat('data_tables/',teststr,'HLWB2',numstr,'.mat'),'-struct',HLWB2str)
      %%catch
      %%    %%% You are probably in the wrong file directory if this happens, just
      %%    %%% go to the tabletestresultsfiles folder and copy the code in the try
      %%    %%% section
      %%end
      %%

end  % end of if admm && cvx && algo3



%%% Save Averages
% Average CPU Time
system(['cat ', localfilename]);
%%%comment out the copy;  cp is not a windows command! only for Henry's machine
%system(['cp ', localfilename, ' data_tables' ]); % most recent table
%system(['cp ', localfilename, ...
%	' ../AMWonWassersteinMClatexfiles/data_tables']); % most recent table
fprintf('The table file is moved to the localdatatables folder\n')
system(['mv ', localfilename, ...
	' localdatatables']); % most recent table
orderedknsizes = knsizes(indsknsizes);
incr = (1e-3/length(orderedknsizes))*(1:length(orderedknsizes));
if verbose
	figure(1)
	clf
	plot(orderedknsizes+incr',ADMM.avertimeADMM(indsknsizes),'-x')
	title('instances increasing sizes kn versus time')
	xlabel('kn+eps')
	ylabel('cpu solve time')
end
end    % of function file
