function [Vhat , Gtmp, Dbar0, params] = generateWassProb(params,options)
%Data  for Solver - move to solver eventually???????????????
seed = params.seed;
rngsave = rng(seed);
n = params.n;   % changed to vector of sizes if varyingn true
d = params.d;
k = params.k;

if isfield(options,'usewheel')
    usewheel = options.usewheel;
else
    usewheel = false;
end

if isfield(options,'varyingn')
        varyingn = options.varyingn;
	if isfield(options,'nnvary')
    	nnvary = options.nnvary;
	else
    	nnvary = 5;
	end
else
        varyingn = false;
end





%Construct EDM by data P
if usewheel
	fprintf('wheel data option has been chosen!!\n')
	%P = constrwheel(k,d);   % test with P from wheel data
	[centers, P] = constrwheel(k,d);
else
	P = [];
	if varyingn 
		nii=zeros(k,1); 
	else
		nii = n;
	end   % save nii values
	for ii = 1:k   % adding a random translation to each random set
		if varyingn
			nlhs = max(3,n-nnvary);
			nrhs = n+nnvary;
			nii(ii) = (nlhs-1) + randi(nrhs);
			P = [P ; ...
			   (sign(randn)*ii*randn(1,d))+randn(nii(ii),d)];
		else
			P = [P ; (sign(randn)*ii*randn(1,d))+randn(n,d)];
		end
	end
end
params.n = nii;
maxn = max(vecnorm(P'));   % changed from command norms
P = P/maxn;   % scale points to lie in unit ball
G = P*P';  % Gram matrix
Dbar = diag(G)*ones(length(G),1)' + ones(length(G),1)*diag(G)' - 2*G; 
%%%%%%%%%%%%%%%%%%%%

%Testing optimal theta
%fprintf('Dbar fro norm: %f\n', norm(theta_opt*Dbar,'fro'));
%fprintf('Dbar 2-norm: %f\n', norm(theta_opt*Dbar, 2));
%% we want norm(Dbar)_F = k+1
%theta = (k+1)/norm(Dbar,'fro');    % too small?????
%theta = ((k+1)/norm(Dbar,'fro'))+0.2055;  % as of july22/22 testing scaling???
%theta = (k*n+1)^2/norm(Dbar,'fro');  % for scaling Dbar
theta = 1;
Dbar =  theta * Dbar;   % scale to speed up cvgnce? study this???
fprintf('Generating new problem: norm Dbar = %g;  scaling theta = %f\n', norm(Dbar,'fro'),theta);

%disp(size(Dbar));
%Condition number of Dbar


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%testing eigs of Dbar?????????????
%%[~, DbarD] = eig(Dbar);
%%fprintf('before scaling:\n');
%%fprintf('DbarLambdaMin: %f\n', DbarD(1, 1)*theta); fprintf('DbarLambdaMax: %f\n', DbarD(end, end)*theta);
%%fprintf('DbarLambdaMax-Min: %f\n', theta*(DbarD(end, end)-DbarD(1, 1)));
%%fprintf('DbarD:\n'); disp(DbarD*theta);
%%fprintf('after scaling:\n');
%%fprintf('DbarLambdaMin: %f\n', DbarD(1, 1)); fprintf('DbarLambdaMax: %f\n', DbarD(end, end));
%%fprintf('DbarLambdaMax-Min: %f\n', DbarD(end, end)-DbarD(1, 1));
%%fprintf('DbarD:\n'); disp(DbarD);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%testing eigs of Dbar?????????????



%Weight matrix
Dbar0 = blkdiag(0,Dbar);   



if varyingn 
	%A = spalloc(k,sum(nii),sum(nii));
	A = [];
	for ii = 1:k
		A = blkdiag(A,ones(1,nii(ii)));
	end
	A = sparse(A);
else
	e = ones(n*k,1); %All-1 vector
	e0 = [1;zeros(n*k,1)]; %[1, zeros] vector
	E00 = e0*e0';
	%Unique element from each set constraint
	A = kron(speye(k),ones(1,n));
end


%Ganster index matrix:
row_zeros = zeros(size(A,1),1)';
Gtmp = [row_zeros;A']*[row_zeros;A']';
Gtmp(eye(length(Gtmp))==1) = 0;
Gtmp(1,1) = 1; 
Gtmp = (Gtmp==1);
%Facial reduction
Dbar0(Gtmp) = 0;  % diagonal blocks of Y are fixed; diag(Dbar) = 0
%norm of Dbar0 changes here!!! scaling should change here %!!!???theta????
%%???????????????????!!!!!!!!!!!!!!!!!!!!!!!!!!scale here?????????
K = [-ones(k,1)';A']';   %exposing matrix
KK = K'*K;
%Vhat = null(full(K)); % full column rank-n*k+1-k matrix  
%%use qr to find Vhat=null(K); this Vhat appears to be lower triangular!
[q,~] = qr(K'); % to find null(K)
Vhat = (q(:,size(K,1)+1:end)); % sparse version
Vhat(abs(Vhat)<1e-13)=0;
nr = size(Vhat,2);
fprintf('FR V using qr: [norm(KV)/nr norm(V''V-I)/nr = [%g %g]\n', ...
    norm(K*Vhat,'fro')/nr,norm(Vhat'*Vhat-speye(size(Vhat,2)),'fro')/nr)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end   % end of function gen...
