%%  Wasserstein with Gurobi
%Outline: a binary-constrained quadratic program(BCQP)
% Using Gurobi solver with cvx

clear;
addpath(genpath('..'))
seed = 134873;
rng(seed);
% rngsave = rng('shuffle');
% save('rngfile','rngsave')
%load('rngfile')  % to rerun saved problem in rngsave
%rng(rngsave);

%Profiler
runprofile = false;
if runprofile
	profile clear
	profile on
end

ns = [5 7 8];
% ks = 7:7;
ds = 2:2;
for n = ns
    k = n;
% for k = ks
for d = ds
plotpts = false;  % for plotting points and barycenter
usewheel = false;  % for using the wheel example k=n, d<=3
if usewheel
	n = k; % always set this for the wheel
	if d > 2   % embedding dim at most 3
		d = 2;   % for now
	end
end

testiis = 1;  % number of tests to run
for testii = testiis

	%Data  for Solver
	e = ones(n*k,1); %All-1 vector

	e0 = [1;zeros(n*k,1)]; %[1, zeros] vector
	E00 = e0*e0';
	% Unique element from each set constraint
	A = kron(speye(k),ones(1,n));

	%Construct EDM by data P
	if usewheel
		fprintf('wheel data option has been chosen!!\n')
		%P = constrwheel(k,d);   % test with P from wheel data
		[centers, P] = constrwheel(k,d);
	else
		P = [];
		for ii = 1:k   % adding a random translation to each random set
			P = [P ; (sign(randn)*ii*randn(1,d))+randn(n,d)];
		end
	end
	%maxn = max(norms(P'));
	%P = P/maxn;   % scale points to lie in unit ball
	G = P*P';  % Gram matrix
	Dbar = diag(G)*ones(length(G),1)' + ones(length(G),1)*diag(G)' - 2*G; 
	Dbarorig = Dbar;
	%%%%%%%%%%%%%%%%%%%%

	%Testing optimal theta
	%fprintf('Dbar fro norm: %f\n', norm(theta_opt*Dbar,'fro'));
	%fprintf('Dbar 2-norm: %f\n', norm(theta_opt*Dbar, 2));
	%% we want norm(Dbar)_F = k+1

	theta = (k*n+1)^2/norm(Dbar,'fro');  % for scaling Dbar

	Dbar =  theta * Dbar;   % scale to speed up cvgnce? study this???
	fprintf('Generating new problem: norm Dbar = %g;  scaling theta = %f\n', norm(Dbar,'fro'),theta);

    %%%%%% Gurobi Test
    Amat = zeros(k, n*k);          % reforming A from a tensor to a matrix
    Amat = full(A);
    tic
            cvx_clear
            cvx_begin quiet
            cvx_solver gurobi
            % cvx_solver mosek
                variable xgur(n*k,1) binary
                minimize (xgur' * (Dbar - 2*min(eig(Dbar))*eye(n*k)) * xgur)
                subject to
                    Amat * xgur == ones(k,1)
            cvx_end
    toc
    fprintf('times for gurobi %g with n = %i and k = %i \n',toc,n,k)
            
end    % for testii = 1:1000  % temp testing
%timesd(d) = toc;
end    % for d = ds dimension
% end    % for k = ks dimension
end    % for n = ns dimension
